import * as cdk from "../../core";
import * as cfn_parse from "../../core/lib/cfn-parse";
/**
 * Properties for defining a `AWS::CodeCommit::Repository`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codecommit-repository.html
 * @external
 */
export interface CfnRepositoryProps {
    /**
     * `AWS::CodeCommit::Repository.RepositoryName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codecommit-repository.html#cfn-codecommit-repository-repositoryname
     * @external
     */
    readonly repositoryName: string;
    /**
     * `AWS::CodeCommit::Repository.Code`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codecommit-repository.html#cfn-codecommit-repository-code
     * @external
     */
    readonly code?: CfnRepository.CodeProperty | cdk.IResolvable;
    /**
     * `AWS::CodeCommit::Repository.RepositoryDescription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codecommit-repository.html#cfn-codecommit-repository-repositorydescription
     * @external
     */
    readonly repositoryDescription?: string;
    /**
     * `AWS::CodeCommit::Repository.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codecommit-repository.html#cfn-codecommit-repository-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::CodeCommit::Repository.Triggers`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codecommit-repository.html#cfn-codecommit-repository-triggers
     * @external
     */
    readonly triggers?: Array<CfnRepository.RepositoryTriggerProperty | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::CodeCommit::Repository`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codecommit-repository.html
 * @external
 * @cloudformationResource AWS::CodeCommit::Repository
 */
export declare class CfnRepository extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::CodeCommit::Repository";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnRepository;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute CloneUrlHttp
     */
    readonly attrCloneUrlHttp: string;
    /**
     * @external
     * @cloudformationAttribute CloneUrlSsh
     */
    readonly attrCloneUrlSsh: string;
    /**
     * @external
     * @cloudformationAttribute Name
     */
    readonly attrName: string;
    /**
     * `AWS::CodeCommit::Repository.RepositoryName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codecommit-repository.html#cfn-codecommit-repository-repositoryname
     * @external
     */
    repositoryName: string;
    /**
     * `AWS::CodeCommit::Repository.Code`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codecommit-repository.html#cfn-codecommit-repository-code
     * @external
     */
    code: CfnRepository.CodeProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::CodeCommit::Repository.RepositoryDescription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codecommit-repository.html#cfn-codecommit-repository-repositorydescription
     * @external
     */
    repositoryDescription: string | undefined;
    /**
     * `AWS::CodeCommit::Repository.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codecommit-repository.html#cfn-codecommit-repository-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::CodeCommit::Repository.Triggers`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codecommit-repository.html#cfn-codecommit-repository-triggers
     * @external
     */
    triggers: Array<CfnRepository.RepositoryTriggerProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::CodeCommit::Repository`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnRepositoryProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::CodeCommit::Repository`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codecommit-repository.html
 * @external
 * @cloudformationResource AWS::CodeCommit::Repository
 */
export declare namespace CfnRepository {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codecommit-repository-code.html
     * @external
     */
    interface CodeProperty {
        /**
         * `CfnRepository.CodeProperty.BranchName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codecommit-repository-code.html#cfn-codecommit-repository-code-branchname
         * @external
         */
        readonly branchName?: string;
        /**
         * `CfnRepository.CodeProperty.S3`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codecommit-repository-code.html#cfn-codecommit-repository-code-s3
         * @external
         */
        readonly s3: CfnRepository.S3Property | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::CodeCommit::Repository`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codecommit-repository.html
 * @external
 * @cloudformationResource AWS::CodeCommit::Repository
 */
export declare namespace CfnRepository {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codecommit-repository-repositorytrigger.html
     * @external
     */
    interface RepositoryTriggerProperty {
        /**
         * `CfnRepository.RepositoryTriggerProperty.Branches`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codecommit-repository-repositorytrigger.html#cfn-codecommit-repository-repositorytrigger-branches
         * @external
         */
        readonly branches?: string[];
        /**
         * `CfnRepository.RepositoryTriggerProperty.CustomData`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codecommit-repository-repositorytrigger.html#cfn-codecommit-repository-repositorytrigger-customdata
         * @external
         */
        readonly customData?: string;
        /**
         * `CfnRepository.RepositoryTriggerProperty.DestinationArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codecommit-repository-repositorytrigger.html#cfn-codecommit-repository-repositorytrigger-destinationarn
         * @external
         */
        readonly destinationArn: string;
        /**
         * `CfnRepository.RepositoryTriggerProperty.Events`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codecommit-repository-repositorytrigger.html#cfn-codecommit-repository-repositorytrigger-events
         * @external
         */
        readonly events: string[];
        /**
         * `CfnRepository.RepositoryTriggerProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codecommit-repository-repositorytrigger.html#cfn-codecommit-repository-repositorytrigger-name
         * @external
         */
        readonly name: string;
    }
}
/**
 * A CloudFormation `AWS::CodeCommit::Repository`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codecommit-repository.html
 * @external
 * @cloudformationResource AWS::CodeCommit::Repository
 */
export declare namespace CfnRepository {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codecommit-repository-s3.html
     * @external
     */
    interface S3Property {
        /**
         * `CfnRepository.S3Property.Bucket`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codecommit-repository-s3.html#cfn-codecommit-repository-s3-bucket
         * @external
         */
        readonly bucket: string;
        /**
         * `CfnRepository.S3Property.Key`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codecommit-repository-s3.html#cfn-codecommit-repository-s3-key
         * @external
         */
        readonly key: string;
        /**
         * `CfnRepository.S3Property.ObjectVersion`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codecommit-repository-s3.html#cfn-codecommit-repository-s3-objectversion
         * @external
         */
        readonly objectVersion?: string;
    }
}
