"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BitBucketSourceCredentials = exports.GitHubEnterpriseSourceCredentials = exports.GitHubSourceCredentials = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const codebuild_generated_1 = require("./codebuild.generated");
/**
 * (experimental) The source credentials used when contacting the GitHub API.
 *
 * **Note**: CodeBuild only allows a single credential for GitHub
 * to be saved in a given AWS account in a given region -
 * any attempt to add more than one will result in an error.
 *
 * @experimental
 * @resource AWS::CodeBuild::SourceCredential
 */
class GitHubSourceCredentials extends core_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id);
        new codebuild_generated_1.CfnSourceCredential(this, 'Resource', {
            serverType: 'GITHUB',
            authType: 'PERSONAL_ACCESS_TOKEN',
            token: props.accessToken.toString(),
        });
    }
}
exports.GitHubSourceCredentials = GitHubSourceCredentials;
/**
 * (experimental) The source credentials used when contacting the GitHub Enterprise API.
 *
 * **Note**: CodeBuild only allows a single credential for GitHub Enterprise
 * to be saved in a given AWS account in a given region -
 * any attempt to add more than one will result in an error.
 *
 * @experimental
 * @resource AWS::CodeBuild::SourceCredential
 */
class GitHubEnterpriseSourceCredentials extends core_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id);
        new codebuild_generated_1.CfnSourceCredential(this, 'Resource', {
            serverType: 'GITHUB_ENTERPRISE',
            authType: 'PERSONAL_ACCESS_TOKEN',
            token: props.accessToken.toString(),
        });
    }
}
exports.GitHubEnterpriseSourceCredentials = GitHubEnterpriseSourceCredentials;
/**
 * (experimental) The source credentials used when contacting the BitBucket API.
 *
 * **Note**: CodeBuild only allows a single credential for BitBucket
 * to be saved in a given AWS account in a given region -
 * any attempt to add more than one will result in an error.
 *
 * @experimental
 * @resource AWS::CodeBuild::SourceCredential
 */
class BitBucketSourceCredentials extends core_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id);
        new codebuild_generated_1.CfnSourceCredential(this, 'Resource', {
            serverType: 'BITBUCKET',
            authType: 'BASIC_AUTH',
            username: props.username.toString(),
            token: props.password.toString(),
        });
    }
}
exports.BitBucketSourceCredentials = BitBucketSourceCredentials;
//# sourceMappingURL=data:application/json;base64,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