import * as cloudwatch from "../../aws-cloudwatch";
import * as ec2 from "../../aws-ec2";
import * as ecr from "../../aws-ecr";
import { DockerImageAssetProps } from "../../aws-ecr-assets";
import * as events from "../../aws-events";
import * as iam from "../../aws-iam";
import * as kms from "../../aws-kms";
import * as s3 from "../../aws-s3";
import * as secretsmanager from "../../aws-secretsmanager";
import { Duration, IResource, Resource } from "../../core";
import { Construct } from 'constructs';
import { IArtifacts } from './artifacts';
import { BuildSpec } from './build-spec';
import { Cache } from './cache';
import { CfnProject } from './codebuild.generated';
import { IFileSystemLocation } from './file-location';
import { ISource } from './source';
import { Construct as CoreConstruct } from "../../core";
/**
 * @experimental
 */
export interface IProject extends IResource, iam.IGrantable, ec2.IConnectable {
    /**
     * (experimental) The ARN of this Project.
     *
     * @experimental
     * @attribute true
     */
    readonly projectArn: string;
    /**
     * (experimental) The human-visible name of this Project.
     *
     * @experimental
     * @attribute true
     */
    readonly projectName: string;
    /**
     * (experimental) The IAM service Role of this Project.
     *
     * Undefined for imported Projects.
     *
     * @experimental
     */
    readonly role?: iam.IRole;
    /**
     * @experimental
     */
    addToRolePolicy(policyStatement: iam.PolicyStatement): void;
    /**
     * (experimental) Defines a CloudWatch event rule triggered when something happens with this project.
     *
     * @see https://docs.aws.amazon.com/codebuild/latest/userguide/sample-build-notifications.html
     * @experimental
     */
    onEvent(id: string, options?: events.OnEventOptions): events.Rule;
    /**
     * (experimental) Defines a CloudWatch event rule triggered when the build project state changes.
     *
     * You can filter specific build status events using an event
     * pattern filter on the `build-status` detail field:
     *
     *     const rule = project.onStateChange('OnBuildStarted', { target });
     *     rule.addEventPattern({
     *       detail: {
     *         'build-status': [
     *           "IN_PROGRESS",
     *           "SUCCEEDED",
     *           "FAILED",
     *           "STOPPED"
     *         ]
     *       }
     *     });
     *
     * You can also use the methods `onBuildFailed` and `onBuildSucceeded` to define rules for
     * these specific state changes.
     *
     * To access fields from the event in the event target input,
     * use the static fields on the `StateChangeEvent` class.
     *
     * @see https://docs.aws.amazon.com/codebuild/latest/userguide/sample-build-notifications.html
     * @experimental
     */
    onStateChange(id: string, options?: events.OnEventOptions): events.Rule;
    /**
     * (experimental) Defines a CloudWatch event rule that triggers upon phase change of this build project.
     *
     * @see https://docs.aws.amazon.com/codebuild/latest/userguide/sample-build-notifications.html
     * @experimental
     */
    onPhaseChange(id: string, options?: events.OnEventOptions): events.Rule;
    /**
     * (experimental) Defines an event rule which triggers when a build starts.
     *
     * @experimental
     */
    onBuildStarted(id: string, options?: events.OnEventOptions): events.Rule;
    /**
     * (experimental) Defines an event rule which triggers when a build fails.
     *
     * @experimental
     */
    onBuildFailed(id: string, options?: events.OnEventOptions): events.Rule;
    /**
     * (experimental) Defines an event rule which triggers when a build completes successfully.
     *
     * @experimental
     */
    onBuildSucceeded(id: string, options?: events.OnEventOptions): events.Rule;
    /**
     * @param metricName The name of the metric.
     * @param props Customization properties.
     * @returns a CloudWatch metric associated with this build project.
     * @experimental
     */
    metric(metricName: string, props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Measures the number of builds triggered.
     *
     * Units: Count
     *
     * Valid CloudWatch statistics: Sum
     *
     * @default sum over 5 minutes
     * @experimental
     */
    metricBuilds(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Measures the duration of all builds over time.
     *
     * Units: Seconds
     *
     * Valid CloudWatch statistics: Average (recommended), Maximum, Minimum
     *
     * @default average over 5 minutes
     * @experimental
     */
    metricDuration(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Measures the number of successful builds.
     *
     * Units: Count
     *
     * Valid CloudWatch statistics: Sum
     *
     * @default sum over 5 minutes
     * @experimental
     */
    metricSucceededBuilds(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Measures the number of builds that failed because of client error or because of a timeout.
     *
     * Units: Count
     *
     * Valid CloudWatch statistics: Sum
     *
     * @default sum over 5 minutes
     * @experimental
     */
    metricFailedBuilds(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
}
/**
 * Represents a reference to a CodeBuild Project.
 *
 * If you're managing the Project alongside the rest of your CDK resources,
 * use the {@link Project} class.
 *
 * If you want to reference an already existing Project
 * (or one defined in a different CDK Stack),
 * use the {@link import} method.
 */
declare abstract class ProjectBase extends Resource implements IProject {
    abstract readonly grantPrincipal: iam.IPrincipal;
    /** The ARN of this Project. */
    abstract readonly projectArn: string;
    /** The human-visible name of this Project. */
    abstract readonly projectName: string;
    /** The IAM service Role of this Project. */
    abstract readonly role?: iam.IRole;
    /**
     * Actual connections object for this Project.
     * May be unset, in which case this Project is not configured to use a VPC.
     * @internal
     */
    protected _connections: ec2.Connections | undefined;
    /**
     * (experimental) Access the Connections object.
     *
     * Will fail if this Project does not have a VPC set.
     *
     * @experimental
     */
    get connections(): ec2.Connections;
    /**
     * (experimental) Add a permission only if there's a policy attached.
     *
     * @param statement The permissions statement to add.
     * @experimental
     */
    addToRolePolicy(statement: iam.PolicyStatement): void;
    /**
     * (experimental) Defines a CloudWatch event rule triggered when something happens with this project.
     *
     * @see https://docs.aws.amazon.com/codebuild/latest/userguide/sample-build-notifications.html
     * @experimental
     */
    onEvent(id: string, options?: events.OnEventOptions): events.Rule;
    /**
     * (experimental) Defines a CloudWatch event rule triggered when the build project state changes.
     *
     * You can filter specific build status events using an event
     * pattern filter on the `build-status` detail field:
     *
     *     const rule = project.onStateChange('OnBuildStarted', { target });
     *     rule.addEventPattern({
     *       detail: {
     *         'build-status': [
     *           "IN_PROGRESS",
     *           "SUCCEEDED",
     *           "FAILED",
     *           "STOPPED"
     *         ]
     *       }
     *     });
     *
     * You can also use the methods `onBuildFailed` and `onBuildSucceeded` to define rules for
     * these specific state changes.
     *
     * To access fields from the event in the event target input,
     * use the static fields on the `StateChangeEvent` class.
     *
     * @see https://docs.aws.amazon.com/codebuild/latest/userguide/sample-build-notifications.html
     * @experimental
     */
    onStateChange(id: string, options?: events.OnEventOptions): events.Rule;
    /**
     * (experimental) Defines a CloudWatch event rule that triggers upon phase change of this build project.
     *
     * @see https://docs.aws.amazon.com/codebuild/latest/userguide/sample-build-notifications.html
     * @experimental
     */
    onPhaseChange(id: string, options?: events.OnEventOptions): events.Rule;
    /**
     * (experimental) Defines an event rule which triggers when a build starts.
     *
     * To access fields from the event in the event target input,
     * use the static fields on the `StateChangeEvent` class.
     *
     * @experimental
     */
    onBuildStarted(id: string, options?: events.OnEventOptions): events.Rule;
    /**
     * (experimental) Defines an event rule which triggers when a build fails.
     *
     * To access fields from the event in the event target input,
     * use the static fields on the `StateChangeEvent` class.
     *
     * @experimental
     */
    onBuildFailed(id: string, options?: events.OnEventOptions): events.Rule;
    /**
     * (experimental) Defines an event rule which triggers when a build completes successfully.
     *
     * To access fields from the event in the event target input,
     * use the static fields on the `StateChangeEvent` class.
     *
     * @experimental
     */
    onBuildSucceeded(id: string, options?: events.OnEventOptions): events.Rule;
    /**
     * @param metricName The name of the metric.
     * @param props Customization properties.
     * @returns a CloudWatch metric associated with this build project.
     * @experimental
     */
    metric(metricName: string, props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Measures the number of builds triggered.
     *
     * Units: Count
     *
     * Valid CloudWatch statistics: Sum
     *
     * @default sum over 5 minutes
     * @experimental
     */
    metricBuilds(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Measures the duration of all builds over time.
     *
     * Units: Seconds
     *
     * Valid CloudWatch statistics: Average (recommended), Maximum, Minimum
     *
     * @default average over 5 minutes
     * @experimental
     */
    metricDuration(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Measures the number of successful builds.
     *
     * Units: Count
     *
     * Valid CloudWatch statistics: Sum
     *
     * @default sum over 5 minutes
     * @experimental
     */
    metricSucceededBuilds(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Measures the number of builds that failed because of client error or because of a timeout.
     *
     * Units: Count
     *
     * Valid CloudWatch statistics: Sum
     *
     * @default sum over 5 minutes
     * @experimental
     */
    metricFailedBuilds(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
}
/**
 * @experimental
 */
export interface CommonProjectProps {
    /**
     * (experimental) A description of the project.
     *
     * Use the description to identify the purpose
     * of the project.
     *
     * @default - No description.
     * @experimental
     */
    readonly description?: string;
    /**
     * (experimental) Filename or contents of buildspec in JSON format.
     *
     * @default - Empty buildspec.
     * @see https://docs.aws.amazon.com/codebuild/latest/userguide/build-spec-ref.html#build-spec-ref-example
     * @experimental
     */
    readonly buildSpec?: BuildSpec;
    /**
     * (experimental) Service Role to assume while running the build.
     *
     * @default - A role will be created.
     * @experimental
     */
    readonly role?: iam.IRole;
    /**
     * (experimental) Encryption key to use to read and write artifacts.
     *
     * @default - The AWS-managed CMK for Amazon Simple Storage Service (Amazon S3) is used.
     * @experimental
     */
    readonly encryptionKey?: kms.IKey;
    /**
     * (experimental) Caching strategy to use.
     *
     * @default Cache.none
     * @experimental
     */
    readonly cache?: Cache;
    /**
     * (experimental) Build environment to use for the build.
     *
     * @default BuildEnvironment.LinuxBuildImage.STANDARD_1_0
     * @experimental
     */
    readonly environment?: BuildEnvironment;
    /**
     * (experimental) Indicates whether AWS CodeBuild generates a publicly accessible URL for your project's build badge.
     *
     * For more information, see Build Badges Sample
     * in the AWS CodeBuild User Guide.
     *
     * @default false
     * @experimental
     */
    readonly badge?: boolean;
    /**
     * (experimental) The number of minutes after which AWS CodeBuild stops the build if it's not complete.
     *
     * For valid values, see the timeoutInMinutes field in the AWS
     * CodeBuild User Guide.
     *
     * @default Duration.hours(1)
     * @experimental
     */
    readonly timeout?: Duration;
    /**
     * (experimental) Additional environment variables to add to the build environment.
     *
     * @default - No additional environment variables are specified.
     * @experimental
     */
    readonly environmentVariables?: {
        [name: string]: BuildEnvironmentVariable;
    };
    /**
     * (experimental) The physical, human-readable name of the CodeBuild Project.
     *
     * @default - Name is automatically generated.
     * @experimental
     */
    readonly projectName?: string;
    /**
     * (experimental) VPC network to place codebuild network interfaces.
     *
     * Specify this if the codebuild project needs to access resources in a VPC.
     *
     * @default - No VPC is specified.
     * @experimental
     */
    readonly vpc?: ec2.IVpc;
    /**
     * (experimental) Where to place the network interfaces within the VPC.
     *
     * Only used if 'vpc' is supplied.
     *
     * @default - All private subnets.
     * @experimental
     */
    readonly subnetSelection?: ec2.SubnetSelection;
    /**
     * (experimental) What security group to associate with the codebuild project's network interfaces.
     *
     * If no security group is identified, one will be created automatically.
     *
     * Only used if 'vpc' is supplied.
     *
     * @default - Security group will be automatically created.
     * @experimental
     */
    readonly securityGroups?: ec2.ISecurityGroup[];
    /**
     * (experimental) Whether to allow the CodeBuild to send all network traffic.
     *
     * If set to false, you must individually add traffic rules to allow the
     * CodeBuild project to connect to network targets.
     *
     * Only used if 'vpc' is supplied.
     *
     * @default true
     * @experimental
     */
    readonly allowAllOutbound?: boolean;
    /**
     * (experimental) An  ProjectFileSystemLocation objects for a CodeBuild build project.
     *
     * A ProjectFileSystemLocation object specifies the identifier, location, mountOptions, mountPoint,
     * and type of a file system created using Amazon Elastic File System.
     *
     * @default - no file system locations
     * @experimental
     */
    readonly fileSystemLocations?: IFileSystemLocation[];
    /**
     * (experimental) Add permissions to this project's role to create and use test report groups with name starting with the name of this project.
     *
     * That is the standard report group that gets created when a simple name
     * (in contrast to an ARN)
     * is used in the 'reports' section of the buildspec of this project.
     * This is usually harmless, but you can turn these off if you don't plan on using test
     * reports in this project.
     *
     * @default true
     * @see https://docs.aws.amazon.com/codebuild/latest/userguide/test-report-group-naming.html
     * @experimental
     */
    readonly grantReportGroupPermissions?: boolean;
}
/**
 * @experimental
 */
export interface ProjectProps extends CommonProjectProps {
    /**
     * (experimental) The source of the build.
     *
     * *Note*: if {@link NoSource} is given as the source,
     * then you need to provide an explicit `buildSpec`.
     *
     * @default - NoSource
     * @experimental
     */
    readonly source?: ISource;
    /**
     * (experimental) Defines where build artifacts will be stored.
     *
     * Could be: PipelineBuildArtifacts, NoArtifacts and S3Artifacts.
     *
     * @default NoArtifacts
     * @experimental
     */
    readonly artifacts?: IArtifacts;
    /**
     * (experimental) The secondary sources for the Project.
     *
     * Can be also added after the Project has been created by using the {@link Project#addSecondarySource} method.
     *
     * @default - No secondary sources.
     * @see https://docs.aws.amazon.com/codebuild/latest/userguide/sample-multi-in-out.html
     * @experimental
     */
    readonly secondarySources?: ISource[];
    /**
     * (experimental) The secondary artifacts for the Project.
     *
     * Can also be added after the Project has been created by using the {@link Project#addSecondaryArtifact} method.
     *
     * @default - No secondary artifacts.
     * @see https://docs.aws.amazon.com/codebuild/latest/userguide/sample-multi-in-out.html
     * @experimental
     */
    readonly secondaryArtifacts?: IArtifacts[];
}
/**
 * (experimental) The extra options passed to the {@link IProject.bindToCodePipeline} method.
 *
 * @experimental
 */
export interface BindToCodePipelineOptions {
    /**
     * (experimental) The artifact bucket that will be used by the action that invokes this project.
     *
     * @experimental
     */
    readonly artifactBucket: s3.IBucket;
}
/**
 * (experimental) A representation of a CodeBuild Project.
 *
 * @experimental
 */
export declare class Project extends ProjectBase {
    /**
     * @experimental
     */
    static fromProjectArn(scope: Construct, id: string, projectArn: string): IProject;
    /**
     * (experimental) Import a Project defined either outside the CDK, or in a different CDK Stack (and exported using the {@link export} method).
     *
     * @param scope the parent Construct for this Construct.
     * @param id the logical name of this Construct.
     * @param projectName the name of the project to import.
     * @returns a reference to the existing Project
     * @experimental
     * @note if you're importing a CodeBuild Project for use
     * in a CodePipeline, make sure the existing Project
     * has permissions to access the S3 Bucket of that Pipeline -
     * otherwise, builds in that Pipeline will always fail.
     */
    static fromProjectName(scope: Construct, id: string, projectName: string): IProject;
    /**
     * (experimental) Convert the environment variables map of string to {@link BuildEnvironmentVariable}, which is the customer-facing type, to a list of {@link CfnProject.EnvironmentVariableProperty}, which is the representation of environment variables in CloudFormation.
     *
     * @param environmentVariables the map of string to environment variables.
     * @returns an array of {@link CfnProject.EnvironmentVariableProperty} instances
     * @experimental
     */
    static serializeEnvVariables(environmentVariables: {
        [name: string]: BuildEnvironmentVariable;
    }): CfnProject.EnvironmentVariableProperty[];
    /**
     * (experimental) The principal to grant permissions to.
     *
     * @experimental
     */
    readonly grantPrincipal: iam.IPrincipal;
    /**
     * (experimental) The IAM role for this project.
     *
     * @experimental
     */
    readonly role?: iam.IRole;
    /**
     * (experimental) The ARN of the project.
     *
     * @experimental
     */
    readonly projectArn: string;
    /**
     * (experimental) The name of the project.
     *
     * @experimental
     */
    readonly projectName: string;
    private readonly source;
    private readonly buildImage;
    private readonly _secondarySources;
    private readonly _secondarySourceVersions;
    private readonly _secondaryArtifacts;
    private _encryptionKey?;
    private readonly _fileSystemLocations;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: ProjectProps);
    /**
     * (experimental) Adds a secondary source to the Project.
     *
     * @param secondarySource the source to add as a secondary source.
     * @see https://docs.aws.amazon.com/codebuild/latest/userguide/sample-multi-in-out.html
     * @experimental
     */
    addSecondarySource(secondarySource: ISource): void;
    /**
     * (experimental) Adds a fileSystemLocation to the Project.
     *
     * @param fileSystemLocation the fileSystemLocation to add.
     * @experimental
     */
    addFileSystemLocation(fileSystemLocation: IFileSystemLocation): void;
    /**
     * (experimental) Adds a secondary artifact to the Project.
     *
     * @param secondaryArtifact the artifact to add as a secondary artifact.
     * @see https://docs.aws.amazon.com/codebuild/latest/userguide/sample-multi-in-out.html
     * @experimental
     */
    addSecondaryArtifact(secondaryArtifact: IArtifacts): void;
    /**
     * (experimental) A callback invoked when the given project is added to a CodePipeline.
     *
     * @param _scope the construct the binding is taking place in.
     * @param options additional options for the binding.
     * @experimental
     */
    bindToCodePipeline(_scope: CoreConstruct, options: BindToCodePipelineOptions): void;
    /**
     * (experimental) Validate the current construct.
     *
     * This method can be implemented by derived constructs in order to perform
     * validation logic. It is called on all constructs before synthesis.
     *
     * @experimental
     * @override true
     */
    protected validate(): string[];
    private set encryptionKey(value);
    private createLoggingPermission;
    private renderEnvironment;
    private renderFileSystemLocations;
    private renderSecondarySources;
    private renderSecondarySourceVersions;
    private renderSecondaryArtifacts;
    /**
     * If configured, set up the VPC-related properties
     *
     * Returns the VpcConfig that should be added to the
     * codebuild creation properties.
     */
    private configureVpc;
    private addVpcRequiredPermissions;
    private validateCodePipelineSettings;
}
/**
 * (experimental) Build machine compute type.
 *
 * @experimental
 */
export declare enum ComputeType {
    /**
     * @experimental
     */
    SMALL = "BUILD_GENERAL1_SMALL",
    /**
     * @experimental
     */
    MEDIUM = "BUILD_GENERAL1_MEDIUM",
    /**
     * @experimental
     */
    LARGE = "BUILD_GENERAL1_LARGE",
    /**
     * @experimental
     */
    X2_LARGE = "BUILD_GENERAL1_2XLARGE"
}
/**
 * (experimental) The type of principal CodeBuild will use to pull your build Docker image.
 *
 * @experimental
 */
export declare enum ImagePullPrincipalType {
    /**
     * (experimental) CODEBUILD specifies that CodeBuild uses its own identity when pulling the image.
     *
     * This means the resource policy of the ECR repository that hosts the image will be modified to trust
     * CodeBuild's service principal.
     * This is the required principal type when using CodeBuild's pre-defined images.
     *
     * @experimental
     */
    CODEBUILD = "CODEBUILD",
    /**
     * (experimental) SERVICE_ROLE specifies that AWS CodeBuild uses the project's role when pulling the image.
     *
     * The role will be granted pull permissions on the ECR repository hosting the image.
     *
     * @experimental
     */
    SERVICE_ROLE = "SERVICE_ROLE"
}
/**
 * @experimental
 */
export interface BuildEnvironment {
    /**
     * (experimental) The image used for the builds.
     *
     * @default LinuxBuildImage.STANDARD_1_0
     * @experimental
     */
    readonly buildImage?: IBuildImage;
    /**
     * (experimental) The type of compute to use for this build.
     *
     * See the {@link ComputeType} enum for the possible values.
     *
     * @default taken from {@link #buildImage#defaultComputeType}
     * @experimental
     */
    readonly computeType?: ComputeType;
    /**
     * (experimental) Indicates how the project builds Docker images.
     *
     * Specify true to enable
     * running the Docker daemon inside a Docker container. This value must be
     * set to true only if this build project will be used to build Docker
     * images, and the specified build environment image is not one provided by
     * AWS CodeBuild with Docker support. Otherwise, all associated builds that
     * attempt to interact with the Docker daemon will fail.
     *
     * @default false
     * @experimental
     */
    readonly privileged?: boolean;
    /**
     * (experimental) The environment variables that your builds can use.
     *
     * @experimental
     */
    readonly environmentVariables?: {
        [name: string]: BuildEnvironmentVariable;
    };
}
/**
 * (experimental) Represents a Docker image used for the CodeBuild Project builds.
 *
 * Use the concrete subclasses, either:
 * {@link LinuxBuildImage} or {@link WindowsBuildImage}.
 *
 * @experimental
 */
export interface IBuildImage {
    /**
     * (experimental) The type of build environment.
     *
     * @experimental
     */
    readonly type: string;
    /**
     * (experimental) The Docker image identifier that the build environment uses.
     *
     * @see https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-available.html
     * @experimental
     */
    readonly imageId: string;
    /**
     * (experimental) The default {@link ComputeType} to use with this image, if one was not specified in {@link BuildEnvironment#computeType} explicitly.
     *
     * @experimental
     */
    readonly defaultComputeType: ComputeType;
    /**
     * (experimental) The type of principal that CodeBuild will use to pull this build Docker image.
     *
     * @default ImagePullPrincipalType.SERVICE_ROLE
     * @experimental
     */
    readonly imagePullPrincipalType?: ImagePullPrincipalType;
    /**
     * (experimental) The secretsManagerCredentials for access to a private registry.
     *
     * @default no credentials will be used
     * @experimental
     */
    readonly secretsManagerCredentials?: secretsmanager.ISecret;
    /**
     * (experimental) An optional ECR repository that the image is hosted in.
     *
     * @default no repository
     * @experimental
     */
    readonly repository?: ecr.IRepository;
    /**
     * (experimental) Allows the image a chance to validate whether the passed configuration is correct.
     *
     * @param buildEnvironment the current build environment.
     * @experimental
     */
    validate(buildEnvironment: BuildEnvironment): string[];
    /**
     * (experimental) Make a buildspec to run the indicated script.
     *
     * @experimental
     */
    runScriptBuildspec(entrypoint: string): BuildSpec;
}
/**
 * (experimental) Optional arguments to {@link IBuildImage.binder} - currently empty.
 *
 * @experimental
 */
export interface BuildImageBindOptions {
}
/**
 * (experimental) The return type from {@link IBuildImage.binder} - currently empty.
 *
 * @experimental
 */
export interface BuildImageConfig {
}
/**
 * (experimental) A variant of {@link IBuildImage} that allows binding to the project.
 *
 * @experimental
 */
export interface IBindableBuildImage extends IBuildImage {
    /**
     * (experimental) Function that allows the build image access to the construct tree.
     *
     * @experimental
     */
    bind(scope: CoreConstruct, project: IProject, options: BuildImageBindOptions): BuildImageConfig;
}
/**
 * (experimental) The options when creating a CodeBuild Docker build image using {@link LinuxBuildImage.fromDockerRegistry} or {@link WindowsBuildImage.fromDockerRegistry}.
 *
 * @experimental
 */
export interface DockerImageOptions {
    /**
     * (experimental) The credentials, stored in Secrets Manager, used for accessing the repository holding the image, if the repository is private.
     *
     * @default no credentials will be used (we assume the repository is public)
     * @experimental
     */
    readonly secretsManagerCredentials?: secretsmanager.ISecret;
}
/**
 * (experimental) A CodeBuild image running Linux.
 *
 * This class has a bunch of public constants that represent the most popular images.
 *
 * You can also specify a custom image using one of the static methods:
 *
 * - LinuxBuildImage.fromDockerRegistry(image[, { secretsManagerCredentials }])
 * - LinuxBuildImage.fromEcrRepository(repo[, tag])
 * - LinuxBuildImage.fromAsset(parent, id, props)
 *
 * @see https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-available.html
 * @experimental
 */
export declare class LinuxBuildImage implements IBuildImage {
    /**
     * @experimental
     */
    static readonly STANDARD_1_0: IBuildImage;
    /**
     * @experimental
     */
    static readonly STANDARD_2_0: IBuildImage;
    /**
     * @experimental
     */
    static readonly STANDARD_3_0: IBuildImage;
    /**
     * (experimental) The `aws/codebuild/standard:4.0` build image.
     *
     * @experimental
     */
    static readonly STANDARD_4_0: IBuildImage;
    /**
     * @experimental
     */
    static readonly AMAZON_LINUX_2: IBuildImage;
    /**
     * @experimental
     */
    static readonly AMAZON_LINUX_2_2: IBuildImage;
    /**
     * (experimental) The Amazon Linux 2 x86_64 standard image, version `3.0`.
     *
     * @experimental
     */
    static readonly AMAZON_LINUX_2_3: IBuildImage;
    /**
     * @experimental
     */
    static readonly AMAZON_LINUX_2_ARM: IBuildImage;
    /**
     * @deprecated Use {@link STANDARD_2_0} and specify runtime in buildspec runtime-versions section
     */
    static readonly UBUNTU_14_04_BASE: IBuildImage;
    /**
     * @deprecated Use {@link STANDARD_2_0} and specify runtime in buildspec runtime-versions section
     */
    static readonly UBUNTU_14_04_ANDROID_JAVA8_24_4_1: IBuildImage;
    /**
     * @deprecated Use {@link STANDARD_2_0} and specify runtime in buildspec runtime-versions section
     */
    static readonly UBUNTU_14_04_ANDROID_JAVA8_26_1_1: IBuildImage;
    /**
     * @deprecated Use {@link STANDARD_2_0} and specify runtime in buildspec runtime-versions section
     */
    static readonly UBUNTU_14_04_DOCKER_17_09_0: IBuildImage;
    /**
     * @deprecated Use {@link STANDARD_2_0} and specify runtime in buildspec runtime-versions section
     */
    static readonly UBUNTU_14_04_DOCKER_18_09_0: IBuildImage;
    /**
     * @deprecated Use {@link STANDARD_2_0} and specify runtime in buildspec runtime-versions section
     */
    static readonly UBUNTU_14_04_GOLANG_1_10: IBuildImage;
    /**
     * @deprecated Use {@link STANDARD_2_0} and specify runtime in buildspec runtime-versions section
     */
    static readonly UBUNTU_14_04_GOLANG_1_11: IBuildImage;
    /**
     * @deprecated Use {@link STANDARD_2_0} and specify runtime in buildspec runtime-versions section
     */
    static readonly UBUNTU_14_04_OPEN_JDK_8: IBuildImage;
    /**
     * @deprecated Use {@link STANDARD_2_0} and specify runtime in buildspec runtime-versions section
     */
    static readonly UBUNTU_14_04_OPEN_JDK_9: IBuildImage;
    /**
     * @deprecated Use {@link STANDARD_2_0} and specify runtime in buildspec runtime-versions section
     */
    static readonly UBUNTU_14_04_OPEN_JDK_11: IBuildImage;
    /**
     * @deprecated Use {@link STANDARD_2_0} and specify runtime in buildspec runtime-versions section
     */
    static readonly UBUNTU_14_04_NODEJS_10_14_1: IBuildImage;
    /**
     * @deprecated Use {@link STANDARD_2_0} and specify runtime in buildspec runtime-versions section
     */
    static readonly UBUNTU_14_04_NODEJS_10_1_0: IBuildImage;
    /**
     * @deprecated Use {@link STANDARD_2_0} and specify runtime in buildspec runtime-versions section
     */
    static readonly UBUNTU_14_04_NODEJS_8_11_0: IBuildImage;
    /**
     * @deprecated Use {@link STANDARD_2_0} and specify runtime in buildspec runtime-versions section
     */
    static readonly UBUNTU_14_04_NODEJS_6_3_1: IBuildImage;
    /**
     * @deprecated Use {@link STANDARD_2_0} and specify runtime in buildspec runtime-versions section
     */
    static readonly UBUNTU_14_04_PHP_5_6: IBuildImage;
    /**
     * @deprecated Use {@link STANDARD_2_0} and specify runtime in buildspec runtime-versions section
     */
    static readonly UBUNTU_14_04_PHP_7_0: IBuildImage;
    /**
     * @deprecated Use {@link STANDARD_2_0} and specify runtime in buildspec runtime-versions section
     */
    static readonly UBUNTU_14_04_PHP_7_1: IBuildImage;
    /**
     * @deprecated Use {@link STANDARD_2_0} and specify runtime in buildspec runtime-versions section
     */
    static readonly UBUNTU_14_04_PYTHON_3_7_1: IBuildImage;
    /**
     * @deprecated Use {@link STANDARD_2_0} and specify runtime in buildspec runtime-versions section
     */
    static readonly UBUNTU_14_04_PYTHON_3_6_5: IBuildImage;
    /**
     * @deprecated Use {@link STANDARD_2_0} and specify runtime in buildspec runtime-versions section
     */
    static readonly UBUNTU_14_04_PYTHON_3_5_2: IBuildImage;
    /**
     * @deprecated Use {@link STANDARD_2_0} and specify runtime in buildspec runtime-versions section
     */
    static readonly UBUNTU_14_04_PYTHON_3_4_5: IBuildImage;
    /**
     * @deprecated Use {@link STANDARD_2_0} and specify runtime in buildspec runtime-versions section
     */
    static readonly UBUNTU_14_04_PYTHON_3_3_6: IBuildImage;
    /**
     * @deprecated Use {@link STANDARD_2_0} and specify runtime in buildspec runtime-versions section
     */
    static readonly UBUNTU_14_04_PYTHON_2_7_12: IBuildImage;
    /**
     * @deprecated Use {@link STANDARD_2_0} and specify runtime in buildspec runtime-versions section
     */
    static readonly UBUNTU_14_04_RUBY_2_5_3: IBuildImage;
    /**
     * @deprecated Use {@link STANDARD_2_0} and specify runtime in buildspec runtime-versions section
     */
    static readonly UBUNTU_14_04_RUBY_2_5_1: IBuildImage;
    /**
     * @deprecated Use {@link STANDARD_2_0} and specify runtime in buildspec runtime-versions section
     */
    static readonly UBUNTU_14_04_RUBY_2_3_1: IBuildImage;
    /**
     * @deprecated Use {@link STANDARD_2_0} and specify runtime in buildspec runtime-versions section
     */
    static readonly UBUNTU_14_04_RUBY_2_2_5: IBuildImage;
    /**
     * @deprecated Use {@link STANDARD_2_0} and specify runtime in buildspec runtime-versions section
     */
    static readonly UBUNTU_14_04_DOTNET_CORE_1_1: IBuildImage;
    /**
     * @deprecated Use {@link STANDARD_2_0} and specify runtime in buildspec runtime-versions section
     */
    static readonly UBUNTU_14_04_DOTNET_CORE_2_0: IBuildImage;
    /**
     * @deprecated Use {@link STANDARD_2_0} and specify runtime in buildspec runtime-versions section
     */
    static readonly UBUNTU_14_04_DOTNET_CORE_2_1: IBuildImage;
    /**
     * @returns a Linux build image from a Docker Hub image.
     * @experimental
     */
    static fromDockerRegistry(name: string, options?: DockerImageOptions): IBuildImage;
    /**
     * @param repository The ECR repository.
     * @param tag Image tag (default "latest").
     * @returns A Linux build image from an ECR repository.
     *
     * NOTE: if the repository is external (i.e. imported), then we won't be able to add
     * a resource policy statement for it so CodeBuild can pull the image.
     * @see https://docs.aws.amazon.com/codebuild/latest/userguide/sample-ecr.html
     * @experimental
     */
    static fromEcrRepository(repository: ecr.IRepository, tag?: string): IBuildImage;
    /**
     * (experimental) Uses an Docker image asset as a Linux build image.
     *
     * @experimental
     */
    static fromAsset(scope: Construct, id: string, props: DockerImageAssetProps): IBuildImage;
    /**
     * (experimental) Uses a Docker image provided by CodeBuild.
     *
     * @param id The image identifier.
     * @returns A Docker image provided by CodeBuild.
     * @see https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-available.html
     * @experimental
     * @example
     *
     * 'aws/codebuild/standard:4.0'
     */
    static fromCodeBuildImageId(id: string): IBuildImage;
    private static codeBuildImage;
    /**
     * (experimental) The type of build environment.
     *
     * @experimental
     */
    readonly type = "LINUX_CONTAINER";
    /**
     * (experimental) The default {@link ComputeType} to use with this image, if one was not specified in {@link BuildEnvironment#computeType} explicitly.
     *
     * @experimental
     */
    readonly defaultComputeType = ComputeType.SMALL;
    /**
     * (experimental) The Docker image identifier that the build environment uses.
     *
     * @experimental
     */
    readonly imageId: string;
    /**
     * (experimental) The type of principal that CodeBuild will use to pull this build Docker image.
     *
     * @experimental
     */
    readonly imagePullPrincipalType?: ImagePullPrincipalType;
    /**
     * (experimental) The secretsManagerCredentials for access to a private registry.
     *
     * @experimental
     */
    readonly secretsManagerCredentials?: secretsmanager.ISecret;
    /**
     * (experimental) An optional ECR repository that the image is hosted in.
     *
     * @experimental
     */
    readonly repository?: ecr.IRepository;
    private constructor();
    /**
     * (experimental) Allows the image a chance to validate whether the passed configuration is correct.
     *
     * @experimental
     */
    validate(_: BuildEnvironment): string[];
    /**
     * (experimental) Make a buildspec to run the indicated script.
     *
     * @experimental
     */
    runScriptBuildspec(entrypoint: string): BuildSpec;
}
/**
 * (experimental) Environment type for Windows Docker images.
 *
 * @experimental
 */
export declare enum WindowsImageType {
    /**
     * (experimental) The standard environment type, WINDOWS_CONTAINER.
     *
     * @experimental
     */
    STANDARD = "WINDOWS_CONTAINER",
    /**
     * (experimental) The WINDOWS_SERVER_2019_CONTAINER environment type.
     *
     * @experimental
     */
    SERVER_2019 = "WINDOWS_SERVER_2019_CONTAINER"
}
/**
 * (experimental) A CodeBuild image running Windows.
 *
 * This class has a bunch of public constants that represent the most popular images.
 *
 * You can also specify a custom image using one of the static methods:
 *
 * - WindowsBuildImage.fromDockerRegistry(image[, { secretsManagerCredentials }, imageType])
 * - WindowsBuildImage.fromEcrRepository(repo[, tag, imageType])
 * - WindowsBuildImage.fromAsset(parent, id, props, [, imageType])
 *
 * @see https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-available.html
 * @experimental
 */
export declare class WindowsBuildImage implements IBuildImage {
    /**
     * (deprecated) Corresponds to the standard CodeBuild image `aws/codebuild/windows-base:1.0`.
     *
     * @deprecated `WindowsBuildImage.WINDOWS_BASE_2_0` should be used instead.
     */
    static readonly WIN_SERVER_CORE_2016_BASE: IBuildImage;
    /**
     * (experimental) The standard CodeBuild image `aws/codebuild/windows-base:2.0`, which is based off Windows Server Core 2016.
     *
     * @experimental
     */
    static readonly WINDOWS_BASE_2_0: IBuildImage;
    /**
     * (experimental) The standard CodeBuild image `aws/codebuild/windows-base:2019-1.0`, which is based off Windows Server Core 2019.
     *
     * @experimental
     */
    static readonly WIN_SERVER_CORE_2019_BASE: IBuildImage;
    /**
     * @returns a Windows build image from a Docker Hub image.
     * @experimental
     */
    static fromDockerRegistry(name: string, options?: DockerImageOptions, imageType?: WindowsImageType): IBuildImage;
    /**
     * @param repository The ECR repository.
     * @param tag Image tag (default "latest").
     * @returns A Linux build image from an ECR repository.
     *
     * NOTE: if the repository is external (i.e. imported), then we won't be able to add
     * a resource policy statement for it so CodeBuild can pull the image.
     * @see https://docs.aws.amazon.com/codebuild/latest/userguide/sample-ecr.html
     * @experimental
     */
    static fromEcrRepository(repository: ecr.IRepository, tag?: string, imageType?: WindowsImageType): IBuildImage;
    /**
     * (experimental) Uses an Docker image asset as a Windows build image.
     *
     * @experimental
     */
    static fromAsset(scope: Construct, id: string, props: DockerImageAssetProps, imageType?: WindowsImageType): IBuildImage;
    /**
     * (experimental) The type of build environment.
     *
     * @experimental
     */
    readonly type: string;
    /**
     * (experimental) The default {@link ComputeType} to use with this image, if one was not specified in {@link BuildEnvironment#computeType} explicitly.
     *
     * @experimental
     */
    readonly defaultComputeType = ComputeType.MEDIUM;
    /**
     * (experimental) The Docker image identifier that the build environment uses.
     *
     * @experimental
     */
    readonly imageId: string;
    /**
     * (experimental) The type of principal that CodeBuild will use to pull this build Docker image.
     *
     * @experimental
     */
    readonly imagePullPrincipalType?: ImagePullPrincipalType;
    /**
     * (experimental) The secretsManagerCredentials for access to a private registry.
     *
     * @experimental
     */
    readonly secretsManagerCredentials?: secretsmanager.ISecret;
    /**
     * (experimental) An optional ECR repository that the image is hosted in.
     *
     * @experimental
     */
    readonly repository?: ecr.IRepository;
    private constructor();
    /**
     * (experimental) Allows the image a chance to validate whether the passed configuration is correct.
     *
     * @experimental
     */
    validate(buildEnvironment: BuildEnvironment): string[];
    /**
     * (experimental) Make a buildspec to run the indicated script.
     *
     * @experimental
     */
    runScriptBuildspec(entrypoint: string): BuildSpec;
}
/**
 * @experimental
 */
export interface BuildEnvironmentVariable {
    /**
     * (experimental) The type of environment variable.
     *
     * @default PlainText
     * @experimental
     */
    readonly type?: BuildEnvironmentVariableType;
    /**
     * (experimental) The value of the environment variable (or the name of the parameter in the SSM parameter store.).
     *
     * @experimental
     */
    readonly value: any;
}
/**
 * @experimental
 */
export declare enum BuildEnvironmentVariableType {
    /**
     * (experimental) An environment variable in plaintext format.
     *
     * @experimental
     */
    PLAINTEXT = "PLAINTEXT",
    /**
     * (experimental) An environment variable stored in Systems Manager Parameter Store.
     *
     * @experimental
     */
    PARAMETER_STORE = "PARAMETER_STORE",
    /**
     * (experimental) An environment variable stored in AWS Secrets Manager.
     *
     * @experimental
     */
    SECRETS_MANAGER = "SECRETS_MANAGER"
}
export {};
