"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.runScriptLinuxBuildSpec = exports.S3_KEY_ENV = exports.S3_BUCKET_ENV = void 0;
const build_spec_1 = require("../build-spec");
exports.S3_BUCKET_ENV = 'SCRIPT_S3_BUCKET';
exports.S3_KEY_ENV = 'SCRIPT_S3_KEY';
function runScriptLinuxBuildSpec(entrypoint) {
    return build_spec_1.BuildSpec.fromObject({
        version: '0.2',
        phases: {
            pre_build: {
                commands: [
                    // Better echo the location here; if this fails, the error message only contains
                    // the unexpanded variables by default. It might fail if you're running an old
                    // definition of the CodeBuild project--the permissions will have been changed
                    // to only allow downloading the very latest version.
                    `echo "Downloading scripts from s3://\${${exports.S3_BUCKET_ENV}}/\${${exports.S3_KEY_ENV}}"`,
                    `aws s3 cp s3://\${${exports.S3_BUCKET_ENV}}/\${${exports.S3_KEY_ENV}} /tmp`,
                    'mkdir -p /tmp/scriptdir',
                    `unzip /tmp/$(basename \$${exports.S3_KEY_ENV}) -d /tmp/scriptdir`,
                ],
            },
            build: {
                commands: [
                    'export SCRIPT_DIR=/tmp/scriptdir',
                    `echo "Running ${entrypoint}"`,
                    `chmod +x /tmp/scriptdir/${entrypoint}`,
                    `/tmp/scriptdir/${entrypoint}`,
                ],
            },
        },
    });
}
exports.runScriptLinuxBuildSpec = runScriptLinuxBuildSpec;
//# sourceMappingURL=data:application/json;base64,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