import { CfnProject } from './codebuild.generated';
import { IProject } from './project';
import { Construct as CoreConstruct } from "../../core";
/**
 * (experimental) The type returned from {@link IFileSystemLocation#bind}.
 *
 * @experimental
 */
export interface FileSystemConfig {
    /**
     * (experimental) File system location wrapper property.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projectfilesystemlocation.html
     * @experimental
     */
    readonly location: CfnProject.ProjectFileSystemLocationProperty;
}
/**
 * (experimental) The interface of a CodeBuild FileSystemLocation.
 *
 * Implemented by {@link EfsFileSystemLocation}.
 *
 * @experimental
 */
export interface IFileSystemLocation {
    /**
     * (experimental) Called by the project when a file system is added so it can perform binding operations on this file system location.
     *
     * @experimental
     */
    bind(scope: CoreConstruct, project: IProject): FileSystemConfig;
}
/**
 * (experimental) FileSystemLocation provider definition for a CodeBuild Project.
 *
 * @experimental
 */
export declare class FileSystemLocation {
    /**
     * (experimental) EFS file system provider.
     *
     * @param props the EFS File System location property.
     * @experimental
     */
    static efs(props: EfsFileSystemLocationProps): IFileSystemLocation;
}
/**
 * (experimental) Construction properties for {@link EfsFileSystemLocation}.
 *
 * @experimental
 */
export interface EfsFileSystemLocationProps {
    /**
     * (experimental) The name used to access a file system created by Amazon EFS.
     *
     * @experimental
     */
    readonly identifier: string;
    /**
     * (experimental) A string that specifies the location of the file system, like Amazon EFS.
     *
     * @experimental
     * @example
     *
     * 'fs-abcd1234.efs.us-west-2.amazonaws.com:/my-efs-mount-directory'.
     */
    readonly location: string;
    /**
     * (experimental) The mount options for a file system such as Amazon EFS.
     *
     * @default 'nfsvers=4.1,rsize=1048576,wsize=1048576,hard,timeo=600,retrans=2'.
     * @experimental
     */
    readonly mountOptions?: string;
    /**
     * (experimental) The location in the container where you mount the file system.
     *
     * @experimental
     */
    readonly mountPoint: string;
}
