"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PhaseChangeEvent = exports.StateChangeEvent = void 0;
const events = require("../../aws-events"); // Automatically re-written from '@aws-cdk/aws-events'
/**
 * (experimental) Event fields for the CodeBuild "state change" event.
 *
 * @see https://docs.aws.amazon.com/codebuild/latest/userguide/sample-build-notifications.html#sample-build-notifications-ref
 * @experimental
 */
class StateChangeEvent {
    /**
     * (experimental) The triggering build's status.
     *
     * @experimental
     */
    static get buildStatus() {
        return events.EventField.fromPath('$.detail.build-status');
    }
    /**
     * (experimental) The triggering build's project name.
     *
     * @experimental
     */
    static get projectName() {
        return events.EventField.fromPath('$.detail.project-name');
    }
    /**
     * (experimental) Return the build id.
     *
     * @experimental
     */
    static get buildId() {
        return events.EventField.fromPath('$.detail.build-id');
    }
    /**
     * @experimental
     */
    static get currentPhase() {
        return events.EventField.fromPath('$.detail.current-phase');
    }
    constructor() {
    }
}
exports.StateChangeEvent = StateChangeEvent;
/**
 * (experimental) Event fields for the CodeBuild "phase change" event.
 *
 * @see https://docs.aws.amazon.com/codebuild/latest/userguide/sample-build-notifications.html#sample-build-notifications-ref
 * @experimental
 */
class PhaseChangeEvent {
    /**
     * (experimental) The triggering build's project name.
     *
     * @experimental
     */
    static get projectName() {
        return events.EventField.fromPath('$.detail.project-name');
    }
    /**
     * (experimental) The triggering build's id.
     *
     * @experimental
     */
    static get buildId() {
        return events.EventField.fromPath('$.detail.build-id');
    }
    /**
     * (experimental) The phase that was just completed.
     *
     * @experimental
     */
    static get completedPhase() {
        return events.EventField.fromPath('$.detail.completed-phase');
    }
    /**
     * (experimental) The status of the completed phase.
     *
     * @experimental
     */
    static get completedPhaseStatus() {
        return events.EventField.fromPath('$.detail.completed-phase-status');
    }
    /**
     * (experimental) The duration of the completed phase.
     *
     * @experimental
     */
    static get completedPhaseDurationSeconds() {
        return events.EventField.fromPath('$.detail.completed-phase-duration-seconds');
    }
    /**
     * (experimental) Whether the build is complete.
     *
     * @experimental
     */
    static get buildComplete() {
        return events.EventField.fromPath('$.detail.build-complete');
    }
    constructor() {
    }
}
exports.PhaseChangeEvent = PhaseChangeEvent;
//# sourceMappingURL=data:application/json;base64,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