/**
 * (experimental) Event fields for the CodeBuild "state change" event.
 *
 * @see https://docs.aws.amazon.com/codebuild/latest/userguide/sample-build-notifications.html#sample-build-notifications-ref
 * @experimental
 */
export declare class StateChangeEvent {
    /**
     * (experimental) The triggering build's status.
     *
     * @experimental
     */
    static get buildStatus(): string;
    /**
     * (experimental) The triggering build's project name.
     *
     * @experimental
     */
    static get projectName(): string;
    /**
     * (experimental) Return the build id.
     *
     * @experimental
     */
    static get buildId(): string;
    /**
     * @experimental
     */
    static get currentPhase(): string;
    private constructor();
}
/**
 * (experimental) Event fields for the CodeBuild "phase change" event.
 *
 * @see https://docs.aws.amazon.com/codebuild/latest/userguide/sample-build-notifications.html#sample-build-notifications-ref
 * @experimental
 */
export declare class PhaseChangeEvent {
    /**
     * (experimental) The triggering build's project name.
     *
     * @experimental
     */
    static get projectName(): string;
    /**
     * (experimental) The triggering build's id.
     *
     * @experimental
     */
    static get buildId(): string;
    /**
     * (experimental) The phase that was just completed.
     *
     * @experimental
     */
    static get completedPhase(): string;
    /**
     * (experimental) The status of the completed phase.
     *
     * @experimental
     */
    static get completedPhaseStatus(): string;
    /**
     * (experimental) The duration of the completed phase.
     *
     * @experimental
     */
    static get completedPhaseDurationSeconds(): string;
    /**
     * (experimental) Whether the build is complete.
     *
     * @experimental
     */
    static get buildComplete(): string;
    private constructor();
}
