import * as cdk from "../../core";
import * as cfn_parse from "../../core/lib/cfn-parse";
/**
 * Properties for defining a `AWS::CodeBuild::Project`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html
 * @external
 */
export interface CfnProjectProps {
    /**
     * `AWS::CodeBuild::Project.Artifacts`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-artifacts
     * @external
     */
    readonly artifacts: CfnProject.ArtifactsProperty | cdk.IResolvable;
    /**
     * `AWS::CodeBuild::Project.Environment`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-environment
     * @external
     */
    readonly environment: CfnProject.EnvironmentProperty | cdk.IResolvable;
    /**
     * `AWS::CodeBuild::Project.ServiceRole`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-servicerole
     * @external
     */
    readonly serviceRole: string;
    /**
     * `AWS::CodeBuild::Project.Source`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-source
     * @external
     */
    readonly source: CfnProject.SourceProperty | cdk.IResolvable;
    /**
     * `AWS::CodeBuild::Project.BadgeEnabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-badgeenabled
     * @external
     */
    readonly badgeEnabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::CodeBuild::Project.BuildBatchConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-buildbatchconfig
     * @external
     */
    readonly buildBatchConfig?: CfnProject.ProjectBuildBatchConfigProperty | cdk.IResolvable;
    /**
     * `AWS::CodeBuild::Project.Cache`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-cache
     * @external
     */
    readonly cache?: CfnProject.ProjectCacheProperty | cdk.IResolvable;
    /**
     * `AWS::CodeBuild::Project.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::CodeBuild::Project.EncryptionKey`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-encryptionkey
     * @external
     */
    readonly encryptionKey?: string;
    /**
     * `AWS::CodeBuild::Project.FileSystemLocations`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-filesystemlocations
     * @external
     */
    readonly fileSystemLocations?: Array<CfnProject.ProjectFileSystemLocationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::CodeBuild::Project.LogsConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-logsconfig
     * @external
     */
    readonly logsConfig?: CfnProject.LogsConfigProperty | cdk.IResolvable;
    /**
     * `AWS::CodeBuild::Project.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-name
     * @external
     */
    readonly name?: string;
    /**
     * `AWS::CodeBuild::Project.QueuedTimeoutInMinutes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-queuedtimeoutinminutes
     * @external
     */
    readonly queuedTimeoutInMinutes?: number;
    /**
     * `AWS::CodeBuild::Project.SecondaryArtifacts`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-secondaryartifacts
     * @external
     */
    readonly secondaryArtifacts?: Array<CfnProject.ArtifactsProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::CodeBuild::Project.SecondarySources`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-secondarysources
     * @external
     */
    readonly secondarySources?: Array<CfnProject.SourceProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::CodeBuild::Project.SecondarySourceVersions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-secondarysourceversions
     * @external
     */
    readonly secondarySourceVersions?: Array<CfnProject.ProjectSourceVersionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::CodeBuild::Project.SourceVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-sourceversion
     * @external
     */
    readonly sourceVersion?: string;
    /**
     * `AWS::CodeBuild::Project.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::CodeBuild::Project.TimeoutInMinutes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-timeoutinminutes
     * @external
     */
    readonly timeoutInMinutes?: number;
    /**
     * `AWS::CodeBuild::Project.Triggers`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-triggers
     * @external
     */
    readonly triggers?: CfnProject.ProjectTriggersProperty | cdk.IResolvable;
    /**
     * `AWS::CodeBuild::Project.VpcConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-vpcconfig
     * @external
     */
    readonly vpcConfig?: CfnProject.VpcConfigProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::CodeBuild::Project`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html
 * @external
 * @cloudformationResource AWS::CodeBuild::Project
 */
export declare class CfnProject extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::CodeBuild::Project";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnProject;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * `AWS::CodeBuild::Project.Artifacts`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-artifacts
     * @external
     */
    artifacts: CfnProject.ArtifactsProperty | cdk.IResolvable;
    /**
     * `AWS::CodeBuild::Project.Environment`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-environment
     * @external
     */
    environment: CfnProject.EnvironmentProperty | cdk.IResolvable;
    /**
     * `AWS::CodeBuild::Project.ServiceRole`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-servicerole
     * @external
     */
    serviceRole: string;
    /**
     * `AWS::CodeBuild::Project.Source`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-source
     * @external
     */
    source: CfnProject.SourceProperty | cdk.IResolvable;
    /**
     * `AWS::CodeBuild::Project.BadgeEnabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-badgeenabled
     * @external
     */
    badgeEnabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::CodeBuild::Project.BuildBatchConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-buildbatchconfig
     * @external
     */
    buildBatchConfig: CfnProject.ProjectBuildBatchConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::CodeBuild::Project.Cache`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-cache
     * @external
     */
    cache: CfnProject.ProjectCacheProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::CodeBuild::Project.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::CodeBuild::Project.EncryptionKey`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-encryptionkey
     * @external
     */
    encryptionKey: string | undefined;
    /**
     * `AWS::CodeBuild::Project.FileSystemLocations`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-filesystemlocations
     * @external
     */
    fileSystemLocations: Array<CfnProject.ProjectFileSystemLocationProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::CodeBuild::Project.LogsConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-logsconfig
     * @external
     */
    logsConfig: CfnProject.LogsConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::CodeBuild::Project.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-name
     * @external
     */
    name: string | undefined;
    /**
     * `AWS::CodeBuild::Project.QueuedTimeoutInMinutes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-queuedtimeoutinminutes
     * @external
     */
    queuedTimeoutInMinutes: number | undefined;
    /**
     * `AWS::CodeBuild::Project.SecondaryArtifacts`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-secondaryartifacts
     * @external
     */
    secondaryArtifacts: Array<CfnProject.ArtifactsProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::CodeBuild::Project.SecondarySources`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-secondarysources
     * @external
     */
    secondarySources: Array<CfnProject.SourceProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::CodeBuild::Project.SecondarySourceVersions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-secondarysourceversions
     * @external
     */
    secondarySourceVersions: Array<CfnProject.ProjectSourceVersionProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::CodeBuild::Project.SourceVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-sourceversion
     * @external
     */
    sourceVersion: string | undefined;
    /**
     * `AWS::CodeBuild::Project.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::CodeBuild::Project.TimeoutInMinutes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-timeoutinminutes
     * @external
     */
    timeoutInMinutes: number | undefined;
    /**
     * `AWS::CodeBuild::Project.Triggers`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-triggers
     * @external
     */
    triggers: CfnProject.ProjectTriggersProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::CodeBuild::Project.VpcConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-vpcconfig
     * @external
     */
    vpcConfig: CfnProject.VpcConfigProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::CodeBuild::Project`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnProjectProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::CodeBuild::Project`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html
 * @external
 * @cloudformationResource AWS::CodeBuild::Project
 */
export declare namespace CfnProject {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html
     * @external
     */
    interface ArtifactsProperty {
        /**
         * `CfnProject.ArtifactsProperty.ArtifactIdentifier`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-artifactidentifier
         * @external
         */
        readonly artifactIdentifier?: string;
        /**
         * `CfnProject.ArtifactsProperty.EncryptionDisabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-encryptiondisabled
         * @external
         */
        readonly encryptionDisabled?: boolean | cdk.IResolvable;
        /**
         * `CfnProject.ArtifactsProperty.Location`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-location
         * @external
         */
        readonly location?: string;
        /**
         * `CfnProject.ArtifactsProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-name
         * @external
         */
        readonly name?: string;
        /**
         * `CfnProject.ArtifactsProperty.NamespaceType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-namespacetype
         * @external
         */
        readonly namespaceType?: string;
        /**
         * `CfnProject.ArtifactsProperty.OverrideArtifactName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-overrideartifactname
         * @external
         */
        readonly overrideArtifactName?: boolean | cdk.IResolvable;
        /**
         * `CfnProject.ArtifactsProperty.Packaging`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-packaging
         * @external
         */
        readonly packaging?: string;
        /**
         * `CfnProject.ArtifactsProperty.Path`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-path
         * @external
         */
        readonly path?: string;
        /**
         * `CfnProject.ArtifactsProperty.Type`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-type
         * @external
         */
        readonly type: string;
    }
}
/**
 * A CloudFormation `AWS::CodeBuild::Project`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html
 * @external
 * @cloudformationResource AWS::CodeBuild::Project
 */
export declare namespace CfnProject {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-batchrestrictions.html
     * @external
     */
    interface BatchRestrictionsProperty {
        /**
         * `CfnProject.BatchRestrictionsProperty.ComputeTypesAllowed`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-batchrestrictions.html#cfn-codebuild-project-batchrestrictions-computetypesallowed
         * @external
         */
        readonly computeTypesAllowed?: string[];
        /**
         * `CfnProject.BatchRestrictionsProperty.MaximumBuildsAllowed`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-batchrestrictions.html#cfn-codebuild-project-batchrestrictions-maximumbuildsallowed
         * @external
         */
        readonly maximumBuildsAllowed?: number;
    }
}
/**
 * A CloudFormation `AWS::CodeBuild::Project`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html
 * @external
 * @cloudformationResource AWS::CodeBuild::Project
 */
export declare namespace CfnProject {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-buildstatusconfig.html
     * @external
     */
    interface BuildStatusConfigProperty {
        /**
         * `CfnProject.BuildStatusConfigProperty.Context`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-buildstatusconfig.html#cfn-codebuild-project-buildstatusconfig-context
         * @external
         */
        readonly context?: string;
        /**
         * `CfnProject.BuildStatusConfigProperty.TargetUrl`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-buildstatusconfig.html#cfn-codebuild-project-buildstatusconfig-targeturl
         * @external
         */
        readonly targetUrl?: string;
    }
}
/**
 * A CloudFormation `AWS::CodeBuild::Project`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html
 * @external
 * @cloudformationResource AWS::CodeBuild::Project
 */
export declare namespace CfnProject {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-cloudwatchlogsconfig.html
     * @external
     */
    interface CloudWatchLogsConfigProperty {
        /**
         * `CfnProject.CloudWatchLogsConfigProperty.GroupName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-cloudwatchlogsconfig.html#cfn-codebuild-project-cloudwatchlogsconfig-groupname
         * @external
         */
        readonly groupName?: string;
        /**
         * `CfnProject.CloudWatchLogsConfigProperty.Status`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-cloudwatchlogsconfig.html#cfn-codebuild-project-cloudwatchlogsconfig-status
         * @external
         */
        readonly status: string;
        /**
         * `CfnProject.CloudWatchLogsConfigProperty.StreamName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-cloudwatchlogsconfig.html#cfn-codebuild-project-cloudwatchlogsconfig-streamname
         * @external
         */
        readonly streamName?: string;
    }
}
/**
 * A CloudFormation `AWS::CodeBuild::Project`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html
 * @external
 * @cloudformationResource AWS::CodeBuild::Project
 */
export declare namespace CfnProject {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html
     * @external
     */
    interface EnvironmentProperty {
        /**
         * `CfnProject.EnvironmentProperty.Certificate`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html#cfn-codebuild-project-environment-certificate
         * @external
         */
        readonly certificate?: string;
        /**
         * `CfnProject.EnvironmentProperty.ComputeType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html#cfn-codebuild-project-environment-computetype
         * @external
         */
        readonly computeType: string;
        /**
         * `CfnProject.EnvironmentProperty.EnvironmentVariables`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html#cfn-codebuild-project-environment-environmentvariables
         * @external
         */
        readonly environmentVariables?: Array<CfnProject.EnvironmentVariableProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnProject.EnvironmentProperty.Image`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html#cfn-codebuild-project-environment-image
         * @external
         */
        readonly image: string;
        /**
         * `CfnProject.EnvironmentProperty.ImagePullCredentialsType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html#cfn-codebuild-project-environment-imagepullcredentialstype
         * @external
         */
        readonly imagePullCredentialsType?: string;
        /**
         * `CfnProject.EnvironmentProperty.PrivilegedMode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html#cfn-codebuild-project-environment-privilegedmode
         * @external
         */
        readonly privilegedMode?: boolean | cdk.IResolvable;
        /**
         * `CfnProject.EnvironmentProperty.RegistryCredential`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html#cfn-codebuild-project-environment-registrycredential
         * @external
         */
        readonly registryCredential?: CfnProject.RegistryCredentialProperty | cdk.IResolvable;
        /**
         * `CfnProject.EnvironmentProperty.Type`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html#cfn-codebuild-project-environment-type
         * @external
         */
        readonly type: string;
    }
}
/**
 * A CloudFormation `AWS::CodeBuild::Project`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html
 * @external
 * @cloudformationResource AWS::CodeBuild::Project
 */
export declare namespace CfnProject {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environmentvariable.html
     * @external
     */
    interface EnvironmentVariableProperty {
        /**
         * `CfnProject.EnvironmentVariableProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environmentvariable.html#cfn-codebuild-project-environmentvariable-name
         * @external
         */
        readonly name: string;
        /**
         * `CfnProject.EnvironmentVariableProperty.Type`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environmentvariable.html#cfn-codebuild-project-environmentvariable-type
         * @external
         */
        readonly type?: string;
        /**
         * `CfnProject.EnvironmentVariableProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environmentvariable.html#cfn-codebuild-project-environmentvariable-value
         * @external
         */
        readonly value: string;
    }
}
/**
 * A CloudFormation `AWS::CodeBuild::Project`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html
 * @external
 * @cloudformationResource AWS::CodeBuild::Project
 */
export declare namespace CfnProject {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-gitsubmodulesconfig.html
     * @external
     */
    interface GitSubmodulesConfigProperty {
        /**
         * `CfnProject.GitSubmodulesConfigProperty.FetchSubmodules`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-gitsubmodulesconfig.html#cfn-codebuild-project-gitsubmodulesconfig-fetchsubmodules
         * @external
         */
        readonly fetchSubmodules: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::CodeBuild::Project`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html
 * @external
 * @cloudformationResource AWS::CodeBuild::Project
 */
export declare namespace CfnProject {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-logsconfig.html
     * @external
     */
    interface LogsConfigProperty {
        /**
         * `CfnProject.LogsConfigProperty.CloudWatchLogs`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-logsconfig.html#cfn-codebuild-project-logsconfig-cloudwatchlogs
         * @external
         */
        readonly cloudWatchLogs?: CfnProject.CloudWatchLogsConfigProperty | cdk.IResolvable;
        /**
         * `CfnProject.LogsConfigProperty.S3Logs`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-logsconfig.html#cfn-codebuild-project-logsconfig-s3logs
         * @external
         */
        readonly s3Logs?: CfnProject.S3LogsConfigProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::CodeBuild::Project`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html
 * @external
 * @cloudformationResource AWS::CodeBuild::Project
 */
export declare namespace CfnProject {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projectbuildbatchconfig.html
     * @external
     */
    interface ProjectBuildBatchConfigProperty {
        /**
         * `CfnProject.ProjectBuildBatchConfigProperty.CombineArtifacts`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projectbuildbatchconfig.html#cfn-codebuild-project-projectbuildbatchconfig-combineartifacts
         * @external
         */
        readonly combineArtifacts?: boolean | cdk.IResolvable;
        /**
         * `CfnProject.ProjectBuildBatchConfigProperty.Restrictions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projectbuildbatchconfig.html#cfn-codebuild-project-projectbuildbatchconfig-restrictions
         * @external
         */
        readonly restrictions?: CfnProject.BatchRestrictionsProperty | cdk.IResolvable;
        /**
         * `CfnProject.ProjectBuildBatchConfigProperty.ServiceRole`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projectbuildbatchconfig.html#cfn-codebuild-project-projectbuildbatchconfig-servicerole
         * @external
         */
        readonly serviceRole?: string;
        /**
         * `CfnProject.ProjectBuildBatchConfigProperty.TimeoutInMins`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projectbuildbatchconfig.html#cfn-codebuild-project-projectbuildbatchconfig-timeoutinmins
         * @external
         */
        readonly timeoutInMins?: number;
    }
}
/**
 * A CloudFormation `AWS::CodeBuild::Project`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html
 * @external
 * @cloudformationResource AWS::CodeBuild::Project
 */
export declare namespace CfnProject {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projectcache.html
     * @external
     */
    interface ProjectCacheProperty {
        /**
         * `CfnProject.ProjectCacheProperty.Location`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projectcache.html#cfn-codebuild-project-projectcache-location
         * @external
         */
        readonly location?: string;
        /**
         * `CfnProject.ProjectCacheProperty.Modes`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projectcache.html#cfn-codebuild-project-projectcache-modes
         * @external
         */
        readonly modes?: string[];
        /**
         * `CfnProject.ProjectCacheProperty.Type`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projectcache.html#cfn-codebuild-project-projectcache-type
         * @external
         */
        readonly type: string;
    }
}
/**
 * A CloudFormation `AWS::CodeBuild::Project`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html
 * @external
 * @cloudformationResource AWS::CodeBuild::Project
 */
export declare namespace CfnProject {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projectfilesystemlocation.html
     * @external
     */
    interface ProjectFileSystemLocationProperty {
        /**
         * `CfnProject.ProjectFileSystemLocationProperty.Identifier`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projectfilesystemlocation.html#cfn-codebuild-project-projectfilesystemlocation-identifier
         * @external
         */
        readonly identifier: string;
        /**
         * `CfnProject.ProjectFileSystemLocationProperty.Location`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projectfilesystemlocation.html#cfn-codebuild-project-projectfilesystemlocation-location
         * @external
         */
        readonly location: string;
        /**
         * `CfnProject.ProjectFileSystemLocationProperty.MountOptions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projectfilesystemlocation.html#cfn-codebuild-project-projectfilesystemlocation-mountoptions
         * @external
         */
        readonly mountOptions?: string;
        /**
         * `CfnProject.ProjectFileSystemLocationProperty.MountPoint`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projectfilesystemlocation.html#cfn-codebuild-project-projectfilesystemlocation-mountpoint
         * @external
         */
        readonly mountPoint: string;
        /**
         * `CfnProject.ProjectFileSystemLocationProperty.Type`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projectfilesystemlocation.html#cfn-codebuild-project-projectfilesystemlocation-type
         * @external
         */
        readonly type: string;
    }
}
/**
 * A CloudFormation `AWS::CodeBuild::Project`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html
 * @external
 * @cloudformationResource AWS::CodeBuild::Project
 */
export declare namespace CfnProject {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projectsourceversion.html
     * @external
     */
    interface ProjectSourceVersionProperty {
        /**
         * `CfnProject.ProjectSourceVersionProperty.SourceIdentifier`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projectsourceversion.html#cfn-codebuild-project-projectsourceversion-sourceidentifier
         * @external
         */
        readonly sourceIdentifier: string;
        /**
         * `CfnProject.ProjectSourceVersionProperty.SourceVersion`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projectsourceversion.html#cfn-codebuild-project-projectsourceversion-sourceversion
         * @external
         */
        readonly sourceVersion?: string;
    }
}
/**
 * A CloudFormation `AWS::CodeBuild::Project`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html
 * @external
 * @cloudformationResource AWS::CodeBuild::Project
 */
export declare namespace CfnProject {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projecttriggers.html
     * @external
     */
    interface ProjectTriggersProperty {
        /**
         * `CfnProject.ProjectTriggersProperty.BuildType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projecttriggers.html#cfn-codebuild-project-projecttriggers-buildtype
         * @external
         */
        readonly buildType?: string;
        /**
         * `CfnProject.ProjectTriggersProperty.FilterGroups`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projecttriggers.html#cfn-codebuild-project-projecttriggers-filtergroups
         * @external
         */
        readonly filterGroups?: Array<Array<CfnProject.WebhookFilterProperty | cdk.IResolvable> | cdk.IResolvable | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnProject.ProjectTriggersProperty.Webhook`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projecttriggers.html#cfn-codebuild-project-projecttriggers-webhook
         * @external
         */
        readonly webhook?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::CodeBuild::Project`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html
 * @external
 * @cloudformationResource AWS::CodeBuild::Project
 */
export declare namespace CfnProject {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-registrycredential.html
     * @external
     */
    interface RegistryCredentialProperty {
        /**
         * `CfnProject.RegistryCredentialProperty.Credential`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-registrycredential.html#cfn-codebuild-project-registrycredential-credential
         * @external
         */
        readonly credential: string;
        /**
         * `CfnProject.RegistryCredentialProperty.CredentialProvider`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-registrycredential.html#cfn-codebuild-project-registrycredential-credentialprovider
         * @external
         */
        readonly credentialProvider: string;
    }
}
/**
 * A CloudFormation `AWS::CodeBuild::Project`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html
 * @external
 * @cloudformationResource AWS::CodeBuild::Project
 */
export declare namespace CfnProject {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-s3logsconfig.html
     * @external
     */
    interface S3LogsConfigProperty {
        /**
         * `CfnProject.S3LogsConfigProperty.EncryptionDisabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-s3logsconfig.html#cfn-codebuild-project-s3logsconfig-encryptiondisabled
         * @external
         */
        readonly encryptionDisabled?: boolean | cdk.IResolvable;
        /**
         * `CfnProject.S3LogsConfigProperty.Location`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-s3logsconfig.html#cfn-codebuild-project-s3logsconfig-location
         * @external
         */
        readonly location?: string;
        /**
         * `CfnProject.S3LogsConfigProperty.Status`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-s3logsconfig.html#cfn-codebuild-project-s3logsconfig-status
         * @external
         */
        readonly status: string;
    }
}
/**
 * A CloudFormation `AWS::CodeBuild::Project`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html
 * @external
 * @cloudformationResource AWS::CodeBuild::Project
 */
export declare namespace CfnProject {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html
     * @external
     */
    interface SourceProperty {
        /**
         * `CfnProject.SourceProperty.Auth`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-auth
         * @external
         */
        readonly auth?: CfnProject.SourceAuthProperty | cdk.IResolvable;
        /**
         * `CfnProject.SourceProperty.BuildSpec`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-buildspec
         * @external
         */
        readonly buildSpec?: string;
        /**
         * `CfnProject.SourceProperty.BuildStatusConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-buildstatusconfig
         * @external
         */
        readonly buildStatusConfig?: CfnProject.BuildStatusConfigProperty | cdk.IResolvable;
        /**
         * `CfnProject.SourceProperty.GitCloneDepth`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-gitclonedepth
         * @external
         */
        readonly gitCloneDepth?: number;
        /**
         * `CfnProject.SourceProperty.GitSubmodulesConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-gitsubmodulesconfig
         * @external
         */
        readonly gitSubmodulesConfig?: CfnProject.GitSubmodulesConfigProperty | cdk.IResolvable;
        /**
         * `CfnProject.SourceProperty.InsecureSsl`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-insecuressl
         * @external
         */
        readonly insecureSsl?: boolean | cdk.IResolvable;
        /**
         * `CfnProject.SourceProperty.Location`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-location
         * @external
         */
        readonly location?: string;
        /**
         * `CfnProject.SourceProperty.ReportBuildStatus`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-reportbuildstatus
         * @external
         */
        readonly reportBuildStatus?: boolean | cdk.IResolvable;
        /**
         * `CfnProject.SourceProperty.SourceIdentifier`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-sourceidentifier
         * @external
         */
        readonly sourceIdentifier?: string;
        /**
         * `CfnProject.SourceProperty.Type`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-type
         * @external
         */
        readonly type: string;
    }
}
/**
 * A CloudFormation `AWS::CodeBuild::Project`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html
 * @external
 * @cloudformationResource AWS::CodeBuild::Project
 */
export declare namespace CfnProject {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-sourceauth.html
     * @external
     */
    interface SourceAuthProperty {
        /**
         * `CfnProject.SourceAuthProperty.Resource`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-sourceauth.html#cfn-codebuild-project-sourceauth-resource
         * @external
         */
        readonly resource?: string;
        /**
         * `CfnProject.SourceAuthProperty.Type`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-sourceauth.html#cfn-codebuild-project-sourceauth-type
         * @external
         */
        readonly type: string;
    }
}
/**
 * A CloudFormation `AWS::CodeBuild::Project`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html
 * @external
 * @cloudformationResource AWS::CodeBuild::Project
 */
export declare namespace CfnProject {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-vpcconfig.html
     * @external
     */
    interface VpcConfigProperty {
        /**
         * `CfnProject.VpcConfigProperty.SecurityGroupIds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-vpcconfig.html#cfn-codebuild-project-vpcconfig-securitygroupids
         * @external
         */
        readonly securityGroupIds?: string[];
        /**
         * `CfnProject.VpcConfigProperty.Subnets`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-vpcconfig.html#cfn-codebuild-project-vpcconfig-subnets
         * @external
         */
        readonly subnets?: string[];
        /**
         * `CfnProject.VpcConfigProperty.VpcId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-vpcconfig.html#cfn-codebuild-project-vpcconfig-vpcid
         * @external
         */
        readonly vpcId?: string;
    }
}
/**
 * A CloudFormation `AWS::CodeBuild::Project`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html
 * @external
 * @cloudformationResource AWS::CodeBuild::Project
 */
export declare namespace CfnProject {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-webhookfilter.html
     * @external
     */
    interface WebhookFilterProperty {
        /**
         * `CfnProject.WebhookFilterProperty.ExcludeMatchedPattern`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-webhookfilter.html#cfn-codebuild-project-webhookfilter-excludematchedpattern
         * @external
         */
        readonly excludeMatchedPattern?: boolean | cdk.IResolvable;
        /**
         * `CfnProject.WebhookFilterProperty.Pattern`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-webhookfilter.html#cfn-codebuild-project-webhookfilter-pattern
         * @external
         */
        readonly pattern: string;
        /**
         * `CfnProject.WebhookFilterProperty.Type`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-webhookfilter.html#cfn-codebuild-project-webhookfilter-type
         * @external
         */
        readonly type: string;
    }
}
/**
 * Properties for defining a `AWS::CodeBuild::ReportGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-reportgroup.html
 * @external
 */
export interface CfnReportGroupProps {
    /**
     * `AWS::CodeBuild::ReportGroup.ExportConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-reportgroup.html#cfn-codebuild-reportgroup-exportconfig
     * @external
     */
    readonly exportConfig: CfnReportGroup.ReportExportConfigProperty | cdk.IResolvable;
    /**
     * `AWS::CodeBuild::ReportGroup.Type`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-reportgroup.html#cfn-codebuild-reportgroup-type
     * @external
     */
    readonly type: string;
    /**
     * `AWS::CodeBuild::ReportGroup.DeleteReports`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-reportgroup.html#cfn-codebuild-reportgroup-deletereports
     * @external
     */
    readonly deleteReports?: boolean | cdk.IResolvable;
    /**
     * `AWS::CodeBuild::ReportGroup.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-reportgroup.html#cfn-codebuild-reportgroup-name
     * @external
     */
    readonly name?: string;
    /**
     * `AWS::CodeBuild::ReportGroup.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-reportgroup.html#cfn-codebuild-reportgroup-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::CodeBuild::ReportGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-reportgroup.html
 * @external
 * @cloudformationResource AWS::CodeBuild::ReportGroup
 */
export declare class CfnReportGroup extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::CodeBuild::ReportGroup";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnReportGroup;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * `AWS::CodeBuild::ReportGroup.ExportConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-reportgroup.html#cfn-codebuild-reportgroup-exportconfig
     * @external
     */
    exportConfig: CfnReportGroup.ReportExportConfigProperty | cdk.IResolvable;
    /**
     * `AWS::CodeBuild::ReportGroup.Type`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-reportgroup.html#cfn-codebuild-reportgroup-type
     * @external
     */
    type: string;
    /**
     * `AWS::CodeBuild::ReportGroup.DeleteReports`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-reportgroup.html#cfn-codebuild-reportgroup-deletereports
     * @external
     */
    deleteReports: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::CodeBuild::ReportGroup.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-reportgroup.html#cfn-codebuild-reportgroup-name
     * @external
     */
    name: string | undefined;
    /**
     * `AWS::CodeBuild::ReportGroup.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-reportgroup.html#cfn-codebuild-reportgroup-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::CodeBuild::ReportGroup`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnReportGroupProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::CodeBuild::ReportGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-reportgroup.html
 * @external
 * @cloudformationResource AWS::CodeBuild::ReportGroup
 */
export declare namespace CfnReportGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-reportgroup-reportexportconfig.html
     * @external
     */
    interface ReportExportConfigProperty {
        /**
         * `CfnReportGroup.ReportExportConfigProperty.ExportConfigType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-reportgroup-reportexportconfig.html#cfn-codebuild-reportgroup-reportexportconfig-exportconfigtype
         * @external
         */
        readonly exportConfigType: string;
        /**
         * `CfnReportGroup.ReportExportConfigProperty.S3Destination`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-reportgroup-reportexportconfig.html#cfn-codebuild-reportgroup-reportexportconfig-s3destination
         * @external
         */
        readonly s3Destination?: CfnReportGroup.S3ReportExportConfigProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::CodeBuild::ReportGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-reportgroup.html
 * @external
 * @cloudformationResource AWS::CodeBuild::ReportGroup
 */
export declare namespace CfnReportGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-reportgroup-s3reportexportconfig.html
     * @external
     */
    interface S3ReportExportConfigProperty {
        /**
         * `CfnReportGroup.S3ReportExportConfigProperty.Bucket`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-reportgroup-s3reportexportconfig.html#cfn-codebuild-reportgroup-s3reportexportconfig-bucket
         * @external
         */
        readonly bucket: string;
        /**
         * `CfnReportGroup.S3ReportExportConfigProperty.EncryptionDisabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-reportgroup-s3reportexportconfig.html#cfn-codebuild-reportgroup-s3reportexportconfig-encryptiondisabled
         * @external
         */
        readonly encryptionDisabled?: boolean | cdk.IResolvable;
        /**
         * `CfnReportGroup.S3ReportExportConfigProperty.EncryptionKey`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-reportgroup-s3reportexportconfig.html#cfn-codebuild-reportgroup-s3reportexportconfig-encryptionkey
         * @external
         */
        readonly encryptionKey?: string;
        /**
         * `CfnReportGroup.S3ReportExportConfigProperty.Packaging`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-reportgroup-s3reportexportconfig.html#cfn-codebuild-reportgroup-s3reportexportconfig-packaging
         * @external
         */
        readonly packaging?: string;
        /**
         * `CfnReportGroup.S3ReportExportConfigProperty.Path`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-reportgroup-s3reportexportconfig.html#cfn-codebuild-reportgroup-s3reportexportconfig-path
         * @external
         */
        readonly path?: string;
    }
}
/**
 * Properties for defining a `AWS::CodeBuild::SourceCredential`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-sourcecredential.html
 * @external
 */
export interface CfnSourceCredentialProps {
    /**
     * `AWS::CodeBuild::SourceCredential.AuthType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-sourcecredential.html#cfn-codebuild-sourcecredential-authtype
     * @external
     */
    readonly authType: string;
    /**
     * `AWS::CodeBuild::SourceCredential.ServerType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-sourcecredential.html#cfn-codebuild-sourcecredential-servertype
     * @external
     */
    readonly serverType: string;
    /**
     * `AWS::CodeBuild::SourceCredential.Token`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-sourcecredential.html#cfn-codebuild-sourcecredential-token
     * @external
     */
    readonly token: string;
    /**
     * `AWS::CodeBuild::SourceCredential.Username`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-sourcecredential.html#cfn-codebuild-sourcecredential-username
     * @external
     */
    readonly username?: string;
}
/**
 * A CloudFormation `AWS::CodeBuild::SourceCredential`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-sourcecredential.html
 * @external
 * @cloudformationResource AWS::CodeBuild::SourceCredential
 */
export declare class CfnSourceCredential extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::CodeBuild::SourceCredential";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnSourceCredential;
    /**
     * `AWS::CodeBuild::SourceCredential.AuthType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-sourcecredential.html#cfn-codebuild-sourcecredential-authtype
     * @external
     */
    authType: string;
    /**
     * `AWS::CodeBuild::SourceCredential.ServerType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-sourcecredential.html#cfn-codebuild-sourcecredential-servertype
     * @external
     */
    serverType: string;
    /**
     * `AWS::CodeBuild::SourceCredential.Token`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-sourcecredential.html#cfn-codebuild-sourcecredential-token
     * @external
     */
    token: string;
    /**
     * `AWS::CodeBuild::SourceCredential.Username`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-sourcecredential.html#cfn-codebuild-sourcecredential-username
     * @external
     */
    username: string | undefined;
    /**
     * Create a new `AWS::CodeBuild::SourceCredential`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnSourceCredentialProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
