"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Cache = exports.LocalCacheMode = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * (experimental) Local cache modes to enable for the CodeBuild Project.
 *
 * @experimental
 */
var LocalCacheMode;
(function (LocalCacheMode) {
    LocalCacheMode["SOURCE"] = "LOCAL_SOURCE_CACHE";
    LocalCacheMode["DOCKER_LAYER"] = "LOCAL_DOCKER_LAYER_CACHE";
    LocalCacheMode["CUSTOM"] = "LOCAL_CUSTOM_CACHE";
})(LocalCacheMode = exports.LocalCacheMode || (exports.LocalCacheMode = {}));
/**
 * (experimental) Cache options for CodeBuild Project.
 *
 * A cache can store reusable pieces of your build environment and use them across multiple builds.
 *
 * @see https://docs.aws.amazon.com/codebuild/latest/userguide/build-caching.html
 * @experimental
 */
class Cache {
    /**
     * @experimental
     */
    static none() {
        return { _toCloudFormation: () => undefined, _bind: () => { return; } };
    }
    /**
     * (experimental) Create a local caching strategy.
     *
     * @param modes the mode(s) to enable for local caching.
     * @experimental
     */
    static local(...modes) {
        return {
            _toCloudFormation: () => ({
                type: 'LOCAL',
                modes,
            }),
            _bind: () => { return; },
        };
    }
    /**
     * (experimental) Create an S3 caching strategy.
     *
     * @param bucket the S3 bucket to use for caching.
     * @param options additional options to pass to the S3 caching.
     * @experimental
     */
    static bucket(bucket, options) {
        return {
            _toCloudFormation: () => ({
                type: 'S3',
                location: core_1.Fn.join('/', [bucket.bucketName, options && options.prefix || core_1.Aws.NO_VALUE]),
            }),
            _bind: (project) => {
                bucket.grantReadWrite(project);
            },
        };
    }
}
exports.Cache = Cache;
//# sourceMappingURL=data:application/json;base64,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