"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mergeBuildSpecs = exports.BuildSpec = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * (experimental) BuildSpec for CodeBuild projects.
 *
 * @experimental
 */
class BuildSpec {
    /**
     * @experimental
     */
    constructor() {
    }
    /**
     * @experimental
     */
    static fromObject(value) {
        return new ObjectBuildSpec(value);
    }
    /**
     * (experimental) Use a file from the source as buildspec.
     *
     * Use this if you want to use a file different from 'buildspec.yml'`
     *
     * @experimental
     */
    static fromSourceFilename(filename) {
        return new FilenameBuildSpec(filename);
    }
}
exports.BuildSpec = BuildSpec;
/**
 * BuildSpec that just returns the input unchanged
 */
class FilenameBuildSpec extends BuildSpec {
    constructor(filename) {
        super();
        this.filename = filename;
        this.isImmediate = false;
    }
    toBuildSpec() {
        return this.filename;
    }
    toString() {
        return `<buildspec file: ${this.filename}>`;
    }
}
/**
 * BuildSpec that understands about structure
 */
class ObjectBuildSpec extends BuildSpec {
    constructor(spec) {
        super();
        this.spec = spec;
        this.isImmediate = true;
    }
    toBuildSpec() {
        // We have to pretty-print the buildspec, otherwise
        // CodeBuild will not recognize it as an inline buildspec.
        return core_1.Lazy.stringValue({
            produce: (ctx) => core_1.Stack.of(ctx.scope).toJsonString(this.spec, 2),
        });
    }
}
/**
 * Merge two buildspecs into a new BuildSpec
 *
 * NOTE: will currently only merge commands, not artifact
 * declarations, environment variables, secrets, or any
 * other configuration elements.
 *
 * Internal for now because it's not complete/good enough
 * to expose on the objects directly, but we need to it to
 * keep feature-parity for Project.
 *
 * @internal
 */
function mergeBuildSpecs(lhs, rhs) {
    if (!(lhs instanceof ObjectBuildSpec) || !(rhs instanceof ObjectBuildSpec)) {
        throw new Error('Can only merge buildspecs created using BuildSpec.fromObject()');
    }
    return new ObjectBuildSpec(copyCommands(lhs.spec, rhs.spec));
}
exports.mergeBuildSpecs = mergeBuildSpecs;
/**
 * Extend buildSpec phases with the contents of another one
 */
function copyCommands(buildSpec, extend) {
    if (buildSpec.version === '0.1') {
        throw new Error('Cannot extend buildspec at version "0.1". Set the version to "0.2" or higher instead.');
    }
    const ret = Object.assign({}, buildSpec); // Return a copy
    ret.phases = Object.assign({}, ret.phases);
    for (const phaseName of Object.keys(extend.phases)) {
        const phase = ret.phases[phaseName] = Object.assign({}, ret.phases[phaseName]);
        phase.commands = [...phase.commands || [], ...extend.phases[phaseName].commands];
    }
    return ret;
}
//# sourceMappingURL=data:application/json;base64,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