"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DropEmptyObjectAtTheEndOfAnArray = void 0;
const cdk = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
const object_1 = require("./object");
/**
 * A Token object that will drop the last element of an array if it is an empty object
 *
 * Necessary to prevent options objects that only contain "region" and "account" keys
 * that evaluate to "undefined" from showing up in the rendered JSON.
 */
class DropEmptyObjectAtTheEndOfAnArray {
    constructor(value) {
        this.value = value;
        this.creationStack = cdk.captureStackTrace();
    }
    resolve(context) {
        context.registerPostProcessor(this);
        return context.resolve(this.value);
    }
    postProcess(o, _context) {
        if (!Array.isArray(o)) {
            return o;
        }
        const lastEl = o[o.length - 1];
        if (typeof lastEl === 'object' && lastEl !== null && Object.keys(object_1.dropUndefined(lastEl)).length === 0) {
            return o.slice(0, o.length - 1);
        }
        return o;
    }
}
exports.DropEmptyObjectAtTheEndOfAnArray = DropEmptyObjectAtTheEndOfAnArray;
//# sourceMappingURL=data:application/json;base64,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