"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LogQueryWidget = exports.LogQueryVisualizationType = void 0;
const cdk = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const widget_1 = require("./widget");
/**
 * (experimental) Types of view.
 *
 * @experimental
 */
var LogQueryVisualizationType;
(function (LogQueryVisualizationType) {
    LogQueryVisualizationType["TABLE"] = "table";
    LogQueryVisualizationType["LINE"] = "line";
    LogQueryVisualizationType["STACKEDAREA"] = "stackedarea";
    LogQueryVisualizationType["BAR"] = "bar";
    LogQueryVisualizationType["PIE"] = "pie";
})(LogQueryVisualizationType = exports.LogQueryVisualizationType || (exports.LogQueryVisualizationType = {}));
/**
 * (experimental) Display query results from Logs Insights.
 *
 * @experimental
 */
class LogQueryWidget extends widget_1.ConcreteWidget {
    /**
     * @experimental
     */
    constructor(props) {
        super(props.width || 6, props.height || 6);
        this.props = props;
        if (props.logGroupNames.length === 0) {
            throw new Error('Specify at least one log group name.');
        }
        if (!!props.queryString === !!props.queryLines) {
            throw new Error('Specify exactly one of \'queryString\' and \'queryLines\'');
        }
    }
    /**
     * (experimental) Return the widget JSON for use in the dashboard.
     *
     * @experimental
     */
    toJson() {
        const sources = this.props.logGroupNames.map(l => `SOURCE '${l}'`).join(' | ');
        const query = this.props.queryLines
            ? this.props.queryLines.join('\n| ')
            : this.props.queryString;
        const properties = {
            view: this.props.view ? this.props.view : LogQueryVisualizationType.TABLE,
            title: this.props.title,
            region: this.props.region || cdk.Aws.REGION,
            query: `${sources} | ${query}`,
        };
        // adding stacked property in case of LINE or STACKEDAREA
        if (this.props.view === LogQueryVisualizationType.LINE || this.props.view === LogQueryVisualizationType.STACKEDAREA) {
            // assign the right native view value. both types share the same value
            properties.view = 'timeSeries',
                properties.stacked = this.props.view === LogQueryVisualizationType.STACKEDAREA ? true : false;
        }
        return [{
                type: 'log',
                width: this.width,
                height: this.height,
                x: this.x,
                y: this.y,
                properties: properties,
            }];
    }
}
exports.LogQueryWidget = LogQueryWidget;
//# sourceMappingURL=data:application/json;base64,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