import { ConcreteWidget } from './widget';
/**
 * (experimental) Types of view.
 *
 * @experimental
 */
export declare enum LogQueryVisualizationType {
    /**
     * (experimental) Table view.
     *
     * @experimental
     */
    TABLE = "table",
    /**
     * (experimental) Line view.
     *
     * @experimental
     */
    LINE = "line",
    /**
     * (experimental) Stacked area view.
     *
     * @experimental
     */
    STACKEDAREA = "stackedarea",
    /**
     * (experimental) Bar view.
     *
     * @experimental
     */
    BAR = "bar",
    /**
     * (experimental) Pie view.
     *
     * @experimental
     */
    PIE = "pie"
}
/**
 * (experimental) Properties for a Query widget.
 *
 * @experimental
 */
export interface LogQueryWidgetProps {
    /**
     * (experimental) Title for the widget.
     *
     * @default No title
     * @experimental
     */
    readonly title?: string;
    /**
     * (experimental) Names of log groups to query.
     *
     * @experimental
     */
    readonly logGroupNames: string[];
    /**
     * (experimental) Full query string for log insights.
     *
     * Be sure to prepend every new line with a newline and pipe character
     * (`\n|`).
     *
     * @default - Exactly one of `queryString`, `queryLines` is required.
     * @experimental
     */
    readonly queryString?: string;
    /**
     * (experimental) A sequence of lines to use to build the query.
     *
     * The query will be built by joining the lines together using `\n|`.
     *
     * @default - Exactly one of `queryString`, `queryLines` is required.
     * @experimental
     */
    readonly queryLines?: string[];
    /**
     * (experimental) The region the metrics of this widget should be taken from.
     *
     * @default Current region
     * @experimental
     */
    readonly region?: string;
    /**
     * (experimental) The type of view to use.
     *
     * @default LogQueryVisualizationType.TABLE
     * @experimental
     */
    readonly view?: LogQueryVisualizationType;
    /**
     * (experimental) Width of the widget, in a grid of 24 units wide.
     *
     * @default 6
     * @experimental
     */
    readonly width?: number;
    /**
     * (experimental) Height of the widget.
     *
     * @default 6
     * @experimental
     */
    readonly height?: number;
}
/**
 * (experimental) Display query results from Logs Insights.
 *
 * @experimental
 */
export declare class LogQueryWidget extends ConcreteWidget {
    private readonly props;
    /**
     * @experimental
     */
    constructor(props: LogQueryWidgetProps);
    /**
     * (experimental) Return the widget JSON for use in the dashboard.
     *
     * @experimental
     */
    toJson(): any[];
}
