import { Resource } from "../../core";
import { Construct } from 'constructs';
/**
 * (experimental) Represents a Origin Request Policy.
 *
 * @experimental
 */
export interface IOriginRequestPolicy {
    /**
     * (experimental) The ID of the origin request policy.
     *
     * @experimental
     * @attribute true
     */
    readonly originRequestPolicyId: string;
}
/**
 * (experimental) Properties for creating a Origin Request Policy.
 *
 * @experimental
 */
export interface OriginRequestPolicyProps {
    /**
     * (experimental) A unique name to identify the origin request policy.
     *
     * The name must only include '-', '_', or alphanumeric characters.
     *
     * @default - generated from the `id`
     * @experimental
     */
    readonly originRequestPolicyName?: string;
    /**
     * (experimental) A comment to describe the origin request policy.
     *
     * @default - no comment
     * @experimental
     */
    readonly comment?: string;
    /**
     * (experimental) The cookies from viewer requests to include in origin requests.
     *
     * @default OriginRequestCookieBehavior.none()
     * @experimental
     */
    readonly cookieBehavior?: OriginRequestCookieBehavior;
    /**
     * (experimental) The HTTP headers to include in origin requests.
     *
     * These can include headers from viewer requests and additional headers added by CloudFront.
     *
     * @default OriginRequestHeaderBehavior.none()
     * @experimental
     */
    readonly headerBehavior?: OriginRequestHeaderBehavior;
    /**
     * (experimental) The URL query strings from viewer requests to include in origin requests.
     *
     * @default OriginRequestQueryStringBehavior.none()
     * @experimental
     */
    readonly queryStringBehavior?: OriginRequestQueryStringBehavior;
}
/**
 * (experimental) A Origin Request Policy configuration.
 *
 * @experimental
 * @resource AWS::CloudFront::OriginRequestPolicy
 */
export declare class OriginRequestPolicy extends Resource implements IOriginRequestPolicy {
    /**
     * (experimental) This policy includes only the User-Agent and Referer headers.
     *
     * It doesn’t include any query strings or cookies.
     *
     * @experimental
     */
    static readonly USER_AGENT_REFERER_HEADERS: IOriginRequestPolicy;
    /**
     * (experimental) This policy includes the header that enables cross-origin resource sharing (CORS) requests when the origin is a custom origin.
     *
     * @experimental
     */
    static readonly CORS_CUSTOM_ORIGIN: IOriginRequestPolicy;
    /**
     * (experimental) This policy includes the headers that enable cross-origin resource sharing (CORS) requests when the origin is an Amazon S3 bucket.
     *
     * @experimental
     */
    static readonly CORS_S3_ORIGIN: IOriginRequestPolicy;
    /**
     * (experimental) This policy includes all values (query strings, headers, and cookies) in the viewer request.
     *
     * @experimental
     */
    static readonly ALL_VIEWER: IOriginRequestPolicy;
    /**
     * (experimental) This policy is designed for use with an origin that is an AWS Elemental MediaTailor endpoint.
     *
     * @experimental
     */
    static readonly ELEMENTAL_MEDIA_TAILOR: IOriginRequestPolicy;
    /**
     * (experimental) Imports a Origin Request Policy from its id.
     *
     * @experimental
     */
    static fromOriginRequestPolicyId(scope: Construct, id: string, originRequestPolicyId: string): IOriginRequestPolicy;
    /** Use an existing managed origin request policy. */
    private static fromManagedOriginRequestPolicy;
    /**
     * (experimental) The ID of the origin request policy.
     *
     * @experimental
     */
    readonly originRequestPolicyId: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: OriginRequestPolicyProps);
}
/**
 * (experimental) Ddetermines whether any cookies in viewer requests (and if so, which cookies) are included in requests that CloudFront sends to the origin.
 *
 * @experimental
 */
export declare class OriginRequestCookieBehavior {
    /**
     * (experimental) Cookies in viewer requests are not included in requests that CloudFront sends to the origin.
     *
     * Any cookies that are listed in a CachePolicy are still included in origin requests.
     *
     * @experimental
     */
    static none(): OriginRequestCookieBehavior;
    /**
     * (experimental) All cookies in viewer requests are included in requests that CloudFront sends to the origin.
     *
     * @experimental
     */
    static all(): OriginRequestCookieBehavior;
    /**
     * (experimental) Only the provided `cookies` are included in requests that CloudFront sends to the origin.
     *
     * @experimental
     */
    static allowList(...cookies: string[]): OriginRequestCookieBehavior;
    /**
     * (experimental) The behavior of cookies: allow all, none or an allow list.
     *
     * @experimental
     */
    readonly behavior: string;
    /**
     * (experimental) The cookies to allow, if the behavior is an allow list.
     *
     * @experimental
     */
    readonly cookies?: string[];
    private constructor();
}
/**
 * (experimental) Determines whether any HTTP headers (and if so, which headers) are included in requests that CloudFront sends to the origin.
 *
 * @experimental
 */
export declare class OriginRequestHeaderBehavior {
    /**
     * (experimental) HTTP headers are not included in requests that CloudFront sends to the origin.
     *
     * Any headers that are listed in a CachePolicy are still included in origin requests.
     *
     * @experimental
     */
    static none(): OriginRequestHeaderBehavior;
    /**
     * (experimental) All HTTP headers in viewer requests are included in requests that CloudFront sends to the origin.
     *
     * Additionally, any additional CloudFront headers provided are included; the additional headers are added by CloudFront.
     *
     * @see https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-cloudfront-headers.html
     * @experimental
     */
    static all(...cloudfrontHeaders: string[]): OriginRequestHeaderBehavior;
    /**
     * (experimental) Listed headers are included in requests that CloudFront sends to the origin.
     *
     * @experimental
     */
    static allowList(...headers: string[]): OriginRequestHeaderBehavior;
    /**
     * (experimental) The behavior of headers: allow all, none or an allow list.
     *
     * @experimental
     */
    readonly behavior: string;
    /**
     * (experimental) The headers for the allow list or the included CloudFront headers, if applicable.
     *
     * @experimental
     */
    readonly headers?: string[];
    private constructor();
}
/**
 * (experimental) Determines whether any URL query strings in viewer requests (and if so, which query strings) are included in requests that CloudFront sends to the origin.
 *
 * @experimental
 */
export declare class OriginRequestQueryStringBehavior {
    /**
     * (experimental) Query strings in viewer requests are not included in requests that CloudFront sends to the origin.
     *
     * Any query strings that are listed in a CachePolicy are still included in origin requests.
     *
     * @experimental
     */
    static none(): OriginRequestQueryStringBehavior;
    /**
     * (experimental) All query strings in viewer requests are included in requests that CloudFront sends to the origin.
     *
     * @experimental
     */
    static all(): OriginRequestQueryStringBehavior;
    /**
     * (experimental) Only the provided `queryStrings` are included in requests that CloudFront sends to the origin.
     *
     * @experimental
     */
    static allowList(...queryStrings: string[]): OriginRequestQueryStringBehavior;
    /**
     * (experimental) The behavior of query strings -- allow all, none, or only an allow list.
     *
     * @experimental
     */
    readonly behavior: string;
    /**
     * (experimental) The query strings to allow, if the behavior is an allow list.
     *
     * @experimental
     */
    readonly queryStrings?: string[];
    private constructor();
}
