"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpOrigin = void 0;
const cloudfront = require("../../aws-cloudfront"); // Automatically re-written from '@aws-cdk/aws-cloudfront'
/**
 * (experimental) An Origin for an HTTP server or S3 bucket configured for website hosting.
 *
 * @experimental
 */
class HttpOrigin extends cloudfront.OriginBase {
    /**
     * @experimental
     */
    constructor(domainName, props = {}) {
        super(domainName, props);
        this.props = props;
        validateSecondsInRangeOrUndefined('readTimeout', 1, 60, props.readTimeout);
        validateSecondsInRangeOrUndefined('keepaliveTimeout', 1, 60, props.keepaliveTimeout);
    }
    /**
     * @experimental
     */
    renderCustomOriginConfig() {
        var _a, _b, _c;
        return {
            originProtocolPolicy: (_a = this.props.protocolPolicy) !== null && _a !== void 0 ? _a : cloudfront.OriginProtocolPolicy.HTTPS_ONLY,
            httpPort: this.props.httpPort,
            httpsPort: this.props.httpsPort,
            originReadTimeout: (_b = this.props.readTimeout) === null || _b === void 0 ? void 0 : _b.toSeconds(),
            originKeepaliveTimeout: (_c = this.props.keepaliveTimeout) === null || _c === void 0 ? void 0 : _c.toSeconds(),
        };
    }
}
exports.HttpOrigin = HttpOrigin;
/**
 * Throws an error if a duration is defined and not an integer number of seconds within a range.
 */
function validateSecondsInRangeOrUndefined(name, min, max, duration) {
    if (duration === undefined) {
        return;
    }
    const value = duration.toSeconds();
    if (!Number.isInteger(value) || value < min || value > max) {
        throw new Error(`${name}: Must be an int between ${min} and ${max} seconds (inclusive); received ${value}.`);
    }
}
//# sourceMappingURL=data:application/json;base64,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