import * as events from "../../aws-events";
import { Duration } from "../../core";
import { IBackupVault } from './vault';
/**
 * (experimental) Properties for a BackupPlanRule.
 *
 * @experimental
 */
export interface BackupPlanRuleProps {
    /**
     * (experimental) The duration after a backup job is successfully started before it must be completed or it is canceled by AWS Backup.
     *
     * @default - 8 hours
     * @experimental
     */
    readonly completionWindow?: Duration;
    /**
     * (experimental) Specifies the duration after creation that a recovery point is deleted.
     *
     * Must be greater than `moveToColdStorageAfter`.
     *
     * @default - recovery point is never deleted
     * @experimental
     */
    readonly deleteAfter?: Duration;
    /**
     * (experimental) Specifies the duration after creation that a recovery point is moved to cold storage.
     *
     * @default - recovery point is never moved to cold storage
     * @experimental
     */
    readonly moveToColdStorageAfter?: Duration;
    /**
     * (experimental) A display name for the backup rule.
     *
     * @default - a CDK generated name
     * @experimental
     */
    readonly ruleName?: string;
    /**
     * (experimental) A CRON expression specifying when AWS Backup initiates a backup job.
     *
     * @default - no schedule
     * @experimental
     */
    readonly scheduleExpression?: events.Schedule;
    /**
     * (experimental) The duration after a backup is scheduled before a job is canceled if it doesn't start successfully.
     *
     * @default - 8 hours
     * @experimental
     */
    readonly startWindow?: Duration;
    /**
     * (experimental) The backup vault where backups are.
     *
     * @default - use the vault defined at the plan level. If not defined a new
     * common vault for the plan will be created
     * @experimental
     */
    readonly backupVault?: IBackupVault;
}
/**
 * (experimental) A backup plan rule.
 *
 * @experimental
 */
export declare class BackupPlanRule {
    readonly props: BackupPlanRuleProps;
    /**
     * (experimental) Daily with 35 days retention.
     *
     * @experimental
     */
    static daily(backupVault?: IBackupVault): BackupPlanRule;
    /**
     * (experimental) Weekly with 3 months retention.
     *
     * @experimental
     */
    static weekly(backupVault?: IBackupVault): BackupPlanRule;
    /**
     * (experimental) Monthly 1 year retention, move to cold storage after 1 month.
     *
     * @experimental
     */
    static monthly1Year(backupVault?: IBackupVault): BackupPlanRule;
    /**
     * (experimental) Monthly 5 year retention, move to cold storage after 3 months.
     *
     * @experimental
     */
    static monthly5Year(backupVault?: IBackupVault): BackupPlanRule;
    /**
     * (experimental) Monthly 7 year retention, move to cold storage after 3 months.
     *
     * @experimental
     */
    static monthly7Year(backupVault?: IBackupVault): BackupPlanRule;
    /**
     * @param props Rule properties.
     * @experimental
     */
    constructor(props: BackupPlanRuleProps);
}
