import * as cdk from "../../core";
import * as cfn_parse from "../../core/lib/cfn-parse";
/**
 * Properties for defining a `AWS::Backup::BackupPlan`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupplan.html
 * @external
 */
export interface CfnBackupPlanProps {
    /**
     * `AWS::Backup::BackupPlan.BackupPlan`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupplan.html#cfn-backup-backupplan-backupplan
     * @external
     */
    readonly backupPlan: CfnBackupPlan.BackupPlanResourceTypeProperty | cdk.IResolvable;
    /**
     * `AWS::Backup::BackupPlan.BackupPlanTags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupplan.html#cfn-backup-backupplan-backupplantags
     * @external
     */
    readonly backupPlanTags?: any | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Backup::BackupPlan`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupplan.html
 * @external
 * @cloudformationResource AWS::Backup::BackupPlan
 */
export declare class CfnBackupPlan extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Backup::BackupPlan";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnBackupPlan;
    /**
     * @external
     * @cloudformationAttribute BackupPlanArn
     */
    readonly attrBackupPlanArn: string;
    /**
     * @external
     * @cloudformationAttribute BackupPlanId
     */
    readonly attrBackupPlanId: string;
    /**
     * @external
     * @cloudformationAttribute VersionId
     */
    readonly attrVersionId: string;
    /**
     * `AWS::Backup::BackupPlan.BackupPlan`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupplan.html#cfn-backup-backupplan-backupplan
     * @external
     */
    backupPlan: CfnBackupPlan.BackupPlanResourceTypeProperty | cdk.IResolvable;
    /**
     * `AWS::Backup::BackupPlan.BackupPlanTags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupplan.html#cfn-backup-backupplan-backupplantags
     * @external
     */
    backupPlanTags: any | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Backup::BackupPlan`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnBackupPlanProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Backup::BackupPlan`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupplan.html
 * @external
 * @cloudformationResource AWS::Backup::BackupPlan
 */
export declare namespace CfnBackupPlan {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-advancedbackupsettingresourcetype.html
     * @external
     */
    interface AdvancedBackupSettingResourceTypeProperty {
        /**
         * `CfnBackupPlan.AdvancedBackupSettingResourceTypeProperty.BackupOptions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-advancedbackupsettingresourcetype.html#cfn-backup-backupplan-advancedbackupsettingresourcetype-backupoptions
         * @external
         */
        readonly backupOptions: any | cdk.IResolvable;
        /**
         * `CfnBackupPlan.AdvancedBackupSettingResourceTypeProperty.ResourceType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-advancedbackupsettingresourcetype.html#cfn-backup-backupplan-advancedbackupsettingresourcetype-resourcetype
         * @external
         */
        readonly resourceType: string;
    }
}
/**
 * A CloudFormation `AWS::Backup::BackupPlan`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupplan.html
 * @external
 * @cloudformationResource AWS::Backup::BackupPlan
 */
export declare namespace CfnBackupPlan {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-backupplanresourcetype.html
     * @external
     */
    interface BackupPlanResourceTypeProperty {
        /**
         * `CfnBackupPlan.BackupPlanResourceTypeProperty.AdvancedBackupSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-backupplanresourcetype.html#cfn-backup-backupplan-backupplanresourcetype-advancedbackupsettings
         * @external
         */
        readonly advancedBackupSettings?: Array<CfnBackupPlan.AdvancedBackupSettingResourceTypeProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnBackupPlan.BackupPlanResourceTypeProperty.BackupPlanName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-backupplanresourcetype.html#cfn-backup-backupplan-backupplanresourcetype-backupplanname
         * @external
         */
        readonly backupPlanName: string;
        /**
         * `CfnBackupPlan.BackupPlanResourceTypeProperty.BackupPlanRule`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-backupplanresourcetype.html#cfn-backup-backupplan-backupplanresourcetype-backupplanrule
         * @external
         */
        readonly backupPlanRule: Array<CfnBackupPlan.BackupRuleResourceTypeProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Backup::BackupPlan`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupplan.html
 * @external
 * @cloudformationResource AWS::Backup::BackupPlan
 */
export declare namespace CfnBackupPlan {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-backupruleresourcetype.html
     * @external
     */
    interface BackupRuleResourceTypeProperty {
        /**
         * `CfnBackupPlan.BackupRuleResourceTypeProperty.CompletionWindowMinutes`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-backupruleresourcetype.html#cfn-backup-backupplan-backupruleresourcetype-completionwindowminutes
         * @external
         */
        readonly completionWindowMinutes?: number;
        /**
         * `CfnBackupPlan.BackupRuleResourceTypeProperty.CopyActions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-backupruleresourcetype.html#cfn-backup-backupplan-backupruleresourcetype-copyactions
         * @external
         */
        readonly copyActions?: Array<CfnBackupPlan.CopyActionResourceTypeProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnBackupPlan.BackupRuleResourceTypeProperty.Lifecycle`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-backupruleresourcetype.html#cfn-backup-backupplan-backupruleresourcetype-lifecycle
         * @external
         */
        readonly lifecycle?: CfnBackupPlan.LifecycleResourceTypeProperty | cdk.IResolvable;
        /**
         * `CfnBackupPlan.BackupRuleResourceTypeProperty.RecoveryPointTags`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-backupruleresourcetype.html#cfn-backup-backupplan-backupruleresourcetype-recoverypointtags
         * @external
         */
        readonly recoveryPointTags?: any | cdk.IResolvable;
        /**
         * `CfnBackupPlan.BackupRuleResourceTypeProperty.RuleName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-backupruleresourcetype.html#cfn-backup-backupplan-backupruleresourcetype-rulename
         * @external
         */
        readonly ruleName: string;
        /**
         * `CfnBackupPlan.BackupRuleResourceTypeProperty.ScheduleExpression`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-backupruleresourcetype.html#cfn-backup-backupplan-backupruleresourcetype-scheduleexpression
         * @external
         */
        readonly scheduleExpression?: string;
        /**
         * `CfnBackupPlan.BackupRuleResourceTypeProperty.StartWindowMinutes`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-backupruleresourcetype.html#cfn-backup-backupplan-backupruleresourcetype-startwindowminutes
         * @external
         */
        readonly startWindowMinutes?: number;
        /**
         * `CfnBackupPlan.BackupRuleResourceTypeProperty.TargetBackupVault`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-backupruleresourcetype.html#cfn-backup-backupplan-backupruleresourcetype-targetbackupvault
         * @external
         */
        readonly targetBackupVault: string;
    }
}
/**
 * A CloudFormation `AWS::Backup::BackupPlan`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupplan.html
 * @external
 * @cloudformationResource AWS::Backup::BackupPlan
 */
export declare namespace CfnBackupPlan {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-copyactionresourcetype.html
     * @external
     */
    interface CopyActionResourceTypeProperty {
        /**
         * `CfnBackupPlan.CopyActionResourceTypeProperty.DestinationBackupVaultArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-copyactionresourcetype.html#cfn-backup-backupplan-copyactionresourcetype-destinationbackupvaultarn
         * @external
         */
        readonly destinationBackupVaultArn: string;
        /**
         * `CfnBackupPlan.CopyActionResourceTypeProperty.Lifecycle`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-copyactionresourcetype.html#cfn-backup-backupplan-copyactionresourcetype-lifecycle
         * @external
         */
        readonly lifecycle?: CfnBackupPlan.LifecycleResourceTypeProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Backup::BackupPlan`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupplan.html
 * @external
 * @cloudformationResource AWS::Backup::BackupPlan
 */
export declare namespace CfnBackupPlan {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-lifecycleresourcetype.html
     * @external
     */
    interface LifecycleResourceTypeProperty {
        /**
         * `CfnBackupPlan.LifecycleResourceTypeProperty.DeleteAfterDays`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-lifecycleresourcetype.html#cfn-backup-backupplan-lifecycleresourcetype-deleteafterdays
         * @external
         */
        readonly deleteAfterDays?: number;
        /**
         * `CfnBackupPlan.LifecycleResourceTypeProperty.MoveToColdStorageAfterDays`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-lifecycleresourcetype.html#cfn-backup-backupplan-lifecycleresourcetype-movetocoldstorageafterdays
         * @external
         */
        readonly moveToColdStorageAfterDays?: number;
    }
}
/**
 * Properties for defining a `AWS::Backup::BackupSelection`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupselection.html
 * @external
 */
export interface CfnBackupSelectionProps {
    /**
     * `AWS::Backup::BackupSelection.BackupPlanId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupselection.html#cfn-backup-backupselection-backupplanid
     * @external
     */
    readonly backupPlanId: string;
    /**
     * `AWS::Backup::BackupSelection.BackupSelection`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupselection.html#cfn-backup-backupselection-backupselection
     * @external
     */
    readonly backupSelection: CfnBackupSelection.BackupSelectionResourceTypeProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Backup::BackupSelection`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupselection.html
 * @external
 * @cloudformationResource AWS::Backup::BackupSelection
 */
export declare class CfnBackupSelection extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Backup::BackupSelection";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnBackupSelection;
    /**
     * @external
     * @cloudformationAttribute BackupPlanId
     */
    readonly attrBackupPlanId: string;
    /**
     * @external
     * @cloudformationAttribute SelectionId
     */
    readonly attrSelectionId: string;
    /**
     * `AWS::Backup::BackupSelection.BackupPlanId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupselection.html#cfn-backup-backupselection-backupplanid
     * @external
     */
    backupPlanId: string;
    /**
     * `AWS::Backup::BackupSelection.BackupSelection`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupselection.html#cfn-backup-backupselection-backupselection
     * @external
     */
    backupSelection: CfnBackupSelection.BackupSelectionResourceTypeProperty | cdk.IResolvable;
    /**
     * Create a new `AWS::Backup::BackupSelection`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnBackupSelectionProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Backup::BackupSelection`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupselection.html
 * @external
 * @cloudformationResource AWS::Backup::BackupSelection
 */
export declare namespace CfnBackupSelection {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupselection-backupselectionresourcetype.html
     * @external
     */
    interface BackupSelectionResourceTypeProperty {
        /**
         * `CfnBackupSelection.BackupSelectionResourceTypeProperty.IamRoleArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupselection-backupselectionresourcetype.html#cfn-backup-backupselection-backupselectionresourcetype-iamrolearn
         * @external
         */
        readonly iamRoleArn: string;
        /**
         * `CfnBackupSelection.BackupSelectionResourceTypeProperty.ListOfTags`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupselection-backupselectionresourcetype.html#cfn-backup-backupselection-backupselectionresourcetype-listoftags
         * @external
         */
        readonly listOfTags?: Array<CfnBackupSelection.ConditionResourceTypeProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnBackupSelection.BackupSelectionResourceTypeProperty.Resources`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupselection-backupselectionresourcetype.html#cfn-backup-backupselection-backupselectionresourcetype-resources
         * @external
         */
        readonly resources?: string[];
        /**
         * `CfnBackupSelection.BackupSelectionResourceTypeProperty.SelectionName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupselection-backupselectionresourcetype.html#cfn-backup-backupselection-backupselectionresourcetype-selectionname
         * @external
         */
        readonly selectionName: string;
    }
}
/**
 * A CloudFormation `AWS::Backup::BackupSelection`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupselection.html
 * @external
 * @cloudformationResource AWS::Backup::BackupSelection
 */
export declare namespace CfnBackupSelection {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupselection-conditionresourcetype.html
     * @external
     */
    interface ConditionResourceTypeProperty {
        /**
         * `CfnBackupSelection.ConditionResourceTypeProperty.ConditionKey`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupselection-conditionresourcetype.html#cfn-backup-backupselection-conditionresourcetype-conditionkey
         * @external
         */
        readonly conditionKey: string;
        /**
         * `CfnBackupSelection.ConditionResourceTypeProperty.ConditionType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupselection-conditionresourcetype.html#cfn-backup-backupselection-conditionresourcetype-conditiontype
         * @external
         */
        readonly conditionType: string;
        /**
         * `CfnBackupSelection.ConditionResourceTypeProperty.ConditionValue`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupselection-conditionresourcetype.html#cfn-backup-backupselection-conditionresourcetype-conditionvalue
         * @external
         */
        readonly conditionValue: string;
    }
}
/**
 * Properties for defining a `AWS::Backup::BackupVault`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html
 * @external
 */
export interface CfnBackupVaultProps {
    /**
     * `AWS::Backup::BackupVault.BackupVaultName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html#cfn-backup-backupvault-backupvaultname
     * @external
     */
    readonly backupVaultName: string;
    /**
     * `AWS::Backup::BackupVault.AccessPolicy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html#cfn-backup-backupvault-accesspolicy
     * @external
     */
    readonly accessPolicy?: any | cdk.IResolvable;
    /**
     * `AWS::Backup::BackupVault.BackupVaultTags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html#cfn-backup-backupvault-backupvaulttags
     * @external
     */
    readonly backupVaultTags?: any | cdk.IResolvable;
    /**
     * `AWS::Backup::BackupVault.EncryptionKeyArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html#cfn-backup-backupvault-encryptionkeyarn
     * @external
     */
    readonly encryptionKeyArn?: string;
    /**
     * `AWS::Backup::BackupVault.Notifications`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html#cfn-backup-backupvault-notifications
     * @external
     */
    readonly notifications?: CfnBackupVault.NotificationObjectTypeProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Backup::BackupVault`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html
 * @external
 * @cloudformationResource AWS::Backup::BackupVault
 */
export declare class CfnBackupVault extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Backup::BackupVault";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnBackupVault;
    /**
     * @external
     * @cloudformationAttribute BackupVaultArn
     */
    readonly attrBackupVaultArn: string;
    /**
     * @external
     * @cloudformationAttribute BackupVaultName
     */
    readonly attrBackupVaultName: string;
    /**
     * `AWS::Backup::BackupVault.BackupVaultName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html#cfn-backup-backupvault-backupvaultname
     * @external
     */
    backupVaultName: string;
    /**
     * `AWS::Backup::BackupVault.AccessPolicy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html#cfn-backup-backupvault-accesspolicy
     * @external
     */
    accessPolicy: any | cdk.IResolvable | undefined;
    /**
     * `AWS::Backup::BackupVault.BackupVaultTags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html#cfn-backup-backupvault-backupvaulttags
     * @external
     */
    backupVaultTags: any | cdk.IResolvable | undefined;
    /**
     * `AWS::Backup::BackupVault.EncryptionKeyArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html#cfn-backup-backupvault-encryptionkeyarn
     * @external
     */
    encryptionKeyArn: string | undefined;
    /**
     * `AWS::Backup::BackupVault.Notifications`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html#cfn-backup-backupvault-notifications
     * @external
     */
    notifications: CfnBackupVault.NotificationObjectTypeProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Backup::BackupVault`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnBackupVaultProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Backup::BackupVault`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html
 * @external
 * @cloudformationResource AWS::Backup::BackupVault
 */
export declare namespace CfnBackupVault {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupvault-notificationobjecttype.html
     * @external
     */
    interface NotificationObjectTypeProperty {
        /**
         * `CfnBackupVault.NotificationObjectTypeProperty.BackupVaultEvents`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupvault-notificationobjecttype.html#cfn-backup-backupvault-notificationobjecttype-backupvaultevents
         * @external
         */
        readonly backupVaultEvents: string[];
        /**
         * `CfnBackupVault.NotificationObjectTypeProperty.SNSTopicArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupvault-notificationobjecttype.html#cfn-backup-backupvault-notificationobjecttype-snstopicarn
         * @external
         */
        readonly snsTopicArn: string;
    }
}
