import { Resource } from "../../core";
import { Construct } from 'constructs';
import { IAutoScalingGroup } from './auto-scaling-group';
import { Schedule } from './schedule';
/**
 * (experimental) Properties for a scheduled scaling action.
 *
 * @experimental
 */
export interface BasicScheduledActionProps {
    /**
     * (experimental) When to perform this action.
     *
     * Supports cron expressions.
     *
     * For more information about cron expressions, see https://en.wikipedia.org/wiki/Cron.
     *
     * @experimental
     * @example
     *
     * 0 8 * * ?
     */
    readonly schedule: Schedule;
    /**
     * (experimental) When this scheduled action becomes active.
     *
     * @default - The rule is activate immediately.
     * @experimental
     */
    readonly startTime?: Date;
    /**
     * (experimental) When this scheduled action expires.
     *
     * @default - The rule never expires.
     * @experimental
     */
    readonly endTime?: Date;
    /**
     * (experimental) The new minimum capacity.
     *
     * At the scheduled time, set the minimum capacity to the given capacity.
     *
     * At least one of maxCapacity, minCapacity, or desiredCapacity must be supplied.
     *
     * @default - No new minimum capacity.
     * @experimental
     */
    readonly minCapacity?: number;
    /**
     * (experimental) The new maximum capacity.
     *
     * At the scheduled time, set the maximum capacity to the given capacity.
     *
     * At least one of maxCapacity, minCapacity, or desiredCapacity must be supplied.
     *
     * @default - No new maximum capacity.
     * @experimental
     */
    readonly maxCapacity?: number;
    /**
     * (experimental) The new desired capacity.
     *
     * At the scheduled time, set the desired capacity to the given capacity.
     *
     * At least one of maxCapacity, minCapacity, or desiredCapacity must be supplied.
     *
     * @default - No new desired capacity.
     * @experimental
     */
    readonly desiredCapacity?: number;
}
/**
 * (experimental) Properties for a scheduled action on an AutoScalingGroup.
 *
 * @experimental
 */
export interface ScheduledActionProps extends BasicScheduledActionProps {
    /**
     * (experimental) The AutoScalingGroup to apply the scheduled actions to.
     *
     * @experimental
     */
    readonly autoScalingGroup: IAutoScalingGroup;
}
/**
 * (experimental) Define a scheduled scaling action.
 *
 * @experimental
 */
export declare class ScheduledAction extends Resource {
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: ScheduledActionProps);
}
