/**
 * (experimental) Schedule for scheduled scaling actions.
 *
 * @experimental
 */
export declare abstract class Schedule {
    /**
     * (experimental) Construct a schedule from a literal schedule expression.
     *
     * @param expression The expression to use.
     * @see http://crontab.org/
     * @experimental
     */
    static expression(expression: string): Schedule;
    /**
     * (experimental) Create a schedule from a set of cron fields.
     *
     * @experimental
     */
    static cron(options: CronOptions): Schedule;
    /**
     * (experimental) Retrieve the expression for this schedule.
     *
     * @experimental
     */
    abstract readonly expressionString: string;
    /**
     * @experimental
     */
    protected constructor();
}
/**
 * (experimental) Options to configure a cron expression.
 *
 * All fields are strings so you can use complex expressions. Absence of
 * a field implies '*' or '?', whichever one is appropriate.
 *
 * @see http://crontab.org/
 * @experimental
 */
export interface CronOptions {
    /**
     * (experimental) The minute to run this rule at.
     *
     * @default - Every minute
     * @experimental
     */
    readonly minute?: string;
    /**
     * (experimental) The hour to run this rule at.
     *
     * @default - Every hour
     * @experimental
     */
    readonly hour?: string;
    /**
     * (experimental) The day of the month to run this rule at.
     *
     * @default - Every day of the month
     * @experimental
     */
    readonly day?: string;
    /**
     * (experimental) The month to run this rule at.
     *
     * @default - Every month
     * @experimental
     */
    readonly month?: string;
    /**
     * (experimental) The day of the week to run this rule at.
     *
     * @default - Any day of the week
     * @experimental
     */
    readonly weekDay?: string;
}
