import * as cdk from "../../core";
import * as cfn_parse from "../../core/lib/cfn-parse";
/**
 * Properties for defining a `AWS::AutoScaling::AutoScalingGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html
 * @external
 */
export interface CfnAutoScalingGroupProps {
    /**
     * `AWS::AutoScaling::AutoScalingGroup.MaxSize`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-maxsize
     * @external
     */
    readonly maxSize: string;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.MinSize`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-minsize
     * @external
     */
    readonly minSize: string;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.AutoScalingGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-autoscaling-autoscalinggroup-autoscalinggroupname
     * @external
     */
    readonly autoScalingGroupName?: string;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.AvailabilityZones`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-availabilityzones
     * @external
     */
    readonly availabilityZones?: string[];
    /**
     * `AWS::AutoScaling::AutoScalingGroup.Cooldown`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-cooldown
     * @external
     */
    readonly cooldown?: string;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.DesiredCapacity`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-desiredcapacity
     * @external
     */
    readonly desiredCapacity?: string;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.HealthCheckGracePeriod`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-healthcheckgraceperiod
     * @external
     */
    readonly healthCheckGracePeriod?: number;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.HealthCheckType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-healthchecktype
     * @external
     */
    readonly healthCheckType?: string;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.InstanceId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-instanceid
     * @external
     */
    readonly instanceId?: string;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.LaunchConfigurationName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-launchconfigurationname
     * @external
     */
    readonly launchConfigurationName?: string;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.LaunchTemplate`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-launchtemplate
     * @external
     */
    readonly launchTemplate?: CfnAutoScalingGroup.LaunchTemplateSpecificationProperty | cdk.IResolvable;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.LifecycleHookSpecificationList`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-autoscaling-autoscalinggroup-lifecyclehookspecificationlist
     * @external
     */
    readonly lifecycleHookSpecificationList?: Array<CfnAutoScalingGroup.LifecycleHookSpecificationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.LoadBalancerNames`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-loadbalancernames
     * @external
     */
    readonly loadBalancerNames?: string[];
    /**
     * `AWS::AutoScaling::AutoScalingGroup.MaxInstanceLifetime`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-maxinstancelifetime
     * @external
     */
    readonly maxInstanceLifetime?: number;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.MetricsCollection`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-metricscollection
     * @external
     */
    readonly metricsCollection?: Array<CfnAutoScalingGroup.MetricsCollectionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.MixedInstancesPolicy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-mixedinstancespolicy
     * @external
     */
    readonly mixedInstancesPolicy?: CfnAutoScalingGroup.MixedInstancesPolicyProperty | cdk.IResolvable;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.NewInstancesProtectedFromScaleIn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-newinstancesprotectedfromscalein
     * @external
     */
    readonly newInstancesProtectedFromScaleIn?: boolean | cdk.IResolvable;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.NotificationConfigurations`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-notificationconfigurations
     * @external
     */
    readonly notificationConfigurations?: Array<CfnAutoScalingGroup.NotificationConfigurationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.PlacementGroup`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-placementgroup
     * @external
     */
    readonly placementGroup?: string;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.ServiceLinkedRoleARN`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-autoscaling-autoscalinggroup-servicelinkedrolearn
     * @external
     */
    readonly serviceLinkedRoleArn?: string;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-tags
     * @external
     */
    readonly tags?: CfnAutoScalingGroup.TagPropertyProperty[];
    /**
     * `AWS::AutoScaling::AutoScalingGroup.TargetGroupARNs`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-targetgrouparns
     * @external
     */
    readonly targetGroupArns?: string[];
    /**
     * `AWS::AutoScaling::AutoScalingGroup.TerminationPolicies`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-termpolicy
     * @external
     */
    readonly terminationPolicies?: string[];
    /**
     * `AWS::AutoScaling::AutoScalingGroup.VPCZoneIdentifier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-vpczoneidentifier
     * @external
     */
    readonly vpcZoneIdentifier?: string[];
}
/**
 * A CloudFormation `AWS::AutoScaling::AutoScalingGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html
 * @external
 * @cloudformationResource AWS::AutoScaling::AutoScalingGroup
 */
export declare class CfnAutoScalingGroup extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AutoScaling::AutoScalingGroup";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnAutoScalingGroup;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.MaxSize`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-maxsize
     * @external
     */
    maxSize: string;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.MinSize`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-minsize
     * @external
     */
    minSize: string;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.AutoScalingGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-autoscaling-autoscalinggroup-autoscalinggroupname
     * @external
     */
    autoScalingGroupName: string | undefined;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.AvailabilityZones`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-availabilityzones
     * @external
     */
    availabilityZones: string[] | undefined;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.Cooldown`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-cooldown
     * @external
     */
    cooldown: string | undefined;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.DesiredCapacity`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-desiredcapacity
     * @external
     */
    desiredCapacity: string | undefined;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.HealthCheckGracePeriod`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-healthcheckgraceperiod
     * @external
     */
    healthCheckGracePeriod: number | undefined;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.HealthCheckType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-healthchecktype
     * @external
     */
    healthCheckType: string | undefined;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.InstanceId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-instanceid
     * @external
     */
    instanceId: string | undefined;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.LaunchConfigurationName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-launchconfigurationname
     * @external
     */
    launchConfigurationName: string | undefined;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.LaunchTemplate`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-launchtemplate
     * @external
     */
    launchTemplate: CfnAutoScalingGroup.LaunchTemplateSpecificationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.LifecycleHookSpecificationList`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-autoscaling-autoscalinggroup-lifecyclehookspecificationlist
     * @external
     */
    lifecycleHookSpecificationList: Array<CfnAutoScalingGroup.LifecycleHookSpecificationProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.LoadBalancerNames`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-loadbalancernames
     * @external
     */
    loadBalancerNames: string[] | undefined;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.MaxInstanceLifetime`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-maxinstancelifetime
     * @external
     */
    maxInstanceLifetime: number | undefined;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.MetricsCollection`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-metricscollection
     * @external
     */
    metricsCollection: Array<CfnAutoScalingGroup.MetricsCollectionProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.MixedInstancesPolicy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-mixedinstancespolicy
     * @external
     */
    mixedInstancesPolicy: CfnAutoScalingGroup.MixedInstancesPolicyProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.NewInstancesProtectedFromScaleIn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-newinstancesprotectedfromscalein
     * @external
     */
    newInstancesProtectedFromScaleIn: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.NotificationConfigurations`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-notificationconfigurations
     * @external
     */
    notificationConfigurations: Array<CfnAutoScalingGroup.NotificationConfigurationProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.PlacementGroup`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-placementgroup
     * @external
     */
    placementGroup: string | undefined;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.ServiceLinkedRoleARN`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-autoscaling-autoscalinggroup-servicelinkedrolearn
     * @external
     */
    serviceLinkedRoleArn: string | undefined;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.TargetGroupARNs`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-targetgrouparns
     * @external
     */
    targetGroupArns: string[] | undefined;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.TerminationPolicies`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-termpolicy
     * @external
     */
    terminationPolicies: string[] | undefined;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.VPCZoneIdentifier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-vpczoneidentifier
     * @external
     */
    vpcZoneIdentifier: string[] | undefined;
    /**
     * Create a new `AWS::AutoScaling::AutoScalingGroup`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAutoScalingGroupProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::AutoScaling::AutoScalingGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html
 * @external
 * @cloudformationResource AWS::AutoScaling::AutoScalingGroup
 */
export declare namespace CfnAutoScalingGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-as-mixedinstancespolicy-instancesdistribution.html
     * @external
     */
    interface InstancesDistributionProperty {
        /**
         * `CfnAutoScalingGroup.InstancesDistributionProperty.OnDemandAllocationStrategy`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-as-mixedinstancespolicy-instancesdistribution.html#cfn-autoscaling-autoscalinggroup-instancesdistribution-ondemandallocationstrategy
         * @external
         */
        readonly onDemandAllocationStrategy?: string;
        /**
         * `CfnAutoScalingGroup.InstancesDistributionProperty.OnDemandBaseCapacity`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-as-mixedinstancespolicy-instancesdistribution.html#cfn-autoscaling-autoscalinggroup-instancesdistribution-ondemandbasecapacity
         * @external
         */
        readonly onDemandBaseCapacity?: number;
        /**
         * `CfnAutoScalingGroup.InstancesDistributionProperty.OnDemandPercentageAboveBaseCapacity`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-as-mixedinstancespolicy-instancesdistribution.html#cfn-autoscaling-autoscalinggroup-instancesdistribution-ondemandpercentageabovebasecapacity
         * @external
         */
        readonly onDemandPercentageAboveBaseCapacity?: number;
        /**
         * `CfnAutoScalingGroup.InstancesDistributionProperty.SpotAllocationStrategy`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-as-mixedinstancespolicy-instancesdistribution.html#cfn-autoscaling-autoscalinggroup-instancesdistribution-spotallocationstrategy
         * @external
         */
        readonly spotAllocationStrategy?: string;
        /**
         * `CfnAutoScalingGroup.InstancesDistributionProperty.SpotInstancePools`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-as-mixedinstancespolicy-instancesdistribution.html#cfn-autoscaling-autoscalinggroup-instancesdistribution-spotinstancepools
         * @external
         */
        readonly spotInstancePools?: number;
        /**
         * `CfnAutoScalingGroup.InstancesDistributionProperty.SpotMaxPrice`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-as-mixedinstancespolicy-instancesdistribution.html#cfn-autoscaling-autoscalinggroup-instancesdistribution-spotmaxprice
         * @external
         */
        readonly spotMaxPrice?: string;
    }
}
/**
 * A CloudFormation `AWS::AutoScaling::AutoScalingGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html
 * @external
 * @cloudformationResource AWS::AutoScaling::AutoScalingGroup
 */
export declare namespace CfnAutoScalingGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-as-mixedinstancespolicy-launchtemplate.html
     * @external
     */
    interface LaunchTemplateProperty {
        /**
         * `CfnAutoScalingGroup.LaunchTemplateProperty.LaunchTemplateSpecification`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-as-mixedinstancespolicy-launchtemplate.html#cfn-as-group-launchtemplate
         * @external
         */
        readonly launchTemplateSpecification: CfnAutoScalingGroup.LaunchTemplateSpecificationProperty | cdk.IResolvable;
        /**
         * `CfnAutoScalingGroup.LaunchTemplateProperty.Overrides`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-as-mixedinstancespolicy-launchtemplate.html#cfn-as-mixedinstancespolicy-overrides
         * @external
         */
        readonly overrides?: Array<CfnAutoScalingGroup.LaunchTemplateOverridesProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AutoScaling::AutoScalingGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html
 * @external
 * @cloudformationResource AWS::AutoScaling::AutoScalingGroup
 */
export declare namespace CfnAutoScalingGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-as-mixedinstancespolicy-launchtemplateoverrides.html
     * @external
     */
    interface LaunchTemplateOverridesProperty {
        /**
         * `CfnAutoScalingGroup.LaunchTemplateOverridesProperty.InstanceType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-as-mixedinstancespolicy-launchtemplateoverrides.html#cfn-autoscaling-autoscalinggroup-launchtemplateoverrides-instancetype
         * @external
         */
        readonly instanceType?: string;
        /**
         * `CfnAutoScalingGroup.LaunchTemplateOverridesProperty.WeightedCapacity`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-as-mixedinstancespolicy-launchtemplateoverrides.html#cfn-autoscaling-autoscalinggroup-launchtemplateoverrides-weightedcapacity
         * @external
         */
        readonly weightedCapacity?: string;
    }
}
/**
 * A CloudFormation `AWS::AutoScaling::AutoScalingGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html
 * @external
 * @cloudformationResource AWS::AutoScaling::AutoScalingGroup
 */
export declare namespace CfnAutoScalingGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-launchtemplatespecification.html
     * @external
     */
    interface LaunchTemplateSpecificationProperty {
        /**
         * `CfnAutoScalingGroup.LaunchTemplateSpecificationProperty.LaunchTemplateId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-launchtemplatespecification.html#cfn-autoscaling-autoscalinggroup-launchtemplatespecification-launchtemplateid
         * @external
         */
        readonly launchTemplateId?: string;
        /**
         * `CfnAutoScalingGroup.LaunchTemplateSpecificationProperty.LaunchTemplateName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-launchtemplatespecification.html#cfn-autoscaling-autoscalinggroup-launchtemplatespecification-launchtemplatename
         * @external
         */
        readonly launchTemplateName?: string;
        /**
         * `CfnAutoScalingGroup.LaunchTemplateSpecificationProperty.Version`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-launchtemplatespecification.html#cfn-autoscaling-autoscalinggroup-launchtemplatespecification-version
         * @external
         */
        readonly version: string;
    }
}
/**
 * A CloudFormation `AWS::AutoScaling::AutoScalingGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html
 * @external
 * @cloudformationResource AWS::AutoScaling::AutoScalingGroup
 */
export declare namespace CfnAutoScalingGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-lifecyclehookspecification.html
     * @external
     */
    interface LifecycleHookSpecificationProperty {
        /**
         * `CfnAutoScalingGroup.LifecycleHookSpecificationProperty.DefaultResult`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-lifecyclehookspecification.html#cfn-autoscaling-autoscalinggroup-lifecyclehookspecification-defaultresult
         * @external
         */
        readonly defaultResult?: string;
        /**
         * `CfnAutoScalingGroup.LifecycleHookSpecificationProperty.HeartbeatTimeout`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-lifecyclehookspecification.html#cfn-autoscaling-autoscalinggroup-lifecyclehookspecification-heartbeattimeout
         * @external
         */
        readonly heartbeatTimeout?: number;
        /**
         * `CfnAutoScalingGroup.LifecycleHookSpecificationProperty.LifecycleHookName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-lifecyclehookspecification.html#cfn-autoscaling-autoscalinggroup-lifecyclehookspecification-lifecyclehookname
         * @external
         */
        readonly lifecycleHookName: string;
        /**
         * `CfnAutoScalingGroup.LifecycleHookSpecificationProperty.LifecycleTransition`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-lifecyclehookspecification.html#cfn-autoscaling-autoscalinggroup-lifecyclehookspecification-lifecycletransition
         * @external
         */
        readonly lifecycleTransition: string;
        /**
         * `CfnAutoScalingGroup.LifecycleHookSpecificationProperty.NotificationMetadata`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-lifecyclehookspecification.html#cfn-autoscaling-autoscalinggroup-lifecyclehookspecification-notificationmetadata
         * @external
         */
        readonly notificationMetadata?: string;
        /**
         * `CfnAutoScalingGroup.LifecycleHookSpecificationProperty.NotificationTargetARN`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-lifecyclehookspecification.html#cfn-autoscaling-autoscalinggroup-lifecyclehookspecification-notificationtargetarn
         * @external
         */
        readonly notificationTargetArn?: string;
        /**
         * `CfnAutoScalingGroup.LifecycleHookSpecificationProperty.RoleARN`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-lifecyclehookspecification.html#cfn-autoscaling-autoscalinggroup-lifecyclehookspecification-rolearn
         * @external
         */
        readonly roleArn?: string;
    }
}
/**
 * A CloudFormation `AWS::AutoScaling::AutoScalingGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html
 * @external
 * @cloudformationResource AWS::AutoScaling::AutoScalingGroup
 */
export declare namespace CfnAutoScalingGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-metricscollection.html
     * @external
     */
    interface MetricsCollectionProperty {
        /**
         * `CfnAutoScalingGroup.MetricsCollectionProperty.Granularity`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-metricscollection.html#cfn-as-metricscollection-granularity
         * @external
         */
        readonly granularity: string;
        /**
         * `CfnAutoScalingGroup.MetricsCollectionProperty.Metrics`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-metricscollection.html#cfn-as-metricscollection-metrics
         * @external
         */
        readonly metrics?: string[];
    }
}
/**
 * A CloudFormation `AWS::AutoScaling::AutoScalingGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html
 * @external
 * @cloudformationResource AWS::AutoScaling::AutoScalingGroup
 */
export declare namespace CfnAutoScalingGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-as-group-mixedinstancespolicy.html
     * @external
     */
    interface MixedInstancesPolicyProperty {
        /**
         * `CfnAutoScalingGroup.MixedInstancesPolicyProperty.InstancesDistribution`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-as-group-mixedinstancespolicy.html#cfn-as-mixedinstancespolicy-instancesdistribution
         * @external
         */
        readonly instancesDistribution?: CfnAutoScalingGroup.InstancesDistributionProperty | cdk.IResolvable;
        /**
         * `CfnAutoScalingGroup.MixedInstancesPolicyProperty.LaunchTemplate`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-as-group-mixedinstancespolicy.html#cfn-as-mixedinstancespolicy-launchtemplate
         * @external
         */
        readonly launchTemplate: CfnAutoScalingGroup.LaunchTemplateProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AutoScaling::AutoScalingGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html
 * @external
 * @cloudformationResource AWS::AutoScaling::AutoScalingGroup
 */
export declare namespace CfnAutoScalingGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-notificationconfigurations.html
     * @external
     */
    interface NotificationConfigurationProperty {
        /**
         * `CfnAutoScalingGroup.NotificationConfigurationProperty.NotificationTypes`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-notificationconfigurations.html#cfn-as-group-notificationconfigurations-notificationtypes
         * @external
         */
        readonly notificationTypes?: string[];
        /**
         * `CfnAutoScalingGroup.NotificationConfigurationProperty.TopicARN`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-notificationconfigurations.html#cfn-autoscaling-autoscalinggroup-notificationconfigurations-topicarn
         * @external
         */
        readonly topicArn: string;
    }
}
/**
 * A CloudFormation `AWS::AutoScaling::AutoScalingGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html
 * @external
 * @cloudformationResource AWS::AutoScaling::AutoScalingGroup
 */
export declare namespace CfnAutoScalingGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-tags.html
     * @external
     */
    interface TagPropertyProperty {
        /**
         * `CfnAutoScalingGroup.TagPropertyProperty.Key`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-tags.html#cfn-as-tags-Key
         * @external
         */
        readonly key: string;
        /**
         * `CfnAutoScalingGroup.TagPropertyProperty.PropagateAtLaunch`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-tags.html#cfn-as-tags-PropagateAtLaunch
         * @external
         */
        readonly propagateAtLaunch: boolean | cdk.IResolvable;
        /**
         * `CfnAutoScalingGroup.TagPropertyProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-tags.html#cfn-as-tags-Value
         * @external
         */
        readonly value: string;
    }
}
/**
 * Properties for defining a `AWS::AutoScaling::LaunchConfiguration`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html
 * @external
 */
export interface CfnLaunchConfigurationProps {
    /**
     * `AWS::AutoScaling::LaunchConfiguration.ImageId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-imageid
     * @external
     */
    readonly imageId: string;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.InstanceType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-instancetype
     * @external
     */
    readonly instanceType: string;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.AssociatePublicIpAddress`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cf-as-launchconfig-associatepubip
     * @external
     */
    readonly associatePublicIpAddress?: boolean | cdk.IResolvable;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.BlockDeviceMappings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-blockdevicemappings
     * @external
     */
    readonly blockDeviceMappings?: Array<CfnLaunchConfiguration.BlockDeviceMappingProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.ClassicLinkVPCId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-classiclinkvpcid
     * @external
     */
    readonly classicLinkVpcId?: string;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.ClassicLinkVPCSecurityGroups`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-classiclinkvpcsecuritygroups
     * @external
     */
    readonly classicLinkVpcSecurityGroups?: string[];
    /**
     * `AWS::AutoScaling::LaunchConfiguration.EbsOptimized`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-ebsoptimized
     * @external
     */
    readonly ebsOptimized?: boolean | cdk.IResolvable;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.IamInstanceProfile`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-iaminstanceprofile
     * @external
     */
    readonly iamInstanceProfile?: string;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.InstanceId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-instanceid
     * @external
     */
    readonly instanceId?: string;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.InstanceMonitoring`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-instancemonitoring
     * @external
     */
    readonly instanceMonitoring?: boolean | cdk.IResolvable;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.KernelId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-kernelid
     * @external
     */
    readonly kernelId?: string;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.KeyName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-keyname
     * @external
     */
    readonly keyName?: string;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.LaunchConfigurationName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-autoscaling-launchconfig-launchconfigurationname
     * @external
     */
    readonly launchConfigurationName?: string;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.PlacementTenancy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-placementtenancy
     * @external
     */
    readonly placementTenancy?: string;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.RamDiskId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-ramdiskid
     * @external
     */
    readonly ramDiskId?: string;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.SecurityGroups`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-securitygroups
     * @external
     */
    readonly securityGroups?: string[];
    /**
     * `AWS::AutoScaling::LaunchConfiguration.SpotPrice`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-spotprice
     * @external
     */
    readonly spotPrice?: string;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.UserData`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-userdata
     * @external
     */
    readonly userData?: string;
}
/**
 * A CloudFormation `AWS::AutoScaling::LaunchConfiguration`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html
 * @external
 * @cloudformationResource AWS::AutoScaling::LaunchConfiguration
 */
export declare class CfnLaunchConfiguration extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AutoScaling::LaunchConfiguration";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnLaunchConfiguration;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.ImageId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-imageid
     * @external
     */
    imageId: string;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.InstanceType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-instancetype
     * @external
     */
    instanceType: string;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.AssociatePublicIpAddress`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cf-as-launchconfig-associatepubip
     * @external
     */
    associatePublicIpAddress: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.BlockDeviceMappings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-blockdevicemappings
     * @external
     */
    blockDeviceMappings: Array<CfnLaunchConfiguration.BlockDeviceMappingProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.ClassicLinkVPCId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-classiclinkvpcid
     * @external
     */
    classicLinkVpcId: string | undefined;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.ClassicLinkVPCSecurityGroups`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-classiclinkvpcsecuritygroups
     * @external
     */
    classicLinkVpcSecurityGroups: string[] | undefined;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.EbsOptimized`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-ebsoptimized
     * @external
     */
    ebsOptimized: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.IamInstanceProfile`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-iaminstanceprofile
     * @external
     */
    iamInstanceProfile: string | undefined;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.InstanceId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-instanceid
     * @external
     */
    instanceId: string | undefined;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.InstanceMonitoring`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-instancemonitoring
     * @external
     */
    instanceMonitoring: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.KernelId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-kernelid
     * @external
     */
    kernelId: string | undefined;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.KeyName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-keyname
     * @external
     */
    keyName: string | undefined;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.LaunchConfigurationName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-autoscaling-launchconfig-launchconfigurationname
     * @external
     */
    launchConfigurationName: string | undefined;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.PlacementTenancy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-placementtenancy
     * @external
     */
    placementTenancy: string | undefined;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.RamDiskId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-ramdiskid
     * @external
     */
    ramDiskId: string | undefined;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.SecurityGroups`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-securitygroups
     * @external
     */
    securityGroups: string[] | undefined;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.SpotPrice`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-spotprice
     * @external
     */
    spotPrice: string | undefined;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.UserData`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-userdata
     * @external
     */
    userData: string | undefined;
    /**
     * Create a new `AWS::AutoScaling::LaunchConfiguration`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnLaunchConfigurationProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::AutoScaling::LaunchConfiguration`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html
 * @external
 * @cloudformationResource AWS::AutoScaling::LaunchConfiguration
 */
export declare namespace CfnLaunchConfiguration {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig-blockdev-template.html
     * @external
     */
    interface BlockDeviceProperty {
        /**
         * `CfnLaunchConfiguration.BlockDeviceProperty.DeleteOnTermination`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig-blockdev-template.html#cfn-as-launchconfig-blockdev-template-deleteonterm
         * @external
         */
        readonly deleteOnTermination?: boolean | cdk.IResolvable;
        /**
         * `CfnLaunchConfiguration.BlockDeviceProperty.Encrypted`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig-blockdev-template.html#cfn-as-launchconfig-blockdev-template-encrypted
         * @external
         */
        readonly encrypted?: boolean | cdk.IResolvable;
        /**
         * `CfnLaunchConfiguration.BlockDeviceProperty.Iops`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig-blockdev-template.html#cfn-as-launchconfig-blockdev-template-iops
         * @external
         */
        readonly iops?: number;
        /**
         * `CfnLaunchConfiguration.BlockDeviceProperty.SnapshotId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig-blockdev-template.html#cfn-as-launchconfig-blockdev-template-snapshotid
         * @external
         */
        readonly snapshotId?: string;
        /**
         * `CfnLaunchConfiguration.BlockDeviceProperty.VolumeSize`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig-blockdev-template.html#cfn-as-launchconfig-blockdev-template-volumesize
         * @external
         */
        readonly volumeSize?: number;
        /**
         * `CfnLaunchConfiguration.BlockDeviceProperty.VolumeType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig-blockdev-template.html#cfn-as-launchconfig-blockdev-template-volumetype
         * @external
         */
        readonly volumeType?: string;
    }
}
/**
 * A CloudFormation `AWS::AutoScaling::LaunchConfiguration`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html
 * @external
 * @cloudformationResource AWS::AutoScaling::LaunchConfiguration
 */
export declare namespace CfnLaunchConfiguration {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig-blockdev-mapping.html
     * @external
     */
    interface BlockDeviceMappingProperty {
        /**
         * `CfnLaunchConfiguration.BlockDeviceMappingProperty.DeviceName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig-blockdev-mapping.html#cfn-as-launchconfig-blockdev-mapping-devicename
         * @external
         */
        readonly deviceName: string;
        /**
         * `CfnLaunchConfiguration.BlockDeviceMappingProperty.Ebs`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig-blockdev-mapping.html#cfn-as-launchconfig-blockdev-mapping-ebs
         * @external
         */
        readonly ebs?: CfnLaunchConfiguration.BlockDeviceProperty | cdk.IResolvable;
        /**
         * `CfnLaunchConfiguration.BlockDeviceMappingProperty.NoDevice`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig-blockdev-mapping.html#cfn-as-launchconfig-blockdev-mapping-nodevice
         * @external
         */
        readonly noDevice?: boolean | cdk.IResolvable;
        /**
         * `CfnLaunchConfiguration.BlockDeviceMappingProperty.VirtualName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig-blockdev-mapping.html#cfn-as-launchconfig-blockdev-mapping-virtualname
         * @external
         */
        readonly virtualName?: string;
    }
}
/**
 * Properties for defining a `AWS::AutoScaling::LifecycleHook`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-lifecyclehook.html
 * @external
 */
export interface CfnLifecycleHookProps {
    /**
     * `AWS::AutoScaling::LifecycleHook.AutoScalingGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-lifecyclehook.html#cfn-as-lifecyclehook-autoscalinggroupname
     * @external
     */
    readonly autoScalingGroupName: string;
    /**
     * `AWS::AutoScaling::LifecycleHook.LifecycleTransition`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-lifecyclehook.html#cfn-as-lifecyclehook-lifecycletransition
     * @external
     */
    readonly lifecycleTransition: string;
    /**
     * `AWS::AutoScaling::LifecycleHook.DefaultResult`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-lifecyclehook.html#cfn-as-lifecyclehook-defaultresult
     * @external
     */
    readonly defaultResult?: string;
    /**
     * `AWS::AutoScaling::LifecycleHook.HeartbeatTimeout`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-lifecyclehook.html#cfn-as-lifecyclehook-heartbeattimeout
     * @external
     */
    readonly heartbeatTimeout?: number;
    /**
     * `AWS::AutoScaling::LifecycleHook.LifecycleHookName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-lifecyclehook.html#cfn-autoscaling-lifecyclehook-lifecyclehookname
     * @external
     */
    readonly lifecycleHookName?: string;
    /**
     * `AWS::AutoScaling::LifecycleHook.NotificationMetadata`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-lifecyclehook.html#cfn-as-lifecyclehook-notificationmetadata
     * @external
     */
    readonly notificationMetadata?: string;
    /**
     * `AWS::AutoScaling::LifecycleHook.NotificationTargetARN`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-lifecyclehook.html#cfn-as-lifecyclehook-notificationtargetarn
     * @external
     */
    readonly notificationTargetArn?: string;
    /**
     * `AWS::AutoScaling::LifecycleHook.RoleARN`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-lifecyclehook.html#cfn-as-lifecyclehook-rolearn
     * @external
     */
    readonly roleArn?: string;
}
/**
 * A CloudFormation `AWS::AutoScaling::LifecycleHook`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-lifecyclehook.html
 * @external
 * @cloudformationResource AWS::AutoScaling::LifecycleHook
 */
export declare class CfnLifecycleHook extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AutoScaling::LifecycleHook";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnLifecycleHook;
    /**
     * `AWS::AutoScaling::LifecycleHook.AutoScalingGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-lifecyclehook.html#cfn-as-lifecyclehook-autoscalinggroupname
     * @external
     */
    autoScalingGroupName: string;
    /**
     * `AWS::AutoScaling::LifecycleHook.LifecycleTransition`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-lifecyclehook.html#cfn-as-lifecyclehook-lifecycletransition
     * @external
     */
    lifecycleTransition: string;
    /**
     * `AWS::AutoScaling::LifecycleHook.DefaultResult`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-lifecyclehook.html#cfn-as-lifecyclehook-defaultresult
     * @external
     */
    defaultResult: string | undefined;
    /**
     * `AWS::AutoScaling::LifecycleHook.HeartbeatTimeout`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-lifecyclehook.html#cfn-as-lifecyclehook-heartbeattimeout
     * @external
     */
    heartbeatTimeout: number | undefined;
    /**
     * `AWS::AutoScaling::LifecycleHook.LifecycleHookName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-lifecyclehook.html#cfn-autoscaling-lifecyclehook-lifecyclehookname
     * @external
     */
    lifecycleHookName: string | undefined;
    /**
     * `AWS::AutoScaling::LifecycleHook.NotificationMetadata`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-lifecyclehook.html#cfn-as-lifecyclehook-notificationmetadata
     * @external
     */
    notificationMetadata: string | undefined;
    /**
     * `AWS::AutoScaling::LifecycleHook.NotificationTargetARN`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-lifecyclehook.html#cfn-as-lifecyclehook-notificationtargetarn
     * @external
     */
    notificationTargetArn: string | undefined;
    /**
     * `AWS::AutoScaling::LifecycleHook.RoleARN`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-lifecyclehook.html#cfn-as-lifecyclehook-rolearn
     * @external
     */
    roleArn: string | undefined;
    /**
     * Create a new `AWS::AutoScaling::LifecycleHook`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnLifecycleHookProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::AutoScaling::ScalingPolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-policy.html
 * @external
 */
export interface CfnScalingPolicyProps {
    /**
     * `AWS::AutoScaling::ScalingPolicy.AutoScalingGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-policy.html#cfn-as-scalingpolicy-autoscalinggroupname
     * @external
     */
    readonly autoScalingGroupName: string;
    /**
     * `AWS::AutoScaling::ScalingPolicy.AdjustmentType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-policy.html#cfn-as-scalingpolicy-adjustmenttype
     * @external
     */
    readonly adjustmentType?: string;
    /**
     * `AWS::AutoScaling::ScalingPolicy.Cooldown`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-policy.html#cfn-as-scalingpolicy-cooldown
     * @external
     */
    readonly cooldown?: string;
    /**
     * `AWS::AutoScaling::ScalingPolicy.EstimatedInstanceWarmup`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-policy.html#cfn-as-scalingpolicy-estimatedinstancewarmup
     * @external
     */
    readonly estimatedInstanceWarmup?: number;
    /**
     * `AWS::AutoScaling::ScalingPolicy.MetricAggregationType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-policy.html#cfn-as-scalingpolicy-metricaggregationtype
     * @external
     */
    readonly metricAggregationType?: string;
    /**
     * `AWS::AutoScaling::ScalingPolicy.MinAdjustmentMagnitude`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-policy.html#cfn-as-scalingpolicy-minadjustmentmagnitude
     * @external
     */
    readonly minAdjustmentMagnitude?: number;
    /**
     * `AWS::AutoScaling::ScalingPolicy.PolicyType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-policy.html#cfn-as-scalingpolicy-policytype
     * @external
     */
    readonly policyType?: string;
    /**
     * `AWS::AutoScaling::ScalingPolicy.ScalingAdjustment`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-policy.html#cfn-as-scalingpolicy-scalingadjustment
     * @external
     */
    readonly scalingAdjustment?: number;
    /**
     * `AWS::AutoScaling::ScalingPolicy.StepAdjustments`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-policy.html#cfn-as-scalingpolicy-stepadjustments
     * @external
     */
    readonly stepAdjustments?: Array<CfnScalingPolicy.StepAdjustmentProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::AutoScaling::ScalingPolicy.TargetTrackingConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-policy.html#cfn-autoscaling-scalingpolicy-targettrackingconfiguration
     * @external
     */
    readonly targetTrackingConfiguration?: CfnScalingPolicy.TargetTrackingConfigurationProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::AutoScaling::ScalingPolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-policy.html
 * @external
 * @cloudformationResource AWS::AutoScaling::ScalingPolicy
 */
export declare class CfnScalingPolicy extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AutoScaling::ScalingPolicy";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnScalingPolicy;
    /**
     * `AWS::AutoScaling::ScalingPolicy.AutoScalingGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-policy.html#cfn-as-scalingpolicy-autoscalinggroupname
     * @external
     */
    autoScalingGroupName: string;
    /**
     * `AWS::AutoScaling::ScalingPolicy.AdjustmentType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-policy.html#cfn-as-scalingpolicy-adjustmenttype
     * @external
     */
    adjustmentType: string | undefined;
    /**
     * `AWS::AutoScaling::ScalingPolicy.Cooldown`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-policy.html#cfn-as-scalingpolicy-cooldown
     * @external
     */
    cooldown: string | undefined;
    /**
     * `AWS::AutoScaling::ScalingPolicy.EstimatedInstanceWarmup`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-policy.html#cfn-as-scalingpolicy-estimatedinstancewarmup
     * @external
     */
    estimatedInstanceWarmup: number | undefined;
    /**
     * `AWS::AutoScaling::ScalingPolicy.MetricAggregationType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-policy.html#cfn-as-scalingpolicy-metricaggregationtype
     * @external
     */
    metricAggregationType: string | undefined;
    /**
     * `AWS::AutoScaling::ScalingPolicy.MinAdjustmentMagnitude`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-policy.html#cfn-as-scalingpolicy-minadjustmentmagnitude
     * @external
     */
    minAdjustmentMagnitude: number | undefined;
    /**
     * `AWS::AutoScaling::ScalingPolicy.PolicyType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-policy.html#cfn-as-scalingpolicy-policytype
     * @external
     */
    policyType: string | undefined;
    /**
     * `AWS::AutoScaling::ScalingPolicy.ScalingAdjustment`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-policy.html#cfn-as-scalingpolicy-scalingadjustment
     * @external
     */
    scalingAdjustment: number | undefined;
    /**
     * `AWS::AutoScaling::ScalingPolicy.StepAdjustments`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-policy.html#cfn-as-scalingpolicy-stepadjustments
     * @external
     */
    stepAdjustments: Array<CfnScalingPolicy.StepAdjustmentProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::AutoScaling::ScalingPolicy.TargetTrackingConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-policy.html#cfn-autoscaling-scalingpolicy-targettrackingconfiguration
     * @external
     */
    targetTrackingConfiguration: CfnScalingPolicy.TargetTrackingConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::AutoScaling::ScalingPolicy`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnScalingPolicyProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::AutoScaling::ScalingPolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-policy.html
 * @external
 * @cloudformationResource AWS::AutoScaling::ScalingPolicy
 */
export declare namespace CfnScalingPolicy {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-scalingpolicy-customizedmetricspecification.html
     * @external
     */
    interface CustomizedMetricSpecificationProperty {
        /**
         * `CfnScalingPolicy.CustomizedMetricSpecificationProperty.Dimensions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-scalingpolicy-customizedmetricspecification.html#cfn-autoscaling-scalingpolicy-customizedmetricspecification-dimensions
         * @external
         */
        readonly dimensions?: Array<CfnScalingPolicy.MetricDimensionProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnScalingPolicy.CustomizedMetricSpecificationProperty.MetricName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-scalingpolicy-customizedmetricspecification.html#cfn-autoscaling-scalingpolicy-customizedmetricspecification-metricname
         * @external
         */
        readonly metricName: string;
        /**
         * `CfnScalingPolicy.CustomizedMetricSpecificationProperty.Namespace`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-scalingpolicy-customizedmetricspecification.html#cfn-autoscaling-scalingpolicy-customizedmetricspecification-namespace
         * @external
         */
        readonly namespace: string;
        /**
         * `CfnScalingPolicy.CustomizedMetricSpecificationProperty.Statistic`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-scalingpolicy-customizedmetricspecification.html#cfn-autoscaling-scalingpolicy-customizedmetricspecification-statistic
         * @external
         */
        readonly statistic: string;
        /**
         * `CfnScalingPolicy.CustomizedMetricSpecificationProperty.Unit`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-scalingpolicy-customizedmetricspecification.html#cfn-autoscaling-scalingpolicy-customizedmetricspecification-unit
         * @external
         */
        readonly unit?: string;
    }
}
/**
 * A CloudFormation `AWS::AutoScaling::ScalingPolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-policy.html
 * @external
 * @cloudformationResource AWS::AutoScaling::ScalingPolicy
 */
export declare namespace CfnScalingPolicy {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-scalingpolicy-metricdimension.html
     * @external
     */
    interface MetricDimensionProperty {
        /**
         * `CfnScalingPolicy.MetricDimensionProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-scalingpolicy-metricdimension.html#cfn-autoscaling-scalingpolicy-metricdimension-name
         * @external
         */
        readonly name: string;
        /**
         * `CfnScalingPolicy.MetricDimensionProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-scalingpolicy-metricdimension.html#cfn-autoscaling-scalingpolicy-metricdimension-value
         * @external
         */
        readonly value: string;
    }
}
/**
 * A CloudFormation `AWS::AutoScaling::ScalingPolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-policy.html
 * @external
 * @cloudformationResource AWS::AutoScaling::ScalingPolicy
 */
export declare namespace CfnScalingPolicy {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-scalingpolicy-predefinedmetricspecification.html
     * @external
     */
    interface PredefinedMetricSpecificationProperty {
        /**
         * `CfnScalingPolicy.PredefinedMetricSpecificationProperty.PredefinedMetricType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-scalingpolicy-predefinedmetricspecification.html#cfn-autoscaling-scalingpolicy-predefinedmetricspecification-predefinedmetrictype
         * @external
         */
        readonly predefinedMetricType: string;
        /**
         * `CfnScalingPolicy.PredefinedMetricSpecificationProperty.ResourceLabel`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-scalingpolicy-predefinedmetricspecification.html#cfn-autoscaling-scalingpolicy-predefinedmetricspecification-resourcelabel
         * @external
         */
        readonly resourceLabel?: string;
    }
}
/**
 * A CloudFormation `AWS::AutoScaling::ScalingPolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-policy.html
 * @external
 * @cloudformationResource AWS::AutoScaling::ScalingPolicy
 */
export declare namespace CfnScalingPolicy {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-scalingpolicy-stepadjustments.html
     * @external
     */
    interface StepAdjustmentProperty {
        /**
         * `CfnScalingPolicy.StepAdjustmentProperty.MetricIntervalLowerBound`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-scalingpolicy-stepadjustments.html#cfn-autoscaling-scalingpolicy-stepadjustment-metricintervallowerbound
         * @external
         */
        readonly metricIntervalLowerBound?: number;
        /**
         * `CfnScalingPolicy.StepAdjustmentProperty.MetricIntervalUpperBound`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-scalingpolicy-stepadjustments.html#cfn-autoscaling-scalingpolicy-stepadjustment-metricintervalupperbound
         * @external
         */
        readonly metricIntervalUpperBound?: number;
        /**
         * `CfnScalingPolicy.StepAdjustmentProperty.ScalingAdjustment`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-scalingpolicy-stepadjustments.html#cfn-autoscaling-scalingpolicy-stepadjustment-scalingadjustment
         * @external
         */
        readonly scalingAdjustment: number;
    }
}
/**
 * A CloudFormation `AWS::AutoScaling::ScalingPolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-policy.html
 * @external
 * @cloudformationResource AWS::AutoScaling::ScalingPolicy
 */
export declare namespace CfnScalingPolicy {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-scalingpolicy-targettrackingconfiguration.html
     * @external
     */
    interface TargetTrackingConfigurationProperty {
        /**
         * `CfnScalingPolicy.TargetTrackingConfigurationProperty.CustomizedMetricSpecification`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-scalingpolicy-targettrackingconfiguration.html#cfn-autoscaling-scalingpolicy-targettrackingconfiguration-customizedmetricspecification
         * @external
         */
        readonly customizedMetricSpecification?: CfnScalingPolicy.CustomizedMetricSpecificationProperty | cdk.IResolvable;
        /**
         * `CfnScalingPolicy.TargetTrackingConfigurationProperty.DisableScaleIn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-scalingpolicy-targettrackingconfiguration.html#cfn-autoscaling-scalingpolicy-targettrackingconfiguration-disablescalein
         * @external
         */
        readonly disableScaleIn?: boolean | cdk.IResolvable;
        /**
         * `CfnScalingPolicy.TargetTrackingConfigurationProperty.PredefinedMetricSpecification`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-scalingpolicy-targettrackingconfiguration.html#cfn-autoscaling-scalingpolicy-targettrackingconfiguration-predefinedmetricspecification
         * @external
         */
        readonly predefinedMetricSpecification?: CfnScalingPolicy.PredefinedMetricSpecificationProperty | cdk.IResolvable;
        /**
         * `CfnScalingPolicy.TargetTrackingConfigurationProperty.TargetValue`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-scalingpolicy-targettrackingconfiguration.html#cfn-autoscaling-scalingpolicy-targettrackingconfiguration-targetvalue
         * @external
         */
        readonly targetValue: number;
    }
}
/**
 * Properties for defining a `AWS::AutoScaling::ScheduledAction`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-scheduledaction.html
 * @external
 */
export interface CfnScheduledActionProps {
    /**
     * `AWS::AutoScaling::ScheduledAction.AutoScalingGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-scheduledaction.html#cfn-as-scheduledaction-asgname
     * @external
     */
    readonly autoScalingGroupName: string;
    /**
     * `AWS::AutoScaling::ScheduledAction.DesiredCapacity`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-scheduledaction.html#cfn-as-scheduledaction-desiredcapacity
     * @external
     */
    readonly desiredCapacity?: number;
    /**
     * `AWS::AutoScaling::ScheduledAction.EndTime`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-scheduledaction.html#cfn-as-scheduledaction-endtime
     * @external
     */
    readonly endTime?: string;
    /**
     * `AWS::AutoScaling::ScheduledAction.MaxSize`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-scheduledaction.html#cfn-as-scheduledaction-maxsize
     * @external
     */
    readonly maxSize?: number;
    /**
     * `AWS::AutoScaling::ScheduledAction.MinSize`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-scheduledaction.html#cfn-as-scheduledaction-minsize
     * @external
     */
    readonly minSize?: number;
    /**
     * `AWS::AutoScaling::ScheduledAction.Recurrence`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-scheduledaction.html#cfn-as-scheduledaction-recurrence
     * @external
     */
    readonly recurrence?: string;
    /**
     * `AWS::AutoScaling::ScheduledAction.StartTime`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-scheduledaction.html#cfn-as-scheduledaction-starttime
     * @external
     */
    readonly startTime?: string;
}
/**
 * A CloudFormation `AWS::AutoScaling::ScheduledAction`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-scheduledaction.html
 * @external
 * @cloudformationResource AWS::AutoScaling::ScheduledAction
 */
export declare class CfnScheduledAction extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AutoScaling::ScheduledAction";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnScheduledAction;
    /**
     * `AWS::AutoScaling::ScheduledAction.AutoScalingGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-scheduledaction.html#cfn-as-scheduledaction-asgname
     * @external
     */
    autoScalingGroupName: string;
    /**
     * `AWS::AutoScaling::ScheduledAction.DesiredCapacity`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-scheduledaction.html#cfn-as-scheduledaction-desiredcapacity
     * @external
     */
    desiredCapacity: number | undefined;
    /**
     * `AWS::AutoScaling::ScheduledAction.EndTime`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-scheduledaction.html#cfn-as-scheduledaction-endtime
     * @external
     */
    endTime: string | undefined;
    /**
     * `AWS::AutoScaling::ScheduledAction.MaxSize`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-scheduledaction.html#cfn-as-scheduledaction-maxsize
     * @external
     */
    maxSize: number | undefined;
    /**
     * `AWS::AutoScaling::ScheduledAction.MinSize`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-scheduledaction.html#cfn-as-scheduledaction-minsize
     * @external
     */
    minSize: number | undefined;
    /**
     * `AWS::AutoScaling::ScheduledAction.Recurrence`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-scheduledaction.html#cfn-as-scheduledaction-recurrence
     * @external
     */
    recurrence: string | undefined;
    /**
     * `AWS::AutoScaling::ScheduledAction.StartTime`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-scheduledaction.html#cfn-as-scheduledaction-starttime
     * @external
     */
    startTime: string | undefined;
    /**
     * Create a new `AWS::AutoScaling::ScheduledAction`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnScheduledActionProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
