import * as cdk from "../../core";
import { Construct } from 'constructs';
import { IMesh } from './mesh';
import { IVirtualNode } from './virtual-node';
import { IVirtualRouter } from './virtual-router';
/**
 * (experimental) Represents the interface which all VirtualService based classes MUST implement.
 *
 * @experimental
 */
export interface IVirtualService extends cdk.IResource {
    /**
     * (experimental) The name of the VirtualService.
     *
     * @experimental
     * @attribute true
     */
    readonly virtualServiceName: string;
    /**
     * (experimental) The Amazon Resource Name (ARN) for the virtual service.
     *
     * @experimental
     * @attribute true
     */
    readonly virtualServiceArn: string;
}
/**
 * (experimental) The base properties which all classes in VirtualService will inherit from.
 *
 * @experimental
 */
export interface VirtualServiceBaseProps {
    /**
     * (experimental) The name of the VirtualService.
     *
     * It is recommended this follows the fully-qualified domain name format,
     * such as "my-service.default.svc.cluster.local".
     *
     * @default - A name is automatically generated
     * @experimental
     * @example
     *
     * service.domain.local
     */
    readonly virtualServiceName?: string;
    /**
     * (experimental) The VirtualRouter which the VirtualService uses as provider.
     *
     * @default - At most one of virtualRouter and virtualNode is allowed.
     * @experimental
     */
    readonly virtualRouter?: IVirtualRouter;
    /**
     * (experimental) The VirtualNode attached to the virtual service.
     *
     * @default - At most one of virtualRouter and virtualNode is allowed.
     * @experimental
     */
    readonly virtualNode?: IVirtualNode;
}
/**
 * (experimental) The properties applied to the VirtualService being define.
 *
 * @experimental
 */
export interface VirtualServiceProps extends VirtualServiceBaseProps {
    /**
     * (experimental) The AppMesh mesh name for which the VirtualService belongs to.
     *
     * @experimental
     */
    readonly mesh: IMesh;
}
/**
 * (experimental) VirtualService represents a service inside an AppMesh.
 *
 * It routes traffic either to a Virtual Node or to a Virtual Router.
 *
 * @see https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_services.html
 * @experimental
 */
export declare class VirtualService extends cdk.Resource implements IVirtualService {
    /**
     * (experimental) Import an existing VirtualService given an ARN.
     *
     * @experimental
     */
    static fromVirtualServiceArn(scope: Construct, id: string, virtualServiceArn: string): IVirtualService;
    /**
     * (experimental) Import an existing VirtualService given mesh and service names.
     *
     * @experimental
     */
    static fromVirtualServiceName(scope: Construct, id: string, meshName: string, virtualServiceName: string): IVirtualService;
    /**
     * (experimental) The name of the VirtualService, it is recommended this follows the fully-qualified domain name format.
     *
     * @experimental
     */
    readonly virtualServiceName: string;
    /**
     * (experimental) The Amazon Resource Name (ARN) for the virtual service.
     *
     * @experimental
     */
    readonly virtualServiceArn: string;
    private readonly virtualServiceProvider?;
    private readonly mesh;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: VirtualServiceProps);
    private addVirtualRouter;
    private addVirtualNode;
}
