import * as cdk from "../../core";
import { Construct } from 'constructs';
import { IMesh } from './mesh';
import { IVirtualNode } from './virtual-node';
import { IVirtualRouter } from './virtual-router';
/**
 * (experimental) Interface for which all Route based classes MUST implement.
 *
 * @experimental
 */
export interface IRoute extends cdk.IResource {
    /**
     * (experimental) The name of the route.
     *
     * @experimental
     * @attribute true
     */
    readonly routeName: string;
    /**
     * (experimental) The Amazon Resource Name (ARN) for the route.
     *
     * @experimental
     * @attribute true
     */
    readonly routeArn: string;
}
/**
 * (experimental) Base interface properties for all Routes.
 *
 * @experimental
 */
export interface RouteBaseProps {
    /**
     * (experimental) The name of the route.
     *
     * @default - An automatically generated name
     * @experimental
     */
    readonly routeName?: string;
    /**
     * (experimental) The path prefix to match for the route.
     *
     * @default "/" if http otherwise none
     * @experimental
     */
    readonly prefix?: string;
    /**
     * (experimental) Array of weighted route targets.
     *
     * @experimental
     * @requires minimum of 1
     */
    readonly routeTargets: WeightedTargetProps[];
    /**
     * (experimental) Weather the route is HTTP based.
     *
     * @default - HTTP if `prefix` is given, TCP otherwise
     * @experimental
     */
    readonly routeType?: RouteType;
}
/**
 * (experimental) Type of route.
 *
 * @experimental
 */
export declare enum RouteType {
    /**
     * (experimental) HTTP route.
     *
     * @experimental
     */
    HTTP = "http",
    /**
     * (experimental) TCP route.
     *
     * @experimental
     */
    TCP = "tcp"
}
/**
 * (experimental) Properties for the Weighted Targets in the route.
 *
 * @experimental
 */
export interface WeightedTargetProps {
    /**
     * (experimental) The VirtualNode the route points to.
     *
     * @experimental
     */
    readonly virtualNode: IVirtualNode;
    /**
     * (experimental) The weight for the target.
     *
     * @default 1
     * @experimental
     */
    readonly weight?: number;
}
/**
 * (experimental) Properties to define new Routes.
 *
 * @experimental
 */
export interface RouteProps extends RouteBaseProps {
    /**
     * (experimental) The service mesh to define the route in.
     *
     * @experimental
     */
    readonly mesh: IMesh;
    /**
     * (experimental) The virtual router in which to define the route.
     *
     * @experimental
     */
    readonly virtualRouter: IVirtualRouter;
}
/**
 * (experimental) Route represents a new or existing route attached to a VirtualRouter and Mesh.
 *
 * @see https://docs.aws.amazon.com/app-mesh/latest/userguide/routes.html
 * @experimental
 */
export declare class Route extends cdk.Resource implements IRoute {
    /**
     * (experimental) Import an existing route given an ARN.
     *
     * @experimental
     */
    static fromRouteArn(scope: Construct, id: string, routeArn: string): IRoute;
    /**
     * (experimental) Import an existing route given its name.
     *
     * @experimental
     */
    static fromRouteName(scope: Construct, id: string, meshName: string, virtualRouterName: string, routeName: string): IRoute;
    /**
     * (experimental) The name of the route.
     *
     * @experimental
     */
    readonly routeName: string;
    /**
     * (experimental) The Amazon Resource Name (ARN) for the route.
     *
     * @experimental
     */
    readonly routeArn: string;
    /**
     * (experimental) The virtual router this route is a part of.
     *
     * @experimental
     */
    readonly virtualRouter: IVirtualRouter;
    private readonly weightedTargets;
    private readonly httpRoute?;
    private readonly tcpRoute?;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: RouteProps);
    /**
     * Utility method to add weighted route targets to an existing route
     */
    private renderWeightedTargets;
    private renderHttpRoute;
    private renderTcpRoute;
}
