"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GatewayRoute = void 0;
const cdk = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const appmesh_generated_1 = require("./appmesh.generated");
const virtual_gateway_1 = require("./virtual-gateway");
/**
 * (experimental) GatewayRoute represents a new or existing gateway route attached to a VirtualGateway and Mesh.
 *
 * @see https://docs.aws.amazon.com/app-mesh/latest/userguide/gateway-routes.html
 * @experimental
 */
class GatewayRoute extends cdk.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.gatewayRouteName || cdk.Lazy.stringValue({ produce: () => this.node.uniqueId }),
        });
        this.virtualGateway = props.virtualGateway;
        const routeSpecConfig = props.routeSpec.bind(this);
        const gatewayRoute = new appmesh_generated_1.CfnGatewayRoute(this, 'Resource', {
            gatewayRouteName: this.physicalName,
            meshName: props.virtualGateway.mesh.meshName,
            spec: {
                httpRoute: routeSpecConfig.httpSpecConfig,
                http2Route: routeSpecConfig.http2SpecConfig,
                grpcRoute: routeSpecConfig.grpcSpecConfig,
            },
            virtualGatewayName: this.virtualGateway.virtualGatewayName,
        });
        this.gatewayRouteName = this.getResourceNameAttribute(gatewayRoute.attrGatewayRouteName);
        this.gatewayRouteArn = this.getResourceArnAttribute(gatewayRoute.ref, {
            service: 'appmesh',
            resource: `mesh/${props.virtualGateway.mesh.meshName}/virtualRouter/${this.virtualGateway.virtualGatewayName}/gatewayRoute`,
            resourceName: this.physicalName,
        });
    }
    /**
     * (experimental) Import an existing GatewayRoute given an ARN.
     *
     * @experimental
     */
    static fromGatewayRouteArn(scope, id, gatewayRouteArn) {
        return new ImportedGatewayRoute(scope, id, { gatewayRouteArn });
    }
}
exports.GatewayRoute = GatewayRoute;
/**
 * Represents an imported IGatewayRoute
 */
class ImportedGatewayRoute extends cdk.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        if (props.gatewayRouteArn) {
            this.gatewayRouteArn = props.gatewayRouteArn;
            this.gatewayRouteName = cdk.Fn.select(4, cdk.Fn.split('/', cdk.Stack.of(scope).parseArn(props.gatewayRouteArn).resourceName));
            this.virtualGateway = virtual_gateway_1.VirtualGateway.fromVirtualGatewayArn(this, 'virtualGateway', props.gatewayRouteArn);
        }
        else {
            throw new Error('Need gatewayRouteArn');
        }
    }
}
//# sourceMappingURL=data:application/json;base64,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