"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GatewayRouteSpec = void 0;
const shared_interfaces_1 = require("./shared-interfaces");
/**
 * (experimental) Used to generate specs with different protocols for a GatewayRoute.
 *
 * @experimental
 */
class GatewayRouteSpec {
    /**
     * (experimental) Creates an HTTP Based GatewayRoute.
     *
     * @param props - no http gateway route.
     * @experimental
     */
    static httpRouteSpec(props) {
        return new HttpGatewayRouteSpec(props, shared_interfaces_1.Protocol.HTTP);
    }
    /**
     * (experimental) Creates an HTTP2 Based GatewayRoute.
     *
     * @param props - no http2 gateway route.
     * @experimental
     */
    static http2RouteSpec(props) {
        return new HttpGatewayRouteSpec(props, shared_interfaces_1.Protocol.HTTP2);
    }
    /**
     * (experimental) Creates an GRPC Based GatewayRoute.
     *
     * @param props - no grpc gateway route.
     * @experimental
     */
    static grpcRouteSpec(props) {
        return new GrpcGatewayRouteSpec(props);
    }
}
exports.GatewayRouteSpec = GatewayRouteSpec;
class HttpGatewayRouteSpec extends GatewayRouteSpec {
    constructor(props, protocol) {
        super();
        this.routeTarget = props.routeTarget;
        this.routeType = protocol;
        this.match = props.match;
    }
    bind(_scope) {
        const prefixPath = this.match ? this.match.prefixPath : '/';
        if (prefixPath[0] != '/') {
            throw new Error(`Prefix Path must start with \'/\', got: ${prefixPath}`);
        }
        const httpConfig = {
            match: {
                prefix: prefixPath,
            },
            action: {
                target: {
                    virtualService: {
                        virtualServiceName: this.routeTarget.virtualServiceName,
                    },
                },
            },
        };
        return {
            httpSpecConfig: this.routeType === shared_interfaces_1.Protocol.HTTP ? httpConfig : undefined,
            http2SpecConfig: this.routeType === shared_interfaces_1.Protocol.HTTP2 ? httpConfig : undefined,
        };
    }
}
class GrpcGatewayRouteSpec extends GatewayRouteSpec {
    constructor(props) {
        super();
        this.match = props.match;
        this.routeTarget = props.routeTarget;
    }
    bind(_scope) {
        return {
            grpcSpecConfig: {
                action: {
                    target: {
                        virtualService: {
                            virtualServiceName: this.routeTarget.virtualServiceName,
                        },
                    },
                },
                match: {
                    serviceName: this.match.serviceName,
                },
            },
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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