import * as cdk from "../../core";
import * as cfn_parse from "../../core/lib/cfn-parse";
/**
 * Properties for defining a `AWS::AppMesh::GatewayRoute`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html
 * @external
 */
export interface CfnGatewayRouteProps {
    /**
     * `AWS::AppMesh::GatewayRoute.GatewayRouteName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html#cfn-appmesh-gatewayroute-gatewayroutename
     * @external
     */
    readonly gatewayRouteName: string;
    /**
     * `AWS::AppMesh::GatewayRoute.MeshName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html#cfn-appmesh-gatewayroute-meshname
     * @external
     */
    readonly meshName: string;
    /**
     * `AWS::AppMesh::GatewayRoute.Spec`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html#cfn-appmesh-gatewayroute-spec
     * @external
     */
    readonly spec: CfnGatewayRoute.GatewayRouteSpecProperty | cdk.IResolvable;
    /**
     * `AWS::AppMesh::GatewayRoute.VirtualGatewayName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html#cfn-appmesh-gatewayroute-virtualgatewayname
     * @external
     */
    readonly virtualGatewayName: string;
    /**
     * `AWS::AppMesh::GatewayRoute.MeshOwner`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html#cfn-appmesh-gatewayroute-meshowner
     * @external
     */
    readonly meshOwner?: string;
    /**
     * `AWS::AppMesh::GatewayRoute.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html#cfn-appmesh-gatewayroute-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::AppMesh::GatewayRoute`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html
 * @external
 * @cloudformationResource AWS::AppMesh::GatewayRoute
 */
export declare class CfnGatewayRoute extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AppMesh::GatewayRoute";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnGatewayRoute;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute GatewayRouteName
     */
    readonly attrGatewayRouteName: string;
    /**
     * @external
     * @cloudformationAttribute MeshName
     */
    readonly attrMeshName: string;
    /**
     * @external
     * @cloudformationAttribute MeshOwner
     */
    readonly attrMeshOwner: string;
    /**
     * @external
     * @cloudformationAttribute ResourceOwner
     */
    readonly attrResourceOwner: string;
    /**
     * @external
     * @cloudformationAttribute Uid
     */
    readonly attrUid: string;
    /**
     * @external
     * @cloudformationAttribute VirtualGatewayName
     */
    readonly attrVirtualGatewayName: string;
    /**
     * `AWS::AppMesh::GatewayRoute.GatewayRouteName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html#cfn-appmesh-gatewayroute-gatewayroutename
     * @external
     */
    gatewayRouteName: string;
    /**
     * `AWS::AppMesh::GatewayRoute.MeshName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html#cfn-appmesh-gatewayroute-meshname
     * @external
     */
    meshName: string;
    /**
     * `AWS::AppMesh::GatewayRoute.Spec`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html#cfn-appmesh-gatewayroute-spec
     * @external
     */
    spec: CfnGatewayRoute.GatewayRouteSpecProperty | cdk.IResolvable;
    /**
     * `AWS::AppMesh::GatewayRoute.VirtualGatewayName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html#cfn-appmesh-gatewayroute-virtualgatewayname
     * @external
     */
    virtualGatewayName: string;
    /**
     * `AWS::AppMesh::GatewayRoute.MeshOwner`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html#cfn-appmesh-gatewayroute-meshowner
     * @external
     */
    meshOwner: string | undefined;
    /**
     * `AWS::AppMesh::GatewayRoute.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html#cfn-appmesh-gatewayroute-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::AppMesh::GatewayRoute`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnGatewayRouteProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::AppMesh::GatewayRoute`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html
 * @external
 * @cloudformationResource AWS::AppMesh::GatewayRoute
 */
export declare namespace CfnGatewayRoute {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutespec.html
     * @external
     */
    interface GatewayRouteSpecProperty {
        /**
         * `CfnGatewayRoute.GatewayRouteSpecProperty.GrpcRoute`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutespec.html#cfn-appmesh-gatewayroute-gatewayroutespec-grpcroute
         * @external
         */
        readonly grpcRoute?: CfnGatewayRoute.GrpcGatewayRouteProperty | cdk.IResolvable;
        /**
         * `CfnGatewayRoute.GatewayRouteSpecProperty.Http2Route`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutespec.html#cfn-appmesh-gatewayroute-gatewayroutespec-http2route
         * @external
         */
        readonly http2Route?: CfnGatewayRoute.HttpGatewayRouteProperty | cdk.IResolvable;
        /**
         * `CfnGatewayRoute.GatewayRouteSpecProperty.HttpRoute`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutespec.html#cfn-appmesh-gatewayroute-gatewayroutespec-httproute
         * @external
         */
        readonly httpRoute?: CfnGatewayRoute.HttpGatewayRouteProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::GatewayRoute`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html
 * @external
 * @cloudformationResource AWS::AppMesh::GatewayRoute
 */
export declare namespace CfnGatewayRoute {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutetarget.html
     * @external
     */
    interface GatewayRouteTargetProperty {
        /**
         * `CfnGatewayRoute.GatewayRouteTargetProperty.VirtualService`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutetarget.html#cfn-appmesh-gatewayroute-gatewayroutetarget-virtualservice
         * @external
         */
        readonly virtualService: CfnGatewayRoute.GatewayRouteVirtualServiceProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::GatewayRoute`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html
 * @external
 * @cloudformationResource AWS::AppMesh::GatewayRoute
 */
export declare namespace CfnGatewayRoute {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutevirtualservice.html
     * @external
     */
    interface GatewayRouteVirtualServiceProperty {
        /**
         * `CfnGatewayRoute.GatewayRouteVirtualServiceProperty.VirtualServiceName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutevirtualservice.html#cfn-appmesh-gatewayroute-gatewayroutevirtualservice-virtualservicename
         * @external
         */
        readonly virtualServiceName: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::GatewayRoute`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html
 * @external
 * @cloudformationResource AWS::AppMesh::GatewayRoute
 */
export declare namespace CfnGatewayRoute {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-grpcgatewayroute.html
     * @external
     */
    interface GrpcGatewayRouteProperty {
        /**
         * `CfnGatewayRoute.GrpcGatewayRouteProperty.Action`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-grpcgatewayroute.html#cfn-appmesh-gatewayroute-grpcgatewayroute-action
         * @external
         */
        readonly action: CfnGatewayRoute.GrpcGatewayRouteActionProperty | cdk.IResolvable;
        /**
         * `CfnGatewayRoute.GrpcGatewayRouteProperty.Match`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-grpcgatewayroute.html#cfn-appmesh-gatewayroute-grpcgatewayroute-match
         * @external
         */
        readonly match: CfnGatewayRoute.GrpcGatewayRouteMatchProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::GatewayRoute`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html
 * @external
 * @cloudformationResource AWS::AppMesh::GatewayRoute
 */
export declare namespace CfnGatewayRoute {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-grpcgatewayrouteaction.html
     * @external
     */
    interface GrpcGatewayRouteActionProperty {
        /**
         * `CfnGatewayRoute.GrpcGatewayRouteActionProperty.Target`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-grpcgatewayrouteaction.html#cfn-appmesh-gatewayroute-grpcgatewayrouteaction-target
         * @external
         */
        readonly target: CfnGatewayRoute.GatewayRouteTargetProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::GatewayRoute`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html
 * @external
 * @cloudformationResource AWS::AppMesh::GatewayRoute
 */
export declare namespace CfnGatewayRoute {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-grpcgatewayroutematch.html
     * @external
     */
    interface GrpcGatewayRouteMatchProperty {
        /**
         * `CfnGatewayRoute.GrpcGatewayRouteMatchProperty.ServiceName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-grpcgatewayroutematch.html#cfn-appmesh-gatewayroute-grpcgatewayroutematch-servicename
         * @external
         */
        readonly serviceName?: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::GatewayRoute`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html
 * @external
 * @cloudformationResource AWS::AppMesh::GatewayRoute
 */
export declare namespace CfnGatewayRoute {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayroute.html
     * @external
     */
    interface HttpGatewayRouteProperty {
        /**
         * `CfnGatewayRoute.HttpGatewayRouteProperty.Action`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayroute.html#cfn-appmesh-gatewayroute-httpgatewayroute-action
         * @external
         */
        readonly action: CfnGatewayRoute.HttpGatewayRouteActionProperty | cdk.IResolvable;
        /**
         * `CfnGatewayRoute.HttpGatewayRouteProperty.Match`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayroute.html#cfn-appmesh-gatewayroute-httpgatewayroute-match
         * @external
         */
        readonly match: CfnGatewayRoute.HttpGatewayRouteMatchProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::GatewayRoute`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html
 * @external
 * @cloudformationResource AWS::AppMesh::GatewayRoute
 */
export declare namespace CfnGatewayRoute {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayrouteaction.html
     * @external
     */
    interface HttpGatewayRouteActionProperty {
        /**
         * `CfnGatewayRoute.HttpGatewayRouteActionProperty.Target`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayrouteaction.html#cfn-appmesh-gatewayroute-httpgatewayrouteaction-target
         * @external
         */
        readonly target: CfnGatewayRoute.GatewayRouteTargetProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::GatewayRoute`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html
 * @external
 * @cloudformationResource AWS::AppMesh::GatewayRoute
 */
export declare namespace CfnGatewayRoute {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayroutematch.html
     * @external
     */
    interface HttpGatewayRouteMatchProperty {
        /**
         * `CfnGatewayRoute.HttpGatewayRouteMatchProperty.Prefix`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayroutematch.html#cfn-appmesh-gatewayroute-httpgatewayroutematch-prefix
         * @external
         */
        readonly prefix: string;
    }
}
/**
 * Properties for defining a `AWS::AppMesh::Mesh`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-mesh.html
 * @external
 */
export interface CfnMeshProps {
    /**
     * `AWS::AppMesh::Mesh.MeshName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-mesh.html#cfn-appmesh-mesh-meshname
     * @external
     */
    readonly meshName: string;
    /**
     * `AWS::AppMesh::Mesh.Spec`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-mesh.html#cfn-appmesh-mesh-spec
     * @external
     */
    readonly spec?: CfnMesh.MeshSpecProperty | cdk.IResolvable;
    /**
     * `AWS::AppMesh::Mesh.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-mesh.html#cfn-appmesh-mesh-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::AppMesh::Mesh`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-mesh.html
 * @external
 * @cloudformationResource AWS::AppMesh::Mesh
 */
export declare class CfnMesh extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AppMesh::Mesh";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnMesh;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute MeshName
     */
    readonly attrMeshName: string;
    /**
     * @external
     * @cloudformationAttribute MeshOwner
     */
    readonly attrMeshOwner: string;
    /**
     * @external
     * @cloudformationAttribute ResourceOwner
     */
    readonly attrResourceOwner: string;
    /**
     * @external
     * @cloudformationAttribute Uid
     */
    readonly attrUid: string;
    /**
     * `AWS::AppMesh::Mesh.MeshName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-mesh.html#cfn-appmesh-mesh-meshname
     * @external
     */
    meshName: string;
    /**
     * `AWS::AppMesh::Mesh.Spec`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-mesh.html#cfn-appmesh-mesh-spec
     * @external
     */
    spec: CfnMesh.MeshSpecProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::AppMesh::Mesh.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-mesh.html#cfn-appmesh-mesh-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::AppMesh::Mesh`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnMeshProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::AppMesh::Mesh`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-mesh.html
 * @external
 * @cloudformationResource AWS::AppMesh::Mesh
 */
export declare namespace CfnMesh {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-mesh-egressfilter.html
     * @external
     */
    interface EgressFilterProperty {
        /**
         * `CfnMesh.EgressFilterProperty.Type`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-mesh-egressfilter.html#cfn-appmesh-mesh-egressfilter-type
         * @external
         */
        readonly type: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::Mesh`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-mesh.html
 * @external
 * @cloudformationResource AWS::AppMesh::Mesh
 */
export declare namespace CfnMesh {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-mesh-meshspec.html
     * @external
     */
    interface MeshSpecProperty {
        /**
         * `CfnMesh.MeshSpecProperty.EgressFilter`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-mesh-meshspec.html#cfn-appmesh-mesh-meshspec-egressfilter
         * @external
         */
        readonly egressFilter?: CfnMesh.EgressFilterProperty | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::AppMesh::Route`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html
 * @external
 */
export interface CfnRouteProps {
    /**
     * `AWS::AppMesh::Route.MeshName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html#cfn-appmesh-route-meshname
     * @external
     */
    readonly meshName: string;
    /**
     * `AWS::AppMesh::Route.RouteName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html#cfn-appmesh-route-routename
     * @external
     */
    readonly routeName: string;
    /**
     * `AWS::AppMesh::Route.Spec`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html#cfn-appmesh-route-spec
     * @external
     */
    readonly spec: CfnRoute.RouteSpecProperty | cdk.IResolvable;
    /**
     * `AWS::AppMesh::Route.VirtualRouterName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html#cfn-appmesh-route-virtualroutername
     * @external
     */
    readonly virtualRouterName: string;
    /**
     * `AWS::AppMesh::Route.MeshOwner`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html#cfn-appmesh-route-meshowner
     * @external
     */
    readonly meshOwner?: string;
    /**
     * `AWS::AppMesh::Route.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html#cfn-appmesh-route-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::AppMesh::Route`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html
 * @external
 * @cloudformationResource AWS::AppMesh::Route
 */
export declare class CfnRoute extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AppMesh::Route";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnRoute;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute MeshName
     */
    readonly attrMeshName: string;
    /**
     * @external
     * @cloudformationAttribute MeshOwner
     */
    readonly attrMeshOwner: string;
    /**
     * @external
     * @cloudformationAttribute ResourceOwner
     */
    readonly attrResourceOwner: string;
    /**
     * @external
     * @cloudformationAttribute RouteName
     */
    readonly attrRouteName: string;
    /**
     * @external
     * @cloudformationAttribute Uid
     */
    readonly attrUid: string;
    /**
     * @external
     * @cloudformationAttribute VirtualRouterName
     */
    readonly attrVirtualRouterName: string;
    /**
     * `AWS::AppMesh::Route.MeshName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html#cfn-appmesh-route-meshname
     * @external
     */
    meshName: string;
    /**
     * `AWS::AppMesh::Route.RouteName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html#cfn-appmesh-route-routename
     * @external
     */
    routeName: string;
    /**
     * `AWS::AppMesh::Route.Spec`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html#cfn-appmesh-route-spec
     * @external
     */
    spec: CfnRoute.RouteSpecProperty | cdk.IResolvable;
    /**
     * `AWS::AppMesh::Route.VirtualRouterName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html#cfn-appmesh-route-virtualroutername
     * @external
     */
    virtualRouterName: string;
    /**
     * `AWS::AppMesh::Route.MeshOwner`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html#cfn-appmesh-route-meshowner
     * @external
     */
    meshOwner: string | undefined;
    /**
     * `AWS::AppMesh::Route.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html#cfn-appmesh-route-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::AppMesh::Route`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnRouteProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::AppMesh::Route`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html
 * @external
 * @cloudformationResource AWS::AppMesh::Route
 */
export declare namespace CfnRoute {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-duration.html
     * @external
     */
    interface DurationProperty {
        /**
         * `CfnRoute.DurationProperty.Unit`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-duration.html#cfn-appmesh-route-duration-unit
         * @external
         */
        readonly unit: string;
        /**
         * `CfnRoute.DurationProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-duration.html#cfn-appmesh-route-duration-value
         * @external
         */
        readonly value: number;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::Route`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html
 * @external
 * @cloudformationResource AWS::AppMesh::Route
 */
export declare namespace CfnRoute {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcretrypolicy.html
     * @external
     */
    interface GrpcRetryPolicyProperty {
        /**
         * `CfnRoute.GrpcRetryPolicyProperty.GrpcRetryEvents`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcretrypolicy.html#cfn-appmesh-route-grpcretrypolicy-grpcretryevents
         * @external
         */
        readonly grpcRetryEvents?: string[];
        /**
         * `CfnRoute.GrpcRetryPolicyProperty.HttpRetryEvents`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcretrypolicy.html#cfn-appmesh-route-grpcretrypolicy-httpretryevents
         * @external
         */
        readonly httpRetryEvents?: string[];
        /**
         * `CfnRoute.GrpcRetryPolicyProperty.MaxRetries`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcretrypolicy.html#cfn-appmesh-route-grpcretrypolicy-maxretries
         * @external
         */
        readonly maxRetries: number;
        /**
         * `CfnRoute.GrpcRetryPolicyProperty.PerRetryTimeout`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcretrypolicy.html#cfn-appmesh-route-grpcretrypolicy-perretrytimeout
         * @external
         */
        readonly perRetryTimeout: CfnRoute.DurationProperty | cdk.IResolvable;
        /**
         * `CfnRoute.GrpcRetryPolicyProperty.TcpRetryEvents`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcretrypolicy.html#cfn-appmesh-route-grpcretrypolicy-tcpretryevents
         * @external
         */
        readonly tcpRetryEvents?: string[];
    }
}
/**
 * A CloudFormation `AWS::AppMesh::Route`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html
 * @external
 * @cloudformationResource AWS::AppMesh::Route
 */
export declare namespace CfnRoute {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroute.html
     * @external
     */
    interface GrpcRouteProperty {
        /**
         * `CfnRoute.GrpcRouteProperty.Action`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroute.html#cfn-appmesh-route-grpcroute-action
         * @external
         */
        readonly action: CfnRoute.GrpcRouteActionProperty | cdk.IResolvable;
        /**
         * `CfnRoute.GrpcRouteProperty.Match`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroute.html#cfn-appmesh-route-grpcroute-match
         * @external
         */
        readonly match: CfnRoute.GrpcRouteMatchProperty | cdk.IResolvable;
        /**
         * `CfnRoute.GrpcRouteProperty.RetryPolicy`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroute.html#cfn-appmesh-route-grpcroute-retrypolicy
         * @external
         */
        readonly retryPolicy?: CfnRoute.GrpcRetryPolicyProperty | cdk.IResolvable;
        /**
         * `CfnRoute.GrpcRouteProperty.Timeout`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroute.html#cfn-appmesh-route-grpcroute-timeout
         * @external
         */
        readonly timeout?: CfnRoute.GrpcTimeoutProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::Route`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html
 * @external
 * @cloudformationResource AWS::AppMesh::Route
 */
export declare namespace CfnRoute {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcrouteaction.html
     * @external
     */
    interface GrpcRouteActionProperty {
        /**
         * `CfnRoute.GrpcRouteActionProperty.WeightedTargets`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcrouteaction.html#cfn-appmesh-route-grpcrouteaction-weightedtargets
         * @external
         */
        readonly weightedTargets: Array<CfnRoute.WeightedTargetProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::Route`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html
 * @external
 * @cloudformationResource AWS::AppMesh::Route
 */
export declare namespace CfnRoute {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutematch.html
     * @external
     */
    interface GrpcRouteMatchProperty {
        /**
         * `CfnRoute.GrpcRouteMatchProperty.Metadata`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutematch.html#cfn-appmesh-route-grpcroutematch-metadata
         * @external
         */
        readonly metadata?: Array<CfnRoute.GrpcRouteMetadataProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnRoute.GrpcRouteMatchProperty.MethodName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutematch.html#cfn-appmesh-route-grpcroutematch-methodname
         * @external
         */
        readonly methodName?: string;
        /**
         * `CfnRoute.GrpcRouteMatchProperty.ServiceName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutematch.html#cfn-appmesh-route-grpcroutematch-servicename
         * @external
         */
        readonly serviceName?: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::Route`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html
 * @external
 * @cloudformationResource AWS::AppMesh::Route
 */
export declare namespace CfnRoute {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutemetadata.html
     * @external
     */
    interface GrpcRouteMetadataProperty {
        /**
         * `CfnRoute.GrpcRouteMetadataProperty.Invert`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutemetadata.html#cfn-appmesh-route-grpcroutemetadata-invert
         * @external
         */
        readonly invert?: boolean | cdk.IResolvable;
        /**
         * `CfnRoute.GrpcRouteMetadataProperty.Match`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutemetadata.html#cfn-appmesh-route-grpcroutemetadata-match
         * @external
         */
        readonly match?: CfnRoute.GrpcRouteMetadataMatchMethodProperty | cdk.IResolvable;
        /**
         * `CfnRoute.GrpcRouteMetadataProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutemetadata.html#cfn-appmesh-route-grpcroutemetadata-name
         * @external
         */
        readonly name: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::Route`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html
 * @external
 * @cloudformationResource AWS::AppMesh::Route
 */
export declare namespace CfnRoute {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutemetadatamatchmethod.html
     * @external
     */
    interface GrpcRouteMetadataMatchMethodProperty {
        /**
         * `CfnRoute.GrpcRouteMetadataMatchMethodProperty.Exact`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutemetadatamatchmethod.html#cfn-appmesh-route-grpcroutemetadatamatchmethod-exact
         * @external
         */
        readonly exact?: string;
        /**
         * `CfnRoute.GrpcRouteMetadataMatchMethodProperty.Prefix`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutemetadatamatchmethod.html#cfn-appmesh-route-grpcroutemetadatamatchmethod-prefix
         * @external
         */
        readonly prefix?: string;
        /**
         * `CfnRoute.GrpcRouteMetadataMatchMethodProperty.Range`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutemetadatamatchmethod.html#cfn-appmesh-route-grpcroutemetadatamatchmethod-range
         * @external
         */
        readonly range?: CfnRoute.MatchRangeProperty | cdk.IResolvable;
        /**
         * `CfnRoute.GrpcRouteMetadataMatchMethodProperty.Regex`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutemetadatamatchmethod.html#cfn-appmesh-route-grpcroutemetadatamatchmethod-regex
         * @external
         */
        readonly regex?: string;
        /**
         * `CfnRoute.GrpcRouteMetadataMatchMethodProperty.Suffix`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutemetadatamatchmethod.html#cfn-appmesh-route-grpcroutemetadatamatchmethod-suffix
         * @external
         */
        readonly suffix?: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::Route`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html
 * @external
 * @cloudformationResource AWS::AppMesh::Route
 */
export declare namespace CfnRoute {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpctimeout.html
     * @external
     */
    interface GrpcTimeoutProperty {
        /**
         * `CfnRoute.GrpcTimeoutProperty.Idle`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpctimeout.html#cfn-appmesh-route-grpctimeout-idle
         * @external
         */
        readonly idle?: CfnRoute.DurationProperty | cdk.IResolvable;
        /**
         * `CfnRoute.GrpcTimeoutProperty.PerRequest`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpctimeout.html#cfn-appmesh-route-grpctimeout-perrequest
         * @external
         */
        readonly perRequest?: CfnRoute.DurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::Route`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html
 * @external
 * @cloudformationResource AWS::AppMesh::Route
 */
export declare namespace CfnRoute {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-headermatchmethod.html
     * @external
     */
    interface HeaderMatchMethodProperty {
        /**
         * `CfnRoute.HeaderMatchMethodProperty.Exact`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-headermatchmethod.html#cfn-appmesh-route-headermatchmethod-exact
         * @external
         */
        readonly exact?: string;
        /**
         * `CfnRoute.HeaderMatchMethodProperty.Prefix`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-headermatchmethod.html#cfn-appmesh-route-headermatchmethod-prefix
         * @external
         */
        readonly prefix?: string;
        /**
         * `CfnRoute.HeaderMatchMethodProperty.Range`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-headermatchmethod.html#cfn-appmesh-route-headermatchmethod-range
         * @external
         */
        readonly range?: CfnRoute.MatchRangeProperty | cdk.IResolvable;
        /**
         * `CfnRoute.HeaderMatchMethodProperty.Regex`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-headermatchmethod.html#cfn-appmesh-route-headermatchmethod-regex
         * @external
         */
        readonly regex?: string;
        /**
         * `CfnRoute.HeaderMatchMethodProperty.Suffix`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-headermatchmethod.html#cfn-appmesh-route-headermatchmethod-suffix
         * @external
         */
        readonly suffix?: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::Route`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html
 * @external
 * @cloudformationResource AWS::AppMesh::Route
 */
export declare namespace CfnRoute {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httpretrypolicy.html
     * @external
     */
    interface HttpRetryPolicyProperty {
        /**
         * `CfnRoute.HttpRetryPolicyProperty.HttpRetryEvents`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httpretrypolicy.html#cfn-appmesh-route-httpretrypolicy-httpretryevents
         * @external
         */
        readonly httpRetryEvents?: string[];
        /**
         * `CfnRoute.HttpRetryPolicyProperty.MaxRetries`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httpretrypolicy.html#cfn-appmesh-route-httpretrypolicy-maxretries
         * @external
         */
        readonly maxRetries: number;
        /**
         * `CfnRoute.HttpRetryPolicyProperty.PerRetryTimeout`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httpretrypolicy.html#cfn-appmesh-route-httpretrypolicy-perretrytimeout
         * @external
         */
        readonly perRetryTimeout: CfnRoute.DurationProperty | cdk.IResolvable;
        /**
         * `CfnRoute.HttpRetryPolicyProperty.TcpRetryEvents`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httpretrypolicy.html#cfn-appmesh-route-httpretrypolicy-tcpretryevents
         * @external
         */
        readonly tcpRetryEvents?: string[];
    }
}
/**
 * A CloudFormation `AWS::AppMesh::Route`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html
 * @external
 * @cloudformationResource AWS::AppMesh::Route
 */
export declare namespace CfnRoute {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httproute.html
     * @external
     */
    interface HttpRouteProperty {
        /**
         * `CfnRoute.HttpRouteProperty.Action`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httproute.html#cfn-appmesh-route-httproute-action
         * @external
         */
        readonly action: CfnRoute.HttpRouteActionProperty | cdk.IResolvable;
        /**
         * `CfnRoute.HttpRouteProperty.Match`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httproute.html#cfn-appmesh-route-httproute-match
         * @external
         */
        readonly match: CfnRoute.HttpRouteMatchProperty | cdk.IResolvable;
        /**
         * `CfnRoute.HttpRouteProperty.RetryPolicy`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httproute.html#cfn-appmesh-route-httproute-retrypolicy
         * @external
         */
        readonly retryPolicy?: CfnRoute.HttpRetryPolicyProperty | cdk.IResolvable;
        /**
         * `CfnRoute.HttpRouteProperty.Timeout`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httproute.html#cfn-appmesh-route-httproute-timeout
         * @external
         */
        readonly timeout?: CfnRoute.HttpTimeoutProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::Route`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html
 * @external
 * @cloudformationResource AWS::AppMesh::Route
 */
export declare namespace CfnRoute {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httprouteaction.html
     * @external
     */
    interface HttpRouteActionProperty {
        /**
         * `CfnRoute.HttpRouteActionProperty.WeightedTargets`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httprouteaction.html#cfn-appmesh-route-httprouteaction-weightedtargets
         * @external
         */
        readonly weightedTargets: Array<CfnRoute.WeightedTargetProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::Route`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html
 * @external
 * @cloudformationResource AWS::AppMesh::Route
 */
export declare namespace CfnRoute {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httprouteheader.html
     * @external
     */
    interface HttpRouteHeaderProperty {
        /**
         * `CfnRoute.HttpRouteHeaderProperty.Invert`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httprouteheader.html#cfn-appmesh-route-httprouteheader-invert
         * @external
         */
        readonly invert?: boolean | cdk.IResolvable;
        /**
         * `CfnRoute.HttpRouteHeaderProperty.Match`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httprouteheader.html#cfn-appmesh-route-httprouteheader-match
         * @external
         */
        readonly match?: CfnRoute.HeaderMatchMethodProperty | cdk.IResolvable;
        /**
         * `CfnRoute.HttpRouteHeaderProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httprouteheader.html#cfn-appmesh-route-httprouteheader-name
         * @external
         */
        readonly name: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::Route`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html
 * @external
 * @cloudformationResource AWS::AppMesh::Route
 */
export declare namespace CfnRoute {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httproutematch.html
     * @external
     */
    interface HttpRouteMatchProperty {
        /**
         * `CfnRoute.HttpRouteMatchProperty.Headers`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httproutematch.html#cfn-appmesh-route-httproutematch-headers
         * @external
         */
        readonly headers?: Array<CfnRoute.HttpRouteHeaderProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnRoute.HttpRouteMatchProperty.Method`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httproutematch.html#cfn-appmesh-route-httproutematch-method
         * @external
         */
        readonly method?: string;
        /**
         * `CfnRoute.HttpRouteMatchProperty.Prefix`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httproutematch.html#cfn-appmesh-route-httproutematch-prefix
         * @external
         */
        readonly prefix: string;
        /**
         * `CfnRoute.HttpRouteMatchProperty.Scheme`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httproutematch.html#cfn-appmesh-route-httproutematch-scheme
         * @external
         */
        readonly scheme?: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::Route`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html
 * @external
 * @cloudformationResource AWS::AppMesh::Route
 */
export declare namespace CfnRoute {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httptimeout.html
     * @external
     */
    interface HttpTimeoutProperty {
        /**
         * `CfnRoute.HttpTimeoutProperty.Idle`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httptimeout.html#cfn-appmesh-route-httptimeout-idle
         * @external
         */
        readonly idle?: CfnRoute.DurationProperty | cdk.IResolvable;
        /**
         * `CfnRoute.HttpTimeoutProperty.PerRequest`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httptimeout.html#cfn-appmesh-route-httptimeout-perrequest
         * @external
         */
        readonly perRequest?: CfnRoute.DurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::Route`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html
 * @external
 * @cloudformationResource AWS::AppMesh::Route
 */
export declare namespace CfnRoute {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-matchrange.html
     * @external
     */
    interface MatchRangeProperty {
        /**
         * `CfnRoute.MatchRangeProperty.End`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-matchrange.html#cfn-appmesh-route-matchrange-end
         * @external
         */
        readonly end: number;
        /**
         * `CfnRoute.MatchRangeProperty.Start`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-matchrange.html#cfn-appmesh-route-matchrange-start
         * @external
         */
        readonly start: number;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::Route`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html
 * @external
 * @cloudformationResource AWS::AppMesh::Route
 */
export declare namespace CfnRoute {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-routespec.html
     * @external
     */
    interface RouteSpecProperty {
        /**
         * `CfnRoute.RouteSpecProperty.GrpcRoute`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-routespec.html#cfn-appmesh-route-routespec-grpcroute
         * @external
         */
        readonly grpcRoute?: CfnRoute.GrpcRouteProperty | cdk.IResolvable;
        /**
         * `CfnRoute.RouteSpecProperty.Http2Route`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-routespec.html#cfn-appmesh-route-routespec-http2route
         * @external
         */
        readonly http2Route?: CfnRoute.HttpRouteProperty | cdk.IResolvable;
        /**
         * `CfnRoute.RouteSpecProperty.HttpRoute`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-routespec.html#cfn-appmesh-route-routespec-httproute
         * @external
         */
        readonly httpRoute?: CfnRoute.HttpRouteProperty | cdk.IResolvable;
        /**
         * `CfnRoute.RouteSpecProperty.Priority`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-routespec.html#cfn-appmesh-route-routespec-priority
         * @external
         */
        readonly priority?: number;
        /**
         * `CfnRoute.RouteSpecProperty.TcpRoute`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-routespec.html#cfn-appmesh-route-routespec-tcproute
         * @external
         */
        readonly tcpRoute?: CfnRoute.TcpRouteProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::Route`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html
 * @external
 * @cloudformationResource AWS::AppMesh::Route
 */
export declare namespace CfnRoute {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-tcproute.html
     * @external
     */
    interface TcpRouteProperty {
        /**
         * `CfnRoute.TcpRouteProperty.Action`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-tcproute.html#cfn-appmesh-route-tcproute-action
         * @external
         */
        readonly action: CfnRoute.TcpRouteActionProperty | cdk.IResolvable;
        /**
         * `CfnRoute.TcpRouteProperty.Timeout`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-tcproute.html#cfn-appmesh-route-tcproute-timeout
         * @external
         */
        readonly timeout?: CfnRoute.TcpTimeoutProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::Route`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html
 * @external
 * @cloudformationResource AWS::AppMesh::Route
 */
export declare namespace CfnRoute {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-tcprouteaction.html
     * @external
     */
    interface TcpRouteActionProperty {
        /**
         * `CfnRoute.TcpRouteActionProperty.WeightedTargets`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-tcprouteaction.html#cfn-appmesh-route-tcprouteaction-weightedtargets
         * @external
         */
        readonly weightedTargets: Array<CfnRoute.WeightedTargetProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::Route`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html
 * @external
 * @cloudformationResource AWS::AppMesh::Route
 */
export declare namespace CfnRoute {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-tcptimeout.html
     * @external
     */
    interface TcpTimeoutProperty {
        /**
         * `CfnRoute.TcpTimeoutProperty.Idle`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-tcptimeout.html#cfn-appmesh-route-tcptimeout-idle
         * @external
         */
        readonly idle?: CfnRoute.DurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::Route`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html
 * @external
 * @cloudformationResource AWS::AppMesh::Route
 */
export declare namespace CfnRoute {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-weightedtarget.html
     * @external
     */
    interface WeightedTargetProperty {
        /**
         * `CfnRoute.WeightedTargetProperty.VirtualNode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-weightedtarget.html#cfn-appmesh-route-weightedtarget-virtualnode
         * @external
         */
        readonly virtualNode: string;
        /**
         * `CfnRoute.WeightedTargetProperty.Weight`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-weightedtarget.html#cfn-appmesh-route-weightedtarget-weight
         * @external
         */
        readonly weight: number;
    }
}
/**
 * Properties for defining a `AWS::AppMesh::VirtualGateway`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html
 * @external
 */
export interface CfnVirtualGatewayProps {
    /**
     * `AWS::AppMesh::VirtualGateway.MeshName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html#cfn-appmesh-virtualgateway-meshname
     * @external
     */
    readonly meshName: string;
    /**
     * `AWS::AppMesh::VirtualGateway.Spec`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html#cfn-appmesh-virtualgateway-spec
     * @external
     */
    readonly spec: CfnVirtualGateway.VirtualGatewaySpecProperty | cdk.IResolvable;
    /**
     * `AWS::AppMesh::VirtualGateway.VirtualGatewayName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html#cfn-appmesh-virtualgateway-virtualgatewayname
     * @external
     */
    readonly virtualGatewayName: string;
    /**
     * `AWS::AppMesh::VirtualGateway.MeshOwner`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html#cfn-appmesh-virtualgateway-meshowner
     * @external
     */
    readonly meshOwner?: string;
    /**
     * `AWS::AppMesh::VirtualGateway.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html#cfn-appmesh-virtualgateway-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualGateway`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualGateway
 */
export declare class CfnVirtualGateway extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AppMesh::VirtualGateway";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnVirtualGateway;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute MeshName
     */
    readonly attrMeshName: string;
    /**
     * @external
     * @cloudformationAttribute MeshOwner
     */
    readonly attrMeshOwner: string;
    /**
     * @external
     * @cloudformationAttribute ResourceOwner
     */
    readonly attrResourceOwner: string;
    /**
     * @external
     * @cloudformationAttribute Uid
     */
    readonly attrUid: string;
    /**
     * @external
     * @cloudformationAttribute VirtualGatewayName
     */
    readonly attrVirtualGatewayName: string;
    /**
     * `AWS::AppMesh::VirtualGateway.MeshName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html#cfn-appmesh-virtualgateway-meshname
     * @external
     */
    meshName: string;
    /**
     * `AWS::AppMesh::VirtualGateway.Spec`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html#cfn-appmesh-virtualgateway-spec
     * @external
     */
    spec: CfnVirtualGateway.VirtualGatewaySpecProperty | cdk.IResolvable;
    /**
     * `AWS::AppMesh::VirtualGateway.VirtualGatewayName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html#cfn-appmesh-virtualgateway-virtualgatewayname
     * @external
     */
    virtualGatewayName: string;
    /**
     * `AWS::AppMesh::VirtualGateway.MeshOwner`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html#cfn-appmesh-virtualgateway-meshowner
     * @external
     */
    meshOwner: string | undefined;
    /**
     * `AWS::AppMesh::VirtualGateway.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html#cfn-appmesh-virtualgateway-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::AppMesh::VirtualGateway`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVirtualGatewayProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualGateway`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualGateway
 */
export declare namespace CfnVirtualGateway {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayaccesslog.html
     * @external
     */
    interface VirtualGatewayAccessLogProperty {
        /**
         * `CfnVirtualGateway.VirtualGatewayAccessLogProperty.File`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayaccesslog.html#cfn-appmesh-virtualgateway-virtualgatewayaccesslog-file
         * @external
         */
        readonly file?: CfnVirtualGateway.VirtualGatewayFileAccessLogProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualGateway`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualGateway
 */
export declare namespace CfnVirtualGateway {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaybackenddefaults.html
     * @external
     */
    interface VirtualGatewayBackendDefaultsProperty {
        /**
         * `CfnVirtualGateway.VirtualGatewayBackendDefaultsProperty.ClientPolicy`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaybackenddefaults.html#cfn-appmesh-virtualgateway-virtualgatewaybackenddefaults-clientpolicy
         * @external
         */
        readonly clientPolicy?: CfnVirtualGateway.VirtualGatewayClientPolicyProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualGateway`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualGateway
 */
export declare namespace CfnVirtualGateway {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayclientpolicy.html
     * @external
     */
    interface VirtualGatewayClientPolicyProperty {
        /**
         * `CfnVirtualGateway.VirtualGatewayClientPolicyProperty.TLS`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayclientpolicy.html#cfn-appmesh-virtualgateway-virtualgatewayclientpolicy-tls
         * @external
         */
        readonly tls?: CfnVirtualGateway.VirtualGatewayClientPolicyTlsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualGateway`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualGateway
 */
export declare namespace CfnVirtualGateway {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayclientpolicytls.html
     * @external
     */
    interface VirtualGatewayClientPolicyTlsProperty {
        /**
         * `CfnVirtualGateway.VirtualGatewayClientPolicyTlsProperty.Enforce`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayclientpolicytls.html#cfn-appmesh-virtualgateway-virtualgatewayclientpolicytls-enforce
         * @external
         */
        readonly enforce?: boolean | cdk.IResolvable;
        /**
         * `CfnVirtualGateway.VirtualGatewayClientPolicyTlsProperty.Ports`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayclientpolicytls.html#cfn-appmesh-virtualgateway-virtualgatewayclientpolicytls-ports
         * @external
         */
        readonly ports?: number[] | cdk.IResolvable;
        /**
         * `CfnVirtualGateway.VirtualGatewayClientPolicyTlsProperty.Validation`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayclientpolicytls.html#cfn-appmesh-virtualgateway-virtualgatewayclientpolicytls-validation
         * @external
         */
        readonly validation: CfnVirtualGateway.VirtualGatewayTlsValidationContextProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualGateway`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualGateway
 */
export declare namespace CfnVirtualGateway {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayfileaccesslog.html
     * @external
     */
    interface VirtualGatewayFileAccessLogProperty {
        /**
         * `CfnVirtualGateway.VirtualGatewayFileAccessLogProperty.Path`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayfileaccesslog.html#cfn-appmesh-virtualgateway-virtualgatewayfileaccesslog-path
         * @external
         */
        readonly path: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualGateway`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualGateway
 */
export declare namespace CfnVirtualGateway {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayhealthcheckpolicy.html
     * @external
     */
    interface VirtualGatewayHealthCheckPolicyProperty {
        /**
         * `CfnVirtualGateway.VirtualGatewayHealthCheckPolicyProperty.HealthyThreshold`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayhealthcheckpolicy.html#cfn-appmesh-virtualgateway-virtualgatewayhealthcheckpolicy-healthythreshold
         * @external
         */
        readonly healthyThreshold: number;
        /**
         * `CfnVirtualGateway.VirtualGatewayHealthCheckPolicyProperty.IntervalMillis`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayhealthcheckpolicy.html#cfn-appmesh-virtualgateway-virtualgatewayhealthcheckpolicy-intervalmillis
         * @external
         */
        readonly intervalMillis: number;
        /**
         * `CfnVirtualGateway.VirtualGatewayHealthCheckPolicyProperty.Path`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayhealthcheckpolicy.html#cfn-appmesh-virtualgateway-virtualgatewayhealthcheckpolicy-path
         * @external
         */
        readonly path?: string;
        /**
         * `CfnVirtualGateway.VirtualGatewayHealthCheckPolicyProperty.Port`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayhealthcheckpolicy.html#cfn-appmesh-virtualgateway-virtualgatewayhealthcheckpolicy-port
         * @external
         */
        readonly port?: number;
        /**
         * `CfnVirtualGateway.VirtualGatewayHealthCheckPolicyProperty.Protocol`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayhealthcheckpolicy.html#cfn-appmesh-virtualgateway-virtualgatewayhealthcheckpolicy-protocol
         * @external
         */
        readonly protocol: string;
        /**
         * `CfnVirtualGateway.VirtualGatewayHealthCheckPolicyProperty.TimeoutMillis`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayhealthcheckpolicy.html#cfn-appmesh-virtualgateway-virtualgatewayhealthcheckpolicy-timeoutmillis
         * @external
         */
        readonly timeoutMillis: number;
        /**
         * `CfnVirtualGateway.VirtualGatewayHealthCheckPolicyProperty.UnhealthyThreshold`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayhealthcheckpolicy.html#cfn-appmesh-virtualgateway-virtualgatewayhealthcheckpolicy-unhealthythreshold
         * @external
         */
        readonly unhealthyThreshold: number;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualGateway`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualGateway
 */
export declare namespace CfnVirtualGateway {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistener.html
     * @external
     */
    interface VirtualGatewayListenerProperty {
        /**
         * `CfnVirtualGateway.VirtualGatewayListenerProperty.HealthCheck`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistener.html#cfn-appmesh-virtualgateway-virtualgatewaylistener-healthcheck
         * @external
         */
        readonly healthCheck?: CfnVirtualGateway.VirtualGatewayHealthCheckPolicyProperty | cdk.IResolvable;
        /**
         * `CfnVirtualGateway.VirtualGatewayListenerProperty.PortMapping`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistener.html#cfn-appmesh-virtualgateway-virtualgatewaylistener-portmapping
         * @external
         */
        readonly portMapping: CfnVirtualGateway.VirtualGatewayPortMappingProperty | cdk.IResolvable;
        /**
         * `CfnVirtualGateway.VirtualGatewayListenerProperty.TLS`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistener.html#cfn-appmesh-virtualgateway-virtualgatewaylistener-tls
         * @external
         */
        readonly tls?: CfnVirtualGateway.VirtualGatewayListenerTlsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualGateway`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualGateway
 */
export declare namespace CfnVirtualGateway {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertls.html
     * @external
     */
    interface VirtualGatewayListenerTlsProperty {
        /**
         * `CfnVirtualGateway.VirtualGatewayListenerTlsProperty.Certificate`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertls.html#cfn-appmesh-virtualgateway-virtualgatewaylistenertls-certificate
         * @external
         */
        readonly certificate: CfnVirtualGateway.VirtualGatewayListenerTlsCertificateProperty | cdk.IResolvable;
        /**
         * `CfnVirtualGateway.VirtualGatewayListenerTlsProperty.Mode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertls.html#cfn-appmesh-virtualgateway-virtualgatewaylistenertls-mode
         * @external
         */
        readonly mode: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualGateway`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualGateway
 */
export declare namespace CfnVirtualGateway {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertlsacmcertificate.html
     * @external
     */
    interface VirtualGatewayListenerTlsAcmCertificateProperty {
        /**
         * `CfnVirtualGateway.VirtualGatewayListenerTlsAcmCertificateProperty.CertificateArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertlsacmcertificate.html#cfn-appmesh-virtualgateway-virtualgatewaylistenertlsacmcertificate-certificatearn
         * @external
         */
        readonly certificateArn: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualGateway`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualGateway
 */
export declare namespace CfnVirtualGateway {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertlscertificate.html
     * @external
     */
    interface VirtualGatewayListenerTlsCertificateProperty {
        /**
         * `CfnVirtualGateway.VirtualGatewayListenerTlsCertificateProperty.ACM`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertlscertificate.html#cfn-appmesh-virtualgateway-virtualgatewaylistenertlscertificate-acm
         * @external
         */
        readonly acm?: CfnVirtualGateway.VirtualGatewayListenerTlsAcmCertificateProperty | cdk.IResolvable;
        /**
         * `CfnVirtualGateway.VirtualGatewayListenerTlsCertificateProperty.File`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertlscertificate.html#cfn-appmesh-virtualgateway-virtualgatewaylistenertlscertificate-file
         * @external
         */
        readonly file?: CfnVirtualGateway.VirtualGatewayListenerTlsFileCertificateProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualGateway`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualGateway
 */
export declare namespace CfnVirtualGateway {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertlsfilecertificate.html
     * @external
     */
    interface VirtualGatewayListenerTlsFileCertificateProperty {
        /**
         * `CfnVirtualGateway.VirtualGatewayListenerTlsFileCertificateProperty.CertificateChain`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertlsfilecertificate.html#cfn-appmesh-virtualgateway-virtualgatewaylistenertlsfilecertificate-certificatechain
         * @external
         */
        readonly certificateChain: string;
        /**
         * `CfnVirtualGateway.VirtualGatewayListenerTlsFileCertificateProperty.PrivateKey`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertlsfilecertificate.html#cfn-appmesh-virtualgateway-virtualgatewaylistenertlsfilecertificate-privatekey
         * @external
         */
        readonly privateKey: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualGateway`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualGateway
 */
export declare namespace CfnVirtualGateway {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylogging.html
     * @external
     */
    interface VirtualGatewayLoggingProperty {
        /**
         * `CfnVirtualGateway.VirtualGatewayLoggingProperty.AccessLog`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylogging.html#cfn-appmesh-virtualgateway-virtualgatewaylogging-accesslog
         * @external
         */
        readonly accessLog?: CfnVirtualGateway.VirtualGatewayAccessLogProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualGateway`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualGateway
 */
export declare namespace CfnVirtualGateway {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayportmapping.html
     * @external
     */
    interface VirtualGatewayPortMappingProperty {
        /**
         * `CfnVirtualGateway.VirtualGatewayPortMappingProperty.Port`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayportmapping.html#cfn-appmesh-virtualgateway-virtualgatewayportmapping-port
         * @external
         */
        readonly port: number;
        /**
         * `CfnVirtualGateway.VirtualGatewayPortMappingProperty.Protocol`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayportmapping.html#cfn-appmesh-virtualgateway-virtualgatewayportmapping-protocol
         * @external
         */
        readonly protocol: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualGateway`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualGateway
 */
export declare namespace CfnVirtualGateway {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayspec.html
     * @external
     */
    interface VirtualGatewaySpecProperty {
        /**
         * `CfnVirtualGateway.VirtualGatewaySpecProperty.BackendDefaults`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayspec.html#cfn-appmesh-virtualgateway-virtualgatewayspec-backenddefaults
         * @external
         */
        readonly backendDefaults?: CfnVirtualGateway.VirtualGatewayBackendDefaultsProperty | cdk.IResolvable;
        /**
         * `CfnVirtualGateway.VirtualGatewaySpecProperty.Listeners`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayspec.html#cfn-appmesh-virtualgateway-virtualgatewayspec-listeners
         * @external
         */
        readonly listeners: Array<CfnVirtualGateway.VirtualGatewayListenerProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnVirtualGateway.VirtualGatewaySpecProperty.Logging`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayspec.html#cfn-appmesh-virtualgateway-virtualgatewayspec-logging
         * @external
         */
        readonly logging?: CfnVirtualGateway.VirtualGatewayLoggingProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualGateway`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualGateway
 */
export declare namespace CfnVirtualGateway {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaytlsvalidationcontext.html
     * @external
     */
    interface VirtualGatewayTlsValidationContextProperty {
        /**
         * `CfnVirtualGateway.VirtualGatewayTlsValidationContextProperty.Trust`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaytlsvalidationcontext.html#cfn-appmesh-virtualgateway-virtualgatewaytlsvalidationcontext-trust
         * @external
         */
        readonly trust: CfnVirtualGateway.VirtualGatewayTlsValidationContextTrustProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualGateway`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualGateway
 */
export declare namespace CfnVirtualGateway {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaytlsvalidationcontextacmtrust.html
     * @external
     */
    interface VirtualGatewayTlsValidationContextAcmTrustProperty {
        /**
         * `CfnVirtualGateway.VirtualGatewayTlsValidationContextAcmTrustProperty.CertificateAuthorityArns`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaytlsvalidationcontextacmtrust.html#cfn-appmesh-virtualgateway-virtualgatewaytlsvalidationcontextacmtrust-certificateauthorityarns
         * @external
         */
        readonly certificateAuthorityArns: string[];
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualGateway`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualGateway
 */
export declare namespace CfnVirtualGateway {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaytlsvalidationcontextfiletrust.html
     * @external
     */
    interface VirtualGatewayTlsValidationContextFileTrustProperty {
        /**
         * `CfnVirtualGateway.VirtualGatewayTlsValidationContextFileTrustProperty.CertificateChain`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaytlsvalidationcontextfiletrust.html#cfn-appmesh-virtualgateway-virtualgatewaytlsvalidationcontextfiletrust-certificatechain
         * @external
         */
        readonly certificateChain: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualGateway`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualGateway
 */
export declare namespace CfnVirtualGateway {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaytlsvalidationcontexttrust.html
     * @external
     */
    interface VirtualGatewayTlsValidationContextTrustProperty {
        /**
         * `CfnVirtualGateway.VirtualGatewayTlsValidationContextTrustProperty.ACM`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaytlsvalidationcontexttrust.html#cfn-appmesh-virtualgateway-virtualgatewaytlsvalidationcontexttrust-acm
         * @external
         */
        readonly acm?: CfnVirtualGateway.VirtualGatewayTlsValidationContextAcmTrustProperty | cdk.IResolvable;
        /**
         * `CfnVirtualGateway.VirtualGatewayTlsValidationContextTrustProperty.File`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaytlsvalidationcontexttrust.html#cfn-appmesh-virtualgateway-virtualgatewaytlsvalidationcontexttrust-file
         * @external
         */
        readonly file?: CfnVirtualGateway.VirtualGatewayTlsValidationContextFileTrustProperty | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::AppMesh::VirtualNode`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 * @external
 */
export interface CfnVirtualNodeProps {
    /**
     * `AWS::AppMesh::VirtualNode.MeshName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html#cfn-appmesh-virtualnode-meshname
     * @external
     */
    readonly meshName: string;
    /**
     * `AWS::AppMesh::VirtualNode.Spec`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html#cfn-appmesh-virtualnode-spec
     * @external
     */
    readonly spec: CfnVirtualNode.VirtualNodeSpecProperty | cdk.IResolvable;
    /**
     * `AWS::AppMesh::VirtualNode.VirtualNodeName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html#cfn-appmesh-virtualnode-virtualnodename
     * @external
     */
    readonly virtualNodeName: string;
    /**
     * `AWS::AppMesh::VirtualNode.MeshOwner`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html#cfn-appmesh-virtualnode-meshowner
     * @external
     */
    readonly meshOwner?: string;
    /**
     * `AWS::AppMesh::VirtualNode.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html#cfn-appmesh-virtualnode-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 */
export declare class CfnVirtualNode extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AppMesh::VirtualNode";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnVirtualNode;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute MeshName
     */
    readonly attrMeshName: string;
    /**
     * @external
     * @cloudformationAttribute MeshOwner
     */
    readonly attrMeshOwner: string;
    /**
     * @external
     * @cloudformationAttribute ResourceOwner
     */
    readonly attrResourceOwner: string;
    /**
     * @external
     * @cloudformationAttribute Uid
     */
    readonly attrUid: string;
    /**
     * @external
     * @cloudformationAttribute VirtualNodeName
     */
    readonly attrVirtualNodeName: string;
    /**
     * `AWS::AppMesh::VirtualNode.MeshName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html#cfn-appmesh-virtualnode-meshname
     * @external
     */
    meshName: string;
    /**
     * `AWS::AppMesh::VirtualNode.Spec`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html#cfn-appmesh-virtualnode-spec
     * @external
     */
    spec: CfnVirtualNode.VirtualNodeSpecProperty | cdk.IResolvable;
    /**
     * `AWS::AppMesh::VirtualNode.VirtualNodeName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html#cfn-appmesh-virtualnode-virtualnodename
     * @external
     */
    virtualNodeName: string;
    /**
     * `AWS::AppMesh::VirtualNode.MeshOwner`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html#cfn-appmesh-virtualnode-meshowner
     * @external
     */
    meshOwner: string | undefined;
    /**
     * `AWS::AppMesh::VirtualNode.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html#cfn-appmesh-virtualnode-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::AppMesh::VirtualNode`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVirtualNodeProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 */
export declare namespace CfnVirtualNode {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-accesslog.html
     * @external
     */
    interface AccessLogProperty {
        /**
         * `CfnVirtualNode.AccessLogProperty.File`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-accesslog.html#cfn-appmesh-virtualnode-accesslog-file
         * @external
         */
        readonly file?: CfnVirtualNode.FileAccessLogProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 */
export declare namespace CfnVirtualNode {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-awscloudmapinstanceattribute.html
     * @external
     */
    interface AwsCloudMapInstanceAttributeProperty {
        /**
         * `CfnVirtualNode.AwsCloudMapInstanceAttributeProperty.Key`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-awscloudmapinstanceattribute.html#cfn-appmesh-virtualnode-awscloudmapinstanceattribute-key
         * @external
         */
        readonly key: string;
        /**
         * `CfnVirtualNode.AwsCloudMapInstanceAttributeProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-awscloudmapinstanceattribute.html#cfn-appmesh-virtualnode-awscloudmapinstanceattribute-value
         * @external
         */
        readonly value: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 */
export declare namespace CfnVirtualNode {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-awscloudmapservicediscovery.html
     * @external
     */
    interface AwsCloudMapServiceDiscoveryProperty {
        /**
         * `CfnVirtualNode.AwsCloudMapServiceDiscoveryProperty.Attributes`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-awscloudmapservicediscovery.html#cfn-appmesh-virtualnode-awscloudmapservicediscovery-attributes
         * @external
         */
        readonly attributes?: Array<CfnVirtualNode.AwsCloudMapInstanceAttributeProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnVirtualNode.AwsCloudMapServiceDiscoveryProperty.NamespaceName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-awscloudmapservicediscovery.html#cfn-appmesh-virtualnode-awscloudmapservicediscovery-namespacename
         * @external
         */
        readonly namespaceName: string;
        /**
         * `CfnVirtualNode.AwsCloudMapServiceDiscoveryProperty.ServiceName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-awscloudmapservicediscovery.html#cfn-appmesh-virtualnode-awscloudmapservicediscovery-servicename
         * @external
         */
        readonly serviceName: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 */
export declare namespace CfnVirtualNode {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-backend.html
     * @external
     */
    interface BackendProperty {
        /**
         * `CfnVirtualNode.BackendProperty.VirtualService`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-backend.html#cfn-appmesh-virtualnode-backend-virtualservice
         * @external
         */
        readonly virtualService?: CfnVirtualNode.VirtualServiceBackendProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 */
export declare namespace CfnVirtualNode {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-backenddefaults.html
     * @external
     */
    interface BackendDefaultsProperty {
        /**
         * `CfnVirtualNode.BackendDefaultsProperty.ClientPolicy`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-backenddefaults.html#cfn-appmesh-virtualnode-backenddefaults-clientpolicy
         * @external
         */
        readonly clientPolicy?: CfnVirtualNode.ClientPolicyProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 */
export declare namespace CfnVirtualNode {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-clientpolicy.html
     * @external
     */
    interface ClientPolicyProperty {
        /**
         * `CfnVirtualNode.ClientPolicyProperty.TLS`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-clientpolicy.html#cfn-appmesh-virtualnode-clientpolicy-tls
         * @external
         */
        readonly tls?: CfnVirtualNode.ClientPolicyTlsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 */
export declare namespace CfnVirtualNode {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-clientpolicytls.html
     * @external
     */
    interface ClientPolicyTlsProperty {
        /**
         * `CfnVirtualNode.ClientPolicyTlsProperty.Enforce`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-clientpolicytls.html#cfn-appmesh-virtualnode-clientpolicytls-enforce
         * @external
         */
        readonly enforce?: boolean | cdk.IResolvable;
        /**
         * `CfnVirtualNode.ClientPolicyTlsProperty.Ports`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-clientpolicytls.html#cfn-appmesh-virtualnode-clientpolicytls-ports
         * @external
         */
        readonly ports?: number[] | cdk.IResolvable;
        /**
         * `CfnVirtualNode.ClientPolicyTlsProperty.Validation`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-clientpolicytls.html#cfn-appmesh-virtualnode-clientpolicytls-validation
         * @external
         */
        readonly validation: CfnVirtualNode.TlsValidationContextProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 */
export declare namespace CfnVirtualNode {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-dnsservicediscovery.html
     * @external
     */
    interface DnsServiceDiscoveryProperty {
        /**
         * `CfnVirtualNode.DnsServiceDiscoveryProperty.Hostname`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-dnsservicediscovery.html#cfn-appmesh-virtualnode-dnsservicediscovery-hostname
         * @external
         */
        readonly hostname: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 */
export declare namespace CfnVirtualNode {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-duration.html
     * @external
     */
    interface DurationProperty {
        /**
         * `CfnVirtualNode.DurationProperty.Unit`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-duration.html#cfn-appmesh-virtualnode-duration-unit
         * @external
         */
        readonly unit: string;
        /**
         * `CfnVirtualNode.DurationProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-duration.html#cfn-appmesh-virtualnode-duration-value
         * @external
         */
        readonly value: number;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 */
export declare namespace CfnVirtualNode {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-fileaccesslog.html
     * @external
     */
    interface FileAccessLogProperty {
        /**
         * `CfnVirtualNode.FileAccessLogProperty.Path`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-fileaccesslog.html#cfn-appmesh-virtualnode-fileaccesslog-path
         * @external
         */
        readonly path: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 */
export declare namespace CfnVirtualNode {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-grpctimeout.html
     * @external
     */
    interface GrpcTimeoutProperty {
        /**
         * `CfnVirtualNode.GrpcTimeoutProperty.Idle`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-grpctimeout.html#cfn-appmesh-virtualnode-grpctimeout-idle
         * @external
         */
        readonly idle?: CfnVirtualNode.DurationProperty | cdk.IResolvable;
        /**
         * `CfnVirtualNode.GrpcTimeoutProperty.PerRequest`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-grpctimeout.html#cfn-appmesh-virtualnode-grpctimeout-perrequest
         * @external
         */
        readonly perRequest?: CfnVirtualNode.DurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 */
export declare namespace CfnVirtualNode {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-healthcheck.html
     * @external
     */
    interface HealthCheckProperty {
        /**
         * `CfnVirtualNode.HealthCheckProperty.HealthyThreshold`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-healthcheck.html#cfn-appmesh-virtualnode-healthcheck-healthythreshold
         * @external
         */
        readonly healthyThreshold: number;
        /**
         * `CfnVirtualNode.HealthCheckProperty.IntervalMillis`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-healthcheck.html#cfn-appmesh-virtualnode-healthcheck-intervalmillis
         * @external
         */
        readonly intervalMillis: number;
        /**
         * `CfnVirtualNode.HealthCheckProperty.Path`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-healthcheck.html#cfn-appmesh-virtualnode-healthcheck-path
         * @external
         */
        readonly path?: string;
        /**
         * `CfnVirtualNode.HealthCheckProperty.Port`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-healthcheck.html#cfn-appmesh-virtualnode-healthcheck-port
         * @external
         */
        readonly port?: number;
        /**
         * `CfnVirtualNode.HealthCheckProperty.Protocol`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-healthcheck.html#cfn-appmesh-virtualnode-healthcheck-protocol
         * @external
         */
        readonly protocol: string;
        /**
         * `CfnVirtualNode.HealthCheckProperty.TimeoutMillis`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-healthcheck.html#cfn-appmesh-virtualnode-healthcheck-timeoutmillis
         * @external
         */
        readonly timeoutMillis: number;
        /**
         * `CfnVirtualNode.HealthCheckProperty.UnhealthyThreshold`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-healthcheck.html#cfn-appmesh-virtualnode-healthcheck-unhealthythreshold
         * @external
         */
        readonly unhealthyThreshold: number;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 */
export declare namespace CfnVirtualNode {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-httptimeout.html
     * @external
     */
    interface HttpTimeoutProperty {
        /**
         * `CfnVirtualNode.HttpTimeoutProperty.Idle`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-httptimeout.html#cfn-appmesh-virtualnode-httptimeout-idle
         * @external
         */
        readonly idle?: CfnVirtualNode.DurationProperty | cdk.IResolvable;
        /**
         * `CfnVirtualNode.HttpTimeoutProperty.PerRequest`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-httptimeout.html#cfn-appmesh-virtualnode-httptimeout-perrequest
         * @external
         */
        readonly perRequest?: CfnVirtualNode.DurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 */
export declare namespace CfnVirtualNode {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listener.html
     * @external
     */
    interface ListenerProperty {
        /**
         * `CfnVirtualNode.ListenerProperty.HealthCheck`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listener.html#cfn-appmesh-virtualnode-listener-healthcheck
         * @external
         */
        readonly healthCheck?: CfnVirtualNode.HealthCheckProperty | cdk.IResolvable;
        /**
         * `CfnVirtualNode.ListenerProperty.PortMapping`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listener.html#cfn-appmesh-virtualnode-listener-portmapping
         * @external
         */
        readonly portMapping: CfnVirtualNode.PortMappingProperty | cdk.IResolvable;
        /**
         * `CfnVirtualNode.ListenerProperty.TLS`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listener.html#cfn-appmesh-virtualnode-listener-tls
         * @external
         */
        readonly tls?: CfnVirtualNode.ListenerTlsProperty | cdk.IResolvable;
        /**
         * `CfnVirtualNode.ListenerProperty.Timeout`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listener.html#cfn-appmesh-virtualnode-listener-timeout
         * @external
         */
        readonly timeout?: CfnVirtualNode.ListenerTimeoutProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 */
export declare namespace CfnVirtualNode {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listenertimeout.html
     * @external
     */
    interface ListenerTimeoutProperty {
        /**
         * `CfnVirtualNode.ListenerTimeoutProperty.GRPC`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listenertimeout.html#cfn-appmesh-virtualnode-listenertimeout-grpc
         * @external
         */
        readonly grpc?: CfnVirtualNode.GrpcTimeoutProperty | cdk.IResolvable;
        /**
         * `CfnVirtualNode.ListenerTimeoutProperty.HTTP`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listenertimeout.html#cfn-appmesh-virtualnode-listenertimeout-http
         * @external
         */
        readonly http?: CfnVirtualNode.HttpTimeoutProperty | cdk.IResolvable;
        /**
         * `CfnVirtualNode.ListenerTimeoutProperty.HTTP2`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listenertimeout.html#cfn-appmesh-virtualnode-listenertimeout-http2
         * @external
         */
        readonly http2?: CfnVirtualNode.HttpTimeoutProperty | cdk.IResolvable;
        /**
         * `CfnVirtualNode.ListenerTimeoutProperty.TCP`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listenertimeout.html#cfn-appmesh-virtualnode-listenertimeout-tcp
         * @external
         */
        readonly tcp?: CfnVirtualNode.TcpTimeoutProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 */
export declare namespace CfnVirtualNode {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listenertls.html
     * @external
     */
    interface ListenerTlsProperty {
        /**
         * `CfnVirtualNode.ListenerTlsProperty.Certificate`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listenertls.html#cfn-appmesh-virtualnode-listenertls-certificate
         * @external
         */
        readonly certificate: CfnVirtualNode.ListenerTlsCertificateProperty | cdk.IResolvable;
        /**
         * `CfnVirtualNode.ListenerTlsProperty.Mode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listenertls.html#cfn-appmesh-virtualnode-listenertls-mode
         * @external
         */
        readonly mode: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 */
export declare namespace CfnVirtualNode {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listenertlsacmcertificate.html
     * @external
     */
    interface ListenerTlsAcmCertificateProperty {
        /**
         * `CfnVirtualNode.ListenerTlsAcmCertificateProperty.CertificateArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listenertlsacmcertificate.html#cfn-appmesh-virtualnode-listenertlsacmcertificate-certificatearn
         * @external
         */
        readonly certificateArn: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 */
export declare namespace CfnVirtualNode {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listenertlscertificate.html
     * @external
     */
    interface ListenerTlsCertificateProperty {
        /**
         * `CfnVirtualNode.ListenerTlsCertificateProperty.ACM`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listenertlscertificate.html#cfn-appmesh-virtualnode-listenertlscertificate-acm
         * @external
         */
        readonly acm?: CfnVirtualNode.ListenerTlsAcmCertificateProperty | cdk.IResolvable;
        /**
         * `CfnVirtualNode.ListenerTlsCertificateProperty.File`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listenertlscertificate.html#cfn-appmesh-virtualnode-listenertlscertificate-file
         * @external
         */
        readonly file?: CfnVirtualNode.ListenerTlsFileCertificateProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 */
export declare namespace CfnVirtualNode {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listenertlsfilecertificate.html
     * @external
     */
    interface ListenerTlsFileCertificateProperty {
        /**
         * `CfnVirtualNode.ListenerTlsFileCertificateProperty.CertificateChain`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listenertlsfilecertificate.html#cfn-appmesh-virtualnode-listenertlsfilecertificate-certificatechain
         * @external
         */
        readonly certificateChain: string;
        /**
         * `CfnVirtualNode.ListenerTlsFileCertificateProperty.PrivateKey`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listenertlsfilecertificate.html#cfn-appmesh-virtualnode-listenertlsfilecertificate-privatekey
         * @external
         */
        readonly privateKey: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 */
export declare namespace CfnVirtualNode {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-logging.html
     * @external
     */
    interface LoggingProperty {
        /**
         * `CfnVirtualNode.LoggingProperty.AccessLog`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-logging.html#cfn-appmesh-virtualnode-logging-accesslog
         * @external
         */
        readonly accessLog?: CfnVirtualNode.AccessLogProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 */
export declare namespace CfnVirtualNode {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-portmapping.html
     * @external
     */
    interface PortMappingProperty {
        /**
         * `CfnVirtualNode.PortMappingProperty.Port`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-portmapping.html#cfn-appmesh-virtualnode-portmapping-port
         * @external
         */
        readonly port: number;
        /**
         * `CfnVirtualNode.PortMappingProperty.Protocol`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-portmapping.html#cfn-appmesh-virtualnode-portmapping-protocol
         * @external
         */
        readonly protocol: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 */
export declare namespace CfnVirtualNode {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-servicediscovery.html
     * @external
     */
    interface ServiceDiscoveryProperty {
        /**
         * `CfnVirtualNode.ServiceDiscoveryProperty.AWSCloudMap`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-servicediscovery.html#cfn-appmesh-virtualnode-servicediscovery-awscloudmap
         * @external
         */
        readonly awsCloudMap?: CfnVirtualNode.AwsCloudMapServiceDiscoveryProperty | cdk.IResolvable;
        /**
         * `CfnVirtualNode.ServiceDiscoveryProperty.DNS`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-servicediscovery.html#cfn-appmesh-virtualnode-servicediscovery-dns
         * @external
         */
        readonly dns?: CfnVirtualNode.DnsServiceDiscoveryProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 */
export declare namespace CfnVirtualNode {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-tcptimeout.html
     * @external
     */
    interface TcpTimeoutProperty {
        /**
         * `CfnVirtualNode.TcpTimeoutProperty.Idle`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-tcptimeout.html#cfn-appmesh-virtualnode-tcptimeout-idle
         * @external
         */
        readonly idle?: CfnVirtualNode.DurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 */
export declare namespace CfnVirtualNode {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-tlsvalidationcontext.html
     * @external
     */
    interface TlsValidationContextProperty {
        /**
         * `CfnVirtualNode.TlsValidationContextProperty.Trust`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-tlsvalidationcontext.html#cfn-appmesh-virtualnode-tlsvalidationcontext-trust
         * @external
         */
        readonly trust: CfnVirtualNode.TlsValidationContextTrustProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 */
export declare namespace CfnVirtualNode {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-tlsvalidationcontextacmtrust.html
     * @external
     */
    interface TlsValidationContextAcmTrustProperty {
        /**
         * `CfnVirtualNode.TlsValidationContextAcmTrustProperty.CertificateAuthorityArns`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-tlsvalidationcontextacmtrust.html#cfn-appmesh-virtualnode-tlsvalidationcontextacmtrust-certificateauthorityarns
         * @external
         */
        readonly certificateAuthorityArns: string[];
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 */
export declare namespace CfnVirtualNode {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-tlsvalidationcontextfiletrust.html
     * @external
     */
    interface TlsValidationContextFileTrustProperty {
        /**
         * `CfnVirtualNode.TlsValidationContextFileTrustProperty.CertificateChain`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-tlsvalidationcontextfiletrust.html#cfn-appmesh-virtualnode-tlsvalidationcontextfiletrust-certificatechain
         * @external
         */
        readonly certificateChain: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 */
export declare namespace CfnVirtualNode {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-tlsvalidationcontexttrust.html
     * @external
     */
    interface TlsValidationContextTrustProperty {
        /**
         * `CfnVirtualNode.TlsValidationContextTrustProperty.ACM`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-tlsvalidationcontexttrust.html#cfn-appmesh-virtualnode-tlsvalidationcontexttrust-acm
         * @external
         */
        readonly acm?: CfnVirtualNode.TlsValidationContextAcmTrustProperty | cdk.IResolvable;
        /**
         * `CfnVirtualNode.TlsValidationContextTrustProperty.File`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-tlsvalidationcontexttrust.html#cfn-appmesh-virtualnode-tlsvalidationcontexttrust-file
         * @external
         */
        readonly file?: CfnVirtualNode.TlsValidationContextFileTrustProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 */
export declare namespace CfnVirtualNode {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-virtualnodespec.html
     * @external
     */
    interface VirtualNodeSpecProperty {
        /**
         * `CfnVirtualNode.VirtualNodeSpecProperty.BackendDefaults`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-virtualnodespec.html#cfn-appmesh-virtualnode-virtualnodespec-backenddefaults
         * @external
         */
        readonly backendDefaults?: CfnVirtualNode.BackendDefaultsProperty | cdk.IResolvable;
        /**
         * `CfnVirtualNode.VirtualNodeSpecProperty.Backends`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-virtualnodespec.html#cfn-appmesh-virtualnode-virtualnodespec-backends
         * @external
         */
        readonly backends?: Array<CfnVirtualNode.BackendProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnVirtualNode.VirtualNodeSpecProperty.Listeners`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-virtualnodespec.html#cfn-appmesh-virtualnode-virtualnodespec-listeners
         * @external
         */
        readonly listeners?: Array<CfnVirtualNode.ListenerProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnVirtualNode.VirtualNodeSpecProperty.Logging`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-virtualnodespec.html#cfn-appmesh-virtualnode-virtualnodespec-logging
         * @external
         */
        readonly logging?: CfnVirtualNode.LoggingProperty | cdk.IResolvable;
        /**
         * `CfnVirtualNode.VirtualNodeSpecProperty.ServiceDiscovery`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-virtualnodespec.html#cfn-appmesh-virtualnode-virtualnodespec-servicediscovery
         * @external
         */
        readonly serviceDiscovery?: CfnVirtualNode.ServiceDiscoveryProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 */
export declare namespace CfnVirtualNode {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-virtualservicebackend.html
     * @external
     */
    interface VirtualServiceBackendProperty {
        /**
         * `CfnVirtualNode.VirtualServiceBackendProperty.ClientPolicy`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-virtualservicebackend.html#cfn-appmesh-virtualnode-virtualservicebackend-clientpolicy
         * @external
         */
        readonly clientPolicy?: CfnVirtualNode.ClientPolicyProperty | cdk.IResolvable;
        /**
         * `CfnVirtualNode.VirtualServiceBackendProperty.VirtualServiceName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-virtualservicebackend.html#cfn-appmesh-virtualnode-virtualservicebackend-virtualservicename
         * @external
         */
        readonly virtualServiceName: string;
    }
}
/**
 * Properties for defining a `AWS::AppMesh::VirtualRouter`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualrouter.html
 * @external
 */
export interface CfnVirtualRouterProps {
    /**
     * `AWS::AppMesh::VirtualRouter.MeshName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualrouter.html#cfn-appmesh-virtualrouter-meshname
     * @external
     */
    readonly meshName: string;
    /**
     * `AWS::AppMesh::VirtualRouter.Spec`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualrouter.html#cfn-appmesh-virtualrouter-spec
     * @external
     */
    readonly spec: CfnVirtualRouter.VirtualRouterSpecProperty | cdk.IResolvable;
    /**
     * `AWS::AppMesh::VirtualRouter.VirtualRouterName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualrouter.html#cfn-appmesh-virtualrouter-virtualroutername
     * @external
     */
    readonly virtualRouterName: string;
    /**
     * `AWS::AppMesh::VirtualRouter.MeshOwner`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualrouter.html#cfn-appmesh-virtualrouter-meshowner
     * @external
     */
    readonly meshOwner?: string;
    /**
     * `AWS::AppMesh::VirtualRouter.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualrouter.html#cfn-appmesh-virtualrouter-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualRouter`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualrouter.html
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualRouter
 */
export declare class CfnVirtualRouter extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AppMesh::VirtualRouter";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnVirtualRouter;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute MeshName
     */
    readonly attrMeshName: string;
    /**
     * @external
     * @cloudformationAttribute MeshOwner
     */
    readonly attrMeshOwner: string;
    /**
     * @external
     * @cloudformationAttribute ResourceOwner
     */
    readonly attrResourceOwner: string;
    /**
     * @external
     * @cloudformationAttribute Uid
     */
    readonly attrUid: string;
    /**
     * @external
     * @cloudformationAttribute VirtualRouterName
     */
    readonly attrVirtualRouterName: string;
    /**
     * `AWS::AppMesh::VirtualRouter.MeshName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualrouter.html#cfn-appmesh-virtualrouter-meshname
     * @external
     */
    meshName: string;
    /**
     * `AWS::AppMesh::VirtualRouter.Spec`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualrouter.html#cfn-appmesh-virtualrouter-spec
     * @external
     */
    spec: CfnVirtualRouter.VirtualRouterSpecProperty | cdk.IResolvable;
    /**
     * `AWS::AppMesh::VirtualRouter.VirtualRouterName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualrouter.html#cfn-appmesh-virtualrouter-virtualroutername
     * @external
     */
    virtualRouterName: string;
    /**
     * `AWS::AppMesh::VirtualRouter.MeshOwner`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualrouter.html#cfn-appmesh-virtualrouter-meshowner
     * @external
     */
    meshOwner: string | undefined;
    /**
     * `AWS::AppMesh::VirtualRouter.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualrouter.html#cfn-appmesh-virtualrouter-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::AppMesh::VirtualRouter`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVirtualRouterProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualRouter`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualrouter.html
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualRouter
 */
export declare namespace CfnVirtualRouter {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualrouter-portmapping.html
     * @external
     */
    interface PortMappingProperty {
        /**
         * `CfnVirtualRouter.PortMappingProperty.Port`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualrouter-portmapping.html#cfn-appmesh-virtualrouter-portmapping-port
         * @external
         */
        readonly port: number;
        /**
         * `CfnVirtualRouter.PortMappingProperty.Protocol`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualrouter-portmapping.html#cfn-appmesh-virtualrouter-portmapping-protocol
         * @external
         */
        readonly protocol: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualRouter`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualrouter.html
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualRouter
 */
export declare namespace CfnVirtualRouter {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualrouter-virtualrouterlistener.html
     * @external
     */
    interface VirtualRouterListenerProperty {
        /**
         * `CfnVirtualRouter.VirtualRouterListenerProperty.PortMapping`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualrouter-virtualrouterlistener.html#cfn-appmesh-virtualrouter-virtualrouterlistener-portmapping
         * @external
         */
        readonly portMapping: CfnVirtualRouter.PortMappingProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualRouter`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualrouter.html
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualRouter
 */
export declare namespace CfnVirtualRouter {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualrouter-virtualrouterspec.html
     * @external
     */
    interface VirtualRouterSpecProperty {
        /**
         * `CfnVirtualRouter.VirtualRouterSpecProperty.Listeners`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualrouter-virtualrouterspec.html#cfn-appmesh-virtualrouter-virtualrouterspec-listeners
         * @external
         */
        readonly listeners: Array<CfnVirtualRouter.VirtualRouterListenerProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::AppMesh::VirtualService`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualservice.html
 * @external
 */
export interface CfnVirtualServiceProps {
    /**
     * `AWS::AppMesh::VirtualService.MeshName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualservice.html#cfn-appmesh-virtualservice-meshname
     * @external
     */
    readonly meshName: string;
    /**
     * `AWS::AppMesh::VirtualService.Spec`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualservice.html#cfn-appmesh-virtualservice-spec
     * @external
     */
    readonly spec: CfnVirtualService.VirtualServiceSpecProperty | cdk.IResolvable;
    /**
     * `AWS::AppMesh::VirtualService.VirtualServiceName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualservice.html#cfn-appmesh-virtualservice-virtualservicename
     * @external
     */
    readonly virtualServiceName: string;
    /**
     * `AWS::AppMesh::VirtualService.MeshOwner`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualservice.html#cfn-appmesh-virtualservice-meshowner
     * @external
     */
    readonly meshOwner?: string;
    /**
     * `AWS::AppMesh::VirtualService.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualservice.html#cfn-appmesh-virtualservice-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualService`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualservice.html
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualService
 */
export declare class CfnVirtualService extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AppMesh::VirtualService";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnVirtualService;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute MeshName
     */
    readonly attrMeshName: string;
    /**
     * @external
     * @cloudformationAttribute MeshOwner
     */
    readonly attrMeshOwner: string;
    /**
     * @external
     * @cloudformationAttribute ResourceOwner
     */
    readonly attrResourceOwner: string;
    /**
     * @external
     * @cloudformationAttribute Uid
     */
    readonly attrUid: string;
    /**
     * @external
     * @cloudformationAttribute VirtualServiceName
     */
    readonly attrVirtualServiceName: string;
    /**
     * `AWS::AppMesh::VirtualService.MeshName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualservice.html#cfn-appmesh-virtualservice-meshname
     * @external
     */
    meshName: string;
    /**
     * `AWS::AppMesh::VirtualService.Spec`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualservice.html#cfn-appmesh-virtualservice-spec
     * @external
     */
    spec: CfnVirtualService.VirtualServiceSpecProperty | cdk.IResolvable;
    /**
     * `AWS::AppMesh::VirtualService.VirtualServiceName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualservice.html#cfn-appmesh-virtualservice-virtualservicename
     * @external
     */
    virtualServiceName: string;
    /**
     * `AWS::AppMesh::VirtualService.MeshOwner`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualservice.html#cfn-appmesh-virtualservice-meshowner
     * @external
     */
    meshOwner: string | undefined;
    /**
     * `AWS::AppMesh::VirtualService.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualservice.html#cfn-appmesh-virtualservice-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::AppMesh::VirtualService`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVirtualServiceProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualService`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualservice.html
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualService
 */
export declare namespace CfnVirtualService {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualservice-virtualnodeserviceprovider.html
     * @external
     */
    interface VirtualNodeServiceProviderProperty {
        /**
         * `CfnVirtualService.VirtualNodeServiceProviderProperty.VirtualNodeName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualservice-virtualnodeserviceprovider.html#cfn-appmesh-virtualservice-virtualnodeserviceprovider-virtualnodename
         * @external
         */
        readonly virtualNodeName: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualService`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualservice.html
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualService
 */
export declare namespace CfnVirtualService {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualservice-virtualrouterserviceprovider.html
     * @external
     */
    interface VirtualRouterServiceProviderProperty {
        /**
         * `CfnVirtualService.VirtualRouterServiceProviderProperty.VirtualRouterName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualservice-virtualrouterserviceprovider.html#cfn-appmesh-virtualservice-virtualrouterserviceprovider-virtualroutername
         * @external
         */
        readonly virtualRouterName: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualService`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualservice.html
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualService
 */
export declare namespace CfnVirtualService {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualservice-virtualserviceprovider.html
     * @external
     */
    interface VirtualServiceProviderProperty {
        /**
         * `CfnVirtualService.VirtualServiceProviderProperty.VirtualNode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualservice-virtualserviceprovider.html#cfn-appmesh-virtualservice-virtualserviceprovider-virtualnode
         * @external
         */
        readonly virtualNode?: CfnVirtualService.VirtualNodeServiceProviderProperty | cdk.IResolvable;
        /**
         * `CfnVirtualService.VirtualServiceProviderProperty.VirtualRouter`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualservice-virtualserviceprovider.html#cfn-appmesh-virtualservice-virtualserviceprovider-virtualrouter
         * @external
         */
        readonly virtualRouter?: CfnVirtualService.VirtualRouterServiceProviderProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualService`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualservice.html
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualService
 */
export declare namespace CfnVirtualService {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualservice-virtualservicespec.html
     * @external
     */
    interface VirtualServiceSpecProperty {
        /**
         * `CfnVirtualService.VirtualServiceSpecProperty.Provider`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualservice-virtualservicespec.html#cfn-appmesh-virtualservice-virtualservicespec-provider
         * @external
         */
        readonly provider?: CfnVirtualService.VirtualServiceProviderProperty | cdk.IResolvable;
    }
}
