import * as cdk from "../../core";
import * as cfn_parse from "../../core/lib/cfn-parse";
/**
 * Properties for defining a `AWS::ApplicationInsights::Application`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html
 * @external
 */
export interface CfnApplicationProps {
    /**
     * `AWS::ApplicationInsights::Application.ResourceGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-resourcegroupname
     * @external
     */
    readonly resourceGroupName: string;
    /**
     * `AWS::ApplicationInsights::Application.AutoConfigurationEnabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-autoconfigurationenabled
     * @external
     */
    readonly autoConfigurationEnabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::ApplicationInsights::Application.ComponentMonitoringSettings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-componentmonitoringsettings
     * @external
     */
    readonly componentMonitoringSettings?: Array<CfnApplication.ComponentMonitoringSettingProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ApplicationInsights::Application.CustomComponents`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-customcomponents
     * @external
     */
    readonly customComponents?: Array<CfnApplication.CustomComponentProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ApplicationInsights::Application.CWEMonitorEnabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-cwemonitorenabled
     * @external
     */
    readonly cweMonitorEnabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::ApplicationInsights::Application.LogPatternSets`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-logpatternsets
     * @external
     */
    readonly logPatternSets?: Array<CfnApplication.LogPatternSetProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ApplicationInsights::Application.OpsCenterEnabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-opscenterenabled
     * @external
     */
    readonly opsCenterEnabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::ApplicationInsights::Application.OpsItemSNSTopicArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-opsitemsnstopicarn
     * @external
     */
    readonly opsItemSnsTopicArn?: string;
    /**
     * `AWS::ApplicationInsights::Application.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::ApplicationInsights::Application`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html
 * @external
 * @cloudformationResource AWS::ApplicationInsights::Application
 */
export declare class CfnApplication extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ApplicationInsights::Application";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnApplication;
    /**
     * @external
     * @cloudformationAttribute ApplicationARN
     */
    readonly attrApplicationArn: string;
    /**
     * `AWS::ApplicationInsights::Application.ResourceGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-resourcegroupname
     * @external
     */
    resourceGroupName: string;
    /**
     * `AWS::ApplicationInsights::Application.AutoConfigurationEnabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-autoconfigurationenabled
     * @external
     */
    autoConfigurationEnabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::ApplicationInsights::Application.ComponentMonitoringSettings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-componentmonitoringsettings
     * @external
     */
    componentMonitoringSettings: Array<CfnApplication.ComponentMonitoringSettingProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::ApplicationInsights::Application.CustomComponents`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-customcomponents
     * @external
     */
    customComponents: Array<CfnApplication.CustomComponentProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::ApplicationInsights::Application.CWEMonitorEnabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-cwemonitorenabled
     * @external
     */
    cweMonitorEnabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::ApplicationInsights::Application.LogPatternSets`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-logpatternsets
     * @external
     */
    logPatternSets: Array<CfnApplication.LogPatternSetProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::ApplicationInsights::Application.OpsCenterEnabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-opscenterenabled
     * @external
     */
    opsCenterEnabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::ApplicationInsights::Application.OpsItemSNSTopicArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-opsitemsnstopicarn
     * @external
     */
    opsItemSnsTopicArn: string | undefined;
    /**
     * `AWS::ApplicationInsights::Application.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::ApplicationInsights::Application`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnApplicationProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ApplicationInsights::Application`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html
 * @external
 * @cloudformationResource AWS::ApplicationInsights::Application
 */
export declare namespace CfnApplication {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-alarm.html
     * @external
     */
    interface AlarmProperty {
        /**
         * `CfnApplication.AlarmProperty.AlarmName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-alarm.html#cfn-applicationinsights-application-alarm-alarmname
         * @external
         */
        readonly alarmName: string;
        /**
         * `CfnApplication.AlarmProperty.Severity`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-alarm.html#cfn-applicationinsights-application-alarm-severity
         * @external
         */
        readonly severity?: string;
    }
}
/**
 * A CloudFormation `AWS::ApplicationInsights::Application`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html
 * @external
 * @cloudformationResource AWS::ApplicationInsights::Application
 */
export declare namespace CfnApplication {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-alarmmetric.html
     * @external
     */
    interface AlarmMetricProperty {
        /**
         * `CfnApplication.AlarmMetricProperty.AlarmMetricName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-alarmmetric.html#cfn-applicationinsights-application-alarmmetric-alarmmetricname
         * @external
         */
        readonly alarmMetricName: string;
    }
}
/**
 * A CloudFormation `AWS::ApplicationInsights::Application`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html
 * @external
 * @cloudformationResource AWS::ApplicationInsights::Application
 */
export declare namespace CfnApplication {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-componentconfiguration.html
     * @external
     */
    interface ComponentConfigurationProperty {
        /**
         * `CfnApplication.ComponentConfigurationProperty.ConfigurationDetails`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-componentconfiguration.html#cfn-applicationinsights-application-componentconfiguration-configurationdetails
         * @external
         */
        readonly configurationDetails?: CfnApplication.ConfigurationDetailsProperty | cdk.IResolvable;
        /**
         * `CfnApplication.ComponentConfigurationProperty.SubComponentTypeConfigurations`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-componentconfiguration.html#cfn-applicationinsights-application-componentconfiguration-subcomponenttypeconfigurations
         * @external
         */
        readonly subComponentTypeConfigurations?: Array<CfnApplication.SubComponentTypeConfigurationProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::ApplicationInsights::Application`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html
 * @external
 * @cloudformationResource AWS::ApplicationInsights::Application
 */
export declare namespace CfnApplication {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-componentmonitoringsetting.html
     * @external
     */
    interface ComponentMonitoringSettingProperty {
        /**
         * `CfnApplication.ComponentMonitoringSettingProperty.ComponentARN`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-componentmonitoringsetting.html#cfn-applicationinsights-application-componentmonitoringsetting-componentarn
         * @external
         */
        readonly componentArn?: string;
        /**
         * `CfnApplication.ComponentMonitoringSettingProperty.ComponentConfigurationMode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-componentmonitoringsetting.html#cfn-applicationinsights-application-componentmonitoringsetting-componentconfigurationmode
         * @external
         */
        readonly componentConfigurationMode?: string;
        /**
         * `CfnApplication.ComponentMonitoringSettingProperty.ComponentName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-componentmonitoringsetting.html#cfn-applicationinsights-application-componentmonitoringsetting-componentname
         * @external
         */
        readonly componentName?: string;
        /**
         * `CfnApplication.ComponentMonitoringSettingProperty.CustomComponentConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-componentmonitoringsetting.html#cfn-applicationinsights-application-componentmonitoringsetting-customcomponentconfiguration
         * @external
         */
        readonly customComponentConfiguration?: CfnApplication.ComponentConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnApplication.ComponentMonitoringSettingProperty.DefaultOverwriteComponentConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-componentmonitoringsetting.html#cfn-applicationinsights-application-componentmonitoringsetting-defaultoverwritecomponentconfiguration
         * @external
         */
        readonly defaultOverwriteComponentConfiguration?: CfnApplication.ComponentConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnApplication.ComponentMonitoringSettingProperty.Tier`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-componentmonitoringsetting.html#cfn-applicationinsights-application-componentmonitoringsetting-tier
         * @external
         */
        readonly tier?: string;
    }
}
/**
 * A CloudFormation `AWS::ApplicationInsights::Application`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html
 * @external
 * @cloudformationResource AWS::ApplicationInsights::Application
 */
export declare namespace CfnApplication {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-configurationdetails.html
     * @external
     */
    interface ConfigurationDetailsProperty {
        /**
         * `CfnApplication.ConfigurationDetailsProperty.AlarmMetrics`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-configurationdetails.html#cfn-applicationinsights-application-configurationdetails-alarmmetrics
         * @external
         */
        readonly alarmMetrics?: Array<CfnApplication.AlarmMetricProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnApplication.ConfigurationDetailsProperty.Alarms`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-configurationdetails.html#cfn-applicationinsights-application-configurationdetails-alarms
         * @external
         */
        readonly alarms?: Array<CfnApplication.AlarmProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnApplication.ConfigurationDetailsProperty.Logs`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-configurationdetails.html#cfn-applicationinsights-application-configurationdetails-logs
         * @external
         */
        readonly logs?: Array<CfnApplication.LogProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnApplication.ConfigurationDetailsProperty.WindowsEvents`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-configurationdetails.html#cfn-applicationinsights-application-configurationdetails-windowsevents
         * @external
         */
        readonly windowsEvents?: Array<CfnApplication.WindowsEventProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::ApplicationInsights::Application`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html
 * @external
 * @cloudformationResource AWS::ApplicationInsights::Application
 */
export declare namespace CfnApplication {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-customcomponent.html
     * @external
     */
    interface CustomComponentProperty {
        /**
         * `CfnApplication.CustomComponentProperty.ComponentName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-customcomponent.html#cfn-applicationinsights-application-customcomponent-componentname
         * @external
         */
        readonly componentName: string;
        /**
         * `CfnApplication.CustomComponentProperty.ResourceList`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-customcomponent.html#cfn-applicationinsights-application-customcomponent-resourcelist
         * @external
         */
        readonly resourceList: string[];
    }
}
/**
 * A CloudFormation `AWS::ApplicationInsights::Application`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html
 * @external
 * @cloudformationResource AWS::ApplicationInsights::Application
 */
export declare namespace CfnApplication {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-log.html
     * @external
     */
    interface LogProperty {
        /**
         * `CfnApplication.LogProperty.Encoding`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-log.html#cfn-applicationinsights-application-log-encoding
         * @external
         */
        readonly encoding?: string;
        /**
         * `CfnApplication.LogProperty.LogGroupName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-log.html#cfn-applicationinsights-application-log-loggroupname
         * @external
         */
        readonly logGroupName?: string;
        /**
         * `CfnApplication.LogProperty.LogPath`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-log.html#cfn-applicationinsights-application-log-logpath
         * @external
         */
        readonly logPath?: string;
        /**
         * `CfnApplication.LogProperty.LogType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-log.html#cfn-applicationinsights-application-log-logtype
         * @external
         */
        readonly logType: string;
        /**
         * `CfnApplication.LogProperty.PatternSet`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-log.html#cfn-applicationinsights-application-log-patternset
         * @external
         */
        readonly patternSet?: string;
    }
}
/**
 * A CloudFormation `AWS::ApplicationInsights::Application`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html
 * @external
 * @cloudformationResource AWS::ApplicationInsights::Application
 */
export declare namespace CfnApplication {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-logpattern.html
     * @external
     */
    interface LogPatternProperty {
        /**
         * `CfnApplication.LogPatternProperty.Pattern`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-logpattern.html#cfn-applicationinsights-application-logpattern-pattern
         * @external
         */
        readonly pattern: string;
        /**
         * `CfnApplication.LogPatternProperty.PatternName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-logpattern.html#cfn-applicationinsights-application-logpattern-patternname
         * @external
         */
        readonly patternName: string;
        /**
         * `CfnApplication.LogPatternProperty.Rank`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-logpattern.html#cfn-applicationinsights-application-logpattern-rank
         * @external
         */
        readonly rank: number;
    }
}
/**
 * A CloudFormation `AWS::ApplicationInsights::Application`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html
 * @external
 * @cloudformationResource AWS::ApplicationInsights::Application
 */
export declare namespace CfnApplication {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-logpatternset.html
     * @external
     */
    interface LogPatternSetProperty {
        /**
         * `CfnApplication.LogPatternSetProperty.LogPatterns`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-logpatternset.html#cfn-applicationinsights-application-logpatternset-logpatterns
         * @external
         */
        readonly logPatterns: Array<CfnApplication.LogPatternProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnApplication.LogPatternSetProperty.PatternSetName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-logpatternset.html#cfn-applicationinsights-application-logpatternset-patternsetname
         * @external
         */
        readonly patternSetName: string;
    }
}
/**
 * A CloudFormation `AWS::ApplicationInsights::Application`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html
 * @external
 * @cloudformationResource AWS::ApplicationInsights::Application
 */
export declare namespace CfnApplication {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-subcomponentconfigurationdetails.html
     * @external
     */
    interface SubComponentConfigurationDetailsProperty {
        /**
         * `CfnApplication.SubComponentConfigurationDetailsProperty.AlarmMetrics`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-subcomponentconfigurationdetails.html#cfn-applicationinsights-application-subcomponentconfigurationdetails-alarmmetrics
         * @external
         */
        readonly alarmMetrics?: Array<CfnApplication.AlarmMetricProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnApplication.SubComponentConfigurationDetailsProperty.Logs`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-subcomponentconfigurationdetails.html#cfn-applicationinsights-application-subcomponentconfigurationdetails-logs
         * @external
         */
        readonly logs?: Array<CfnApplication.LogProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnApplication.SubComponentConfigurationDetailsProperty.WindowsEvents`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-subcomponentconfigurationdetails.html#cfn-applicationinsights-application-subcomponentconfigurationdetails-windowsevents
         * @external
         */
        readonly windowsEvents?: Array<CfnApplication.WindowsEventProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::ApplicationInsights::Application`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html
 * @external
 * @cloudformationResource AWS::ApplicationInsights::Application
 */
export declare namespace CfnApplication {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-subcomponenttypeconfiguration.html
     * @external
     */
    interface SubComponentTypeConfigurationProperty {
        /**
         * `CfnApplication.SubComponentTypeConfigurationProperty.SubComponentConfigurationDetails`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-subcomponenttypeconfiguration.html#cfn-applicationinsights-application-subcomponenttypeconfiguration-subcomponentconfigurationdetails
         * @external
         */
        readonly subComponentConfigurationDetails: CfnApplication.SubComponentConfigurationDetailsProperty | cdk.IResolvable;
        /**
         * `CfnApplication.SubComponentTypeConfigurationProperty.SubComponentType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-subcomponenttypeconfiguration.html#cfn-applicationinsights-application-subcomponenttypeconfiguration-subcomponenttype
         * @external
         */
        readonly subComponentType: string;
    }
}
/**
 * A CloudFormation `AWS::ApplicationInsights::Application`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html
 * @external
 * @cloudformationResource AWS::ApplicationInsights::Application
 */
export declare namespace CfnApplication {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-windowsevent.html
     * @external
     */
    interface WindowsEventProperty {
        /**
         * `CfnApplication.WindowsEventProperty.EventLevels`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-windowsevent.html#cfn-applicationinsights-application-windowsevent-eventlevels
         * @external
         */
        readonly eventLevels: string[];
        /**
         * `CfnApplication.WindowsEventProperty.EventName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-windowsevent.html#cfn-applicationinsights-application-windowsevent-eventname
         * @external
         */
        readonly eventName: string;
        /**
         * `CfnApplication.WindowsEventProperty.LogGroupName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-windowsevent.html#cfn-applicationinsights-application-windowsevent-loggroupname
         * @external
         */
        readonly logGroupName: string;
        /**
         * `CfnApplication.WindowsEventProperty.PatternSet`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-windowsevent.html#cfn-applicationinsights-application-windowsevent-patternset
         * @external
         */
        readonly patternSet?: string;
    }
}
