import * as iam from "../../aws-iam";
import * as cdk from "../../core";
import { Construct } from 'constructs';
import { ScalingSchedule, ServiceNamespace } from './scalable-target';
import { BasicStepScalingPolicyProps } from './step-scaling-policy';
import { BasicTargetTrackingScalingPolicyProps } from './target-tracking-scaling-policy';
/**
 * (experimental) Properties for a ScalableTableAttribute.
 *
 * @experimental
 */
export interface BaseScalableAttributeProps extends EnableScalingProps {
    /**
     * (experimental) Service namespace of the scalable attribute.
     *
     * @experimental
     */
    readonly serviceNamespace: ServiceNamespace;
    /**
     * (experimental) Resource ID of the attribute.
     *
     * @experimental
     */
    readonly resourceId: string;
    /**
     * (experimental) Scalable dimension of the attribute.
     *
     * @experimental
     */
    readonly dimension: string;
    /**
     * (experimental) Role to use for scaling.
     *
     * @experimental
     */
    readonly role: iam.IRole;
}
/**
 * (experimental) Represent an attribute for which autoscaling can be configured.
 *
 * This class is basically a light wrapper around ScalableTarget, but with
 * all methods protected instead of public so they can be selectively
 * exposed and/or more specific versions of them can be exposed by derived
 * classes for individual services support autoscaling.
 *
 * Typical use cases:
 *
 * - Hide away the PredefinedMetric enum for target tracking policies.
 * - Don't expose all scaling methods (for example Dynamo tables don't support
 *    Step Scaling, so the Dynamo subclass won't expose this method).
 *
 * @experimental
 */
export declare abstract class BaseScalableAttribute extends cdk.Construct {
    protected readonly props: BaseScalableAttributeProps;
    private target;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: BaseScalableAttributeProps);
    /**
     * (experimental) Scale out or in based on time.
     *
     * @experimental
     */
    protected doScaleOnSchedule(id: string, props: ScalingSchedule): void;
    /**
     * (experimental) Scale out or in based on a metric value.
     *
     * @experimental
     */
    protected doScaleOnMetric(id: string, props: BasicStepScalingPolicyProps): void;
    /**
     * (experimental) Scale out or in in order to keep a metric around a target value.
     *
     * @experimental
     */
    protected doScaleToTrackMetric(id: string, props: BasicTargetTrackingScalingPolicyProps): void;
}
/**
 * (experimental) Properties for enabling DynamoDB capacity scaling.
 *
 * @experimental
 */
export interface EnableScalingProps {
    /**
     * (experimental) Minimum capacity to scale to.
     *
     * @default 1
     * @experimental
     */
    readonly minCapacity?: number;
    /**
     * (experimental) Maximum capacity to scale to.
     *
     * @experimental
     */
    readonly maxCapacity: number;
}
