import * as cdk from "../../core";
import * as cfn_parse from "../../core/lib/cfn-parse";
/**
 * Properties for defining a `AWS::AppFlow::ConnectorProfile`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html
 * @external
 */
export interface CfnConnectorProfileProps {
    /**
     * `AWS::AppFlow::ConnectorProfile.ConnectionMode`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html#cfn-appflow-connectorprofile-connectionmode
     * @external
     */
    readonly connectionMode: string;
    /**
     * `AWS::AppFlow::ConnectorProfile.ConnectorProfileName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html#cfn-appflow-connectorprofile-connectorprofilename
     * @external
     */
    readonly connectorProfileName: string;
    /**
     * `AWS::AppFlow::ConnectorProfile.ConnectorType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html#cfn-appflow-connectorprofile-connectortype
     * @external
     */
    readonly connectorType: string;
    /**
     * `AWS::AppFlow::ConnectorProfile.ConnectorProfileConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html#cfn-appflow-connectorprofile-connectorprofileconfig
     * @external
     */
    readonly connectorProfileConfig?: CfnConnectorProfile.ConnectorProfileConfigProperty | cdk.IResolvable;
    /**
     * `AWS::AppFlow::ConnectorProfile.KMSArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html#cfn-appflow-connectorprofile-kmsarn
     * @external
     */
    readonly kmsArn?: string;
}
/**
 * A CloudFormation `AWS::AppFlow::ConnectorProfile`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html
 * @external
 * @cloudformationResource AWS::AppFlow::ConnectorProfile
 */
export declare class CfnConnectorProfile extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AppFlow::ConnectorProfile";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnConnectorProfile;
    /**
     * @external
     * @cloudformationAttribute ConnectorProfileArn
     */
    readonly attrConnectorProfileArn: string;
    /**
     * @external
     * @cloudformationAttribute CredentialsArn
     */
    readonly attrCredentialsArn: string;
    /**
     * `AWS::AppFlow::ConnectorProfile.ConnectionMode`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html#cfn-appflow-connectorprofile-connectionmode
     * @external
     */
    connectionMode: string;
    /**
     * `AWS::AppFlow::ConnectorProfile.ConnectorProfileName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html#cfn-appflow-connectorprofile-connectorprofilename
     * @external
     */
    connectorProfileName: string;
    /**
     * `AWS::AppFlow::ConnectorProfile.ConnectorType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html#cfn-appflow-connectorprofile-connectortype
     * @external
     */
    connectorType: string;
    /**
     * `AWS::AppFlow::ConnectorProfile.ConnectorProfileConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html#cfn-appflow-connectorprofile-connectorprofileconfig
     * @external
     */
    connectorProfileConfig: CfnConnectorProfile.ConnectorProfileConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::AppFlow::ConnectorProfile.KMSArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html#cfn-appflow-connectorprofile-kmsarn
     * @external
     */
    kmsArn: string | undefined;
    /**
     * Create a new `AWS::AppFlow::ConnectorProfile`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnConnectorProfileProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::AppFlow::ConnectorProfile`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html
 * @external
 * @cloudformationResource AWS::AppFlow::ConnectorProfile
 */
export declare namespace CfnConnectorProfile {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-amplitudeconnectorprofilecredentials.html
     * @external
     */
    interface AmplitudeConnectorProfileCredentialsProperty {
        /**
         * `CfnConnectorProfile.AmplitudeConnectorProfileCredentialsProperty.ApiKey`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-amplitudeconnectorprofilecredentials.html#cfn-appflow-connectorprofile-amplitudeconnectorprofilecredentials-apikey
         * @external
         */
        readonly apiKey: string;
        /**
         * `CfnConnectorProfile.AmplitudeConnectorProfileCredentialsProperty.SecretKey`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-amplitudeconnectorprofilecredentials.html#cfn-appflow-connectorprofile-amplitudeconnectorprofilecredentials-secretkey
         * @external
         */
        readonly secretKey: string;
    }
}
/**
 * A CloudFormation `AWS::AppFlow::ConnectorProfile`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html
 * @external
 * @cloudformationResource AWS::AppFlow::ConnectorProfile
 */
export declare namespace CfnConnectorProfile {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectoroauthrequest.html
     * @external
     */
    interface ConnectorOAuthRequestProperty {
        /**
         * `CfnConnectorProfile.ConnectorOAuthRequestProperty.AuthCode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectoroauthrequest.html#cfn-appflow-connectorprofile-connectoroauthrequest-authcode
         * @external
         */
        readonly authCode?: string;
        /**
         * `CfnConnectorProfile.ConnectorOAuthRequestProperty.RedirectUri`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectoroauthrequest.html#cfn-appflow-connectorprofile-connectoroauthrequest-redirecturi
         * @external
         */
        readonly redirectUri?: string;
    }
}
/**
 * A CloudFormation `AWS::AppFlow::ConnectorProfile`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html
 * @external
 * @cloudformationResource AWS::AppFlow::ConnectorProfile
 */
export declare namespace CfnConnectorProfile {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofileconfig.html
     * @external
     */
    interface ConnectorProfileConfigProperty {
        /**
         * `CfnConnectorProfile.ConnectorProfileConfigProperty.ConnectorProfileCredentials`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofileconfig.html#cfn-appflow-connectorprofile-connectorprofileconfig-connectorprofilecredentials
         * @external
         */
        readonly connectorProfileCredentials: CfnConnectorProfile.ConnectorProfileCredentialsProperty | cdk.IResolvable;
        /**
         * `CfnConnectorProfile.ConnectorProfileConfigProperty.ConnectorProfileProperties`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofileconfig.html#cfn-appflow-connectorprofile-connectorprofileconfig-connectorprofileproperties
         * @external
         */
        readonly connectorProfileProperties?: CfnConnectorProfile.ConnectorProfilePropertiesProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppFlow::ConnectorProfile`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html
 * @external
 * @cloudformationResource AWS::AppFlow::ConnectorProfile
 */
export declare namespace CfnConnectorProfile {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofilecredentials.html
     * @external
     */
    interface ConnectorProfileCredentialsProperty {
        /**
         * `CfnConnectorProfile.ConnectorProfileCredentialsProperty.Amplitude`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofilecredentials.html#cfn-appflow-connectorprofile-connectorprofilecredentials-amplitude
         * @external
         */
        readonly amplitude?: CfnConnectorProfile.AmplitudeConnectorProfileCredentialsProperty | cdk.IResolvable;
        /**
         * `CfnConnectorProfile.ConnectorProfileCredentialsProperty.Datadog`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofilecredentials.html#cfn-appflow-connectorprofile-connectorprofilecredentials-datadog
         * @external
         */
        readonly datadog?: CfnConnectorProfile.DatadogConnectorProfileCredentialsProperty | cdk.IResolvable;
        /**
         * `CfnConnectorProfile.ConnectorProfileCredentialsProperty.Dynatrace`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofilecredentials.html#cfn-appflow-connectorprofile-connectorprofilecredentials-dynatrace
         * @external
         */
        readonly dynatrace?: CfnConnectorProfile.DynatraceConnectorProfileCredentialsProperty | cdk.IResolvable;
        /**
         * `CfnConnectorProfile.ConnectorProfileCredentialsProperty.GoogleAnalytics`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofilecredentials.html#cfn-appflow-connectorprofile-connectorprofilecredentials-googleanalytics
         * @external
         */
        readonly googleAnalytics?: CfnConnectorProfile.GoogleAnalyticsConnectorProfileCredentialsProperty | cdk.IResolvable;
        /**
         * `CfnConnectorProfile.ConnectorProfileCredentialsProperty.InforNexus`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofilecredentials.html#cfn-appflow-connectorprofile-connectorprofilecredentials-infornexus
         * @external
         */
        readonly inforNexus?: CfnConnectorProfile.InforNexusConnectorProfileCredentialsProperty | cdk.IResolvable;
        /**
         * `CfnConnectorProfile.ConnectorProfileCredentialsProperty.Marketo`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofilecredentials.html#cfn-appflow-connectorprofile-connectorprofilecredentials-marketo
         * @external
         */
        readonly marketo?: CfnConnectorProfile.MarketoConnectorProfileCredentialsProperty | cdk.IResolvable;
        /**
         * `CfnConnectorProfile.ConnectorProfileCredentialsProperty.Redshift`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofilecredentials.html#cfn-appflow-connectorprofile-connectorprofilecredentials-redshift
         * @external
         */
        readonly redshift?: CfnConnectorProfile.RedshiftConnectorProfileCredentialsProperty | cdk.IResolvable;
        /**
         * `CfnConnectorProfile.ConnectorProfileCredentialsProperty.Salesforce`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofilecredentials.html#cfn-appflow-connectorprofile-connectorprofilecredentials-salesforce
         * @external
         */
        readonly salesforce?: CfnConnectorProfile.SalesforceConnectorProfileCredentialsProperty | cdk.IResolvable;
        /**
         * `CfnConnectorProfile.ConnectorProfileCredentialsProperty.ServiceNow`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofilecredentials.html#cfn-appflow-connectorprofile-connectorprofilecredentials-servicenow
         * @external
         */
        readonly serviceNow?: CfnConnectorProfile.ServiceNowConnectorProfileCredentialsProperty | cdk.IResolvable;
        /**
         * `CfnConnectorProfile.ConnectorProfileCredentialsProperty.Singular`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofilecredentials.html#cfn-appflow-connectorprofile-connectorprofilecredentials-singular
         * @external
         */
        readonly singular?: CfnConnectorProfile.SingularConnectorProfileCredentialsProperty | cdk.IResolvable;
        /**
         * `CfnConnectorProfile.ConnectorProfileCredentialsProperty.Slack`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofilecredentials.html#cfn-appflow-connectorprofile-connectorprofilecredentials-slack
         * @external
         */
        readonly slack?: CfnConnectorProfile.SlackConnectorProfileCredentialsProperty | cdk.IResolvable;
        /**
         * `CfnConnectorProfile.ConnectorProfileCredentialsProperty.Snowflake`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofilecredentials.html#cfn-appflow-connectorprofile-connectorprofilecredentials-snowflake
         * @external
         */
        readonly snowflake?: CfnConnectorProfile.SnowflakeConnectorProfileCredentialsProperty | cdk.IResolvable;
        /**
         * `CfnConnectorProfile.ConnectorProfileCredentialsProperty.Trendmicro`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofilecredentials.html#cfn-appflow-connectorprofile-connectorprofilecredentials-trendmicro
         * @external
         */
        readonly trendmicro?: CfnConnectorProfile.TrendmicroConnectorProfileCredentialsProperty | cdk.IResolvable;
        /**
         * `CfnConnectorProfile.ConnectorProfileCredentialsProperty.Veeva`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofilecredentials.html#cfn-appflow-connectorprofile-connectorprofilecredentials-veeva
         * @external
         */
        readonly veeva?: CfnConnectorProfile.VeevaConnectorProfileCredentialsProperty | cdk.IResolvable;
        /**
         * `CfnConnectorProfile.ConnectorProfileCredentialsProperty.Zendesk`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofilecredentials.html#cfn-appflow-connectorprofile-connectorprofilecredentials-zendesk
         * @external
         */
        readonly zendesk?: CfnConnectorProfile.ZendeskConnectorProfileCredentialsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppFlow::ConnectorProfile`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html
 * @external
 * @cloudformationResource AWS::AppFlow::ConnectorProfile
 */
export declare namespace CfnConnectorProfile {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofileproperties.html
     * @external
     */
    interface ConnectorProfilePropertiesProperty {
        /**
         * `CfnConnectorProfile.ConnectorProfilePropertiesProperty.Datadog`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofileproperties.html#cfn-appflow-connectorprofile-connectorprofileproperties-datadog
         * @external
         */
        readonly datadog?: CfnConnectorProfile.DatadogConnectorProfilePropertiesProperty | cdk.IResolvable;
        /**
         * `CfnConnectorProfile.ConnectorProfilePropertiesProperty.Dynatrace`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofileproperties.html#cfn-appflow-connectorprofile-connectorprofileproperties-dynatrace
         * @external
         */
        readonly dynatrace?: CfnConnectorProfile.DynatraceConnectorProfilePropertiesProperty | cdk.IResolvable;
        /**
         * `CfnConnectorProfile.ConnectorProfilePropertiesProperty.InforNexus`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofileproperties.html#cfn-appflow-connectorprofile-connectorprofileproperties-infornexus
         * @external
         */
        readonly inforNexus?: CfnConnectorProfile.InforNexusConnectorProfilePropertiesProperty | cdk.IResolvable;
        /**
         * `CfnConnectorProfile.ConnectorProfilePropertiesProperty.Marketo`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofileproperties.html#cfn-appflow-connectorprofile-connectorprofileproperties-marketo
         * @external
         */
        readonly marketo?: CfnConnectorProfile.MarketoConnectorProfilePropertiesProperty | cdk.IResolvable;
        /**
         * `CfnConnectorProfile.ConnectorProfilePropertiesProperty.Redshift`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofileproperties.html#cfn-appflow-connectorprofile-connectorprofileproperties-redshift
         * @external
         */
        readonly redshift?: CfnConnectorProfile.RedshiftConnectorProfilePropertiesProperty | cdk.IResolvable;
        /**
         * `CfnConnectorProfile.ConnectorProfilePropertiesProperty.Salesforce`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofileproperties.html#cfn-appflow-connectorprofile-connectorprofileproperties-salesforce
         * @external
         */
        readonly salesforce?: CfnConnectorProfile.SalesforceConnectorProfilePropertiesProperty | cdk.IResolvable;
        /**
         * `CfnConnectorProfile.ConnectorProfilePropertiesProperty.ServiceNow`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofileproperties.html#cfn-appflow-connectorprofile-connectorprofileproperties-servicenow
         * @external
         */
        readonly serviceNow?: CfnConnectorProfile.ServiceNowConnectorProfilePropertiesProperty | cdk.IResolvable;
        /**
         * `CfnConnectorProfile.ConnectorProfilePropertiesProperty.Slack`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofileproperties.html#cfn-appflow-connectorprofile-connectorprofileproperties-slack
         * @external
         */
        readonly slack?: CfnConnectorProfile.SlackConnectorProfilePropertiesProperty | cdk.IResolvable;
        /**
         * `CfnConnectorProfile.ConnectorProfilePropertiesProperty.Snowflake`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofileproperties.html#cfn-appflow-connectorprofile-connectorprofileproperties-snowflake
         * @external
         */
        readonly snowflake?: CfnConnectorProfile.SnowflakeConnectorProfilePropertiesProperty | cdk.IResolvable;
        /**
         * `CfnConnectorProfile.ConnectorProfilePropertiesProperty.Veeva`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofileproperties.html#cfn-appflow-connectorprofile-connectorprofileproperties-veeva
         * @external
         */
        readonly veeva?: CfnConnectorProfile.VeevaConnectorProfilePropertiesProperty | cdk.IResolvable;
        /**
         * `CfnConnectorProfile.ConnectorProfilePropertiesProperty.Zendesk`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofileproperties.html#cfn-appflow-connectorprofile-connectorprofileproperties-zendesk
         * @external
         */
        readonly zendesk?: CfnConnectorProfile.ZendeskConnectorProfilePropertiesProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppFlow::ConnectorProfile`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html
 * @external
 * @cloudformationResource AWS::AppFlow::ConnectorProfile
 */
export declare namespace CfnConnectorProfile {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-datadogconnectorprofilecredentials.html
     * @external
     */
    interface DatadogConnectorProfileCredentialsProperty {
        /**
         * `CfnConnectorProfile.DatadogConnectorProfileCredentialsProperty.ApiKey`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-datadogconnectorprofilecredentials.html#cfn-appflow-connectorprofile-datadogconnectorprofilecredentials-apikey
         * @external
         */
        readonly apiKey: string;
        /**
         * `CfnConnectorProfile.DatadogConnectorProfileCredentialsProperty.ApplicationKey`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-datadogconnectorprofilecredentials.html#cfn-appflow-connectorprofile-datadogconnectorprofilecredentials-applicationkey
         * @external
         */
        readonly applicationKey: string;
    }
}
/**
 * A CloudFormation `AWS::AppFlow::ConnectorProfile`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html
 * @external
 * @cloudformationResource AWS::AppFlow::ConnectorProfile
 */
export declare namespace CfnConnectorProfile {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-datadogconnectorprofileproperties.html
     * @external
     */
    interface DatadogConnectorProfilePropertiesProperty {
        /**
         * `CfnConnectorProfile.DatadogConnectorProfilePropertiesProperty.InstanceUrl`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-datadogconnectorprofileproperties.html#cfn-appflow-connectorprofile-datadogconnectorprofileproperties-instanceurl
         * @external
         */
        readonly instanceUrl: string;
    }
}
/**
 * A CloudFormation `AWS::AppFlow::ConnectorProfile`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html
 * @external
 * @cloudformationResource AWS::AppFlow::ConnectorProfile
 */
export declare namespace CfnConnectorProfile {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-dynatraceconnectorprofilecredentials.html
     * @external
     */
    interface DynatraceConnectorProfileCredentialsProperty {
        /**
         * `CfnConnectorProfile.DynatraceConnectorProfileCredentialsProperty.ApiToken`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-dynatraceconnectorprofilecredentials.html#cfn-appflow-connectorprofile-dynatraceconnectorprofilecredentials-apitoken
         * @external
         */
        readonly apiToken: string;
    }
}
/**
 * A CloudFormation `AWS::AppFlow::ConnectorProfile`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html
 * @external
 * @cloudformationResource AWS::AppFlow::ConnectorProfile
 */
export declare namespace CfnConnectorProfile {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-dynatraceconnectorprofileproperties.html
     * @external
     */
    interface DynatraceConnectorProfilePropertiesProperty {
        /**
         * `CfnConnectorProfile.DynatraceConnectorProfilePropertiesProperty.InstanceUrl`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-dynatraceconnectorprofileproperties.html#cfn-appflow-connectorprofile-dynatraceconnectorprofileproperties-instanceurl
         * @external
         */
        readonly instanceUrl: string;
    }
}
/**
 * A CloudFormation `AWS::AppFlow::ConnectorProfile`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html
 * @external
 * @cloudformationResource AWS::AppFlow::ConnectorProfile
 */
export declare namespace CfnConnectorProfile {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-googleanalyticsconnectorprofilecredentials.html
     * @external
     */
    interface GoogleAnalyticsConnectorProfileCredentialsProperty {
        /**
         * `CfnConnectorProfile.GoogleAnalyticsConnectorProfileCredentialsProperty.AccessToken`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-googleanalyticsconnectorprofilecredentials.html#cfn-appflow-connectorprofile-googleanalyticsconnectorprofilecredentials-accesstoken
         * @external
         */
        readonly accessToken?: string;
        /**
         * `CfnConnectorProfile.GoogleAnalyticsConnectorProfileCredentialsProperty.ClientId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-googleanalyticsconnectorprofilecredentials.html#cfn-appflow-connectorprofile-googleanalyticsconnectorprofilecredentials-clientid
         * @external
         */
        readonly clientId: string;
        /**
         * `CfnConnectorProfile.GoogleAnalyticsConnectorProfileCredentialsProperty.ClientSecret`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-googleanalyticsconnectorprofilecredentials.html#cfn-appflow-connectorprofile-googleanalyticsconnectorprofilecredentials-clientsecret
         * @external
         */
        readonly clientSecret: string;
        /**
         * `CfnConnectorProfile.GoogleAnalyticsConnectorProfileCredentialsProperty.ConnectorOAuthRequest`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-googleanalyticsconnectorprofilecredentials.html#cfn-appflow-connectorprofile-googleanalyticsconnectorprofilecredentials-connectoroauthrequest
         * @external
         */
        readonly connectorOAuthRequest?: CfnConnectorProfile.ConnectorOAuthRequestProperty | cdk.IResolvable;
        /**
         * `CfnConnectorProfile.GoogleAnalyticsConnectorProfileCredentialsProperty.RefreshToken`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-googleanalyticsconnectorprofilecredentials.html#cfn-appflow-connectorprofile-googleanalyticsconnectorprofilecredentials-refreshtoken
         * @external
         */
        readonly refreshToken?: string;
    }
}
/**
 * A CloudFormation `AWS::AppFlow::ConnectorProfile`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html
 * @external
 * @cloudformationResource AWS::AppFlow::ConnectorProfile
 */
export declare namespace CfnConnectorProfile {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-infornexusconnectorprofilecredentials.html
     * @external
     */
    interface InforNexusConnectorProfileCredentialsProperty {
        /**
         * `CfnConnectorProfile.InforNexusConnectorProfileCredentialsProperty.AccessKeyId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-infornexusconnectorprofilecredentials.html#cfn-appflow-connectorprofile-infornexusconnectorprofilecredentials-accesskeyid
         * @external
         */
        readonly accessKeyId: string;
        /**
         * `CfnConnectorProfile.InforNexusConnectorProfileCredentialsProperty.Datakey`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-infornexusconnectorprofilecredentials.html#cfn-appflow-connectorprofile-infornexusconnectorprofilecredentials-datakey
         * @external
         */
        readonly datakey: string;
        /**
         * `CfnConnectorProfile.InforNexusConnectorProfileCredentialsProperty.SecretAccessKey`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-infornexusconnectorprofilecredentials.html#cfn-appflow-connectorprofile-infornexusconnectorprofilecredentials-secretaccesskey
         * @external
         */
        readonly secretAccessKey: string;
        /**
         * `CfnConnectorProfile.InforNexusConnectorProfileCredentialsProperty.UserId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-infornexusconnectorprofilecredentials.html#cfn-appflow-connectorprofile-infornexusconnectorprofilecredentials-userid
         * @external
         */
        readonly userId: string;
    }
}
/**
 * A CloudFormation `AWS::AppFlow::ConnectorProfile`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html
 * @external
 * @cloudformationResource AWS::AppFlow::ConnectorProfile
 */
export declare namespace CfnConnectorProfile {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-infornexusconnectorprofileproperties.html
     * @external
     */
    interface InforNexusConnectorProfilePropertiesProperty {
        /**
         * `CfnConnectorProfile.InforNexusConnectorProfilePropertiesProperty.InstanceUrl`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-infornexusconnectorprofileproperties.html#cfn-appflow-connectorprofile-infornexusconnectorprofileproperties-instanceurl
         * @external
         */
        readonly instanceUrl: string;
    }
}
/**
 * A CloudFormation `AWS::AppFlow::ConnectorProfile`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html
 * @external
 * @cloudformationResource AWS::AppFlow::ConnectorProfile
 */
export declare namespace CfnConnectorProfile {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-marketoconnectorprofilecredentials.html
     * @external
     */
    interface MarketoConnectorProfileCredentialsProperty {
        /**
         * `CfnConnectorProfile.MarketoConnectorProfileCredentialsProperty.AccessToken`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-marketoconnectorprofilecredentials.html#cfn-appflow-connectorprofile-marketoconnectorprofilecredentials-accesstoken
         * @external
         */
        readonly accessToken?: string;
        /**
         * `CfnConnectorProfile.MarketoConnectorProfileCredentialsProperty.ClientId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-marketoconnectorprofilecredentials.html#cfn-appflow-connectorprofile-marketoconnectorprofilecredentials-clientid
         * @external
         */
        readonly clientId: string;
        /**
         * `CfnConnectorProfile.MarketoConnectorProfileCredentialsProperty.ClientSecret`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-marketoconnectorprofilecredentials.html#cfn-appflow-connectorprofile-marketoconnectorprofilecredentials-clientsecret
         * @external
         */
        readonly clientSecret: string;
        /**
         * `CfnConnectorProfile.MarketoConnectorProfileCredentialsProperty.ConnectorOAuthRequest`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-marketoconnectorprofilecredentials.html#cfn-appflow-connectorprofile-marketoconnectorprofilecredentials-connectoroauthrequest
         * @external
         */
        readonly connectorOAuthRequest?: CfnConnectorProfile.ConnectorOAuthRequestProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppFlow::ConnectorProfile`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html
 * @external
 * @cloudformationResource AWS::AppFlow::ConnectorProfile
 */
export declare namespace CfnConnectorProfile {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-marketoconnectorprofileproperties.html
     * @external
     */
    interface MarketoConnectorProfilePropertiesProperty {
        /**
         * `CfnConnectorProfile.MarketoConnectorProfilePropertiesProperty.InstanceUrl`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-marketoconnectorprofileproperties.html#cfn-appflow-connectorprofile-marketoconnectorprofileproperties-instanceurl
         * @external
         */
        readonly instanceUrl: string;
    }
}
/**
 * A CloudFormation `AWS::AppFlow::ConnectorProfile`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html
 * @external
 * @cloudformationResource AWS::AppFlow::ConnectorProfile
 */
export declare namespace CfnConnectorProfile {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-redshiftconnectorprofilecredentials.html
     * @external
     */
    interface RedshiftConnectorProfileCredentialsProperty {
        /**
         * `CfnConnectorProfile.RedshiftConnectorProfileCredentialsProperty.Password`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-redshiftconnectorprofilecredentials.html#cfn-appflow-connectorprofile-redshiftconnectorprofilecredentials-password
         * @external
         */
        readonly password: string;
        /**
         * `CfnConnectorProfile.RedshiftConnectorProfileCredentialsProperty.Username`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-redshiftconnectorprofilecredentials.html#cfn-appflow-connectorprofile-redshiftconnectorprofilecredentials-username
         * @external
         */
        readonly username: string;
    }
}
/**
 * A CloudFormation `AWS::AppFlow::ConnectorProfile`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html
 * @external
 * @cloudformationResource AWS::AppFlow::ConnectorProfile
 */
export declare namespace CfnConnectorProfile {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-redshiftconnectorprofileproperties.html
     * @external
     */
    interface RedshiftConnectorProfilePropertiesProperty {
        /**
         * `CfnConnectorProfile.RedshiftConnectorProfilePropertiesProperty.BucketName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-redshiftconnectorprofileproperties.html#cfn-appflow-connectorprofile-redshiftconnectorprofileproperties-bucketname
         * @external
         */
        readonly bucketName: string;
        /**
         * `CfnConnectorProfile.RedshiftConnectorProfilePropertiesProperty.BucketPrefix`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-redshiftconnectorprofileproperties.html#cfn-appflow-connectorprofile-redshiftconnectorprofileproperties-bucketprefix
         * @external
         */
        readonly bucketPrefix?: string;
        /**
         * `CfnConnectorProfile.RedshiftConnectorProfilePropertiesProperty.DatabaseUrl`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-redshiftconnectorprofileproperties.html#cfn-appflow-connectorprofile-redshiftconnectorprofileproperties-databaseurl
         * @external
         */
        readonly databaseUrl: string;
        /**
         * `CfnConnectorProfile.RedshiftConnectorProfilePropertiesProperty.RoleArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-redshiftconnectorprofileproperties.html#cfn-appflow-connectorprofile-redshiftconnectorprofileproperties-rolearn
         * @external
         */
        readonly roleArn: string;
    }
}
/**
 * A CloudFormation `AWS::AppFlow::ConnectorProfile`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html
 * @external
 * @cloudformationResource AWS::AppFlow::ConnectorProfile
 */
export declare namespace CfnConnectorProfile {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-salesforceconnectorprofilecredentials.html
     * @external
     */
    interface SalesforceConnectorProfileCredentialsProperty {
        /**
         * `CfnConnectorProfile.SalesforceConnectorProfileCredentialsProperty.AccessToken`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-salesforceconnectorprofilecredentials.html#cfn-appflow-connectorprofile-salesforceconnectorprofilecredentials-accesstoken
         * @external
         */
        readonly accessToken?: string;
        /**
         * `CfnConnectorProfile.SalesforceConnectorProfileCredentialsProperty.ConnectorOAuthRequest`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-salesforceconnectorprofilecredentials.html#cfn-appflow-connectorprofile-salesforceconnectorprofilecredentials-connectoroauthrequest
         * @external
         */
        readonly connectorOAuthRequest?: CfnConnectorProfile.ConnectorOAuthRequestProperty | cdk.IResolvable;
        /**
         * `CfnConnectorProfile.SalesforceConnectorProfileCredentialsProperty.RefreshToken`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-salesforceconnectorprofilecredentials.html#cfn-appflow-connectorprofile-salesforceconnectorprofilecredentials-refreshtoken
         * @external
         */
        readonly refreshToken?: string;
    }
}
/**
 * A CloudFormation `AWS::AppFlow::ConnectorProfile`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html
 * @external
 * @cloudformationResource AWS::AppFlow::ConnectorProfile
 */
export declare namespace CfnConnectorProfile {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-salesforceconnectorprofileproperties.html
     * @external
     */
    interface SalesforceConnectorProfilePropertiesProperty {
        /**
         * `CfnConnectorProfile.SalesforceConnectorProfilePropertiesProperty.InstanceUrl`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-salesforceconnectorprofileproperties.html#cfn-appflow-connectorprofile-salesforceconnectorprofileproperties-instanceurl
         * @external
         */
        readonly instanceUrl?: string;
        /**
         * `CfnConnectorProfile.SalesforceConnectorProfilePropertiesProperty.isSandboxEnvironment`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-salesforceconnectorprofileproperties.html#cfn-appflow-connectorprofile-salesforceconnectorprofileproperties-issandboxenvironment
         * @external
         */
        readonly isSandboxEnvironment?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppFlow::ConnectorProfile`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html
 * @external
 * @cloudformationResource AWS::AppFlow::ConnectorProfile
 */
export declare namespace CfnConnectorProfile {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-servicenowconnectorprofilecredentials.html
     * @external
     */
    interface ServiceNowConnectorProfileCredentialsProperty {
        /**
         * `CfnConnectorProfile.ServiceNowConnectorProfileCredentialsProperty.Password`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-servicenowconnectorprofilecredentials.html#cfn-appflow-connectorprofile-servicenowconnectorprofilecredentials-password
         * @external
         */
        readonly password: string;
        /**
         * `CfnConnectorProfile.ServiceNowConnectorProfileCredentialsProperty.Username`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-servicenowconnectorprofilecredentials.html#cfn-appflow-connectorprofile-servicenowconnectorprofilecredentials-username
         * @external
         */
        readonly username: string;
    }
}
/**
 * A CloudFormation `AWS::AppFlow::ConnectorProfile`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html
 * @external
 * @cloudformationResource AWS::AppFlow::ConnectorProfile
 */
export declare namespace CfnConnectorProfile {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-servicenowconnectorprofileproperties.html
     * @external
     */
    interface ServiceNowConnectorProfilePropertiesProperty {
        /**
         * `CfnConnectorProfile.ServiceNowConnectorProfilePropertiesProperty.InstanceUrl`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-servicenowconnectorprofileproperties.html#cfn-appflow-connectorprofile-servicenowconnectorprofileproperties-instanceurl
         * @external
         */
        readonly instanceUrl: string;
    }
}
/**
 * A CloudFormation `AWS::AppFlow::ConnectorProfile`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html
 * @external
 * @cloudformationResource AWS::AppFlow::ConnectorProfile
 */
export declare namespace CfnConnectorProfile {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-singularconnectorprofilecredentials.html
     * @external
     */
    interface SingularConnectorProfileCredentialsProperty {
        /**
         * `CfnConnectorProfile.SingularConnectorProfileCredentialsProperty.ApiKey`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-singularconnectorprofilecredentials.html#cfn-appflow-connectorprofile-singularconnectorprofilecredentials-apikey
         * @external
         */
        readonly apiKey: string;
    }
}
/**
 * A CloudFormation `AWS::AppFlow::ConnectorProfile`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html
 * @external
 * @cloudformationResource AWS::AppFlow::ConnectorProfile
 */
export declare namespace CfnConnectorProfile {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-slackconnectorprofilecredentials.html
     * @external
     */
    interface SlackConnectorProfileCredentialsProperty {
        /**
         * `CfnConnectorProfile.SlackConnectorProfileCredentialsProperty.AccessToken`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-slackconnectorprofilecredentials.html#cfn-appflow-connectorprofile-slackconnectorprofilecredentials-accesstoken
         * @external
         */
        readonly accessToken?: string;
        /**
         * `CfnConnectorProfile.SlackConnectorProfileCredentialsProperty.ClientId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-slackconnectorprofilecredentials.html#cfn-appflow-connectorprofile-slackconnectorprofilecredentials-clientid
         * @external
         */
        readonly clientId: string;
        /**
         * `CfnConnectorProfile.SlackConnectorProfileCredentialsProperty.ClientSecret`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-slackconnectorprofilecredentials.html#cfn-appflow-connectorprofile-slackconnectorprofilecredentials-clientsecret
         * @external
         */
        readonly clientSecret: string;
        /**
         * `CfnConnectorProfile.SlackConnectorProfileCredentialsProperty.ConnectorOAuthRequest`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-slackconnectorprofilecredentials.html#cfn-appflow-connectorprofile-slackconnectorprofilecredentials-connectoroauthrequest
         * @external
         */
        readonly connectorOAuthRequest?: CfnConnectorProfile.ConnectorOAuthRequestProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppFlow::ConnectorProfile`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html
 * @external
 * @cloudformationResource AWS::AppFlow::ConnectorProfile
 */
export declare namespace CfnConnectorProfile {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-slackconnectorprofileproperties.html
     * @external
     */
    interface SlackConnectorProfilePropertiesProperty {
        /**
         * `CfnConnectorProfile.SlackConnectorProfilePropertiesProperty.InstanceUrl`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-slackconnectorprofileproperties.html#cfn-appflow-connectorprofile-slackconnectorprofileproperties-instanceurl
         * @external
         */
        readonly instanceUrl: string;
    }
}
/**
 * A CloudFormation `AWS::AppFlow::ConnectorProfile`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html
 * @external
 * @cloudformationResource AWS::AppFlow::ConnectorProfile
 */
export declare namespace CfnConnectorProfile {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-snowflakeconnectorprofilecredentials.html
     * @external
     */
    interface SnowflakeConnectorProfileCredentialsProperty {
        /**
         * `CfnConnectorProfile.SnowflakeConnectorProfileCredentialsProperty.Password`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-snowflakeconnectorprofilecredentials.html#cfn-appflow-connectorprofile-snowflakeconnectorprofilecredentials-password
         * @external
         */
        readonly password: string;
        /**
         * `CfnConnectorProfile.SnowflakeConnectorProfileCredentialsProperty.Username`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-snowflakeconnectorprofilecredentials.html#cfn-appflow-connectorprofile-snowflakeconnectorprofilecredentials-username
         * @external
         */
        readonly username: string;
    }
}
/**
 * A CloudFormation `AWS::AppFlow::ConnectorProfile`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html
 * @external
 * @cloudformationResource AWS::AppFlow::ConnectorProfile
 */
export declare namespace CfnConnectorProfile {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-snowflakeconnectorprofileproperties.html
     * @external
     */
    interface SnowflakeConnectorProfilePropertiesProperty {
        /**
         * `CfnConnectorProfile.SnowflakeConnectorProfilePropertiesProperty.AccountName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-snowflakeconnectorprofileproperties.html#cfn-appflow-connectorprofile-snowflakeconnectorprofileproperties-accountname
         * @external
         */
        readonly accountName?: string;
        /**
         * `CfnConnectorProfile.SnowflakeConnectorProfilePropertiesProperty.BucketName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-snowflakeconnectorprofileproperties.html#cfn-appflow-connectorprofile-snowflakeconnectorprofileproperties-bucketname
         * @external
         */
        readonly bucketName: string;
        /**
         * `CfnConnectorProfile.SnowflakeConnectorProfilePropertiesProperty.BucketPrefix`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-snowflakeconnectorprofileproperties.html#cfn-appflow-connectorprofile-snowflakeconnectorprofileproperties-bucketprefix
         * @external
         */
        readonly bucketPrefix?: string;
        /**
         * `CfnConnectorProfile.SnowflakeConnectorProfilePropertiesProperty.PrivateLinkServiceName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-snowflakeconnectorprofileproperties.html#cfn-appflow-connectorprofile-snowflakeconnectorprofileproperties-privatelinkservicename
         * @external
         */
        readonly privateLinkServiceName?: string;
        /**
         * `CfnConnectorProfile.SnowflakeConnectorProfilePropertiesProperty.Region`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-snowflakeconnectorprofileproperties.html#cfn-appflow-connectorprofile-snowflakeconnectorprofileproperties-region
         * @external
         */
        readonly region?: string;
        /**
         * `CfnConnectorProfile.SnowflakeConnectorProfilePropertiesProperty.Stage`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-snowflakeconnectorprofileproperties.html#cfn-appflow-connectorprofile-snowflakeconnectorprofileproperties-stage
         * @external
         */
        readonly stage: string;
        /**
         * `CfnConnectorProfile.SnowflakeConnectorProfilePropertiesProperty.Warehouse`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-snowflakeconnectorprofileproperties.html#cfn-appflow-connectorprofile-snowflakeconnectorprofileproperties-warehouse
         * @external
         */
        readonly warehouse: string;
    }
}
/**
 * A CloudFormation `AWS::AppFlow::ConnectorProfile`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html
 * @external
 * @cloudformationResource AWS::AppFlow::ConnectorProfile
 */
export declare namespace CfnConnectorProfile {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-trendmicroconnectorprofilecredentials.html
     * @external
     */
    interface TrendmicroConnectorProfileCredentialsProperty {
        /**
         * `CfnConnectorProfile.TrendmicroConnectorProfileCredentialsProperty.ApiSecretKey`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-trendmicroconnectorprofilecredentials.html#cfn-appflow-connectorprofile-trendmicroconnectorprofilecredentials-apisecretkey
         * @external
         */
        readonly apiSecretKey: string;
    }
}
/**
 * A CloudFormation `AWS::AppFlow::ConnectorProfile`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html
 * @external
 * @cloudformationResource AWS::AppFlow::ConnectorProfile
 */
export declare namespace CfnConnectorProfile {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-veevaconnectorprofilecredentials.html
     * @external
     */
    interface VeevaConnectorProfileCredentialsProperty {
        /**
         * `CfnConnectorProfile.VeevaConnectorProfileCredentialsProperty.Password`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-veevaconnectorprofilecredentials.html#cfn-appflow-connectorprofile-veevaconnectorprofilecredentials-password
         * @external
         */
        readonly password: string;
        /**
         * `CfnConnectorProfile.VeevaConnectorProfileCredentialsProperty.Username`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-veevaconnectorprofilecredentials.html#cfn-appflow-connectorprofile-veevaconnectorprofilecredentials-username
         * @external
         */
        readonly username: string;
    }
}
/**
 * A CloudFormation `AWS::AppFlow::ConnectorProfile`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html
 * @external
 * @cloudformationResource AWS::AppFlow::ConnectorProfile
 */
export declare namespace CfnConnectorProfile {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-veevaconnectorprofileproperties.html
     * @external
     */
    interface VeevaConnectorProfilePropertiesProperty {
        /**
         * `CfnConnectorProfile.VeevaConnectorProfilePropertiesProperty.InstanceUrl`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-veevaconnectorprofileproperties.html#cfn-appflow-connectorprofile-veevaconnectorprofileproperties-instanceurl
         * @external
         */
        readonly instanceUrl: string;
    }
}
/**
 * A CloudFormation `AWS::AppFlow::ConnectorProfile`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html
 * @external
 * @cloudformationResource AWS::AppFlow::ConnectorProfile
 */
export declare namespace CfnConnectorProfile {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-zendeskconnectorprofilecredentials.html
     * @external
     */
    interface ZendeskConnectorProfileCredentialsProperty {
        /**
         * `CfnConnectorProfile.ZendeskConnectorProfileCredentialsProperty.AccessToken`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-zendeskconnectorprofilecredentials.html#cfn-appflow-connectorprofile-zendeskconnectorprofilecredentials-accesstoken
         * @external
         */
        readonly accessToken?: string;
        /**
         * `CfnConnectorProfile.ZendeskConnectorProfileCredentialsProperty.ClientId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-zendeskconnectorprofilecredentials.html#cfn-appflow-connectorprofile-zendeskconnectorprofilecredentials-clientid
         * @external
         */
        readonly clientId: string;
        /**
         * `CfnConnectorProfile.ZendeskConnectorProfileCredentialsProperty.ClientSecret`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-zendeskconnectorprofilecredentials.html#cfn-appflow-connectorprofile-zendeskconnectorprofilecredentials-clientsecret
         * @external
         */
        readonly clientSecret: string;
        /**
         * `CfnConnectorProfile.ZendeskConnectorProfileCredentialsProperty.ConnectorOAuthRequest`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-zendeskconnectorprofilecredentials.html#cfn-appflow-connectorprofile-zendeskconnectorprofilecredentials-connectoroauthrequest
         * @external
         */
        readonly connectorOAuthRequest?: CfnConnectorProfile.ConnectorOAuthRequestProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppFlow::ConnectorProfile`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html
 * @external
 * @cloudformationResource AWS::AppFlow::ConnectorProfile
 */
export declare namespace CfnConnectorProfile {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-zendeskconnectorprofileproperties.html
     * @external
     */
    interface ZendeskConnectorProfilePropertiesProperty {
        /**
         * `CfnConnectorProfile.ZendeskConnectorProfilePropertiesProperty.InstanceUrl`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-zendeskconnectorprofileproperties.html#cfn-appflow-connectorprofile-zendeskconnectorprofileproperties-instanceurl
         * @external
         */
        readonly instanceUrl: string;
    }
}
/**
 * Properties for defining a `AWS::AppFlow::Flow`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html
 * @external
 */
export interface CfnFlowProps {
    /**
     * `AWS::AppFlow::Flow.DestinationFlowConfigList`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-destinationflowconfiglist
     * @external
     */
    readonly destinationFlowConfigList: Array<CfnFlow.DestinationFlowConfigProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::AppFlow::Flow.FlowName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-flowname
     * @external
     */
    readonly flowName: string;
    /**
     * `AWS::AppFlow::Flow.SourceFlowConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-sourceflowconfig
     * @external
     */
    readonly sourceFlowConfig: CfnFlow.SourceFlowConfigProperty | cdk.IResolvable;
    /**
     * `AWS::AppFlow::Flow.Tasks`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-tasks
     * @external
     */
    readonly tasks: Array<CfnFlow.TaskProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::AppFlow::Flow.TriggerConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-triggerconfig
     * @external
     */
    readonly triggerConfig: CfnFlow.TriggerConfigProperty | cdk.IResolvable;
    /**
     * `AWS::AppFlow::Flow.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::AppFlow::Flow.KMSArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-kmsarn
     * @external
     */
    readonly kmsArn?: string;
    /**
     * `AWS::AppFlow::Flow.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::AppFlow::Flow`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html
 * @external
 * @cloudformationResource AWS::AppFlow::Flow
 */
export declare class CfnFlow extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AppFlow::Flow";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnFlow;
    /**
     * @external
     * @cloudformationAttribute FlowArn
     */
    readonly attrFlowArn: string;
    /**
     * `AWS::AppFlow::Flow.DestinationFlowConfigList`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-destinationflowconfiglist
     * @external
     */
    destinationFlowConfigList: Array<CfnFlow.DestinationFlowConfigProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::AppFlow::Flow.FlowName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-flowname
     * @external
     */
    flowName: string;
    /**
     * `AWS::AppFlow::Flow.SourceFlowConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-sourceflowconfig
     * @external
     */
    sourceFlowConfig: CfnFlow.SourceFlowConfigProperty | cdk.IResolvable;
    /**
     * `AWS::AppFlow::Flow.Tasks`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-tasks
     * @external
     */
    tasks: Array<CfnFlow.TaskProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::AppFlow::Flow.TriggerConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-triggerconfig
     * @external
     */
    triggerConfig: CfnFlow.TriggerConfigProperty | cdk.IResolvable;
    /**
     * `AWS::AppFlow::Flow.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::AppFlow::Flow.KMSArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-kmsarn
     * @external
     */
    kmsArn: string | undefined;
    /**
     * `AWS::AppFlow::Flow.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::AppFlow::Flow`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnFlowProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::AppFlow::Flow`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html
 * @external
 * @cloudformationResource AWS::AppFlow::Flow
 */
export declare namespace CfnFlow {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-aggregationconfig.html
     * @external
     */
    interface AggregationConfigProperty {
        /**
         * `CfnFlow.AggregationConfigProperty.AggregationType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-aggregationconfig.html#cfn-appflow-flow-aggregationconfig-aggregationtype
         * @external
         */
        readonly aggregationType?: string;
    }
}
/**
 * A CloudFormation `AWS::AppFlow::Flow`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html
 * @external
 * @cloudformationResource AWS::AppFlow::Flow
 */
export declare namespace CfnFlow {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-amplitudesourceproperties.html
     * @external
     */
    interface AmplitudeSourcePropertiesProperty {
        /**
         * `CfnFlow.AmplitudeSourcePropertiesProperty.Object`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-amplitudesourceproperties.html#cfn-appflow-flow-amplitudesourceproperties-object
         * @external
         */
        readonly object: string;
    }
}
/**
 * A CloudFormation `AWS::AppFlow::Flow`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html
 * @external
 * @cloudformationResource AWS::AppFlow::Flow
 */
export declare namespace CfnFlow {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-connectoroperator.html
     * @external
     */
    interface ConnectorOperatorProperty {
        /**
         * `CfnFlow.ConnectorOperatorProperty.Amplitude`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-connectoroperator.html#cfn-appflow-flow-connectoroperator-amplitude
         * @external
         */
        readonly amplitude?: string;
        /**
         * `CfnFlow.ConnectorOperatorProperty.Datadog`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-connectoroperator.html#cfn-appflow-flow-connectoroperator-datadog
         * @external
         */
        readonly datadog?: string;
        /**
         * `CfnFlow.ConnectorOperatorProperty.Dynatrace`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-connectoroperator.html#cfn-appflow-flow-connectoroperator-dynatrace
         * @external
         */
        readonly dynatrace?: string;
        /**
         * `CfnFlow.ConnectorOperatorProperty.GoogleAnalytics`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-connectoroperator.html#cfn-appflow-flow-connectoroperator-googleanalytics
         * @external
         */
        readonly googleAnalytics?: string;
        /**
         * `CfnFlow.ConnectorOperatorProperty.InforNexus`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-connectoroperator.html#cfn-appflow-flow-connectoroperator-infornexus
         * @external
         */
        readonly inforNexus?: string;
        /**
         * `CfnFlow.ConnectorOperatorProperty.Marketo`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-connectoroperator.html#cfn-appflow-flow-connectoroperator-marketo
         * @external
         */
        readonly marketo?: string;
        /**
         * `CfnFlow.ConnectorOperatorProperty.S3`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-connectoroperator.html#cfn-appflow-flow-connectoroperator-s3
         * @external
         */
        readonly s3?: string;
        /**
         * `CfnFlow.ConnectorOperatorProperty.Salesforce`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-connectoroperator.html#cfn-appflow-flow-connectoroperator-salesforce
         * @external
         */
        readonly salesforce?: string;
        /**
         * `CfnFlow.ConnectorOperatorProperty.ServiceNow`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-connectoroperator.html#cfn-appflow-flow-connectoroperator-servicenow
         * @external
         */
        readonly serviceNow?: string;
        /**
         * `CfnFlow.ConnectorOperatorProperty.Singular`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-connectoroperator.html#cfn-appflow-flow-connectoroperator-singular
         * @external
         */
        readonly singular?: string;
        /**
         * `CfnFlow.ConnectorOperatorProperty.Slack`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-connectoroperator.html#cfn-appflow-flow-connectoroperator-slack
         * @external
         */
        readonly slack?: string;
        /**
         * `CfnFlow.ConnectorOperatorProperty.Trendmicro`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-connectoroperator.html#cfn-appflow-flow-connectoroperator-trendmicro
         * @external
         */
        readonly trendmicro?: string;
        /**
         * `CfnFlow.ConnectorOperatorProperty.Veeva`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-connectoroperator.html#cfn-appflow-flow-connectoroperator-veeva
         * @external
         */
        readonly veeva?: string;
        /**
         * `CfnFlow.ConnectorOperatorProperty.Zendesk`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-connectoroperator.html#cfn-appflow-flow-connectoroperator-zendesk
         * @external
         */
        readonly zendesk?: string;
    }
}
/**
 * A CloudFormation `AWS::AppFlow::Flow`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html
 * @external
 * @cloudformationResource AWS::AppFlow::Flow
 */
export declare namespace CfnFlow {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-datadogsourceproperties.html
     * @external
     */
    interface DatadogSourcePropertiesProperty {
        /**
         * `CfnFlow.DatadogSourcePropertiesProperty.Object`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-datadogsourceproperties.html#cfn-appflow-flow-datadogsourceproperties-object
         * @external
         */
        readonly object: string;
    }
}
/**
 * A CloudFormation `AWS::AppFlow::Flow`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html
 * @external
 * @cloudformationResource AWS::AppFlow::Flow
 */
export declare namespace CfnFlow {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-destinationconnectorproperties.html
     * @external
     */
    interface DestinationConnectorPropertiesProperty {
        /**
         * `CfnFlow.DestinationConnectorPropertiesProperty.EventBridge`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-destinationconnectorproperties.html#cfn-appflow-flow-destinationconnectorproperties-eventbridge
         * @external
         */
        readonly eventBridge?: CfnFlow.EventBridgeDestinationPropertiesProperty | cdk.IResolvable;
        /**
         * `CfnFlow.DestinationConnectorPropertiesProperty.Redshift`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-destinationconnectorproperties.html#cfn-appflow-flow-destinationconnectorproperties-redshift
         * @external
         */
        readonly redshift?: CfnFlow.RedshiftDestinationPropertiesProperty | cdk.IResolvable;
        /**
         * `CfnFlow.DestinationConnectorPropertiesProperty.S3`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-destinationconnectorproperties.html#cfn-appflow-flow-destinationconnectorproperties-s3
         * @external
         */
        readonly s3?: CfnFlow.S3DestinationPropertiesProperty | cdk.IResolvable;
        /**
         * `CfnFlow.DestinationConnectorPropertiesProperty.Salesforce`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-destinationconnectorproperties.html#cfn-appflow-flow-destinationconnectorproperties-salesforce
         * @external
         */
        readonly salesforce?: CfnFlow.SalesforceDestinationPropertiesProperty | cdk.IResolvable;
        /**
         * `CfnFlow.DestinationConnectorPropertiesProperty.Snowflake`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-destinationconnectorproperties.html#cfn-appflow-flow-destinationconnectorproperties-snowflake
         * @external
         */
        readonly snowflake?: CfnFlow.SnowflakeDestinationPropertiesProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppFlow::Flow`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html
 * @external
 * @cloudformationResource AWS::AppFlow::Flow
 */
export declare namespace CfnFlow {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-destinationflowconfig.html
     * @external
     */
    interface DestinationFlowConfigProperty {
        /**
         * `CfnFlow.DestinationFlowConfigProperty.ConnectorProfileName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-destinationflowconfig.html#cfn-appflow-flow-destinationflowconfig-connectorprofilename
         * @external
         */
        readonly connectorProfileName?: string;
        /**
         * `CfnFlow.DestinationFlowConfigProperty.ConnectorType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-destinationflowconfig.html#cfn-appflow-flow-destinationflowconfig-connectortype
         * @external
         */
        readonly connectorType: string;
        /**
         * `CfnFlow.DestinationFlowConfigProperty.DestinationConnectorProperties`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-destinationflowconfig.html#cfn-appflow-flow-destinationflowconfig-destinationconnectorproperties
         * @external
         */
        readonly destinationConnectorProperties: CfnFlow.DestinationConnectorPropertiesProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppFlow::Flow`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html
 * @external
 * @cloudformationResource AWS::AppFlow::Flow
 */
export declare namespace CfnFlow {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-dynatracesourceproperties.html
     * @external
     */
    interface DynatraceSourcePropertiesProperty {
        /**
         * `CfnFlow.DynatraceSourcePropertiesProperty.Object`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-dynatracesourceproperties.html#cfn-appflow-flow-dynatracesourceproperties-object
         * @external
         */
        readonly object: string;
    }
}
/**
 * A CloudFormation `AWS::AppFlow::Flow`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html
 * @external
 * @cloudformationResource AWS::AppFlow::Flow
 */
export declare namespace CfnFlow {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-errorhandlingconfig.html
     * @external
     */
    interface ErrorHandlingConfigProperty {
        /**
         * `CfnFlow.ErrorHandlingConfigProperty.BucketName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-errorhandlingconfig.html#cfn-appflow-flow-errorhandlingconfig-bucketname
         * @external
         */
        readonly bucketName?: string;
        /**
         * `CfnFlow.ErrorHandlingConfigProperty.BucketPrefix`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-errorhandlingconfig.html#cfn-appflow-flow-errorhandlingconfig-bucketprefix
         * @external
         */
        readonly bucketPrefix?: string;
        /**
         * `CfnFlow.ErrorHandlingConfigProperty.FailOnFirstError`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-errorhandlingconfig.html#cfn-appflow-flow-errorhandlingconfig-failonfirsterror
         * @external
         */
        readonly failOnFirstError?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppFlow::Flow`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html
 * @external
 * @cloudformationResource AWS::AppFlow::Flow
 */
export declare namespace CfnFlow {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-eventbridgedestinationproperties.html
     * @external
     */
    interface EventBridgeDestinationPropertiesProperty {
        /**
         * `CfnFlow.EventBridgeDestinationPropertiesProperty.ErrorHandlingConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-eventbridgedestinationproperties.html#cfn-appflow-flow-eventbridgedestinationproperties-errorhandlingconfig
         * @external
         */
        readonly errorHandlingConfig?: CfnFlow.ErrorHandlingConfigProperty | cdk.IResolvable;
        /**
         * `CfnFlow.EventBridgeDestinationPropertiesProperty.Object`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-eventbridgedestinationproperties.html#cfn-appflow-flow-eventbridgedestinationproperties-object
         * @external
         */
        readonly object: string;
    }
}
/**
 * A CloudFormation `AWS::AppFlow::Flow`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html
 * @external
 * @cloudformationResource AWS::AppFlow::Flow
 */
export declare namespace CfnFlow {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-googleanalyticssourceproperties.html
     * @external
     */
    interface GoogleAnalyticsSourcePropertiesProperty {
        /**
         * `CfnFlow.GoogleAnalyticsSourcePropertiesProperty.Object`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-googleanalyticssourceproperties.html#cfn-appflow-flow-googleanalyticssourceproperties-object
         * @external
         */
        readonly object: string;
    }
}
/**
 * A CloudFormation `AWS::AppFlow::Flow`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html
 * @external
 * @cloudformationResource AWS::AppFlow::Flow
 */
export declare namespace CfnFlow {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-infornexussourceproperties.html
     * @external
     */
    interface InforNexusSourcePropertiesProperty {
        /**
         * `CfnFlow.InforNexusSourcePropertiesProperty.Object`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-infornexussourceproperties.html#cfn-appflow-flow-infornexussourceproperties-object
         * @external
         */
        readonly object: string;
    }
}
/**
 * A CloudFormation `AWS::AppFlow::Flow`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html
 * @external
 * @cloudformationResource AWS::AppFlow::Flow
 */
export declare namespace CfnFlow {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-marketosourceproperties.html
     * @external
     */
    interface MarketoSourcePropertiesProperty {
        /**
         * `CfnFlow.MarketoSourcePropertiesProperty.Object`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-marketosourceproperties.html#cfn-appflow-flow-marketosourceproperties-object
         * @external
         */
        readonly object: string;
    }
}
/**
 * A CloudFormation `AWS::AppFlow::Flow`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html
 * @external
 * @cloudformationResource AWS::AppFlow::Flow
 */
export declare namespace CfnFlow {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-prefixconfig.html
     * @external
     */
    interface PrefixConfigProperty {
        /**
         * `CfnFlow.PrefixConfigProperty.PrefixFormat`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-prefixconfig.html#cfn-appflow-flow-prefixconfig-prefixformat
         * @external
         */
        readonly prefixFormat?: string;
        /**
         * `CfnFlow.PrefixConfigProperty.PrefixType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-prefixconfig.html#cfn-appflow-flow-prefixconfig-prefixtype
         * @external
         */
        readonly prefixType?: string;
    }
}
/**
 * A CloudFormation `AWS::AppFlow::Flow`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html
 * @external
 * @cloudformationResource AWS::AppFlow::Flow
 */
export declare namespace CfnFlow {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-redshiftdestinationproperties.html
     * @external
     */
    interface RedshiftDestinationPropertiesProperty {
        /**
         * `CfnFlow.RedshiftDestinationPropertiesProperty.BucketPrefix`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-redshiftdestinationproperties.html#cfn-appflow-flow-redshiftdestinationproperties-bucketprefix
         * @external
         */
        readonly bucketPrefix?: string;
        /**
         * `CfnFlow.RedshiftDestinationPropertiesProperty.ErrorHandlingConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-redshiftdestinationproperties.html#cfn-appflow-flow-redshiftdestinationproperties-errorhandlingconfig
         * @external
         */
        readonly errorHandlingConfig?: CfnFlow.ErrorHandlingConfigProperty | cdk.IResolvable;
        /**
         * `CfnFlow.RedshiftDestinationPropertiesProperty.IntermediateBucketName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-redshiftdestinationproperties.html#cfn-appflow-flow-redshiftdestinationproperties-intermediatebucketname
         * @external
         */
        readonly intermediateBucketName: string;
        /**
         * `CfnFlow.RedshiftDestinationPropertiesProperty.Object`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-redshiftdestinationproperties.html#cfn-appflow-flow-redshiftdestinationproperties-object
         * @external
         */
        readonly object: string;
    }
}
/**
 * A CloudFormation `AWS::AppFlow::Flow`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html
 * @external
 * @cloudformationResource AWS::AppFlow::Flow
 */
export declare namespace CfnFlow {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-s3destinationproperties.html
     * @external
     */
    interface S3DestinationPropertiesProperty {
        /**
         * `CfnFlow.S3DestinationPropertiesProperty.BucketName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-s3destinationproperties.html#cfn-appflow-flow-s3destinationproperties-bucketname
         * @external
         */
        readonly bucketName: string;
        /**
         * `CfnFlow.S3DestinationPropertiesProperty.BucketPrefix`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-s3destinationproperties.html#cfn-appflow-flow-s3destinationproperties-bucketprefix
         * @external
         */
        readonly bucketPrefix?: string;
        /**
         * `CfnFlow.S3DestinationPropertiesProperty.S3OutputFormatConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-s3destinationproperties.html#cfn-appflow-flow-s3destinationproperties-s3outputformatconfig
         * @external
         */
        readonly s3OutputFormatConfig?: CfnFlow.S3OutputFormatConfigProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppFlow::Flow`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html
 * @external
 * @cloudformationResource AWS::AppFlow::Flow
 */
export declare namespace CfnFlow {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-s3outputformatconfig.html
     * @external
     */
    interface S3OutputFormatConfigProperty {
        /**
         * `CfnFlow.S3OutputFormatConfigProperty.AggregationConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-s3outputformatconfig.html#cfn-appflow-flow-s3outputformatconfig-aggregationconfig
         * @external
         */
        readonly aggregationConfig?: CfnFlow.AggregationConfigProperty | cdk.IResolvable;
        /**
         * `CfnFlow.S3OutputFormatConfigProperty.FileType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-s3outputformatconfig.html#cfn-appflow-flow-s3outputformatconfig-filetype
         * @external
         */
        readonly fileType?: string;
        /**
         * `CfnFlow.S3OutputFormatConfigProperty.PrefixConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-s3outputformatconfig.html#cfn-appflow-flow-s3outputformatconfig-prefixconfig
         * @external
         */
        readonly prefixConfig?: CfnFlow.PrefixConfigProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppFlow::Flow`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html
 * @external
 * @cloudformationResource AWS::AppFlow::Flow
 */
export declare namespace CfnFlow {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-s3sourceproperties.html
     * @external
     */
    interface S3SourcePropertiesProperty {
        /**
         * `CfnFlow.S3SourcePropertiesProperty.BucketName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-s3sourceproperties.html#cfn-appflow-flow-s3sourceproperties-bucketname
         * @external
         */
        readonly bucketName: string;
        /**
         * `CfnFlow.S3SourcePropertiesProperty.BucketPrefix`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-s3sourceproperties.html#cfn-appflow-flow-s3sourceproperties-bucketprefix
         * @external
         */
        readonly bucketPrefix: string;
    }
}
/**
 * A CloudFormation `AWS::AppFlow::Flow`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html
 * @external
 * @cloudformationResource AWS::AppFlow::Flow
 */
export declare namespace CfnFlow {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-salesforcedestinationproperties.html
     * @external
     */
    interface SalesforceDestinationPropertiesProperty {
        /**
         * `CfnFlow.SalesforceDestinationPropertiesProperty.ErrorHandlingConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-salesforcedestinationproperties.html#cfn-appflow-flow-salesforcedestinationproperties-errorhandlingconfig
         * @external
         */
        readonly errorHandlingConfig?: CfnFlow.ErrorHandlingConfigProperty | cdk.IResolvable;
        /**
         * `CfnFlow.SalesforceDestinationPropertiesProperty.Object`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-salesforcedestinationproperties.html#cfn-appflow-flow-salesforcedestinationproperties-object
         * @external
         */
        readonly object: string;
    }
}
/**
 * A CloudFormation `AWS::AppFlow::Flow`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html
 * @external
 * @cloudformationResource AWS::AppFlow::Flow
 */
export declare namespace CfnFlow {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-salesforcesourceproperties.html
     * @external
     */
    interface SalesforceSourcePropertiesProperty {
        /**
         * `CfnFlow.SalesforceSourcePropertiesProperty.EnableDynamicFieldUpdate`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-salesforcesourceproperties.html#cfn-appflow-flow-salesforcesourceproperties-enabledynamicfieldupdate
         * @external
         */
        readonly enableDynamicFieldUpdate?: boolean | cdk.IResolvable;
        /**
         * `CfnFlow.SalesforceSourcePropertiesProperty.IncludeDeletedRecords`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-salesforcesourceproperties.html#cfn-appflow-flow-salesforcesourceproperties-includedeletedrecords
         * @external
         */
        readonly includeDeletedRecords?: boolean | cdk.IResolvable;
        /**
         * `CfnFlow.SalesforceSourcePropertiesProperty.Object`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-salesforcesourceproperties.html#cfn-appflow-flow-salesforcesourceproperties-object
         * @external
         */
        readonly object: string;
    }
}
/**
 * A CloudFormation `AWS::AppFlow::Flow`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html
 * @external
 * @cloudformationResource AWS::AppFlow::Flow
 */
export declare namespace CfnFlow {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-scheduledtriggerproperties.html
     * @external
     */
    interface ScheduledTriggerPropertiesProperty {
        /**
         * `CfnFlow.ScheduledTriggerPropertiesProperty.DataPullMode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-scheduledtriggerproperties.html#cfn-appflow-flow-scheduledtriggerproperties-datapullmode
         * @external
         */
        readonly dataPullMode?: string;
        /**
         * `CfnFlow.ScheduledTriggerPropertiesProperty.ScheduleEndTime`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-scheduledtriggerproperties.html#cfn-appflow-flow-scheduledtriggerproperties-scheduleendtime
         * @external
         */
        readonly scheduleEndTime?: number;
        /**
         * `CfnFlow.ScheduledTriggerPropertiesProperty.ScheduleExpression`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-scheduledtriggerproperties.html#cfn-appflow-flow-scheduledtriggerproperties-scheduleexpression
         * @external
         */
        readonly scheduleExpression: string;
        /**
         * `CfnFlow.ScheduledTriggerPropertiesProperty.ScheduleStartTime`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-scheduledtriggerproperties.html#cfn-appflow-flow-scheduledtriggerproperties-schedulestarttime
         * @external
         */
        readonly scheduleStartTime?: number;
        /**
         * `CfnFlow.ScheduledTriggerPropertiesProperty.TimeZone`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-scheduledtriggerproperties.html#cfn-appflow-flow-scheduledtriggerproperties-timezone
         * @external
         */
        readonly timeZone?: string;
    }
}
/**
 * A CloudFormation `AWS::AppFlow::Flow`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html
 * @external
 * @cloudformationResource AWS::AppFlow::Flow
 */
export declare namespace CfnFlow {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-servicenowsourceproperties.html
     * @external
     */
    interface ServiceNowSourcePropertiesProperty {
        /**
         * `CfnFlow.ServiceNowSourcePropertiesProperty.Object`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-servicenowsourceproperties.html#cfn-appflow-flow-servicenowsourceproperties-object
         * @external
         */
        readonly object: string;
    }
}
/**
 * A CloudFormation `AWS::AppFlow::Flow`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html
 * @external
 * @cloudformationResource AWS::AppFlow::Flow
 */
export declare namespace CfnFlow {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-singularsourceproperties.html
     * @external
     */
    interface SingularSourcePropertiesProperty {
        /**
         * `CfnFlow.SingularSourcePropertiesProperty.Object`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-singularsourceproperties.html#cfn-appflow-flow-singularsourceproperties-object
         * @external
         */
        readonly object: string;
    }
}
/**
 * A CloudFormation `AWS::AppFlow::Flow`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html
 * @external
 * @cloudformationResource AWS::AppFlow::Flow
 */
export declare namespace CfnFlow {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-slacksourceproperties.html
     * @external
     */
    interface SlackSourcePropertiesProperty {
        /**
         * `CfnFlow.SlackSourcePropertiesProperty.Object`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-slacksourceproperties.html#cfn-appflow-flow-slacksourceproperties-object
         * @external
         */
        readonly object: string;
    }
}
/**
 * A CloudFormation `AWS::AppFlow::Flow`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html
 * @external
 * @cloudformationResource AWS::AppFlow::Flow
 */
export declare namespace CfnFlow {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-snowflakedestinationproperties.html
     * @external
     */
    interface SnowflakeDestinationPropertiesProperty {
        /**
         * `CfnFlow.SnowflakeDestinationPropertiesProperty.BucketPrefix`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-snowflakedestinationproperties.html#cfn-appflow-flow-snowflakedestinationproperties-bucketprefix
         * @external
         */
        readonly bucketPrefix?: string;
        /**
         * `CfnFlow.SnowflakeDestinationPropertiesProperty.ErrorHandlingConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-snowflakedestinationproperties.html#cfn-appflow-flow-snowflakedestinationproperties-errorhandlingconfig
         * @external
         */
        readonly errorHandlingConfig?: CfnFlow.ErrorHandlingConfigProperty | cdk.IResolvable;
        /**
         * `CfnFlow.SnowflakeDestinationPropertiesProperty.IntermediateBucketName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-snowflakedestinationproperties.html#cfn-appflow-flow-snowflakedestinationproperties-intermediatebucketname
         * @external
         */
        readonly intermediateBucketName: string;
        /**
         * `CfnFlow.SnowflakeDestinationPropertiesProperty.Object`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-snowflakedestinationproperties.html#cfn-appflow-flow-snowflakedestinationproperties-object
         * @external
         */
        readonly object: string;
    }
}
/**
 * A CloudFormation `AWS::AppFlow::Flow`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html
 * @external
 * @cloudformationResource AWS::AppFlow::Flow
 */
export declare namespace CfnFlow {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceconnectorproperties.html
     * @external
     */
    interface SourceConnectorPropertiesProperty {
        /**
         * `CfnFlow.SourceConnectorPropertiesProperty.Amplitude`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceconnectorproperties.html#cfn-appflow-flow-sourceconnectorproperties-amplitude
         * @external
         */
        readonly amplitude?: CfnFlow.AmplitudeSourcePropertiesProperty | cdk.IResolvable;
        /**
         * `CfnFlow.SourceConnectorPropertiesProperty.Datadog`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceconnectorproperties.html#cfn-appflow-flow-sourceconnectorproperties-datadog
         * @external
         */
        readonly datadog?: CfnFlow.DatadogSourcePropertiesProperty | cdk.IResolvable;
        /**
         * `CfnFlow.SourceConnectorPropertiesProperty.Dynatrace`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceconnectorproperties.html#cfn-appflow-flow-sourceconnectorproperties-dynatrace
         * @external
         */
        readonly dynatrace?: CfnFlow.DynatraceSourcePropertiesProperty | cdk.IResolvable;
        /**
         * `CfnFlow.SourceConnectorPropertiesProperty.GoogleAnalytics`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceconnectorproperties.html#cfn-appflow-flow-sourceconnectorproperties-googleanalytics
         * @external
         */
        readonly googleAnalytics?: CfnFlow.GoogleAnalyticsSourcePropertiesProperty | cdk.IResolvable;
        /**
         * `CfnFlow.SourceConnectorPropertiesProperty.InforNexus`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceconnectorproperties.html#cfn-appflow-flow-sourceconnectorproperties-infornexus
         * @external
         */
        readonly inforNexus?: CfnFlow.InforNexusSourcePropertiesProperty | cdk.IResolvable;
        /**
         * `CfnFlow.SourceConnectorPropertiesProperty.Marketo`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceconnectorproperties.html#cfn-appflow-flow-sourceconnectorproperties-marketo
         * @external
         */
        readonly marketo?: CfnFlow.MarketoSourcePropertiesProperty | cdk.IResolvable;
        /**
         * `CfnFlow.SourceConnectorPropertiesProperty.S3`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceconnectorproperties.html#cfn-appflow-flow-sourceconnectorproperties-s3
         * @external
         */
        readonly s3?: CfnFlow.S3SourcePropertiesProperty | cdk.IResolvable;
        /**
         * `CfnFlow.SourceConnectorPropertiesProperty.Salesforce`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceconnectorproperties.html#cfn-appflow-flow-sourceconnectorproperties-salesforce
         * @external
         */
        readonly salesforce?: CfnFlow.SalesforceSourcePropertiesProperty | cdk.IResolvable;
        /**
         * `CfnFlow.SourceConnectorPropertiesProperty.ServiceNow`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceconnectorproperties.html#cfn-appflow-flow-sourceconnectorproperties-servicenow
         * @external
         */
        readonly serviceNow?: CfnFlow.ServiceNowSourcePropertiesProperty | cdk.IResolvable;
        /**
         * `CfnFlow.SourceConnectorPropertiesProperty.Singular`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceconnectorproperties.html#cfn-appflow-flow-sourceconnectorproperties-singular
         * @external
         */
        readonly singular?: CfnFlow.SingularSourcePropertiesProperty | cdk.IResolvable;
        /**
         * `CfnFlow.SourceConnectorPropertiesProperty.Slack`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceconnectorproperties.html#cfn-appflow-flow-sourceconnectorproperties-slack
         * @external
         */
        readonly slack?: CfnFlow.SlackSourcePropertiesProperty | cdk.IResolvable;
        /**
         * `CfnFlow.SourceConnectorPropertiesProperty.Trendmicro`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceconnectorproperties.html#cfn-appflow-flow-sourceconnectorproperties-trendmicro
         * @external
         */
        readonly trendmicro?: CfnFlow.TrendmicroSourcePropertiesProperty | cdk.IResolvable;
        /**
         * `CfnFlow.SourceConnectorPropertiesProperty.Veeva`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceconnectorproperties.html#cfn-appflow-flow-sourceconnectorproperties-veeva
         * @external
         */
        readonly veeva?: CfnFlow.VeevaSourcePropertiesProperty | cdk.IResolvable;
        /**
         * `CfnFlow.SourceConnectorPropertiesProperty.Zendesk`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceconnectorproperties.html#cfn-appflow-flow-sourceconnectorproperties-zendesk
         * @external
         */
        readonly zendesk?: CfnFlow.ZendeskSourcePropertiesProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppFlow::Flow`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html
 * @external
 * @cloudformationResource AWS::AppFlow::Flow
 */
export declare namespace CfnFlow {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceflowconfig.html
     * @external
     */
    interface SourceFlowConfigProperty {
        /**
         * `CfnFlow.SourceFlowConfigProperty.ConnectorProfileName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceflowconfig.html#cfn-appflow-flow-sourceflowconfig-connectorprofilename
         * @external
         */
        readonly connectorProfileName?: string;
        /**
         * `CfnFlow.SourceFlowConfigProperty.ConnectorType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceflowconfig.html#cfn-appflow-flow-sourceflowconfig-connectortype
         * @external
         */
        readonly connectorType: string;
        /**
         * `CfnFlow.SourceFlowConfigProperty.SourceConnectorProperties`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceflowconfig.html#cfn-appflow-flow-sourceflowconfig-sourceconnectorproperties
         * @external
         */
        readonly sourceConnectorProperties: CfnFlow.SourceConnectorPropertiesProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppFlow::Flow`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html
 * @external
 * @cloudformationResource AWS::AppFlow::Flow
 */
export declare namespace CfnFlow {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-task.html
     * @external
     */
    interface TaskProperty {
        /**
         * `CfnFlow.TaskProperty.ConnectorOperator`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-task.html#cfn-appflow-flow-task-connectoroperator
         * @external
         */
        readonly connectorOperator?: CfnFlow.ConnectorOperatorProperty | cdk.IResolvable;
        /**
         * `CfnFlow.TaskProperty.DestinationField`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-task.html#cfn-appflow-flow-task-destinationfield
         * @external
         */
        readonly destinationField?: string;
        /**
         * `CfnFlow.TaskProperty.SourceFields`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-task.html#cfn-appflow-flow-task-sourcefields
         * @external
         */
        readonly sourceFields: string[];
        /**
         * `CfnFlow.TaskProperty.TaskProperties`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-task.html#cfn-appflow-flow-task-taskproperties
         * @external
         */
        readonly taskProperties?: Array<CfnFlow.TaskPropertiesObjectProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnFlow.TaskProperty.TaskType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-task.html#cfn-appflow-flow-task-tasktype
         * @external
         */
        readonly taskType: string;
    }
}
/**
 * A CloudFormation `AWS::AppFlow::Flow`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html
 * @external
 * @cloudformationResource AWS::AppFlow::Flow
 */
export declare namespace CfnFlow {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-taskpropertiesobject.html
     * @external
     */
    interface TaskPropertiesObjectProperty {
        /**
         * `CfnFlow.TaskPropertiesObjectProperty.Key`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-taskpropertiesobject.html#cfn-appflow-flow-taskpropertiesobject-key
         * @external
         */
        readonly key: string;
        /**
         * `CfnFlow.TaskPropertiesObjectProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-taskpropertiesobject.html#cfn-appflow-flow-taskpropertiesobject-value
         * @external
         */
        readonly value: string;
    }
}
/**
 * A CloudFormation `AWS::AppFlow::Flow`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html
 * @external
 * @cloudformationResource AWS::AppFlow::Flow
 */
export declare namespace CfnFlow {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-trendmicrosourceproperties.html
     * @external
     */
    interface TrendmicroSourcePropertiesProperty {
        /**
         * `CfnFlow.TrendmicroSourcePropertiesProperty.Object`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-trendmicrosourceproperties.html#cfn-appflow-flow-trendmicrosourceproperties-object
         * @external
         */
        readonly object: string;
    }
}
/**
 * A CloudFormation `AWS::AppFlow::Flow`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html
 * @external
 * @cloudformationResource AWS::AppFlow::Flow
 */
export declare namespace CfnFlow {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-triggerconfig.html
     * @external
     */
    interface TriggerConfigProperty {
        /**
         * `CfnFlow.TriggerConfigProperty.TriggerProperties`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-triggerconfig.html#cfn-appflow-flow-triggerconfig-triggerproperties
         * @external
         */
        readonly triggerProperties?: CfnFlow.ScheduledTriggerPropertiesProperty | cdk.IResolvable;
        /**
         * `CfnFlow.TriggerConfigProperty.TriggerType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-triggerconfig.html#cfn-appflow-flow-triggerconfig-triggertype
         * @external
         */
        readonly triggerType: string;
    }
}
/**
 * A CloudFormation `AWS::AppFlow::Flow`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html
 * @external
 * @cloudformationResource AWS::AppFlow::Flow
 */
export declare namespace CfnFlow {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-veevasourceproperties.html
     * @external
     */
    interface VeevaSourcePropertiesProperty {
        /**
         * `CfnFlow.VeevaSourcePropertiesProperty.Object`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-veevasourceproperties.html#cfn-appflow-flow-veevasourceproperties-object
         * @external
         */
        readonly object: string;
    }
}
/**
 * A CloudFormation `AWS::AppFlow::Flow`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html
 * @external
 * @cloudformationResource AWS::AppFlow::Flow
 */
export declare namespace CfnFlow {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-zendesksourceproperties.html
     * @external
     */
    interface ZendeskSourcePropertiesProperty {
        /**
         * `CfnFlow.ZendeskSourcePropertiesProperty.Object`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-zendesksourceproperties.html#cfn-appflow-flow-zendesksourceproperties-object
         * @external
         */
        readonly object: string;
    }
}
