"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaProxyIntegration = void 0;
const aws_iam_1 = require("../../../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const core_1 = require("../../../../core"); // Automatically re-written from '@aws-cdk/core'
const integration_1 = require("../integration");
/**
 * (experimental) The Lambda Proxy integration resource for HTTP API.
 *
 * @experimental
 */
class LambdaProxyIntegration {
    /**
     * @experimental
     */
    constructor(props) {
        this.props = props;
    }
    /**
     * (experimental) Bind this integration to the route.
     *
     * @experimental
     */
    bind(options) {
        var _a, _b;
        const route = options.route;
        this.props.handler.addPermission(`${core_1.Names.nodeUniqueId(route.node)}-Permission`, {
            scope: options.scope,
            principal: new aws_iam_1.ServicePrincipal('apigateway.amazonaws.com'),
            sourceArn: core_1.Stack.of(route).formatArn({
                service: 'execute-api',
                resource: route.httpApi.httpApiId,
                resourceName: `*/*${(_a = route.path) !== null && _a !== void 0 ? _a : ''}`,
            }),
        });
        return {
            type: integration_1.HttpIntegrationType.LAMBDA_PROXY,
            uri: this.props.handler.functionArn,
            payloadFormatVersion: (_b = this.props.payloadFormatVersion) !== null && _b !== void 0 ? _b : integration_1.PayloadFormatVersion.VERSION_2_0,
        };
    }
}
exports.LambdaProxyIntegration = LambdaProxyIntegration;
//# sourceMappingURL=data:application/json;base64,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