"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpIntegration = exports.PayloadFormatVersion = exports.HttpConnectionType = exports.HttpIntegrationType = void 0;
const core_1 = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
const apigatewayv2_generated_1 = require("../apigatewayv2.generated");
/**
 * (experimental) Supported integration types.
 *
 * @experimental
 */
var HttpIntegrationType;
(function (HttpIntegrationType) {
    HttpIntegrationType["LAMBDA_PROXY"] = "AWS_PROXY";
    HttpIntegrationType["HTTP_PROXY"] = "HTTP_PROXY";
})(HttpIntegrationType = exports.HttpIntegrationType || (exports.HttpIntegrationType = {}));
/**
 * (experimental) Supported connection types.
 *
 * @experimental
 */
var HttpConnectionType;
(function (HttpConnectionType) {
    HttpConnectionType["VPC_LINK"] = "VPC_LINK";
    HttpConnectionType["INTERNET"] = "INTERNET";
})(HttpConnectionType = exports.HttpConnectionType || (exports.HttpConnectionType = {}));
/**
 * (experimental) Payload format version for lambda proxy integration.
 *
 * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html
 * @experimental
 */
class PayloadFormatVersion {
    constructor(version) {
        this.version = version;
    }
    /**
     * (experimental) A custom payload version.
     *
     * Typically used if there is a version number that the CDK doesn't support yet
     *
     * @experimental
     */
    static custom(version) {
        return new PayloadFormatVersion(version);
    }
}
exports.PayloadFormatVersion = PayloadFormatVersion;
/**
 * (experimental) Version 1.0.
 *
 * @experimental
 */
PayloadFormatVersion.VERSION_1_0 = new PayloadFormatVersion('1.0');
/**
 * (experimental) Version 2.0.
 *
 * @experimental
 */
PayloadFormatVersion.VERSION_2_0 = new PayloadFormatVersion('2.0');
/**
 * (experimental) The integration for an API route.
 *
 * @experimental
 * @resource AWS::ApiGatewayV2::Integration
 */
class HttpIntegration extends core_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _a;
        super(scope, id);
        const integ = new apigatewayv2_generated_1.CfnIntegration(this, 'Resource', {
            apiId: props.httpApi.httpApiId,
            integrationType: props.integrationType,
            integrationUri: props.integrationUri,
            integrationMethod: props.method,
            connectionId: props.connectionId,
            connectionType: props.connectionType,
            payloadFormatVersion: (_a = props.payloadFormatVersion) === null || _a === void 0 ? void 0 : _a.version,
        });
        this.integrationId = integ.ref;
        this.httpApi = props.httpApi;
    }
}
exports.HttpIntegration = HttpIntegration;
//# sourceMappingURL=data:application/json;base64,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