"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpApiMapping = void 0;
const core_1 = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
const apigatewayv2_generated_1 = require("../apigatewayv2.generated");
/**
 * (experimental) Create a new API mapping for API Gateway HTTP API endpoint.
 *
 * @experimental
 * @resource AWS::ApiGatewayV2::ApiMapping
 */
class HttpApiMapping extends core_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _a, _b, _c, _d;
        super(scope, id);
        if ((!((_a = props.stage) === null || _a === void 0 ? void 0 : _a.stageName)) && !props.api.defaultStage) {
            throw new Error('stage is required if default stage is not available');
        }
        const paramRe = '^[a-zA-Z0-9]*[-_.+!,$]?[a-zA-Z0-9]*$';
        if (props.apiMappingKey && !new RegExp(paramRe).test(props.apiMappingKey)) {
            throw new Error('An ApiMapping key may contain only letters, numbers and one of $-_.+!*\'(),');
        }
        if (props.apiMappingKey === '') {
            throw new Error('empty string for api mapping key not allowed');
        }
        const apiMappingProps = {
            apiId: props.api.httpApiId,
            domainName: props.domainName.domainName,
            stage: (_c = (_b = props.stage) === null || _b === void 0 ? void 0 : _b.stageName) !== null && _c !== void 0 ? _c : props.api.defaultStage.stageName,
            apiMappingKey: props.apiMappingKey,
        };
        const resource = new apigatewayv2_generated_1.CfnApiMapping(this, 'Resource', apiMappingProps);
        // ensure the dependency on the provided stage
        if (props.stage) {
            this.node.addDependency(props.stage);
        }
        // if stage not specified, we ensure the default stage is ready before we create the api mapping
        if (!((_d = props.stage) === null || _d === void 0 ? void 0 : _d.stageName) && props.api.defaultStage) {
            this.node.addDependency(props.api.defaultStage);
        }
        this.apiMappingId = resource.ref;
        this.mappingKey = props.apiMappingKey;
    }
    /**
     * (experimental) import from API ID.
     *
     * @experimental
     */
    static fromHttpApiMappingAttributes(scope, id, attrs) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.apiMappingId = attrs.apiMappingId;
            }
        }
        return new Import(scope, id);
    }
}
exports.HttpApiMapping = HttpApiMapping;
//# sourceMappingURL=data:application/json;base64,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