import { Resource } from "../../../core";
import { Construct } from 'constructs';
import { IApiMapping, IDomainName } from '../common';
import { IHttpApi } from '../http/api';
import { IHttpStage } from './stage';
/**
 * (experimental) Properties used to create the HttpApiMapping resource.
 *
 * @experimental
 */
export interface HttpApiMappingProps {
    /**
     * (experimental) Api mapping key.
     *
     * The path where this stage should be mapped to on the domain
     *
     * @default - undefined for the root path mapping.
     * @experimental
     */
    readonly apiMappingKey?: string;
    /**
     * (experimental) The HttpApi to which this mapping is applied.
     *
     * @experimental
     */
    readonly api: IHttpApi;
    /**
     * (experimental) custom domain name of the mapping target.
     *
     * @experimental
     */
    readonly domainName: IDomainName;
    /**
     * (experimental) stage for the HttpApiMapping resource.
     *
     * @default - the $default stage
     * @experimental
     */
    readonly stage?: IHttpStage;
}
/**
 * (experimental) The attributes used to import existing HttpApiMapping.
 *
 * @experimental
 */
export interface HttpApiMappingAttributes {
    /**
     * (experimental) The API mapping ID.
     *
     * @experimental
     */
    readonly apiMappingId: string;
}
/**
 * (experimental) Create a new API mapping for API Gateway HTTP API endpoint.
 *
 * @experimental
 * @resource AWS::ApiGatewayV2::ApiMapping
 */
export declare class HttpApiMapping extends Resource implements IApiMapping {
    /**
     * (experimental) import from API ID.
     *
     * @experimental
     */
    static fromHttpApiMappingAttributes(scope: Construct, id: string, attrs: HttpApiMappingAttributes): IApiMapping;
    /**
     * (experimental) ID of the API Mapping.
     *
     * @experimental
     */
    readonly apiMappingId: string;
    /**
     * (experimental) API Mapping key.
     *
     * @experimental
     */
    readonly mappingKey?: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: HttpApiMappingProps);
}
