import { IResource } from "../../../core";
/**
 * (experimental) Represents a Stage.
 *
 * @experimental
 */
export interface IStage extends IResource {
    /**
     * (experimental) The name of the stage;
     *
     * its primary identifier.
     *
     * @experimental
     * @attribute true
     */
    readonly stageName: string;
}
/**
 * (experimental) Options required to create a new stage.
 *
 * Options that are common between HTTP and Websocket APIs.
 *
 * @experimental
 */
export interface CommonStageOptions {
    /**
     * (experimental) The name of the stage.
     *
     * See `StageName` class for more details.
     *
     * @default '$default' the default stage of the API. This stage will have the URL at the root of the API endpoint.
     * @experimental
     */
    readonly stageName?: string;
    /**
     * (experimental) Whether updates to an API automatically trigger a new deployment.
     *
     * @default false
     * @experimental
     */
    readonly autoDeploy?: boolean;
}
