import * as cdk from "../../core";
import * as cfn_parse from "../../core/lib/cfn-parse";
/**
 * Properties for defining a `AWS::ApiGatewayV2::Api`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html
 * @external
 */
export interface CfnApiProps {
    /**
     * `AWS::ApiGatewayV2::Api.ApiKeySelectionExpression`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-apikeyselectionexpression
     * @external
     */
    readonly apiKeySelectionExpression?: string;
    /**
     * `AWS::ApiGatewayV2::Api.BasePath`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-basepath
     * @external
     */
    readonly basePath?: string;
    /**
     * `AWS::ApiGatewayV2::Api.Body`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-body
     * @external
     */
    readonly body?: any | cdk.IResolvable;
    /**
     * `AWS::ApiGatewayV2::Api.BodyS3Location`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-bodys3location
     * @external
     */
    readonly bodyS3Location?: CfnApi.BodyS3LocationProperty | cdk.IResolvable;
    /**
     * `AWS::ApiGatewayV2::Api.CorsConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-corsconfiguration
     * @external
     */
    readonly corsConfiguration?: CfnApi.CorsProperty | cdk.IResolvable;
    /**
     * `AWS::ApiGatewayV2::Api.CredentialsArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-credentialsarn
     * @external
     */
    readonly credentialsArn?: string;
    /**
     * `AWS::ApiGatewayV2::Api.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::ApiGatewayV2::Api.DisableExecuteApiEndpoint`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-disableexecuteapiendpoint
     * @external
     */
    readonly disableExecuteApiEndpoint?: boolean | cdk.IResolvable;
    /**
     * `AWS::ApiGatewayV2::Api.DisableSchemaValidation`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-disableschemavalidation
     * @external
     */
    readonly disableSchemaValidation?: boolean | cdk.IResolvable;
    /**
     * `AWS::ApiGatewayV2::Api.FailOnWarnings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-failonwarnings
     * @external
     */
    readonly failOnWarnings?: boolean | cdk.IResolvable;
    /**
     * `AWS::ApiGatewayV2::Api.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-name
     * @external
     */
    readonly name?: string;
    /**
     * `AWS::ApiGatewayV2::Api.ProtocolType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-protocoltype
     * @external
     */
    readonly protocolType?: string;
    /**
     * `AWS::ApiGatewayV2::Api.RouteKey`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-routekey
     * @external
     */
    readonly routeKey?: string;
    /**
     * `AWS::ApiGatewayV2::Api.RouteSelectionExpression`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-routeselectionexpression
     * @external
     */
    readonly routeSelectionExpression?: string;
    /**
     * `AWS::ApiGatewayV2::Api.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-tags
     * @external
     */
    readonly tags?: any;
    /**
     * `AWS::ApiGatewayV2::Api.Target`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-target
     * @external
     */
    readonly target?: string;
    /**
     * `AWS::ApiGatewayV2::Api.Version`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-version
     * @external
     */
    readonly version?: string;
}
/**
 * A CloudFormation `AWS::ApiGatewayV2::Api`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html
 * @external
 * @cloudformationResource AWS::ApiGatewayV2::Api
 */
export declare class CfnApi extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ApiGatewayV2::Api";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnApi;
    /**
     * @external
     * @cloudformationAttribute ApiEndpoint
     */
    readonly attrApiEndpoint: string;
    /**
     * `AWS::ApiGatewayV2::Api.ApiKeySelectionExpression`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-apikeyselectionexpression
     * @external
     */
    apiKeySelectionExpression: string | undefined;
    /**
     * `AWS::ApiGatewayV2::Api.BasePath`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-basepath
     * @external
     */
    basePath: string | undefined;
    /**
     * `AWS::ApiGatewayV2::Api.Body`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-body
     * @external
     */
    body: any | cdk.IResolvable | undefined;
    /**
     * `AWS::ApiGatewayV2::Api.BodyS3Location`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-bodys3location
     * @external
     */
    bodyS3Location: CfnApi.BodyS3LocationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::ApiGatewayV2::Api.CorsConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-corsconfiguration
     * @external
     */
    corsConfiguration: CfnApi.CorsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::ApiGatewayV2::Api.CredentialsArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-credentialsarn
     * @external
     */
    credentialsArn: string | undefined;
    /**
     * `AWS::ApiGatewayV2::Api.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::ApiGatewayV2::Api.DisableExecuteApiEndpoint`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-disableexecuteapiendpoint
     * @external
     */
    disableExecuteApiEndpoint: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::ApiGatewayV2::Api.DisableSchemaValidation`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-disableschemavalidation
     * @external
     */
    disableSchemaValidation: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::ApiGatewayV2::Api.FailOnWarnings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-failonwarnings
     * @external
     */
    failOnWarnings: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::ApiGatewayV2::Api.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-name
     * @external
     */
    name: string | undefined;
    /**
     * `AWS::ApiGatewayV2::Api.ProtocolType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-protocoltype
     * @external
     */
    protocolType: string | undefined;
    /**
     * `AWS::ApiGatewayV2::Api.RouteKey`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-routekey
     * @external
     */
    routeKey: string | undefined;
    /**
     * `AWS::ApiGatewayV2::Api.RouteSelectionExpression`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-routeselectionexpression
     * @external
     */
    routeSelectionExpression: string | undefined;
    /**
     * `AWS::ApiGatewayV2::Api.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::ApiGatewayV2::Api.Target`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-target
     * @external
     */
    target: string | undefined;
    /**
     * `AWS::ApiGatewayV2::Api.Version`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-version
     * @external
     */
    version: string | undefined;
    /**
     * Create a new `AWS::ApiGatewayV2::Api`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnApiProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ApiGatewayV2::Api`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html
 * @external
 * @cloudformationResource AWS::ApiGatewayV2::Api
 */
export declare namespace CfnApi {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-api-bodys3location.html
     * @external
     */
    interface BodyS3LocationProperty {
        /**
         * `CfnApi.BodyS3LocationProperty.Bucket`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-api-bodys3location.html#cfn-apigatewayv2-api-bodys3location-bucket
         * @external
         */
        readonly bucket?: string;
        /**
         * `CfnApi.BodyS3LocationProperty.Etag`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-api-bodys3location.html#cfn-apigatewayv2-api-bodys3location-etag
         * @external
         */
        readonly etag?: string;
        /**
         * `CfnApi.BodyS3LocationProperty.Key`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-api-bodys3location.html#cfn-apigatewayv2-api-bodys3location-key
         * @external
         */
        readonly key?: string;
        /**
         * `CfnApi.BodyS3LocationProperty.Version`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-api-bodys3location.html#cfn-apigatewayv2-api-bodys3location-version
         * @external
         */
        readonly version?: string;
    }
}
/**
 * A CloudFormation `AWS::ApiGatewayV2::Api`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html
 * @external
 * @cloudformationResource AWS::ApiGatewayV2::Api
 */
export declare namespace CfnApi {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-api-cors.html
     * @external
     */
    interface CorsProperty {
        /**
         * `CfnApi.CorsProperty.AllowCredentials`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-api-cors.html#cfn-apigatewayv2-api-cors-allowcredentials
         * @external
         */
        readonly allowCredentials?: boolean | cdk.IResolvable;
        /**
         * `CfnApi.CorsProperty.AllowHeaders`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-api-cors.html#cfn-apigatewayv2-api-cors-allowheaders
         * @external
         */
        readonly allowHeaders?: string[];
        /**
         * `CfnApi.CorsProperty.AllowMethods`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-api-cors.html#cfn-apigatewayv2-api-cors-allowmethods
         * @external
         */
        readonly allowMethods?: string[];
        /**
         * `CfnApi.CorsProperty.AllowOrigins`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-api-cors.html#cfn-apigatewayv2-api-cors-alloworigins
         * @external
         */
        readonly allowOrigins?: string[];
        /**
         * `CfnApi.CorsProperty.ExposeHeaders`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-api-cors.html#cfn-apigatewayv2-api-cors-exposeheaders
         * @external
         */
        readonly exposeHeaders?: string[];
        /**
         * `CfnApi.CorsProperty.MaxAge`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-api-cors.html#cfn-apigatewayv2-api-cors-maxage
         * @external
         */
        readonly maxAge?: number;
    }
}
/**
 * Properties for defining a `AWS::ApiGatewayV2::ApiGatewayManagedOverrides`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-apigatewaymanagedoverrides.html
 * @external
 */
export interface CfnApiGatewayManagedOverridesProps {
    /**
     * `AWS::ApiGatewayV2::ApiGatewayManagedOverrides.ApiId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-apigatewaymanagedoverrides.html#cfn-apigatewayv2-apigatewaymanagedoverrides-apiid
     * @external
     */
    readonly apiId: string;
    /**
     * `AWS::ApiGatewayV2::ApiGatewayManagedOverrides.Integration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-apigatewaymanagedoverrides.html#cfn-apigatewayv2-apigatewaymanagedoverrides-integration
     * @external
     */
    readonly integration?: CfnApiGatewayManagedOverrides.IntegrationOverridesProperty | cdk.IResolvable;
    /**
     * `AWS::ApiGatewayV2::ApiGatewayManagedOverrides.Route`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-apigatewaymanagedoverrides.html#cfn-apigatewayv2-apigatewaymanagedoverrides-route
     * @external
     */
    readonly route?: CfnApiGatewayManagedOverrides.RouteOverridesProperty | cdk.IResolvable;
    /**
     * `AWS::ApiGatewayV2::ApiGatewayManagedOverrides.Stage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-apigatewaymanagedoverrides.html#cfn-apigatewayv2-apigatewaymanagedoverrides-stage
     * @external
     */
    readonly stage?: CfnApiGatewayManagedOverrides.StageOverridesProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::ApiGatewayV2::ApiGatewayManagedOverrides`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-apigatewaymanagedoverrides.html
 * @external
 * @cloudformationResource AWS::ApiGatewayV2::ApiGatewayManagedOverrides
 */
export declare class CfnApiGatewayManagedOverrides extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ApiGatewayV2::ApiGatewayManagedOverrides";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnApiGatewayManagedOverrides;
    /**
     * `AWS::ApiGatewayV2::ApiGatewayManagedOverrides.ApiId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-apigatewaymanagedoverrides.html#cfn-apigatewayv2-apigatewaymanagedoverrides-apiid
     * @external
     */
    apiId: string;
    /**
     * `AWS::ApiGatewayV2::ApiGatewayManagedOverrides.Integration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-apigatewaymanagedoverrides.html#cfn-apigatewayv2-apigatewaymanagedoverrides-integration
     * @external
     */
    integration: CfnApiGatewayManagedOverrides.IntegrationOverridesProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::ApiGatewayV2::ApiGatewayManagedOverrides.Route`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-apigatewaymanagedoverrides.html#cfn-apigatewayv2-apigatewaymanagedoverrides-route
     * @external
     */
    route: CfnApiGatewayManagedOverrides.RouteOverridesProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::ApiGatewayV2::ApiGatewayManagedOverrides.Stage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-apigatewaymanagedoverrides.html#cfn-apigatewayv2-apigatewaymanagedoverrides-stage
     * @external
     */
    stage: CfnApiGatewayManagedOverrides.StageOverridesProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::ApiGatewayV2::ApiGatewayManagedOverrides`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnApiGatewayManagedOverridesProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ApiGatewayV2::ApiGatewayManagedOverrides`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-apigatewaymanagedoverrides.html
 * @external
 * @cloudformationResource AWS::ApiGatewayV2::ApiGatewayManagedOverrides
 */
export declare namespace CfnApiGatewayManagedOverrides {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-apigatewaymanagedoverrides-accesslogsettings.html
     * @external
     */
    interface AccessLogSettingsProperty {
        /**
         * `CfnApiGatewayManagedOverrides.AccessLogSettingsProperty.DestinationArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-apigatewaymanagedoverrides-accesslogsettings.html#cfn-apigatewayv2-apigatewaymanagedoverrides-accesslogsettings-destinationarn
         * @external
         */
        readonly destinationArn?: string;
        /**
         * `CfnApiGatewayManagedOverrides.AccessLogSettingsProperty.Format`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-apigatewaymanagedoverrides-accesslogsettings.html#cfn-apigatewayv2-apigatewaymanagedoverrides-accesslogsettings-format
         * @external
         */
        readonly format?: string;
    }
}
/**
 * A CloudFormation `AWS::ApiGatewayV2::ApiGatewayManagedOverrides`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-apigatewaymanagedoverrides.html
 * @external
 * @cloudformationResource AWS::ApiGatewayV2::ApiGatewayManagedOverrides
 */
export declare namespace CfnApiGatewayManagedOverrides {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-apigatewaymanagedoverrides-integrationoverrides.html
     * @external
     */
    interface IntegrationOverridesProperty {
        /**
         * `CfnApiGatewayManagedOverrides.IntegrationOverridesProperty.Description`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-apigatewaymanagedoverrides-integrationoverrides.html#cfn-apigatewayv2-apigatewaymanagedoverrides-integrationoverrides-description
         * @external
         */
        readonly description?: string;
        /**
         * `CfnApiGatewayManagedOverrides.IntegrationOverridesProperty.IntegrationMethod`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-apigatewaymanagedoverrides-integrationoverrides.html#cfn-apigatewayv2-apigatewaymanagedoverrides-integrationoverrides-integrationmethod
         * @external
         */
        readonly integrationMethod?: string;
        /**
         * `CfnApiGatewayManagedOverrides.IntegrationOverridesProperty.PayloadFormatVersion`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-apigatewaymanagedoverrides-integrationoverrides.html#cfn-apigatewayv2-apigatewaymanagedoverrides-integrationoverrides-payloadformatversion
         * @external
         */
        readonly payloadFormatVersion?: string;
        /**
         * `CfnApiGatewayManagedOverrides.IntegrationOverridesProperty.TimeoutInMillis`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-apigatewaymanagedoverrides-integrationoverrides.html#cfn-apigatewayv2-apigatewaymanagedoverrides-integrationoverrides-timeoutinmillis
         * @external
         */
        readonly timeoutInMillis?: number;
    }
}
/**
 * A CloudFormation `AWS::ApiGatewayV2::ApiGatewayManagedOverrides`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-apigatewaymanagedoverrides.html
 * @external
 * @cloudformationResource AWS::ApiGatewayV2::ApiGatewayManagedOverrides
 */
export declare namespace CfnApiGatewayManagedOverrides {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-apigatewaymanagedoverrides-routeoverrides.html
     * @external
     */
    interface RouteOverridesProperty {
        /**
         * `CfnApiGatewayManagedOverrides.RouteOverridesProperty.AuthorizationScopes`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-apigatewaymanagedoverrides-routeoverrides.html#cfn-apigatewayv2-apigatewaymanagedoverrides-routeoverrides-authorizationscopes
         * @external
         */
        readonly authorizationScopes?: string[];
        /**
         * `CfnApiGatewayManagedOverrides.RouteOverridesProperty.AuthorizationType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-apigatewaymanagedoverrides-routeoverrides.html#cfn-apigatewayv2-apigatewaymanagedoverrides-routeoverrides-authorizationtype
         * @external
         */
        readonly authorizationType?: string;
        /**
         * `CfnApiGatewayManagedOverrides.RouteOverridesProperty.AuthorizerId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-apigatewaymanagedoverrides-routeoverrides.html#cfn-apigatewayv2-apigatewaymanagedoverrides-routeoverrides-authorizerid
         * @external
         */
        readonly authorizerId?: string;
        /**
         * `CfnApiGatewayManagedOverrides.RouteOverridesProperty.OperationName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-apigatewaymanagedoverrides-routeoverrides.html#cfn-apigatewayv2-apigatewaymanagedoverrides-routeoverrides-operationname
         * @external
         */
        readonly operationName?: string;
        /**
         * `CfnApiGatewayManagedOverrides.RouteOverridesProperty.Target`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-apigatewaymanagedoverrides-routeoverrides.html#cfn-apigatewayv2-apigatewaymanagedoverrides-routeoverrides-target
         * @external
         */
        readonly target?: string;
    }
}
/**
 * A CloudFormation `AWS::ApiGatewayV2::ApiGatewayManagedOverrides`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-apigatewaymanagedoverrides.html
 * @external
 * @cloudformationResource AWS::ApiGatewayV2::ApiGatewayManagedOverrides
 */
export declare namespace CfnApiGatewayManagedOverrides {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-apigatewaymanagedoverrides-routesettings.html
     * @external
     */
    interface RouteSettingsProperty {
        /**
         * `CfnApiGatewayManagedOverrides.RouteSettingsProperty.DataTraceEnabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-apigatewaymanagedoverrides-routesettings.html#cfn-apigatewayv2-apigatewaymanagedoverrides-routesettings-datatraceenabled
         * @external
         */
        readonly dataTraceEnabled?: boolean | cdk.IResolvable;
        /**
         * `CfnApiGatewayManagedOverrides.RouteSettingsProperty.DetailedMetricsEnabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-apigatewaymanagedoverrides-routesettings.html#cfn-apigatewayv2-apigatewaymanagedoverrides-routesettings-detailedmetricsenabled
         * @external
         */
        readonly detailedMetricsEnabled?: boolean | cdk.IResolvable;
        /**
         * `CfnApiGatewayManagedOverrides.RouteSettingsProperty.LoggingLevel`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-apigatewaymanagedoverrides-routesettings.html#cfn-apigatewayv2-apigatewaymanagedoverrides-routesettings-logginglevel
         * @external
         */
        readonly loggingLevel?: string;
        /**
         * `CfnApiGatewayManagedOverrides.RouteSettingsProperty.ThrottlingBurstLimit`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-apigatewaymanagedoverrides-routesettings.html#cfn-apigatewayv2-apigatewaymanagedoverrides-routesettings-throttlingburstlimit
         * @external
         */
        readonly throttlingBurstLimit?: number;
        /**
         * `CfnApiGatewayManagedOverrides.RouteSettingsProperty.ThrottlingRateLimit`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-apigatewaymanagedoverrides-routesettings.html#cfn-apigatewayv2-apigatewaymanagedoverrides-routesettings-throttlingratelimit
         * @external
         */
        readonly throttlingRateLimit?: number;
    }
}
/**
 * A CloudFormation `AWS::ApiGatewayV2::ApiGatewayManagedOverrides`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-apigatewaymanagedoverrides.html
 * @external
 * @cloudformationResource AWS::ApiGatewayV2::ApiGatewayManagedOverrides
 */
export declare namespace CfnApiGatewayManagedOverrides {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-apigatewaymanagedoverrides-stageoverrides.html
     * @external
     */
    interface StageOverridesProperty {
        /**
         * `CfnApiGatewayManagedOverrides.StageOverridesProperty.AccessLogSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-apigatewaymanagedoverrides-stageoverrides.html#cfn-apigatewayv2-apigatewaymanagedoverrides-stageoverrides-accesslogsettings
         * @external
         */
        readonly accessLogSettings?: CfnApiGatewayManagedOverrides.AccessLogSettingsProperty | cdk.IResolvable;
        /**
         * `CfnApiGatewayManagedOverrides.StageOverridesProperty.AutoDeploy`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-apigatewaymanagedoverrides-stageoverrides.html#cfn-apigatewayv2-apigatewaymanagedoverrides-stageoverrides-autodeploy
         * @external
         */
        readonly autoDeploy?: boolean | cdk.IResolvable;
        /**
         * `CfnApiGatewayManagedOverrides.StageOverridesProperty.DefaultRouteSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-apigatewaymanagedoverrides-stageoverrides.html#cfn-apigatewayv2-apigatewaymanagedoverrides-stageoverrides-defaultroutesettings
         * @external
         */
        readonly defaultRouteSettings?: CfnApiGatewayManagedOverrides.RouteSettingsProperty | cdk.IResolvable;
        /**
         * `CfnApiGatewayManagedOverrides.StageOverridesProperty.Description`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-apigatewaymanagedoverrides-stageoverrides.html#cfn-apigatewayv2-apigatewaymanagedoverrides-stageoverrides-description
         * @external
         */
        readonly description?: string;
        /**
         * `CfnApiGatewayManagedOverrides.StageOverridesProperty.RouteSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-apigatewaymanagedoverrides-stageoverrides.html#cfn-apigatewayv2-apigatewaymanagedoverrides-stageoverrides-routesettings
         * @external
         */
        readonly routeSettings?: any | cdk.IResolvable;
        /**
         * `CfnApiGatewayManagedOverrides.StageOverridesProperty.StageVariables`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-apigatewaymanagedoverrides-stageoverrides.html#cfn-apigatewayv2-apigatewaymanagedoverrides-stageoverrides-stagevariables
         * @external
         */
        readonly stageVariables?: any | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::ApiGatewayV2::ApiMapping`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-apimapping.html
 * @external
 */
export interface CfnApiMappingProps {
    /**
     * `AWS::ApiGatewayV2::ApiMapping.ApiId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-apimapping.html#cfn-apigatewayv2-apimapping-apiid
     * @external
     */
    readonly apiId: string;
    /**
     * `AWS::ApiGatewayV2::ApiMapping.DomainName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-apimapping.html#cfn-apigatewayv2-apimapping-domainname
     * @external
     */
    readonly domainName: string;
    /**
     * `AWS::ApiGatewayV2::ApiMapping.Stage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-apimapping.html#cfn-apigatewayv2-apimapping-stage
     * @external
     */
    readonly stage: string;
    /**
     * `AWS::ApiGatewayV2::ApiMapping.ApiMappingKey`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-apimapping.html#cfn-apigatewayv2-apimapping-apimappingkey
     * @external
     */
    readonly apiMappingKey?: string;
}
/**
 * A CloudFormation `AWS::ApiGatewayV2::ApiMapping`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-apimapping.html
 * @external
 * @cloudformationResource AWS::ApiGatewayV2::ApiMapping
 */
export declare class CfnApiMapping extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ApiGatewayV2::ApiMapping";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnApiMapping;
    /**
     * `AWS::ApiGatewayV2::ApiMapping.ApiId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-apimapping.html#cfn-apigatewayv2-apimapping-apiid
     * @external
     */
    apiId: string;
    /**
     * `AWS::ApiGatewayV2::ApiMapping.DomainName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-apimapping.html#cfn-apigatewayv2-apimapping-domainname
     * @external
     */
    domainName: string;
    /**
     * `AWS::ApiGatewayV2::ApiMapping.Stage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-apimapping.html#cfn-apigatewayv2-apimapping-stage
     * @external
     */
    stage: string;
    /**
     * `AWS::ApiGatewayV2::ApiMapping.ApiMappingKey`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-apimapping.html#cfn-apigatewayv2-apimapping-apimappingkey
     * @external
     */
    apiMappingKey: string | undefined;
    /**
     * Create a new `AWS::ApiGatewayV2::ApiMapping`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnApiMappingProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::ApiGatewayV2::Authorizer`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html
 * @external
 */
export interface CfnAuthorizerProps {
    /**
     * `AWS::ApiGatewayV2::Authorizer.ApiId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-apiid
     * @external
     */
    readonly apiId: string;
    /**
     * `AWS::ApiGatewayV2::Authorizer.AuthorizerType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-authorizertype
     * @external
     */
    readonly authorizerType: string;
    /**
     * `AWS::ApiGatewayV2::Authorizer.IdentitySource`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-identitysource
     * @external
     */
    readonly identitySource: string[];
    /**
     * `AWS::ApiGatewayV2::Authorizer.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-name
     * @external
     */
    readonly name: string;
    /**
     * `AWS::ApiGatewayV2::Authorizer.AuthorizerCredentialsArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-authorizercredentialsarn
     * @external
     */
    readonly authorizerCredentialsArn?: string;
    /**
     * `AWS::ApiGatewayV2::Authorizer.AuthorizerPayloadFormatVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-authorizerpayloadformatversion
     * @external
     */
    readonly authorizerPayloadFormatVersion?: string;
    /**
     * `AWS::ApiGatewayV2::Authorizer.AuthorizerResultTtlInSeconds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-authorizerresultttlinseconds
     * @external
     */
    readonly authorizerResultTtlInSeconds?: number;
    /**
     * `AWS::ApiGatewayV2::Authorizer.AuthorizerUri`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-authorizeruri
     * @external
     */
    readonly authorizerUri?: string;
    /**
     * `AWS::ApiGatewayV2::Authorizer.EnableSimpleResponses`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-enablesimpleresponses
     * @external
     */
    readonly enableSimpleResponses?: boolean | cdk.IResolvable;
    /**
     * `AWS::ApiGatewayV2::Authorizer.IdentityValidationExpression`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-identityvalidationexpression
     * @external
     */
    readonly identityValidationExpression?: string;
    /**
     * `AWS::ApiGatewayV2::Authorizer.JwtConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-jwtconfiguration
     * @external
     */
    readonly jwtConfiguration?: CfnAuthorizer.JWTConfigurationProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::ApiGatewayV2::Authorizer`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html
 * @external
 * @cloudformationResource AWS::ApiGatewayV2::Authorizer
 */
export declare class CfnAuthorizer extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ApiGatewayV2::Authorizer";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnAuthorizer;
    /**
     * `AWS::ApiGatewayV2::Authorizer.ApiId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-apiid
     * @external
     */
    apiId: string;
    /**
     * `AWS::ApiGatewayV2::Authorizer.AuthorizerType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-authorizertype
     * @external
     */
    authorizerType: string;
    /**
     * `AWS::ApiGatewayV2::Authorizer.IdentitySource`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-identitysource
     * @external
     */
    identitySource: string[];
    /**
     * `AWS::ApiGatewayV2::Authorizer.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-name
     * @external
     */
    name: string;
    /**
     * `AWS::ApiGatewayV2::Authorizer.AuthorizerCredentialsArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-authorizercredentialsarn
     * @external
     */
    authorizerCredentialsArn: string | undefined;
    /**
     * `AWS::ApiGatewayV2::Authorizer.AuthorizerPayloadFormatVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-authorizerpayloadformatversion
     * @external
     */
    authorizerPayloadFormatVersion: string | undefined;
    /**
     * `AWS::ApiGatewayV2::Authorizer.AuthorizerResultTtlInSeconds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-authorizerresultttlinseconds
     * @external
     */
    authorizerResultTtlInSeconds: number | undefined;
    /**
     * `AWS::ApiGatewayV2::Authorizer.AuthorizerUri`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-authorizeruri
     * @external
     */
    authorizerUri: string | undefined;
    /**
     * `AWS::ApiGatewayV2::Authorizer.EnableSimpleResponses`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-enablesimpleresponses
     * @external
     */
    enableSimpleResponses: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::ApiGatewayV2::Authorizer.IdentityValidationExpression`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-identityvalidationexpression
     * @external
     */
    identityValidationExpression: string | undefined;
    /**
     * `AWS::ApiGatewayV2::Authorizer.JwtConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-jwtconfiguration
     * @external
     */
    jwtConfiguration: CfnAuthorizer.JWTConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::ApiGatewayV2::Authorizer`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAuthorizerProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ApiGatewayV2::Authorizer`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html
 * @external
 * @cloudformationResource AWS::ApiGatewayV2::Authorizer
 */
export declare namespace CfnAuthorizer {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-authorizer-jwtconfiguration.html
     * @external
     */
    interface JWTConfigurationProperty {
        /**
         * `CfnAuthorizer.JWTConfigurationProperty.Audience`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-authorizer-jwtconfiguration.html#cfn-apigatewayv2-authorizer-jwtconfiguration-audience
         * @external
         */
        readonly audience?: string[];
        /**
         * `CfnAuthorizer.JWTConfigurationProperty.Issuer`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-authorizer-jwtconfiguration.html#cfn-apigatewayv2-authorizer-jwtconfiguration-issuer
         * @external
         */
        readonly issuer?: string;
    }
}
/**
 * Properties for defining a `AWS::ApiGatewayV2::Deployment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-deployment.html
 * @external
 */
export interface CfnDeploymentProps {
    /**
     * `AWS::ApiGatewayV2::Deployment.ApiId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-deployment.html#cfn-apigatewayv2-deployment-apiid
     * @external
     */
    readonly apiId: string;
    /**
     * `AWS::ApiGatewayV2::Deployment.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-deployment.html#cfn-apigatewayv2-deployment-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::ApiGatewayV2::Deployment.StageName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-deployment.html#cfn-apigatewayv2-deployment-stagename
     * @external
     */
    readonly stageName?: string;
}
/**
 * A CloudFormation `AWS::ApiGatewayV2::Deployment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-deployment.html
 * @external
 * @cloudformationResource AWS::ApiGatewayV2::Deployment
 */
export declare class CfnDeployment extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ApiGatewayV2::Deployment";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDeployment;
    /**
     * `AWS::ApiGatewayV2::Deployment.ApiId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-deployment.html#cfn-apigatewayv2-deployment-apiid
     * @external
     */
    apiId: string;
    /**
     * `AWS::ApiGatewayV2::Deployment.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-deployment.html#cfn-apigatewayv2-deployment-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::ApiGatewayV2::Deployment.StageName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-deployment.html#cfn-apigatewayv2-deployment-stagename
     * @external
     */
    stageName: string | undefined;
    /**
     * Create a new `AWS::ApiGatewayV2::Deployment`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDeploymentProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::ApiGatewayV2::DomainName`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-domainname.html
 * @external
 */
export interface CfnDomainNameProps {
    /**
     * `AWS::ApiGatewayV2::DomainName.DomainName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-domainname.html#cfn-apigatewayv2-domainname-domainname
     * @external
     */
    readonly domainName: string;
    /**
     * `AWS::ApiGatewayV2::DomainName.DomainNameConfigurations`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-domainname.html#cfn-apigatewayv2-domainname-domainnameconfigurations
     * @external
     */
    readonly domainNameConfigurations?: Array<CfnDomainName.DomainNameConfigurationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ApiGatewayV2::DomainName.MutualTlsAuthentication`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-domainname.html#cfn-apigatewayv2-domainname-mutualtlsauthentication
     * @external
     */
    readonly mutualTlsAuthentication?: CfnDomainName.MutualTlsAuthenticationProperty | cdk.IResolvable;
    /**
     * `AWS::ApiGatewayV2::DomainName.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-domainname.html#cfn-apigatewayv2-domainname-tags
     * @external
     */
    readonly tags?: any;
}
/**
 * A CloudFormation `AWS::ApiGatewayV2::DomainName`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-domainname.html
 * @external
 * @cloudformationResource AWS::ApiGatewayV2::DomainName
 */
export declare class CfnDomainName extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ApiGatewayV2::DomainName";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDomainName;
    /**
     * @external
     * @cloudformationAttribute RegionalDomainName
     */
    readonly attrRegionalDomainName: string;
    /**
     * @external
     * @cloudformationAttribute RegionalHostedZoneId
     */
    readonly attrRegionalHostedZoneId: string;
    /**
     * `AWS::ApiGatewayV2::DomainName.DomainName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-domainname.html#cfn-apigatewayv2-domainname-domainname
     * @external
     */
    domainName: string;
    /**
     * `AWS::ApiGatewayV2::DomainName.DomainNameConfigurations`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-domainname.html#cfn-apigatewayv2-domainname-domainnameconfigurations
     * @external
     */
    domainNameConfigurations: Array<CfnDomainName.DomainNameConfigurationProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::ApiGatewayV2::DomainName.MutualTlsAuthentication`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-domainname.html#cfn-apigatewayv2-domainname-mutualtlsauthentication
     * @external
     */
    mutualTlsAuthentication: CfnDomainName.MutualTlsAuthenticationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::ApiGatewayV2::DomainName.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-domainname.html#cfn-apigatewayv2-domainname-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::ApiGatewayV2::DomainName`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDomainNameProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ApiGatewayV2::DomainName`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-domainname.html
 * @external
 * @cloudformationResource AWS::ApiGatewayV2::DomainName
 */
export declare namespace CfnDomainName {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-domainname-domainnameconfiguration.html
     * @external
     */
    interface DomainNameConfigurationProperty {
        /**
         * `CfnDomainName.DomainNameConfigurationProperty.CertificateArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-domainname-domainnameconfiguration.html#cfn-apigatewayv2-domainname-domainnameconfiguration-certificatearn
         * @external
         */
        readonly certificateArn?: string;
        /**
         * `CfnDomainName.DomainNameConfigurationProperty.CertificateName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-domainname-domainnameconfiguration.html#cfn-apigatewayv2-domainname-domainnameconfiguration-certificatename
         * @external
         */
        readonly certificateName?: string;
        /**
         * `CfnDomainName.DomainNameConfigurationProperty.EndpointType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-domainname-domainnameconfiguration.html#cfn-apigatewayv2-domainname-domainnameconfiguration-endpointtype
         * @external
         */
        readonly endpointType?: string;
        /**
         * `CfnDomainName.DomainNameConfigurationProperty.SecurityPolicy`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-domainname-domainnameconfiguration.html#cfn-apigatewayv2-domainname-domainnameconfiguration-securitypolicy
         * @external
         */
        readonly securityPolicy?: string;
    }
}
/**
 * A CloudFormation `AWS::ApiGatewayV2::DomainName`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-domainname.html
 * @external
 * @cloudformationResource AWS::ApiGatewayV2::DomainName
 */
export declare namespace CfnDomainName {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-domainname-mutualtlsauthentication.html
     * @external
     */
    interface MutualTlsAuthenticationProperty {
        /**
         * `CfnDomainName.MutualTlsAuthenticationProperty.TruststoreUri`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-domainname-mutualtlsauthentication.html#cfn-apigatewayv2-domainname-mutualtlsauthentication-truststoreuri
         * @external
         */
        readonly truststoreUri?: string;
        /**
         * `CfnDomainName.MutualTlsAuthenticationProperty.TruststoreVersion`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-domainname-mutualtlsauthentication.html#cfn-apigatewayv2-domainname-mutualtlsauthentication-truststoreversion
         * @external
         */
        readonly truststoreVersion?: string;
    }
}
/**
 * Properties for defining a `AWS::ApiGatewayV2::Integration`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html
 * @external
 */
export interface CfnIntegrationProps {
    /**
     * `AWS::ApiGatewayV2::Integration.ApiId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-apiid
     * @external
     */
    readonly apiId: string;
    /**
     * `AWS::ApiGatewayV2::Integration.IntegrationType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-integrationtype
     * @external
     */
    readonly integrationType: string;
    /**
     * `AWS::ApiGatewayV2::Integration.ConnectionId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-connectionid
     * @external
     */
    readonly connectionId?: string;
    /**
     * `AWS::ApiGatewayV2::Integration.ConnectionType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-connectiontype
     * @external
     */
    readonly connectionType?: string;
    /**
     * `AWS::ApiGatewayV2::Integration.ContentHandlingStrategy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-contenthandlingstrategy
     * @external
     */
    readonly contentHandlingStrategy?: string;
    /**
     * `AWS::ApiGatewayV2::Integration.CredentialsArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-credentialsarn
     * @external
     */
    readonly credentialsArn?: string;
    /**
     * `AWS::ApiGatewayV2::Integration.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::ApiGatewayV2::Integration.IntegrationMethod`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-integrationmethod
     * @external
     */
    readonly integrationMethod?: string;
    /**
     * `AWS::ApiGatewayV2::Integration.IntegrationSubtype`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-integrationsubtype
     * @external
     */
    readonly integrationSubtype?: string;
    /**
     * `AWS::ApiGatewayV2::Integration.IntegrationUri`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-integrationuri
     * @external
     */
    readonly integrationUri?: string;
    /**
     * `AWS::ApiGatewayV2::Integration.PassthroughBehavior`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-passthroughbehavior
     * @external
     */
    readonly passthroughBehavior?: string;
    /**
     * `AWS::ApiGatewayV2::Integration.PayloadFormatVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-payloadformatversion
     * @external
     */
    readonly payloadFormatVersion?: string;
    /**
     * `AWS::ApiGatewayV2::Integration.RequestParameters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-requestparameters
     * @external
     */
    readonly requestParameters?: any | cdk.IResolvable;
    /**
     * `AWS::ApiGatewayV2::Integration.RequestTemplates`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-requesttemplates
     * @external
     */
    readonly requestTemplates?: any | cdk.IResolvable;
    /**
     * `AWS::ApiGatewayV2::Integration.TemplateSelectionExpression`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-templateselectionexpression
     * @external
     */
    readonly templateSelectionExpression?: string;
    /**
     * `AWS::ApiGatewayV2::Integration.TimeoutInMillis`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-timeoutinmillis
     * @external
     */
    readonly timeoutInMillis?: number;
    /**
     * `AWS::ApiGatewayV2::Integration.TlsConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-tlsconfig
     * @external
     */
    readonly tlsConfig?: CfnIntegration.TlsConfigProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::ApiGatewayV2::Integration`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html
 * @external
 * @cloudformationResource AWS::ApiGatewayV2::Integration
 */
export declare class CfnIntegration extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ApiGatewayV2::Integration";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnIntegration;
    /**
     * `AWS::ApiGatewayV2::Integration.ApiId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-apiid
     * @external
     */
    apiId: string;
    /**
     * `AWS::ApiGatewayV2::Integration.IntegrationType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-integrationtype
     * @external
     */
    integrationType: string;
    /**
     * `AWS::ApiGatewayV2::Integration.ConnectionId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-connectionid
     * @external
     */
    connectionId: string | undefined;
    /**
     * `AWS::ApiGatewayV2::Integration.ConnectionType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-connectiontype
     * @external
     */
    connectionType: string | undefined;
    /**
     * `AWS::ApiGatewayV2::Integration.ContentHandlingStrategy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-contenthandlingstrategy
     * @external
     */
    contentHandlingStrategy: string | undefined;
    /**
     * `AWS::ApiGatewayV2::Integration.CredentialsArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-credentialsarn
     * @external
     */
    credentialsArn: string | undefined;
    /**
     * `AWS::ApiGatewayV2::Integration.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::ApiGatewayV2::Integration.IntegrationMethod`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-integrationmethod
     * @external
     */
    integrationMethod: string | undefined;
    /**
     * `AWS::ApiGatewayV2::Integration.IntegrationSubtype`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-integrationsubtype
     * @external
     */
    integrationSubtype: string | undefined;
    /**
     * `AWS::ApiGatewayV2::Integration.IntegrationUri`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-integrationuri
     * @external
     */
    integrationUri: string | undefined;
    /**
     * `AWS::ApiGatewayV2::Integration.PassthroughBehavior`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-passthroughbehavior
     * @external
     */
    passthroughBehavior: string | undefined;
    /**
     * `AWS::ApiGatewayV2::Integration.PayloadFormatVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-payloadformatversion
     * @external
     */
    payloadFormatVersion: string | undefined;
    /**
     * `AWS::ApiGatewayV2::Integration.RequestParameters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-requestparameters
     * @external
     */
    requestParameters: any | cdk.IResolvable | undefined;
    /**
     * `AWS::ApiGatewayV2::Integration.RequestTemplates`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-requesttemplates
     * @external
     */
    requestTemplates: any | cdk.IResolvable | undefined;
    /**
     * `AWS::ApiGatewayV2::Integration.TemplateSelectionExpression`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-templateselectionexpression
     * @external
     */
    templateSelectionExpression: string | undefined;
    /**
     * `AWS::ApiGatewayV2::Integration.TimeoutInMillis`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-timeoutinmillis
     * @external
     */
    timeoutInMillis: number | undefined;
    /**
     * `AWS::ApiGatewayV2::Integration.TlsConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-tlsconfig
     * @external
     */
    tlsConfig: CfnIntegration.TlsConfigProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::ApiGatewayV2::Integration`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnIntegrationProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ApiGatewayV2::Integration`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html
 * @external
 * @cloudformationResource AWS::ApiGatewayV2::Integration
 */
export declare namespace CfnIntegration {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-integration-tlsconfig.html
     * @external
     */
    interface TlsConfigProperty {
        /**
         * `CfnIntegration.TlsConfigProperty.ServerNameToVerify`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-integration-tlsconfig.html#cfn-apigatewayv2-integration-tlsconfig-servernametoverify
         * @external
         */
        readonly serverNameToVerify?: string;
    }
}
/**
 * Properties for defining a `AWS::ApiGatewayV2::IntegrationResponse`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integrationresponse.html
 * @external
 */
export interface CfnIntegrationResponseProps {
    /**
     * `AWS::ApiGatewayV2::IntegrationResponse.ApiId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integrationresponse.html#cfn-apigatewayv2-integrationresponse-apiid
     * @external
     */
    readonly apiId: string;
    /**
     * `AWS::ApiGatewayV2::IntegrationResponse.IntegrationId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integrationresponse.html#cfn-apigatewayv2-integrationresponse-integrationid
     * @external
     */
    readonly integrationId: string;
    /**
     * `AWS::ApiGatewayV2::IntegrationResponse.IntegrationResponseKey`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integrationresponse.html#cfn-apigatewayv2-integrationresponse-integrationresponsekey
     * @external
     */
    readonly integrationResponseKey: string;
    /**
     * `AWS::ApiGatewayV2::IntegrationResponse.ContentHandlingStrategy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integrationresponse.html#cfn-apigatewayv2-integrationresponse-contenthandlingstrategy
     * @external
     */
    readonly contentHandlingStrategy?: string;
    /**
     * `AWS::ApiGatewayV2::IntegrationResponse.ResponseParameters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integrationresponse.html#cfn-apigatewayv2-integrationresponse-responseparameters
     * @external
     */
    readonly responseParameters?: any | cdk.IResolvable;
    /**
     * `AWS::ApiGatewayV2::IntegrationResponse.ResponseTemplates`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integrationresponse.html#cfn-apigatewayv2-integrationresponse-responsetemplates
     * @external
     */
    readonly responseTemplates?: any | cdk.IResolvable;
    /**
     * `AWS::ApiGatewayV2::IntegrationResponse.TemplateSelectionExpression`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integrationresponse.html#cfn-apigatewayv2-integrationresponse-templateselectionexpression
     * @external
     */
    readonly templateSelectionExpression?: string;
}
/**
 * A CloudFormation `AWS::ApiGatewayV2::IntegrationResponse`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integrationresponse.html
 * @external
 * @cloudformationResource AWS::ApiGatewayV2::IntegrationResponse
 */
export declare class CfnIntegrationResponse extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ApiGatewayV2::IntegrationResponse";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnIntegrationResponse;
    /**
     * `AWS::ApiGatewayV2::IntegrationResponse.ApiId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integrationresponse.html#cfn-apigatewayv2-integrationresponse-apiid
     * @external
     */
    apiId: string;
    /**
     * `AWS::ApiGatewayV2::IntegrationResponse.IntegrationId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integrationresponse.html#cfn-apigatewayv2-integrationresponse-integrationid
     * @external
     */
    integrationId: string;
    /**
     * `AWS::ApiGatewayV2::IntegrationResponse.IntegrationResponseKey`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integrationresponse.html#cfn-apigatewayv2-integrationresponse-integrationresponsekey
     * @external
     */
    integrationResponseKey: string;
    /**
     * `AWS::ApiGatewayV2::IntegrationResponse.ContentHandlingStrategy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integrationresponse.html#cfn-apigatewayv2-integrationresponse-contenthandlingstrategy
     * @external
     */
    contentHandlingStrategy: string | undefined;
    /**
     * `AWS::ApiGatewayV2::IntegrationResponse.ResponseParameters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integrationresponse.html#cfn-apigatewayv2-integrationresponse-responseparameters
     * @external
     */
    responseParameters: any | cdk.IResolvable | undefined;
    /**
     * `AWS::ApiGatewayV2::IntegrationResponse.ResponseTemplates`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integrationresponse.html#cfn-apigatewayv2-integrationresponse-responsetemplates
     * @external
     */
    responseTemplates: any | cdk.IResolvable | undefined;
    /**
     * `AWS::ApiGatewayV2::IntegrationResponse.TemplateSelectionExpression`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integrationresponse.html#cfn-apigatewayv2-integrationresponse-templateselectionexpression
     * @external
     */
    templateSelectionExpression: string | undefined;
    /**
     * Create a new `AWS::ApiGatewayV2::IntegrationResponse`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnIntegrationResponseProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::ApiGatewayV2::Model`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-model.html
 * @external
 */
export interface CfnModelProps {
    /**
     * `AWS::ApiGatewayV2::Model.ApiId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-model.html#cfn-apigatewayv2-model-apiid
     * @external
     */
    readonly apiId: string;
    /**
     * `AWS::ApiGatewayV2::Model.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-model.html#cfn-apigatewayv2-model-name
     * @external
     */
    readonly name: string;
    /**
     * `AWS::ApiGatewayV2::Model.Schema`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-model.html#cfn-apigatewayv2-model-schema
     * @external
     */
    readonly schema: any | cdk.IResolvable;
    /**
     * `AWS::ApiGatewayV2::Model.ContentType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-model.html#cfn-apigatewayv2-model-contenttype
     * @external
     */
    readonly contentType?: string;
    /**
     * `AWS::ApiGatewayV2::Model.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-model.html#cfn-apigatewayv2-model-description
     * @external
     */
    readonly description?: string;
}
/**
 * A CloudFormation `AWS::ApiGatewayV2::Model`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-model.html
 * @external
 * @cloudformationResource AWS::ApiGatewayV2::Model
 */
export declare class CfnModel extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ApiGatewayV2::Model";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnModel;
    /**
     * `AWS::ApiGatewayV2::Model.ApiId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-model.html#cfn-apigatewayv2-model-apiid
     * @external
     */
    apiId: string;
    /**
     * `AWS::ApiGatewayV2::Model.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-model.html#cfn-apigatewayv2-model-name
     * @external
     */
    name: string;
    /**
     * `AWS::ApiGatewayV2::Model.Schema`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-model.html#cfn-apigatewayv2-model-schema
     * @external
     */
    schema: any | cdk.IResolvable;
    /**
     * `AWS::ApiGatewayV2::Model.ContentType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-model.html#cfn-apigatewayv2-model-contenttype
     * @external
     */
    contentType: string | undefined;
    /**
     * `AWS::ApiGatewayV2::Model.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-model.html#cfn-apigatewayv2-model-description
     * @external
     */
    description: string | undefined;
    /**
     * Create a new `AWS::ApiGatewayV2::Model`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnModelProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::ApiGatewayV2::Route`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-route.html
 * @external
 */
export interface CfnRouteProps {
    /**
     * `AWS::ApiGatewayV2::Route.ApiId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-route.html#cfn-apigatewayv2-route-apiid
     * @external
     */
    readonly apiId: string;
    /**
     * `AWS::ApiGatewayV2::Route.RouteKey`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-route.html#cfn-apigatewayv2-route-routekey
     * @external
     */
    readonly routeKey: string;
    /**
     * `AWS::ApiGatewayV2::Route.ApiKeyRequired`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-route.html#cfn-apigatewayv2-route-apikeyrequired
     * @external
     */
    readonly apiKeyRequired?: boolean | cdk.IResolvable;
    /**
     * `AWS::ApiGatewayV2::Route.AuthorizationScopes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-route.html#cfn-apigatewayv2-route-authorizationscopes
     * @external
     */
    readonly authorizationScopes?: string[];
    /**
     * `AWS::ApiGatewayV2::Route.AuthorizationType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-route.html#cfn-apigatewayv2-route-authorizationtype
     * @external
     */
    readonly authorizationType?: string;
    /**
     * `AWS::ApiGatewayV2::Route.AuthorizerId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-route.html#cfn-apigatewayv2-route-authorizerid
     * @external
     */
    readonly authorizerId?: string;
    /**
     * `AWS::ApiGatewayV2::Route.ModelSelectionExpression`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-route.html#cfn-apigatewayv2-route-modelselectionexpression
     * @external
     */
    readonly modelSelectionExpression?: string;
    /**
     * `AWS::ApiGatewayV2::Route.OperationName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-route.html#cfn-apigatewayv2-route-operationname
     * @external
     */
    readonly operationName?: string;
    /**
     * `AWS::ApiGatewayV2::Route.RequestModels`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-route.html#cfn-apigatewayv2-route-requestmodels
     * @external
     */
    readonly requestModels?: any | cdk.IResolvable;
    /**
     * `AWS::ApiGatewayV2::Route.RequestParameters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-route.html#cfn-apigatewayv2-route-requestparameters
     * @external
     */
    readonly requestParameters?: any | cdk.IResolvable;
    /**
     * `AWS::ApiGatewayV2::Route.RouteResponseSelectionExpression`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-route.html#cfn-apigatewayv2-route-routeresponseselectionexpression
     * @external
     */
    readonly routeResponseSelectionExpression?: string;
    /**
     * `AWS::ApiGatewayV2::Route.Target`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-route.html#cfn-apigatewayv2-route-target
     * @external
     */
    readonly target?: string;
}
/**
 * A CloudFormation `AWS::ApiGatewayV2::Route`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-route.html
 * @external
 * @cloudformationResource AWS::ApiGatewayV2::Route
 */
export declare class CfnRoute extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ApiGatewayV2::Route";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnRoute;
    /**
     * `AWS::ApiGatewayV2::Route.ApiId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-route.html#cfn-apigatewayv2-route-apiid
     * @external
     */
    apiId: string;
    /**
     * `AWS::ApiGatewayV2::Route.RouteKey`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-route.html#cfn-apigatewayv2-route-routekey
     * @external
     */
    routeKey: string;
    /**
     * `AWS::ApiGatewayV2::Route.ApiKeyRequired`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-route.html#cfn-apigatewayv2-route-apikeyrequired
     * @external
     */
    apiKeyRequired: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::ApiGatewayV2::Route.AuthorizationScopes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-route.html#cfn-apigatewayv2-route-authorizationscopes
     * @external
     */
    authorizationScopes: string[] | undefined;
    /**
     * `AWS::ApiGatewayV2::Route.AuthorizationType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-route.html#cfn-apigatewayv2-route-authorizationtype
     * @external
     */
    authorizationType: string | undefined;
    /**
     * `AWS::ApiGatewayV2::Route.AuthorizerId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-route.html#cfn-apigatewayv2-route-authorizerid
     * @external
     */
    authorizerId: string | undefined;
    /**
     * `AWS::ApiGatewayV2::Route.ModelSelectionExpression`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-route.html#cfn-apigatewayv2-route-modelselectionexpression
     * @external
     */
    modelSelectionExpression: string | undefined;
    /**
     * `AWS::ApiGatewayV2::Route.OperationName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-route.html#cfn-apigatewayv2-route-operationname
     * @external
     */
    operationName: string | undefined;
    /**
     * `AWS::ApiGatewayV2::Route.RequestModels`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-route.html#cfn-apigatewayv2-route-requestmodels
     * @external
     */
    requestModels: any | cdk.IResolvable | undefined;
    /**
     * `AWS::ApiGatewayV2::Route.RequestParameters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-route.html#cfn-apigatewayv2-route-requestparameters
     * @external
     */
    requestParameters: any | cdk.IResolvable | undefined;
    /**
     * `AWS::ApiGatewayV2::Route.RouteResponseSelectionExpression`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-route.html#cfn-apigatewayv2-route-routeresponseselectionexpression
     * @external
     */
    routeResponseSelectionExpression: string | undefined;
    /**
     * `AWS::ApiGatewayV2::Route.Target`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-route.html#cfn-apigatewayv2-route-target
     * @external
     */
    target: string | undefined;
    /**
     * Create a new `AWS::ApiGatewayV2::Route`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnRouteProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ApiGatewayV2::Route`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-route.html
 * @external
 * @cloudformationResource AWS::ApiGatewayV2::Route
 */
export declare namespace CfnRoute {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-route-parameterconstraints.html
     * @external
     */
    interface ParameterConstraintsProperty {
        /**
         * `CfnRoute.ParameterConstraintsProperty.Required`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-route-parameterconstraints.html#cfn-apigatewayv2-route-parameterconstraints-required
         * @external
         */
        readonly required: boolean | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::ApiGatewayV2::RouteResponse`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-routeresponse.html
 * @external
 */
export interface CfnRouteResponseProps {
    /**
     * `AWS::ApiGatewayV2::RouteResponse.ApiId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-routeresponse.html#cfn-apigatewayv2-routeresponse-apiid
     * @external
     */
    readonly apiId: string;
    /**
     * `AWS::ApiGatewayV2::RouteResponse.RouteId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-routeresponse.html#cfn-apigatewayv2-routeresponse-routeid
     * @external
     */
    readonly routeId: string;
    /**
     * `AWS::ApiGatewayV2::RouteResponse.RouteResponseKey`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-routeresponse.html#cfn-apigatewayv2-routeresponse-routeresponsekey
     * @external
     */
    readonly routeResponseKey: string;
    /**
     * `AWS::ApiGatewayV2::RouteResponse.ModelSelectionExpression`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-routeresponse.html#cfn-apigatewayv2-routeresponse-modelselectionexpression
     * @external
     */
    readonly modelSelectionExpression?: string;
    /**
     * `AWS::ApiGatewayV2::RouteResponse.ResponseModels`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-routeresponse.html#cfn-apigatewayv2-routeresponse-responsemodels
     * @external
     */
    readonly responseModels?: any | cdk.IResolvable;
    /**
     * `AWS::ApiGatewayV2::RouteResponse.ResponseParameters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-routeresponse.html#cfn-apigatewayv2-routeresponse-responseparameters
     * @external
     */
    readonly responseParameters?: any | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::ApiGatewayV2::RouteResponse`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-routeresponse.html
 * @external
 * @cloudformationResource AWS::ApiGatewayV2::RouteResponse
 */
export declare class CfnRouteResponse extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ApiGatewayV2::RouteResponse";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnRouteResponse;
    /**
     * `AWS::ApiGatewayV2::RouteResponse.ApiId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-routeresponse.html#cfn-apigatewayv2-routeresponse-apiid
     * @external
     */
    apiId: string;
    /**
     * `AWS::ApiGatewayV2::RouteResponse.RouteId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-routeresponse.html#cfn-apigatewayv2-routeresponse-routeid
     * @external
     */
    routeId: string;
    /**
     * `AWS::ApiGatewayV2::RouteResponse.RouteResponseKey`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-routeresponse.html#cfn-apigatewayv2-routeresponse-routeresponsekey
     * @external
     */
    routeResponseKey: string;
    /**
     * `AWS::ApiGatewayV2::RouteResponse.ModelSelectionExpression`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-routeresponse.html#cfn-apigatewayv2-routeresponse-modelselectionexpression
     * @external
     */
    modelSelectionExpression: string | undefined;
    /**
     * `AWS::ApiGatewayV2::RouteResponse.ResponseModels`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-routeresponse.html#cfn-apigatewayv2-routeresponse-responsemodels
     * @external
     */
    responseModels: any | cdk.IResolvable | undefined;
    /**
     * `AWS::ApiGatewayV2::RouteResponse.ResponseParameters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-routeresponse.html#cfn-apigatewayv2-routeresponse-responseparameters
     * @external
     */
    responseParameters: any | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::ApiGatewayV2::RouteResponse`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnRouteResponseProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ApiGatewayV2::RouteResponse`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-routeresponse.html
 * @external
 * @cloudformationResource AWS::ApiGatewayV2::RouteResponse
 */
export declare namespace CfnRouteResponse {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-routeresponse-parameterconstraints.html
     * @external
     */
    interface ParameterConstraintsProperty {
        /**
         * `CfnRouteResponse.ParameterConstraintsProperty.Required`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-routeresponse-parameterconstraints.html#cfn-apigatewayv2-routeresponse-parameterconstraints-required
         * @external
         */
        readonly required: boolean | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::ApiGatewayV2::Stage`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html
 * @external
 */
export interface CfnStageProps {
    /**
     * `AWS::ApiGatewayV2::Stage.ApiId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-apiid
     * @external
     */
    readonly apiId: string;
    /**
     * `AWS::ApiGatewayV2::Stage.StageName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-stagename
     * @external
     */
    readonly stageName: string;
    /**
     * `AWS::ApiGatewayV2::Stage.AccessLogSettings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-accesslogsettings
     * @external
     */
    readonly accessLogSettings?: CfnStage.AccessLogSettingsProperty | cdk.IResolvable;
    /**
     * `AWS::ApiGatewayV2::Stage.AutoDeploy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-autodeploy
     * @external
     */
    readonly autoDeploy?: boolean | cdk.IResolvable;
    /**
     * `AWS::ApiGatewayV2::Stage.ClientCertificateId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-clientcertificateid
     * @external
     */
    readonly clientCertificateId?: string;
    /**
     * `AWS::ApiGatewayV2::Stage.DefaultRouteSettings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-defaultroutesettings
     * @external
     */
    readonly defaultRouteSettings?: CfnStage.RouteSettingsProperty | cdk.IResolvable;
    /**
     * `AWS::ApiGatewayV2::Stage.DeploymentId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-deploymentid
     * @external
     */
    readonly deploymentId?: string;
    /**
     * `AWS::ApiGatewayV2::Stage.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::ApiGatewayV2::Stage.RouteSettings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-routesettings
     * @external
     */
    readonly routeSettings?: any | cdk.IResolvable;
    /**
     * `AWS::ApiGatewayV2::Stage.StageVariables`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-stagevariables
     * @external
     */
    readonly stageVariables?: any | cdk.IResolvable;
    /**
     * `AWS::ApiGatewayV2::Stage.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-tags
     * @external
     */
    readonly tags?: any;
}
/**
 * A CloudFormation `AWS::ApiGatewayV2::Stage`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html
 * @external
 * @cloudformationResource AWS::ApiGatewayV2::Stage
 */
export declare class CfnStage extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ApiGatewayV2::Stage";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnStage;
    /**
     * `AWS::ApiGatewayV2::Stage.ApiId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-apiid
     * @external
     */
    apiId: string;
    /**
     * `AWS::ApiGatewayV2::Stage.StageName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-stagename
     * @external
     */
    stageName: string;
    /**
     * `AWS::ApiGatewayV2::Stage.AccessLogSettings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-accesslogsettings
     * @external
     */
    accessLogSettings: CfnStage.AccessLogSettingsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::ApiGatewayV2::Stage.AutoDeploy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-autodeploy
     * @external
     */
    autoDeploy: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::ApiGatewayV2::Stage.ClientCertificateId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-clientcertificateid
     * @external
     */
    clientCertificateId: string | undefined;
    /**
     * `AWS::ApiGatewayV2::Stage.DefaultRouteSettings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-defaultroutesettings
     * @external
     */
    defaultRouteSettings: CfnStage.RouteSettingsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::ApiGatewayV2::Stage.DeploymentId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-deploymentid
     * @external
     */
    deploymentId: string | undefined;
    /**
     * `AWS::ApiGatewayV2::Stage.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::ApiGatewayV2::Stage.RouteSettings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-routesettings
     * @external
     */
    routeSettings: any | cdk.IResolvable | undefined;
    /**
     * `AWS::ApiGatewayV2::Stage.StageVariables`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-stagevariables
     * @external
     */
    stageVariables: any | cdk.IResolvable | undefined;
    /**
     * `AWS::ApiGatewayV2::Stage.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::ApiGatewayV2::Stage`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnStageProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ApiGatewayV2::Stage`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html
 * @external
 * @cloudformationResource AWS::ApiGatewayV2::Stage
 */
export declare namespace CfnStage {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-stage-accesslogsettings.html
     * @external
     */
    interface AccessLogSettingsProperty {
        /**
         * `CfnStage.AccessLogSettingsProperty.DestinationArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-stage-accesslogsettings.html#cfn-apigatewayv2-stage-accesslogsettings-destinationarn
         * @external
         */
        readonly destinationArn?: string;
        /**
         * `CfnStage.AccessLogSettingsProperty.Format`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-stage-accesslogsettings.html#cfn-apigatewayv2-stage-accesslogsettings-format
         * @external
         */
        readonly format?: string;
    }
}
/**
 * A CloudFormation `AWS::ApiGatewayV2::Stage`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html
 * @external
 * @cloudformationResource AWS::ApiGatewayV2::Stage
 */
export declare namespace CfnStage {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-stage-routesettings.html
     * @external
     */
    interface RouteSettingsProperty {
        /**
         * `CfnStage.RouteSettingsProperty.DataTraceEnabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-stage-routesettings.html#cfn-apigatewayv2-stage-routesettings-datatraceenabled
         * @external
         */
        readonly dataTraceEnabled?: boolean | cdk.IResolvable;
        /**
         * `CfnStage.RouteSettingsProperty.DetailedMetricsEnabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-stage-routesettings.html#cfn-apigatewayv2-stage-routesettings-detailedmetricsenabled
         * @external
         */
        readonly detailedMetricsEnabled?: boolean | cdk.IResolvable;
        /**
         * `CfnStage.RouteSettingsProperty.LoggingLevel`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-stage-routesettings.html#cfn-apigatewayv2-stage-routesettings-logginglevel
         * @external
         */
        readonly loggingLevel?: string;
        /**
         * `CfnStage.RouteSettingsProperty.ThrottlingBurstLimit`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-stage-routesettings.html#cfn-apigatewayv2-stage-routesettings-throttlingburstlimit
         * @external
         */
        readonly throttlingBurstLimit?: number;
        /**
         * `CfnStage.RouteSettingsProperty.ThrottlingRateLimit`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-stage-routesettings.html#cfn-apigatewayv2-stage-routesettings-throttlingratelimit
         * @external
         */
        readonly throttlingRateLimit?: number;
    }
}
/**
 * Properties for defining a `AWS::ApiGatewayV2::VpcLink`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-vpclink.html
 * @external
 */
export interface CfnVpcLinkProps {
    /**
     * `AWS::ApiGatewayV2::VpcLink.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-vpclink.html#cfn-apigatewayv2-vpclink-name
     * @external
     */
    readonly name: string;
    /**
     * `AWS::ApiGatewayV2::VpcLink.SubnetIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-vpclink.html#cfn-apigatewayv2-vpclink-subnetids
     * @external
     */
    readonly subnetIds: string[];
    /**
     * `AWS::ApiGatewayV2::VpcLink.SecurityGroupIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-vpclink.html#cfn-apigatewayv2-vpclink-securitygroupids
     * @external
     */
    readonly securityGroupIds?: string[];
    /**
     * `AWS::ApiGatewayV2::VpcLink.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-vpclink.html#cfn-apigatewayv2-vpclink-tags
     * @external
     */
    readonly tags?: any;
}
/**
 * A CloudFormation `AWS::ApiGatewayV2::VpcLink`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-vpclink.html
 * @external
 * @cloudformationResource AWS::ApiGatewayV2::VpcLink
 */
export declare class CfnVpcLink extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ApiGatewayV2::VpcLink";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnVpcLink;
    /**
     * `AWS::ApiGatewayV2::VpcLink.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-vpclink.html#cfn-apigatewayv2-vpclink-name
     * @external
     */
    name: string;
    /**
     * `AWS::ApiGatewayV2::VpcLink.SubnetIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-vpclink.html#cfn-apigatewayv2-vpclink-subnetids
     * @external
     */
    subnetIds: string[];
    /**
     * `AWS::ApiGatewayV2::VpcLink.SecurityGroupIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-vpclink.html#cfn-apigatewayv2-vpclink-securitygroupids
     * @external
     */
    securityGroupIds: string[] | undefined;
    /**
     * `AWS::ApiGatewayV2::VpcLink.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-vpclink.html#cfn-apigatewayv2-vpclink-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::ApiGatewayV2::VpcLink`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVpcLinkProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
