import { HttpMethod, IVpcLink, HttpRouteIntegrationBindOptions, HttpRouteIntegrationConfig } from "../../../aws-apigatewayv2";
import * as servicediscovery from "../../../aws-servicediscovery";
import { HttpPrivateIntegration } from './private/integration';
/**
 * (experimental) Properties to initialize `HttpServiceDiscoveryIntegration`.
 *
 * @experimental
 */
export interface HttpServiceDiscoveryIntegrationProps {
    /**
     * (experimental) The discovery service used for the integration.
     *
     * @experimental
     */
    readonly service: servicediscovery.Service;
    /**
     * (experimental) The vpc link to be used for the private integration.
     *
     * @experimental
     */
    readonly vpcLink: IVpcLink;
    /**
     * (experimental) The HTTP method that must be used to invoke the underlying HTTP proxy.
     *
     * @default HttpMethod.ANY
     * @experimental
     */
    readonly method?: HttpMethod;
}
/**
 * (experimental) The Service Discovery integration resource for HTTP API.
 *
 * @experimental
 */
export declare class HttpServiceDiscoveryIntegration extends HttpPrivateIntegration {
    private readonly props;
    /**
     * @experimental
     */
    constructor(props: HttpServiceDiscoveryIntegrationProps);
    /**
     * (experimental) Bind this integration to the route.
     *
     * @experimental
     */
    bind(_: HttpRouteIntegrationBindOptions): HttpRouteIntegrationConfig;
}
