"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpPrivateIntegration = void 0;
const aws_apigatewayv2_1 = require("../../../../aws-apigatewayv2"); // Automatically re-written from '@aws-cdk/aws-apigatewayv2'
/**
 * The HTTP Private integration resource for HTTP API
 *
 * @internal
 */
class HttpPrivateIntegration {
    constructor() {
        /**
         * @experimental
         */
        this.httpMethod = aws_apigatewayv2_1.HttpMethod.ANY;
        /**
         * @experimental
         */
        this.payloadFormatVersion = aws_apigatewayv2_1.PayloadFormatVersion.VERSION_1_0; // 1.0 is required and is the only supported format
        /**
         * @experimental
         */
        this.integrationType = aws_apigatewayv2_1.HttpIntegrationType.HTTP_PROXY;
        /**
         * @experimental
         */
        this.connectionType = aws_apigatewayv2_1.HttpConnectionType.VPC_LINK;
    }
    /**
     * Adds a vpcLink to the API if not passed in the options
     *
     * @internal
     */
    _configureVpcLink(bindOptions, configOptions) {
        let vpcLink = configOptions.vpcLink;
        if (!vpcLink) {
            if (!configOptions.vpc) {
                throw new Error('One of vpcLink or vpc should be provided for private integration');
            }
            vpcLink = bindOptions.route.httpApi.addVpcLink({ vpc: configOptions.vpc });
        }
        return vpcLink;
    }
}
exports.HttpPrivateIntegration = HttpPrivateIntegration;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWdyYXRpb24uanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJpbnRlZ3JhdGlvbi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSxtRUFBd04sQ0FBQyw0REFBNEQ7QUFxQnJSOzs7O0dBSUc7QUFDSCxNQUFzQixzQkFBc0I7SUFBNUM7Ozs7UUFDYyxlQUFVLEdBQUcsNkJBQVUsQ0FBQyxHQUFHLENBQUM7Ozs7UUFDNUIseUJBQW9CLEdBQUcsdUNBQW9CLENBQUMsV0FBVyxDQUFDLENBQUMsbURBQW1EOzs7O1FBQzVHLG9CQUFlLEdBQUcsc0NBQW1CLENBQUMsVUFBVSxDQUFDOzs7O1FBQ2pELG1CQUFjLEdBQUcscUNBQWtCLENBQUMsUUFBUSxDQUFDO0lBaUIzRCxDQUFDO0lBaEJHOzs7O09BSUc7SUFDTyxpQkFBaUIsQ0FBQyxXQUE0QyxFQUFFLGFBQTBDO1FBQ2hILElBQUksT0FBTyxHQUFHLGFBQWEsQ0FBQyxPQUFPLENBQUM7UUFDcEMsSUFBSSxDQUFDLE9BQU8sRUFBRTtZQUNWLElBQUksQ0FBQyxhQUFhLENBQUMsR0FBRyxFQUFFO2dCQUNwQixNQUFNLElBQUksS0FBSyxDQUFDLGtFQUFrRSxDQUFDLENBQUM7YUFDdkY7WUFDRCxPQUFPLEdBQUcsV0FBVyxDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsVUFBVSxDQUFDLEVBQUUsR0FBRyxFQUFFLGFBQWEsQ0FBQyxHQUFHLEVBQUUsQ0FBQyxDQUFDO1NBQzlFO1FBQ0QsT0FBTyxPQUFPLENBQUM7SUFDbkIsQ0FBQztDQUVKO0FBckJELHdEQXFCQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEh0dHBDb25uZWN0aW9uVHlwZSwgSHR0cEludGVncmF0aW9uVHlwZSwgSHR0cFJvdXRlSW50ZWdyYXRpb25CaW5kT3B0aW9ucywgSHR0cFJvdXRlSW50ZWdyYXRpb25Db25maWcsIElIdHRwUm91dGVJbnRlZ3JhdGlvbiwgUGF5bG9hZEZvcm1hdFZlcnNpb24sIEh0dHBNZXRob2QsIElWcGNMaW5rLCB9IGZyb20gXCIuLi8uLi8uLi8uLi9hd3MtYXBpZ2F0ZXdheXYyXCI7IC8vIEF1dG9tYXRpY2FsbHkgcmUtd3JpdHRlbiBmcm9tICdAYXdzLWNkay9hd3MtYXBpZ2F0ZXdheXYyJ1xuaW1wb3J0ICogYXMgZWMyIGZyb20gXCIuLi8uLi8uLi8uLi9hd3MtZWMyXCI7IC8vIEF1dG9tYXRpY2FsbHkgcmUtd3JpdHRlbiBmcm9tICdAYXdzLWNkay9hd3MtZWMyJ1xuLyoqXG4gKiBPcHRpb25zIHJlcXVpcmVkIHRvIHVzZSBhbiBleGlzdGluZyB2cGNMaW5rIG9yIGNvbmZpZ3VyZSBhIG5ldyBvbmVcbiAqXG4gKiBAaW50ZXJuYWxcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBWcGNMaW5rQ29uZmlndXJhdGlvbk9wdGlvbnMge1xuICAgIC8qKlxuICAgICAqIFRoZSB2cGMgbGluayB0byBiZSB1c2VkIGZvciB0aGUgcHJpdmF0ZSBpbnRlZ3JhdGlvblxuICAgICAqXG4gICAgICogQGRlZmF1bHQgLSBhIG5ldyBWcGNMaW5rIGlzIGNyZWF0ZWRcbiAgICAgKi9cbiAgICByZWFkb25seSB2cGNMaW5rPzogSVZwY0xpbms7XG4gICAgLyoqXG4gICAgICogVGhlIHZwYyBmb3Igd2hpY2ggdGhlIFZwY0xpbmsgbmVlZHMgdG8gYmUgY3JlYXRlZFxuICAgICAqXG4gICAgICogQGRlZmF1bHQgdW5kZWZpbmVkXG4gICAgICovXG4gICAgcmVhZG9ubHkgdnBjPzogZWMyLklWcGM7XG59XG4vKipcbiAqIFRoZSBIVFRQIFByaXZhdGUgaW50ZWdyYXRpb24gcmVzb3VyY2UgZm9yIEhUVFAgQVBJXG4gKlxuICogQGludGVybmFsXG4gKi9cbmV4cG9ydCBhYnN0cmFjdCBjbGFzcyBIdHRwUHJpdmF0ZUludGVncmF0aW9uIGltcGxlbWVudHMgSUh0dHBSb3V0ZUludGVncmF0aW9uIHtcbiAgICBwcm90ZWN0ZWQgaHR0cE1ldGhvZCA9IEh0dHBNZXRob2QuQU5ZO1xuICAgIHByb3RlY3RlZCBwYXlsb2FkRm9ybWF0VmVyc2lvbiA9IFBheWxvYWRGb3JtYXRWZXJzaW9uLlZFUlNJT05fMV8wOyAvLyAxLjAgaXMgcmVxdWlyZWQgYW5kIGlzIHRoZSBvbmx5IHN1cHBvcnRlZCBmb3JtYXRcbiAgICBwcm90ZWN0ZWQgaW50ZWdyYXRpb25UeXBlID0gSHR0cEludGVncmF0aW9uVHlwZS5IVFRQX1BST1hZO1xuICAgIHByb3RlY3RlZCBjb25uZWN0aW9uVHlwZSA9IEh0dHBDb25uZWN0aW9uVHlwZS5WUENfTElOSztcbiAgICAvKipcbiAgICAgKiBBZGRzIGEgdnBjTGluayB0byB0aGUgQVBJIGlmIG5vdCBwYXNzZWQgaW4gdGhlIG9wdGlvbnNcbiAgICAgKlxuICAgICAqIEBpbnRlcm5hbFxuICAgICAqL1xuICAgIHByb3RlY3RlZCBfY29uZmlndXJlVnBjTGluayhiaW5kT3B0aW9uczogSHR0cFJvdXRlSW50ZWdyYXRpb25CaW5kT3B0aW9ucywgY29uZmlnT3B0aW9uczogVnBjTGlua0NvbmZpZ3VyYXRpb25PcHRpb25zKTogSVZwY0xpbmsge1xuICAgICAgICBsZXQgdnBjTGluayA9IGNvbmZpZ09wdGlvbnMudnBjTGluaztcbiAgICAgICAgaWYgKCF2cGNMaW5rKSB7XG4gICAgICAgICAgICBpZiAoIWNvbmZpZ09wdGlvbnMudnBjKSB7XG4gICAgICAgICAgICAgICAgdGhyb3cgbmV3IEVycm9yKCdPbmUgb2YgdnBjTGluayBvciB2cGMgc2hvdWxkIGJlIHByb3ZpZGVkIGZvciBwcml2YXRlIGludGVncmF0aW9uJyk7XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICB2cGNMaW5rID0gYmluZE9wdGlvbnMucm91dGUuaHR0cEFwaS5hZGRWcGNMaW5rKHsgdnBjOiBjb25maWdPcHRpb25zLnZwYyB9KTtcbiAgICAgICAgfVxuICAgICAgICByZXR1cm4gdnBjTGluaztcbiAgICB9XG4gICAgcHVibGljIGFic3RyYWN0IGJpbmQob3B0aW9uczogSHR0cFJvdXRlSW50ZWdyYXRpb25CaW5kT3B0aW9ucyk6IEh0dHBSb3V0ZUludGVncmF0aW9uQ29uZmlnO1xufVxuIl19