"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpNlbIntegration = void 0;
const integration_1 = require("./private/integration");
/**
 * (experimental) The Network Load Balancer integration resource for HTTP API.
 *
 * @experimental
 */
class HttpNlbIntegration extends integration_1.HttpPrivateIntegration {
    /**
     * @experimental
     */
    constructor(props) {
        super();
        this.props = props;
    }
    /**
     * (experimental) Bind this integration to the route.
     *
     * @experimental
     */
    bind(options) {
        var _a;
        const vpcLink = this._configureVpcLink(options, {
            vpcLink: this.props.vpcLink,
            vpc: this.props.listener.loadBalancer.vpc,
        });
        return {
            method: (_a = this.props.method) !== null && _a !== void 0 ? _a : this.httpMethod,
            payloadFormatVersion: this.payloadFormatVersion,
            type: this.integrationType,
            connectionType: this.connectionType,
            connectionId: vpcLink.vpcLinkId,
            uri: this.props.listener.listenerArn,
        };
    }
}
exports.HttpNlbIntegration = HttpNlbIntegration;
//# sourceMappingURL=data:application/json;base64,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