"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpAlbIntegration = void 0;
const integration_1 = require("./private/integration");
/**
 * (experimental) The Application Load Balancer integration resource for HTTP API.
 *
 * @experimental
 */
class HttpAlbIntegration extends integration_1.HttpPrivateIntegration {
    /**
     * @experimental
     */
    constructor(props) {
        super();
        this.props = props;
    }
    /**
     * (experimental) Bind this integration to the route.
     *
     * @experimental
     */
    bind(options) {
        var _a;
        const vpcLink = this._configureVpcLink(options, {
            vpcLink: this.props.vpcLink,
            vpc: this.props.listener.loadBalancer.vpc,
        });
        return {
            method: (_a = this.props.method) !== null && _a !== void 0 ? _a : this.httpMethod,
            payloadFormatVersion: this.payloadFormatVersion,
            type: this.integrationType,
            connectionType: this.connectionType,
            connectionId: vpcLink.vpcLinkId,
            uri: this.props.listener.listenerArn,
        };
    }
}
exports.HttpAlbIntegration = HttpAlbIntegration;
//# sourceMappingURL=data:application/json;base64,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