/**
 * @experimental
 */
export declare enum JsonSchemaVersion {
    /**
     * (experimental) In API Gateway models are defined using the JSON schema draft 4.
     *
     * @see https://tools.ietf.org/html/draft-zyp-json-schema-04
     * @experimental
     */
    DRAFT4 = "http://json-schema.org/draft-04/schema#",
    /**
     * @experimental
     */
    DRAFT7 = "http://json-schema.org/draft-07/schema#"
}
/**
 * @experimental
 */
export declare enum JsonSchemaType {
    /**
     * @experimental
     */
    NULL = "null",
    /**
     * @experimental
     */
    BOOLEAN = "boolean",
    /**
     * @experimental
     */
    OBJECT = "object",
    /**
     * @experimental
     */
    ARRAY = "array",
    /**
     * @experimental
     */
    NUMBER = "number",
    /**
     * @experimental
     */
    INTEGER = "integer",
    /**
     * @experimental
     */
    STRING = "string"
}
/**
 * (experimental) Represents a JSON schema definition of the structure of a REST API model.
 *
 * Copied from npm module jsonschema.
 *
 * @see https://github.com/tdegrunt/jsonschema
 * @experimental
 */
export interface JsonSchema {
    /**
     * @experimental
     */
    readonly schema?: JsonSchemaVersion;
    /**
     * @experimental
     */
    readonly id?: string;
    /**
     * @experimental
     */
    readonly ref?: string;
    /**
     * @experimental
     */
    readonly type?: JsonSchemaType | JsonSchemaType[];
    /**
     * @experimental
     */
    readonly title?: string;
    /**
     * @experimental
     */
    readonly description?: string;
    /**
     * @experimental
     */
    readonly 'enum'?: any[];
    /**
     * @experimental
     */
    readonly format?: string;
    /**
     * @experimental
     */
    readonly definitions?: {
        [name: string]: JsonSchema;
    };
    /**
     * @experimental
     */
    readonly multipleOf?: number;
    /**
     * @experimental
     */
    readonly maximum?: number;
    /**
     * @experimental
     */
    readonly exclusiveMaximum?: boolean;
    /**
     * @experimental
     */
    readonly minimum?: number;
    /**
     * @experimental
     */
    readonly exclusiveMinimum?: boolean;
    /**
     * @experimental
     */
    readonly maxLength?: number;
    /**
     * @experimental
     */
    readonly minLength?: number;
    /**
     * @experimental
     */
    readonly pattern?: string;
    /**
     * @experimental
     */
    readonly items?: JsonSchema | JsonSchema[];
    /**
     * @experimental
     */
    readonly additionalItems?: JsonSchema[];
    /**
     * @experimental
     */
    readonly maxItems?: number;
    /**
     * @experimental
     */
    readonly minItems?: number;
    /**
     * @experimental
     */
    readonly uniqueItems?: boolean;
    /**
     * @experimental
     */
    readonly contains?: JsonSchema | JsonSchema[];
    /**
     * @experimental
     */
    readonly maxProperties?: number;
    /**
     * @experimental
     */
    readonly minProperties?: number;
    /**
     * @experimental
     */
    readonly required?: string[];
    /**
     * @experimental
     */
    readonly properties?: {
        [name: string]: JsonSchema;
    };
    /**
     * @experimental
     */
    readonly additionalProperties?: JsonSchema | boolean;
    /**
     * @experimental
     */
    readonly patternProperties?: {
        [name: string]: JsonSchema;
    };
    /**
     * @experimental
     */
    readonly dependencies?: {
        [name: string]: JsonSchema | string[];
    };
    /**
     * @experimental
     */
    readonly propertyNames?: JsonSchema;
    /**
     * @experimental
     */
    readonly allOf?: JsonSchema[];
    /**
     * @experimental
     */
    readonly anyOf?: JsonSchema[];
    /**
     * @experimental
     */
    readonly oneOf?: JsonSchema[];
    /**
     * @experimental
     */
    readonly not?: JsonSchema;
}
