"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ResponseType = exports.GatewayResponse = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const apigateway_generated_1 = require("./apigateway.generated");
/**
 * (experimental) Configure the response received by clients, produced from the API Gateway backend.
 *
 * @experimental
 * @resource AWS::ApiGateway::GatewayResponse
 */
class GatewayResponse extends core_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id);
        const gatewayResponseProps = {
            restApiId: props.restApi.restApiId,
            responseType: props.type.responseType,
            responseParameters: this.buildResponseParameters(props.responseHeaders),
            responseTemplates: props.templates,
            statusCode: props.statusCode,
        };
        const resource = new apigateway_generated_1.CfnGatewayResponse(this, 'Resource', gatewayResponseProps);
        const deployment = props.restApi.latestDeployment;
        if (deployment) {
            deployment.node.addDependency(resource);
            deployment.addToLogicalId({
                gatewayResponse: {
                    ...gatewayResponseProps,
                },
            });
        }
        this.node.defaultChild = resource;
    }
    buildResponseParameters(responseHeaders) {
        if (!responseHeaders) {
            return undefined;
        }
        const responseParameters = {};
        for (const [header, value] of Object.entries(responseHeaders)) {
            responseParameters[`gatewayresponse.header.${header}`] = value;
        }
        return responseParameters;
    }
}
exports.GatewayResponse = GatewayResponse;
/**
 * (experimental) Supported types of gateway responses.
 *
 * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/supported-gateway-response-types.html
 * @experimental
 */
class ResponseType {
    constructor(type) {
        this.responseType = type;
    }
    /**
     * (experimental) A custom response type to suppport future cases.
     *
     * @experimental
     */
    static of(type) {
        return new ResponseType(type.toUpperCase());
    }
}
exports.ResponseType = ResponseType;
/**
 * (experimental) The gateway response for authorization failure.
 *
 * @experimental
 */
ResponseType.ACCESS_DENIED = new ResponseType('ACCESS_DENIED');
/**
 * (experimental) The gateway response for an invalid API configuration.
 *
 * @experimental
 */
ResponseType.API_CONFIGURATION_ERROR = new ResponseType('API_CONFIGURATION_ERROR');
/**
 * (experimental) The gateway response when a custom or Amazon Cognito authorizer failed to authenticate the caller.
 *
 * @experimental
 */
ResponseType.AUTHORIZER_FAILURE = new ResponseType('AUTHORIZER_FAILURE');
/**
 * (experimental) The gateway response for failing to connect to a custom or Amazon Cognito authorizer.
 *
 * @experimental
 */
ResponseType.AUTHORIZER_CONFIGURATION_ERROR = new ResponseType('AUTHORIZER_CONFIGURATION_ERROR');
/**
 * (experimental) The gateway response when the request parameter cannot be validated according to an enabled request validator.
 *
 * @experimental
 */
ResponseType.BAD_REQUEST_PARAMETERS = new ResponseType('BAD_REQUEST_PARAMETERS');
/**
 * (experimental) The gateway response when the request body cannot be validated according to an enabled request validator.
 *
 * @experimental
 */
ResponseType.BAD_REQUEST_BODY = new ResponseType('BAD_REQUEST_BODY');
/**
 * (experimental) The default gateway response for an unspecified response type with the status code of 4XX.
 *
 * @experimental
 */
ResponseType.DEFAULT_4XX = new ResponseType('DEFAULT_4XX');
/**
 * (experimental) The default gateway response for an unspecified response type with a status code of 5XX.
 *
 * @experimental
 */
ResponseType.DEFAULT_5XX = new ResponseType('DEFAULT_5XX');
/**
 * (experimental) The gateway response for an AWS authentication token expired error.
 *
 * @experimental
 */
ResponseType.EXPIRED_TOKEN = new ResponseType('EXPIRED_TOKEN');
/**
 * (experimental) The gateway response for an invalid AWS signature error.
 *
 * @experimental
 */
ResponseType.INVALID_SIGNATURE = new ResponseType('INVALID_SIGNATURE');
/**
 * (experimental) The gateway response for an integration failed error.
 *
 * @experimental
 */
ResponseType.INTEGRATION_FAILURE = new ResponseType('INTEGRATION_FAILURE');
/**
 * (experimental) The gateway response for an integration timed out error.
 *
 * @experimental
 */
ResponseType.INTEGRATION_TIMEOUT = new ResponseType('INTEGRATION_TIMEOUT');
/**
 * (experimental) The gateway response for an invalid API key submitted for a method requiring an API key.
 *
 * @experimental
 */
ResponseType.INVALID_API_KEY = new ResponseType('INVALID_API_KEY');
/**
 * (experimental) The gateway response for a missing authentication token error, including the cases when the client attempts to invoke an unsupported API method or resource.
 *
 * @experimental
 */
ResponseType.MISSING_AUTHENTICATION_TOKEN = new ResponseType('MISSING_AUTHENTICATION_TOKEN');
/**
 * (experimental) The gateway response for the usage plan quota exceeded error.
 *
 * @experimental
 */
ResponseType.QUOTA_EXCEEDED = new ResponseType('QUOTA_EXCEEDED');
/**
 * (experimental) The gateway response for the request too large error.
 *
 * @experimental
 */
ResponseType.REQUEST_TOO_LARGE = new ResponseType('REQUEST_TOO_LARGE');
/**
 * (experimental) The gateway response when API Gateway cannot find the specified resource after an API request passes authentication and authorization.
 *
 * @experimental
 */
ResponseType.RESOURCE_NOT_FOUND = new ResponseType('RESOURCE_NOT_FOUND');
/**
 * (experimental) The gateway response when usage plan, method, stage, or account level throttling limits exceeded.
 *
 * @experimental
 */
ResponseType.THROTTLED = new ResponseType('THROTTLED');
/**
 * (experimental) The gateway response when the custom or Amazon Cognito authorizer failed to authenticate the caller.
 *
 * @experimental
 */
ResponseType.UNAUTHORIZED = new ResponseType('UNAUTHORIZED');
/**
 * (experimental) The gateway response when a payload is of an unsupported media type, if strict passthrough behavior is enabled.
 *
 * @experimental
 */
ResponseType.UNSUPPORTED_MEDIA_TYPE = new ResponseType('UNSUPPORTED_MEDIA_TYPE');
/**
 * (experimental) The gateway response when a request is blocked by AWS WAF.
 *
 * @experimental
 */
ResponseType.WAF_FILTERED = new ResponseType('WAF_FILTERED');
//# sourceMappingURL=data:application/json;base64,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