import * as acm from "../../aws-certificatemanager";
import { IBucket } from "../../aws-s3";
import { IResource, Resource } from "../../core";
import { Construct } from 'constructs';
import { BasePathMapping, BasePathMappingOptions } from './base-path-mapping';
import { EndpointType, IRestApi } from './restapi';
/**
 * (experimental) The minimum version of the SSL protocol that you want API Gateway to use for HTTPS connections.
 *
 * @experimental
 */
export declare enum SecurityPolicy {
    /**
     * (experimental) Cipher suite TLS 1.0.
     *
     * @experimental
     */
    TLS_1_0 = "TLS_1_0",
    /**
     * (experimental) Cipher suite TLS 1.2.
     *
     * @experimental
     */
    TLS_1_2 = "TLS_1_2"
}
/**
 * @experimental
 */
export interface DomainNameOptions {
    /**
     * (experimental) The custom domain name for your API.
     *
     * Uppercase letters are not supported.
     *
     * @experimental
     */
    readonly domainName: string;
    /**
     * (experimental) The reference to an AWS-managed certificate for use by the edge-optimized endpoint for the domain name.
     *
     * For "EDGE" domain names, the certificate
     * needs to be in the US East (N. Virginia) region.
     *
     * @experimental
     */
    readonly certificate: acm.ICertificate;
    /**
     * (experimental) The type of endpoint for this DomainName.
     *
     * @default REGIONAL
     * @experimental
     */
    readonly endpointType?: EndpointType;
    /**
     * (experimental) The Transport Layer Security (TLS) version + cipher suite for this domain name.
     *
     * @default SecurityPolicy.TLS_1_0
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainname.html
     * @experimental
     */
    readonly securityPolicy?: SecurityPolicy;
    /**
     * (experimental) The mutual TLS authentication configuration for a custom domain name.
     *
     * @default - mTLS is not configured.
     * @experimental
     */
    readonly mtls?: MTLSConfig;
}
/**
 * @experimental
 */
export interface DomainNameProps extends DomainNameOptions {
    /**
     * (experimental) If specified, all requests to this domain will be mapped to the production deployment of this API.
     *
     * If you wish to map this domain to multiple APIs
     * with different base paths, don't specify this option and use
     * `addBasePathMapping`.
     *
     * @default - you will have to call `addBasePathMapping` to map this domain to
     * API endpoints.
     * @experimental
     */
    readonly mapping?: IRestApi;
}
/**
 * @experimental
 */
export interface IDomainName extends IResource {
    /**
     * (experimental) The domain name (e.g. `example.com`).
     *
     * @experimental
     * @attribute DomainName
     */
    readonly domainName: string;
    /**
     * (experimental) The Route53 alias target to use in order to connect a record set to this domain through an alias.
     *
     * @experimental
     * @attribute DistributionDomainName,RegionalDomainName
     */
    readonly domainNameAliasDomainName: string;
    /**
     * (experimental) The Route53 hosted zone ID to use in order to connect a record set to this domain through an alias.
     *
     * @experimental
     * @attribute DistributionHostedZoneId,RegionalHostedZoneId
     */
    readonly domainNameAliasHostedZoneId: string;
}
/**
 * @experimental
 */
export declare class DomainName extends Resource implements IDomainName {
    /**
     * (experimental) Imports an existing domain name.
     *
     * @experimental
     */
    static fromDomainNameAttributes(scope: Construct, id: string, attrs: DomainNameAttributes): IDomainName;
    /**
     * (experimental) The domain name (e.g. `example.com`).
     *
     * @experimental
     */
    readonly domainName: string;
    /**
     * (experimental) The Route53 alias target to use in order to connect a record set to this domain through an alias.
     *
     * @experimental
     */
    readonly domainNameAliasDomainName: string;
    /**
     * (experimental) The Route53 hosted zone ID to use in order to connect a record set to this domain through an alias.
     *
     * @experimental
     */
    readonly domainNameAliasHostedZoneId: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: DomainNameProps);
    /**
     * (experimental) Maps this domain to an API endpoint.
     *
     * @param targetApi That target API endpoint, requests will be mapped to the deployment stage.
     * @param options Options for mapping to base path with or without a stage.
     * @experimental
     */
    addBasePathMapping(targetApi: IRestApi, options?: BasePathMappingOptions): BasePathMapping;
    private configureMTLS;
}
/**
 * @experimental
 */
export interface DomainNameAttributes {
    /**
     * (experimental) The domain name (e.g. `example.com`).
     *
     * @experimental
     */
    readonly domainName: string;
    /**
     * (experimental) The Route53 alias target to use in order to connect a record set to this domain through an alias.
     *
     * @experimental
     */
    readonly domainNameAliasTarget: string;
    /**
     * (experimental) Thje Route53 hosted zone ID to use in order to connect a record set to this domain through an alias.
     *
     * @experimental
     */
    readonly domainNameAliasHostedZoneId: string;
}
/**
 * (experimental) The mTLS authentication configuration for a custom domain name.
 *
 * @experimental
 */
export interface MTLSConfig {
    /**
     * (experimental) The bucket that the trust store is hosted in.
     *
     * @experimental
     */
    readonly bucket: IBucket;
    /**
     * (experimental) The key in S3 to look at for the trust store.
     *
     * @experimental
     */
    readonly key: string;
    /**
     * (experimental) The version of the S3 object that contains your truststore.
     *
     * To specify a version, you must have versioning enabled for the S3 bucket.
     *
     * @default - latest version
     * @experimental
     */
    readonly version?: string;
}
