"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IdentitySource = void 0;
/**
 * (experimental) Represents an identity source.
 *
 * The source can be specified either as a literal value (e.g: `Auth`) which
 * cannot be blank, or as an unresolved string token.
 *
 * @experimental
 */
class IdentitySource {
    /**
     * (experimental) Provides a properly formatted header identity source.
     *
     * @param headerName the name of the header the `IdentitySource` will represent.
     * @returns a header identity source.
     * @experimental
     */
    static header(headerName) {
        return IdentitySource.toString(headerName, 'method.request.header');
    }
    /**
     * (experimental) Provides a properly formatted query string identity source.
     *
     * @param queryString the name of the query string the `IdentitySource` will represent.
     * @returns a query string identity source.
     * @experimental
     */
    static queryString(queryString) {
        return IdentitySource.toString(queryString, 'method.request.querystring');
    }
    /**
     * (experimental) Provides a properly formatted API Gateway stage variable identity source.
     *
     * @param stageVariable the name of the stage variable the `IdentitySource` will represent.
     * @returns an API Gateway stage variable identity source.
     * @experimental
     */
    static stageVariable(stageVariable) {
        return IdentitySource.toString(stageVariable, 'stageVariables');
    }
    /**
     * (experimental) Provides a properly formatted request context identity source.
     *
     * @param context the name of the context variable the `IdentitySource` will represent.
     * @returns a request context identity source.
     * @experimental
     */
    static context(context) {
        return IdentitySource.toString(context, 'context');
    }
    static toString(source, type) {
        if (!source.trim()) {
            throw new Error('IdentitySources must be a non-empty string.');
        }
        return `${type}.${source}`;
    }
}
exports.IdentitySource = IdentitySource;
//# sourceMappingURL=data:application/json;base64,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