"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CustomRule = exports.RedirectStatus = exports.App = void 0;
const iam = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const amplify_generated_1 = require("./amplify.generated");
const branch_1 = require("./branch");
const domain_1 = require("./domain");
const utils_1 = require("./utils");
/**
 * (experimental) An Amplify Console application.
 *
 * @experimental
 */
class App extends core_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _a, _b, _c;
        super(scope, id);
        this.customRules = props.customRules || [];
        this.environmentVariables = props.environmentVariables || {};
        this.autoBranchEnvironmentVariables = props.autoBranchCreation && props.autoBranchCreation.environmentVariables || {};
        const role = props.role || new iam.Role(this, 'Role', {
            assumedBy: new iam.ServicePrincipal('amplify.amazonaws.com'),
        });
        this.grantPrincipal = role;
        const sourceCodeProviderOptions = (_a = props.sourceCodeProvider) === null || _a === void 0 ? void 0 : _a.bind(this);
        const app = new amplify_generated_1.CfnApp(this, 'Resource', {
            accessToken: (_b = sourceCodeProviderOptions === null || sourceCodeProviderOptions === void 0 ? void 0 : sourceCodeProviderOptions.accessToken) === null || _b === void 0 ? void 0 : _b.toString(),
            autoBranchCreationConfig: props.autoBranchCreation && {
                autoBranchCreationPatterns: props.autoBranchCreation.patterns,
                basicAuthConfig: props.autoBranchCreation.basicAuth && props.autoBranchCreation.basicAuth.bind(this, 'BranchBasicAuth'),
                buildSpec: props.autoBranchCreation.buildSpec && props.autoBranchCreation.buildSpec.toBuildSpec(),
                enableAutoBranchCreation: true,
                enableAutoBuild: props.autoBranchCreation.autoBuild === undefined ? true : props.autoBranchCreation.autoBuild,
                environmentVariables: core_1.Lazy.anyValue({ produce: () => utils_1.renderEnvironmentVariables(this.autoBranchEnvironmentVariables) }, { omitEmptyArray: true }),
                enablePullRequestPreview: props.autoBranchCreation.pullRequestPreview === undefined ? true : props.autoBranchCreation.pullRequestPreview,
                pullRequestEnvironmentName: props.autoBranchCreation.pullRequestEnvironmentName,
                stage: props.autoBranchCreation.stage,
            },
            enableBranchAutoDeletion: props.autoBranchDeletion,
            basicAuthConfig: props.basicAuth && props.basicAuth.bind(this, 'AppBasicAuth'),
            buildSpec: props.buildSpec && props.buildSpec.toBuildSpec(),
            customRules: core_1.Lazy.anyValue({ produce: () => this.customRules }, { omitEmptyArray: true }),
            description: props.description,
            environmentVariables: core_1.Lazy.anyValue({ produce: () => utils_1.renderEnvironmentVariables(this.environmentVariables) }, { omitEmptyArray: true }),
            iamServiceRole: role.roleArn,
            name: props.appName || this.node.id,
            oauthToken: (_c = sourceCodeProviderOptions === null || sourceCodeProviderOptions === void 0 ? void 0 : sourceCodeProviderOptions.oauthToken) === null || _c === void 0 ? void 0 : _c.toString(),
            repository: sourceCodeProviderOptions === null || sourceCodeProviderOptions === void 0 ? void 0 : sourceCodeProviderOptions.repository,
        });
        this.appId = app.attrAppId;
        this.appName = app.attrAppName;
        this.arn = app.attrArn;
        this.defaultDomain = app.attrDefaultDomain;
    }
    /**
     * (experimental) Import an existing application.
     *
     * @experimental
     */
    static fromAppId(scope, id, appId) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.appId = appId;
            }
        }
        return new Import(scope, id);
    }
    /**
     * (experimental) Adds a custom rewrite/redirect rule to this application.
     *
     * @experimental
     */
    addCustomRule(rule) {
        this.customRules.push(rule);
        return this;
    }
    /**
     * (experimental) Adds an environment variable to this application.
     *
     * All environment variables that you add are encrypted to prevent rogue
     * access so you can use them to store secret information.
     *
     * @experimental
     */
    addEnvironment(name, value) {
        this.environmentVariables[name] = value;
        return this;
    }
    /**
     * (experimental) Adds an environment variable to the auto created branch.
     *
     * All environment variables that you add are encrypted to prevent rogue
     * access so you can use them to store secret information.
     *
     * @experimental
     */
    addAutoBranchEnvironment(name, value) {
        this.autoBranchEnvironmentVariables[name] = value;
        return this;
    }
    /**
     * (experimental) Adds a branch to this application.
     *
     * @experimental
     */
    addBranch(id, options = {}) {
        return new branch_1.Branch(this, id, {
            ...options,
            app: this,
        });
    }
    /**
     * (experimental) Adds a domain to this application.
     *
     * @experimental
     */
    addDomain(id, options = {}) {
        return new domain_1.Domain(this, id, {
            ...options,
            app: this,
        });
    }
}
exports.App = App;
/**
 * (experimental) The status code for a URL rewrite or redirect rule.
 *
 * @experimental
 */
var RedirectStatus;
(function (RedirectStatus) {
    RedirectStatus["REWRITE"] = "200";
    RedirectStatus["PERMANENT_REDIRECT"] = "301";
    RedirectStatus["TEMPORARY_REDIRECT"] = "302";
    RedirectStatus["NOT_FOUND"] = "404";
    RedirectStatus["NOT_FOUND_REWRITE"] = "404-200";
})(RedirectStatus = exports.RedirectStatus || (exports.RedirectStatus = {}));
/**
 * (experimental) Custom rewrite/redirect rule for an Amplify App.
 *
 * @see https://docs.aws.amazon.com/amplify/latest/userguide/redirects.html
 * @experimental
 */
class CustomRule {
    /**
     * @experimental
     */
    constructor(options) {
        this.source = options.source;
        this.target = options.target;
        this.status = options.status;
        this.condition = options.condition;
    }
}
exports.CustomRule = CustomRule;
/**
 * (experimental) Sets up a 200 rewrite for all paths to `index.html` except for path containing a file extension.
 *
 * @experimental
 */
CustomRule.SINGLE_PAGE_APPLICATION_REDIRECT = new CustomRule({
    source: '</^[^.]+$/>',
    target: '/index.html',
    status: RedirectStatus.REWRITE,
});
//# sourceMappingURL=data:application/json;base64,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