import abc
import builtins
import datetime
import enum
import typing

import jsii
import publication
import typing_extensions

from .._jsii import *

import constructs
from .. import (
    AssetHashType as _AssetHashType_49193809,
    BundlingOptions as _BundlingOptions_ab115a99,
    CfnResource as _CfnResource_e0a482dc,
    CfnTag as _CfnTag_95fbdc29,
    Construct as _Construct_e78e779f,
    Duration as _Duration_070aa057,
    IInspectable as _IInspectable_82c04a63,
    IResolvable as _IResolvable_a771d0ef,
    IResource as _IResource_8c1dbbbd,
    Resource as _Resource_abff4495,
    ResourceProps as _ResourceProps_9b554c0f,
    TagManager as _TagManager_0b7ab120,
    TreeInspector as _TreeInspector_1cd1894e,
)
from ..assets import FollowMode as _FollowMode_98b05cc5
from ..aws_certificatemanager import ICertificate as _ICertificate_c7bbdc16
from ..aws_cloudwatch import (
    Metric as _Metric_5b2b8e58,
    MetricOptions as _MetricOptions_1c185ae8,
    Unit as _Unit_113c79f9,
)
from ..aws_ec2 import IVpcEndpoint as _IVpcEndpoint_8b8ad2f1
from ..aws_elasticloadbalancingv2 import (
    INetworkLoadBalancer as _INetworkLoadBalancer_ead0b7fa
)
from ..aws_iam import (
    Grant as _Grant_bcb5eae7,
    IGrantable as _IGrantable_4c5a91d1,
    IRole as _IRole_59af6f50,
    PolicyDocument as _PolicyDocument_b5de5177,
)
from ..aws_lambda import IFunction as _IFunction_6e14f09e
from ..aws_logs import ILogGroup as _ILogGroup_846e17a0
from ..aws_s3 import IBucket as _IBucket_73486e29
from ..aws_s3_assets import AssetOptions as _AssetOptions_bd2996da


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.AccessLogDestinationConfig",
    jsii_struct_bases=[],
    name_mapping={"destination_arn": "destinationArn"},
)
class AccessLogDestinationConfig:
    def __init__(self, *, destination_arn: builtins.str) -> None:
        """(experimental) Options when binding a log destination to a RestApi Stage.

        :param destination_arn: (experimental) The Amazon Resource Name (ARN) of the destination resource.

        :stability: experimental
        """
        self._values: typing.Dict[str, typing.Any] = {
            "destination_arn": destination_arn,
        }

    @builtins.property
    def destination_arn(self) -> builtins.str:
        """(experimental) The Amazon Resource Name (ARN) of the destination resource.

        :stability: experimental
        """
        result = self._values.get("destination_arn")
        assert result is not None, "Required property 'destination_arn' is missing"
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AccessLogDestinationConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class AccessLogField(
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_apigateway.AccessLogField",
):
    """(experimental) $context variables that can be used to customize access log pattern.

    :stability: experimental
    """

    def __init__(self) -> None:
        """
        :stability: experimental
        """
        jsii.create(AccessLogField, self, [])

    @jsii.member(jsii_name="contextAccountId")
    @builtins.classmethod
    def context_account_id(cls) -> builtins.str:
        """(experimental) The API owner's AWS account ID.

        :stability: experimental
        """
        return jsii.sinvoke(cls, "contextAccountId", [])

    @jsii.member(jsii_name="contextApiId")
    @builtins.classmethod
    def context_api_id(cls) -> builtins.str:
        """(experimental) The identifier API Gateway assigns to your API.

        :stability: experimental
        """
        return jsii.sinvoke(cls, "contextApiId", [])

    @jsii.member(jsii_name="contextAuthorizer")
    @builtins.classmethod
    def context_authorizer(cls, property: builtins.str) -> builtins.str:
        """(experimental) The stringified value of the specified key-value pair of the ``context`` map returned from an API Gateway Lambda authorizer function.

        :param property: key of the context map.

        :see: https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-use-lambda-authorizer.html
        :stability: experimental
        """
        return jsii.sinvoke(cls, "contextAuthorizer", [property])

    @jsii.member(jsii_name="contextAuthorizerClaims")
    @builtins.classmethod
    def context_authorizer_claims(cls, property: builtins.str) -> builtins.str:
        """(experimental) A property of the claims returned from the Amazon Cognito user pool after the method caller is successfully authenticated.

        :param property: A property key of the claims.

        :see: https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-integrate-with-cognito.html
        :stability: experimental
        """
        return jsii.sinvoke(cls, "contextAuthorizerClaims", [property])

    @jsii.member(jsii_name="contextAuthorizerIntegrationLatency")
    @builtins.classmethod
    def context_authorizer_integration_latency(cls) -> builtins.str:
        """(experimental) The authorizer latency in ms.

        :stability: experimental
        """
        return jsii.sinvoke(cls, "contextAuthorizerIntegrationLatency", [])

    @jsii.member(jsii_name="contextAuthorizerPrincipalId")
    @builtins.classmethod
    def context_authorizer_principal_id(cls) -> builtins.str:
        """(experimental) The principal user identification associated with the token sent by the client and returned from an API Gateway Lambda authorizer (formerly known as a custom authorizer).

        :see: https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-use-lambda-authorizer.html
        :stability: experimental
        """
        return jsii.sinvoke(cls, "contextAuthorizerPrincipalId", [])

    @jsii.member(jsii_name="contextAwsEndpointRequestId")
    @builtins.classmethod
    def context_aws_endpoint_request_id(cls) -> builtins.str:
        """(experimental) The AWS endpoint's request ID.

        :stability: experimental
        """
        return jsii.sinvoke(cls, "contextAwsEndpointRequestId", [])

    @jsii.member(jsii_name="contextDomainName")
    @builtins.classmethod
    def context_domain_name(cls) -> builtins.str:
        """(experimental) The full domain name used to invoke the API.

        This should be the same as the incoming ``Host`` header.

        :stability: experimental
        """
        return jsii.sinvoke(cls, "contextDomainName", [])

    @jsii.member(jsii_name="contextDomainPrefix")
    @builtins.classmethod
    def context_domain_prefix(cls) -> builtins.str:
        """(experimental) The first label of the ``$context.domainName``. This is often used as a caller/customer identifier.

        :stability: experimental
        """
        return jsii.sinvoke(cls, "contextDomainPrefix", [])

    @jsii.member(jsii_name="contextErrorMessage")
    @builtins.classmethod
    def context_error_message(cls) -> builtins.str:
        """(experimental) A string containing an API Gateway error message.

        :stability: experimental
        """
        return jsii.sinvoke(cls, "contextErrorMessage", [])

    @jsii.member(jsii_name="contextErrorMessageString")
    @builtins.classmethod
    def context_error_message_string(cls) -> builtins.str:
        """(experimental) The quoted value of $context.error.message, namely "$context.error.message".

        :stability: experimental
        """
        return jsii.sinvoke(cls, "contextErrorMessageString", [])

    @jsii.member(jsii_name="contextErrorResponseType")
    @builtins.classmethod
    def context_error_response_type(cls) -> builtins.str:
        """(experimental) A type of GatewayResponse.

        This variable can only be used for simple variable substitution in a GatewayResponse body-mapping template,
        which is not processed by the Velocity Template Language engine, and in access logging.

        :see: https://docs.aws.amazon.com/apigateway/latest/developerguide/customize-gateway-responses.html
        :stability: experimental
        """
        return jsii.sinvoke(cls, "contextErrorResponseType", [])

    @jsii.member(jsii_name="contextErrorValidationErrorString")
    @builtins.classmethod
    def context_error_validation_error_string(cls) -> builtins.str:
        """(experimental) A string containing a detailed validation error message.

        :stability: experimental
        """
        return jsii.sinvoke(cls, "contextErrorValidationErrorString", [])

    @jsii.member(jsii_name="contextExtendedRequestId")
    @builtins.classmethod
    def context_extended_request_id(cls) -> builtins.str:
        """(experimental) The extended ID that API Gateway assigns to the API request, which contains more useful information for debugging/troubleshooting.

        :stability: experimental
        """
        return jsii.sinvoke(cls, "contextExtendedRequestId", [])

    @jsii.member(jsii_name="contextHttpMethod")
    @builtins.classmethod
    def context_http_method(cls) -> builtins.str:
        """(experimental) The HTTP method used.

        Valid values include: ``DELETE``, ``GET``, ``HEAD``, ``OPTIONS``, ``PATCH``, ``POST``, and ``PUT``.

        :stability: experimental
        """
        return jsii.sinvoke(cls, "contextHttpMethod", [])

    @jsii.member(jsii_name="contextIdentityAccountId")
    @builtins.classmethod
    def context_identity_account_id(cls) -> builtins.str:
        """(experimental) The AWS account ID associated with the request.

        :stability: experimental
        """
        return jsii.sinvoke(cls, "contextIdentityAccountId", [])

    @jsii.member(jsii_name="contextIdentityApiKey")
    @builtins.classmethod
    def context_identity_api_key(cls) -> builtins.str:
        """(experimental) For API methods that require an API key, this variable is the API key associated with the method request.

        For methods that don't require an API key, this variable is

        :see: https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-api-usage-plans.html
        :stability: experimental
        """
        return jsii.sinvoke(cls, "contextIdentityApiKey", [])

    @jsii.member(jsii_name="contextIdentityApiKeyId")
    @builtins.classmethod
    def context_identity_api_key_id(cls) -> builtins.str:
        """(experimental) The API key ID associated with an API request that requires an API key.

        :stability: experimental
        """
        return jsii.sinvoke(cls, "contextIdentityApiKeyId", [])

    @jsii.member(jsii_name="contextIdentityCaller")
    @builtins.classmethod
    def context_identity_caller(cls) -> builtins.str:
        """(experimental) The principal identifier of the caller making the request.

        :stability: experimental
        """
        return jsii.sinvoke(cls, "contextIdentityCaller", [])

    @jsii.member(jsii_name="contextIdentityCognitoAuthenticationProvider")
    @builtins.classmethod
    def context_identity_cognito_authentication_provider(cls) -> builtins.str:
        """(experimental) The Amazon Cognito authentication provider used by the caller making the request.

        Available only if the request was signed with Amazon Cognito credentials.

        :see: https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-identity.html
        :stability: experimental
        """
        return jsii.sinvoke(cls, "contextIdentityCognitoAuthenticationProvider", [])

    @jsii.member(jsii_name="contextIdentityCognitoAuthenticationType")
    @builtins.classmethod
    def context_identity_cognito_authentication_type(cls) -> builtins.str:
        """(experimental) The Amazon Cognito authentication type of the caller making the request.

        Available only if the request was signed with Amazon Cognito credentials.

        :stability: experimental
        """
        return jsii.sinvoke(cls, "contextIdentityCognitoAuthenticationType", [])

    @jsii.member(jsii_name="contextIdentityCognitoIdentityId")
    @builtins.classmethod
    def context_identity_cognito_identity_id(cls) -> builtins.str:
        """(experimental) The Amazon Cognito identity ID of the caller making the request.

        Available only if the request was signed with Amazon Cognito credentials.

        :stability: experimental
        """
        return jsii.sinvoke(cls, "contextIdentityCognitoIdentityId", [])

    @jsii.member(jsii_name="contextIdentityCognitoIdentityPoolId")
    @builtins.classmethod
    def context_identity_cognito_identity_pool_id(cls) -> builtins.str:
        """(experimental) The Amazon Cognito identity pool ID of the caller making the request.

        Available only if the request was signed with Amazon Cognito credentials.

        :stability: experimental
        """
        return jsii.sinvoke(cls, "contextIdentityCognitoIdentityPoolId", [])

    @jsii.member(jsii_name="contextIdentityPrincipalOrgId")
    @builtins.classmethod
    def context_identity_principal_org_id(cls) -> builtins.str:
        """(experimental) The AWS organization ID.

        :stability: experimental
        """
        return jsii.sinvoke(cls, "contextIdentityPrincipalOrgId", [])

    @jsii.member(jsii_name="contextIdentitySourceIp")
    @builtins.classmethod
    def context_identity_source_ip(cls) -> builtins.str:
        """(experimental) The source IP address of the TCP connection making the request to API Gateway.

        Warning: You should not trust this value if there is any chance that the ``X-Forwarded-For`` header could be forged.

        :stability: experimental
        """
        return jsii.sinvoke(cls, "contextIdentitySourceIp", [])

    @jsii.member(jsii_name="contextIdentityUser")
    @builtins.classmethod
    def context_identity_user(cls) -> builtins.str:
        """(experimental) The principal identifier of the user making the request.

        Used in Lambda authorizers.

        :see: https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-lambda-authorizer-output.html
        :stability: experimental
        """
        return jsii.sinvoke(cls, "contextIdentityUser", [])

    @jsii.member(jsii_name="contextIdentityUserAgent")
    @builtins.classmethod
    def context_identity_user_agent(cls) -> builtins.str:
        """(experimental) The User-Agent header of the API caller.

        :stability: experimental
        """
        return jsii.sinvoke(cls, "contextIdentityUserAgent", [])

    @jsii.member(jsii_name="contextIdentityUserArn")
    @builtins.classmethod
    def context_identity_user_arn(cls) -> builtins.str:
        """(experimental) The Amazon Resource Name (ARN) of the effective user identified after authentication.

        :see: https://docs.aws.amazon.com/IAM/latest/UserGuide/id_users.html
        :stability: experimental
        """
        return jsii.sinvoke(cls, "contextIdentityUserArn", [])

    @jsii.member(jsii_name="contextIntegrationLatency")
    @builtins.classmethod
    def context_integration_latency(cls) -> builtins.str:
        """(experimental) The integration latency in ms.

        :stability: experimental
        """
        return jsii.sinvoke(cls, "contextIntegrationLatency", [])

    @jsii.member(jsii_name="contextIntegrationStatus")
    @builtins.classmethod
    def context_integration_status(cls) -> builtins.str:
        """(experimental) For Lambda proxy integration, this parameter represents the status code returned from AWS Lambda, not from the backend Lambda function.

        :stability: experimental
        """
        return jsii.sinvoke(cls, "contextIntegrationStatus", [])

    @jsii.member(jsii_name="contextPath")
    @builtins.classmethod
    def context_path(cls) -> builtins.str:
        """(experimental) The request path.

        For example, for a non-proxy request URL of https://{rest-api-id.execute-api.{region}.amazonaws.com/{stage}/root/child,
        this value is /{stage}/root/child.

        :stability: experimental
        """
        return jsii.sinvoke(cls, "contextPath", [])

    @jsii.member(jsii_name="contextProtocol")
    @builtins.classmethod
    def context_protocol(cls) -> builtins.str:
        """(experimental) The request protocol, for example, HTTP/1.1.

        :stability: experimental
        """
        return jsii.sinvoke(cls, "contextProtocol", [])

    @jsii.member(jsii_name="contextRequestId")
    @builtins.classmethod
    def context_request_id(cls) -> builtins.str:
        """(experimental) The ID that API Gateway assigns to the API request.

        :stability: experimental
        """
        return jsii.sinvoke(cls, "contextRequestId", [])

    @jsii.member(jsii_name="contextRequestOverrideHeader")
    @builtins.classmethod
    def context_request_override_header(cls, header_name: builtins.str) -> builtins.str:
        """(experimental) The request header override.

        If this parameter is defined, it contains the headers to be used instead of the HTTP Headers that are defined in the Integration Request pane.

        :param header_name: -

        :see: https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-override-request-response-parameters.html
        :stability: experimental
        """
        return jsii.sinvoke(cls, "contextRequestOverrideHeader", [header_name])

    @jsii.member(jsii_name="contextRequestOverridePath")
    @builtins.classmethod
    def context_request_override_path(cls, path_name: builtins.str) -> builtins.str:
        """(experimental) The request path override.

        If this parameter is defined,
        it contains the request path to be used instead of the URL Path Parameters that are defined in the Integration Request pane.

        :param path_name: -

        :see: https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-override-request-response-parameters.html
        :stability: experimental
        """
        return jsii.sinvoke(cls, "contextRequestOverridePath", [path_name])

    @jsii.member(jsii_name="contextRequestOverrideQuerystring")
    @builtins.classmethod
    def context_request_override_querystring(
        cls,
        querystring_name: builtins.str,
    ) -> builtins.str:
        """(experimental) The request query string override.

        If this parameter is defined, it contains the request query strings to be used instead
        of the URL Query String Parameters that are defined in the Integration Request pane.

        :param querystring_name: -

        :stability: experimental
        """
        return jsii.sinvoke(cls, "contextRequestOverrideQuerystring", [querystring_name])

    @jsii.member(jsii_name="contextRequestTime")
    @builtins.classmethod
    def context_request_time(cls) -> builtins.str:
        """(experimental) The CLF-formatted request time (dd/MMM/yyyy:HH:mm:ss +-hhmm).

        :stability: experimental
        """
        return jsii.sinvoke(cls, "contextRequestTime", [])

    @jsii.member(jsii_name="contextRequestTimeEpoch")
    @builtins.classmethod
    def context_request_time_epoch(cls) -> builtins.str:
        """(experimental) The Epoch-formatted request time.

        :stability: experimental
        """
        return jsii.sinvoke(cls, "contextRequestTimeEpoch", [])

    @jsii.member(jsii_name="contextResourceId")
    @builtins.classmethod
    def context_resource_id(cls) -> builtins.str:
        """(experimental) The identifier that API Gateway assigns to your resource.

        :stability: experimental
        """
        return jsii.sinvoke(cls, "contextResourceId", [])

    @jsii.member(jsii_name="contextResourcePath")
    @builtins.classmethod
    def context_resource_path(cls) -> builtins.str:
        """(experimental) The path to your resource.

        For example, for the non-proxy request URI of ``https://{rest-api-id.execute-api.{region}.amazonaws.com/{stage}/root/child``,
        The $context.resourcePath value is ``/root/child``.

        :see: https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-create-api-step-by-step.html
        :stability: experimental
        """
        return jsii.sinvoke(cls, "contextResourcePath", [])

    @jsii.member(jsii_name="contextResponseLatency")
    @builtins.classmethod
    def context_response_latency(cls) -> builtins.str:
        """(experimental) The response latency in ms.

        :stability: experimental
        """
        return jsii.sinvoke(cls, "contextResponseLatency", [])

    @jsii.member(jsii_name="contextResponseLength")
    @builtins.classmethod
    def context_response_length(cls) -> builtins.str:
        """(experimental) The response payload length.

        :stability: experimental
        """
        return jsii.sinvoke(cls, "contextResponseLength", [])

    @jsii.member(jsii_name="contextResponseOverrideHeader")
    @builtins.classmethod
    def context_response_override_header(
        cls,
        header_name: builtins.str,
    ) -> builtins.str:
        """(experimental) The response header override.

        If this parameter is defined, it contains the header to be returned instead of the Response header
        that is defined as the Default mapping in the Integration Response pane.

        :param header_name: -

        :see: https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-override-request-response-parameters.html
        :stability: experimental
        """
        return jsii.sinvoke(cls, "contextResponseOverrideHeader", [header_name])

    @jsii.member(jsii_name="contextResponseOverrideStatus")
    @builtins.classmethod
    def context_response_override_status(cls) -> builtins.str:
        """(experimental) The response status code override.

        If this parameter is defined, it contains the status code to be returned instead of the Method response status
        that is defined as the Default mapping in the Integration Response pane.

        :see: https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-override-request-response-parameters.html
        :stability: experimental
        """
        return jsii.sinvoke(cls, "contextResponseOverrideStatus", [])

    @jsii.member(jsii_name="contextStage")
    @builtins.classmethod
    def context_stage(cls) -> builtins.str:
        """(experimental) The deployment stage of the API request (for example, ``Beta`` or ``Prod``).

        :stability: experimental
        """
        return jsii.sinvoke(cls, "contextStage", [])

    @jsii.member(jsii_name="contextStatus")
    @builtins.classmethod
    def context_status(cls) -> builtins.str:
        """(experimental) The method response status.

        :stability: experimental
        """
        return jsii.sinvoke(cls, "contextStatus", [])

    @jsii.member(jsii_name="contextWafResponseCode")
    @builtins.classmethod
    def context_waf_response_code(cls) -> builtins.str:
        """(experimental) The response received from AWS WAF: ``WAF_ALLOW`` or ``WAF_BLOCK``.

        Will not be set if the stage is not associated with a web ACL.

        :see: https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-control-access-aws-waf.html
        :stability: experimental
        """
        return jsii.sinvoke(cls, "contextWafResponseCode", [])

    @jsii.member(jsii_name="contextWebaclArn")
    @builtins.classmethod
    def context_webacl_arn(cls) -> builtins.str:
        """(experimental) The complete ARN of the web ACL that is used to decide whether to allow or block the request.

        Will not be set if the stage is not associated with a web ACL.

        :see: https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-control-access-aws-waf.html
        :stability: experimental
        """
        return jsii.sinvoke(cls, "contextWebaclArn", [])

    @jsii.member(jsii_name="contextXrayTraceId")
    @builtins.classmethod
    def context_xray_trace_id(cls) -> builtins.str:
        """(experimental) The trace ID for the X-Ray trace.

        :see: https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-enabling-xray.html
        :stability: experimental
        """
        return jsii.sinvoke(cls, "contextXrayTraceId", [])


class AccessLogFormat(
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_apigateway.AccessLogFormat",
):
    """(experimental) factory methods for access log format.

    :stability: experimental
    """

    @jsii.member(jsii_name="clf")
    @builtins.classmethod
    def clf(cls) -> "AccessLogFormat":
        """(experimental) Generate Common Log Format.

        :stability: experimental
        """
        return jsii.sinvoke(cls, "clf", [])

    @jsii.member(jsii_name="custom")
    @builtins.classmethod
    def custom(cls, format: builtins.str) -> "AccessLogFormat":
        """(experimental) Custom log format.

        You can create any log format string. You can easily get the $ context variable by using the methods of AccessLogField.

        :param format: -

        :stability: experimental

        Example::

            # Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
            custom(JSON.stringify(
                request_id=AccessLogField.context_request_id(),
                source_ip=AccessLogField.context_identity_source_ip(),
                method=AccessLogFiled.context_http_method(),
                user_context={
                    "sub": AccessLogField.context_authorizer_claims("sub"),
                    "email": AccessLogField.context_authorizer_claims("email")
                }
            ))
        """
        return jsii.sinvoke(cls, "custom", [format])

    @jsii.member(jsii_name="jsonWithStandardFields")
    @builtins.classmethod
    def json_with_standard_fields(
        cls,
        *,
        caller: builtins.bool,
        http_method: builtins.bool,
        ip: builtins.bool,
        protocol: builtins.bool,
        request_time: builtins.bool,
        resource_path: builtins.bool,
        response_length: builtins.bool,
        status: builtins.bool,
        user: builtins.bool,
    ) -> "AccessLogFormat":
        """(experimental) Access log will be produced in the JSON format with a set of fields most useful in the access log.

        All fields are turned on by default with the
        option to turn off specific fields.

        :param caller: (experimental) If this flag is enabled, the principal identifier of the caller will be output to the log.
        :param http_method: (experimental) If this flag is enabled, the http method will be output to the log.
        :param ip: (experimental) If this flag is enabled, the source IP of request will be output to the log.
        :param protocol: (experimental) If this flag is enabled, the request protocol will be output to the log.
        :param request_time: (experimental) If this flag is enabled, the CLF-formatted request time((dd/MMM/yyyy:HH:mm:ss +-hhmm) will be output to the log.
        :param resource_path: (experimental) If this flag is enabled, the path to your resource will be output to the log.
        :param response_length: (experimental) If this flag is enabled, the response payload length will be output to the log.
        :param status: (experimental) If this flag is enabled, the method response status will be output to the log.
        :param user: (experimental) If this flag is enabled, the principal identifier of the user will be output to the log.

        :stability: experimental
        """
        fields = JsonWithStandardFieldProps(
            caller=caller,
            http_method=http_method,
            ip=ip,
            protocol=protocol,
            request_time=request_time,
            resource_path=resource_path,
            response_length=response_length,
            status=status,
            user=user,
        )

        return jsii.sinvoke(cls, "jsonWithStandardFields", [fields])

    @jsii.member(jsii_name="toString")
    def to_string(self) -> builtins.str:
        """(experimental) Output a format string to be used with CloudFormation.

        :stability: experimental
        """
        return jsii.invoke(self, "toString", [])


class ApiDefinition(
    metaclass=jsii.JSIIAbstractClass,
    jsii_type="monocdk.aws_apigateway.ApiDefinition",
):
    """(experimental) Represents an OpenAPI definition asset.

    :stability: experimental
    """

    @builtins.staticmethod
    def __jsii_proxy_class__():
        return _ApiDefinitionProxy

    def __init__(self) -> None:
        """
        :stability: experimental
        """
        jsii.create(ApiDefinition, self, [])

    @jsii.member(jsii_name="fromAsset")
    @builtins.classmethod
    def from_asset(
        cls,
        file: builtins.str,
        *,
        readers: typing.Optional[typing.List[_IGrantable_4c5a91d1]] = None,
        source_hash: typing.Optional[builtins.str] = None,
        exclude: typing.Optional[typing.List[builtins.str]] = None,
        follow: typing.Optional[_FollowMode_98b05cc5] = None,
        asset_hash: typing.Optional[builtins.str] = None,
        asset_hash_type: typing.Optional[_AssetHashType_49193809] = None,
        bundling: typing.Optional[_BundlingOptions_ab115a99] = None,
    ) -> "AssetApiDefinition":
        """(experimental) Loads the API specification from a local disk asset.

        :param file: -
        :param readers: (experimental) A list of principals that should be able to read this asset from S3. You can use ``asset.grantRead(principal)`` to grant read permissions later. Default: - No principals that can read file asset.
        :param source_hash: (deprecated) Custom hash to use when identifying the specific version of the asset. For consistency, this custom hash will be SHA256 hashed and encoded as hex. The resulting hash will be the asset hash. NOTE: the source hash is used in order to identify a specific revision of the asset, and used for optimizing and caching deployment activities related to this asset such as packaging, uploading to Amazon S3, etc. If you chose to customize the source hash, you will need to make sure it is updated every time the source changes, or otherwise it is possible that some deployments will not be invalidated. Default: - automatically calculate source hash based on the contents of the source file or directory.
        :param exclude: (deprecated) Glob patterns to exclude from the copy. Default: nothing is excluded
        :param follow: (deprecated) A strategy for how to handle symlinks. Default: Never
        :param asset_hash: (experimental) Specify a custom hash for this asset. If ``assetHashType`` is set it must be set to ``AssetHashType.CUSTOM``. For consistency, this custom hash will be SHA256 hashed and encoded as hex. The resulting hash will be the asset hash. NOTE: the hash is used in order to identify a specific revision of the asset, and used for optimizing and caching deployment activities related to this asset such as packaging, uploading to Amazon S3, etc. If you chose to customize the hash, you will need to make sure it is updated every time the asset changes, or otherwise it is possible that some deployments will not be invalidated. Default: - based on ``assetHashType``
        :param asset_hash_type: (experimental) Specifies the type of hash to calculate for this asset. If ``assetHash`` is configured, this option must be ``undefined`` or ``AssetHashType.CUSTOM``. Default: - the default is ``AssetHashType.SOURCE``, but if ``assetHash`` is explicitly specified this value defaults to ``AssetHashType.CUSTOM``.
        :param bundling: (experimental) Bundle the asset by executing a command in a Docker container. The asset path will be mounted at ``/asset-input``. The Docker container is responsible for putting content at ``/asset-output``. The content at ``/asset-output`` will be zipped and used as the final asset. Default: - uploaded as-is to S3 if the asset is a regular file or a .zip file, archived into a .zip file and uploaded to S3 otherwise

        :stability: experimental
        """
        options = _AssetOptions_bd2996da(
            readers=readers,
            source_hash=source_hash,
            exclude=exclude,
            follow=follow,
            asset_hash=asset_hash,
            asset_hash_type=asset_hash_type,
            bundling=bundling,
        )

        return jsii.sinvoke(cls, "fromAsset", [file, options])

    @jsii.member(jsii_name="fromBucket")
    @builtins.classmethod
    def from_bucket(
        cls,
        bucket: _IBucket_73486e29,
        key: builtins.str,
        object_version: typing.Optional[builtins.str] = None,
    ) -> "S3ApiDefinition":
        """(experimental) Creates an API definition from a specification file in an S3 bucket.

        :param bucket: -
        :param key: -
        :param object_version: -

        :stability: experimental
        """
        return jsii.sinvoke(cls, "fromBucket", [bucket, key, object_version])

    @jsii.member(jsii_name="fromInline")
    @builtins.classmethod
    def from_inline(cls, definition: typing.Any) -> "InlineApiDefinition":
        """(experimental) Create an API definition from an inline object.

        The inline object must follow the
        schema of OpenAPI 2.0 or OpenAPI 3.0

        :param definition: -

        :stability: experimental

        Example::

            # Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
            ApiDefinition.from_inline(
                openapi="3.0.2",
                paths={
                    "/pets": {
                        "get": {
                            "responses": {
                                "200": {
                                    "content": {
                                        "application/json": {
                                            "schema": {
                                                "$ref": "#/components/schemas/Empty"
                                            }
                                        }
                                    }
                                }
                            },
                            "x-amazon-apigateway-integration": {
                                "responses": {
                                    "default": {
                                        "status_code": "200"
                                    }
                                },
                                "request_templates": {
                                    "application/json": "{\"statusCode\": 200}"
                                },
                                "passthrough_behavior": "when_no_match",
                                "type": "mock"
                            }
                        }
                    }
                },
                components={
                    "schemas": {
                        "Empty": {
                            "title": "Empty Schema",
                            "type": "object"
                        }
                    }
                }
            )
        """
        return jsii.sinvoke(cls, "fromInline", [definition])

    @jsii.member(jsii_name="bind")
    @abc.abstractmethod
    def bind(self, scope: _Construct_e78e779f) -> "ApiDefinitionConfig":
        """(experimental) Called when the specification is initialized to allow this object to bind to the stack, add resources and have fun.

        :param scope: The binding scope. Don't be smart about trying to down-cast or assume it's initialized. You may just use it as a construct scope.

        :stability: experimental
        """
        ...


class _ApiDefinitionProxy(ApiDefinition):
    @jsii.member(jsii_name="bind")
    def bind(self, scope: _Construct_e78e779f) -> "ApiDefinitionConfig":
        """(experimental) Called when the specification is initialized to allow this object to bind to the stack, add resources and have fun.

        :param scope: The binding scope. Don't be smart about trying to down-cast or assume it's initialized. You may just use it as a construct scope.

        :stability: experimental
        """
        return jsii.invoke(self, "bind", [scope])


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.ApiDefinitionConfig",
    jsii_struct_bases=[],
    name_mapping={
        "inline_definition": "inlineDefinition",
        "s3_location": "s3Location",
    },
)
class ApiDefinitionConfig:
    def __init__(
        self,
        *,
        inline_definition: typing.Any = None,
        s3_location: typing.Optional["ApiDefinitionS3Location"] = None,
    ) -> None:
        """(experimental) Post-Binding Configuration for a CDK construct.

        :param inline_definition: (experimental) Inline specification (mutually exclusive with ``s3Location``). Default: - API definition is not defined inline
        :param s3_location: (experimental) The location of the specification in S3 (mutually exclusive with ``inlineDefinition``). Default: - API definition is not an S3 location

        :stability: experimental
        """
        if isinstance(s3_location, dict):
            s3_location = ApiDefinitionS3Location(**s3_location)
        self._values: typing.Dict[str, typing.Any] = {}
        if inline_definition is not None:
            self._values["inline_definition"] = inline_definition
        if s3_location is not None:
            self._values["s3_location"] = s3_location

    @builtins.property
    def inline_definition(self) -> typing.Any:
        """(experimental) Inline specification (mutually exclusive with ``s3Location``).

        :default: - API definition is not defined inline

        :stability: experimental
        """
        result = self._values.get("inline_definition")
        return result

    @builtins.property
    def s3_location(self) -> typing.Optional["ApiDefinitionS3Location"]:
        """(experimental) The location of the specification in S3 (mutually exclusive with ``inlineDefinition``).

        :default: - API definition is not an S3 location

        :stability: experimental
        """
        result = self._values.get("s3_location")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiDefinitionConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.ApiDefinitionS3Location",
    jsii_struct_bases=[],
    name_mapping={"bucket": "bucket", "key": "key", "version": "version"},
)
class ApiDefinitionS3Location:
    def __init__(
        self,
        *,
        bucket: builtins.str,
        key: builtins.str,
        version: typing.Optional[builtins.str] = None,
    ) -> None:
        """(experimental) S3 location of the API definition file.

        :param bucket: (experimental) The S3 bucket.
        :param key: (experimental) The S3 key.
        :param version: (experimental) An optional version. Default: - latest version

        :stability: experimental
        """
        self._values: typing.Dict[str, typing.Any] = {
            "bucket": bucket,
            "key": key,
        }
        if version is not None:
            self._values["version"] = version

    @builtins.property
    def bucket(self) -> builtins.str:
        """(experimental) The S3 bucket.

        :stability: experimental
        """
        result = self._values.get("bucket")
        assert result is not None, "Required property 'bucket' is missing"
        return result

    @builtins.property
    def key(self) -> builtins.str:
        """(experimental) The S3 key.

        :stability: experimental
        """
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return result

    @builtins.property
    def version(self) -> typing.Optional[builtins.str]:
        """(experimental) An optional version.

        :default: - latest version

        :stability: experimental
        """
        result = self._values.get("version")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiDefinitionS3Location(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="monocdk.aws_apigateway.ApiKeySourceType")
class ApiKeySourceType(enum.Enum):
    """
    :stability: experimental
    """

    HEADER = "HEADER"
    """(experimental) To read the API key from the ``X-API-Key`` header of a request.

    :stability: experimental
    """
    AUTHORIZER = "AUTHORIZER"
    """(experimental) To read the API key from the ``UsageIdentifierKey`` from a custom authorizer.

    :stability: experimental
    """


class AssetApiDefinition(
    ApiDefinition,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_apigateway.AssetApiDefinition",
):
    """(experimental) OpenAPI specification from a local file.

    :stability: experimental
    """

    def __init__(
        self,
        path: builtins.str,
        *,
        readers: typing.Optional[typing.List[_IGrantable_4c5a91d1]] = None,
        source_hash: typing.Optional[builtins.str] = None,
        exclude: typing.Optional[typing.List[builtins.str]] = None,
        follow: typing.Optional[_FollowMode_98b05cc5] = None,
        asset_hash: typing.Optional[builtins.str] = None,
        asset_hash_type: typing.Optional[_AssetHashType_49193809] = None,
        bundling: typing.Optional[_BundlingOptions_ab115a99] = None,
    ) -> None:
        """
        :param path: -
        :param readers: (experimental) A list of principals that should be able to read this asset from S3. You can use ``asset.grantRead(principal)`` to grant read permissions later. Default: - No principals that can read file asset.
        :param source_hash: (deprecated) Custom hash to use when identifying the specific version of the asset. For consistency, this custom hash will be SHA256 hashed and encoded as hex. The resulting hash will be the asset hash. NOTE: the source hash is used in order to identify a specific revision of the asset, and used for optimizing and caching deployment activities related to this asset such as packaging, uploading to Amazon S3, etc. If you chose to customize the source hash, you will need to make sure it is updated every time the source changes, or otherwise it is possible that some deployments will not be invalidated. Default: - automatically calculate source hash based on the contents of the source file or directory.
        :param exclude: (deprecated) Glob patterns to exclude from the copy. Default: nothing is excluded
        :param follow: (deprecated) A strategy for how to handle symlinks. Default: Never
        :param asset_hash: (experimental) Specify a custom hash for this asset. If ``assetHashType`` is set it must be set to ``AssetHashType.CUSTOM``. For consistency, this custom hash will be SHA256 hashed and encoded as hex. The resulting hash will be the asset hash. NOTE: the hash is used in order to identify a specific revision of the asset, and used for optimizing and caching deployment activities related to this asset such as packaging, uploading to Amazon S3, etc. If you chose to customize the hash, you will need to make sure it is updated every time the asset changes, or otherwise it is possible that some deployments will not be invalidated. Default: - based on ``assetHashType``
        :param asset_hash_type: (experimental) Specifies the type of hash to calculate for this asset. If ``assetHash`` is configured, this option must be ``undefined`` or ``AssetHashType.CUSTOM``. Default: - the default is ``AssetHashType.SOURCE``, but if ``assetHash`` is explicitly specified this value defaults to ``AssetHashType.CUSTOM``.
        :param bundling: (experimental) Bundle the asset by executing a command in a Docker container. The asset path will be mounted at ``/asset-input``. The Docker container is responsible for putting content at ``/asset-output``. The content at ``/asset-output`` will be zipped and used as the final asset. Default: - uploaded as-is to S3 if the asset is a regular file or a .zip file, archived into a .zip file and uploaded to S3 otherwise

        :stability: experimental
        """
        options = _AssetOptions_bd2996da(
            readers=readers,
            source_hash=source_hash,
            exclude=exclude,
            follow=follow,
            asset_hash=asset_hash,
            asset_hash_type=asset_hash_type,
            bundling=bundling,
        )

        jsii.create(AssetApiDefinition, self, [path, options])

    @jsii.member(jsii_name="bind")
    def bind(self, scope: _Construct_e78e779f) -> ApiDefinitionConfig:
        """(experimental) Called when the specification is initialized to allow this object to bind to the stack, add resources and have fun.

        :param scope: -

        :stability: experimental
        """
        return jsii.invoke(self, "bind", [scope])


@jsii.enum(jsii_type="monocdk.aws_apigateway.AuthorizationType")
class AuthorizationType(enum.Enum):
    """
    :stability: experimental
    """

    NONE = "NONE"
    """(experimental) Open access.

    :stability: experimental
    """
    IAM = "IAM"
    """(experimental) Use AWS IAM permissions.

    :stability: experimental
    """
    CUSTOM = "CUSTOM"
    """(experimental) Use a custom authorizer.

    :stability: experimental
    """
    COGNITO = "COGNITO"
    """(experimental) Use an AWS Cognito user pool.

    :stability: experimental
    """


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.AwsIntegrationProps",
    jsii_struct_bases=[],
    name_mapping={
        "service": "service",
        "action": "action",
        "action_parameters": "actionParameters",
        "integration_http_method": "integrationHttpMethod",
        "options": "options",
        "path": "path",
        "proxy": "proxy",
        "subdomain": "subdomain",
    },
)
class AwsIntegrationProps:
    def __init__(
        self,
        *,
        service: builtins.str,
        action: typing.Optional[builtins.str] = None,
        action_parameters: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        integration_http_method: typing.Optional[builtins.str] = None,
        options: typing.Optional["IntegrationOptions"] = None,
        path: typing.Optional[builtins.str] = None,
        proxy: typing.Optional[builtins.bool] = None,
        subdomain: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param service: (experimental) The name of the integrated AWS service (e.g. ``s3``).
        :param action: (experimental) The AWS action to perform in the integration. Use ``actionParams`` to specify key-value params for the action. Mutually exclusive with ``path``.
        :param action_parameters: (experimental) Parameters for the action. ``action`` must be set, and ``path`` must be undefined. The action params will be URL encoded.
        :param integration_http_method: (experimental) The integration's HTTP method type. Default: POST
        :param options: (experimental) Integration options, such as content handling, request/response mapping, etc.
        :param path: (experimental) The path to use for path-base APIs. For example, for S3 GET, you can set path to ``bucket/key``. For lambda, you can set path to ``2015-03-31/functions/${function-arn}/invocations`` Mutually exclusive with the ``action`` options.
        :param proxy: (experimental) Use AWS_PROXY integration. Default: false
        :param subdomain: (experimental) A designated subdomain supported by certain AWS service for fast host-name lookup.

        :stability: experimental
        """
        if isinstance(options, dict):
            options = IntegrationOptions(**options)
        self._values: typing.Dict[str, typing.Any] = {
            "service": service,
        }
        if action is not None:
            self._values["action"] = action
        if action_parameters is not None:
            self._values["action_parameters"] = action_parameters
        if integration_http_method is not None:
            self._values["integration_http_method"] = integration_http_method
        if options is not None:
            self._values["options"] = options
        if path is not None:
            self._values["path"] = path
        if proxy is not None:
            self._values["proxy"] = proxy
        if subdomain is not None:
            self._values["subdomain"] = subdomain

    @builtins.property
    def service(self) -> builtins.str:
        """(experimental) The name of the integrated AWS service (e.g. ``s3``).

        :stability: experimental
        """
        result = self._values.get("service")
        assert result is not None, "Required property 'service' is missing"
        return result

    @builtins.property
    def action(self) -> typing.Optional[builtins.str]:
        """(experimental) The AWS action to perform in the integration.

        Use ``actionParams`` to specify key-value params for the action.

        Mutually exclusive with ``path``.

        :stability: experimental
        """
        result = self._values.get("action")
        return result

    @builtins.property
    def action_parameters(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        """(experimental) Parameters for the action.

        ``action`` must be set, and ``path`` must be undefined.
        The action params will be URL encoded.

        :stability: experimental
        """
        result = self._values.get("action_parameters")
        return result

    @builtins.property
    def integration_http_method(self) -> typing.Optional[builtins.str]:
        """(experimental) The integration's HTTP method type.

        :default: POST

        :stability: experimental
        """
        result = self._values.get("integration_http_method")
        return result

    @builtins.property
    def options(self) -> typing.Optional["IntegrationOptions"]:
        """(experimental) Integration options, such as content handling, request/response mapping, etc.

        :stability: experimental
        """
        result = self._values.get("options")
        return result

    @builtins.property
    def path(self) -> typing.Optional[builtins.str]:
        """(experimental) The path to use for path-base APIs.

        For example, for S3 GET, you can set path to ``bucket/key``.
        For lambda, you can set path to ``2015-03-31/functions/${function-arn}/invocations``

        Mutually exclusive with the ``action`` options.

        :stability: experimental
        """
        result = self._values.get("path")
        return result

    @builtins.property
    def proxy(self) -> typing.Optional[builtins.bool]:
        """(experimental) Use AWS_PROXY integration.

        :default: false

        :stability: experimental
        """
        result = self._values.get("proxy")
        return result

    @builtins.property
    def subdomain(self) -> typing.Optional[builtins.str]:
        """(experimental) A designated subdomain supported by certain AWS service for fast host-name lookup.

        :stability: experimental
        """
        result = self._values.get("subdomain")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AwsIntegrationProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class BasePathMapping(
    _Resource_abff4495,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_apigateway.BasePathMapping",
):
    """(experimental) This resource creates a base path that clients who call your API must use in the invocation URL.

    Unless you're importing a domain with ``DomainName.fromDomainNameAttributes()``,
    you can use ``DomainName.addBasePathMapping()`` to define mappings.

    :stability: experimental
    """

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        domain_name: "IDomainName",
        rest_api: "IRestApi",
        base_path: typing.Optional[builtins.str] = None,
        stage: typing.Optional["Stage"] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param domain_name: (experimental) The DomainName to associate with this base path mapping.
        :param rest_api: (experimental) The RestApi resource to target.
        :param base_path: (experimental) The base path name that callers of the API must provide in the URL after the domain name (e.g. ``example.com/base-path``). If you specify this property, it can't be an empty string. Default: - map requests from the domain root (e.g. ``example.com``). If this is undefined, no additional mappings will be allowed on this domain name.
        :param stage: (experimental) The Deployment stage of API [disable-awslint:ref-via-interface]. Default: - map to deploymentStage of restApi otherwise stage needs to pass in URL

        :stability: experimental
        """
        props = BasePathMappingProps(
            domain_name=domain_name,
            rest_api=rest_api,
            base_path=base_path,
            stage=stage,
        )

        jsii.create(BasePathMapping, self, [scope, id, props])


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.BasePathMappingOptions",
    jsii_struct_bases=[],
    name_mapping={"base_path": "basePath", "stage": "stage"},
)
class BasePathMappingOptions:
    def __init__(
        self,
        *,
        base_path: typing.Optional[builtins.str] = None,
        stage: typing.Optional["Stage"] = None,
    ) -> None:
        """
        :param base_path: (experimental) The base path name that callers of the API must provide in the URL after the domain name (e.g. ``example.com/base-path``). If you specify this property, it can't be an empty string. Default: - map requests from the domain root (e.g. ``example.com``). If this is undefined, no additional mappings will be allowed on this domain name.
        :param stage: (experimental) The Deployment stage of API [disable-awslint:ref-via-interface]. Default: - map to deploymentStage of restApi otherwise stage needs to pass in URL

        :stability: experimental
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if base_path is not None:
            self._values["base_path"] = base_path
        if stage is not None:
            self._values["stage"] = stage

    @builtins.property
    def base_path(self) -> typing.Optional[builtins.str]:
        """(experimental) The base path name that callers of the API must provide in the URL after the domain name (e.g. ``example.com/base-path``). If you specify this property, it can't be an empty string.

        :default:

        - map requests from the domain root (e.g. ``example.com``). If this
        is undefined, no additional mappings will be allowed on this domain name.

        :stability: experimental
        """
        result = self._values.get("base_path")
        return result

    @builtins.property
    def stage(self) -> typing.Optional["Stage"]:
        """(experimental) The Deployment stage of API [disable-awslint:ref-via-interface].

        :default: - map to deploymentStage of restApi otherwise stage needs to pass in URL

        :stability: experimental
        """
        result = self._values.get("stage")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "BasePathMappingOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.BasePathMappingProps",
    jsii_struct_bases=[BasePathMappingOptions],
    name_mapping={
        "base_path": "basePath",
        "stage": "stage",
        "domain_name": "domainName",
        "rest_api": "restApi",
    },
)
class BasePathMappingProps(BasePathMappingOptions):
    def __init__(
        self,
        *,
        base_path: typing.Optional[builtins.str] = None,
        stage: typing.Optional["Stage"] = None,
        domain_name: "IDomainName",
        rest_api: "IRestApi",
    ) -> None:
        """
        :param base_path: (experimental) The base path name that callers of the API must provide in the URL after the domain name (e.g. ``example.com/base-path``). If you specify this property, it can't be an empty string. Default: - map requests from the domain root (e.g. ``example.com``). If this is undefined, no additional mappings will be allowed on this domain name.
        :param stage: (experimental) The Deployment stage of API [disable-awslint:ref-via-interface]. Default: - map to deploymentStage of restApi otherwise stage needs to pass in URL
        :param domain_name: (experimental) The DomainName to associate with this base path mapping.
        :param rest_api: (experimental) The RestApi resource to target.

        :stability: experimental
        """
        self._values: typing.Dict[str, typing.Any] = {
            "domain_name": domain_name,
            "rest_api": rest_api,
        }
        if base_path is not None:
            self._values["base_path"] = base_path
        if stage is not None:
            self._values["stage"] = stage

    @builtins.property
    def base_path(self) -> typing.Optional[builtins.str]:
        """(experimental) The base path name that callers of the API must provide in the URL after the domain name (e.g. ``example.com/base-path``). If you specify this property, it can't be an empty string.

        :default:

        - map requests from the domain root (e.g. ``example.com``). If this
        is undefined, no additional mappings will be allowed on this domain name.

        :stability: experimental
        """
        result = self._values.get("base_path")
        return result

    @builtins.property
    def stage(self) -> typing.Optional["Stage"]:
        """(experimental) The Deployment stage of API [disable-awslint:ref-via-interface].

        :default: - map to deploymentStage of restApi otherwise stage needs to pass in URL

        :stability: experimental
        """
        result = self._values.get("stage")
        return result

    @builtins.property
    def domain_name(self) -> "IDomainName":
        """(experimental) The DomainName to associate with this base path mapping.

        :stability: experimental
        """
        result = self._values.get("domain_name")
        assert result is not None, "Required property 'domain_name' is missing"
        return result

    @builtins.property
    def rest_api(self) -> "IRestApi":
        """(experimental) The RestApi resource to target.

        :stability: experimental
        """
        result = self._values.get("rest_api")
        assert result is not None, "Required property 'rest_api' is missing"
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "BasePathMappingProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_82c04a63)
class CfnAccount(
    _CfnResource_e0a482dc,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_apigateway.CfnAccount",
):
    """A CloudFormation ``AWS::ApiGateway::Account``.

    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-account.html
    :cloudformationResource: AWS::ApiGateway::Account
    """

    def __init__(
        self,
        scope: _Construct_e78e779f,
        id: builtins.str,
        *,
        cloud_watch_role_arn: typing.Optional[builtins.str] = None,
    ) -> None:
        """Create a new ``AWS::ApiGateway::Account``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param cloud_watch_role_arn: ``AWS::ApiGateway::Account.CloudWatchRoleArn``.
        """
        props = CfnAccountProps(cloud_watch_role_arn=cloud_watch_role_arn)

        jsii.create(CfnAccount, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_1cd1894e) -> None:
        """(experimental) Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cloudWatchRoleArn")
    def cloud_watch_role_arn(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::Account.CloudWatchRoleArn``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-account.html#cfn-apigateway-account-cloudwatchrolearn
        """
        return jsii.get(self, "cloudWatchRoleArn")

    @cloud_watch_role_arn.setter # type: ignore
    def cloud_watch_role_arn(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "cloudWatchRoleArn", value)


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.CfnAccountProps",
    jsii_struct_bases=[],
    name_mapping={"cloud_watch_role_arn": "cloudWatchRoleArn"},
)
class CfnAccountProps:
    def __init__(
        self,
        *,
        cloud_watch_role_arn: typing.Optional[builtins.str] = None,
    ) -> None:
        """Properties for defining a ``AWS::ApiGateway::Account``.

        :param cloud_watch_role_arn: ``AWS::ApiGateway::Account.CloudWatchRoleArn``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-account.html
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if cloud_watch_role_arn is not None:
            self._values["cloud_watch_role_arn"] = cloud_watch_role_arn

    @builtins.property
    def cloud_watch_role_arn(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::Account.CloudWatchRoleArn``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-account.html#cfn-apigateway-account-cloudwatchrolearn
        """
        result = self._values.get("cloud_watch_role_arn")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnAccountProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_82c04a63)
class CfnApiKey(
    _CfnResource_e0a482dc,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_apigateway.CfnApiKey",
):
    """A CloudFormation ``AWS::ApiGateway::ApiKey``.

    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html
    :cloudformationResource: AWS::ApiGateway::ApiKey
    """

    def __init__(
        self,
        scope: _Construct_e78e779f,
        id: builtins.str,
        *,
        customer_id: typing.Optional[builtins.str] = None,
        description: typing.Optional[builtins.str] = None,
        enabled: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
        generate_distinct_id: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
        name: typing.Optional[builtins.str] = None,
        stage_keys: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnApiKey.StageKeyProperty", _IResolvable_a771d0ef]]]] = None,
        tags: typing.Optional[typing.List[_CfnTag_95fbdc29]] = None,
        value: typing.Optional[builtins.str] = None,
    ) -> None:
        """Create a new ``AWS::ApiGateway::ApiKey``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param customer_id: ``AWS::ApiGateway::ApiKey.CustomerId``.
        :param description: ``AWS::ApiGateway::ApiKey.Description``.
        :param enabled: ``AWS::ApiGateway::ApiKey.Enabled``.
        :param generate_distinct_id: ``AWS::ApiGateway::ApiKey.GenerateDistinctId``.
        :param name: ``AWS::ApiGateway::ApiKey.Name``.
        :param stage_keys: ``AWS::ApiGateway::ApiKey.StageKeys``.
        :param tags: ``AWS::ApiGateway::ApiKey.Tags``.
        :param value: ``AWS::ApiGateway::ApiKey.Value``.
        """
        props = CfnApiKeyProps(
            customer_id=customer_id,
            description=description,
            enabled=enabled,
            generate_distinct_id=generate_distinct_id,
            name=name,
            stage_keys=stage_keys,
            tags=tags,
            value=value,
        )

        jsii.create(CfnApiKey, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_1cd1894e) -> None:
        """(experimental) Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_0b7ab120:
        """``AWS::ApiGateway::ApiKey.Tags``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html#cfn-apigateway-apikey-tags
        """
        return jsii.get(self, "tags")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="customerId")
    def customer_id(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::ApiKey.CustomerId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html#cfn-apigateway-apikey-customerid
        """
        return jsii.get(self, "customerId")

    @customer_id.setter # type: ignore
    def customer_id(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "customerId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::ApiKey.Description``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html#cfn-apigateway-apikey-description
        """
        return jsii.get(self, "description")

    @description.setter # type: ignore
    def description(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "description", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="enabled")
    def enabled(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
        """``AWS::ApiGateway::ApiKey.Enabled``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html#cfn-apigateway-apikey-enabled
        """
        return jsii.get(self, "enabled")

    @enabled.setter # type: ignore
    def enabled(
        self,
        value: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]],
    ) -> None:
        jsii.set(self, "enabled", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="generateDistinctId")
    def generate_distinct_id(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
        """``AWS::ApiGateway::ApiKey.GenerateDistinctId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html#cfn-apigateway-apikey-generatedistinctid
        """
        return jsii.get(self, "generateDistinctId")

    @generate_distinct_id.setter # type: ignore
    def generate_distinct_id(
        self,
        value: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]],
    ) -> None:
        jsii.set(self, "generateDistinctId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="name")
    def name(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::ApiKey.Name``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html#cfn-apigateway-apikey-name
        """
        return jsii.get(self, "name")

    @name.setter # type: ignore
    def name(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "name", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="stageKeys")
    def stage_keys(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnApiKey.StageKeyProperty", _IResolvable_a771d0ef]]]]:
        """``AWS::ApiGateway::ApiKey.StageKeys``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html#cfn-apigateway-apikey-stagekeys
        """
        return jsii.get(self, "stageKeys")

    @stage_keys.setter # type: ignore
    def stage_keys(
        self,
        value: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnApiKey.StageKeyProperty", _IResolvable_a771d0ef]]]],
    ) -> None:
        jsii.set(self, "stageKeys", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="value")
    def value(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::ApiKey.Value``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html#cfn-apigateway-apikey-value
        """
        return jsii.get(self, "value")

    @value.setter # type: ignore
    def value(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "value", value)

    @jsii.data_type(
        jsii_type="monocdk.aws_apigateway.CfnApiKey.StageKeyProperty",
        jsii_struct_bases=[],
        name_mapping={"rest_api_id": "restApiId", "stage_name": "stageName"},
    )
    class StageKeyProperty:
        def __init__(
            self,
            *,
            rest_api_id: typing.Optional[builtins.str] = None,
            stage_name: typing.Optional[builtins.str] = None,
        ) -> None:
            """
            :param rest_api_id: ``CfnApiKey.StageKeyProperty.RestApiId``.
            :param stage_name: ``CfnApiKey.StageKeyProperty.StageName``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-apikey-stagekey.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if rest_api_id is not None:
                self._values["rest_api_id"] = rest_api_id
            if stage_name is not None:
                self._values["stage_name"] = stage_name

        @builtins.property
        def rest_api_id(self) -> typing.Optional[builtins.str]:
            """``CfnApiKey.StageKeyProperty.RestApiId``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-apikey-stagekey.html#cfn-apigateway-apikey-stagekey-restapiid
            """
            result = self._values.get("rest_api_id")
            return result

        @builtins.property
        def stage_name(self) -> typing.Optional[builtins.str]:
            """``CfnApiKey.StageKeyProperty.StageName``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-apikey-stagekey.html#cfn-apigateway-apikey-stagekey-stagename
            """
            result = self._values.get("stage_name")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "StageKeyProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.CfnApiKeyProps",
    jsii_struct_bases=[],
    name_mapping={
        "customer_id": "customerId",
        "description": "description",
        "enabled": "enabled",
        "generate_distinct_id": "generateDistinctId",
        "name": "name",
        "stage_keys": "stageKeys",
        "tags": "tags",
        "value": "value",
    },
)
class CfnApiKeyProps:
    def __init__(
        self,
        *,
        customer_id: typing.Optional[builtins.str] = None,
        description: typing.Optional[builtins.str] = None,
        enabled: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
        generate_distinct_id: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
        name: typing.Optional[builtins.str] = None,
        stage_keys: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union[CfnApiKey.StageKeyProperty, _IResolvable_a771d0ef]]]] = None,
        tags: typing.Optional[typing.List[_CfnTag_95fbdc29]] = None,
        value: typing.Optional[builtins.str] = None,
    ) -> None:
        """Properties for defining a ``AWS::ApiGateway::ApiKey``.

        :param customer_id: ``AWS::ApiGateway::ApiKey.CustomerId``.
        :param description: ``AWS::ApiGateway::ApiKey.Description``.
        :param enabled: ``AWS::ApiGateway::ApiKey.Enabled``.
        :param generate_distinct_id: ``AWS::ApiGateway::ApiKey.GenerateDistinctId``.
        :param name: ``AWS::ApiGateway::ApiKey.Name``.
        :param stage_keys: ``AWS::ApiGateway::ApiKey.StageKeys``.
        :param tags: ``AWS::ApiGateway::ApiKey.Tags``.
        :param value: ``AWS::ApiGateway::ApiKey.Value``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if customer_id is not None:
            self._values["customer_id"] = customer_id
        if description is not None:
            self._values["description"] = description
        if enabled is not None:
            self._values["enabled"] = enabled
        if generate_distinct_id is not None:
            self._values["generate_distinct_id"] = generate_distinct_id
        if name is not None:
            self._values["name"] = name
        if stage_keys is not None:
            self._values["stage_keys"] = stage_keys
        if tags is not None:
            self._values["tags"] = tags
        if value is not None:
            self._values["value"] = value

    @builtins.property
    def customer_id(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::ApiKey.CustomerId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html#cfn-apigateway-apikey-customerid
        """
        result = self._values.get("customer_id")
        return result

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::ApiKey.Description``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html#cfn-apigateway-apikey-description
        """
        result = self._values.get("description")
        return result

    @builtins.property
    def enabled(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
        """``AWS::ApiGateway::ApiKey.Enabled``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html#cfn-apigateway-apikey-enabled
        """
        result = self._values.get("enabled")
        return result

    @builtins.property
    def generate_distinct_id(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
        """``AWS::ApiGateway::ApiKey.GenerateDistinctId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html#cfn-apigateway-apikey-generatedistinctid
        """
        result = self._values.get("generate_distinct_id")
        return result

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::ApiKey.Name``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html#cfn-apigateway-apikey-name
        """
        result = self._values.get("name")
        return result

    @builtins.property
    def stage_keys(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union[CfnApiKey.StageKeyProperty, _IResolvable_a771d0ef]]]]:
        """``AWS::ApiGateway::ApiKey.StageKeys``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html#cfn-apigateway-apikey-stagekeys
        """
        result = self._values.get("stage_keys")
        return result

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_95fbdc29]]:
        """``AWS::ApiGateway::ApiKey.Tags``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html#cfn-apigateway-apikey-tags
        """
        result = self._values.get("tags")
        return result

    @builtins.property
    def value(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::ApiKey.Value``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html#cfn-apigateway-apikey-value
        """
        result = self._values.get("value")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnApiKeyProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_82c04a63)
class CfnApiMappingV2(
    _CfnResource_e0a482dc,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_apigateway.CfnApiMappingV2",
):
    """(deprecated) A CloudFormation ``AWS::ApiGatewayV2::ApiMapping``.

    :deprecated: moved to package aws-apigatewayv2

    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-apimapping.html
    :stability: deprecated
    :cloudformationResource: AWS::ApiGatewayV2::ApiMapping
    """

    def __init__(
        self,
        scope: _Construct_e78e779f,
        id: builtins.str,
        *,
        api_id: builtins.str,
        domain_name: builtins.str,
        stage: builtins.str,
        api_mapping_key: typing.Optional[builtins.str] = None,
    ) -> None:
        """(deprecated) Create a new ``AWS::ApiGatewayV2::ApiMapping``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param api_id: (deprecated) ``AWS::ApiGatewayV2::ApiMapping.ApiId``.
        :param domain_name: (deprecated) ``AWS::ApiGatewayV2::ApiMapping.DomainName``.
        :param stage: (deprecated) ``AWS::ApiGatewayV2::ApiMapping.Stage``.
        :param api_mapping_key: (deprecated) ``AWS::ApiGatewayV2::ApiMapping.ApiMappingKey``.

        :stability: deprecated
        """
        props = CfnApiMappingV2Props(
            api_id=api_id,
            domain_name=domain_name,
            stage=stage,
            api_mapping_key=api_mapping_key,
        )

        jsii.create(CfnApiMappingV2, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_1cd1894e) -> None:
        """(experimental) Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -

        :stability: deprecated
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """(deprecated) The CloudFormation resource type name for this resource class.

        :stability: deprecated
        """
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :stability: deprecated
        """
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiId")
    def api_id(self) -> builtins.str:
        """(deprecated) ``AWS::ApiGatewayV2::ApiMapping.ApiId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-apimapping.html#cfn-apigatewayv2-apimapping-apiid
        :stability: deprecated
        """
        return jsii.get(self, "apiId")

    @api_id.setter # type: ignore
    def api_id(self, value: builtins.str) -> None:
        jsii.set(self, "apiId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="domainName")
    def domain_name(self) -> builtins.str:
        """(deprecated) ``AWS::ApiGatewayV2::ApiMapping.DomainName``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-apimapping.html#cfn-apigatewayv2-apimapping-domainname
        :stability: deprecated
        """
        return jsii.get(self, "domainName")

    @domain_name.setter # type: ignore
    def domain_name(self, value: builtins.str) -> None:
        jsii.set(self, "domainName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="stage")
    def stage(self) -> builtins.str:
        """(deprecated) ``AWS::ApiGatewayV2::ApiMapping.Stage``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-apimapping.html#cfn-apigatewayv2-apimapping-stage
        :stability: deprecated
        """
        return jsii.get(self, "stage")

    @stage.setter # type: ignore
    def stage(self, value: builtins.str) -> None:
        jsii.set(self, "stage", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiMappingKey")
    def api_mapping_key(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::ApiMapping.ApiMappingKey``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-apimapping.html#cfn-apigatewayv2-apimapping-apimappingkey
        :stability: deprecated
        """
        return jsii.get(self, "apiMappingKey")

    @api_mapping_key.setter # type: ignore
    def api_mapping_key(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "apiMappingKey", value)


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.CfnApiMappingV2Props",
    jsii_struct_bases=[],
    name_mapping={
        "api_id": "apiId",
        "domain_name": "domainName",
        "stage": "stage",
        "api_mapping_key": "apiMappingKey",
    },
)
class CfnApiMappingV2Props:
    def __init__(
        self,
        *,
        api_id: builtins.str,
        domain_name: builtins.str,
        stage: builtins.str,
        api_mapping_key: typing.Optional[builtins.str] = None,
    ) -> None:
        """(deprecated) Properties for defining a ``AWS::ApiGatewayV2::ApiMapping``.

        :param api_id: (deprecated) ``AWS::ApiGatewayV2::ApiMapping.ApiId``.
        :param domain_name: (deprecated) ``AWS::ApiGatewayV2::ApiMapping.DomainName``.
        :param stage: (deprecated) ``AWS::ApiGatewayV2::ApiMapping.Stage``.
        :param api_mapping_key: (deprecated) ``AWS::ApiGatewayV2::ApiMapping.ApiMappingKey``.

        :deprecated: moved to package aws-apigatewayv2

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-apimapping.html
        :stability: deprecated
        """
        self._values: typing.Dict[str, typing.Any] = {
            "api_id": api_id,
            "domain_name": domain_name,
            "stage": stage,
        }
        if api_mapping_key is not None:
            self._values["api_mapping_key"] = api_mapping_key

    @builtins.property
    def api_id(self) -> builtins.str:
        """(deprecated) ``AWS::ApiGatewayV2::ApiMapping.ApiId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-apimapping.html#cfn-apigatewayv2-apimapping-apiid
        :stability: deprecated
        """
        result = self._values.get("api_id")
        assert result is not None, "Required property 'api_id' is missing"
        return result

    @builtins.property
    def domain_name(self) -> builtins.str:
        """(deprecated) ``AWS::ApiGatewayV2::ApiMapping.DomainName``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-apimapping.html#cfn-apigatewayv2-apimapping-domainname
        :stability: deprecated
        """
        result = self._values.get("domain_name")
        assert result is not None, "Required property 'domain_name' is missing"
        return result

    @builtins.property
    def stage(self) -> builtins.str:
        """(deprecated) ``AWS::ApiGatewayV2::ApiMapping.Stage``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-apimapping.html#cfn-apigatewayv2-apimapping-stage
        :stability: deprecated
        """
        result = self._values.get("stage")
        assert result is not None, "Required property 'stage' is missing"
        return result

    @builtins.property
    def api_mapping_key(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::ApiMapping.ApiMappingKey``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-apimapping.html#cfn-apigatewayv2-apimapping-apimappingkey
        :stability: deprecated
        """
        result = self._values.get("api_mapping_key")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnApiMappingV2Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_82c04a63)
class CfnApiV2(
    _CfnResource_e0a482dc,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_apigateway.CfnApiV2",
):
    """(deprecated) A CloudFormation ``AWS::ApiGatewayV2::Api``.

    :deprecated: moved to package aws-apigatewayv2

    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html
    :stability: deprecated
    :cloudformationResource: AWS::ApiGatewayV2::Api
    """

    def __init__(
        self,
        scope: _Construct_e78e779f,
        id: builtins.str,
        *,
        api_key_selection_expression: typing.Optional[builtins.str] = None,
        base_path: typing.Optional[builtins.str] = None,
        body: typing.Any = None,
        body_s3_location: typing.Optional[typing.Union["CfnApiV2.BodyS3LocationProperty", _IResolvable_a771d0ef]] = None,
        cors_configuration: typing.Optional[typing.Union["CfnApiV2.CorsProperty", _IResolvable_a771d0ef]] = None,
        credentials_arn: typing.Optional[builtins.str] = None,
        description: typing.Optional[builtins.str] = None,
        disable_schema_validation: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
        fail_on_warnings: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
        name: typing.Optional[builtins.str] = None,
        protocol_type: typing.Optional[builtins.str] = None,
        route_key: typing.Optional[builtins.str] = None,
        route_selection_expression: typing.Optional[builtins.str] = None,
        tags: typing.Any = None,
        target: typing.Optional[builtins.str] = None,
        version: typing.Optional[builtins.str] = None,
    ) -> None:
        """(deprecated) Create a new ``AWS::ApiGatewayV2::Api``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param api_key_selection_expression: (deprecated) ``AWS::ApiGatewayV2::Api.ApiKeySelectionExpression``.
        :param base_path: (deprecated) ``AWS::ApiGatewayV2::Api.BasePath``.
        :param body: (deprecated) ``AWS::ApiGatewayV2::Api.Body``.
        :param body_s3_location: (deprecated) ``AWS::ApiGatewayV2::Api.BodyS3Location``.
        :param cors_configuration: (deprecated) ``AWS::ApiGatewayV2::Api.CorsConfiguration``.
        :param credentials_arn: (deprecated) ``AWS::ApiGatewayV2::Api.CredentialsArn``.
        :param description: (deprecated) ``AWS::ApiGatewayV2::Api.Description``.
        :param disable_schema_validation: (deprecated) ``AWS::ApiGatewayV2::Api.DisableSchemaValidation``.
        :param fail_on_warnings: (deprecated) ``AWS::ApiGatewayV2::Api.FailOnWarnings``.
        :param name: (deprecated) ``AWS::ApiGatewayV2::Api.Name``.
        :param protocol_type: (deprecated) ``AWS::ApiGatewayV2::Api.ProtocolType``.
        :param route_key: (deprecated) ``AWS::ApiGatewayV2::Api.RouteKey``.
        :param route_selection_expression: (deprecated) ``AWS::ApiGatewayV2::Api.RouteSelectionExpression``.
        :param tags: (deprecated) ``AWS::ApiGatewayV2::Api.Tags``.
        :param target: (deprecated) ``AWS::ApiGatewayV2::Api.Target``.
        :param version: (deprecated) ``AWS::ApiGatewayV2::Api.Version``.

        :stability: deprecated
        """
        props = CfnApiV2Props(
            api_key_selection_expression=api_key_selection_expression,
            base_path=base_path,
            body=body,
            body_s3_location=body_s3_location,
            cors_configuration=cors_configuration,
            credentials_arn=credentials_arn,
            description=description,
            disable_schema_validation=disable_schema_validation,
            fail_on_warnings=fail_on_warnings,
            name=name,
            protocol_type=protocol_type,
            route_key=route_key,
            route_selection_expression=route_selection_expression,
            tags=tags,
            target=target,
            version=version,
        )

        jsii.create(CfnApiV2, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_1cd1894e) -> None:
        """(experimental) Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -

        :stability: deprecated
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """(deprecated) The CloudFormation resource type name for this resource class.

        :stability: deprecated
        """
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :stability: deprecated
        """
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_0b7ab120:
        """(deprecated) ``AWS::ApiGatewayV2::Api.Tags``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-tags
        :stability: deprecated
        """
        return jsii.get(self, "tags")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="body")
    def body(self) -> typing.Any:
        """(deprecated) ``AWS::ApiGatewayV2::Api.Body``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-body
        :stability: deprecated
        """
        return jsii.get(self, "body")

    @body.setter # type: ignore
    def body(self, value: typing.Any) -> None:
        jsii.set(self, "body", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiKeySelectionExpression")
    def api_key_selection_expression(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Api.ApiKeySelectionExpression``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-apikeyselectionexpression
        :stability: deprecated
        """
        return jsii.get(self, "apiKeySelectionExpression")

    @api_key_selection_expression.setter # type: ignore
    def api_key_selection_expression(
        self,
        value: typing.Optional[builtins.str],
    ) -> None:
        jsii.set(self, "apiKeySelectionExpression", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="basePath")
    def base_path(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Api.BasePath``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-basepath
        :stability: deprecated
        """
        return jsii.get(self, "basePath")

    @base_path.setter # type: ignore
    def base_path(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "basePath", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="bodyS3Location")
    def body_s3_location(
        self,
    ) -> typing.Optional[typing.Union["CfnApiV2.BodyS3LocationProperty", _IResolvable_a771d0ef]]:
        """(deprecated) ``AWS::ApiGatewayV2::Api.BodyS3Location``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-bodys3location
        :stability: deprecated
        """
        return jsii.get(self, "bodyS3Location")

    @body_s3_location.setter # type: ignore
    def body_s3_location(
        self,
        value: typing.Optional[typing.Union["CfnApiV2.BodyS3LocationProperty", _IResolvable_a771d0ef]],
    ) -> None:
        jsii.set(self, "bodyS3Location", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="corsConfiguration")
    def cors_configuration(
        self,
    ) -> typing.Optional[typing.Union["CfnApiV2.CorsProperty", _IResolvable_a771d0ef]]:
        """(deprecated) ``AWS::ApiGatewayV2::Api.CorsConfiguration``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-corsconfiguration
        :stability: deprecated
        """
        return jsii.get(self, "corsConfiguration")

    @cors_configuration.setter # type: ignore
    def cors_configuration(
        self,
        value: typing.Optional[typing.Union["CfnApiV2.CorsProperty", _IResolvable_a771d0ef]],
    ) -> None:
        jsii.set(self, "corsConfiguration", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="credentialsArn")
    def credentials_arn(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Api.CredentialsArn``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-credentialsarn
        :stability: deprecated
        """
        return jsii.get(self, "credentialsArn")

    @credentials_arn.setter # type: ignore
    def credentials_arn(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "credentialsArn", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Api.Description``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-description
        :stability: deprecated
        """
        return jsii.get(self, "description")

    @description.setter # type: ignore
    def description(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "description", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="disableSchemaValidation")
    def disable_schema_validation(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
        """(deprecated) ``AWS::ApiGatewayV2::Api.DisableSchemaValidation``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-disableschemavalidation
        :stability: deprecated
        """
        return jsii.get(self, "disableSchemaValidation")

    @disable_schema_validation.setter # type: ignore
    def disable_schema_validation(
        self,
        value: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]],
    ) -> None:
        jsii.set(self, "disableSchemaValidation", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="failOnWarnings")
    def fail_on_warnings(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
        """(deprecated) ``AWS::ApiGatewayV2::Api.FailOnWarnings``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-failonwarnings
        :stability: deprecated
        """
        return jsii.get(self, "failOnWarnings")

    @fail_on_warnings.setter # type: ignore
    def fail_on_warnings(
        self,
        value: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]],
    ) -> None:
        jsii.set(self, "failOnWarnings", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="name")
    def name(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Api.Name``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-name
        :stability: deprecated
        """
        return jsii.get(self, "name")

    @name.setter # type: ignore
    def name(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "name", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="protocolType")
    def protocol_type(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Api.ProtocolType``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-protocoltype
        :stability: deprecated
        """
        return jsii.get(self, "protocolType")

    @protocol_type.setter # type: ignore
    def protocol_type(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "protocolType", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="routeKey")
    def route_key(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Api.RouteKey``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-routekey
        :stability: deprecated
        """
        return jsii.get(self, "routeKey")

    @route_key.setter # type: ignore
    def route_key(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "routeKey", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="routeSelectionExpression")
    def route_selection_expression(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Api.RouteSelectionExpression``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-routeselectionexpression
        :stability: deprecated
        """
        return jsii.get(self, "routeSelectionExpression")

    @route_selection_expression.setter # type: ignore
    def route_selection_expression(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "routeSelectionExpression", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="target")
    def target(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Api.Target``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-target
        :stability: deprecated
        """
        return jsii.get(self, "target")

    @target.setter # type: ignore
    def target(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "target", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="version")
    def version(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Api.Version``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-version
        :stability: deprecated
        """
        return jsii.get(self, "version")

    @version.setter # type: ignore
    def version(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "version", value)

    @jsii.data_type(
        jsii_type="monocdk.aws_apigateway.CfnApiV2.BodyS3LocationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "bucket": "bucket",
            "etag": "etag",
            "key": "key",
            "version": "version",
        },
    )
    class BodyS3LocationProperty:
        def __init__(
            self,
            *,
            bucket: typing.Optional[builtins.str] = None,
            etag: typing.Optional[builtins.str] = None,
            key: typing.Optional[builtins.str] = None,
            version: typing.Optional[builtins.str] = None,
        ) -> None:
            """
            :param bucket: (deprecated) ``CfnApiV2.BodyS3LocationProperty.Bucket``.
            :param etag: (deprecated) ``CfnApiV2.BodyS3LocationProperty.Etag``.
            :param key: (deprecated) ``CfnApiV2.BodyS3LocationProperty.Key``.
            :param version: (deprecated) ``CfnApiV2.BodyS3LocationProperty.Version``.

            :deprecated: moved to package aws-apigatewayv2

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-api-bodys3location.html
            :stability: deprecated
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if bucket is not None:
                self._values["bucket"] = bucket
            if etag is not None:
                self._values["etag"] = etag
            if key is not None:
                self._values["key"] = key
            if version is not None:
                self._values["version"] = version

        @builtins.property
        def bucket(self) -> typing.Optional[builtins.str]:
            """(deprecated) ``CfnApiV2.BodyS3LocationProperty.Bucket``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-api-bodys3location.html#cfn-apigatewayv2-api-bodys3location-bucket
            :stability: deprecated
            """
            result = self._values.get("bucket")
            return result

        @builtins.property
        def etag(self) -> typing.Optional[builtins.str]:
            """(deprecated) ``CfnApiV2.BodyS3LocationProperty.Etag``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-api-bodys3location.html#cfn-apigatewayv2-api-bodys3location-etag
            :stability: deprecated
            """
            result = self._values.get("etag")
            return result

        @builtins.property
        def key(self) -> typing.Optional[builtins.str]:
            """(deprecated) ``CfnApiV2.BodyS3LocationProperty.Key``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-api-bodys3location.html#cfn-apigatewayv2-api-bodys3location-key
            :stability: deprecated
            """
            result = self._values.get("key")
            return result

        @builtins.property
        def version(self) -> typing.Optional[builtins.str]:
            """(deprecated) ``CfnApiV2.BodyS3LocationProperty.Version``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-api-bodys3location.html#cfn-apigatewayv2-api-bodys3location-version
            :stability: deprecated
            """
            result = self._values.get("version")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "BodyS3LocationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_apigateway.CfnApiV2.CorsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "allow_credentials": "allowCredentials",
            "allow_headers": "allowHeaders",
            "allow_methods": "allowMethods",
            "allow_origins": "allowOrigins",
            "expose_headers": "exposeHeaders",
            "max_age": "maxAge",
        },
    )
    class CorsProperty:
        def __init__(
            self,
            *,
            allow_credentials: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
            allow_headers: typing.Optional[typing.List[builtins.str]] = None,
            allow_methods: typing.Optional[typing.List[builtins.str]] = None,
            allow_origins: typing.Optional[typing.List[builtins.str]] = None,
            expose_headers: typing.Optional[typing.List[builtins.str]] = None,
            max_age: typing.Optional[jsii.Number] = None,
        ) -> None:
            """
            :param allow_credentials: (deprecated) ``CfnApiV2.CorsProperty.AllowCredentials``.
            :param allow_headers: (deprecated) ``CfnApiV2.CorsProperty.AllowHeaders``.
            :param allow_methods: (deprecated) ``CfnApiV2.CorsProperty.AllowMethods``.
            :param allow_origins: (deprecated) ``CfnApiV2.CorsProperty.AllowOrigins``.
            :param expose_headers: (deprecated) ``CfnApiV2.CorsProperty.ExposeHeaders``.
            :param max_age: (deprecated) ``CfnApiV2.CorsProperty.MaxAge``.

            :deprecated: moved to package aws-apigatewayv2

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-api-cors.html
            :stability: deprecated
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if allow_credentials is not None:
                self._values["allow_credentials"] = allow_credentials
            if allow_headers is not None:
                self._values["allow_headers"] = allow_headers
            if allow_methods is not None:
                self._values["allow_methods"] = allow_methods
            if allow_origins is not None:
                self._values["allow_origins"] = allow_origins
            if expose_headers is not None:
                self._values["expose_headers"] = expose_headers
            if max_age is not None:
                self._values["max_age"] = max_age

        @builtins.property
        def allow_credentials(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
            """(deprecated) ``CfnApiV2.CorsProperty.AllowCredentials``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-api-cors.html#cfn-apigatewayv2-api-cors-allowcredentials
            :stability: deprecated
            """
            result = self._values.get("allow_credentials")
            return result

        @builtins.property
        def allow_headers(self) -> typing.Optional[typing.List[builtins.str]]:
            """(deprecated) ``CfnApiV2.CorsProperty.AllowHeaders``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-api-cors.html#cfn-apigatewayv2-api-cors-allowheaders
            :stability: deprecated
            """
            result = self._values.get("allow_headers")
            return result

        @builtins.property
        def allow_methods(self) -> typing.Optional[typing.List[builtins.str]]:
            """(deprecated) ``CfnApiV2.CorsProperty.AllowMethods``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-api-cors.html#cfn-apigatewayv2-api-cors-allowmethods
            :stability: deprecated
            """
            result = self._values.get("allow_methods")
            return result

        @builtins.property
        def allow_origins(self) -> typing.Optional[typing.List[builtins.str]]:
            """(deprecated) ``CfnApiV2.CorsProperty.AllowOrigins``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-api-cors.html#cfn-apigatewayv2-api-cors-alloworigins
            :stability: deprecated
            """
            result = self._values.get("allow_origins")
            return result

        @builtins.property
        def expose_headers(self) -> typing.Optional[typing.List[builtins.str]]:
            """(deprecated) ``CfnApiV2.CorsProperty.ExposeHeaders``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-api-cors.html#cfn-apigatewayv2-api-cors-exposeheaders
            :stability: deprecated
            """
            result = self._values.get("expose_headers")
            return result

        @builtins.property
        def max_age(self) -> typing.Optional[jsii.Number]:
            """(deprecated) ``CfnApiV2.CorsProperty.MaxAge``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-api-cors.html#cfn-apigatewayv2-api-cors-maxage
            :stability: deprecated
            """
            result = self._values.get("max_age")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CorsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.CfnApiV2Props",
    jsii_struct_bases=[],
    name_mapping={
        "api_key_selection_expression": "apiKeySelectionExpression",
        "base_path": "basePath",
        "body": "body",
        "body_s3_location": "bodyS3Location",
        "cors_configuration": "corsConfiguration",
        "credentials_arn": "credentialsArn",
        "description": "description",
        "disable_schema_validation": "disableSchemaValidation",
        "fail_on_warnings": "failOnWarnings",
        "name": "name",
        "protocol_type": "protocolType",
        "route_key": "routeKey",
        "route_selection_expression": "routeSelectionExpression",
        "tags": "tags",
        "target": "target",
        "version": "version",
    },
)
class CfnApiV2Props:
    def __init__(
        self,
        *,
        api_key_selection_expression: typing.Optional[builtins.str] = None,
        base_path: typing.Optional[builtins.str] = None,
        body: typing.Any = None,
        body_s3_location: typing.Optional[typing.Union[CfnApiV2.BodyS3LocationProperty, _IResolvable_a771d0ef]] = None,
        cors_configuration: typing.Optional[typing.Union[CfnApiV2.CorsProperty, _IResolvable_a771d0ef]] = None,
        credentials_arn: typing.Optional[builtins.str] = None,
        description: typing.Optional[builtins.str] = None,
        disable_schema_validation: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
        fail_on_warnings: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
        name: typing.Optional[builtins.str] = None,
        protocol_type: typing.Optional[builtins.str] = None,
        route_key: typing.Optional[builtins.str] = None,
        route_selection_expression: typing.Optional[builtins.str] = None,
        tags: typing.Any = None,
        target: typing.Optional[builtins.str] = None,
        version: typing.Optional[builtins.str] = None,
    ) -> None:
        """(deprecated) Properties for defining a ``AWS::ApiGatewayV2::Api``.

        :param api_key_selection_expression: (deprecated) ``AWS::ApiGatewayV2::Api.ApiKeySelectionExpression``.
        :param base_path: (deprecated) ``AWS::ApiGatewayV2::Api.BasePath``.
        :param body: (deprecated) ``AWS::ApiGatewayV2::Api.Body``.
        :param body_s3_location: (deprecated) ``AWS::ApiGatewayV2::Api.BodyS3Location``.
        :param cors_configuration: (deprecated) ``AWS::ApiGatewayV2::Api.CorsConfiguration``.
        :param credentials_arn: (deprecated) ``AWS::ApiGatewayV2::Api.CredentialsArn``.
        :param description: (deprecated) ``AWS::ApiGatewayV2::Api.Description``.
        :param disable_schema_validation: (deprecated) ``AWS::ApiGatewayV2::Api.DisableSchemaValidation``.
        :param fail_on_warnings: (deprecated) ``AWS::ApiGatewayV2::Api.FailOnWarnings``.
        :param name: (deprecated) ``AWS::ApiGatewayV2::Api.Name``.
        :param protocol_type: (deprecated) ``AWS::ApiGatewayV2::Api.ProtocolType``.
        :param route_key: (deprecated) ``AWS::ApiGatewayV2::Api.RouteKey``.
        :param route_selection_expression: (deprecated) ``AWS::ApiGatewayV2::Api.RouteSelectionExpression``.
        :param tags: (deprecated) ``AWS::ApiGatewayV2::Api.Tags``.
        :param target: (deprecated) ``AWS::ApiGatewayV2::Api.Target``.
        :param version: (deprecated) ``AWS::ApiGatewayV2::Api.Version``.

        :deprecated: moved to package aws-apigatewayv2

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html
        :stability: deprecated
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if api_key_selection_expression is not None:
            self._values["api_key_selection_expression"] = api_key_selection_expression
        if base_path is not None:
            self._values["base_path"] = base_path
        if body is not None:
            self._values["body"] = body
        if body_s3_location is not None:
            self._values["body_s3_location"] = body_s3_location
        if cors_configuration is not None:
            self._values["cors_configuration"] = cors_configuration
        if credentials_arn is not None:
            self._values["credentials_arn"] = credentials_arn
        if description is not None:
            self._values["description"] = description
        if disable_schema_validation is not None:
            self._values["disable_schema_validation"] = disable_schema_validation
        if fail_on_warnings is not None:
            self._values["fail_on_warnings"] = fail_on_warnings
        if name is not None:
            self._values["name"] = name
        if protocol_type is not None:
            self._values["protocol_type"] = protocol_type
        if route_key is not None:
            self._values["route_key"] = route_key
        if route_selection_expression is not None:
            self._values["route_selection_expression"] = route_selection_expression
        if tags is not None:
            self._values["tags"] = tags
        if target is not None:
            self._values["target"] = target
        if version is not None:
            self._values["version"] = version

    @builtins.property
    def api_key_selection_expression(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Api.ApiKeySelectionExpression``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-apikeyselectionexpression
        :stability: deprecated
        """
        result = self._values.get("api_key_selection_expression")
        return result

    @builtins.property
    def base_path(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Api.BasePath``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-basepath
        :stability: deprecated
        """
        result = self._values.get("base_path")
        return result

    @builtins.property
    def body(self) -> typing.Any:
        """(deprecated) ``AWS::ApiGatewayV2::Api.Body``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-body
        :stability: deprecated
        """
        result = self._values.get("body")
        return result

    @builtins.property
    def body_s3_location(
        self,
    ) -> typing.Optional[typing.Union[CfnApiV2.BodyS3LocationProperty, _IResolvable_a771d0ef]]:
        """(deprecated) ``AWS::ApiGatewayV2::Api.BodyS3Location``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-bodys3location
        :stability: deprecated
        """
        result = self._values.get("body_s3_location")
        return result

    @builtins.property
    def cors_configuration(
        self,
    ) -> typing.Optional[typing.Union[CfnApiV2.CorsProperty, _IResolvable_a771d0ef]]:
        """(deprecated) ``AWS::ApiGatewayV2::Api.CorsConfiguration``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-corsconfiguration
        :stability: deprecated
        """
        result = self._values.get("cors_configuration")
        return result

    @builtins.property
    def credentials_arn(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Api.CredentialsArn``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-credentialsarn
        :stability: deprecated
        """
        result = self._values.get("credentials_arn")
        return result

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Api.Description``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-description
        :stability: deprecated
        """
        result = self._values.get("description")
        return result

    @builtins.property
    def disable_schema_validation(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
        """(deprecated) ``AWS::ApiGatewayV2::Api.DisableSchemaValidation``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-disableschemavalidation
        :stability: deprecated
        """
        result = self._values.get("disable_schema_validation")
        return result

    @builtins.property
    def fail_on_warnings(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
        """(deprecated) ``AWS::ApiGatewayV2::Api.FailOnWarnings``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-failonwarnings
        :stability: deprecated
        """
        result = self._values.get("fail_on_warnings")
        return result

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Api.Name``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-name
        :stability: deprecated
        """
        result = self._values.get("name")
        return result

    @builtins.property
    def protocol_type(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Api.ProtocolType``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-protocoltype
        :stability: deprecated
        """
        result = self._values.get("protocol_type")
        return result

    @builtins.property
    def route_key(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Api.RouteKey``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-routekey
        :stability: deprecated
        """
        result = self._values.get("route_key")
        return result

    @builtins.property
    def route_selection_expression(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Api.RouteSelectionExpression``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-routeselectionexpression
        :stability: deprecated
        """
        result = self._values.get("route_selection_expression")
        return result

    @builtins.property
    def tags(self) -> typing.Any:
        """(deprecated) ``AWS::ApiGatewayV2::Api.Tags``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-tags
        :stability: deprecated
        """
        result = self._values.get("tags")
        return result

    @builtins.property
    def target(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Api.Target``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-target
        :stability: deprecated
        """
        result = self._values.get("target")
        return result

    @builtins.property
    def version(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Api.Version``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-version
        :stability: deprecated
        """
        result = self._values.get("version")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnApiV2Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_82c04a63)
class CfnAuthorizer(
    _CfnResource_e0a482dc,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_apigateway.CfnAuthorizer",
):
    """A CloudFormation ``AWS::ApiGateway::Authorizer``.

    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html
    :cloudformationResource: AWS::ApiGateway::Authorizer
    """

    def __init__(
        self,
        scope: _Construct_e78e779f,
        id: builtins.str,
        *,
        rest_api_id: builtins.str,
        type: builtins.str,
        authorizer_credentials: typing.Optional[builtins.str] = None,
        authorizer_result_ttl_in_seconds: typing.Optional[jsii.Number] = None,
        authorizer_uri: typing.Optional[builtins.str] = None,
        auth_type: typing.Optional[builtins.str] = None,
        identity_source: typing.Optional[builtins.str] = None,
        identity_validation_expression: typing.Optional[builtins.str] = None,
        name: typing.Optional[builtins.str] = None,
        provider_arns: typing.Optional[typing.List[builtins.str]] = None,
    ) -> None:
        """Create a new ``AWS::ApiGateway::Authorizer``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param rest_api_id: ``AWS::ApiGateway::Authorizer.RestApiId``.
        :param type: ``AWS::ApiGateway::Authorizer.Type``.
        :param authorizer_credentials: ``AWS::ApiGateway::Authorizer.AuthorizerCredentials``.
        :param authorizer_result_ttl_in_seconds: ``AWS::ApiGateway::Authorizer.AuthorizerResultTtlInSeconds``.
        :param authorizer_uri: ``AWS::ApiGateway::Authorizer.AuthorizerUri``.
        :param auth_type: ``AWS::ApiGateway::Authorizer.AuthType``.
        :param identity_source: ``AWS::ApiGateway::Authorizer.IdentitySource``.
        :param identity_validation_expression: ``AWS::ApiGateway::Authorizer.IdentityValidationExpression``.
        :param name: ``AWS::ApiGateway::Authorizer.Name``.
        :param provider_arns: ``AWS::ApiGateway::Authorizer.ProviderARNs``.
        """
        props = CfnAuthorizerProps(
            rest_api_id=rest_api_id,
            type=type,
            authorizer_credentials=authorizer_credentials,
            authorizer_result_ttl_in_seconds=authorizer_result_ttl_in_seconds,
            authorizer_uri=authorizer_uri,
            auth_type=auth_type,
            identity_source=identity_source,
            identity_validation_expression=identity_validation_expression,
            name=name,
            provider_arns=provider_arns,
        )

        jsii.create(CfnAuthorizer, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_1cd1894e) -> None:
        """(experimental) Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="restApiId")
    def rest_api_id(self) -> builtins.str:
        """``AWS::ApiGateway::Authorizer.RestApiId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-restapiid
        """
        return jsii.get(self, "restApiId")

    @rest_api_id.setter # type: ignore
    def rest_api_id(self, value: builtins.str) -> None:
        jsii.set(self, "restApiId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="type")
    def type(self) -> builtins.str:
        """``AWS::ApiGateway::Authorizer.Type``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-type
        """
        return jsii.get(self, "type")

    @type.setter # type: ignore
    def type(self, value: builtins.str) -> None:
        jsii.set(self, "type", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="authorizerCredentials")
    def authorizer_credentials(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::Authorizer.AuthorizerCredentials``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-authorizercredentials
        """
        return jsii.get(self, "authorizerCredentials")

    @authorizer_credentials.setter # type: ignore
    def authorizer_credentials(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "authorizerCredentials", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="authorizerResultTtlInSeconds")
    def authorizer_result_ttl_in_seconds(self) -> typing.Optional[jsii.Number]:
        """``AWS::ApiGateway::Authorizer.AuthorizerResultTtlInSeconds``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-authorizerresultttlinseconds
        """
        return jsii.get(self, "authorizerResultTtlInSeconds")

    @authorizer_result_ttl_in_seconds.setter # type: ignore
    def authorizer_result_ttl_in_seconds(
        self,
        value: typing.Optional[jsii.Number],
    ) -> None:
        jsii.set(self, "authorizerResultTtlInSeconds", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="authorizerUri")
    def authorizer_uri(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::Authorizer.AuthorizerUri``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-authorizeruri
        """
        return jsii.get(self, "authorizerUri")

    @authorizer_uri.setter # type: ignore
    def authorizer_uri(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "authorizerUri", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="authType")
    def auth_type(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::Authorizer.AuthType``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-authtype
        """
        return jsii.get(self, "authType")

    @auth_type.setter # type: ignore
    def auth_type(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "authType", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="identitySource")
    def identity_source(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::Authorizer.IdentitySource``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-identitysource
        """
        return jsii.get(self, "identitySource")

    @identity_source.setter # type: ignore
    def identity_source(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "identitySource", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="identityValidationExpression")
    def identity_validation_expression(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::Authorizer.IdentityValidationExpression``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-identityvalidationexpression
        """
        return jsii.get(self, "identityValidationExpression")

    @identity_validation_expression.setter # type: ignore
    def identity_validation_expression(
        self,
        value: typing.Optional[builtins.str],
    ) -> None:
        jsii.set(self, "identityValidationExpression", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="name")
    def name(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::Authorizer.Name``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-name
        """
        return jsii.get(self, "name")

    @name.setter # type: ignore
    def name(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "name", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="providerArns")
    def provider_arns(self) -> typing.Optional[typing.List[builtins.str]]:
        """``AWS::ApiGateway::Authorizer.ProviderARNs``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-providerarns
        """
        return jsii.get(self, "providerArns")

    @provider_arns.setter # type: ignore
    def provider_arns(self, value: typing.Optional[typing.List[builtins.str]]) -> None:
        jsii.set(self, "providerArns", value)


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.CfnAuthorizerProps",
    jsii_struct_bases=[],
    name_mapping={
        "rest_api_id": "restApiId",
        "type": "type",
        "authorizer_credentials": "authorizerCredentials",
        "authorizer_result_ttl_in_seconds": "authorizerResultTtlInSeconds",
        "authorizer_uri": "authorizerUri",
        "auth_type": "authType",
        "identity_source": "identitySource",
        "identity_validation_expression": "identityValidationExpression",
        "name": "name",
        "provider_arns": "providerArns",
    },
)
class CfnAuthorizerProps:
    def __init__(
        self,
        *,
        rest_api_id: builtins.str,
        type: builtins.str,
        authorizer_credentials: typing.Optional[builtins.str] = None,
        authorizer_result_ttl_in_seconds: typing.Optional[jsii.Number] = None,
        authorizer_uri: typing.Optional[builtins.str] = None,
        auth_type: typing.Optional[builtins.str] = None,
        identity_source: typing.Optional[builtins.str] = None,
        identity_validation_expression: typing.Optional[builtins.str] = None,
        name: typing.Optional[builtins.str] = None,
        provider_arns: typing.Optional[typing.List[builtins.str]] = None,
    ) -> None:
        """Properties for defining a ``AWS::ApiGateway::Authorizer``.

        :param rest_api_id: ``AWS::ApiGateway::Authorizer.RestApiId``.
        :param type: ``AWS::ApiGateway::Authorizer.Type``.
        :param authorizer_credentials: ``AWS::ApiGateway::Authorizer.AuthorizerCredentials``.
        :param authorizer_result_ttl_in_seconds: ``AWS::ApiGateway::Authorizer.AuthorizerResultTtlInSeconds``.
        :param authorizer_uri: ``AWS::ApiGateway::Authorizer.AuthorizerUri``.
        :param auth_type: ``AWS::ApiGateway::Authorizer.AuthType``.
        :param identity_source: ``AWS::ApiGateway::Authorizer.IdentitySource``.
        :param identity_validation_expression: ``AWS::ApiGateway::Authorizer.IdentityValidationExpression``.
        :param name: ``AWS::ApiGateway::Authorizer.Name``.
        :param provider_arns: ``AWS::ApiGateway::Authorizer.ProviderARNs``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html
        """
        self._values: typing.Dict[str, typing.Any] = {
            "rest_api_id": rest_api_id,
            "type": type,
        }
        if authorizer_credentials is not None:
            self._values["authorizer_credentials"] = authorizer_credentials
        if authorizer_result_ttl_in_seconds is not None:
            self._values["authorizer_result_ttl_in_seconds"] = authorizer_result_ttl_in_seconds
        if authorizer_uri is not None:
            self._values["authorizer_uri"] = authorizer_uri
        if auth_type is not None:
            self._values["auth_type"] = auth_type
        if identity_source is not None:
            self._values["identity_source"] = identity_source
        if identity_validation_expression is not None:
            self._values["identity_validation_expression"] = identity_validation_expression
        if name is not None:
            self._values["name"] = name
        if provider_arns is not None:
            self._values["provider_arns"] = provider_arns

    @builtins.property
    def rest_api_id(self) -> builtins.str:
        """``AWS::ApiGateway::Authorizer.RestApiId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-restapiid
        """
        result = self._values.get("rest_api_id")
        assert result is not None, "Required property 'rest_api_id' is missing"
        return result

    @builtins.property
    def type(self) -> builtins.str:
        """``AWS::ApiGateway::Authorizer.Type``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-type
        """
        result = self._values.get("type")
        assert result is not None, "Required property 'type' is missing"
        return result

    @builtins.property
    def authorizer_credentials(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::Authorizer.AuthorizerCredentials``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-authorizercredentials
        """
        result = self._values.get("authorizer_credentials")
        return result

    @builtins.property
    def authorizer_result_ttl_in_seconds(self) -> typing.Optional[jsii.Number]:
        """``AWS::ApiGateway::Authorizer.AuthorizerResultTtlInSeconds``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-authorizerresultttlinseconds
        """
        result = self._values.get("authorizer_result_ttl_in_seconds")
        return result

    @builtins.property
    def authorizer_uri(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::Authorizer.AuthorizerUri``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-authorizeruri
        """
        result = self._values.get("authorizer_uri")
        return result

    @builtins.property
    def auth_type(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::Authorizer.AuthType``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-authtype
        """
        result = self._values.get("auth_type")
        return result

    @builtins.property
    def identity_source(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::Authorizer.IdentitySource``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-identitysource
        """
        result = self._values.get("identity_source")
        return result

    @builtins.property
    def identity_validation_expression(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::Authorizer.IdentityValidationExpression``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-identityvalidationexpression
        """
        result = self._values.get("identity_validation_expression")
        return result

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::Authorizer.Name``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-name
        """
        result = self._values.get("name")
        return result

    @builtins.property
    def provider_arns(self) -> typing.Optional[typing.List[builtins.str]]:
        """``AWS::ApiGateway::Authorizer.ProviderARNs``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-providerarns
        """
        result = self._values.get("provider_arns")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnAuthorizerProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_82c04a63)
class CfnAuthorizerV2(
    _CfnResource_e0a482dc,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_apigateway.CfnAuthorizerV2",
):
    """(deprecated) A CloudFormation ``AWS::ApiGatewayV2::Authorizer``.

    :deprecated: moved to package aws-apigatewayv2

    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html
    :stability: deprecated
    :cloudformationResource: AWS::ApiGatewayV2::Authorizer
    """

    def __init__(
        self,
        scope: _Construct_e78e779f,
        id: builtins.str,
        *,
        api_id: builtins.str,
        authorizer_type: builtins.str,
        identity_source: typing.List[builtins.str],
        name: builtins.str,
        authorizer_credentials_arn: typing.Optional[builtins.str] = None,
        authorizer_result_ttl_in_seconds: typing.Optional[jsii.Number] = None,
        authorizer_uri: typing.Optional[builtins.str] = None,
        identity_validation_expression: typing.Optional[builtins.str] = None,
        jwt_configuration: typing.Optional[typing.Union["CfnAuthorizerV2.JWTConfigurationProperty", _IResolvable_a771d0ef]] = None,
    ) -> None:
        """(deprecated) Create a new ``AWS::ApiGatewayV2::Authorizer``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param api_id: (deprecated) ``AWS::ApiGatewayV2::Authorizer.ApiId``.
        :param authorizer_type: (deprecated) ``AWS::ApiGatewayV2::Authorizer.AuthorizerType``.
        :param identity_source: (deprecated) ``AWS::ApiGatewayV2::Authorizer.IdentitySource``.
        :param name: (deprecated) ``AWS::ApiGatewayV2::Authorizer.Name``.
        :param authorizer_credentials_arn: (deprecated) ``AWS::ApiGatewayV2::Authorizer.AuthorizerCredentialsArn``.
        :param authorizer_result_ttl_in_seconds: (deprecated) ``AWS::ApiGatewayV2::Authorizer.AuthorizerResultTtlInSeconds``.
        :param authorizer_uri: (deprecated) ``AWS::ApiGatewayV2::Authorizer.AuthorizerUri``.
        :param identity_validation_expression: (deprecated) ``AWS::ApiGatewayV2::Authorizer.IdentityValidationExpression``.
        :param jwt_configuration: (deprecated) ``AWS::ApiGatewayV2::Authorizer.JwtConfiguration``.

        :stability: deprecated
        """
        props = CfnAuthorizerV2Props(
            api_id=api_id,
            authorizer_type=authorizer_type,
            identity_source=identity_source,
            name=name,
            authorizer_credentials_arn=authorizer_credentials_arn,
            authorizer_result_ttl_in_seconds=authorizer_result_ttl_in_seconds,
            authorizer_uri=authorizer_uri,
            identity_validation_expression=identity_validation_expression,
            jwt_configuration=jwt_configuration,
        )

        jsii.create(CfnAuthorizerV2, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_1cd1894e) -> None:
        """(experimental) Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -

        :stability: deprecated
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """(deprecated) The CloudFormation resource type name for this resource class.

        :stability: deprecated
        """
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :stability: deprecated
        """
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiId")
    def api_id(self) -> builtins.str:
        """(deprecated) ``AWS::ApiGatewayV2::Authorizer.ApiId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-apiid
        :stability: deprecated
        """
        return jsii.get(self, "apiId")

    @api_id.setter # type: ignore
    def api_id(self, value: builtins.str) -> None:
        jsii.set(self, "apiId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="authorizerType")
    def authorizer_type(self) -> builtins.str:
        """(deprecated) ``AWS::ApiGatewayV2::Authorizer.AuthorizerType``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-authorizertype
        :stability: deprecated
        """
        return jsii.get(self, "authorizerType")

    @authorizer_type.setter # type: ignore
    def authorizer_type(self, value: builtins.str) -> None:
        jsii.set(self, "authorizerType", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="identitySource")
    def identity_source(self) -> typing.List[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Authorizer.IdentitySource``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-identitysource
        :stability: deprecated
        """
        return jsii.get(self, "identitySource")

    @identity_source.setter # type: ignore
    def identity_source(self, value: typing.List[builtins.str]) -> None:
        jsii.set(self, "identitySource", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        """(deprecated) ``AWS::ApiGatewayV2::Authorizer.Name``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-name
        :stability: deprecated
        """
        return jsii.get(self, "name")

    @name.setter # type: ignore
    def name(self, value: builtins.str) -> None:
        jsii.set(self, "name", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="authorizerCredentialsArn")
    def authorizer_credentials_arn(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Authorizer.AuthorizerCredentialsArn``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-authorizercredentialsarn
        :stability: deprecated
        """
        return jsii.get(self, "authorizerCredentialsArn")

    @authorizer_credentials_arn.setter # type: ignore
    def authorizer_credentials_arn(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "authorizerCredentialsArn", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="authorizerResultTtlInSeconds")
    def authorizer_result_ttl_in_seconds(self) -> typing.Optional[jsii.Number]:
        """(deprecated) ``AWS::ApiGatewayV2::Authorizer.AuthorizerResultTtlInSeconds``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-authorizerresultttlinseconds
        :stability: deprecated
        """
        return jsii.get(self, "authorizerResultTtlInSeconds")

    @authorizer_result_ttl_in_seconds.setter # type: ignore
    def authorizer_result_ttl_in_seconds(
        self,
        value: typing.Optional[jsii.Number],
    ) -> None:
        jsii.set(self, "authorizerResultTtlInSeconds", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="authorizerUri")
    def authorizer_uri(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Authorizer.AuthorizerUri``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-authorizeruri
        :stability: deprecated
        """
        return jsii.get(self, "authorizerUri")

    @authorizer_uri.setter # type: ignore
    def authorizer_uri(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "authorizerUri", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="identityValidationExpression")
    def identity_validation_expression(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Authorizer.IdentityValidationExpression``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-identityvalidationexpression
        :stability: deprecated
        """
        return jsii.get(self, "identityValidationExpression")

    @identity_validation_expression.setter # type: ignore
    def identity_validation_expression(
        self,
        value: typing.Optional[builtins.str],
    ) -> None:
        jsii.set(self, "identityValidationExpression", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="jwtConfiguration")
    def jwt_configuration(
        self,
    ) -> typing.Optional[typing.Union["CfnAuthorizerV2.JWTConfigurationProperty", _IResolvable_a771d0ef]]:
        """(deprecated) ``AWS::ApiGatewayV2::Authorizer.JwtConfiguration``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-jwtconfiguration
        :stability: deprecated
        """
        return jsii.get(self, "jwtConfiguration")

    @jwt_configuration.setter # type: ignore
    def jwt_configuration(
        self,
        value: typing.Optional[typing.Union["CfnAuthorizerV2.JWTConfigurationProperty", _IResolvable_a771d0ef]],
    ) -> None:
        jsii.set(self, "jwtConfiguration", value)

    @jsii.data_type(
        jsii_type="monocdk.aws_apigateway.CfnAuthorizerV2.JWTConfigurationProperty",
        jsii_struct_bases=[],
        name_mapping={"audience": "audience", "issuer": "issuer"},
    )
    class JWTConfigurationProperty:
        def __init__(
            self,
            *,
            audience: typing.Optional[typing.List[builtins.str]] = None,
            issuer: typing.Optional[builtins.str] = None,
        ) -> None:
            """
            :param audience: (deprecated) ``CfnAuthorizerV2.JWTConfigurationProperty.Audience``.
            :param issuer: (deprecated) ``CfnAuthorizerV2.JWTConfigurationProperty.Issuer``.

            :deprecated: moved to package aws-apigatewayv2

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-authorizer-jwtconfiguration.html
            :stability: deprecated
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if audience is not None:
                self._values["audience"] = audience
            if issuer is not None:
                self._values["issuer"] = issuer

        @builtins.property
        def audience(self) -> typing.Optional[typing.List[builtins.str]]:
            """(deprecated) ``CfnAuthorizerV2.JWTConfigurationProperty.Audience``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-authorizer-jwtconfiguration.html#cfn-apigatewayv2-authorizer-jwtconfiguration-audience
            :stability: deprecated
            """
            result = self._values.get("audience")
            return result

        @builtins.property
        def issuer(self) -> typing.Optional[builtins.str]:
            """(deprecated) ``CfnAuthorizerV2.JWTConfigurationProperty.Issuer``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-authorizer-jwtconfiguration.html#cfn-apigatewayv2-authorizer-jwtconfiguration-issuer
            :stability: deprecated
            """
            result = self._values.get("issuer")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "JWTConfigurationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.CfnAuthorizerV2Props",
    jsii_struct_bases=[],
    name_mapping={
        "api_id": "apiId",
        "authorizer_type": "authorizerType",
        "identity_source": "identitySource",
        "name": "name",
        "authorizer_credentials_arn": "authorizerCredentialsArn",
        "authorizer_result_ttl_in_seconds": "authorizerResultTtlInSeconds",
        "authorizer_uri": "authorizerUri",
        "identity_validation_expression": "identityValidationExpression",
        "jwt_configuration": "jwtConfiguration",
    },
)
class CfnAuthorizerV2Props:
    def __init__(
        self,
        *,
        api_id: builtins.str,
        authorizer_type: builtins.str,
        identity_source: typing.List[builtins.str],
        name: builtins.str,
        authorizer_credentials_arn: typing.Optional[builtins.str] = None,
        authorizer_result_ttl_in_seconds: typing.Optional[jsii.Number] = None,
        authorizer_uri: typing.Optional[builtins.str] = None,
        identity_validation_expression: typing.Optional[builtins.str] = None,
        jwt_configuration: typing.Optional[typing.Union[CfnAuthorizerV2.JWTConfigurationProperty, _IResolvable_a771d0ef]] = None,
    ) -> None:
        """(deprecated) Properties for defining a ``AWS::ApiGatewayV2::Authorizer``.

        :param api_id: (deprecated) ``AWS::ApiGatewayV2::Authorizer.ApiId``.
        :param authorizer_type: (deprecated) ``AWS::ApiGatewayV2::Authorizer.AuthorizerType``.
        :param identity_source: (deprecated) ``AWS::ApiGatewayV2::Authorizer.IdentitySource``.
        :param name: (deprecated) ``AWS::ApiGatewayV2::Authorizer.Name``.
        :param authorizer_credentials_arn: (deprecated) ``AWS::ApiGatewayV2::Authorizer.AuthorizerCredentialsArn``.
        :param authorizer_result_ttl_in_seconds: (deprecated) ``AWS::ApiGatewayV2::Authorizer.AuthorizerResultTtlInSeconds``.
        :param authorizer_uri: (deprecated) ``AWS::ApiGatewayV2::Authorizer.AuthorizerUri``.
        :param identity_validation_expression: (deprecated) ``AWS::ApiGatewayV2::Authorizer.IdentityValidationExpression``.
        :param jwt_configuration: (deprecated) ``AWS::ApiGatewayV2::Authorizer.JwtConfiguration``.

        :deprecated: moved to package aws-apigatewayv2

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html
        :stability: deprecated
        """
        self._values: typing.Dict[str, typing.Any] = {
            "api_id": api_id,
            "authorizer_type": authorizer_type,
            "identity_source": identity_source,
            "name": name,
        }
        if authorizer_credentials_arn is not None:
            self._values["authorizer_credentials_arn"] = authorizer_credentials_arn
        if authorizer_result_ttl_in_seconds is not None:
            self._values["authorizer_result_ttl_in_seconds"] = authorizer_result_ttl_in_seconds
        if authorizer_uri is not None:
            self._values["authorizer_uri"] = authorizer_uri
        if identity_validation_expression is not None:
            self._values["identity_validation_expression"] = identity_validation_expression
        if jwt_configuration is not None:
            self._values["jwt_configuration"] = jwt_configuration

    @builtins.property
    def api_id(self) -> builtins.str:
        """(deprecated) ``AWS::ApiGatewayV2::Authorizer.ApiId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-apiid
        :stability: deprecated
        """
        result = self._values.get("api_id")
        assert result is not None, "Required property 'api_id' is missing"
        return result

    @builtins.property
    def authorizer_type(self) -> builtins.str:
        """(deprecated) ``AWS::ApiGatewayV2::Authorizer.AuthorizerType``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-authorizertype
        :stability: deprecated
        """
        result = self._values.get("authorizer_type")
        assert result is not None, "Required property 'authorizer_type' is missing"
        return result

    @builtins.property
    def identity_source(self) -> typing.List[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Authorizer.IdentitySource``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-identitysource
        :stability: deprecated
        """
        result = self._values.get("identity_source")
        assert result is not None, "Required property 'identity_source' is missing"
        return result

    @builtins.property
    def name(self) -> builtins.str:
        """(deprecated) ``AWS::ApiGatewayV2::Authorizer.Name``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-name
        :stability: deprecated
        """
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return result

    @builtins.property
    def authorizer_credentials_arn(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Authorizer.AuthorizerCredentialsArn``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-authorizercredentialsarn
        :stability: deprecated
        """
        result = self._values.get("authorizer_credentials_arn")
        return result

    @builtins.property
    def authorizer_result_ttl_in_seconds(self) -> typing.Optional[jsii.Number]:
        """(deprecated) ``AWS::ApiGatewayV2::Authorizer.AuthorizerResultTtlInSeconds``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-authorizerresultttlinseconds
        :stability: deprecated
        """
        result = self._values.get("authorizer_result_ttl_in_seconds")
        return result

    @builtins.property
    def authorizer_uri(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Authorizer.AuthorizerUri``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-authorizeruri
        :stability: deprecated
        """
        result = self._values.get("authorizer_uri")
        return result

    @builtins.property
    def identity_validation_expression(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Authorizer.IdentityValidationExpression``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-identityvalidationexpression
        :stability: deprecated
        """
        result = self._values.get("identity_validation_expression")
        return result

    @builtins.property
    def jwt_configuration(
        self,
    ) -> typing.Optional[typing.Union[CfnAuthorizerV2.JWTConfigurationProperty, _IResolvable_a771d0ef]]:
        """(deprecated) ``AWS::ApiGatewayV2::Authorizer.JwtConfiguration``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-jwtconfiguration
        :stability: deprecated
        """
        result = self._values.get("jwt_configuration")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnAuthorizerV2Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_82c04a63)
class CfnBasePathMapping(
    _CfnResource_e0a482dc,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_apigateway.CfnBasePathMapping",
):
    """A CloudFormation ``AWS::ApiGateway::BasePathMapping``.

    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-basepathmapping.html
    :cloudformationResource: AWS::ApiGateway::BasePathMapping
    """

    def __init__(
        self,
        scope: _Construct_e78e779f,
        id: builtins.str,
        *,
        domain_name: builtins.str,
        base_path: typing.Optional[builtins.str] = None,
        rest_api_id: typing.Optional[builtins.str] = None,
        stage: typing.Optional[builtins.str] = None,
    ) -> None:
        """Create a new ``AWS::ApiGateway::BasePathMapping``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param domain_name: ``AWS::ApiGateway::BasePathMapping.DomainName``.
        :param base_path: ``AWS::ApiGateway::BasePathMapping.BasePath``.
        :param rest_api_id: ``AWS::ApiGateway::BasePathMapping.RestApiId``.
        :param stage: ``AWS::ApiGateway::BasePathMapping.Stage``.
        """
        props = CfnBasePathMappingProps(
            domain_name=domain_name,
            base_path=base_path,
            rest_api_id=rest_api_id,
            stage=stage,
        )

        jsii.create(CfnBasePathMapping, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_1cd1894e) -> None:
        """(experimental) Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="domainName")
    def domain_name(self) -> builtins.str:
        """``AWS::ApiGateway::BasePathMapping.DomainName``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-basepathmapping.html#cfn-apigateway-basepathmapping-domainname
        """
        return jsii.get(self, "domainName")

    @domain_name.setter # type: ignore
    def domain_name(self, value: builtins.str) -> None:
        jsii.set(self, "domainName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="basePath")
    def base_path(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::BasePathMapping.BasePath``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-basepathmapping.html#cfn-apigateway-basepathmapping-basepath
        """
        return jsii.get(self, "basePath")

    @base_path.setter # type: ignore
    def base_path(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "basePath", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="restApiId")
    def rest_api_id(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::BasePathMapping.RestApiId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-basepathmapping.html#cfn-apigateway-basepathmapping-restapiid
        """
        return jsii.get(self, "restApiId")

    @rest_api_id.setter # type: ignore
    def rest_api_id(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "restApiId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="stage")
    def stage(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::BasePathMapping.Stage``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-basepathmapping.html#cfn-apigateway-basepathmapping-stage
        """
        return jsii.get(self, "stage")

    @stage.setter # type: ignore
    def stage(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "stage", value)


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.CfnBasePathMappingProps",
    jsii_struct_bases=[],
    name_mapping={
        "domain_name": "domainName",
        "base_path": "basePath",
        "rest_api_id": "restApiId",
        "stage": "stage",
    },
)
class CfnBasePathMappingProps:
    def __init__(
        self,
        *,
        domain_name: builtins.str,
        base_path: typing.Optional[builtins.str] = None,
        rest_api_id: typing.Optional[builtins.str] = None,
        stage: typing.Optional[builtins.str] = None,
    ) -> None:
        """Properties for defining a ``AWS::ApiGateway::BasePathMapping``.

        :param domain_name: ``AWS::ApiGateway::BasePathMapping.DomainName``.
        :param base_path: ``AWS::ApiGateway::BasePathMapping.BasePath``.
        :param rest_api_id: ``AWS::ApiGateway::BasePathMapping.RestApiId``.
        :param stage: ``AWS::ApiGateway::BasePathMapping.Stage``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-basepathmapping.html
        """
        self._values: typing.Dict[str, typing.Any] = {
            "domain_name": domain_name,
        }
        if base_path is not None:
            self._values["base_path"] = base_path
        if rest_api_id is not None:
            self._values["rest_api_id"] = rest_api_id
        if stage is not None:
            self._values["stage"] = stage

    @builtins.property
    def domain_name(self) -> builtins.str:
        """``AWS::ApiGateway::BasePathMapping.DomainName``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-basepathmapping.html#cfn-apigateway-basepathmapping-domainname
        """
        result = self._values.get("domain_name")
        assert result is not None, "Required property 'domain_name' is missing"
        return result

    @builtins.property
    def base_path(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::BasePathMapping.BasePath``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-basepathmapping.html#cfn-apigateway-basepathmapping-basepath
        """
        result = self._values.get("base_path")
        return result

    @builtins.property
    def rest_api_id(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::BasePathMapping.RestApiId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-basepathmapping.html#cfn-apigateway-basepathmapping-restapiid
        """
        result = self._values.get("rest_api_id")
        return result

    @builtins.property
    def stage(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::BasePathMapping.Stage``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-basepathmapping.html#cfn-apigateway-basepathmapping-stage
        """
        result = self._values.get("stage")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnBasePathMappingProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_82c04a63)
class CfnClientCertificate(
    _CfnResource_e0a482dc,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_apigateway.CfnClientCertificate",
):
    """A CloudFormation ``AWS::ApiGateway::ClientCertificate``.

    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-clientcertificate.html
    :cloudformationResource: AWS::ApiGateway::ClientCertificate
    """

    def __init__(
        self,
        scope: _Construct_e78e779f,
        id: builtins.str,
        *,
        description: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.List[_CfnTag_95fbdc29]] = None,
    ) -> None:
        """Create a new ``AWS::ApiGateway::ClientCertificate``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param description: ``AWS::ApiGateway::ClientCertificate.Description``.
        :param tags: ``AWS::ApiGateway::ClientCertificate.Tags``.
        """
        props = CfnClientCertificateProps(description=description, tags=tags)

        jsii.create(CfnClientCertificate, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_1cd1894e) -> None:
        """(experimental) Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_0b7ab120:
        """``AWS::ApiGateway::ClientCertificate.Tags``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-clientcertificate.html#cfn-apigateway-clientcertificate-tags
        """
        return jsii.get(self, "tags")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::ClientCertificate.Description``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-clientcertificate.html#cfn-apigateway-clientcertificate-description
        """
        return jsii.get(self, "description")

    @description.setter # type: ignore
    def description(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "description", value)


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.CfnClientCertificateProps",
    jsii_struct_bases=[],
    name_mapping={"description": "description", "tags": "tags"},
)
class CfnClientCertificateProps:
    def __init__(
        self,
        *,
        description: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.List[_CfnTag_95fbdc29]] = None,
    ) -> None:
        """Properties for defining a ``AWS::ApiGateway::ClientCertificate``.

        :param description: ``AWS::ApiGateway::ClientCertificate.Description``.
        :param tags: ``AWS::ApiGateway::ClientCertificate.Tags``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-clientcertificate.html
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if description is not None:
            self._values["description"] = description
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::ClientCertificate.Description``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-clientcertificate.html#cfn-apigateway-clientcertificate-description
        """
        result = self._values.get("description")
        return result

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_95fbdc29]]:
        """``AWS::ApiGateway::ClientCertificate.Tags``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-clientcertificate.html#cfn-apigateway-clientcertificate-tags
        """
        result = self._values.get("tags")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnClientCertificateProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_82c04a63)
class CfnDeployment(
    _CfnResource_e0a482dc,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_apigateway.CfnDeployment",
):
    """A CloudFormation ``AWS::ApiGateway::Deployment``.

    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html
    :cloudformationResource: AWS::ApiGateway::Deployment
    """

    def __init__(
        self,
        scope: _Construct_e78e779f,
        id: builtins.str,
        *,
        rest_api_id: builtins.str,
        deployment_canary_settings: typing.Optional[typing.Union["CfnDeployment.DeploymentCanarySettingsProperty", _IResolvable_a771d0ef]] = None,
        description: typing.Optional[builtins.str] = None,
        stage_description: typing.Optional[typing.Union["CfnDeployment.StageDescriptionProperty", _IResolvable_a771d0ef]] = None,
        stage_name: typing.Optional[builtins.str] = None,
    ) -> None:
        """Create a new ``AWS::ApiGateway::Deployment``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param rest_api_id: ``AWS::ApiGateway::Deployment.RestApiId``.
        :param deployment_canary_settings: ``AWS::ApiGateway::Deployment.DeploymentCanarySettings``.
        :param description: ``AWS::ApiGateway::Deployment.Description``.
        :param stage_description: ``AWS::ApiGateway::Deployment.StageDescription``.
        :param stage_name: ``AWS::ApiGateway::Deployment.StageName``.
        """
        props = CfnDeploymentProps(
            rest_api_id=rest_api_id,
            deployment_canary_settings=deployment_canary_settings,
            description=description,
            stage_description=stage_description,
            stage_name=stage_name,
        )

        jsii.create(CfnDeployment, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_1cd1894e) -> None:
        """(experimental) Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="restApiId")
    def rest_api_id(self) -> builtins.str:
        """``AWS::ApiGateway::Deployment.RestApiId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html#cfn-apigateway-deployment-restapiid
        """
        return jsii.get(self, "restApiId")

    @rest_api_id.setter # type: ignore
    def rest_api_id(self, value: builtins.str) -> None:
        jsii.set(self, "restApiId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="deploymentCanarySettings")
    def deployment_canary_settings(
        self,
    ) -> typing.Optional[typing.Union["CfnDeployment.DeploymentCanarySettingsProperty", _IResolvable_a771d0ef]]:
        """``AWS::ApiGateway::Deployment.DeploymentCanarySettings``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html#cfn-apigateway-deployment-deploymentcanarysettings
        """
        return jsii.get(self, "deploymentCanarySettings")

    @deployment_canary_settings.setter # type: ignore
    def deployment_canary_settings(
        self,
        value: typing.Optional[typing.Union["CfnDeployment.DeploymentCanarySettingsProperty", _IResolvable_a771d0ef]],
    ) -> None:
        jsii.set(self, "deploymentCanarySettings", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::Deployment.Description``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html#cfn-apigateway-deployment-description
        """
        return jsii.get(self, "description")

    @description.setter # type: ignore
    def description(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "description", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="stageDescription")
    def stage_description(
        self,
    ) -> typing.Optional[typing.Union["CfnDeployment.StageDescriptionProperty", _IResolvable_a771d0ef]]:
        """``AWS::ApiGateway::Deployment.StageDescription``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html#cfn-apigateway-deployment-stagedescription
        """
        return jsii.get(self, "stageDescription")

    @stage_description.setter # type: ignore
    def stage_description(
        self,
        value: typing.Optional[typing.Union["CfnDeployment.StageDescriptionProperty", _IResolvable_a771d0ef]],
    ) -> None:
        jsii.set(self, "stageDescription", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="stageName")
    def stage_name(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::Deployment.StageName``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html#cfn-apigateway-deployment-stagename
        """
        return jsii.get(self, "stageName")

    @stage_name.setter # type: ignore
    def stage_name(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "stageName", value)

    @jsii.data_type(
        jsii_type="monocdk.aws_apigateway.CfnDeployment.AccessLogSettingProperty",
        jsii_struct_bases=[],
        name_mapping={"destination_arn": "destinationArn", "format": "format"},
    )
    class AccessLogSettingProperty:
        def __init__(
            self,
            *,
            destination_arn: typing.Optional[builtins.str] = None,
            format: typing.Optional[builtins.str] = None,
        ) -> None:
            """
            :param destination_arn: ``CfnDeployment.AccessLogSettingProperty.DestinationArn``.
            :param format: ``CfnDeployment.AccessLogSettingProperty.Format``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-accesslogsetting.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if destination_arn is not None:
                self._values["destination_arn"] = destination_arn
            if format is not None:
                self._values["format"] = format

        @builtins.property
        def destination_arn(self) -> typing.Optional[builtins.str]:
            """``CfnDeployment.AccessLogSettingProperty.DestinationArn``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-accesslogsetting.html#cfn-apigateway-deployment-accesslogsetting-destinationarn
            """
            result = self._values.get("destination_arn")
            return result

        @builtins.property
        def format(self) -> typing.Optional[builtins.str]:
            """``CfnDeployment.AccessLogSettingProperty.Format``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-accesslogsetting.html#cfn-apigateway-deployment-accesslogsetting-format
            """
            result = self._values.get("format")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AccessLogSettingProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_apigateway.CfnDeployment.CanarySettingProperty",
        jsii_struct_bases=[],
        name_mapping={
            "percent_traffic": "percentTraffic",
            "stage_variable_overrides": "stageVariableOverrides",
            "use_stage_cache": "useStageCache",
        },
    )
    class CanarySettingProperty:
        def __init__(
            self,
            *,
            percent_traffic: typing.Optional[jsii.Number] = None,
            stage_variable_overrides: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, builtins.str]]] = None,
            use_stage_cache: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
        ) -> None:
            """
            :param percent_traffic: ``CfnDeployment.CanarySettingProperty.PercentTraffic``.
            :param stage_variable_overrides: ``CfnDeployment.CanarySettingProperty.StageVariableOverrides``.
            :param use_stage_cache: ``CfnDeployment.CanarySettingProperty.UseStageCache``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-canarysetting.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if percent_traffic is not None:
                self._values["percent_traffic"] = percent_traffic
            if stage_variable_overrides is not None:
                self._values["stage_variable_overrides"] = stage_variable_overrides
            if use_stage_cache is not None:
                self._values["use_stage_cache"] = use_stage_cache

        @builtins.property
        def percent_traffic(self) -> typing.Optional[jsii.Number]:
            """``CfnDeployment.CanarySettingProperty.PercentTraffic``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-canarysetting.html#cfn-apigateway-deployment-canarysetting-percenttraffic
            """
            result = self._values.get("percent_traffic")
            return result

        @builtins.property
        def stage_variable_overrides(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, builtins.str]]]:
            """``CfnDeployment.CanarySettingProperty.StageVariableOverrides``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-canarysetting.html#cfn-apigateway-deployment-canarysetting-stagevariableoverrides
            """
            result = self._values.get("stage_variable_overrides")
            return result

        @builtins.property
        def use_stage_cache(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
            """``CfnDeployment.CanarySettingProperty.UseStageCache``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-canarysetting.html#cfn-apigateway-deployment-canarysetting-usestagecache
            """
            result = self._values.get("use_stage_cache")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CanarySettingProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_apigateway.CfnDeployment.DeploymentCanarySettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "percent_traffic": "percentTraffic",
            "stage_variable_overrides": "stageVariableOverrides",
            "use_stage_cache": "useStageCache",
        },
    )
    class DeploymentCanarySettingsProperty:
        def __init__(
            self,
            *,
            percent_traffic: typing.Optional[jsii.Number] = None,
            stage_variable_overrides: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, builtins.str]]] = None,
            use_stage_cache: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
        ) -> None:
            """
            :param percent_traffic: ``CfnDeployment.DeploymentCanarySettingsProperty.PercentTraffic``.
            :param stage_variable_overrides: ``CfnDeployment.DeploymentCanarySettingsProperty.StageVariableOverrides``.
            :param use_stage_cache: ``CfnDeployment.DeploymentCanarySettingsProperty.UseStageCache``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-deploymentcanarysettings.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if percent_traffic is not None:
                self._values["percent_traffic"] = percent_traffic
            if stage_variable_overrides is not None:
                self._values["stage_variable_overrides"] = stage_variable_overrides
            if use_stage_cache is not None:
                self._values["use_stage_cache"] = use_stage_cache

        @builtins.property
        def percent_traffic(self) -> typing.Optional[jsii.Number]:
            """``CfnDeployment.DeploymentCanarySettingsProperty.PercentTraffic``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-deploymentcanarysettings.html#cfn-apigateway-deployment-deploymentcanarysettings-percenttraffic
            """
            result = self._values.get("percent_traffic")
            return result

        @builtins.property
        def stage_variable_overrides(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, builtins.str]]]:
            """``CfnDeployment.DeploymentCanarySettingsProperty.StageVariableOverrides``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-deploymentcanarysettings.html#cfn-apigateway-deployment-deploymentcanarysettings-stagevariableoverrides
            """
            result = self._values.get("stage_variable_overrides")
            return result

        @builtins.property
        def use_stage_cache(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
            """``CfnDeployment.DeploymentCanarySettingsProperty.UseStageCache``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-deploymentcanarysettings.html#cfn-apigateway-deployment-deploymentcanarysettings-usestagecache
            """
            result = self._values.get("use_stage_cache")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DeploymentCanarySettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_apigateway.CfnDeployment.MethodSettingProperty",
        jsii_struct_bases=[],
        name_mapping={
            "cache_data_encrypted": "cacheDataEncrypted",
            "cache_ttl_in_seconds": "cacheTtlInSeconds",
            "caching_enabled": "cachingEnabled",
            "data_trace_enabled": "dataTraceEnabled",
            "http_method": "httpMethod",
            "logging_level": "loggingLevel",
            "metrics_enabled": "metricsEnabled",
            "resource_path": "resourcePath",
            "throttling_burst_limit": "throttlingBurstLimit",
            "throttling_rate_limit": "throttlingRateLimit",
        },
    )
    class MethodSettingProperty:
        def __init__(
            self,
            *,
            cache_data_encrypted: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
            cache_ttl_in_seconds: typing.Optional[jsii.Number] = None,
            caching_enabled: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
            data_trace_enabled: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
            http_method: typing.Optional[builtins.str] = None,
            logging_level: typing.Optional[builtins.str] = None,
            metrics_enabled: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
            resource_path: typing.Optional[builtins.str] = None,
            throttling_burst_limit: typing.Optional[jsii.Number] = None,
            throttling_rate_limit: typing.Optional[jsii.Number] = None,
        ) -> None:
            """
            :param cache_data_encrypted: ``CfnDeployment.MethodSettingProperty.CacheDataEncrypted``.
            :param cache_ttl_in_seconds: ``CfnDeployment.MethodSettingProperty.CacheTtlInSeconds``.
            :param caching_enabled: ``CfnDeployment.MethodSettingProperty.CachingEnabled``.
            :param data_trace_enabled: ``CfnDeployment.MethodSettingProperty.DataTraceEnabled``.
            :param http_method: ``CfnDeployment.MethodSettingProperty.HttpMethod``.
            :param logging_level: ``CfnDeployment.MethodSettingProperty.LoggingLevel``.
            :param metrics_enabled: ``CfnDeployment.MethodSettingProperty.MetricsEnabled``.
            :param resource_path: ``CfnDeployment.MethodSettingProperty.ResourcePath``.
            :param throttling_burst_limit: ``CfnDeployment.MethodSettingProperty.ThrottlingBurstLimit``.
            :param throttling_rate_limit: ``CfnDeployment.MethodSettingProperty.ThrottlingRateLimit``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if cache_data_encrypted is not None:
                self._values["cache_data_encrypted"] = cache_data_encrypted
            if cache_ttl_in_seconds is not None:
                self._values["cache_ttl_in_seconds"] = cache_ttl_in_seconds
            if caching_enabled is not None:
                self._values["caching_enabled"] = caching_enabled
            if data_trace_enabled is not None:
                self._values["data_trace_enabled"] = data_trace_enabled
            if http_method is not None:
                self._values["http_method"] = http_method
            if logging_level is not None:
                self._values["logging_level"] = logging_level
            if metrics_enabled is not None:
                self._values["metrics_enabled"] = metrics_enabled
            if resource_path is not None:
                self._values["resource_path"] = resource_path
            if throttling_burst_limit is not None:
                self._values["throttling_burst_limit"] = throttling_burst_limit
            if throttling_rate_limit is not None:
                self._values["throttling_rate_limit"] = throttling_rate_limit

        @builtins.property
        def cache_data_encrypted(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
            """``CfnDeployment.MethodSettingProperty.CacheDataEncrypted``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-cachedataencrypted
            """
            result = self._values.get("cache_data_encrypted")
            return result

        @builtins.property
        def cache_ttl_in_seconds(self) -> typing.Optional[jsii.Number]:
            """``CfnDeployment.MethodSettingProperty.CacheTtlInSeconds``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-cachettlinseconds
            """
            result = self._values.get("cache_ttl_in_seconds")
            return result

        @builtins.property
        def caching_enabled(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
            """``CfnDeployment.MethodSettingProperty.CachingEnabled``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-cachingenabled
            """
            result = self._values.get("caching_enabled")
            return result

        @builtins.property
        def data_trace_enabled(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
            """``CfnDeployment.MethodSettingProperty.DataTraceEnabled``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-datatraceenabled
            """
            result = self._values.get("data_trace_enabled")
            return result

        @builtins.property
        def http_method(self) -> typing.Optional[builtins.str]:
            """``CfnDeployment.MethodSettingProperty.HttpMethod``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-httpmethod
            """
            result = self._values.get("http_method")
            return result

        @builtins.property
        def logging_level(self) -> typing.Optional[builtins.str]:
            """``CfnDeployment.MethodSettingProperty.LoggingLevel``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-logginglevel
            """
            result = self._values.get("logging_level")
            return result

        @builtins.property
        def metrics_enabled(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
            """``CfnDeployment.MethodSettingProperty.MetricsEnabled``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-metricsenabled
            """
            result = self._values.get("metrics_enabled")
            return result

        @builtins.property
        def resource_path(self) -> typing.Optional[builtins.str]:
            """``CfnDeployment.MethodSettingProperty.ResourcePath``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-resourcepath
            """
            result = self._values.get("resource_path")
            return result

        @builtins.property
        def throttling_burst_limit(self) -> typing.Optional[jsii.Number]:
            """``CfnDeployment.MethodSettingProperty.ThrottlingBurstLimit``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-throttlingburstlimit
            """
            result = self._values.get("throttling_burst_limit")
            return result

        @builtins.property
        def throttling_rate_limit(self) -> typing.Optional[jsii.Number]:
            """``CfnDeployment.MethodSettingProperty.ThrottlingRateLimit``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-throttlingratelimit
            """
            result = self._values.get("throttling_rate_limit")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "MethodSettingProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_apigateway.CfnDeployment.StageDescriptionProperty",
        jsii_struct_bases=[],
        name_mapping={
            "access_log_setting": "accessLogSetting",
            "cache_cluster_enabled": "cacheClusterEnabled",
            "cache_cluster_size": "cacheClusterSize",
            "cache_data_encrypted": "cacheDataEncrypted",
            "cache_ttl_in_seconds": "cacheTtlInSeconds",
            "caching_enabled": "cachingEnabled",
            "canary_setting": "canarySetting",
            "client_certificate_id": "clientCertificateId",
            "data_trace_enabled": "dataTraceEnabled",
            "description": "description",
            "documentation_version": "documentationVersion",
            "logging_level": "loggingLevel",
            "method_settings": "methodSettings",
            "metrics_enabled": "metricsEnabled",
            "tags": "tags",
            "throttling_burst_limit": "throttlingBurstLimit",
            "throttling_rate_limit": "throttlingRateLimit",
            "tracing_enabled": "tracingEnabled",
            "variables": "variables",
        },
    )
    class StageDescriptionProperty:
        def __init__(
            self,
            *,
            access_log_setting: typing.Optional[typing.Union["CfnDeployment.AccessLogSettingProperty", _IResolvable_a771d0ef]] = None,
            cache_cluster_enabled: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
            cache_cluster_size: typing.Optional[builtins.str] = None,
            cache_data_encrypted: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
            cache_ttl_in_seconds: typing.Optional[jsii.Number] = None,
            caching_enabled: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
            canary_setting: typing.Optional[typing.Union["CfnDeployment.CanarySettingProperty", _IResolvable_a771d0ef]] = None,
            client_certificate_id: typing.Optional[builtins.str] = None,
            data_trace_enabled: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
            description: typing.Optional[builtins.str] = None,
            documentation_version: typing.Optional[builtins.str] = None,
            logging_level: typing.Optional[builtins.str] = None,
            method_settings: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnDeployment.MethodSettingProperty", _IResolvable_a771d0ef]]]] = None,
            metrics_enabled: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
            tags: typing.Optional[typing.List[_CfnTag_95fbdc29]] = None,
            throttling_burst_limit: typing.Optional[jsii.Number] = None,
            throttling_rate_limit: typing.Optional[jsii.Number] = None,
            tracing_enabled: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
            variables: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, builtins.str]]] = None,
        ) -> None:
            """
            :param access_log_setting: ``CfnDeployment.StageDescriptionProperty.AccessLogSetting``.
            :param cache_cluster_enabled: ``CfnDeployment.StageDescriptionProperty.CacheClusterEnabled``.
            :param cache_cluster_size: ``CfnDeployment.StageDescriptionProperty.CacheClusterSize``.
            :param cache_data_encrypted: ``CfnDeployment.StageDescriptionProperty.CacheDataEncrypted``.
            :param cache_ttl_in_seconds: ``CfnDeployment.StageDescriptionProperty.CacheTtlInSeconds``.
            :param caching_enabled: ``CfnDeployment.StageDescriptionProperty.CachingEnabled``.
            :param canary_setting: ``CfnDeployment.StageDescriptionProperty.CanarySetting``.
            :param client_certificate_id: ``CfnDeployment.StageDescriptionProperty.ClientCertificateId``.
            :param data_trace_enabled: ``CfnDeployment.StageDescriptionProperty.DataTraceEnabled``.
            :param description: ``CfnDeployment.StageDescriptionProperty.Description``.
            :param documentation_version: ``CfnDeployment.StageDescriptionProperty.DocumentationVersion``.
            :param logging_level: ``CfnDeployment.StageDescriptionProperty.LoggingLevel``.
            :param method_settings: ``CfnDeployment.StageDescriptionProperty.MethodSettings``.
            :param metrics_enabled: ``CfnDeployment.StageDescriptionProperty.MetricsEnabled``.
            :param tags: ``CfnDeployment.StageDescriptionProperty.Tags``.
            :param throttling_burst_limit: ``CfnDeployment.StageDescriptionProperty.ThrottlingBurstLimit``.
            :param throttling_rate_limit: ``CfnDeployment.StageDescriptionProperty.ThrottlingRateLimit``.
            :param tracing_enabled: ``CfnDeployment.StageDescriptionProperty.TracingEnabled``.
            :param variables: ``CfnDeployment.StageDescriptionProperty.Variables``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if access_log_setting is not None:
                self._values["access_log_setting"] = access_log_setting
            if cache_cluster_enabled is not None:
                self._values["cache_cluster_enabled"] = cache_cluster_enabled
            if cache_cluster_size is not None:
                self._values["cache_cluster_size"] = cache_cluster_size
            if cache_data_encrypted is not None:
                self._values["cache_data_encrypted"] = cache_data_encrypted
            if cache_ttl_in_seconds is not None:
                self._values["cache_ttl_in_seconds"] = cache_ttl_in_seconds
            if caching_enabled is not None:
                self._values["caching_enabled"] = caching_enabled
            if canary_setting is not None:
                self._values["canary_setting"] = canary_setting
            if client_certificate_id is not None:
                self._values["client_certificate_id"] = client_certificate_id
            if data_trace_enabled is not None:
                self._values["data_trace_enabled"] = data_trace_enabled
            if description is not None:
                self._values["description"] = description
            if documentation_version is not None:
                self._values["documentation_version"] = documentation_version
            if logging_level is not None:
                self._values["logging_level"] = logging_level
            if method_settings is not None:
                self._values["method_settings"] = method_settings
            if metrics_enabled is not None:
                self._values["metrics_enabled"] = metrics_enabled
            if tags is not None:
                self._values["tags"] = tags
            if throttling_burst_limit is not None:
                self._values["throttling_burst_limit"] = throttling_burst_limit
            if throttling_rate_limit is not None:
                self._values["throttling_rate_limit"] = throttling_rate_limit
            if tracing_enabled is not None:
                self._values["tracing_enabled"] = tracing_enabled
            if variables is not None:
                self._values["variables"] = variables

        @builtins.property
        def access_log_setting(
            self,
        ) -> typing.Optional[typing.Union["CfnDeployment.AccessLogSettingProperty", _IResolvable_a771d0ef]]:
            """``CfnDeployment.StageDescriptionProperty.AccessLogSetting``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-accesslogsetting
            """
            result = self._values.get("access_log_setting")
            return result

        @builtins.property
        def cache_cluster_enabled(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
            """``CfnDeployment.StageDescriptionProperty.CacheClusterEnabled``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cacheclusterenabled
            """
            result = self._values.get("cache_cluster_enabled")
            return result

        @builtins.property
        def cache_cluster_size(self) -> typing.Optional[builtins.str]:
            """``CfnDeployment.StageDescriptionProperty.CacheClusterSize``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cacheclustersize
            """
            result = self._values.get("cache_cluster_size")
            return result

        @builtins.property
        def cache_data_encrypted(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
            """``CfnDeployment.StageDescriptionProperty.CacheDataEncrypted``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cachedataencrypted
            """
            result = self._values.get("cache_data_encrypted")
            return result

        @builtins.property
        def cache_ttl_in_seconds(self) -> typing.Optional[jsii.Number]:
            """``CfnDeployment.StageDescriptionProperty.CacheTtlInSeconds``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cachettlinseconds
            """
            result = self._values.get("cache_ttl_in_seconds")
            return result

        @builtins.property
        def caching_enabled(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
            """``CfnDeployment.StageDescriptionProperty.CachingEnabled``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cachingenabled
            """
            result = self._values.get("caching_enabled")
            return result

        @builtins.property
        def canary_setting(
            self,
        ) -> typing.Optional[typing.Union["CfnDeployment.CanarySettingProperty", _IResolvable_a771d0ef]]:
            """``CfnDeployment.StageDescriptionProperty.CanarySetting``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-canarysetting
            """
            result = self._values.get("canary_setting")
            return result

        @builtins.property
        def client_certificate_id(self) -> typing.Optional[builtins.str]:
            """``CfnDeployment.StageDescriptionProperty.ClientCertificateId``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-clientcertificateid
            """
            result = self._values.get("client_certificate_id")
            return result

        @builtins.property
        def data_trace_enabled(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
            """``CfnDeployment.StageDescriptionProperty.DataTraceEnabled``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-datatraceenabled
            """
            result = self._values.get("data_trace_enabled")
            return result

        @builtins.property
        def description(self) -> typing.Optional[builtins.str]:
            """``CfnDeployment.StageDescriptionProperty.Description``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-description
            """
            result = self._values.get("description")
            return result

        @builtins.property
        def documentation_version(self) -> typing.Optional[builtins.str]:
            """``CfnDeployment.StageDescriptionProperty.DocumentationVersion``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-documentationversion
            """
            result = self._values.get("documentation_version")
            return result

        @builtins.property
        def logging_level(self) -> typing.Optional[builtins.str]:
            """``CfnDeployment.StageDescriptionProperty.LoggingLevel``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-logginglevel
            """
            result = self._values.get("logging_level")
            return result

        @builtins.property
        def method_settings(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnDeployment.MethodSettingProperty", _IResolvable_a771d0ef]]]]:
            """``CfnDeployment.StageDescriptionProperty.MethodSettings``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-methodsettings
            """
            result = self._values.get("method_settings")
            return result

        @builtins.property
        def metrics_enabled(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
            """``CfnDeployment.StageDescriptionProperty.MetricsEnabled``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-metricsenabled
            """
            result = self._values.get("metrics_enabled")
            return result

        @builtins.property
        def tags(self) -> typing.Optional[typing.List[_CfnTag_95fbdc29]]:
            """``CfnDeployment.StageDescriptionProperty.Tags``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-tags
            """
            result = self._values.get("tags")
            return result

        @builtins.property
        def throttling_burst_limit(self) -> typing.Optional[jsii.Number]:
            """``CfnDeployment.StageDescriptionProperty.ThrottlingBurstLimit``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-throttlingburstlimit
            """
            result = self._values.get("throttling_burst_limit")
            return result

        @builtins.property
        def throttling_rate_limit(self) -> typing.Optional[jsii.Number]:
            """``CfnDeployment.StageDescriptionProperty.ThrottlingRateLimit``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-throttlingratelimit
            """
            result = self._values.get("throttling_rate_limit")
            return result

        @builtins.property
        def tracing_enabled(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
            """``CfnDeployment.StageDescriptionProperty.TracingEnabled``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-tracingenabled
            """
            result = self._values.get("tracing_enabled")
            return result

        @builtins.property
        def variables(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, builtins.str]]]:
            """``CfnDeployment.StageDescriptionProperty.Variables``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-variables
            """
            result = self._values.get("variables")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "StageDescriptionProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.CfnDeploymentProps",
    jsii_struct_bases=[],
    name_mapping={
        "rest_api_id": "restApiId",
        "deployment_canary_settings": "deploymentCanarySettings",
        "description": "description",
        "stage_description": "stageDescription",
        "stage_name": "stageName",
    },
)
class CfnDeploymentProps:
    def __init__(
        self,
        *,
        rest_api_id: builtins.str,
        deployment_canary_settings: typing.Optional[typing.Union[CfnDeployment.DeploymentCanarySettingsProperty, _IResolvable_a771d0ef]] = None,
        description: typing.Optional[builtins.str] = None,
        stage_description: typing.Optional[typing.Union[CfnDeployment.StageDescriptionProperty, _IResolvable_a771d0ef]] = None,
        stage_name: typing.Optional[builtins.str] = None,
    ) -> None:
        """Properties for defining a ``AWS::ApiGateway::Deployment``.

        :param rest_api_id: ``AWS::ApiGateway::Deployment.RestApiId``.
        :param deployment_canary_settings: ``AWS::ApiGateway::Deployment.DeploymentCanarySettings``.
        :param description: ``AWS::ApiGateway::Deployment.Description``.
        :param stage_description: ``AWS::ApiGateway::Deployment.StageDescription``.
        :param stage_name: ``AWS::ApiGateway::Deployment.StageName``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html
        """
        self._values: typing.Dict[str, typing.Any] = {
            "rest_api_id": rest_api_id,
        }
        if deployment_canary_settings is not None:
            self._values["deployment_canary_settings"] = deployment_canary_settings
        if description is not None:
            self._values["description"] = description
        if stage_description is not None:
            self._values["stage_description"] = stage_description
        if stage_name is not None:
            self._values["stage_name"] = stage_name

    @builtins.property
    def rest_api_id(self) -> builtins.str:
        """``AWS::ApiGateway::Deployment.RestApiId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html#cfn-apigateway-deployment-restapiid
        """
        result = self._values.get("rest_api_id")
        assert result is not None, "Required property 'rest_api_id' is missing"
        return result

    @builtins.property
    def deployment_canary_settings(
        self,
    ) -> typing.Optional[typing.Union[CfnDeployment.DeploymentCanarySettingsProperty, _IResolvable_a771d0ef]]:
        """``AWS::ApiGateway::Deployment.DeploymentCanarySettings``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html#cfn-apigateway-deployment-deploymentcanarysettings
        """
        result = self._values.get("deployment_canary_settings")
        return result

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::Deployment.Description``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html#cfn-apigateway-deployment-description
        """
        result = self._values.get("description")
        return result

    @builtins.property
    def stage_description(
        self,
    ) -> typing.Optional[typing.Union[CfnDeployment.StageDescriptionProperty, _IResolvable_a771d0ef]]:
        """``AWS::ApiGateway::Deployment.StageDescription``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html#cfn-apigateway-deployment-stagedescription
        """
        result = self._values.get("stage_description")
        return result

    @builtins.property
    def stage_name(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::Deployment.StageName``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html#cfn-apigateway-deployment-stagename
        """
        result = self._values.get("stage_name")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnDeploymentProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_82c04a63)
class CfnDeploymentV2(
    _CfnResource_e0a482dc,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_apigateway.CfnDeploymentV2",
):
    """(deprecated) A CloudFormation ``AWS::ApiGatewayV2::Deployment``.

    :deprecated: moved to package aws-apigatewayv2

    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-deployment.html
    :stability: deprecated
    :cloudformationResource: AWS::ApiGatewayV2::Deployment
    """

    def __init__(
        self,
        scope: _Construct_e78e779f,
        id: builtins.str,
        *,
        api_id: builtins.str,
        description: typing.Optional[builtins.str] = None,
        stage_name: typing.Optional[builtins.str] = None,
    ) -> None:
        """(deprecated) Create a new ``AWS::ApiGatewayV2::Deployment``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param api_id: (deprecated) ``AWS::ApiGatewayV2::Deployment.ApiId``.
        :param description: (deprecated) ``AWS::ApiGatewayV2::Deployment.Description``.
        :param stage_name: (deprecated) ``AWS::ApiGatewayV2::Deployment.StageName``.

        :stability: deprecated
        """
        props = CfnDeploymentV2Props(
            api_id=api_id, description=description, stage_name=stage_name
        )

        jsii.create(CfnDeploymentV2, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_1cd1894e) -> None:
        """(experimental) Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -

        :stability: deprecated
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """(deprecated) The CloudFormation resource type name for this resource class.

        :stability: deprecated
        """
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :stability: deprecated
        """
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiId")
    def api_id(self) -> builtins.str:
        """(deprecated) ``AWS::ApiGatewayV2::Deployment.ApiId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-deployment.html#cfn-apigatewayv2-deployment-apiid
        :stability: deprecated
        """
        return jsii.get(self, "apiId")

    @api_id.setter # type: ignore
    def api_id(self, value: builtins.str) -> None:
        jsii.set(self, "apiId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Deployment.Description``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-deployment.html#cfn-apigatewayv2-deployment-description
        :stability: deprecated
        """
        return jsii.get(self, "description")

    @description.setter # type: ignore
    def description(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "description", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="stageName")
    def stage_name(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Deployment.StageName``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-deployment.html#cfn-apigatewayv2-deployment-stagename
        :stability: deprecated
        """
        return jsii.get(self, "stageName")

    @stage_name.setter # type: ignore
    def stage_name(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "stageName", value)


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.CfnDeploymentV2Props",
    jsii_struct_bases=[],
    name_mapping={
        "api_id": "apiId",
        "description": "description",
        "stage_name": "stageName",
    },
)
class CfnDeploymentV2Props:
    def __init__(
        self,
        *,
        api_id: builtins.str,
        description: typing.Optional[builtins.str] = None,
        stage_name: typing.Optional[builtins.str] = None,
    ) -> None:
        """(deprecated) Properties for defining a ``AWS::ApiGatewayV2::Deployment``.

        :param api_id: (deprecated) ``AWS::ApiGatewayV2::Deployment.ApiId``.
        :param description: (deprecated) ``AWS::ApiGatewayV2::Deployment.Description``.
        :param stage_name: (deprecated) ``AWS::ApiGatewayV2::Deployment.StageName``.

        :deprecated: moved to package aws-apigatewayv2

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-deployment.html
        :stability: deprecated
        """
        self._values: typing.Dict[str, typing.Any] = {
            "api_id": api_id,
        }
        if description is not None:
            self._values["description"] = description
        if stage_name is not None:
            self._values["stage_name"] = stage_name

    @builtins.property
    def api_id(self) -> builtins.str:
        """(deprecated) ``AWS::ApiGatewayV2::Deployment.ApiId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-deployment.html#cfn-apigatewayv2-deployment-apiid
        :stability: deprecated
        """
        result = self._values.get("api_id")
        assert result is not None, "Required property 'api_id' is missing"
        return result

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Deployment.Description``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-deployment.html#cfn-apigatewayv2-deployment-description
        :stability: deprecated
        """
        result = self._values.get("description")
        return result

    @builtins.property
    def stage_name(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Deployment.StageName``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-deployment.html#cfn-apigatewayv2-deployment-stagename
        :stability: deprecated
        """
        result = self._values.get("stage_name")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnDeploymentV2Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_82c04a63)
class CfnDocumentationPart(
    _CfnResource_e0a482dc,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_apigateway.CfnDocumentationPart",
):
    """A CloudFormation ``AWS::ApiGateway::DocumentationPart``.

    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationpart.html
    :cloudformationResource: AWS::ApiGateway::DocumentationPart
    """

    def __init__(
        self,
        scope: _Construct_e78e779f,
        id: builtins.str,
        *,
        location: typing.Union["CfnDocumentationPart.LocationProperty", _IResolvable_a771d0ef],
        properties: builtins.str,
        rest_api_id: builtins.str,
    ) -> None:
        """Create a new ``AWS::ApiGateway::DocumentationPart``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param location: ``AWS::ApiGateway::DocumentationPart.Location``.
        :param properties: ``AWS::ApiGateway::DocumentationPart.Properties``.
        :param rest_api_id: ``AWS::ApiGateway::DocumentationPart.RestApiId``.
        """
        props = CfnDocumentationPartProps(
            location=location, properties=properties, rest_api_id=rest_api_id
        )

        jsii.create(CfnDocumentationPart, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_1cd1894e) -> None:
        """(experimental) Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="location")
    def location(
        self,
    ) -> typing.Union["CfnDocumentationPart.LocationProperty", _IResolvable_a771d0ef]:
        """``AWS::ApiGateway::DocumentationPart.Location``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationpart.html#cfn-apigateway-documentationpart-location
        """
        return jsii.get(self, "location")

    @location.setter # type: ignore
    def location(
        self,
        value: typing.Union["CfnDocumentationPart.LocationProperty", _IResolvable_a771d0ef],
    ) -> None:
        jsii.set(self, "location", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="properties")
    def properties(self) -> builtins.str:
        """``AWS::ApiGateway::DocumentationPart.Properties``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationpart.html#cfn-apigateway-documentationpart-properties
        """
        return jsii.get(self, "properties")

    @properties.setter # type: ignore
    def properties(self, value: builtins.str) -> None:
        jsii.set(self, "properties", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="restApiId")
    def rest_api_id(self) -> builtins.str:
        """``AWS::ApiGateway::DocumentationPart.RestApiId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationpart.html#cfn-apigateway-documentationpart-restapiid
        """
        return jsii.get(self, "restApiId")

    @rest_api_id.setter # type: ignore
    def rest_api_id(self, value: builtins.str) -> None:
        jsii.set(self, "restApiId", value)

    @jsii.data_type(
        jsii_type="monocdk.aws_apigateway.CfnDocumentationPart.LocationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "method": "method",
            "name": "name",
            "path": "path",
            "status_code": "statusCode",
            "type": "type",
        },
    )
    class LocationProperty:
        def __init__(
            self,
            *,
            method: typing.Optional[builtins.str] = None,
            name: typing.Optional[builtins.str] = None,
            path: typing.Optional[builtins.str] = None,
            status_code: typing.Optional[builtins.str] = None,
            type: typing.Optional[builtins.str] = None,
        ) -> None:
            """
            :param method: ``CfnDocumentationPart.LocationProperty.Method``.
            :param name: ``CfnDocumentationPart.LocationProperty.Name``.
            :param path: ``CfnDocumentationPart.LocationProperty.Path``.
            :param status_code: ``CfnDocumentationPart.LocationProperty.StatusCode``.
            :param type: ``CfnDocumentationPart.LocationProperty.Type``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if method is not None:
                self._values["method"] = method
            if name is not None:
                self._values["name"] = name
            if path is not None:
                self._values["path"] = path
            if status_code is not None:
                self._values["status_code"] = status_code
            if type is not None:
                self._values["type"] = type

        @builtins.property
        def method(self) -> typing.Optional[builtins.str]:
            """``CfnDocumentationPart.LocationProperty.Method``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-method
            """
            result = self._values.get("method")
            return result

        @builtins.property
        def name(self) -> typing.Optional[builtins.str]:
            """``CfnDocumentationPart.LocationProperty.Name``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-name
            """
            result = self._values.get("name")
            return result

        @builtins.property
        def path(self) -> typing.Optional[builtins.str]:
            """``CfnDocumentationPart.LocationProperty.Path``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-path
            """
            result = self._values.get("path")
            return result

        @builtins.property
        def status_code(self) -> typing.Optional[builtins.str]:
            """``CfnDocumentationPart.LocationProperty.StatusCode``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-statuscode
            """
            result = self._values.get("status_code")
            return result

        @builtins.property
        def type(self) -> typing.Optional[builtins.str]:
            """``CfnDocumentationPart.LocationProperty.Type``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-type
            """
            result = self._values.get("type")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "LocationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.CfnDocumentationPartProps",
    jsii_struct_bases=[],
    name_mapping={
        "location": "location",
        "properties": "properties",
        "rest_api_id": "restApiId",
    },
)
class CfnDocumentationPartProps:
    def __init__(
        self,
        *,
        location: typing.Union[CfnDocumentationPart.LocationProperty, _IResolvable_a771d0ef],
        properties: builtins.str,
        rest_api_id: builtins.str,
    ) -> None:
        """Properties for defining a ``AWS::ApiGateway::DocumentationPart``.

        :param location: ``AWS::ApiGateway::DocumentationPart.Location``.
        :param properties: ``AWS::ApiGateway::DocumentationPart.Properties``.
        :param rest_api_id: ``AWS::ApiGateway::DocumentationPart.RestApiId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationpart.html
        """
        self._values: typing.Dict[str, typing.Any] = {
            "location": location,
            "properties": properties,
            "rest_api_id": rest_api_id,
        }

    @builtins.property
    def location(
        self,
    ) -> typing.Union[CfnDocumentationPart.LocationProperty, _IResolvable_a771d0ef]:
        """``AWS::ApiGateway::DocumentationPart.Location``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationpart.html#cfn-apigateway-documentationpart-location
        """
        result = self._values.get("location")
        assert result is not None, "Required property 'location' is missing"
        return result

    @builtins.property
    def properties(self) -> builtins.str:
        """``AWS::ApiGateway::DocumentationPart.Properties``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationpart.html#cfn-apigateway-documentationpart-properties
        """
        result = self._values.get("properties")
        assert result is not None, "Required property 'properties' is missing"
        return result

    @builtins.property
    def rest_api_id(self) -> builtins.str:
        """``AWS::ApiGateway::DocumentationPart.RestApiId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationpart.html#cfn-apigateway-documentationpart-restapiid
        """
        result = self._values.get("rest_api_id")
        assert result is not None, "Required property 'rest_api_id' is missing"
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnDocumentationPartProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_82c04a63)
class CfnDocumentationVersion(
    _CfnResource_e0a482dc,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_apigateway.CfnDocumentationVersion",
):
    """A CloudFormation ``AWS::ApiGateway::DocumentationVersion``.

    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationversion.html
    :cloudformationResource: AWS::ApiGateway::DocumentationVersion
    """

    def __init__(
        self,
        scope: _Construct_e78e779f,
        id: builtins.str,
        *,
        documentation_version: builtins.str,
        rest_api_id: builtins.str,
        description: typing.Optional[builtins.str] = None,
    ) -> None:
        """Create a new ``AWS::ApiGateway::DocumentationVersion``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param documentation_version: ``AWS::ApiGateway::DocumentationVersion.DocumentationVersion``.
        :param rest_api_id: ``AWS::ApiGateway::DocumentationVersion.RestApiId``.
        :param description: ``AWS::ApiGateway::DocumentationVersion.Description``.
        """
        props = CfnDocumentationVersionProps(
            documentation_version=documentation_version,
            rest_api_id=rest_api_id,
            description=description,
        )

        jsii.create(CfnDocumentationVersion, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_1cd1894e) -> None:
        """(experimental) Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="documentationVersion")
    def documentation_version(self) -> builtins.str:
        """``AWS::ApiGateway::DocumentationVersion.DocumentationVersion``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationversion.html#cfn-apigateway-documentationversion-documentationversion
        """
        return jsii.get(self, "documentationVersion")

    @documentation_version.setter # type: ignore
    def documentation_version(self, value: builtins.str) -> None:
        jsii.set(self, "documentationVersion", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="restApiId")
    def rest_api_id(self) -> builtins.str:
        """``AWS::ApiGateway::DocumentationVersion.RestApiId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationversion.html#cfn-apigateway-documentationversion-restapiid
        """
        return jsii.get(self, "restApiId")

    @rest_api_id.setter # type: ignore
    def rest_api_id(self, value: builtins.str) -> None:
        jsii.set(self, "restApiId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::DocumentationVersion.Description``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationversion.html#cfn-apigateway-documentationversion-description
        """
        return jsii.get(self, "description")

    @description.setter # type: ignore
    def description(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "description", value)


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.CfnDocumentationVersionProps",
    jsii_struct_bases=[],
    name_mapping={
        "documentation_version": "documentationVersion",
        "rest_api_id": "restApiId",
        "description": "description",
    },
)
class CfnDocumentationVersionProps:
    def __init__(
        self,
        *,
        documentation_version: builtins.str,
        rest_api_id: builtins.str,
        description: typing.Optional[builtins.str] = None,
    ) -> None:
        """Properties for defining a ``AWS::ApiGateway::DocumentationVersion``.

        :param documentation_version: ``AWS::ApiGateway::DocumentationVersion.DocumentationVersion``.
        :param rest_api_id: ``AWS::ApiGateway::DocumentationVersion.RestApiId``.
        :param description: ``AWS::ApiGateway::DocumentationVersion.Description``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationversion.html
        """
        self._values: typing.Dict[str, typing.Any] = {
            "documentation_version": documentation_version,
            "rest_api_id": rest_api_id,
        }
        if description is not None:
            self._values["description"] = description

    @builtins.property
    def documentation_version(self) -> builtins.str:
        """``AWS::ApiGateway::DocumentationVersion.DocumentationVersion``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationversion.html#cfn-apigateway-documentationversion-documentationversion
        """
        result = self._values.get("documentation_version")
        assert result is not None, "Required property 'documentation_version' is missing"
        return result

    @builtins.property
    def rest_api_id(self) -> builtins.str:
        """``AWS::ApiGateway::DocumentationVersion.RestApiId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationversion.html#cfn-apigateway-documentationversion-restapiid
        """
        result = self._values.get("rest_api_id")
        assert result is not None, "Required property 'rest_api_id' is missing"
        return result

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::DocumentationVersion.Description``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationversion.html#cfn-apigateway-documentationversion-description
        """
        result = self._values.get("description")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnDocumentationVersionProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_82c04a63)
class CfnDomainName(
    _CfnResource_e0a482dc,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_apigateway.CfnDomainName",
):
    """A CloudFormation ``AWS::ApiGateway::DomainName``.

    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainname.html
    :cloudformationResource: AWS::ApiGateway::DomainName
    """

    def __init__(
        self,
        scope: _Construct_e78e779f,
        id: builtins.str,
        *,
        certificate_arn: typing.Optional[builtins.str] = None,
        domain_name: typing.Optional[builtins.str] = None,
        endpoint_configuration: typing.Optional[typing.Union["CfnDomainName.EndpointConfigurationProperty", _IResolvable_a771d0ef]] = None,
        mutual_tls_authentication: typing.Optional[typing.Union["CfnDomainName.MutualTlsAuthenticationProperty", _IResolvable_a771d0ef]] = None,
        regional_certificate_arn: typing.Optional[builtins.str] = None,
        security_policy: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.List[_CfnTag_95fbdc29]] = None,
    ) -> None:
        """Create a new ``AWS::ApiGateway::DomainName``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param certificate_arn: ``AWS::ApiGateway::DomainName.CertificateArn``.
        :param domain_name: ``AWS::ApiGateway::DomainName.DomainName``.
        :param endpoint_configuration: ``AWS::ApiGateway::DomainName.EndpointConfiguration``.
        :param mutual_tls_authentication: ``AWS::ApiGateway::DomainName.MutualTlsAuthentication``.
        :param regional_certificate_arn: ``AWS::ApiGateway::DomainName.RegionalCertificateArn``.
        :param security_policy: ``AWS::ApiGateway::DomainName.SecurityPolicy``.
        :param tags: ``AWS::ApiGateway::DomainName.Tags``.
        """
        props = CfnDomainNameProps(
            certificate_arn=certificate_arn,
            domain_name=domain_name,
            endpoint_configuration=endpoint_configuration,
            mutual_tls_authentication=mutual_tls_authentication,
            regional_certificate_arn=regional_certificate_arn,
            security_policy=security_policy,
            tags=tags,
        )

        jsii.create(CfnDomainName, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_1cd1894e) -> None:
        """(experimental) Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="attrDistributionDomainName")
    def attr_distribution_domain_name(self) -> builtins.str:
        """
        :cloudformationAttribute: DistributionDomainName
        """
        return jsii.get(self, "attrDistributionDomainName")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="attrDistributionHostedZoneId")
    def attr_distribution_hosted_zone_id(self) -> builtins.str:
        """
        :cloudformationAttribute: DistributionHostedZoneId
        """
        return jsii.get(self, "attrDistributionHostedZoneId")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="attrRegionalDomainName")
    def attr_regional_domain_name(self) -> builtins.str:
        """
        :cloudformationAttribute: RegionalDomainName
        """
        return jsii.get(self, "attrRegionalDomainName")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="attrRegionalHostedZoneId")
    def attr_regional_hosted_zone_id(self) -> builtins.str:
        """
        :cloudformationAttribute: RegionalHostedZoneId
        """
        return jsii.get(self, "attrRegionalHostedZoneId")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_0b7ab120:
        """``AWS::ApiGateway::DomainName.Tags``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainname.html#cfn-apigateway-domainname-tags
        """
        return jsii.get(self, "tags")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="certificateArn")
    def certificate_arn(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::DomainName.CertificateArn``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainname.html#cfn-apigateway-domainname-certificatearn
        """
        return jsii.get(self, "certificateArn")

    @certificate_arn.setter # type: ignore
    def certificate_arn(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "certificateArn", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="domainName")
    def domain_name(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::DomainName.DomainName``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainname.html#cfn-apigateway-domainname-domainname
        """
        return jsii.get(self, "domainName")

    @domain_name.setter # type: ignore
    def domain_name(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "domainName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="endpointConfiguration")
    def endpoint_configuration(
        self,
    ) -> typing.Optional[typing.Union["CfnDomainName.EndpointConfigurationProperty", _IResolvable_a771d0ef]]:
        """``AWS::ApiGateway::DomainName.EndpointConfiguration``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainname.html#cfn-apigateway-domainname-endpointconfiguration
        """
        return jsii.get(self, "endpointConfiguration")

    @endpoint_configuration.setter # type: ignore
    def endpoint_configuration(
        self,
        value: typing.Optional[typing.Union["CfnDomainName.EndpointConfigurationProperty", _IResolvable_a771d0ef]],
    ) -> None:
        jsii.set(self, "endpointConfiguration", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="mutualTlsAuthentication")
    def mutual_tls_authentication(
        self,
    ) -> typing.Optional[typing.Union["CfnDomainName.MutualTlsAuthenticationProperty", _IResolvable_a771d0ef]]:
        """``AWS::ApiGateway::DomainName.MutualTlsAuthentication``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainname.html#cfn-apigateway-domainname-mutualtlsauthentication
        """
        return jsii.get(self, "mutualTlsAuthentication")

    @mutual_tls_authentication.setter # type: ignore
    def mutual_tls_authentication(
        self,
        value: typing.Optional[typing.Union["CfnDomainName.MutualTlsAuthenticationProperty", _IResolvable_a771d0ef]],
    ) -> None:
        jsii.set(self, "mutualTlsAuthentication", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="regionalCertificateArn")
    def regional_certificate_arn(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::DomainName.RegionalCertificateArn``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainname.html#cfn-apigateway-domainname-regionalcertificatearn
        """
        return jsii.get(self, "regionalCertificateArn")

    @regional_certificate_arn.setter # type: ignore
    def regional_certificate_arn(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "regionalCertificateArn", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="securityPolicy")
    def security_policy(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::DomainName.SecurityPolicy``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainname.html#cfn-apigateway-domainname-securitypolicy
        """
        return jsii.get(self, "securityPolicy")

    @security_policy.setter # type: ignore
    def security_policy(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "securityPolicy", value)

    @jsii.data_type(
        jsii_type="monocdk.aws_apigateway.CfnDomainName.EndpointConfigurationProperty",
        jsii_struct_bases=[],
        name_mapping={"types": "types"},
    )
    class EndpointConfigurationProperty:
        def __init__(
            self,
            *,
            types: typing.Optional[typing.List[builtins.str]] = None,
        ) -> None:
            """
            :param types: ``CfnDomainName.EndpointConfigurationProperty.Types``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-domainname-endpointconfiguration.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if types is not None:
                self._values["types"] = types

        @builtins.property
        def types(self) -> typing.Optional[typing.List[builtins.str]]:
            """``CfnDomainName.EndpointConfigurationProperty.Types``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-domainname-endpointconfiguration.html#cfn-apigateway-domainname-endpointconfiguration-types
            """
            result = self._values.get("types")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "EndpointConfigurationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_apigateway.CfnDomainName.MutualTlsAuthenticationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "truststore_uri": "truststoreUri",
            "truststore_version": "truststoreVersion",
        },
    )
    class MutualTlsAuthenticationProperty:
        def __init__(
            self,
            *,
            truststore_uri: typing.Optional[builtins.str] = None,
            truststore_version: typing.Optional[builtins.str] = None,
        ) -> None:
            """
            :param truststore_uri: ``CfnDomainName.MutualTlsAuthenticationProperty.TruststoreUri``.
            :param truststore_version: ``CfnDomainName.MutualTlsAuthenticationProperty.TruststoreVersion``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-domainname-mutualtlsauthentication.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if truststore_uri is not None:
                self._values["truststore_uri"] = truststore_uri
            if truststore_version is not None:
                self._values["truststore_version"] = truststore_version

        @builtins.property
        def truststore_uri(self) -> typing.Optional[builtins.str]:
            """``CfnDomainName.MutualTlsAuthenticationProperty.TruststoreUri``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-domainname-mutualtlsauthentication.html#cfn-apigateway-domainname-mutualtlsauthentication-truststoreuri
            """
            result = self._values.get("truststore_uri")
            return result

        @builtins.property
        def truststore_version(self) -> typing.Optional[builtins.str]:
            """``CfnDomainName.MutualTlsAuthenticationProperty.TruststoreVersion``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-domainname-mutualtlsauthentication.html#cfn-apigateway-domainname-mutualtlsauthentication-truststoreversion
            """
            result = self._values.get("truststore_version")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "MutualTlsAuthenticationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.CfnDomainNameProps",
    jsii_struct_bases=[],
    name_mapping={
        "certificate_arn": "certificateArn",
        "domain_name": "domainName",
        "endpoint_configuration": "endpointConfiguration",
        "mutual_tls_authentication": "mutualTlsAuthentication",
        "regional_certificate_arn": "regionalCertificateArn",
        "security_policy": "securityPolicy",
        "tags": "tags",
    },
)
class CfnDomainNameProps:
    def __init__(
        self,
        *,
        certificate_arn: typing.Optional[builtins.str] = None,
        domain_name: typing.Optional[builtins.str] = None,
        endpoint_configuration: typing.Optional[typing.Union[CfnDomainName.EndpointConfigurationProperty, _IResolvable_a771d0ef]] = None,
        mutual_tls_authentication: typing.Optional[typing.Union[CfnDomainName.MutualTlsAuthenticationProperty, _IResolvable_a771d0ef]] = None,
        regional_certificate_arn: typing.Optional[builtins.str] = None,
        security_policy: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.List[_CfnTag_95fbdc29]] = None,
    ) -> None:
        """Properties for defining a ``AWS::ApiGateway::DomainName``.

        :param certificate_arn: ``AWS::ApiGateway::DomainName.CertificateArn``.
        :param domain_name: ``AWS::ApiGateway::DomainName.DomainName``.
        :param endpoint_configuration: ``AWS::ApiGateway::DomainName.EndpointConfiguration``.
        :param mutual_tls_authentication: ``AWS::ApiGateway::DomainName.MutualTlsAuthentication``.
        :param regional_certificate_arn: ``AWS::ApiGateway::DomainName.RegionalCertificateArn``.
        :param security_policy: ``AWS::ApiGateway::DomainName.SecurityPolicy``.
        :param tags: ``AWS::ApiGateway::DomainName.Tags``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainname.html
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if certificate_arn is not None:
            self._values["certificate_arn"] = certificate_arn
        if domain_name is not None:
            self._values["domain_name"] = domain_name
        if endpoint_configuration is not None:
            self._values["endpoint_configuration"] = endpoint_configuration
        if mutual_tls_authentication is not None:
            self._values["mutual_tls_authentication"] = mutual_tls_authentication
        if regional_certificate_arn is not None:
            self._values["regional_certificate_arn"] = regional_certificate_arn
        if security_policy is not None:
            self._values["security_policy"] = security_policy
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def certificate_arn(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::DomainName.CertificateArn``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainname.html#cfn-apigateway-domainname-certificatearn
        """
        result = self._values.get("certificate_arn")
        return result

    @builtins.property
    def domain_name(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::DomainName.DomainName``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainname.html#cfn-apigateway-domainname-domainname
        """
        result = self._values.get("domain_name")
        return result

    @builtins.property
    def endpoint_configuration(
        self,
    ) -> typing.Optional[typing.Union[CfnDomainName.EndpointConfigurationProperty, _IResolvable_a771d0ef]]:
        """``AWS::ApiGateway::DomainName.EndpointConfiguration``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainname.html#cfn-apigateway-domainname-endpointconfiguration
        """
        result = self._values.get("endpoint_configuration")
        return result

    @builtins.property
    def mutual_tls_authentication(
        self,
    ) -> typing.Optional[typing.Union[CfnDomainName.MutualTlsAuthenticationProperty, _IResolvable_a771d0ef]]:
        """``AWS::ApiGateway::DomainName.MutualTlsAuthentication``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainname.html#cfn-apigateway-domainname-mutualtlsauthentication
        """
        result = self._values.get("mutual_tls_authentication")
        return result

    @builtins.property
    def regional_certificate_arn(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::DomainName.RegionalCertificateArn``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainname.html#cfn-apigateway-domainname-regionalcertificatearn
        """
        result = self._values.get("regional_certificate_arn")
        return result

    @builtins.property
    def security_policy(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::DomainName.SecurityPolicy``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainname.html#cfn-apigateway-domainname-securitypolicy
        """
        result = self._values.get("security_policy")
        return result

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_95fbdc29]]:
        """``AWS::ApiGateway::DomainName.Tags``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainname.html#cfn-apigateway-domainname-tags
        """
        result = self._values.get("tags")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnDomainNameProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_82c04a63)
class CfnDomainNameV2(
    _CfnResource_e0a482dc,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_apigateway.CfnDomainNameV2",
):
    """(deprecated) A CloudFormation ``AWS::ApiGatewayV2::DomainName``.

    :deprecated: moved to package aws-apigatewayv2

    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-domainname.html
    :stability: deprecated
    :cloudformationResource: AWS::ApiGatewayV2::DomainName
    """

    def __init__(
        self,
        scope: _Construct_e78e779f,
        id: builtins.str,
        *,
        domain_name: builtins.str,
        domain_name_configurations: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnDomainNameV2.DomainNameConfigurationProperty", _IResolvable_a771d0ef]]]] = None,
        tags: typing.Any = None,
    ) -> None:
        """(deprecated) Create a new ``AWS::ApiGatewayV2::DomainName``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param domain_name: (deprecated) ``AWS::ApiGatewayV2::DomainName.DomainName``.
        :param domain_name_configurations: (deprecated) ``AWS::ApiGatewayV2::DomainName.DomainNameConfigurations``.
        :param tags: (deprecated) ``AWS::ApiGatewayV2::DomainName.Tags``.

        :stability: deprecated
        """
        props = CfnDomainNameV2Props(
            domain_name=domain_name,
            domain_name_configurations=domain_name_configurations,
            tags=tags,
        )

        jsii.create(CfnDomainNameV2, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_1cd1894e) -> None:
        """(experimental) Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -

        :stability: deprecated
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """(deprecated) The CloudFormation resource type name for this resource class.

        :stability: deprecated
        """
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="attrRegionalDomainName")
    def attr_regional_domain_name(self) -> builtins.str:
        """
        :stability: deprecated
        :cloudformationAttribute: RegionalDomainName
        """
        return jsii.get(self, "attrRegionalDomainName")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="attrRegionalHostedZoneId")
    def attr_regional_hosted_zone_id(self) -> builtins.str:
        """
        :stability: deprecated
        :cloudformationAttribute: RegionalHostedZoneId
        """
        return jsii.get(self, "attrRegionalHostedZoneId")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :stability: deprecated
        """
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_0b7ab120:
        """(deprecated) ``AWS::ApiGatewayV2::DomainName.Tags``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-domainname.html#cfn-apigatewayv2-domainname-tags
        :stability: deprecated
        """
        return jsii.get(self, "tags")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="domainName")
    def domain_name(self) -> builtins.str:
        """(deprecated) ``AWS::ApiGatewayV2::DomainName.DomainName``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-domainname.html#cfn-apigatewayv2-domainname-domainname
        :stability: deprecated
        """
        return jsii.get(self, "domainName")

    @domain_name.setter # type: ignore
    def domain_name(self, value: builtins.str) -> None:
        jsii.set(self, "domainName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="domainNameConfigurations")
    def domain_name_configurations(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnDomainNameV2.DomainNameConfigurationProperty", _IResolvable_a771d0ef]]]]:
        """(deprecated) ``AWS::ApiGatewayV2::DomainName.DomainNameConfigurations``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-domainname.html#cfn-apigatewayv2-domainname-domainnameconfigurations
        :stability: deprecated
        """
        return jsii.get(self, "domainNameConfigurations")

    @domain_name_configurations.setter # type: ignore
    def domain_name_configurations(
        self,
        value: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnDomainNameV2.DomainNameConfigurationProperty", _IResolvable_a771d0ef]]]],
    ) -> None:
        jsii.set(self, "domainNameConfigurations", value)

    @jsii.data_type(
        jsii_type="monocdk.aws_apigateway.CfnDomainNameV2.DomainNameConfigurationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "certificate_arn": "certificateArn",
            "certificate_name": "certificateName",
            "endpoint_type": "endpointType",
        },
    )
    class DomainNameConfigurationProperty:
        def __init__(
            self,
            *,
            certificate_arn: typing.Optional[builtins.str] = None,
            certificate_name: typing.Optional[builtins.str] = None,
            endpoint_type: typing.Optional[builtins.str] = None,
        ) -> None:
            """
            :param certificate_arn: (deprecated) ``CfnDomainNameV2.DomainNameConfigurationProperty.CertificateArn``.
            :param certificate_name: (deprecated) ``CfnDomainNameV2.DomainNameConfigurationProperty.CertificateName``.
            :param endpoint_type: (deprecated) ``CfnDomainNameV2.DomainNameConfigurationProperty.EndpointType``.

            :deprecated: moved to package aws-apigatewayv2

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-domainname-domainnameconfiguration.html
            :stability: deprecated
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if certificate_arn is not None:
                self._values["certificate_arn"] = certificate_arn
            if certificate_name is not None:
                self._values["certificate_name"] = certificate_name
            if endpoint_type is not None:
                self._values["endpoint_type"] = endpoint_type

        @builtins.property
        def certificate_arn(self) -> typing.Optional[builtins.str]:
            """(deprecated) ``CfnDomainNameV2.DomainNameConfigurationProperty.CertificateArn``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-domainname-domainnameconfiguration.html#cfn-apigatewayv2-domainname-domainnameconfiguration-certificatearn
            :stability: deprecated
            """
            result = self._values.get("certificate_arn")
            return result

        @builtins.property
        def certificate_name(self) -> typing.Optional[builtins.str]:
            """(deprecated) ``CfnDomainNameV2.DomainNameConfigurationProperty.CertificateName``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-domainname-domainnameconfiguration.html#cfn-apigatewayv2-domainname-domainnameconfiguration-certificatename
            :stability: deprecated
            """
            result = self._values.get("certificate_name")
            return result

        @builtins.property
        def endpoint_type(self) -> typing.Optional[builtins.str]:
            """(deprecated) ``CfnDomainNameV2.DomainNameConfigurationProperty.EndpointType``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-domainname-domainnameconfiguration.html#cfn-apigatewayv2-domainname-domainnameconfiguration-endpointtype
            :stability: deprecated
            """
            result = self._values.get("endpoint_type")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DomainNameConfigurationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.CfnDomainNameV2Props",
    jsii_struct_bases=[],
    name_mapping={
        "domain_name": "domainName",
        "domain_name_configurations": "domainNameConfigurations",
        "tags": "tags",
    },
)
class CfnDomainNameV2Props:
    def __init__(
        self,
        *,
        domain_name: builtins.str,
        domain_name_configurations: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union[CfnDomainNameV2.DomainNameConfigurationProperty, _IResolvable_a771d0ef]]]] = None,
        tags: typing.Any = None,
    ) -> None:
        """(deprecated) Properties for defining a ``AWS::ApiGatewayV2::DomainName``.

        :param domain_name: (deprecated) ``AWS::ApiGatewayV2::DomainName.DomainName``.
        :param domain_name_configurations: (deprecated) ``AWS::ApiGatewayV2::DomainName.DomainNameConfigurations``.
        :param tags: (deprecated) ``AWS::ApiGatewayV2::DomainName.Tags``.

        :deprecated: moved to package aws-apigatewayv2

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-domainname.html
        :stability: deprecated
        """
        self._values: typing.Dict[str, typing.Any] = {
            "domain_name": domain_name,
        }
        if domain_name_configurations is not None:
            self._values["domain_name_configurations"] = domain_name_configurations
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def domain_name(self) -> builtins.str:
        """(deprecated) ``AWS::ApiGatewayV2::DomainName.DomainName``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-domainname.html#cfn-apigatewayv2-domainname-domainname
        :stability: deprecated
        """
        result = self._values.get("domain_name")
        assert result is not None, "Required property 'domain_name' is missing"
        return result

    @builtins.property
    def domain_name_configurations(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union[CfnDomainNameV2.DomainNameConfigurationProperty, _IResolvable_a771d0ef]]]]:
        """(deprecated) ``AWS::ApiGatewayV2::DomainName.DomainNameConfigurations``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-domainname.html#cfn-apigatewayv2-domainname-domainnameconfigurations
        :stability: deprecated
        """
        result = self._values.get("domain_name_configurations")
        return result

    @builtins.property
    def tags(self) -> typing.Any:
        """(deprecated) ``AWS::ApiGatewayV2::DomainName.Tags``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-domainname.html#cfn-apigatewayv2-domainname-tags
        :stability: deprecated
        """
        result = self._values.get("tags")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnDomainNameV2Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_82c04a63)
class CfnGatewayResponse(
    _CfnResource_e0a482dc,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_apigateway.CfnGatewayResponse",
):
    """A CloudFormation ``AWS::ApiGateway::GatewayResponse``.

    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-gatewayresponse.html
    :cloudformationResource: AWS::ApiGateway::GatewayResponse
    """

    def __init__(
        self,
        scope: _Construct_e78e779f,
        id: builtins.str,
        *,
        response_type: builtins.str,
        rest_api_id: builtins.str,
        response_parameters: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, builtins.str]]] = None,
        response_templates: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, builtins.str]]] = None,
        status_code: typing.Optional[builtins.str] = None,
    ) -> None:
        """Create a new ``AWS::ApiGateway::GatewayResponse``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param response_type: ``AWS::ApiGateway::GatewayResponse.ResponseType``.
        :param rest_api_id: ``AWS::ApiGateway::GatewayResponse.RestApiId``.
        :param response_parameters: ``AWS::ApiGateway::GatewayResponse.ResponseParameters``.
        :param response_templates: ``AWS::ApiGateway::GatewayResponse.ResponseTemplates``.
        :param status_code: ``AWS::ApiGateway::GatewayResponse.StatusCode``.
        """
        props = CfnGatewayResponseProps(
            response_type=response_type,
            rest_api_id=rest_api_id,
            response_parameters=response_parameters,
            response_templates=response_templates,
            status_code=status_code,
        )

        jsii.create(CfnGatewayResponse, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_1cd1894e) -> None:
        """(experimental) Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="responseType")
    def response_type(self) -> builtins.str:
        """``AWS::ApiGateway::GatewayResponse.ResponseType``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-gatewayresponse.html#cfn-apigateway-gatewayresponse-responsetype
        """
        return jsii.get(self, "responseType")

    @response_type.setter # type: ignore
    def response_type(self, value: builtins.str) -> None:
        jsii.set(self, "responseType", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="restApiId")
    def rest_api_id(self) -> builtins.str:
        """``AWS::ApiGateway::GatewayResponse.RestApiId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-gatewayresponse.html#cfn-apigateway-gatewayresponse-restapiid
        """
        return jsii.get(self, "restApiId")

    @rest_api_id.setter # type: ignore
    def rest_api_id(self, value: builtins.str) -> None:
        jsii.set(self, "restApiId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="responseParameters")
    def response_parameters(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, builtins.str]]]:
        """``AWS::ApiGateway::GatewayResponse.ResponseParameters``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-gatewayresponse.html#cfn-apigateway-gatewayresponse-responseparameters
        """
        return jsii.get(self, "responseParameters")

    @response_parameters.setter # type: ignore
    def response_parameters(
        self,
        value: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, builtins.str]]],
    ) -> None:
        jsii.set(self, "responseParameters", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="responseTemplates")
    def response_templates(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, builtins.str]]]:
        """``AWS::ApiGateway::GatewayResponse.ResponseTemplates``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-gatewayresponse.html#cfn-apigateway-gatewayresponse-responsetemplates
        """
        return jsii.get(self, "responseTemplates")

    @response_templates.setter # type: ignore
    def response_templates(
        self,
        value: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, builtins.str]]],
    ) -> None:
        jsii.set(self, "responseTemplates", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="statusCode")
    def status_code(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::GatewayResponse.StatusCode``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-gatewayresponse.html#cfn-apigateway-gatewayresponse-statuscode
        """
        return jsii.get(self, "statusCode")

    @status_code.setter # type: ignore
    def status_code(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "statusCode", value)


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.CfnGatewayResponseProps",
    jsii_struct_bases=[],
    name_mapping={
        "response_type": "responseType",
        "rest_api_id": "restApiId",
        "response_parameters": "responseParameters",
        "response_templates": "responseTemplates",
        "status_code": "statusCode",
    },
)
class CfnGatewayResponseProps:
    def __init__(
        self,
        *,
        response_type: builtins.str,
        rest_api_id: builtins.str,
        response_parameters: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, builtins.str]]] = None,
        response_templates: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, builtins.str]]] = None,
        status_code: typing.Optional[builtins.str] = None,
    ) -> None:
        """Properties for defining a ``AWS::ApiGateway::GatewayResponse``.

        :param response_type: ``AWS::ApiGateway::GatewayResponse.ResponseType``.
        :param rest_api_id: ``AWS::ApiGateway::GatewayResponse.RestApiId``.
        :param response_parameters: ``AWS::ApiGateway::GatewayResponse.ResponseParameters``.
        :param response_templates: ``AWS::ApiGateway::GatewayResponse.ResponseTemplates``.
        :param status_code: ``AWS::ApiGateway::GatewayResponse.StatusCode``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-gatewayresponse.html
        """
        self._values: typing.Dict[str, typing.Any] = {
            "response_type": response_type,
            "rest_api_id": rest_api_id,
        }
        if response_parameters is not None:
            self._values["response_parameters"] = response_parameters
        if response_templates is not None:
            self._values["response_templates"] = response_templates
        if status_code is not None:
            self._values["status_code"] = status_code

    @builtins.property
    def response_type(self) -> builtins.str:
        """``AWS::ApiGateway::GatewayResponse.ResponseType``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-gatewayresponse.html#cfn-apigateway-gatewayresponse-responsetype
        """
        result = self._values.get("response_type")
        assert result is not None, "Required property 'response_type' is missing"
        return result

    @builtins.property
    def rest_api_id(self) -> builtins.str:
        """``AWS::ApiGateway::GatewayResponse.RestApiId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-gatewayresponse.html#cfn-apigateway-gatewayresponse-restapiid
        """
        result = self._values.get("rest_api_id")
        assert result is not None, "Required property 'rest_api_id' is missing"
        return result

    @builtins.property
    def response_parameters(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, builtins.str]]]:
        """``AWS::ApiGateway::GatewayResponse.ResponseParameters``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-gatewayresponse.html#cfn-apigateway-gatewayresponse-responseparameters
        """
        result = self._values.get("response_parameters")
        return result

    @builtins.property
    def response_templates(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, builtins.str]]]:
        """``AWS::ApiGateway::GatewayResponse.ResponseTemplates``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-gatewayresponse.html#cfn-apigateway-gatewayresponse-responsetemplates
        """
        result = self._values.get("response_templates")
        return result

    @builtins.property
    def status_code(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::GatewayResponse.StatusCode``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-gatewayresponse.html#cfn-apigateway-gatewayresponse-statuscode
        """
        result = self._values.get("status_code")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnGatewayResponseProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_82c04a63)
class CfnIntegrationResponseV2(
    _CfnResource_e0a482dc,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_apigateway.CfnIntegrationResponseV2",
):
    """(deprecated) A CloudFormation ``AWS::ApiGatewayV2::IntegrationResponse``.

    :deprecated: moved to package aws-apigatewayv2

    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integrationresponse.html
    :stability: deprecated
    :cloudformationResource: AWS::ApiGatewayV2::IntegrationResponse
    """

    def __init__(
        self,
        scope: _Construct_e78e779f,
        id: builtins.str,
        *,
        api_id: builtins.str,
        integration_id: builtins.str,
        integration_response_key: builtins.str,
        content_handling_strategy: typing.Optional[builtins.str] = None,
        response_parameters: typing.Any = None,
        response_templates: typing.Any = None,
        template_selection_expression: typing.Optional[builtins.str] = None,
    ) -> None:
        """(deprecated) Create a new ``AWS::ApiGatewayV2::IntegrationResponse``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param api_id: (deprecated) ``AWS::ApiGatewayV2::IntegrationResponse.ApiId``.
        :param integration_id: (deprecated) ``AWS::ApiGatewayV2::IntegrationResponse.IntegrationId``.
        :param integration_response_key: (deprecated) ``AWS::ApiGatewayV2::IntegrationResponse.IntegrationResponseKey``.
        :param content_handling_strategy: (deprecated) ``AWS::ApiGatewayV2::IntegrationResponse.ContentHandlingStrategy``.
        :param response_parameters: (deprecated) ``AWS::ApiGatewayV2::IntegrationResponse.ResponseParameters``.
        :param response_templates: (deprecated) ``AWS::ApiGatewayV2::IntegrationResponse.ResponseTemplates``.
        :param template_selection_expression: (deprecated) ``AWS::ApiGatewayV2::IntegrationResponse.TemplateSelectionExpression``.

        :stability: deprecated
        """
        props = CfnIntegrationResponseV2Props(
            api_id=api_id,
            integration_id=integration_id,
            integration_response_key=integration_response_key,
            content_handling_strategy=content_handling_strategy,
            response_parameters=response_parameters,
            response_templates=response_templates,
            template_selection_expression=template_selection_expression,
        )

        jsii.create(CfnIntegrationResponseV2, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_1cd1894e) -> None:
        """(experimental) Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -

        :stability: deprecated
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """(deprecated) The CloudFormation resource type name for this resource class.

        :stability: deprecated
        """
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :stability: deprecated
        """
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiId")
    def api_id(self) -> builtins.str:
        """(deprecated) ``AWS::ApiGatewayV2::IntegrationResponse.ApiId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integrationresponse.html#cfn-apigatewayv2-integrationresponse-apiid
        :stability: deprecated
        """
        return jsii.get(self, "apiId")

    @api_id.setter # type: ignore
    def api_id(self, value: builtins.str) -> None:
        jsii.set(self, "apiId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="integrationId")
    def integration_id(self) -> builtins.str:
        """(deprecated) ``AWS::ApiGatewayV2::IntegrationResponse.IntegrationId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integrationresponse.html#cfn-apigatewayv2-integrationresponse-integrationid
        :stability: deprecated
        """
        return jsii.get(self, "integrationId")

    @integration_id.setter # type: ignore
    def integration_id(self, value: builtins.str) -> None:
        jsii.set(self, "integrationId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="integrationResponseKey")
    def integration_response_key(self) -> builtins.str:
        """(deprecated) ``AWS::ApiGatewayV2::IntegrationResponse.IntegrationResponseKey``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integrationresponse.html#cfn-apigatewayv2-integrationresponse-integrationresponsekey
        :stability: deprecated
        """
        return jsii.get(self, "integrationResponseKey")

    @integration_response_key.setter # type: ignore
    def integration_response_key(self, value: builtins.str) -> None:
        jsii.set(self, "integrationResponseKey", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="responseParameters")
    def response_parameters(self) -> typing.Any:
        """(deprecated) ``AWS::ApiGatewayV2::IntegrationResponse.ResponseParameters``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integrationresponse.html#cfn-apigatewayv2-integrationresponse-responseparameters
        :stability: deprecated
        """
        return jsii.get(self, "responseParameters")

    @response_parameters.setter # type: ignore
    def response_parameters(self, value: typing.Any) -> None:
        jsii.set(self, "responseParameters", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="responseTemplates")
    def response_templates(self) -> typing.Any:
        """(deprecated) ``AWS::ApiGatewayV2::IntegrationResponse.ResponseTemplates``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integrationresponse.html#cfn-apigatewayv2-integrationresponse-responsetemplates
        :stability: deprecated
        """
        return jsii.get(self, "responseTemplates")

    @response_templates.setter # type: ignore
    def response_templates(self, value: typing.Any) -> None:
        jsii.set(self, "responseTemplates", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="contentHandlingStrategy")
    def content_handling_strategy(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::IntegrationResponse.ContentHandlingStrategy``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integrationresponse.html#cfn-apigatewayv2-integrationresponse-contenthandlingstrategy
        :stability: deprecated
        """
        return jsii.get(self, "contentHandlingStrategy")

    @content_handling_strategy.setter # type: ignore
    def content_handling_strategy(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "contentHandlingStrategy", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="templateSelectionExpression")
    def template_selection_expression(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::IntegrationResponse.TemplateSelectionExpression``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integrationresponse.html#cfn-apigatewayv2-integrationresponse-templateselectionexpression
        :stability: deprecated
        """
        return jsii.get(self, "templateSelectionExpression")

    @template_selection_expression.setter # type: ignore
    def template_selection_expression(
        self,
        value: typing.Optional[builtins.str],
    ) -> None:
        jsii.set(self, "templateSelectionExpression", value)


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.CfnIntegrationResponseV2Props",
    jsii_struct_bases=[],
    name_mapping={
        "api_id": "apiId",
        "integration_id": "integrationId",
        "integration_response_key": "integrationResponseKey",
        "content_handling_strategy": "contentHandlingStrategy",
        "response_parameters": "responseParameters",
        "response_templates": "responseTemplates",
        "template_selection_expression": "templateSelectionExpression",
    },
)
class CfnIntegrationResponseV2Props:
    def __init__(
        self,
        *,
        api_id: builtins.str,
        integration_id: builtins.str,
        integration_response_key: builtins.str,
        content_handling_strategy: typing.Optional[builtins.str] = None,
        response_parameters: typing.Any = None,
        response_templates: typing.Any = None,
        template_selection_expression: typing.Optional[builtins.str] = None,
    ) -> None:
        """(deprecated) Properties for defining a ``AWS::ApiGatewayV2::IntegrationResponse``.

        :param api_id: (deprecated) ``AWS::ApiGatewayV2::IntegrationResponse.ApiId``.
        :param integration_id: (deprecated) ``AWS::ApiGatewayV2::IntegrationResponse.IntegrationId``.
        :param integration_response_key: (deprecated) ``AWS::ApiGatewayV2::IntegrationResponse.IntegrationResponseKey``.
        :param content_handling_strategy: (deprecated) ``AWS::ApiGatewayV2::IntegrationResponse.ContentHandlingStrategy``.
        :param response_parameters: (deprecated) ``AWS::ApiGatewayV2::IntegrationResponse.ResponseParameters``.
        :param response_templates: (deprecated) ``AWS::ApiGatewayV2::IntegrationResponse.ResponseTemplates``.
        :param template_selection_expression: (deprecated) ``AWS::ApiGatewayV2::IntegrationResponse.TemplateSelectionExpression``.

        :deprecated: moved to package aws-apigatewayv2

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integrationresponse.html
        :stability: deprecated
        """
        self._values: typing.Dict[str, typing.Any] = {
            "api_id": api_id,
            "integration_id": integration_id,
            "integration_response_key": integration_response_key,
        }
        if content_handling_strategy is not None:
            self._values["content_handling_strategy"] = content_handling_strategy
        if response_parameters is not None:
            self._values["response_parameters"] = response_parameters
        if response_templates is not None:
            self._values["response_templates"] = response_templates
        if template_selection_expression is not None:
            self._values["template_selection_expression"] = template_selection_expression

    @builtins.property
    def api_id(self) -> builtins.str:
        """(deprecated) ``AWS::ApiGatewayV2::IntegrationResponse.ApiId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integrationresponse.html#cfn-apigatewayv2-integrationresponse-apiid
        :stability: deprecated
        """
        result = self._values.get("api_id")
        assert result is not None, "Required property 'api_id' is missing"
        return result

    @builtins.property
    def integration_id(self) -> builtins.str:
        """(deprecated) ``AWS::ApiGatewayV2::IntegrationResponse.IntegrationId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integrationresponse.html#cfn-apigatewayv2-integrationresponse-integrationid
        :stability: deprecated
        """
        result = self._values.get("integration_id")
        assert result is not None, "Required property 'integration_id' is missing"
        return result

    @builtins.property
    def integration_response_key(self) -> builtins.str:
        """(deprecated) ``AWS::ApiGatewayV2::IntegrationResponse.IntegrationResponseKey``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integrationresponse.html#cfn-apigatewayv2-integrationresponse-integrationresponsekey
        :stability: deprecated
        """
        result = self._values.get("integration_response_key")
        assert result is not None, "Required property 'integration_response_key' is missing"
        return result

    @builtins.property
    def content_handling_strategy(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::IntegrationResponse.ContentHandlingStrategy``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integrationresponse.html#cfn-apigatewayv2-integrationresponse-contenthandlingstrategy
        :stability: deprecated
        """
        result = self._values.get("content_handling_strategy")
        return result

    @builtins.property
    def response_parameters(self) -> typing.Any:
        """(deprecated) ``AWS::ApiGatewayV2::IntegrationResponse.ResponseParameters``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integrationresponse.html#cfn-apigatewayv2-integrationresponse-responseparameters
        :stability: deprecated
        """
        result = self._values.get("response_parameters")
        return result

    @builtins.property
    def response_templates(self) -> typing.Any:
        """(deprecated) ``AWS::ApiGatewayV2::IntegrationResponse.ResponseTemplates``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integrationresponse.html#cfn-apigatewayv2-integrationresponse-responsetemplates
        :stability: deprecated
        """
        result = self._values.get("response_templates")
        return result

    @builtins.property
    def template_selection_expression(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::IntegrationResponse.TemplateSelectionExpression``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integrationresponse.html#cfn-apigatewayv2-integrationresponse-templateselectionexpression
        :stability: deprecated
        """
        result = self._values.get("template_selection_expression")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnIntegrationResponseV2Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_82c04a63)
class CfnIntegrationV2(
    _CfnResource_e0a482dc,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_apigateway.CfnIntegrationV2",
):
    """(deprecated) A CloudFormation ``AWS::ApiGatewayV2::Integration``.

    :deprecated: moved to package aws-apigatewayv2

    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html
    :stability: deprecated
    :cloudformationResource: AWS::ApiGatewayV2::Integration
    """

    def __init__(
        self,
        scope: _Construct_e78e779f,
        id: builtins.str,
        *,
        api_id: builtins.str,
        integration_type: builtins.str,
        connection_type: typing.Optional[builtins.str] = None,
        content_handling_strategy: typing.Optional[builtins.str] = None,
        credentials_arn: typing.Optional[builtins.str] = None,
        description: typing.Optional[builtins.str] = None,
        integration_method: typing.Optional[builtins.str] = None,
        integration_uri: typing.Optional[builtins.str] = None,
        passthrough_behavior: typing.Optional[builtins.str] = None,
        payload_format_version: typing.Optional[builtins.str] = None,
        request_parameters: typing.Any = None,
        request_templates: typing.Any = None,
        template_selection_expression: typing.Optional[builtins.str] = None,
        timeout_in_millis: typing.Optional[jsii.Number] = None,
    ) -> None:
        """(deprecated) Create a new ``AWS::ApiGatewayV2::Integration``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param api_id: (deprecated) ``AWS::ApiGatewayV2::Integration.ApiId``.
        :param integration_type: (deprecated) ``AWS::ApiGatewayV2::Integration.IntegrationType``.
        :param connection_type: (deprecated) ``AWS::ApiGatewayV2::Integration.ConnectionType``.
        :param content_handling_strategy: (deprecated) ``AWS::ApiGatewayV2::Integration.ContentHandlingStrategy``.
        :param credentials_arn: (deprecated) ``AWS::ApiGatewayV2::Integration.CredentialsArn``.
        :param description: (deprecated) ``AWS::ApiGatewayV2::Integration.Description``.
        :param integration_method: (deprecated) ``AWS::ApiGatewayV2::Integration.IntegrationMethod``.
        :param integration_uri: (deprecated) ``AWS::ApiGatewayV2::Integration.IntegrationUri``.
        :param passthrough_behavior: (deprecated) ``AWS::ApiGatewayV2::Integration.PassthroughBehavior``.
        :param payload_format_version: (deprecated) ``AWS::ApiGatewayV2::Integration.PayloadFormatVersion``.
        :param request_parameters: (deprecated) ``AWS::ApiGatewayV2::Integration.RequestParameters``.
        :param request_templates: (deprecated) ``AWS::ApiGatewayV2::Integration.RequestTemplates``.
        :param template_selection_expression: (deprecated) ``AWS::ApiGatewayV2::Integration.TemplateSelectionExpression``.
        :param timeout_in_millis: (deprecated) ``AWS::ApiGatewayV2::Integration.TimeoutInMillis``.

        :stability: deprecated
        """
        props = CfnIntegrationV2Props(
            api_id=api_id,
            integration_type=integration_type,
            connection_type=connection_type,
            content_handling_strategy=content_handling_strategy,
            credentials_arn=credentials_arn,
            description=description,
            integration_method=integration_method,
            integration_uri=integration_uri,
            passthrough_behavior=passthrough_behavior,
            payload_format_version=payload_format_version,
            request_parameters=request_parameters,
            request_templates=request_templates,
            template_selection_expression=template_selection_expression,
            timeout_in_millis=timeout_in_millis,
        )

        jsii.create(CfnIntegrationV2, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_1cd1894e) -> None:
        """(experimental) Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -

        :stability: deprecated
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """(deprecated) The CloudFormation resource type name for this resource class.

        :stability: deprecated
        """
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :stability: deprecated
        """
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiId")
    def api_id(self) -> builtins.str:
        """(deprecated) ``AWS::ApiGatewayV2::Integration.ApiId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-apiid
        :stability: deprecated
        """
        return jsii.get(self, "apiId")

    @api_id.setter # type: ignore
    def api_id(self, value: builtins.str) -> None:
        jsii.set(self, "apiId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="integrationType")
    def integration_type(self) -> builtins.str:
        """(deprecated) ``AWS::ApiGatewayV2::Integration.IntegrationType``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-integrationtype
        :stability: deprecated
        """
        return jsii.get(self, "integrationType")

    @integration_type.setter # type: ignore
    def integration_type(self, value: builtins.str) -> None:
        jsii.set(self, "integrationType", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="requestParameters")
    def request_parameters(self) -> typing.Any:
        """(deprecated) ``AWS::ApiGatewayV2::Integration.RequestParameters``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-requestparameters
        :stability: deprecated
        """
        return jsii.get(self, "requestParameters")

    @request_parameters.setter # type: ignore
    def request_parameters(self, value: typing.Any) -> None:
        jsii.set(self, "requestParameters", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="requestTemplates")
    def request_templates(self) -> typing.Any:
        """(deprecated) ``AWS::ApiGatewayV2::Integration.RequestTemplates``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-requesttemplates
        :stability: deprecated
        """
        return jsii.get(self, "requestTemplates")

    @request_templates.setter # type: ignore
    def request_templates(self, value: typing.Any) -> None:
        jsii.set(self, "requestTemplates", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="connectionType")
    def connection_type(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Integration.ConnectionType``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-connectiontype
        :stability: deprecated
        """
        return jsii.get(self, "connectionType")

    @connection_type.setter # type: ignore
    def connection_type(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "connectionType", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="contentHandlingStrategy")
    def content_handling_strategy(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Integration.ContentHandlingStrategy``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-contenthandlingstrategy
        :stability: deprecated
        """
        return jsii.get(self, "contentHandlingStrategy")

    @content_handling_strategy.setter # type: ignore
    def content_handling_strategy(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "contentHandlingStrategy", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="credentialsArn")
    def credentials_arn(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Integration.CredentialsArn``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-credentialsarn
        :stability: deprecated
        """
        return jsii.get(self, "credentialsArn")

    @credentials_arn.setter # type: ignore
    def credentials_arn(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "credentialsArn", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Integration.Description``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-description
        :stability: deprecated
        """
        return jsii.get(self, "description")

    @description.setter # type: ignore
    def description(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "description", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="integrationMethod")
    def integration_method(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Integration.IntegrationMethod``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-integrationmethod
        :stability: deprecated
        """
        return jsii.get(self, "integrationMethod")

    @integration_method.setter # type: ignore
    def integration_method(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "integrationMethod", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="integrationUri")
    def integration_uri(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Integration.IntegrationUri``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-integrationuri
        :stability: deprecated
        """
        return jsii.get(self, "integrationUri")

    @integration_uri.setter # type: ignore
    def integration_uri(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "integrationUri", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="passthroughBehavior")
    def passthrough_behavior(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Integration.PassthroughBehavior``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-passthroughbehavior
        :stability: deprecated
        """
        return jsii.get(self, "passthroughBehavior")

    @passthrough_behavior.setter # type: ignore
    def passthrough_behavior(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "passthroughBehavior", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="payloadFormatVersion")
    def payload_format_version(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Integration.PayloadFormatVersion``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-payloadformatversion
        :stability: deprecated
        """
        return jsii.get(self, "payloadFormatVersion")

    @payload_format_version.setter # type: ignore
    def payload_format_version(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "payloadFormatVersion", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="templateSelectionExpression")
    def template_selection_expression(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Integration.TemplateSelectionExpression``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-templateselectionexpression
        :stability: deprecated
        """
        return jsii.get(self, "templateSelectionExpression")

    @template_selection_expression.setter # type: ignore
    def template_selection_expression(
        self,
        value: typing.Optional[builtins.str],
    ) -> None:
        jsii.set(self, "templateSelectionExpression", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeoutInMillis")
    def timeout_in_millis(self) -> typing.Optional[jsii.Number]:
        """(deprecated) ``AWS::ApiGatewayV2::Integration.TimeoutInMillis``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-timeoutinmillis
        :stability: deprecated
        """
        return jsii.get(self, "timeoutInMillis")

    @timeout_in_millis.setter # type: ignore
    def timeout_in_millis(self, value: typing.Optional[jsii.Number]) -> None:
        jsii.set(self, "timeoutInMillis", value)


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.CfnIntegrationV2Props",
    jsii_struct_bases=[],
    name_mapping={
        "api_id": "apiId",
        "integration_type": "integrationType",
        "connection_type": "connectionType",
        "content_handling_strategy": "contentHandlingStrategy",
        "credentials_arn": "credentialsArn",
        "description": "description",
        "integration_method": "integrationMethod",
        "integration_uri": "integrationUri",
        "passthrough_behavior": "passthroughBehavior",
        "payload_format_version": "payloadFormatVersion",
        "request_parameters": "requestParameters",
        "request_templates": "requestTemplates",
        "template_selection_expression": "templateSelectionExpression",
        "timeout_in_millis": "timeoutInMillis",
    },
)
class CfnIntegrationV2Props:
    def __init__(
        self,
        *,
        api_id: builtins.str,
        integration_type: builtins.str,
        connection_type: typing.Optional[builtins.str] = None,
        content_handling_strategy: typing.Optional[builtins.str] = None,
        credentials_arn: typing.Optional[builtins.str] = None,
        description: typing.Optional[builtins.str] = None,
        integration_method: typing.Optional[builtins.str] = None,
        integration_uri: typing.Optional[builtins.str] = None,
        passthrough_behavior: typing.Optional[builtins.str] = None,
        payload_format_version: typing.Optional[builtins.str] = None,
        request_parameters: typing.Any = None,
        request_templates: typing.Any = None,
        template_selection_expression: typing.Optional[builtins.str] = None,
        timeout_in_millis: typing.Optional[jsii.Number] = None,
    ) -> None:
        """(deprecated) Properties for defining a ``AWS::ApiGatewayV2::Integration``.

        :param api_id: (deprecated) ``AWS::ApiGatewayV2::Integration.ApiId``.
        :param integration_type: (deprecated) ``AWS::ApiGatewayV2::Integration.IntegrationType``.
        :param connection_type: (deprecated) ``AWS::ApiGatewayV2::Integration.ConnectionType``.
        :param content_handling_strategy: (deprecated) ``AWS::ApiGatewayV2::Integration.ContentHandlingStrategy``.
        :param credentials_arn: (deprecated) ``AWS::ApiGatewayV2::Integration.CredentialsArn``.
        :param description: (deprecated) ``AWS::ApiGatewayV2::Integration.Description``.
        :param integration_method: (deprecated) ``AWS::ApiGatewayV2::Integration.IntegrationMethod``.
        :param integration_uri: (deprecated) ``AWS::ApiGatewayV2::Integration.IntegrationUri``.
        :param passthrough_behavior: (deprecated) ``AWS::ApiGatewayV2::Integration.PassthroughBehavior``.
        :param payload_format_version: (deprecated) ``AWS::ApiGatewayV2::Integration.PayloadFormatVersion``.
        :param request_parameters: (deprecated) ``AWS::ApiGatewayV2::Integration.RequestParameters``.
        :param request_templates: (deprecated) ``AWS::ApiGatewayV2::Integration.RequestTemplates``.
        :param template_selection_expression: (deprecated) ``AWS::ApiGatewayV2::Integration.TemplateSelectionExpression``.
        :param timeout_in_millis: (deprecated) ``AWS::ApiGatewayV2::Integration.TimeoutInMillis``.

        :deprecated: moved to package aws-apigatewayv2

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html
        :stability: deprecated
        """
        self._values: typing.Dict[str, typing.Any] = {
            "api_id": api_id,
            "integration_type": integration_type,
        }
        if connection_type is not None:
            self._values["connection_type"] = connection_type
        if content_handling_strategy is not None:
            self._values["content_handling_strategy"] = content_handling_strategy
        if credentials_arn is not None:
            self._values["credentials_arn"] = credentials_arn
        if description is not None:
            self._values["description"] = description
        if integration_method is not None:
            self._values["integration_method"] = integration_method
        if integration_uri is not None:
            self._values["integration_uri"] = integration_uri
        if passthrough_behavior is not None:
            self._values["passthrough_behavior"] = passthrough_behavior
        if payload_format_version is not None:
            self._values["payload_format_version"] = payload_format_version
        if request_parameters is not None:
            self._values["request_parameters"] = request_parameters
        if request_templates is not None:
            self._values["request_templates"] = request_templates
        if template_selection_expression is not None:
            self._values["template_selection_expression"] = template_selection_expression
        if timeout_in_millis is not None:
            self._values["timeout_in_millis"] = timeout_in_millis

    @builtins.property
    def api_id(self) -> builtins.str:
        """(deprecated) ``AWS::ApiGatewayV2::Integration.ApiId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-apiid
        :stability: deprecated
        """
        result = self._values.get("api_id")
        assert result is not None, "Required property 'api_id' is missing"
        return result

    @builtins.property
    def integration_type(self) -> builtins.str:
        """(deprecated) ``AWS::ApiGatewayV2::Integration.IntegrationType``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-integrationtype
        :stability: deprecated
        """
        result = self._values.get("integration_type")
        assert result is not None, "Required property 'integration_type' is missing"
        return result

    @builtins.property
    def connection_type(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Integration.ConnectionType``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-connectiontype
        :stability: deprecated
        """
        result = self._values.get("connection_type")
        return result

    @builtins.property
    def content_handling_strategy(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Integration.ContentHandlingStrategy``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-contenthandlingstrategy
        :stability: deprecated
        """
        result = self._values.get("content_handling_strategy")
        return result

    @builtins.property
    def credentials_arn(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Integration.CredentialsArn``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-credentialsarn
        :stability: deprecated
        """
        result = self._values.get("credentials_arn")
        return result

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Integration.Description``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-description
        :stability: deprecated
        """
        result = self._values.get("description")
        return result

    @builtins.property
    def integration_method(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Integration.IntegrationMethod``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-integrationmethod
        :stability: deprecated
        """
        result = self._values.get("integration_method")
        return result

    @builtins.property
    def integration_uri(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Integration.IntegrationUri``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-integrationuri
        :stability: deprecated
        """
        result = self._values.get("integration_uri")
        return result

    @builtins.property
    def passthrough_behavior(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Integration.PassthroughBehavior``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-passthroughbehavior
        :stability: deprecated
        """
        result = self._values.get("passthrough_behavior")
        return result

    @builtins.property
    def payload_format_version(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Integration.PayloadFormatVersion``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-payloadformatversion
        :stability: deprecated
        """
        result = self._values.get("payload_format_version")
        return result

    @builtins.property
    def request_parameters(self) -> typing.Any:
        """(deprecated) ``AWS::ApiGatewayV2::Integration.RequestParameters``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-requestparameters
        :stability: deprecated
        """
        result = self._values.get("request_parameters")
        return result

    @builtins.property
    def request_templates(self) -> typing.Any:
        """(deprecated) ``AWS::ApiGatewayV2::Integration.RequestTemplates``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-requesttemplates
        :stability: deprecated
        """
        result = self._values.get("request_templates")
        return result

    @builtins.property
    def template_selection_expression(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Integration.TemplateSelectionExpression``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-templateselectionexpression
        :stability: deprecated
        """
        result = self._values.get("template_selection_expression")
        return result

    @builtins.property
    def timeout_in_millis(self) -> typing.Optional[jsii.Number]:
        """(deprecated) ``AWS::ApiGatewayV2::Integration.TimeoutInMillis``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-timeoutinmillis
        :stability: deprecated
        """
        result = self._values.get("timeout_in_millis")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnIntegrationV2Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_82c04a63)
class CfnMethod(
    _CfnResource_e0a482dc,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_apigateway.CfnMethod",
):
    """A CloudFormation ``AWS::ApiGateway::Method``.

    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html
    :cloudformationResource: AWS::ApiGateway::Method
    """

    def __init__(
        self,
        scope: _Construct_e78e779f,
        id: builtins.str,
        *,
        http_method: builtins.str,
        resource_id: builtins.str,
        rest_api_id: builtins.str,
        api_key_required: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
        authorization_scopes: typing.Optional[typing.List[builtins.str]] = None,
        authorization_type: typing.Optional[builtins.str] = None,
        authorizer_id: typing.Optional[builtins.str] = None,
        integration: typing.Optional[typing.Union["CfnMethod.IntegrationProperty", _IResolvable_a771d0ef]] = None,
        method_responses: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnMethod.MethodResponseProperty", _IResolvable_a771d0ef]]]] = None,
        operation_name: typing.Optional[builtins.str] = None,
        request_models: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, builtins.str]]] = None,
        request_parameters: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, typing.Union[builtins.bool, _IResolvable_a771d0ef]]]] = None,
        request_validator_id: typing.Optional[builtins.str] = None,
    ) -> None:
        """Create a new ``AWS::ApiGateway::Method``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param http_method: ``AWS::ApiGateway::Method.HttpMethod``.
        :param resource_id: ``AWS::ApiGateway::Method.ResourceId``.
        :param rest_api_id: ``AWS::ApiGateway::Method.RestApiId``.
        :param api_key_required: ``AWS::ApiGateway::Method.ApiKeyRequired``.
        :param authorization_scopes: ``AWS::ApiGateway::Method.AuthorizationScopes``.
        :param authorization_type: ``AWS::ApiGateway::Method.AuthorizationType``.
        :param authorizer_id: ``AWS::ApiGateway::Method.AuthorizerId``.
        :param integration: ``AWS::ApiGateway::Method.Integration``.
        :param method_responses: ``AWS::ApiGateway::Method.MethodResponses``.
        :param operation_name: ``AWS::ApiGateway::Method.OperationName``.
        :param request_models: ``AWS::ApiGateway::Method.RequestModels``.
        :param request_parameters: ``AWS::ApiGateway::Method.RequestParameters``.
        :param request_validator_id: ``AWS::ApiGateway::Method.RequestValidatorId``.
        """
        props = CfnMethodProps(
            http_method=http_method,
            resource_id=resource_id,
            rest_api_id=rest_api_id,
            api_key_required=api_key_required,
            authorization_scopes=authorization_scopes,
            authorization_type=authorization_type,
            authorizer_id=authorizer_id,
            integration=integration,
            method_responses=method_responses,
            operation_name=operation_name,
            request_models=request_models,
            request_parameters=request_parameters,
            request_validator_id=request_validator_id,
        )

        jsii.create(CfnMethod, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_1cd1894e) -> None:
        """(experimental) Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="httpMethod")
    def http_method(self) -> builtins.str:
        """``AWS::ApiGateway::Method.HttpMethod``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-httpmethod
        """
        return jsii.get(self, "httpMethod")

    @http_method.setter # type: ignore
    def http_method(self, value: builtins.str) -> None:
        jsii.set(self, "httpMethod", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceId")
    def resource_id(self) -> builtins.str:
        """``AWS::ApiGateway::Method.ResourceId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-resourceid
        """
        return jsii.get(self, "resourceId")

    @resource_id.setter # type: ignore
    def resource_id(self, value: builtins.str) -> None:
        jsii.set(self, "resourceId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="restApiId")
    def rest_api_id(self) -> builtins.str:
        """``AWS::ApiGateway::Method.RestApiId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-restapiid
        """
        return jsii.get(self, "restApiId")

    @rest_api_id.setter # type: ignore
    def rest_api_id(self, value: builtins.str) -> None:
        jsii.set(self, "restApiId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiKeyRequired")
    def api_key_required(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
        """``AWS::ApiGateway::Method.ApiKeyRequired``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-apikeyrequired
        """
        return jsii.get(self, "apiKeyRequired")

    @api_key_required.setter # type: ignore
    def api_key_required(
        self,
        value: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]],
    ) -> None:
        jsii.set(self, "apiKeyRequired", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="authorizationScopes")
    def authorization_scopes(self) -> typing.Optional[typing.List[builtins.str]]:
        """``AWS::ApiGateway::Method.AuthorizationScopes``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationscopes
        """
        return jsii.get(self, "authorizationScopes")

    @authorization_scopes.setter # type: ignore
    def authorization_scopes(
        self,
        value: typing.Optional[typing.List[builtins.str]],
    ) -> None:
        jsii.set(self, "authorizationScopes", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="authorizationType")
    def authorization_type(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::Method.AuthorizationType``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationtype
        """
        return jsii.get(self, "authorizationType")

    @authorization_type.setter # type: ignore
    def authorization_type(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "authorizationType", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="authorizerId")
    def authorizer_id(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::Method.AuthorizerId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizerid
        """
        return jsii.get(self, "authorizerId")

    @authorizer_id.setter # type: ignore
    def authorizer_id(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "authorizerId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="integration")
    def integration(
        self,
    ) -> typing.Optional[typing.Union["CfnMethod.IntegrationProperty", _IResolvable_a771d0ef]]:
        """``AWS::ApiGateway::Method.Integration``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-integration
        """
        return jsii.get(self, "integration")

    @integration.setter # type: ignore
    def integration(
        self,
        value: typing.Optional[typing.Union["CfnMethod.IntegrationProperty", _IResolvable_a771d0ef]],
    ) -> None:
        jsii.set(self, "integration", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="methodResponses")
    def method_responses(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnMethod.MethodResponseProperty", _IResolvable_a771d0ef]]]]:
        """``AWS::ApiGateway::Method.MethodResponses``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-methodresponses
        """
        return jsii.get(self, "methodResponses")

    @method_responses.setter # type: ignore
    def method_responses(
        self,
        value: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnMethod.MethodResponseProperty", _IResolvable_a771d0ef]]]],
    ) -> None:
        jsii.set(self, "methodResponses", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="operationName")
    def operation_name(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::Method.OperationName``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-operationname
        """
        return jsii.get(self, "operationName")

    @operation_name.setter # type: ignore
    def operation_name(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "operationName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="requestModels")
    def request_models(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, builtins.str]]]:
        """``AWS::ApiGateway::Method.RequestModels``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestmodels
        """
        return jsii.get(self, "requestModels")

    @request_models.setter # type: ignore
    def request_models(
        self,
        value: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, builtins.str]]],
    ) -> None:
        jsii.set(self, "requestModels", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="requestParameters")
    def request_parameters(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, typing.Union[builtins.bool, _IResolvable_a771d0ef]]]]:
        """``AWS::ApiGateway::Method.RequestParameters``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestparameters
        """
        return jsii.get(self, "requestParameters")

    @request_parameters.setter # type: ignore
    def request_parameters(
        self,
        value: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, typing.Union[builtins.bool, _IResolvable_a771d0ef]]]],
    ) -> None:
        jsii.set(self, "requestParameters", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="requestValidatorId")
    def request_validator_id(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::Method.RequestValidatorId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestvalidatorid
        """
        return jsii.get(self, "requestValidatorId")

    @request_validator_id.setter # type: ignore
    def request_validator_id(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "requestValidatorId", value)

    @jsii.data_type(
        jsii_type="monocdk.aws_apigateway.CfnMethod.IntegrationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "cache_key_parameters": "cacheKeyParameters",
            "cache_namespace": "cacheNamespace",
            "connection_id": "connectionId",
            "connection_type": "connectionType",
            "content_handling": "contentHandling",
            "credentials": "credentials",
            "integration_http_method": "integrationHttpMethod",
            "integration_responses": "integrationResponses",
            "passthrough_behavior": "passthroughBehavior",
            "request_parameters": "requestParameters",
            "request_templates": "requestTemplates",
            "timeout_in_millis": "timeoutInMillis",
            "type": "type",
            "uri": "uri",
        },
    )
    class IntegrationProperty:
        def __init__(
            self,
            *,
            cache_key_parameters: typing.Optional[typing.List[builtins.str]] = None,
            cache_namespace: typing.Optional[builtins.str] = None,
            connection_id: typing.Optional[builtins.str] = None,
            connection_type: typing.Optional[builtins.str] = None,
            content_handling: typing.Optional[builtins.str] = None,
            credentials: typing.Optional[builtins.str] = None,
            integration_http_method: typing.Optional[builtins.str] = None,
            integration_responses: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnMethod.IntegrationResponseProperty", _IResolvable_a771d0ef]]]] = None,
            passthrough_behavior: typing.Optional[builtins.str] = None,
            request_parameters: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, builtins.str]]] = None,
            request_templates: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, builtins.str]]] = None,
            timeout_in_millis: typing.Optional[jsii.Number] = None,
            type: typing.Optional[builtins.str] = None,
            uri: typing.Optional[builtins.str] = None,
        ) -> None:
            """
            :param cache_key_parameters: ``CfnMethod.IntegrationProperty.CacheKeyParameters``.
            :param cache_namespace: ``CfnMethod.IntegrationProperty.CacheNamespace``.
            :param connection_id: ``CfnMethod.IntegrationProperty.ConnectionId``.
            :param connection_type: ``CfnMethod.IntegrationProperty.ConnectionType``.
            :param content_handling: ``CfnMethod.IntegrationProperty.ContentHandling``.
            :param credentials: ``CfnMethod.IntegrationProperty.Credentials``.
            :param integration_http_method: ``CfnMethod.IntegrationProperty.IntegrationHttpMethod``.
            :param integration_responses: ``CfnMethod.IntegrationProperty.IntegrationResponses``.
            :param passthrough_behavior: ``CfnMethod.IntegrationProperty.PassthroughBehavior``.
            :param request_parameters: ``CfnMethod.IntegrationProperty.RequestParameters``.
            :param request_templates: ``CfnMethod.IntegrationProperty.RequestTemplates``.
            :param timeout_in_millis: ``CfnMethod.IntegrationProperty.TimeoutInMillis``.
            :param type: ``CfnMethod.IntegrationProperty.Type``.
            :param uri: ``CfnMethod.IntegrationProperty.Uri``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if cache_key_parameters is not None:
                self._values["cache_key_parameters"] = cache_key_parameters
            if cache_namespace is not None:
                self._values["cache_namespace"] = cache_namespace
            if connection_id is not None:
                self._values["connection_id"] = connection_id
            if connection_type is not None:
                self._values["connection_type"] = connection_type
            if content_handling is not None:
                self._values["content_handling"] = content_handling
            if credentials is not None:
                self._values["credentials"] = credentials
            if integration_http_method is not None:
                self._values["integration_http_method"] = integration_http_method
            if integration_responses is not None:
                self._values["integration_responses"] = integration_responses
            if passthrough_behavior is not None:
                self._values["passthrough_behavior"] = passthrough_behavior
            if request_parameters is not None:
                self._values["request_parameters"] = request_parameters
            if request_templates is not None:
                self._values["request_templates"] = request_templates
            if timeout_in_millis is not None:
                self._values["timeout_in_millis"] = timeout_in_millis
            if type is not None:
                self._values["type"] = type
            if uri is not None:
                self._values["uri"] = uri

        @builtins.property
        def cache_key_parameters(self) -> typing.Optional[typing.List[builtins.str]]:
            """``CfnMethod.IntegrationProperty.CacheKeyParameters``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-cachekeyparameters
            """
            result = self._values.get("cache_key_parameters")
            return result

        @builtins.property
        def cache_namespace(self) -> typing.Optional[builtins.str]:
            """``CfnMethod.IntegrationProperty.CacheNamespace``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-cachenamespace
            """
            result = self._values.get("cache_namespace")
            return result

        @builtins.property
        def connection_id(self) -> typing.Optional[builtins.str]:
            """``CfnMethod.IntegrationProperty.ConnectionId``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-connectionid
            """
            result = self._values.get("connection_id")
            return result

        @builtins.property
        def connection_type(self) -> typing.Optional[builtins.str]:
            """``CfnMethod.IntegrationProperty.ConnectionType``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-connectiontype
            """
            result = self._values.get("connection_type")
            return result

        @builtins.property
        def content_handling(self) -> typing.Optional[builtins.str]:
            """``CfnMethod.IntegrationProperty.ContentHandling``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-contenthandling
            """
            result = self._values.get("content_handling")
            return result

        @builtins.property
        def credentials(self) -> typing.Optional[builtins.str]:
            """``CfnMethod.IntegrationProperty.Credentials``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-credentials
            """
            result = self._values.get("credentials")
            return result

        @builtins.property
        def integration_http_method(self) -> typing.Optional[builtins.str]:
            """``CfnMethod.IntegrationProperty.IntegrationHttpMethod``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-integrationhttpmethod
            """
            result = self._values.get("integration_http_method")
            return result

        @builtins.property
        def integration_responses(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnMethod.IntegrationResponseProperty", _IResolvable_a771d0ef]]]]:
            """``CfnMethod.IntegrationProperty.IntegrationResponses``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-integrationresponses
            """
            result = self._values.get("integration_responses")
            return result

        @builtins.property
        def passthrough_behavior(self) -> typing.Optional[builtins.str]:
            """``CfnMethod.IntegrationProperty.PassthroughBehavior``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-passthroughbehavior
            """
            result = self._values.get("passthrough_behavior")
            return result

        @builtins.property
        def request_parameters(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, builtins.str]]]:
            """``CfnMethod.IntegrationProperty.RequestParameters``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-requestparameters
            """
            result = self._values.get("request_parameters")
            return result

        @builtins.property
        def request_templates(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, builtins.str]]]:
            """``CfnMethod.IntegrationProperty.RequestTemplates``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-requesttemplates
            """
            result = self._values.get("request_templates")
            return result

        @builtins.property
        def timeout_in_millis(self) -> typing.Optional[jsii.Number]:
            """``CfnMethod.IntegrationProperty.TimeoutInMillis``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-timeoutinmillis
            """
            result = self._values.get("timeout_in_millis")
            return result

        @builtins.property
        def type(self) -> typing.Optional[builtins.str]:
            """``CfnMethod.IntegrationProperty.Type``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-type
            """
            result = self._values.get("type")
            return result

        @builtins.property
        def uri(self) -> typing.Optional[builtins.str]:
            """``CfnMethod.IntegrationProperty.Uri``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-uri
            """
            result = self._values.get("uri")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "IntegrationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_apigateway.CfnMethod.IntegrationResponseProperty",
        jsii_struct_bases=[],
        name_mapping={
            "status_code": "statusCode",
            "content_handling": "contentHandling",
            "response_parameters": "responseParameters",
            "response_templates": "responseTemplates",
            "selection_pattern": "selectionPattern",
        },
    )
    class IntegrationResponseProperty:
        def __init__(
            self,
            *,
            status_code: builtins.str,
            content_handling: typing.Optional[builtins.str] = None,
            response_parameters: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, builtins.str]]] = None,
            response_templates: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, builtins.str]]] = None,
            selection_pattern: typing.Optional[builtins.str] = None,
        ) -> None:
            """
            :param status_code: ``CfnMethod.IntegrationResponseProperty.StatusCode``.
            :param content_handling: ``CfnMethod.IntegrationResponseProperty.ContentHandling``.
            :param response_parameters: ``CfnMethod.IntegrationResponseProperty.ResponseParameters``.
            :param response_templates: ``CfnMethod.IntegrationResponseProperty.ResponseTemplates``.
            :param selection_pattern: ``CfnMethod.IntegrationResponseProperty.SelectionPattern``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html
            """
            self._values: typing.Dict[str, typing.Any] = {
                "status_code": status_code,
            }
            if content_handling is not None:
                self._values["content_handling"] = content_handling
            if response_parameters is not None:
                self._values["response_parameters"] = response_parameters
            if response_templates is not None:
                self._values["response_templates"] = response_templates
            if selection_pattern is not None:
                self._values["selection_pattern"] = selection_pattern

        @builtins.property
        def status_code(self) -> builtins.str:
            """``CfnMethod.IntegrationResponseProperty.StatusCode``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-statuscode
            """
            result = self._values.get("status_code")
            assert result is not None, "Required property 'status_code' is missing"
            return result

        @builtins.property
        def content_handling(self) -> typing.Optional[builtins.str]:
            """``CfnMethod.IntegrationResponseProperty.ContentHandling``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integrationresponse-contenthandling
            """
            result = self._values.get("content_handling")
            return result

        @builtins.property
        def response_parameters(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, builtins.str]]]:
            """``CfnMethod.IntegrationResponseProperty.ResponseParameters``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-responseparameters
            """
            result = self._values.get("response_parameters")
            return result

        @builtins.property
        def response_templates(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, builtins.str]]]:
            """``CfnMethod.IntegrationResponseProperty.ResponseTemplates``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-responsetemplates
            """
            result = self._values.get("response_templates")
            return result

        @builtins.property
        def selection_pattern(self) -> typing.Optional[builtins.str]:
            """``CfnMethod.IntegrationResponseProperty.SelectionPattern``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-selectionpattern
            """
            result = self._values.get("selection_pattern")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "IntegrationResponseProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_apigateway.CfnMethod.MethodResponseProperty",
        jsii_struct_bases=[],
        name_mapping={
            "status_code": "statusCode",
            "response_models": "responseModels",
            "response_parameters": "responseParameters",
        },
    )
    class MethodResponseProperty:
        def __init__(
            self,
            *,
            status_code: builtins.str,
            response_models: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, builtins.str]]] = None,
            response_parameters: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, typing.Union[builtins.bool, _IResolvable_a771d0ef]]]] = None,
        ) -> None:
            """
            :param status_code: ``CfnMethod.MethodResponseProperty.StatusCode``.
            :param response_models: ``CfnMethod.MethodResponseProperty.ResponseModels``.
            :param response_parameters: ``CfnMethod.MethodResponseProperty.ResponseParameters``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html
            """
            self._values: typing.Dict[str, typing.Any] = {
                "status_code": status_code,
            }
            if response_models is not None:
                self._values["response_models"] = response_models
            if response_parameters is not None:
                self._values["response_parameters"] = response_parameters

        @builtins.property
        def status_code(self) -> builtins.str:
            """``CfnMethod.MethodResponseProperty.StatusCode``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-statuscode
            """
            result = self._values.get("status_code")
            assert result is not None, "Required property 'status_code' is missing"
            return result

        @builtins.property
        def response_models(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, builtins.str]]]:
            """``CfnMethod.MethodResponseProperty.ResponseModels``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-responsemodels
            """
            result = self._values.get("response_models")
            return result

        @builtins.property
        def response_parameters(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, typing.Union[builtins.bool, _IResolvable_a771d0ef]]]]:
            """``CfnMethod.MethodResponseProperty.ResponseParameters``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-responseparameters
            """
            result = self._values.get("response_parameters")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "MethodResponseProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.CfnMethodProps",
    jsii_struct_bases=[],
    name_mapping={
        "http_method": "httpMethod",
        "resource_id": "resourceId",
        "rest_api_id": "restApiId",
        "api_key_required": "apiKeyRequired",
        "authorization_scopes": "authorizationScopes",
        "authorization_type": "authorizationType",
        "authorizer_id": "authorizerId",
        "integration": "integration",
        "method_responses": "methodResponses",
        "operation_name": "operationName",
        "request_models": "requestModels",
        "request_parameters": "requestParameters",
        "request_validator_id": "requestValidatorId",
    },
)
class CfnMethodProps:
    def __init__(
        self,
        *,
        http_method: builtins.str,
        resource_id: builtins.str,
        rest_api_id: builtins.str,
        api_key_required: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
        authorization_scopes: typing.Optional[typing.List[builtins.str]] = None,
        authorization_type: typing.Optional[builtins.str] = None,
        authorizer_id: typing.Optional[builtins.str] = None,
        integration: typing.Optional[typing.Union[CfnMethod.IntegrationProperty, _IResolvable_a771d0ef]] = None,
        method_responses: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union[CfnMethod.MethodResponseProperty, _IResolvable_a771d0ef]]]] = None,
        operation_name: typing.Optional[builtins.str] = None,
        request_models: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, builtins.str]]] = None,
        request_parameters: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, typing.Union[builtins.bool, _IResolvable_a771d0ef]]]] = None,
        request_validator_id: typing.Optional[builtins.str] = None,
    ) -> None:
        """Properties for defining a ``AWS::ApiGateway::Method``.

        :param http_method: ``AWS::ApiGateway::Method.HttpMethod``.
        :param resource_id: ``AWS::ApiGateway::Method.ResourceId``.
        :param rest_api_id: ``AWS::ApiGateway::Method.RestApiId``.
        :param api_key_required: ``AWS::ApiGateway::Method.ApiKeyRequired``.
        :param authorization_scopes: ``AWS::ApiGateway::Method.AuthorizationScopes``.
        :param authorization_type: ``AWS::ApiGateway::Method.AuthorizationType``.
        :param authorizer_id: ``AWS::ApiGateway::Method.AuthorizerId``.
        :param integration: ``AWS::ApiGateway::Method.Integration``.
        :param method_responses: ``AWS::ApiGateway::Method.MethodResponses``.
        :param operation_name: ``AWS::ApiGateway::Method.OperationName``.
        :param request_models: ``AWS::ApiGateway::Method.RequestModels``.
        :param request_parameters: ``AWS::ApiGateway::Method.RequestParameters``.
        :param request_validator_id: ``AWS::ApiGateway::Method.RequestValidatorId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html
        """
        self._values: typing.Dict[str, typing.Any] = {
            "http_method": http_method,
            "resource_id": resource_id,
            "rest_api_id": rest_api_id,
        }
        if api_key_required is not None:
            self._values["api_key_required"] = api_key_required
        if authorization_scopes is not None:
            self._values["authorization_scopes"] = authorization_scopes
        if authorization_type is not None:
            self._values["authorization_type"] = authorization_type
        if authorizer_id is not None:
            self._values["authorizer_id"] = authorizer_id
        if integration is not None:
            self._values["integration"] = integration
        if method_responses is not None:
            self._values["method_responses"] = method_responses
        if operation_name is not None:
            self._values["operation_name"] = operation_name
        if request_models is not None:
            self._values["request_models"] = request_models
        if request_parameters is not None:
            self._values["request_parameters"] = request_parameters
        if request_validator_id is not None:
            self._values["request_validator_id"] = request_validator_id

    @builtins.property
    def http_method(self) -> builtins.str:
        """``AWS::ApiGateway::Method.HttpMethod``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-httpmethod
        """
        result = self._values.get("http_method")
        assert result is not None, "Required property 'http_method' is missing"
        return result

    @builtins.property
    def resource_id(self) -> builtins.str:
        """``AWS::ApiGateway::Method.ResourceId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-resourceid
        """
        result = self._values.get("resource_id")
        assert result is not None, "Required property 'resource_id' is missing"
        return result

    @builtins.property
    def rest_api_id(self) -> builtins.str:
        """``AWS::ApiGateway::Method.RestApiId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-restapiid
        """
        result = self._values.get("rest_api_id")
        assert result is not None, "Required property 'rest_api_id' is missing"
        return result

    @builtins.property
    def api_key_required(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
        """``AWS::ApiGateway::Method.ApiKeyRequired``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-apikeyrequired
        """
        result = self._values.get("api_key_required")
        return result

    @builtins.property
    def authorization_scopes(self) -> typing.Optional[typing.List[builtins.str]]:
        """``AWS::ApiGateway::Method.AuthorizationScopes``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationscopes
        """
        result = self._values.get("authorization_scopes")
        return result

    @builtins.property
    def authorization_type(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::Method.AuthorizationType``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationtype
        """
        result = self._values.get("authorization_type")
        return result

    @builtins.property
    def authorizer_id(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::Method.AuthorizerId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizerid
        """
        result = self._values.get("authorizer_id")
        return result

    @builtins.property
    def integration(
        self,
    ) -> typing.Optional[typing.Union[CfnMethod.IntegrationProperty, _IResolvable_a771d0ef]]:
        """``AWS::ApiGateway::Method.Integration``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-integration
        """
        result = self._values.get("integration")
        return result

    @builtins.property
    def method_responses(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union[CfnMethod.MethodResponseProperty, _IResolvable_a771d0ef]]]]:
        """``AWS::ApiGateway::Method.MethodResponses``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-methodresponses
        """
        result = self._values.get("method_responses")
        return result

    @builtins.property
    def operation_name(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::Method.OperationName``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-operationname
        """
        result = self._values.get("operation_name")
        return result

    @builtins.property
    def request_models(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, builtins.str]]]:
        """``AWS::ApiGateway::Method.RequestModels``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestmodels
        """
        result = self._values.get("request_models")
        return result

    @builtins.property
    def request_parameters(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, typing.Union[builtins.bool, _IResolvable_a771d0ef]]]]:
        """``AWS::ApiGateway::Method.RequestParameters``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestparameters
        """
        result = self._values.get("request_parameters")
        return result

    @builtins.property
    def request_validator_id(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::Method.RequestValidatorId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestvalidatorid
        """
        result = self._values.get("request_validator_id")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnMethodProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_82c04a63)
class CfnModel(
    _CfnResource_e0a482dc,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_apigateway.CfnModel",
):
    """A CloudFormation ``AWS::ApiGateway::Model``.

    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-model.html
    :cloudformationResource: AWS::ApiGateway::Model
    """

    def __init__(
        self,
        scope: _Construct_e78e779f,
        id: builtins.str,
        *,
        rest_api_id: builtins.str,
        content_type: typing.Optional[builtins.str] = None,
        description: typing.Optional[builtins.str] = None,
        name: typing.Optional[builtins.str] = None,
        schema: typing.Any = None,
    ) -> None:
        """Create a new ``AWS::ApiGateway::Model``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param rest_api_id: ``AWS::ApiGateway::Model.RestApiId``.
        :param content_type: ``AWS::ApiGateway::Model.ContentType``.
        :param description: ``AWS::ApiGateway::Model.Description``.
        :param name: ``AWS::ApiGateway::Model.Name``.
        :param schema: ``AWS::ApiGateway::Model.Schema``.
        """
        props = CfnModelProps(
            rest_api_id=rest_api_id,
            content_type=content_type,
            description=description,
            name=name,
            schema=schema,
        )

        jsii.create(CfnModel, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_1cd1894e) -> None:
        """(experimental) Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="restApiId")
    def rest_api_id(self) -> builtins.str:
        """``AWS::ApiGateway::Model.RestApiId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-model.html#cfn-apigateway-model-restapiid
        """
        return jsii.get(self, "restApiId")

    @rest_api_id.setter # type: ignore
    def rest_api_id(self, value: builtins.str) -> None:
        jsii.set(self, "restApiId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="schema")
    def schema(self) -> typing.Any:
        """``AWS::ApiGateway::Model.Schema``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-model.html#cfn-apigateway-model-schema
        """
        return jsii.get(self, "schema")

    @schema.setter # type: ignore
    def schema(self, value: typing.Any) -> None:
        jsii.set(self, "schema", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="contentType")
    def content_type(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::Model.ContentType``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-model.html#cfn-apigateway-model-contenttype
        """
        return jsii.get(self, "contentType")

    @content_type.setter # type: ignore
    def content_type(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "contentType", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::Model.Description``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-model.html#cfn-apigateway-model-description
        """
        return jsii.get(self, "description")

    @description.setter # type: ignore
    def description(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "description", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="name")
    def name(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::Model.Name``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-model.html#cfn-apigateway-model-name
        """
        return jsii.get(self, "name")

    @name.setter # type: ignore
    def name(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "name", value)


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.CfnModelProps",
    jsii_struct_bases=[],
    name_mapping={
        "rest_api_id": "restApiId",
        "content_type": "contentType",
        "description": "description",
        "name": "name",
        "schema": "schema",
    },
)
class CfnModelProps:
    def __init__(
        self,
        *,
        rest_api_id: builtins.str,
        content_type: typing.Optional[builtins.str] = None,
        description: typing.Optional[builtins.str] = None,
        name: typing.Optional[builtins.str] = None,
        schema: typing.Any = None,
    ) -> None:
        """Properties for defining a ``AWS::ApiGateway::Model``.

        :param rest_api_id: ``AWS::ApiGateway::Model.RestApiId``.
        :param content_type: ``AWS::ApiGateway::Model.ContentType``.
        :param description: ``AWS::ApiGateway::Model.Description``.
        :param name: ``AWS::ApiGateway::Model.Name``.
        :param schema: ``AWS::ApiGateway::Model.Schema``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-model.html
        """
        self._values: typing.Dict[str, typing.Any] = {
            "rest_api_id": rest_api_id,
        }
        if content_type is not None:
            self._values["content_type"] = content_type
        if description is not None:
            self._values["description"] = description
        if name is not None:
            self._values["name"] = name
        if schema is not None:
            self._values["schema"] = schema

    @builtins.property
    def rest_api_id(self) -> builtins.str:
        """``AWS::ApiGateway::Model.RestApiId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-model.html#cfn-apigateway-model-restapiid
        """
        result = self._values.get("rest_api_id")
        assert result is not None, "Required property 'rest_api_id' is missing"
        return result

    @builtins.property
    def content_type(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::Model.ContentType``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-model.html#cfn-apigateway-model-contenttype
        """
        result = self._values.get("content_type")
        return result

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::Model.Description``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-model.html#cfn-apigateway-model-description
        """
        result = self._values.get("description")
        return result

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::Model.Name``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-model.html#cfn-apigateway-model-name
        """
        result = self._values.get("name")
        return result

    @builtins.property
    def schema(self) -> typing.Any:
        """``AWS::ApiGateway::Model.Schema``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-model.html#cfn-apigateway-model-schema
        """
        result = self._values.get("schema")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnModelProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_82c04a63)
class CfnModelV2(
    _CfnResource_e0a482dc,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_apigateway.CfnModelV2",
):
    """(deprecated) A CloudFormation ``AWS::ApiGatewayV2::Model``.

    :deprecated: moved to package aws-apigatewayv2

    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-model.html
    :stability: deprecated
    :cloudformationResource: AWS::ApiGatewayV2::Model
    """

    def __init__(
        self,
        scope: _Construct_e78e779f,
        id: builtins.str,
        *,
        api_id: builtins.str,
        name: builtins.str,
        schema: typing.Any,
        content_type: typing.Optional[builtins.str] = None,
        description: typing.Optional[builtins.str] = None,
    ) -> None:
        """(deprecated) Create a new ``AWS::ApiGatewayV2::Model``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param api_id: (deprecated) ``AWS::ApiGatewayV2::Model.ApiId``.
        :param name: (deprecated) ``AWS::ApiGatewayV2::Model.Name``.
        :param schema: (deprecated) ``AWS::ApiGatewayV2::Model.Schema``.
        :param content_type: (deprecated) ``AWS::ApiGatewayV2::Model.ContentType``.
        :param description: (deprecated) ``AWS::ApiGatewayV2::Model.Description``.

        :stability: deprecated
        """
        props = CfnModelV2Props(
            api_id=api_id,
            name=name,
            schema=schema,
            content_type=content_type,
            description=description,
        )

        jsii.create(CfnModelV2, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_1cd1894e) -> None:
        """(experimental) Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -

        :stability: deprecated
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """(deprecated) The CloudFormation resource type name for this resource class.

        :stability: deprecated
        """
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :stability: deprecated
        """
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiId")
    def api_id(self) -> builtins.str:
        """(deprecated) ``AWS::ApiGatewayV2::Model.ApiId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-model.html#cfn-apigatewayv2-model-apiid
        :stability: deprecated
        """
        return jsii.get(self, "apiId")

    @api_id.setter # type: ignore
    def api_id(self, value: builtins.str) -> None:
        jsii.set(self, "apiId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        """(deprecated) ``AWS::ApiGatewayV2::Model.Name``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-model.html#cfn-apigatewayv2-model-name
        :stability: deprecated
        """
        return jsii.get(self, "name")

    @name.setter # type: ignore
    def name(self, value: builtins.str) -> None:
        jsii.set(self, "name", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="schema")
    def schema(self) -> typing.Any:
        """(deprecated) ``AWS::ApiGatewayV2::Model.Schema``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-model.html#cfn-apigatewayv2-model-schema
        :stability: deprecated
        """
        return jsii.get(self, "schema")

    @schema.setter # type: ignore
    def schema(self, value: typing.Any) -> None:
        jsii.set(self, "schema", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="contentType")
    def content_type(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Model.ContentType``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-model.html#cfn-apigatewayv2-model-contenttype
        :stability: deprecated
        """
        return jsii.get(self, "contentType")

    @content_type.setter # type: ignore
    def content_type(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "contentType", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Model.Description``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-model.html#cfn-apigatewayv2-model-description
        :stability: deprecated
        """
        return jsii.get(self, "description")

    @description.setter # type: ignore
    def description(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "description", value)


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.CfnModelV2Props",
    jsii_struct_bases=[],
    name_mapping={
        "api_id": "apiId",
        "name": "name",
        "schema": "schema",
        "content_type": "contentType",
        "description": "description",
    },
)
class CfnModelV2Props:
    def __init__(
        self,
        *,
        api_id: builtins.str,
        name: builtins.str,
        schema: typing.Any,
        content_type: typing.Optional[builtins.str] = None,
        description: typing.Optional[builtins.str] = None,
    ) -> None:
        """(deprecated) Properties for defining a ``AWS::ApiGatewayV2::Model``.

        :param api_id: (deprecated) ``AWS::ApiGatewayV2::Model.ApiId``.
        :param name: (deprecated) ``AWS::ApiGatewayV2::Model.Name``.
        :param schema: (deprecated) ``AWS::ApiGatewayV2::Model.Schema``.
        :param content_type: (deprecated) ``AWS::ApiGatewayV2::Model.ContentType``.
        :param description: (deprecated) ``AWS::ApiGatewayV2::Model.Description``.

        :deprecated: moved to package aws-apigatewayv2

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-model.html
        :stability: deprecated
        """
        self._values: typing.Dict[str, typing.Any] = {
            "api_id": api_id,
            "name": name,
            "schema": schema,
        }
        if content_type is not None:
            self._values["content_type"] = content_type
        if description is not None:
            self._values["description"] = description

    @builtins.property
    def api_id(self) -> builtins.str:
        """(deprecated) ``AWS::ApiGatewayV2::Model.ApiId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-model.html#cfn-apigatewayv2-model-apiid
        :stability: deprecated
        """
        result = self._values.get("api_id")
        assert result is not None, "Required property 'api_id' is missing"
        return result

    @builtins.property
    def name(self) -> builtins.str:
        """(deprecated) ``AWS::ApiGatewayV2::Model.Name``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-model.html#cfn-apigatewayv2-model-name
        :stability: deprecated
        """
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return result

    @builtins.property
    def schema(self) -> typing.Any:
        """(deprecated) ``AWS::ApiGatewayV2::Model.Schema``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-model.html#cfn-apigatewayv2-model-schema
        :stability: deprecated
        """
        result = self._values.get("schema")
        assert result is not None, "Required property 'schema' is missing"
        return result

    @builtins.property
    def content_type(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Model.ContentType``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-model.html#cfn-apigatewayv2-model-contenttype
        :stability: deprecated
        """
        result = self._values.get("content_type")
        return result

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Model.Description``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-model.html#cfn-apigatewayv2-model-description
        :stability: deprecated
        """
        result = self._values.get("description")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnModelV2Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_82c04a63)
class CfnRequestValidator(
    _CfnResource_e0a482dc,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_apigateway.CfnRequestValidator",
):
    """A CloudFormation ``AWS::ApiGateway::RequestValidator``.

    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-requestvalidator.html
    :cloudformationResource: AWS::ApiGateway::RequestValidator
    """

    def __init__(
        self,
        scope: _Construct_e78e779f,
        id: builtins.str,
        *,
        rest_api_id: builtins.str,
        name: typing.Optional[builtins.str] = None,
        validate_request_body: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
        validate_request_parameters: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
    ) -> None:
        """Create a new ``AWS::ApiGateway::RequestValidator``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param rest_api_id: ``AWS::ApiGateway::RequestValidator.RestApiId``.
        :param name: ``AWS::ApiGateway::RequestValidator.Name``.
        :param validate_request_body: ``AWS::ApiGateway::RequestValidator.ValidateRequestBody``.
        :param validate_request_parameters: ``AWS::ApiGateway::RequestValidator.ValidateRequestParameters``.
        """
        props = CfnRequestValidatorProps(
            rest_api_id=rest_api_id,
            name=name,
            validate_request_body=validate_request_body,
            validate_request_parameters=validate_request_parameters,
        )

        jsii.create(CfnRequestValidator, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_1cd1894e) -> None:
        """(experimental) Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="restApiId")
    def rest_api_id(self) -> builtins.str:
        """``AWS::ApiGateway::RequestValidator.RestApiId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-requestvalidator.html#cfn-apigateway-requestvalidator-restapiid
        """
        return jsii.get(self, "restApiId")

    @rest_api_id.setter # type: ignore
    def rest_api_id(self, value: builtins.str) -> None:
        jsii.set(self, "restApiId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="name")
    def name(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::RequestValidator.Name``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-requestvalidator.html#cfn-apigateway-requestvalidator-name
        """
        return jsii.get(self, "name")

    @name.setter # type: ignore
    def name(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "name", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="validateRequestBody")
    def validate_request_body(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
        """``AWS::ApiGateway::RequestValidator.ValidateRequestBody``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-requestvalidator.html#cfn-apigateway-requestvalidator-validaterequestbody
        """
        return jsii.get(self, "validateRequestBody")

    @validate_request_body.setter # type: ignore
    def validate_request_body(
        self,
        value: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]],
    ) -> None:
        jsii.set(self, "validateRequestBody", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="validateRequestParameters")
    def validate_request_parameters(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
        """``AWS::ApiGateway::RequestValidator.ValidateRequestParameters``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-requestvalidator.html#cfn-apigateway-requestvalidator-validaterequestparameters
        """
        return jsii.get(self, "validateRequestParameters")

    @validate_request_parameters.setter # type: ignore
    def validate_request_parameters(
        self,
        value: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]],
    ) -> None:
        jsii.set(self, "validateRequestParameters", value)


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.CfnRequestValidatorProps",
    jsii_struct_bases=[],
    name_mapping={
        "rest_api_id": "restApiId",
        "name": "name",
        "validate_request_body": "validateRequestBody",
        "validate_request_parameters": "validateRequestParameters",
    },
)
class CfnRequestValidatorProps:
    def __init__(
        self,
        *,
        rest_api_id: builtins.str,
        name: typing.Optional[builtins.str] = None,
        validate_request_body: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
        validate_request_parameters: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
    ) -> None:
        """Properties for defining a ``AWS::ApiGateway::RequestValidator``.

        :param rest_api_id: ``AWS::ApiGateway::RequestValidator.RestApiId``.
        :param name: ``AWS::ApiGateway::RequestValidator.Name``.
        :param validate_request_body: ``AWS::ApiGateway::RequestValidator.ValidateRequestBody``.
        :param validate_request_parameters: ``AWS::ApiGateway::RequestValidator.ValidateRequestParameters``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-requestvalidator.html
        """
        self._values: typing.Dict[str, typing.Any] = {
            "rest_api_id": rest_api_id,
        }
        if name is not None:
            self._values["name"] = name
        if validate_request_body is not None:
            self._values["validate_request_body"] = validate_request_body
        if validate_request_parameters is not None:
            self._values["validate_request_parameters"] = validate_request_parameters

    @builtins.property
    def rest_api_id(self) -> builtins.str:
        """``AWS::ApiGateway::RequestValidator.RestApiId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-requestvalidator.html#cfn-apigateway-requestvalidator-restapiid
        """
        result = self._values.get("rest_api_id")
        assert result is not None, "Required property 'rest_api_id' is missing"
        return result

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::RequestValidator.Name``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-requestvalidator.html#cfn-apigateway-requestvalidator-name
        """
        result = self._values.get("name")
        return result

    @builtins.property
    def validate_request_body(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
        """``AWS::ApiGateway::RequestValidator.ValidateRequestBody``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-requestvalidator.html#cfn-apigateway-requestvalidator-validaterequestbody
        """
        result = self._values.get("validate_request_body")
        return result

    @builtins.property
    def validate_request_parameters(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
        """``AWS::ApiGateway::RequestValidator.ValidateRequestParameters``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-requestvalidator.html#cfn-apigateway-requestvalidator-validaterequestparameters
        """
        result = self._values.get("validate_request_parameters")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnRequestValidatorProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_82c04a63)
class CfnResource(
    _CfnResource_e0a482dc,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_apigateway.CfnResource",
):
    """A CloudFormation ``AWS::ApiGateway::Resource``.

    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-resource.html
    :cloudformationResource: AWS::ApiGateway::Resource
    """

    def __init__(
        self,
        scope: _Construct_e78e779f,
        id: builtins.str,
        *,
        parent_id: builtins.str,
        path_part: builtins.str,
        rest_api_id: builtins.str,
    ) -> None:
        """Create a new ``AWS::ApiGateway::Resource``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param parent_id: ``AWS::ApiGateway::Resource.ParentId``.
        :param path_part: ``AWS::ApiGateway::Resource.PathPart``.
        :param rest_api_id: ``AWS::ApiGateway::Resource.RestApiId``.
        """
        props = CfnResourceProps(
            parent_id=parent_id, path_part=path_part, rest_api_id=rest_api_id
        )

        jsii.create(CfnResource, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_1cd1894e) -> None:
        """(experimental) Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="parentId")
    def parent_id(self) -> builtins.str:
        """``AWS::ApiGateway::Resource.ParentId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-resource.html#cfn-apigateway-resource-parentid
        """
        return jsii.get(self, "parentId")

    @parent_id.setter # type: ignore
    def parent_id(self, value: builtins.str) -> None:
        jsii.set(self, "parentId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="pathPart")
    def path_part(self) -> builtins.str:
        """``AWS::ApiGateway::Resource.PathPart``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-resource.html#cfn-apigateway-resource-pathpart
        """
        return jsii.get(self, "pathPart")

    @path_part.setter # type: ignore
    def path_part(self, value: builtins.str) -> None:
        jsii.set(self, "pathPart", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="restApiId")
    def rest_api_id(self) -> builtins.str:
        """``AWS::ApiGateway::Resource.RestApiId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-resource.html#cfn-apigateway-resource-restapiid
        """
        return jsii.get(self, "restApiId")

    @rest_api_id.setter # type: ignore
    def rest_api_id(self, value: builtins.str) -> None:
        jsii.set(self, "restApiId", value)


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.CfnResourceProps",
    jsii_struct_bases=[],
    name_mapping={
        "parent_id": "parentId",
        "path_part": "pathPart",
        "rest_api_id": "restApiId",
    },
)
class CfnResourceProps:
    def __init__(
        self,
        *,
        parent_id: builtins.str,
        path_part: builtins.str,
        rest_api_id: builtins.str,
    ) -> None:
        """Properties for defining a ``AWS::ApiGateway::Resource``.

        :param parent_id: ``AWS::ApiGateway::Resource.ParentId``.
        :param path_part: ``AWS::ApiGateway::Resource.PathPart``.
        :param rest_api_id: ``AWS::ApiGateway::Resource.RestApiId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-resource.html
        """
        self._values: typing.Dict[str, typing.Any] = {
            "parent_id": parent_id,
            "path_part": path_part,
            "rest_api_id": rest_api_id,
        }

    @builtins.property
    def parent_id(self) -> builtins.str:
        """``AWS::ApiGateway::Resource.ParentId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-resource.html#cfn-apigateway-resource-parentid
        """
        result = self._values.get("parent_id")
        assert result is not None, "Required property 'parent_id' is missing"
        return result

    @builtins.property
    def path_part(self) -> builtins.str:
        """``AWS::ApiGateway::Resource.PathPart``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-resource.html#cfn-apigateway-resource-pathpart
        """
        result = self._values.get("path_part")
        assert result is not None, "Required property 'path_part' is missing"
        return result

    @builtins.property
    def rest_api_id(self) -> builtins.str:
        """``AWS::ApiGateway::Resource.RestApiId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-resource.html#cfn-apigateway-resource-restapiid
        """
        result = self._values.get("rest_api_id")
        assert result is not None, "Required property 'rest_api_id' is missing"
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnResourceProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_82c04a63)
class CfnRestApi(
    _CfnResource_e0a482dc,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_apigateway.CfnRestApi",
):
    """A CloudFormation ``AWS::ApiGateway::RestApi``.

    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html
    :cloudformationResource: AWS::ApiGateway::RestApi
    """

    def __init__(
        self,
        scope: _Construct_e78e779f,
        id: builtins.str,
        *,
        api_key_source_type: typing.Optional[builtins.str] = None,
        binary_media_types: typing.Optional[typing.List[builtins.str]] = None,
        body: typing.Any = None,
        body_s3_location: typing.Optional[typing.Union["CfnRestApi.S3LocationProperty", _IResolvable_a771d0ef]] = None,
        clone_from: typing.Optional[builtins.str] = None,
        description: typing.Optional[builtins.str] = None,
        endpoint_configuration: typing.Optional[typing.Union["CfnRestApi.EndpointConfigurationProperty", _IResolvable_a771d0ef]] = None,
        fail_on_warnings: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
        minimum_compression_size: typing.Optional[jsii.Number] = None,
        name: typing.Optional[builtins.str] = None,
        parameters: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, builtins.str]]] = None,
        policy: typing.Any = None,
        tags: typing.Optional[typing.List[_CfnTag_95fbdc29]] = None,
    ) -> None:
        """Create a new ``AWS::ApiGateway::RestApi``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param api_key_source_type: ``AWS::ApiGateway::RestApi.ApiKeySourceType``.
        :param binary_media_types: ``AWS::ApiGateway::RestApi.BinaryMediaTypes``.
        :param body: ``AWS::ApiGateway::RestApi.Body``.
        :param body_s3_location: ``AWS::ApiGateway::RestApi.BodyS3Location``.
        :param clone_from: ``AWS::ApiGateway::RestApi.CloneFrom``.
        :param description: ``AWS::ApiGateway::RestApi.Description``.
        :param endpoint_configuration: ``AWS::ApiGateway::RestApi.EndpointConfiguration``.
        :param fail_on_warnings: ``AWS::ApiGateway::RestApi.FailOnWarnings``.
        :param minimum_compression_size: ``AWS::ApiGateway::RestApi.MinimumCompressionSize``.
        :param name: ``AWS::ApiGateway::RestApi.Name``.
        :param parameters: ``AWS::ApiGateway::RestApi.Parameters``.
        :param policy: ``AWS::ApiGateway::RestApi.Policy``.
        :param tags: ``AWS::ApiGateway::RestApi.Tags``.
        """
        props = CfnRestApiProps(
            api_key_source_type=api_key_source_type,
            binary_media_types=binary_media_types,
            body=body,
            body_s3_location=body_s3_location,
            clone_from=clone_from,
            description=description,
            endpoint_configuration=endpoint_configuration,
            fail_on_warnings=fail_on_warnings,
            minimum_compression_size=minimum_compression_size,
            name=name,
            parameters=parameters,
            policy=policy,
            tags=tags,
        )

        jsii.create(CfnRestApi, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_1cd1894e) -> None:
        """(experimental) Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="attrRootResourceId")
    def attr_root_resource_id(self) -> builtins.str:
        """
        :cloudformationAttribute: RootResourceId
        """
        return jsii.get(self, "attrRootResourceId")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_0b7ab120:
        """``AWS::ApiGateway::RestApi.Tags``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-tags
        """
        return jsii.get(self, "tags")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="body")
    def body(self) -> typing.Any:
        """``AWS::ApiGateway::RestApi.Body``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-body
        """
        return jsii.get(self, "body")

    @body.setter # type: ignore
    def body(self, value: typing.Any) -> None:
        jsii.set(self, "body", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="policy")
    def policy(self) -> typing.Any:
        """``AWS::ApiGateway::RestApi.Policy``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-policy
        """
        return jsii.get(self, "policy")

    @policy.setter # type: ignore
    def policy(self, value: typing.Any) -> None:
        jsii.set(self, "policy", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiKeySourceType")
    def api_key_source_type(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::RestApi.ApiKeySourceType``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-apikeysourcetype
        """
        return jsii.get(self, "apiKeySourceType")

    @api_key_source_type.setter # type: ignore
    def api_key_source_type(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "apiKeySourceType", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="binaryMediaTypes")
    def binary_media_types(self) -> typing.Optional[typing.List[builtins.str]]:
        """``AWS::ApiGateway::RestApi.BinaryMediaTypes``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-binarymediatypes
        """
        return jsii.get(self, "binaryMediaTypes")

    @binary_media_types.setter # type: ignore
    def binary_media_types(
        self,
        value: typing.Optional[typing.List[builtins.str]],
    ) -> None:
        jsii.set(self, "binaryMediaTypes", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="bodyS3Location")
    def body_s3_location(
        self,
    ) -> typing.Optional[typing.Union["CfnRestApi.S3LocationProperty", _IResolvable_a771d0ef]]:
        """``AWS::ApiGateway::RestApi.BodyS3Location``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-bodys3location
        """
        return jsii.get(self, "bodyS3Location")

    @body_s3_location.setter # type: ignore
    def body_s3_location(
        self,
        value: typing.Optional[typing.Union["CfnRestApi.S3LocationProperty", _IResolvable_a771d0ef]],
    ) -> None:
        jsii.set(self, "bodyS3Location", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cloneFrom")
    def clone_from(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::RestApi.CloneFrom``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-clonefrom
        """
        return jsii.get(self, "cloneFrom")

    @clone_from.setter # type: ignore
    def clone_from(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "cloneFrom", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::RestApi.Description``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-description
        """
        return jsii.get(self, "description")

    @description.setter # type: ignore
    def description(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "description", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="endpointConfiguration")
    def endpoint_configuration(
        self,
    ) -> typing.Optional[typing.Union["CfnRestApi.EndpointConfigurationProperty", _IResolvable_a771d0ef]]:
        """``AWS::ApiGateway::RestApi.EndpointConfiguration``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-endpointconfiguration
        """
        return jsii.get(self, "endpointConfiguration")

    @endpoint_configuration.setter # type: ignore
    def endpoint_configuration(
        self,
        value: typing.Optional[typing.Union["CfnRestApi.EndpointConfigurationProperty", _IResolvable_a771d0ef]],
    ) -> None:
        jsii.set(self, "endpointConfiguration", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="failOnWarnings")
    def fail_on_warnings(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
        """``AWS::ApiGateway::RestApi.FailOnWarnings``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-failonwarnings
        """
        return jsii.get(self, "failOnWarnings")

    @fail_on_warnings.setter # type: ignore
    def fail_on_warnings(
        self,
        value: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]],
    ) -> None:
        jsii.set(self, "failOnWarnings", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="minimumCompressionSize")
    def minimum_compression_size(self) -> typing.Optional[jsii.Number]:
        """``AWS::ApiGateway::RestApi.MinimumCompressionSize``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-minimumcompressionsize
        """
        return jsii.get(self, "minimumCompressionSize")

    @minimum_compression_size.setter # type: ignore
    def minimum_compression_size(self, value: typing.Optional[jsii.Number]) -> None:
        jsii.set(self, "minimumCompressionSize", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="name")
    def name(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::RestApi.Name``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-name
        """
        return jsii.get(self, "name")

    @name.setter # type: ignore
    def name(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "name", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="parameters")
    def parameters(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, builtins.str]]]:
        """``AWS::ApiGateway::RestApi.Parameters``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-parameters
        """
        return jsii.get(self, "parameters")

    @parameters.setter # type: ignore
    def parameters(
        self,
        value: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, builtins.str]]],
    ) -> None:
        jsii.set(self, "parameters", value)

    @jsii.data_type(
        jsii_type="monocdk.aws_apigateway.CfnRestApi.EndpointConfigurationProperty",
        jsii_struct_bases=[],
        name_mapping={"types": "types", "vpc_endpoint_ids": "vpcEndpointIds"},
    )
    class EndpointConfigurationProperty:
        def __init__(
            self,
            *,
            types: typing.Optional[typing.List[builtins.str]] = None,
            vpc_endpoint_ids: typing.Optional[typing.List[builtins.str]] = None,
        ) -> None:
            """
            :param types: ``CfnRestApi.EndpointConfigurationProperty.Types``.
            :param vpc_endpoint_ids: ``CfnRestApi.EndpointConfigurationProperty.VpcEndpointIds``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-endpointconfiguration.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if types is not None:
                self._values["types"] = types
            if vpc_endpoint_ids is not None:
                self._values["vpc_endpoint_ids"] = vpc_endpoint_ids

        @builtins.property
        def types(self) -> typing.Optional[typing.List[builtins.str]]:
            """``CfnRestApi.EndpointConfigurationProperty.Types``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-endpointconfiguration.html#cfn-apigateway-restapi-endpointconfiguration-types
            """
            result = self._values.get("types")
            return result

        @builtins.property
        def vpc_endpoint_ids(self) -> typing.Optional[typing.List[builtins.str]]:
            """``CfnRestApi.EndpointConfigurationProperty.VpcEndpointIds``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-endpointconfiguration.html#cfn-apigateway-restapi-endpointconfiguration-vpcendpointids
            """
            result = self._values.get("vpc_endpoint_ids")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "EndpointConfigurationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_apigateway.CfnRestApi.S3LocationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "bucket": "bucket",
            "e_tag": "eTag",
            "key": "key",
            "version": "version",
        },
    )
    class S3LocationProperty:
        def __init__(
            self,
            *,
            bucket: typing.Optional[builtins.str] = None,
            e_tag: typing.Optional[builtins.str] = None,
            key: typing.Optional[builtins.str] = None,
            version: typing.Optional[builtins.str] = None,
        ) -> None:
            """
            :param bucket: ``CfnRestApi.S3LocationProperty.Bucket``.
            :param e_tag: ``CfnRestApi.S3LocationProperty.ETag``.
            :param key: ``CfnRestApi.S3LocationProperty.Key``.
            :param version: ``CfnRestApi.S3LocationProperty.Version``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if bucket is not None:
                self._values["bucket"] = bucket
            if e_tag is not None:
                self._values["e_tag"] = e_tag
            if key is not None:
                self._values["key"] = key
            if version is not None:
                self._values["version"] = version

        @builtins.property
        def bucket(self) -> typing.Optional[builtins.str]:
            """``CfnRestApi.S3LocationProperty.Bucket``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-bucket
            """
            result = self._values.get("bucket")
            return result

        @builtins.property
        def e_tag(self) -> typing.Optional[builtins.str]:
            """``CfnRestApi.S3LocationProperty.ETag``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-etag
            """
            result = self._values.get("e_tag")
            return result

        @builtins.property
        def key(self) -> typing.Optional[builtins.str]:
            """``CfnRestApi.S3LocationProperty.Key``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-key
            """
            result = self._values.get("key")
            return result

        @builtins.property
        def version(self) -> typing.Optional[builtins.str]:
            """``CfnRestApi.S3LocationProperty.Version``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-version
            """
            result = self._values.get("version")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "S3LocationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.CfnRestApiProps",
    jsii_struct_bases=[],
    name_mapping={
        "api_key_source_type": "apiKeySourceType",
        "binary_media_types": "binaryMediaTypes",
        "body": "body",
        "body_s3_location": "bodyS3Location",
        "clone_from": "cloneFrom",
        "description": "description",
        "endpoint_configuration": "endpointConfiguration",
        "fail_on_warnings": "failOnWarnings",
        "minimum_compression_size": "minimumCompressionSize",
        "name": "name",
        "parameters": "parameters",
        "policy": "policy",
        "tags": "tags",
    },
)
class CfnRestApiProps:
    def __init__(
        self,
        *,
        api_key_source_type: typing.Optional[builtins.str] = None,
        binary_media_types: typing.Optional[typing.List[builtins.str]] = None,
        body: typing.Any = None,
        body_s3_location: typing.Optional[typing.Union[CfnRestApi.S3LocationProperty, _IResolvable_a771d0ef]] = None,
        clone_from: typing.Optional[builtins.str] = None,
        description: typing.Optional[builtins.str] = None,
        endpoint_configuration: typing.Optional[typing.Union[CfnRestApi.EndpointConfigurationProperty, _IResolvable_a771d0ef]] = None,
        fail_on_warnings: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
        minimum_compression_size: typing.Optional[jsii.Number] = None,
        name: typing.Optional[builtins.str] = None,
        parameters: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, builtins.str]]] = None,
        policy: typing.Any = None,
        tags: typing.Optional[typing.List[_CfnTag_95fbdc29]] = None,
    ) -> None:
        """Properties for defining a ``AWS::ApiGateway::RestApi``.

        :param api_key_source_type: ``AWS::ApiGateway::RestApi.ApiKeySourceType``.
        :param binary_media_types: ``AWS::ApiGateway::RestApi.BinaryMediaTypes``.
        :param body: ``AWS::ApiGateway::RestApi.Body``.
        :param body_s3_location: ``AWS::ApiGateway::RestApi.BodyS3Location``.
        :param clone_from: ``AWS::ApiGateway::RestApi.CloneFrom``.
        :param description: ``AWS::ApiGateway::RestApi.Description``.
        :param endpoint_configuration: ``AWS::ApiGateway::RestApi.EndpointConfiguration``.
        :param fail_on_warnings: ``AWS::ApiGateway::RestApi.FailOnWarnings``.
        :param minimum_compression_size: ``AWS::ApiGateway::RestApi.MinimumCompressionSize``.
        :param name: ``AWS::ApiGateway::RestApi.Name``.
        :param parameters: ``AWS::ApiGateway::RestApi.Parameters``.
        :param policy: ``AWS::ApiGateway::RestApi.Policy``.
        :param tags: ``AWS::ApiGateway::RestApi.Tags``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if api_key_source_type is not None:
            self._values["api_key_source_type"] = api_key_source_type
        if binary_media_types is not None:
            self._values["binary_media_types"] = binary_media_types
        if body is not None:
            self._values["body"] = body
        if body_s3_location is not None:
            self._values["body_s3_location"] = body_s3_location
        if clone_from is not None:
            self._values["clone_from"] = clone_from
        if description is not None:
            self._values["description"] = description
        if endpoint_configuration is not None:
            self._values["endpoint_configuration"] = endpoint_configuration
        if fail_on_warnings is not None:
            self._values["fail_on_warnings"] = fail_on_warnings
        if minimum_compression_size is not None:
            self._values["minimum_compression_size"] = minimum_compression_size
        if name is not None:
            self._values["name"] = name
        if parameters is not None:
            self._values["parameters"] = parameters
        if policy is not None:
            self._values["policy"] = policy
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def api_key_source_type(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::RestApi.ApiKeySourceType``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-apikeysourcetype
        """
        result = self._values.get("api_key_source_type")
        return result

    @builtins.property
    def binary_media_types(self) -> typing.Optional[typing.List[builtins.str]]:
        """``AWS::ApiGateway::RestApi.BinaryMediaTypes``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-binarymediatypes
        """
        result = self._values.get("binary_media_types")
        return result

    @builtins.property
    def body(self) -> typing.Any:
        """``AWS::ApiGateway::RestApi.Body``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-body
        """
        result = self._values.get("body")
        return result

    @builtins.property
    def body_s3_location(
        self,
    ) -> typing.Optional[typing.Union[CfnRestApi.S3LocationProperty, _IResolvable_a771d0ef]]:
        """``AWS::ApiGateway::RestApi.BodyS3Location``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-bodys3location
        """
        result = self._values.get("body_s3_location")
        return result

    @builtins.property
    def clone_from(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::RestApi.CloneFrom``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-clonefrom
        """
        result = self._values.get("clone_from")
        return result

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::RestApi.Description``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-description
        """
        result = self._values.get("description")
        return result

    @builtins.property
    def endpoint_configuration(
        self,
    ) -> typing.Optional[typing.Union[CfnRestApi.EndpointConfigurationProperty, _IResolvable_a771d0ef]]:
        """``AWS::ApiGateway::RestApi.EndpointConfiguration``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-endpointconfiguration
        """
        result = self._values.get("endpoint_configuration")
        return result

    @builtins.property
    def fail_on_warnings(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
        """``AWS::ApiGateway::RestApi.FailOnWarnings``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-failonwarnings
        """
        result = self._values.get("fail_on_warnings")
        return result

    @builtins.property
    def minimum_compression_size(self) -> typing.Optional[jsii.Number]:
        """``AWS::ApiGateway::RestApi.MinimumCompressionSize``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-minimumcompressionsize
        """
        result = self._values.get("minimum_compression_size")
        return result

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::RestApi.Name``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-name
        """
        result = self._values.get("name")
        return result

    @builtins.property
    def parameters(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, builtins.str]]]:
        """``AWS::ApiGateway::RestApi.Parameters``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-parameters
        """
        result = self._values.get("parameters")
        return result

    @builtins.property
    def policy(self) -> typing.Any:
        """``AWS::ApiGateway::RestApi.Policy``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-policy
        """
        result = self._values.get("policy")
        return result

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_95fbdc29]]:
        """``AWS::ApiGateway::RestApi.Tags``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-tags
        """
        result = self._values.get("tags")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnRestApiProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_82c04a63)
class CfnRouteResponseV2(
    _CfnResource_e0a482dc,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_apigateway.CfnRouteResponseV2",
):
    """(deprecated) A CloudFormation ``AWS::ApiGatewayV2::RouteResponse``.

    :deprecated: moved to package aws-apigatewayv2

    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-routeresponse.html
    :stability: deprecated
    :cloudformationResource: AWS::ApiGatewayV2::RouteResponse
    """

    def __init__(
        self,
        scope: _Construct_e78e779f,
        id: builtins.str,
        *,
        api_id: builtins.str,
        route_id: builtins.str,
        route_response_key: builtins.str,
        model_selection_expression: typing.Optional[builtins.str] = None,
        response_models: typing.Any = None,
        response_parameters: typing.Any = None,
    ) -> None:
        """(deprecated) Create a new ``AWS::ApiGatewayV2::RouteResponse``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param api_id: (deprecated) ``AWS::ApiGatewayV2::RouteResponse.ApiId``.
        :param route_id: (deprecated) ``AWS::ApiGatewayV2::RouteResponse.RouteId``.
        :param route_response_key: (deprecated) ``AWS::ApiGatewayV2::RouteResponse.RouteResponseKey``.
        :param model_selection_expression: (deprecated) ``AWS::ApiGatewayV2::RouteResponse.ModelSelectionExpression``.
        :param response_models: (deprecated) ``AWS::ApiGatewayV2::RouteResponse.ResponseModels``.
        :param response_parameters: (deprecated) ``AWS::ApiGatewayV2::RouteResponse.ResponseParameters``.

        :stability: deprecated
        """
        props = CfnRouteResponseV2Props(
            api_id=api_id,
            route_id=route_id,
            route_response_key=route_response_key,
            model_selection_expression=model_selection_expression,
            response_models=response_models,
            response_parameters=response_parameters,
        )

        jsii.create(CfnRouteResponseV2, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_1cd1894e) -> None:
        """(experimental) Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -

        :stability: deprecated
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """(deprecated) The CloudFormation resource type name for this resource class.

        :stability: deprecated
        """
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :stability: deprecated
        """
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiId")
    def api_id(self) -> builtins.str:
        """(deprecated) ``AWS::ApiGatewayV2::RouteResponse.ApiId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-routeresponse.html#cfn-apigatewayv2-routeresponse-apiid
        :stability: deprecated
        """
        return jsii.get(self, "apiId")

    @api_id.setter # type: ignore
    def api_id(self, value: builtins.str) -> None:
        jsii.set(self, "apiId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="responseModels")
    def response_models(self) -> typing.Any:
        """(deprecated) ``AWS::ApiGatewayV2::RouteResponse.ResponseModels``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-routeresponse.html#cfn-apigatewayv2-routeresponse-responsemodels
        :stability: deprecated
        """
        return jsii.get(self, "responseModels")

    @response_models.setter # type: ignore
    def response_models(self, value: typing.Any) -> None:
        jsii.set(self, "responseModels", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="responseParameters")
    def response_parameters(self) -> typing.Any:
        """(deprecated) ``AWS::ApiGatewayV2::RouteResponse.ResponseParameters``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-routeresponse.html#cfn-apigatewayv2-routeresponse-responseparameters
        :stability: deprecated
        """
        return jsii.get(self, "responseParameters")

    @response_parameters.setter # type: ignore
    def response_parameters(self, value: typing.Any) -> None:
        jsii.set(self, "responseParameters", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="routeId")
    def route_id(self) -> builtins.str:
        """(deprecated) ``AWS::ApiGatewayV2::RouteResponse.RouteId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-routeresponse.html#cfn-apigatewayv2-routeresponse-routeid
        :stability: deprecated
        """
        return jsii.get(self, "routeId")

    @route_id.setter # type: ignore
    def route_id(self, value: builtins.str) -> None:
        jsii.set(self, "routeId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="routeResponseKey")
    def route_response_key(self) -> builtins.str:
        """(deprecated) ``AWS::ApiGatewayV2::RouteResponse.RouteResponseKey``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-routeresponse.html#cfn-apigatewayv2-routeresponse-routeresponsekey
        :stability: deprecated
        """
        return jsii.get(self, "routeResponseKey")

    @route_response_key.setter # type: ignore
    def route_response_key(self, value: builtins.str) -> None:
        jsii.set(self, "routeResponseKey", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="modelSelectionExpression")
    def model_selection_expression(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::RouteResponse.ModelSelectionExpression``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-routeresponse.html#cfn-apigatewayv2-routeresponse-modelselectionexpression
        :stability: deprecated
        """
        return jsii.get(self, "modelSelectionExpression")

    @model_selection_expression.setter # type: ignore
    def model_selection_expression(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "modelSelectionExpression", value)

    @jsii.data_type(
        jsii_type="monocdk.aws_apigateway.CfnRouteResponseV2.ParameterConstraintsProperty",
        jsii_struct_bases=[],
        name_mapping={"required": "required"},
    )
    class ParameterConstraintsProperty:
        def __init__(
            self,
            *,
            required: typing.Union[builtins.bool, _IResolvable_a771d0ef],
        ) -> None:
            """
            :param required: (deprecated) ``CfnRouteResponseV2.ParameterConstraintsProperty.Required``.

            :deprecated: moved to package aws-apigatewayv2

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-routeresponse-parameterconstraints.html
            :stability: deprecated
            """
            self._values: typing.Dict[str, typing.Any] = {
                "required": required,
            }

        @builtins.property
        def required(self) -> typing.Union[builtins.bool, _IResolvable_a771d0ef]:
            """(deprecated) ``CfnRouteResponseV2.ParameterConstraintsProperty.Required``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-routeresponse-parameterconstraints.html#cfn-apigatewayv2-routeresponse-parameterconstraints-required
            :stability: deprecated
            """
            result = self._values.get("required")
            assert result is not None, "Required property 'required' is missing"
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ParameterConstraintsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.CfnRouteResponseV2Props",
    jsii_struct_bases=[],
    name_mapping={
        "api_id": "apiId",
        "route_id": "routeId",
        "route_response_key": "routeResponseKey",
        "model_selection_expression": "modelSelectionExpression",
        "response_models": "responseModels",
        "response_parameters": "responseParameters",
    },
)
class CfnRouteResponseV2Props:
    def __init__(
        self,
        *,
        api_id: builtins.str,
        route_id: builtins.str,
        route_response_key: builtins.str,
        model_selection_expression: typing.Optional[builtins.str] = None,
        response_models: typing.Any = None,
        response_parameters: typing.Any = None,
    ) -> None:
        """(deprecated) Properties for defining a ``AWS::ApiGatewayV2::RouteResponse``.

        :param api_id: (deprecated) ``AWS::ApiGatewayV2::RouteResponse.ApiId``.
        :param route_id: (deprecated) ``AWS::ApiGatewayV2::RouteResponse.RouteId``.
        :param route_response_key: (deprecated) ``AWS::ApiGatewayV2::RouteResponse.RouteResponseKey``.
        :param model_selection_expression: (deprecated) ``AWS::ApiGatewayV2::RouteResponse.ModelSelectionExpression``.
        :param response_models: (deprecated) ``AWS::ApiGatewayV2::RouteResponse.ResponseModels``.
        :param response_parameters: (deprecated) ``AWS::ApiGatewayV2::RouteResponse.ResponseParameters``.

        :deprecated: moved to package aws-apigatewayv2

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-routeresponse.html
        :stability: deprecated
        """
        self._values: typing.Dict[str, typing.Any] = {
            "api_id": api_id,
            "route_id": route_id,
            "route_response_key": route_response_key,
        }
        if model_selection_expression is not None:
            self._values["model_selection_expression"] = model_selection_expression
        if response_models is not None:
            self._values["response_models"] = response_models
        if response_parameters is not None:
            self._values["response_parameters"] = response_parameters

    @builtins.property
    def api_id(self) -> builtins.str:
        """(deprecated) ``AWS::ApiGatewayV2::RouteResponse.ApiId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-routeresponse.html#cfn-apigatewayv2-routeresponse-apiid
        :stability: deprecated
        """
        result = self._values.get("api_id")
        assert result is not None, "Required property 'api_id' is missing"
        return result

    @builtins.property
    def route_id(self) -> builtins.str:
        """(deprecated) ``AWS::ApiGatewayV2::RouteResponse.RouteId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-routeresponse.html#cfn-apigatewayv2-routeresponse-routeid
        :stability: deprecated
        """
        result = self._values.get("route_id")
        assert result is not None, "Required property 'route_id' is missing"
        return result

    @builtins.property
    def route_response_key(self) -> builtins.str:
        """(deprecated) ``AWS::ApiGatewayV2::RouteResponse.RouteResponseKey``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-routeresponse.html#cfn-apigatewayv2-routeresponse-routeresponsekey
        :stability: deprecated
        """
        result = self._values.get("route_response_key")
        assert result is not None, "Required property 'route_response_key' is missing"
        return result

    @builtins.property
    def model_selection_expression(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::RouteResponse.ModelSelectionExpression``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-routeresponse.html#cfn-apigatewayv2-routeresponse-modelselectionexpression
        :stability: deprecated
        """
        result = self._values.get("model_selection_expression")
        return result

    @builtins.property
    def response_models(self) -> typing.Any:
        """(deprecated) ``AWS::ApiGatewayV2::RouteResponse.ResponseModels``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-routeresponse.html#cfn-apigatewayv2-routeresponse-responsemodels
        :stability: deprecated
        """
        result = self._values.get("response_models")
        return result

    @builtins.property
    def response_parameters(self) -> typing.Any:
        """(deprecated) ``AWS::ApiGatewayV2::RouteResponse.ResponseParameters``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-routeresponse.html#cfn-apigatewayv2-routeresponse-responseparameters
        :stability: deprecated
        """
        result = self._values.get("response_parameters")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnRouteResponseV2Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_82c04a63)
class CfnRouteV2(
    _CfnResource_e0a482dc,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_apigateway.CfnRouteV2",
):
    """(deprecated) A CloudFormation ``AWS::ApiGatewayV2::Route``.

    :deprecated: moved to package aws-apigatewayv2

    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-route.html
    :stability: deprecated
    :cloudformationResource: AWS::ApiGatewayV2::Route
    """

    def __init__(
        self,
        scope: _Construct_e78e779f,
        id: builtins.str,
        *,
        api_id: builtins.str,
        route_key: builtins.str,
        api_key_required: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
        authorization_scopes: typing.Optional[typing.List[builtins.str]] = None,
        authorization_type: typing.Optional[builtins.str] = None,
        authorizer_id: typing.Optional[builtins.str] = None,
        model_selection_expression: typing.Optional[builtins.str] = None,
        operation_name: typing.Optional[builtins.str] = None,
        request_models: typing.Any = None,
        request_parameters: typing.Any = None,
        route_response_selection_expression: typing.Optional[builtins.str] = None,
        target: typing.Optional[builtins.str] = None,
    ) -> None:
        """(deprecated) Create a new ``AWS::ApiGatewayV2::Route``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param api_id: (deprecated) ``AWS::ApiGatewayV2::Route.ApiId``.
        :param route_key: (deprecated) ``AWS::ApiGatewayV2::Route.RouteKey``.
        :param api_key_required: (deprecated) ``AWS::ApiGatewayV2::Route.ApiKeyRequired``.
        :param authorization_scopes: (deprecated) ``AWS::ApiGatewayV2::Route.AuthorizationScopes``.
        :param authorization_type: (deprecated) ``AWS::ApiGatewayV2::Route.AuthorizationType``.
        :param authorizer_id: (deprecated) ``AWS::ApiGatewayV2::Route.AuthorizerId``.
        :param model_selection_expression: (deprecated) ``AWS::ApiGatewayV2::Route.ModelSelectionExpression``.
        :param operation_name: (deprecated) ``AWS::ApiGatewayV2::Route.OperationName``.
        :param request_models: (deprecated) ``AWS::ApiGatewayV2::Route.RequestModels``.
        :param request_parameters: (deprecated) ``AWS::ApiGatewayV2::Route.RequestParameters``.
        :param route_response_selection_expression: (deprecated) ``AWS::ApiGatewayV2::Route.RouteResponseSelectionExpression``.
        :param target: (deprecated) ``AWS::ApiGatewayV2::Route.Target``.

        :stability: deprecated
        """
        props = CfnRouteV2Props(
            api_id=api_id,
            route_key=route_key,
            api_key_required=api_key_required,
            authorization_scopes=authorization_scopes,
            authorization_type=authorization_type,
            authorizer_id=authorizer_id,
            model_selection_expression=model_selection_expression,
            operation_name=operation_name,
            request_models=request_models,
            request_parameters=request_parameters,
            route_response_selection_expression=route_response_selection_expression,
            target=target,
        )

        jsii.create(CfnRouteV2, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_1cd1894e) -> None:
        """(experimental) Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -

        :stability: deprecated
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """(deprecated) The CloudFormation resource type name for this resource class.

        :stability: deprecated
        """
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :stability: deprecated
        """
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiId")
    def api_id(self) -> builtins.str:
        """(deprecated) ``AWS::ApiGatewayV2::Route.ApiId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-route.html#cfn-apigatewayv2-route-apiid
        :stability: deprecated
        """
        return jsii.get(self, "apiId")

    @api_id.setter # type: ignore
    def api_id(self, value: builtins.str) -> None:
        jsii.set(self, "apiId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="requestModels")
    def request_models(self) -> typing.Any:
        """(deprecated) ``AWS::ApiGatewayV2::Route.RequestModels``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-route.html#cfn-apigatewayv2-route-requestmodels
        :stability: deprecated
        """
        return jsii.get(self, "requestModels")

    @request_models.setter # type: ignore
    def request_models(self, value: typing.Any) -> None:
        jsii.set(self, "requestModels", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="requestParameters")
    def request_parameters(self) -> typing.Any:
        """(deprecated) ``AWS::ApiGatewayV2::Route.RequestParameters``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-route.html#cfn-apigatewayv2-route-requestparameters
        :stability: deprecated
        """
        return jsii.get(self, "requestParameters")

    @request_parameters.setter # type: ignore
    def request_parameters(self, value: typing.Any) -> None:
        jsii.set(self, "requestParameters", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="routeKey")
    def route_key(self) -> builtins.str:
        """(deprecated) ``AWS::ApiGatewayV2::Route.RouteKey``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-route.html#cfn-apigatewayv2-route-routekey
        :stability: deprecated
        """
        return jsii.get(self, "routeKey")

    @route_key.setter # type: ignore
    def route_key(self, value: builtins.str) -> None:
        jsii.set(self, "routeKey", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiKeyRequired")
    def api_key_required(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
        """(deprecated) ``AWS::ApiGatewayV2::Route.ApiKeyRequired``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-route.html#cfn-apigatewayv2-route-apikeyrequired
        :stability: deprecated
        """
        return jsii.get(self, "apiKeyRequired")

    @api_key_required.setter # type: ignore
    def api_key_required(
        self,
        value: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]],
    ) -> None:
        jsii.set(self, "apiKeyRequired", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="authorizationScopes")
    def authorization_scopes(self) -> typing.Optional[typing.List[builtins.str]]:
        """(deprecated) ``AWS::ApiGatewayV2::Route.AuthorizationScopes``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-route.html#cfn-apigatewayv2-route-authorizationscopes
        :stability: deprecated
        """
        return jsii.get(self, "authorizationScopes")

    @authorization_scopes.setter # type: ignore
    def authorization_scopes(
        self,
        value: typing.Optional[typing.List[builtins.str]],
    ) -> None:
        jsii.set(self, "authorizationScopes", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="authorizationType")
    def authorization_type(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Route.AuthorizationType``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-route.html#cfn-apigatewayv2-route-authorizationtype
        :stability: deprecated
        """
        return jsii.get(self, "authorizationType")

    @authorization_type.setter # type: ignore
    def authorization_type(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "authorizationType", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="authorizerId")
    def authorizer_id(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Route.AuthorizerId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-route.html#cfn-apigatewayv2-route-authorizerid
        :stability: deprecated
        """
        return jsii.get(self, "authorizerId")

    @authorizer_id.setter # type: ignore
    def authorizer_id(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "authorizerId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="modelSelectionExpression")
    def model_selection_expression(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Route.ModelSelectionExpression``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-route.html#cfn-apigatewayv2-route-modelselectionexpression
        :stability: deprecated
        """
        return jsii.get(self, "modelSelectionExpression")

    @model_selection_expression.setter # type: ignore
    def model_selection_expression(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "modelSelectionExpression", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="operationName")
    def operation_name(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Route.OperationName``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-route.html#cfn-apigatewayv2-route-operationname
        :stability: deprecated
        """
        return jsii.get(self, "operationName")

    @operation_name.setter # type: ignore
    def operation_name(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "operationName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="routeResponseSelectionExpression")
    def route_response_selection_expression(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Route.RouteResponseSelectionExpression``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-route.html#cfn-apigatewayv2-route-routeresponseselectionexpression
        :stability: deprecated
        """
        return jsii.get(self, "routeResponseSelectionExpression")

    @route_response_selection_expression.setter # type: ignore
    def route_response_selection_expression(
        self,
        value: typing.Optional[builtins.str],
    ) -> None:
        jsii.set(self, "routeResponseSelectionExpression", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="target")
    def target(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Route.Target``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-route.html#cfn-apigatewayv2-route-target
        :stability: deprecated
        """
        return jsii.get(self, "target")

    @target.setter # type: ignore
    def target(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "target", value)

    @jsii.data_type(
        jsii_type="monocdk.aws_apigateway.CfnRouteV2.ParameterConstraintsProperty",
        jsii_struct_bases=[],
        name_mapping={"required": "required"},
    )
    class ParameterConstraintsProperty:
        def __init__(
            self,
            *,
            required: typing.Union[builtins.bool, _IResolvable_a771d0ef],
        ) -> None:
            """
            :param required: (deprecated) ``CfnRouteV2.ParameterConstraintsProperty.Required``.

            :deprecated: moved to package aws-apigatewayv2

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-route-parameterconstraints.html
            :stability: deprecated
            """
            self._values: typing.Dict[str, typing.Any] = {
                "required": required,
            }

        @builtins.property
        def required(self) -> typing.Union[builtins.bool, _IResolvable_a771d0ef]:
            """(deprecated) ``CfnRouteV2.ParameterConstraintsProperty.Required``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-route-parameterconstraints.html#cfn-apigatewayv2-route-parameterconstraints-required
            :stability: deprecated
            """
            result = self._values.get("required")
            assert result is not None, "Required property 'required' is missing"
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ParameterConstraintsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.CfnRouteV2Props",
    jsii_struct_bases=[],
    name_mapping={
        "api_id": "apiId",
        "route_key": "routeKey",
        "api_key_required": "apiKeyRequired",
        "authorization_scopes": "authorizationScopes",
        "authorization_type": "authorizationType",
        "authorizer_id": "authorizerId",
        "model_selection_expression": "modelSelectionExpression",
        "operation_name": "operationName",
        "request_models": "requestModels",
        "request_parameters": "requestParameters",
        "route_response_selection_expression": "routeResponseSelectionExpression",
        "target": "target",
    },
)
class CfnRouteV2Props:
    def __init__(
        self,
        *,
        api_id: builtins.str,
        route_key: builtins.str,
        api_key_required: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
        authorization_scopes: typing.Optional[typing.List[builtins.str]] = None,
        authorization_type: typing.Optional[builtins.str] = None,
        authorizer_id: typing.Optional[builtins.str] = None,
        model_selection_expression: typing.Optional[builtins.str] = None,
        operation_name: typing.Optional[builtins.str] = None,
        request_models: typing.Any = None,
        request_parameters: typing.Any = None,
        route_response_selection_expression: typing.Optional[builtins.str] = None,
        target: typing.Optional[builtins.str] = None,
    ) -> None:
        """(deprecated) Properties for defining a ``AWS::ApiGatewayV2::Route``.

        :param api_id: (deprecated) ``AWS::ApiGatewayV2::Route.ApiId``.
        :param route_key: (deprecated) ``AWS::ApiGatewayV2::Route.RouteKey``.
        :param api_key_required: (deprecated) ``AWS::ApiGatewayV2::Route.ApiKeyRequired``.
        :param authorization_scopes: (deprecated) ``AWS::ApiGatewayV2::Route.AuthorizationScopes``.
        :param authorization_type: (deprecated) ``AWS::ApiGatewayV2::Route.AuthorizationType``.
        :param authorizer_id: (deprecated) ``AWS::ApiGatewayV2::Route.AuthorizerId``.
        :param model_selection_expression: (deprecated) ``AWS::ApiGatewayV2::Route.ModelSelectionExpression``.
        :param operation_name: (deprecated) ``AWS::ApiGatewayV2::Route.OperationName``.
        :param request_models: (deprecated) ``AWS::ApiGatewayV2::Route.RequestModels``.
        :param request_parameters: (deprecated) ``AWS::ApiGatewayV2::Route.RequestParameters``.
        :param route_response_selection_expression: (deprecated) ``AWS::ApiGatewayV2::Route.RouteResponseSelectionExpression``.
        :param target: (deprecated) ``AWS::ApiGatewayV2::Route.Target``.

        :deprecated: moved to package aws-apigatewayv2

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-route.html
        :stability: deprecated
        """
        self._values: typing.Dict[str, typing.Any] = {
            "api_id": api_id,
            "route_key": route_key,
        }
        if api_key_required is not None:
            self._values["api_key_required"] = api_key_required
        if authorization_scopes is not None:
            self._values["authorization_scopes"] = authorization_scopes
        if authorization_type is not None:
            self._values["authorization_type"] = authorization_type
        if authorizer_id is not None:
            self._values["authorizer_id"] = authorizer_id
        if model_selection_expression is not None:
            self._values["model_selection_expression"] = model_selection_expression
        if operation_name is not None:
            self._values["operation_name"] = operation_name
        if request_models is not None:
            self._values["request_models"] = request_models
        if request_parameters is not None:
            self._values["request_parameters"] = request_parameters
        if route_response_selection_expression is not None:
            self._values["route_response_selection_expression"] = route_response_selection_expression
        if target is not None:
            self._values["target"] = target

    @builtins.property
    def api_id(self) -> builtins.str:
        """(deprecated) ``AWS::ApiGatewayV2::Route.ApiId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-route.html#cfn-apigatewayv2-route-apiid
        :stability: deprecated
        """
        result = self._values.get("api_id")
        assert result is not None, "Required property 'api_id' is missing"
        return result

    @builtins.property
    def route_key(self) -> builtins.str:
        """(deprecated) ``AWS::ApiGatewayV2::Route.RouteKey``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-route.html#cfn-apigatewayv2-route-routekey
        :stability: deprecated
        """
        result = self._values.get("route_key")
        assert result is not None, "Required property 'route_key' is missing"
        return result

    @builtins.property
    def api_key_required(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
        """(deprecated) ``AWS::ApiGatewayV2::Route.ApiKeyRequired``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-route.html#cfn-apigatewayv2-route-apikeyrequired
        :stability: deprecated
        """
        result = self._values.get("api_key_required")
        return result

    @builtins.property
    def authorization_scopes(self) -> typing.Optional[typing.List[builtins.str]]:
        """(deprecated) ``AWS::ApiGatewayV2::Route.AuthorizationScopes``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-route.html#cfn-apigatewayv2-route-authorizationscopes
        :stability: deprecated
        """
        result = self._values.get("authorization_scopes")
        return result

    @builtins.property
    def authorization_type(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Route.AuthorizationType``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-route.html#cfn-apigatewayv2-route-authorizationtype
        :stability: deprecated
        """
        result = self._values.get("authorization_type")
        return result

    @builtins.property
    def authorizer_id(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Route.AuthorizerId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-route.html#cfn-apigatewayv2-route-authorizerid
        :stability: deprecated
        """
        result = self._values.get("authorizer_id")
        return result

    @builtins.property
    def model_selection_expression(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Route.ModelSelectionExpression``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-route.html#cfn-apigatewayv2-route-modelselectionexpression
        :stability: deprecated
        """
        result = self._values.get("model_selection_expression")
        return result

    @builtins.property
    def operation_name(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Route.OperationName``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-route.html#cfn-apigatewayv2-route-operationname
        :stability: deprecated
        """
        result = self._values.get("operation_name")
        return result

    @builtins.property
    def request_models(self) -> typing.Any:
        """(deprecated) ``AWS::ApiGatewayV2::Route.RequestModels``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-route.html#cfn-apigatewayv2-route-requestmodels
        :stability: deprecated
        """
        result = self._values.get("request_models")
        return result

    @builtins.property
    def request_parameters(self) -> typing.Any:
        """(deprecated) ``AWS::ApiGatewayV2::Route.RequestParameters``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-route.html#cfn-apigatewayv2-route-requestparameters
        :stability: deprecated
        """
        result = self._values.get("request_parameters")
        return result

    @builtins.property
    def route_response_selection_expression(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Route.RouteResponseSelectionExpression``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-route.html#cfn-apigatewayv2-route-routeresponseselectionexpression
        :stability: deprecated
        """
        result = self._values.get("route_response_selection_expression")
        return result

    @builtins.property
    def target(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Route.Target``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-route.html#cfn-apigatewayv2-route-target
        :stability: deprecated
        """
        result = self._values.get("target")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnRouteV2Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_82c04a63)
class CfnStage(
    _CfnResource_e0a482dc,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_apigateway.CfnStage",
):
    """A CloudFormation ``AWS::ApiGateway::Stage``.

    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html
    :cloudformationResource: AWS::ApiGateway::Stage
    """

    def __init__(
        self,
        scope: _Construct_e78e779f,
        id: builtins.str,
        *,
        rest_api_id: builtins.str,
        access_log_setting: typing.Optional[typing.Union["CfnStage.AccessLogSettingProperty", _IResolvable_a771d0ef]] = None,
        cache_cluster_enabled: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
        cache_cluster_size: typing.Optional[builtins.str] = None,
        canary_setting: typing.Optional[typing.Union["CfnStage.CanarySettingProperty", _IResolvable_a771d0ef]] = None,
        client_certificate_id: typing.Optional[builtins.str] = None,
        deployment_id: typing.Optional[builtins.str] = None,
        description: typing.Optional[builtins.str] = None,
        documentation_version: typing.Optional[builtins.str] = None,
        method_settings: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnStage.MethodSettingProperty", _IResolvable_a771d0ef]]]] = None,
        stage_name: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.List[_CfnTag_95fbdc29]] = None,
        tracing_enabled: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
        variables: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, builtins.str]]] = None,
    ) -> None:
        """Create a new ``AWS::ApiGateway::Stage``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param rest_api_id: ``AWS::ApiGateway::Stage.RestApiId``.
        :param access_log_setting: ``AWS::ApiGateway::Stage.AccessLogSetting``.
        :param cache_cluster_enabled: ``AWS::ApiGateway::Stage.CacheClusterEnabled``.
        :param cache_cluster_size: ``AWS::ApiGateway::Stage.CacheClusterSize``.
        :param canary_setting: ``AWS::ApiGateway::Stage.CanarySetting``.
        :param client_certificate_id: ``AWS::ApiGateway::Stage.ClientCertificateId``.
        :param deployment_id: ``AWS::ApiGateway::Stage.DeploymentId``.
        :param description: ``AWS::ApiGateway::Stage.Description``.
        :param documentation_version: ``AWS::ApiGateway::Stage.DocumentationVersion``.
        :param method_settings: ``AWS::ApiGateway::Stage.MethodSettings``.
        :param stage_name: ``AWS::ApiGateway::Stage.StageName``.
        :param tags: ``AWS::ApiGateway::Stage.Tags``.
        :param tracing_enabled: ``AWS::ApiGateway::Stage.TracingEnabled``.
        :param variables: ``AWS::ApiGateway::Stage.Variables``.
        """
        props = CfnStageProps(
            rest_api_id=rest_api_id,
            access_log_setting=access_log_setting,
            cache_cluster_enabled=cache_cluster_enabled,
            cache_cluster_size=cache_cluster_size,
            canary_setting=canary_setting,
            client_certificate_id=client_certificate_id,
            deployment_id=deployment_id,
            description=description,
            documentation_version=documentation_version,
            method_settings=method_settings,
            stage_name=stage_name,
            tags=tags,
            tracing_enabled=tracing_enabled,
            variables=variables,
        )

        jsii.create(CfnStage, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_1cd1894e) -> None:
        """(experimental) Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_0b7ab120:
        """``AWS::ApiGateway::Stage.Tags``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-tags
        """
        return jsii.get(self, "tags")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="restApiId")
    def rest_api_id(self) -> builtins.str:
        """``AWS::ApiGateway::Stage.RestApiId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-restapiid
        """
        return jsii.get(self, "restApiId")

    @rest_api_id.setter # type: ignore
    def rest_api_id(self, value: builtins.str) -> None:
        jsii.set(self, "restApiId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="accessLogSetting")
    def access_log_setting(
        self,
    ) -> typing.Optional[typing.Union["CfnStage.AccessLogSettingProperty", _IResolvable_a771d0ef]]:
        """``AWS::ApiGateway::Stage.AccessLogSetting``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-accesslogsetting
        """
        return jsii.get(self, "accessLogSetting")

    @access_log_setting.setter # type: ignore
    def access_log_setting(
        self,
        value: typing.Optional[typing.Union["CfnStage.AccessLogSettingProperty", _IResolvable_a771d0ef]],
    ) -> None:
        jsii.set(self, "accessLogSetting", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cacheClusterEnabled")
    def cache_cluster_enabled(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
        """``AWS::ApiGateway::Stage.CacheClusterEnabled``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-cacheclusterenabled
        """
        return jsii.get(self, "cacheClusterEnabled")

    @cache_cluster_enabled.setter # type: ignore
    def cache_cluster_enabled(
        self,
        value: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]],
    ) -> None:
        jsii.set(self, "cacheClusterEnabled", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cacheClusterSize")
    def cache_cluster_size(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::Stage.CacheClusterSize``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-cacheclustersize
        """
        return jsii.get(self, "cacheClusterSize")

    @cache_cluster_size.setter # type: ignore
    def cache_cluster_size(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "cacheClusterSize", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="canarySetting")
    def canary_setting(
        self,
    ) -> typing.Optional[typing.Union["CfnStage.CanarySettingProperty", _IResolvable_a771d0ef]]:
        """``AWS::ApiGateway::Stage.CanarySetting``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-canarysetting
        """
        return jsii.get(self, "canarySetting")

    @canary_setting.setter # type: ignore
    def canary_setting(
        self,
        value: typing.Optional[typing.Union["CfnStage.CanarySettingProperty", _IResolvable_a771d0ef]],
    ) -> None:
        jsii.set(self, "canarySetting", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="clientCertificateId")
    def client_certificate_id(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::Stage.ClientCertificateId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-clientcertificateid
        """
        return jsii.get(self, "clientCertificateId")

    @client_certificate_id.setter # type: ignore
    def client_certificate_id(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "clientCertificateId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="deploymentId")
    def deployment_id(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::Stage.DeploymentId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-deploymentid
        """
        return jsii.get(self, "deploymentId")

    @deployment_id.setter # type: ignore
    def deployment_id(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "deploymentId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::Stage.Description``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-description
        """
        return jsii.get(self, "description")

    @description.setter # type: ignore
    def description(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "description", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="documentationVersion")
    def documentation_version(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::Stage.DocumentationVersion``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-documentationversion
        """
        return jsii.get(self, "documentationVersion")

    @documentation_version.setter # type: ignore
    def documentation_version(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "documentationVersion", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="methodSettings")
    def method_settings(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnStage.MethodSettingProperty", _IResolvable_a771d0ef]]]]:
        """``AWS::ApiGateway::Stage.MethodSettings``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-methodsettings
        """
        return jsii.get(self, "methodSettings")

    @method_settings.setter # type: ignore
    def method_settings(
        self,
        value: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnStage.MethodSettingProperty", _IResolvable_a771d0ef]]]],
    ) -> None:
        jsii.set(self, "methodSettings", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="stageName")
    def stage_name(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::Stage.StageName``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-stagename
        """
        return jsii.get(self, "stageName")

    @stage_name.setter # type: ignore
    def stage_name(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "stageName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tracingEnabled")
    def tracing_enabled(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
        """``AWS::ApiGateway::Stage.TracingEnabled``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-tracingenabled
        """
        return jsii.get(self, "tracingEnabled")

    @tracing_enabled.setter # type: ignore
    def tracing_enabled(
        self,
        value: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]],
    ) -> None:
        jsii.set(self, "tracingEnabled", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="variables")
    def variables(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, builtins.str]]]:
        """``AWS::ApiGateway::Stage.Variables``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-variables
        """
        return jsii.get(self, "variables")

    @variables.setter # type: ignore
    def variables(
        self,
        value: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, builtins.str]]],
    ) -> None:
        jsii.set(self, "variables", value)

    @jsii.data_type(
        jsii_type="monocdk.aws_apigateway.CfnStage.AccessLogSettingProperty",
        jsii_struct_bases=[],
        name_mapping={"destination_arn": "destinationArn", "format": "format"},
    )
    class AccessLogSettingProperty:
        def __init__(
            self,
            *,
            destination_arn: typing.Optional[builtins.str] = None,
            format: typing.Optional[builtins.str] = None,
        ) -> None:
            """
            :param destination_arn: ``CfnStage.AccessLogSettingProperty.DestinationArn``.
            :param format: ``CfnStage.AccessLogSettingProperty.Format``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-accesslogsetting.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if destination_arn is not None:
                self._values["destination_arn"] = destination_arn
            if format is not None:
                self._values["format"] = format

        @builtins.property
        def destination_arn(self) -> typing.Optional[builtins.str]:
            """``CfnStage.AccessLogSettingProperty.DestinationArn``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-accesslogsetting.html#cfn-apigateway-stage-accesslogsetting-destinationarn
            """
            result = self._values.get("destination_arn")
            return result

        @builtins.property
        def format(self) -> typing.Optional[builtins.str]:
            """``CfnStage.AccessLogSettingProperty.Format``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-accesslogsetting.html#cfn-apigateway-stage-accesslogsetting-format
            """
            result = self._values.get("format")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AccessLogSettingProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_apigateway.CfnStage.CanarySettingProperty",
        jsii_struct_bases=[],
        name_mapping={
            "deployment_id": "deploymentId",
            "percent_traffic": "percentTraffic",
            "stage_variable_overrides": "stageVariableOverrides",
            "use_stage_cache": "useStageCache",
        },
    )
    class CanarySettingProperty:
        def __init__(
            self,
            *,
            deployment_id: typing.Optional[builtins.str] = None,
            percent_traffic: typing.Optional[jsii.Number] = None,
            stage_variable_overrides: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, builtins.str]]] = None,
            use_stage_cache: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
        ) -> None:
            """
            :param deployment_id: ``CfnStage.CanarySettingProperty.DeploymentId``.
            :param percent_traffic: ``CfnStage.CanarySettingProperty.PercentTraffic``.
            :param stage_variable_overrides: ``CfnStage.CanarySettingProperty.StageVariableOverrides``.
            :param use_stage_cache: ``CfnStage.CanarySettingProperty.UseStageCache``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-canarysetting.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if deployment_id is not None:
                self._values["deployment_id"] = deployment_id
            if percent_traffic is not None:
                self._values["percent_traffic"] = percent_traffic
            if stage_variable_overrides is not None:
                self._values["stage_variable_overrides"] = stage_variable_overrides
            if use_stage_cache is not None:
                self._values["use_stage_cache"] = use_stage_cache

        @builtins.property
        def deployment_id(self) -> typing.Optional[builtins.str]:
            """``CfnStage.CanarySettingProperty.DeploymentId``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-canarysetting.html#cfn-apigateway-stage-canarysetting-deploymentid
            """
            result = self._values.get("deployment_id")
            return result

        @builtins.property
        def percent_traffic(self) -> typing.Optional[jsii.Number]:
            """``CfnStage.CanarySettingProperty.PercentTraffic``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-canarysetting.html#cfn-apigateway-stage-canarysetting-percenttraffic
            """
            result = self._values.get("percent_traffic")
            return result

        @builtins.property
        def stage_variable_overrides(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, builtins.str]]]:
            """``CfnStage.CanarySettingProperty.StageVariableOverrides``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-canarysetting.html#cfn-apigateway-stage-canarysetting-stagevariableoverrides
            """
            result = self._values.get("stage_variable_overrides")
            return result

        @builtins.property
        def use_stage_cache(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
            """``CfnStage.CanarySettingProperty.UseStageCache``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-canarysetting.html#cfn-apigateway-stage-canarysetting-usestagecache
            """
            result = self._values.get("use_stage_cache")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CanarySettingProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_apigateway.CfnStage.MethodSettingProperty",
        jsii_struct_bases=[],
        name_mapping={
            "cache_data_encrypted": "cacheDataEncrypted",
            "cache_ttl_in_seconds": "cacheTtlInSeconds",
            "caching_enabled": "cachingEnabled",
            "data_trace_enabled": "dataTraceEnabled",
            "http_method": "httpMethod",
            "logging_level": "loggingLevel",
            "metrics_enabled": "metricsEnabled",
            "resource_path": "resourcePath",
            "throttling_burst_limit": "throttlingBurstLimit",
            "throttling_rate_limit": "throttlingRateLimit",
        },
    )
    class MethodSettingProperty:
        def __init__(
            self,
            *,
            cache_data_encrypted: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
            cache_ttl_in_seconds: typing.Optional[jsii.Number] = None,
            caching_enabled: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
            data_trace_enabled: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
            http_method: typing.Optional[builtins.str] = None,
            logging_level: typing.Optional[builtins.str] = None,
            metrics_enabled: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
            resource_path: typing.Optional[builtins.str] = None,
            throttling_burst_limit: typing.Optional[jsii.Number] = None,
            throttling_rate_limit: typing.Optional[jsii.Number] = None,
        ) -> None:
            """
            :param cache_data_encrypted: ``CfnStage.MethodSettingProperty.CacheDataEncrypted``.
            :param cache_ttl_in_seconds: ``CfnStage.MethodSettingProperty.CacheTtlInSeconds``.
            :param caching_enabled: ``CfnStage.MethodSettingProperty.CachingEnabled``.
            :param data_trace_enabled: ``CfnStage.MethodSettingProperty.DataTraceEnabled``.
            :param http_method: ``CfnStage.MethodSettingProperty.HttpMethod``.
            :param logging_level: ``CfnStage.MethodSettingProperty.LoggingLevel``.
            :param metrics_enabled: ``CfnStage.MethodSettingProperty.MetricsEnabled``.
            :param resource_path: ``CfnStage.MethodSettingProperty.ResourcePath``.
            :param throttling_burst_limit: ``CfnStage.MethodSettingProperty.ThrottlingBurstLimit``.
            :param throttling_rate_limit: ``CfnStage.MethodSettingProperty.ThrottlingRateLimit``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if cache_data_encrypted is not None:
                self._values["cache_data_encrypted"] = cache_data_encrypted
            if cache_ttl_in_seconds is not None:
                self._values["cache_ttl_in_seconds"] = cache_ttl_in_seconds
            if caching_enabled is not None:
                self._values["caching_enabled"] = caching_enabled
            if data_trace_enabled is not None:
                self._values["data_trace_enabled"] = data_trace_enabled
            if http_method is not None:
                self._values["http_method"] = http_method
            if logging_level is not None:
                self._values["logging_level"] = logging_level
            if metrics_enabled is not None:
                self._values["metrics_enabled"] = metrics_enabled
            if resource_path is not None:
                self._values["resource_path"] = resource_path
            if throttling_burst_limit is not None:
                self._values["throttling_burst_limit"] = throttling_burst_limit
            if throttling_rate_limit is not None:
                self._values["throttling_rate_limit"] = throttling_rate_limit

        @builtins.property
        def cache_data_encrypted(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
            """``CfnStage.MethodSettingProperty.CacheDataEncrypted``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-cachedataencrypted
            """
            result = self._values.get("cache_data_encrypted")
            return result

        @builtins.property
        def cache_ttl_in_seconds(self) -> typing.Optional[jsii.Number]:
            """``CfnStage.MethodSettingProperty.CacheTtlInSeconds``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-cachettlinseconds
            """
            result = self._values.get("cache_ttl_in_seconds")
            return result

        @builtins.property
        def caching_enabled(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
            """``CfnStage.MethodSettingProperty.CachingEnabled``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-cachingenabled
            """
            result = self._values.get("caching_enabled")
            return result

        @builtins.property
        def data_trace_enabled(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
            """``CfnStage.MethodSettingProperty.DataTraceEnabled``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-datatraceenabled
            """
            result = self._values.get("data_trace_enabled")
            return result

        @builtins.property
        def http_method(self) -> typing.Optional[builtins.str]:
            """``CfnStage.MethodSettingProperty.HttpMethod``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-httpmethod
            """
            result = self._values.get("http_method")
            return result

        @builtins.property
        def logging_level(self) -> typing.Optional[builtins.str]:
            """``CfnStage.MethodSettingProperty.LoggingLevel``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-logginglevel
            """
            result = self._values.get("logging_level")
            return result

        @builtins.property
        def metrics_enabled(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
            """``CfnStage.MethodSettingProperty.MetricsEnabled``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-metricsenabled
            """
            result = self._values.get("metrics_enabled")
            return result

        @builtins.property
        def resource_path(self) -> typing.Optional[builtins.str]:
            """``CfnStage.MethodSettingProperty.ResourcePath``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-resourcepath
            """
            result = self._values.get("resource_path")
            return result

        @builtins.property
        def throttling_burst_limit(self) -> typing.Optional[jsii.Number]:
            """``CfnStage.MethodSettingProperty.ThrottlingBurstLimit``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-throttlingburstlimit
            """
            result = self._values.get("throttling_burst_limit")
            return result

        @builtins.property
        def throttling_rate_limit(self) -> typing.Optional[jsii.Number]:
            """``CfnStage.MethodSettingProperty.ThrottlingRateLimit``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-throttlingratelimit
            """
            result = self._values.get("throttling_rate_limit")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "MethodSettingProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.CfnStageProps",
    jsii_struct_bases=[],
    name_mapping={
        "rest_api_id": "restApiId",
        "access_log_setting": "accessLogSetting",
        "cache_cluster_enabled": "cacheClusterEnabled",
        "cache_cluster_size": "cacheClusterSize",
        "canary_setting": "canarySetting",
        "client_certificate_id": "clientCertificateId",
        "deployment_id": "deploymentId",
        "description": "description",
        "documentation_version": "documentationVersion",
        "method_settings": "methodSettings",
        "stage_name": "stageName",
        "tags": "tags",
        "tracing_enabled": "tracingEnabled",
        "variables": "variables",
    },
)
class CfnStageProps:
    def __init__(
        self,
        *,
        rest_api_id: builtins.str,
        access_log_setting: typing.Optional[typing.Union[CfnStage.AccessLogSettingProperty, _IResolvable_a771d0ef]] = None,
        cache_cluster_enabled: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
        cache_cluster_size: typing.Optional[builtins.str] = None,
        canary_setting: typing.Optional[typing.Union[CfnStage.CanarySettingProperty, _IResolvable_a771d0ef]] = None,
        client_certificate_id: typing.Optional[builtins.str] = None,
        deployment_id: typing.Optional[builtins.str] = None,
        description: typing.Optional[builtins.str] = None,
        documentation_version: typing.Optional[builtins.str] = None,
        method_settings: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union[CfnStage.MethodSettingProperty, _IResolvable_a771d0ef]]]] = None,
        stage_name: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.List[_CfnTag_95fbdc29]] = None,
        tracing_enabled: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
        variables: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, builtins.str]]] = None,
    ) -> None:
        """Properties for defining a ``AWS::ApiGateway::Stage``.

        :param rest_api_id: ``AWS::ApiGateway::Stage.RestApiId``.
        :param access_log_setting: ``AWS::ApiGateway::Stage.AccessLogSetting``.
        :param cache_cluster_enabled: ``AWS::ApiGateway::Stage.CacheClusterEnabled``.
        :param cache_cluster_size: ``AWS::ApiGateway::Stage.CacheClusterSize``.
        :param canary_setting: ``AWS::ApiGateway::Stage.CanarySetting``.
        :param client_certificate_id: ``AWS::ApiGateway::Stage.ClientCertificateId``.
        :param deployment_id: ``AWS::ApiGateway::Stage.DeploymentId``.
        :param description: ``AWS::ApiGateway::Stage.Description``.
        :param documentation_version: ``AWS::ApiGateway::Stage.DocumentationVersion``.
        :param method_settings: ``AWS::ApiGateway::Stage.MethodSettings``.
        :param stage_name: ``AWS::ApiGateway::Stage.StageName``.
        :param tags: ``AWS::ApiGateway::Stage.Tags``.
        :param tracing_enabled: ``AWS::ApiGateway::Stage.TracingEnabled``.
        :param variables: ``AWS::ApiGateway::Stage.Variables``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html
        """
        self._values: typing.Dict[str, typing.Any] = {
            "rest_api_id": rest_api_id,
        }
        if access_log_setting is not None:
            self._values["access_log_setting"] = access_log_setting
        if cache_cluster_enabled is not None:
            self._values["cache_cluster_enabled"] = cache_cluster_enabled
        if cache_cluster_size is not None:
            self._values["cache_cluster_size"] = cache_cluster_size
        if canary_setting is not None:
            self._values["canary_setting"] = canary_setting
        if client_certificate_id is not None:
            self._values["client_certificate_id"] = client_certificate_id
        if deployment_id is not None:
            self._values["deployment_id"] = deployment_id
        if description is not None:
            self._values["description"] = description
        if documentation_version is not None:
            self._values["documentation_version"] = documentation_version
        if method_settings is not None:
            self._values["method_settings"] = method_settings
        if stage_name is not None:
            self._values["stage_name"] = stage_name
        if tags is not None:
            self._values["tags"] = tags
        if tracing_enabled is not None:
            self._values["tracing_enabled"] = tracing_enabled
        if variables is not None:
            self._values["variables"] = variables

    @builtins.property
    def rest_api_id(self) -> builtins.str:
        """``AWS::ApiGateway::Stage.RestApiId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-restapiid
        """
        result = self._values.get("rest_api_id")
        assert result is not None, "Required property 'rest_api_id' is missing"
        return result

    @builtins.property
    def access_log_setting(
        self,
    ) -> typing.Optional[typing.Union[CfnStage.AccessLogSettingProperty, _IResolvable_a771d0ef]]:
        """``AWS::ApiGateway::Stage.AccessLogSetting``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-accesslogsetting
        """
        result = self._values.get("access_log_setting")
        return result

    @builtins.property
    def cache_cluster_enabled(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
        """``AWS::ApiGateway::Stage.CacheClusterEnabled``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-cacheclusterenabled
        """
        result = self._values.get("cache_cluster_enabled")
        return result

    @builtins.property
    def cache_cluster_size(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::Stage.CacheClusterSize``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-cacheclustersize
        """
        result = self._values.get("cache_cluster_size")
        return result

    @builtins.property
    def canary_setting(
        self,
    ) -> typing.Optional[typing.Union[CfnStage.CanarySettingProperty, _IResolvable_a771d0ef]]:
        """``AWS::ApiGateway::Stage.CanarySetting``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-canarysetting
        """
        result = self._values.get("canary_setting")
        return result

    @builtins.property
    def client_certificate_id(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::Stage.ClientCertificateId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-clientcertificateid
        """
        result = self._values.get("client_certificate_id")
        return result

    @builtins.property
    def deployment_id(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::Stage.DeploymentId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-deploymentid
        """
        result = self._values.get("deployment_id")
        return result

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::Stage.Description``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-description
        """
        result = self._values.get("description")
        return result

    @builtins.property
    def documentation_version(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::Stage.DocumentationVersion``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-documentationversion
        """
        result = self._values.get("documentation_version")
        return result

    @builtins.property
    def method_settings(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union[CfnStage.MethodSettingProperty, _IResolvable_a771d0ef]]]]:
        """``AWS::ApiGateway::Stage.MethodSettings``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-methodsettings
        """
        result = self._values.get("method_settings")
        return result

    @builtins.property
    def stage_name(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::Stage.StageName``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-stagename
        """
        result = self._values.get("stage_name")
        return result

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_95fbdc29]]:
        """``AWS::ApiGateway::Stage.Tags``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-tags
        """
        result = self._values.get("tags")
        return result

    @builtins.property
    def tracing_enabled(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
        """``AWS::ApiGateway::Stage.TracingEnabled``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-tracingenabled
        """
        result = self._values.get("tracing_enabled")
        return result

    @builtins.property
    def variables(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, builtins.str]]]:
        """``AWS::ApiGateway::Stage.Variables``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-variables
        """
        result = self._values.get("variables")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnStageProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_82c04a63)
class CfnStageV2(
    _CfnResource_e0a482dc,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_apigateway.CfnStageV2",
):
    """(deprecated) A CloudFormation ``AWS::ApiGatewayV2::Stage``.

    :deprecated: moved to package aws-apigatewayv2

    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html
    :stability: deprecated
    :cloudformationResource: AWS::ApiGatewayV2::Stage
    """

    def __init__(
        self,
        scope: _Construct_e78e779f,
        id: builtins.str,
        *,
        api_id: builtins.str,
        stage_name: builtins.str,
        access_log_settings: typing.Optional[typing.Union["CfnStageV2.AccessLogSettingsProperty", _IResolvable_a771d0ef]] = None,
        auto_deploy: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
        client_certificate_id: typing.Optional[builtins.str] = None,
        default_route_settings: typing.Optional[typing.Union["CfnStageV2.RouteSettingsProperty", _IResolvable_a771d0ef]] = None,
        deployment_id: typing.Optional[builtins.str] = None,
        description: typing.Optional[builtins.str] = None,
        route_settings: typing.Any = None,
        stage_variables: typing.Any = None,
        tags: typing.Any = None,
    ) -> None:
        """(deprecated) Create a new ``AWS::ApiGatewayV2::Stage``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param api_id: (deprecated) ``AWS::ApiGatewayV2::Stage.ApiId``.
        :param stage_name: (deprecated) ``AWS::ApiGatewayV2::Stage.StageName``.
        :param access_log_settings: (deprecated) ``AWS::ApiGatewayV2::Stage.AccessLogSettings``.
        :param auto_deploy: (deprecated) ``AWS::ApiGatewayV2::Stage.AutoDeploy``.
        :param client_certificate_id: (deprecated) ``AWS::ApiGatewayV2::Stage.ClientCertificateId``.
        :param default_route_settings: (deprecated) ``AWS::ApiGatewayV2::Stage.DefaultRouteSettings``.
        :param deployment_id: (deprecated) ``AWS::ApiGatewayV2::Stage.DeploymentId``.
        :param description: (deprecated) ``AWS::ApiGatewayV2::Stage.Description``.
        :param route_settings: (deprecated) ``AWS::ApiGatewayV2::Stage.RouteSettings``.
        :param stage_variables: (deprecated) ``AWS::ApiGatewayV2::Stage.StageVariables``.
        :param tags: (deprecated) ``AWS::ApiGatewayV2::Stage.Tags``.

        :stability: deprecated
        """
        props = CfnStageV2Props(
            api_id=api_id,
            stage_name=stage_name,
            access_log_settings=access_log_settings,
            auto_deploy=auto_deploy,
            client_certificate_id=client_certificate_id,
            default_route_settings=default_route_settings,
            deployment_id=deployment_id,
            description=description,
            route_settings=route_settings,
            stage_variables=stage_variables,
            tags=tags,
        )

        jsii.create(CfnStageV2, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_1cd1894e) -> None:
        """(experimental) Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -

        :stability: deprecated
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """(deprecated) The CloudFormation resource type name for this resource class.

        :stability: deprecated
        """
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :stability: deprecated
        """
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_0b7ab120:
        """(deprecated) ``AWS::ApiGatewayV2::Stage.Tags``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-tags
        :stability: deprecated
        """
        return jsii.get(self, "tags")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiId")
    def api_id(self) -> builtins.str:
        """(deprecated) ``AWS::ApiGatewayV2::Stage.ApiId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-apiid
        :stability: deprecated
        """
        return jsii.get(self, "apiId")

    @api_id.setter # type: ignore
    def api_id(self, value: builtins.str) -> None:
        jsii.set(self, "apiId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="routeSettings")
    def route_settings(self) -> typing.Any:
        """(deprecated) ``AWS::ApiGatewayV2::Stage.RouteSettings``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-routesettings
        :stability: deprecated
        """
        return jsii.get(self, "routeSettings")

    @route_settings.setter # type: ignore
    def route_settings(self, value: typing.Any) -> None:
        jsii.set(self, "routeSettings", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="stageName")
    def stage_name(self) -> builtins.str:
        """(deprecated) ``AWS::ApiGatewayV2::Stage.StageName``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-stagename
        :stability: deprecated
        """
        return jsii.get(self, "stageName")

    @stage_name.setter # type: ignore
    def stage_name(self, value: builtins.str) -> None:
        jsii.set(self, "stageName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="stageVariables")
    def stage_variables(self) -> typing.Any:
        """(deprecated) ``AWS::ApiGatewayV2::Stage.StageVariables``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-stagevariables
        :stability: deprecated
        """
        return jsii.get(self, "stageVariables")

    @stage_variables.setter # type: ignore
    def stage_variables(self, value: typing.Any) -> None:
        jsii.set(self, "stageVariables", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="accessLogSettings")
    def access_log_settings(
        self,
    ) -> typing.Optional[typing.Union["CfnStageV2.AccessLogSettingsProperty", _IResolvable_a771d0ef]]:
        """(deprecated) ``AWS::ApiGatewayV2::Stage.AccessLogSettings``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-accesslogsettings
        :stability: deprecated
        """
        return jsii.get(self, "accessLogSettings")

    @access_log_settings.setter # type: ignore
    def access_log_settings(
        self,
        value: typing.Optional[typing.Union["CfnStageV2.AccessLogSettingsProperty", _IResolvable_a771d0ef]],
    ) -> None:
        jsii.set(self, "accessLogSettings", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="autoDeploy")
    def auto_deploy(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
        """(deprecated) ``AWS::ApiGatewayV2::Stage.AutoDeploy``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-autodeploy
        :stability: deprecated
        """
        return jsii.get(self, "autoDeploy")

    @auto_deploy.setter # type: ignore
    def auto_deploy(
        self,
        value: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]],
    ) -> None:
        jsii.set(self, "autoDeploy", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="clientCertificateId")
    def client_certificate_id(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Stage.ClientCertificateId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-clientcertificateid
        :stability: deprecated
        """
        return jsii.get(self, "clientCertificateId")

    @client_certificate_id.setter # type: ignore
    def client_certificate_id(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "clientCertificateId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="defaultRouteSettings")
    def default_route_settings(
        self,
    ) -> typing.Optional[typing.Union["CfnStageV2.RouteSettingsProperty", _IResolvable_a771d0ef]]:
        """(deprecated) ``AWS::ApiGatewayV2::Stage.DefaultRouteSettings``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-defaultroutesettings
        :stability: deprecated
        """
        return jsii.get(self, "defaultRouteSettings")

    @default_route_settings.setter # type: ignore
    def default_route_settings(
        self,
        value: typing.Optional[typing.Union["CfnStageV2.RouteSettingsProperty", _IResolvable_a771d0ef]],
    ) -> None:
        jsii.set(self, "defaultRouteSettings", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="deploymentId")
    def deployment_id(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Stage.DeploymentId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-deploymentid
        :stability: deprecated
        """
        return jsii.get(self, "deploymentId")

    @deployment_id.setter # type: ignore
    def deployment_id(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "deploymentId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Stage.Description``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-description
        :stability: deprecated
        """
        return jsii.get(self, "description")

    @description.setter # type: ignore
    def description(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "description", value)

    @jsii.data_type(
        jsii_type="monocdk.aws_apigateway.CfnStageV2.AccessLogSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={"destination_arn": "destinationArn", "format": "format"},
    )
    class AccessLogSettingsProperty:
        def __init__(
            self,
            *,
            destination_arn: typing.Optional[builtins.str] = None,
            format: typing.Optional[builtins.str] = None,
        ) -> None:
            """
            :param destination_arn: (deprecated) ``CfnStageV2.AccessLogSettingsProperty.DestinationArn``.
            :param format: (deprecated) ``CfnStageV2.AccessLogSettingsProperty.Format``.

            :deprecated: moved to package aws-apigatewayv2

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-stage-accesslogsettings.html
            :stability: deprecated
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if destination_arn is not None:
                self._values["destination_arn"] = destination_arn
            if format is not None:
                self._values["format"] = format

        @builtins.property
        def destination_arn(self) -> typing.Optional[builtins.str]:
            """(deprecated) ``CfnStageV2.AccessLogSettingsProperty.DestinationArn``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-stage-accesslogsettings.html#cfn-apigatewayv2-stage-accesslogsettings-destinationarn
            :stability: deprecated
            """
            result = self._values.get("destination_arn")
            return result

        @builtins.property
        def format(self) -> typing.Optional[builtins.str]:
            """(deprecated) ``CfnStageV2.AccessLogSettingsProperty.Format``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-stage-accesslogsettings.html#cfn-apigatewayv2-stage-accesslogsettings-format
            :stability: deprecated
            """
            result = self._values.get("format")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AccessLogSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_apigateway.CfnStageV2.RouteSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "data_trace_enabled": "dataTraceEnabled",
            "detailed_metrics_enabled": "detailedMetricsEnabled",
            "logging_level": "loggingLevel",
            "throttling_burst_limit": "throttlingBurstLimit",
            "throttling_rate_limit": "throttlingRateLimit",
        },
    )
    class RouteSettingsProperty:
        def __init__(
            self,
            *,
            data_trace_enabled: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
            detailed_metrics_enabled: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
            logging_level: typing.Optional[builtins.str] = None,
            throttling_burst_limit: typing.Optional[jsii.Number] = None,
            throttling_rate_limit: typing.Optional[jsii.Number] = None,
        ) -> None:
            """
            :param data_trace_enabled: (deprecated) ``CfnStageV2.RouteSettingsProperty.DataTraceEnabled``.
            :param detailed_metrics_enabled: (deprecated) ``CfnStageV2.RouteSettingsProperty.DetailedMetricsEnabled``.
            :param logging_level: (deprecated) ``CfnStageV2.RouteSettingsProperty.LoggingLevel``.
            :param throttling_burst_limit: (deprecated) ``CfnStageV2.RouteSettingsProperty.ThrottlingBurstLimit``.
            :param throttling_rate_limit: (deprecated) ``CfnStageV2.RouteSettingsProperty.ThrottlingRateLimit``.

            :deprecated: moved to package aws-apigatewayv2

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-stage-routesettings.html
            :stability: deprecated
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if data_trace_enabled is not None:
                self._values["data_trace_enabled"] = data_trace_enabled
            if detailed_metrics_enabled is not None:
                self._values["detailed_metrics_enabled"] = detailed_metrics_enabled
            if logging_level is not None:
                self._values["logging_level"] = logging_level
            if throttling_burst_limit is not None:
                self._values["throttling_burst_limit"] = throttling_burst_limit
            if throttling_rate_limit is not None:
                self._values["throttling_rate_limit"] = throttling_rate_limit

        @builtins.property
        def data_trace_enabled(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
            """(deprecated) ``CfnStageV2.RouteSettingsProperty.DataTraceEnabled``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-stage-routesettings.html#cfn-apigatewayv2-stage-routesettings-datatraceenabled
            :stability: deprecated
            """
            result = self._values.get("data_trace_enabled")
            return result

        @builtins.property
        def detailed_metrics_enabled(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
            """(deprecated) ``CfnStageV2.RouteSettingsProperty.DetailedMetricsEnabled``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-stage-routesettings.html#cfn-apigatewayv2-stage-routesettings-detailedmetricsenabled
            :stability: deprecated
            """
            result = self._values.get("detailed_metrics_enabled")
            return result

        @builtins.property
        def logging_level(self) -> typing.Optional[builtins.str]:
            """(deprecated) ``CfnStageV2.RouteSettingsProperty.LoggingLevel``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-stage-routesettings.html#cfn-apigatewayv2-stage-routesettings-logginglevel
            :stability: deprecated
            """
            result = self._values.get("logging_level")
            return result

        @builtins.property
        def throttling_burst_limit(self) -> typing.Optional[jsii.Number]:
            """(deprecated) ``CfnStageV2.RouteSettingsProperty.ThrottlingBurstLimit``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-stage-routesettings.html#cfn-apigatewayv2-stage-routesettings-throttlingburstlimit
            :stability: deprecated
            """
            result = self._values.get("throttling_burst_limit")
            return result

        @builtins.property
        def throttling_rate_limit(self) -> typing.Optional[jsii.Number]:
            """(deprecated) ``CfnStageV2.RouteSettingsProperty.ThrottlingRateLimit``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-stage-routesettings.html#cfn-apigatewayv2-stage-routesettings-throttlingratelimit
            :stability: deprecated
            """
            result = self._values.get("throttling_rate_limit")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "RouteSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.CfnStageV2Props",
    jsii_struct_bases=[],
    name_mapping={
        "api_id": "apiId",
        "stage_name": "stageName",
        "access_log_settings": "accessLogSettings",
        "auto_deploy": "autoDeploy",
        "client_certificate_id": "clientCertificateId",
        "default_route_settings": "defaultRouteSettings",
        "deployment_id": "deploymentId",
        "description": "description",
        "route_settings": "routeSettings",
        "stage_variables": "stageVariables",
        "tags": "tags",
    },
)
class CfnStageV2Props:
    def __init__(
        self,
        *,
        api_id: builtins.str,
        stage_name: builtins.str,
        access_log_settings: typing.Optional[typing.Union[CfnStageV2.AccessLogSettingsProperty, _IResolvable_a771d0ef]] = None,
        auto_deploy: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
        client_certificate_id: typing.Optional[builtins.str] = None,
        default_route_settings: typing.Optional[typing.Union[CfnStageV2.RouteSettingsProperty, _IResolvable_a771d0ef]] = None,
        deployment_id: typing.Optional[builtins.str] = None,
        description: typing.Optional[builtins.str] = None,
        route_settings: typing.Any = None,
        stage_variables: typing.Any = None,
        tags: typing.Any = None,
    ) -> None:
        """(deprecated) Properties for defining a ``AWS::ApiGatewayV2::Stage``.

        :param api_id: (deprecated) ``AWS::ApiGatewayV2::Stage.ApiId``.
        :param stage_name: (deprecated) ``AWS::ApiGatewayV2::Stage.StageName``.
        :param access_log_settings: (deprecated) ``AWS::ApiGatewayV2::Stage.AccessLogSettings``.
        :param auto_deploy: (deprecated) ``AWS::ApiGatewayV2::Stage.AutoDeploy``.
        :param client_certificate_id: (deprecated) ``AWS::ApiGatewayV2::Stage.ClientCertificateId``.
        :param default_route_settings: (deprecated) ``AWS::ApiGatewayV2::Stage.DefaultRouteSettings``.
        :param deployment_id: (deprecated) ``AWS::ApiGatewayV2::Stage.DeploymentId``.
        :param description: (deprecated) ``AWS::ApiGatewayV2::Stage.Description``.
        :param route_settings: (deprecated) ``AWS::ApiGatewayV2::Stage.RouteSettings``.
        :param stage_variables: (deprecated) ``AWS::ApiGatewayV2::Stage.StageVariables``.
        :param tags: (deprecated) ``AWS::ApiGatewayV2::Stage.Tags``.

        :deprecated: moved to package aws-apigatewayv2

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html
        :stability: deprecated
        """
        self._values: typing.Dict[str, typing.Any] = {
            "api_id": api_id,
            "stage_name": stage_name,
        }
        if access_log_settings is not None:
            self._values["access_log_settings"] = access_log_settings
        if auto_deploy is not None:
            self._values["auto_deploy"] = auto_deploy
        if client_certificate_id is not None:
            self._values["client_certificate_id"] = client_certificate_id
        if default_route_settings is not None:
            self._values["default_route_settings"] = default_route_settings
        if deployment_id is not None:
            self._values["deployment_id"] = deployment_id
        if description is not None:
            self._values["description"] = description
        if route_settings is not None:
            self._values["route_settings"] = route_settings
        if stage_variables is not None:
            self._values["stage_variables"] = stage_variables
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def api_id(self) -> builtins.str:
        """(deprecated) ``AWS::ApiGatewayV2::Stage.ApiId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-apiid
        :stability: deprecated
        """
        result = self._values.get("api_id")
        assert result is not None, "Required property 'api_id' is missing"
        return result

    @builtins.property
    def stage_name(self) -> builtins.str:
        """(deprecated) ``AWS::ApiGatewayV2::Stage.StageName``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-stagename
        :stability: deprecated
        """
        result = self._values.get("stage_name")
        assert result is not None, "Required property 'stage_name' is missing"
        return result

    @builtins.property
    def access_log_settings(
        self,
    ) -> typing.Optional[typing.Union[CfnStageV2.AccessLogSettingsProperty, _IResolvable_a771d0ef]]:
        """(deprecated) ``AWS::ApiGatewayV2::Stage.AccessLogSettings``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-accesslogsettings
        :stability: deprecated
        """
        result = self._values.get("access_log_settings")
        return result

    @builtins.property
    def auto_deploy(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
        """(deprecated) ``AWS::ApiGatewayV2::Stage.AutoDeploy``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-autodeploy
        :stability: deprecated
        """
        result = self._values.get("auto_deploy")
        return result

    @builtins.property
    def client_certificate_id(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Stage.ClientCertificateId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-clientcertificateid
        :stability: deprecated
        """
        result = self._values.get("client_certificate_id")
        return result

    @builtins.property
    def default_route_settings(
        self,
    ) -> typing.Optional[typing.Union[CfnStageV2.RouteSettingsProperty, _IResolvable_a771d0ef]]:
        """(deprecated) ``AWS::ApiGatewayV2::Stage.DefaultRouteSettings``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-defaultroutesettings
        :stability: deprecated
        """
        result = self._values.get("default_route_settings")
        return result

    @builtins.property
    def deployment_id(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Stage.DeploymentId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-deploymentid
        :stability: deprecated
        """
        result = self._values.get("deployment_id")
        return result

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        """(deprecated) ``AWS::ApiGatewayV2::Stage.Description``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-description
        :stability: deprecated
        """
        result = self._values.get("description")
        return result

    @builtins.property
    def route_settings(self) -> typing.Any:
        """(deprecated) ``AWS::ApiGatewayV2::Stage.RouteSettings``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-routesettings
        :stability: deprecated
        """
        result = self._values.get("route_settings")
        return result

    @builtins.property
    def stage_variables(self) -> typing.Any:
        """(deprecated) ``AWS::ApiGatewayV2::Stage.StageVariables``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-stagevariables
        :stability: deprecated
        """
        result = self._values.get("stage_variables")
        return result

    @builtins.property
    def tags(self) -> typing.Any:
        """(deprecated) ``AWS::ApiGatewayV2::Stage.Tags``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-tags
        :stability: deprecated
        """
        result = self._values.get("tags")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnStageV2Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_82c04a63)
class CfnUsagePlan(
    _CfnResource_e0a482dc,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_apigateway.CfnUsagePlan",
):
    """A CloudFormation ``AWS::ApiGateway::UsagePlan``.

    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html
    :cloudformationResource: AWS::ApiGateway::UsagePlan
    """

    def __init__(
        self,
        scope: _Construct_e78e779f,
        id: builtins.str,
        *,
        api_stages: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnUsagePlan.ApiStageProperty", _IResolvable_a771d0ef]]]] = None,
        description: typing.Optional[builtins.str] = None,
        quota: typing.Optional[typing.Union["CfnUsagePlan.QuotaSettingsProperty", _IResolvable_a771d0ef]] = None,
        tags: typing.Optional[typing.List[_CfnTag_95fbdc29]] = None,
        throttle: typing.Optional[typing.Union["CfnUsagePlan.ThrottleSettingsProperty", _IResolvable_a771d0ef]] = None,
        usage_plan_name: typing.Optional[builtins.str] = None,
    ) -> None:
        """Create a new ``AWS::ApiGateway::UsagePlan``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param api_stages: ``AWS::ApiGateway::UsagePlan.ApiStages``.
        :param description: ``AWS::ApiGateway::UsagePlan.Description``.
        :param quota: ``AWS::ApiGateway::UsagePlan.Quota``.
        :param tags: ``AWS::ApiGateway::UsagePlan.Tags``.
        :param throttle: ``AWS::ApiGateway::UsagePlan.Throttle``.
        :param usage_plan_name: ``AWS::ApiGateway::UsagePlan.UsagePlanName``.
        """
        props = CfnUsagePlanProps(
            api_stages=api_stages,
            description=description,
            quota=quota,
            tags=tags,
            throttle=throttle,
            usage_plan_name=usage_plan_name,
        )

        jsii.create(CfnUsagePlan, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_1cd1894e) -> None:
        """(experimental) Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_0b7ab120:
        """``AWS::ApiGateway::UsagePlan.Tags``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html#cfn-apigateway-usageplan-tags
        """
        return jsii.get(self, "tags")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiStages")
    def api_stages(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnUsagePlan.ApiStageProperty", _IResolvable_a771d0ef]]]]:
        """``AWS::ApiGateway::UsagePlan.ApiStages``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html#cfn-apigateway-usageplan-apistages
        """
        return jsii.get(self, "apiStages")

    @api_stages.setter # type: ignore
    def api_stages(
        self,
        value: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnUsagePlan.ApiStageProperty", _IResolvable_a771d0ef]]]],
    ) -> None:
        jsii.set(self, "apiStages", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::UsagePlan.Description``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html#cfn-apigateway-usageplan-description
        """
        return jsii.get(self, "description")

    @description.setter # type: ignore
    def description(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "description", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="quota")
    def quota(
        self,
    ) -> typing.Optional[typing.Union["CfnUsagePlan.QuotaSettingsProperty", _IResolvable_a771d0ef]]:
        """``AWS::ApiGateway::UsagePlan.Quota``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html#cfn-apigateway-usageplan-quota
        """
        return jsii.get(self, "quota")

    @quota.setter # type: ignore
    def quota(
        self,
        value: typing.Optional[typing.Union["CfnUsagePlan.QuotaSettingsProperty", _IResolvable_a771d0ef]],
    ) -> None:
        jsii.set(self, "quota", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="throttle")
    def throttle(
        self,
    ) -> typing.Optional[typing.Union["CfnUsagePlan.ThrottleSettingsProperty", _IResolvable_a771d0ef]]:
        """``AWS::ApiGateway::UsagePlan.Throttle``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html#cfn-apigateway-usageplan-throttle
        """
        return jsii.get(self, "throttle")

    @throttle.setter # type: ignore
    def throttle(
        self,
        value: typing.Optional[typing.Union["CfnUsagePlan.ThrottleSettingsProperty", _IResolvable_a771d0ef]],
    ) -> None:
        jsii.set(self, "throttle", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="usagePlanName")
    def usage_plan_name(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::UsagePlan.UsagePlanName``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html#cfn-apigateway-usageplan-usageplanname
        """
        return jsii.get(self, "usagePlanName")

    @usage_plan_name.setter # type: ignore
    def usage_plan_name(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "usagePlanName", value)

    @jsii.data_type(
        jsii_type="monocdk.aws_apigateway.CfnUsagePlan.ApiStageProperty",
        jsii_struct_bases=[],
        name_mapping={"api_id": "apiId", "stage": "stage", "throttle": "throttle"},
    )
    class ApiStageProperty:
        def __init__(
            self,
            *,
            api_id: typing.Optional[builtins.str] = None,
            stage: typing.Optional[builtins.str] = None,
            throttle: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, typing.Union["CfnUsagePlan.ThrottleSettingsProperty", _IResolvable_a771d0ef]]]] = None,
        ) -> None:
            """
            :param api_id: ``CfnUsagePlan.ApiStageProperty.ApiId``.
            :param stage: ``CfnUsagePlan.ApiStageProperty.Stage``.
            :param throttle: ``CfnUsagePlan.ApiStageProperty.Throttle``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-apistage.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if api_id is not None:
                self._values["api_id"] = api_id
            if stage is not None:
                self._values["stage"] = stage
            if throttle is not None:
                self._values["throttle"] = throttle

        @builtins.property
        def api_id(self) -> typing.Optional[builtins.str]:
            """``CfnUsagePlan.ApiStageProperty.ApiId``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-apistage.html#cfn-apigateway-usageplan-apistage-apiid
            """
            result = self._values.get("api_id")
            return result

        @builtins.property
        def stage(self) -> typing.Optional[builtins.str]:
            """``CfnUsagePlan.ApiStageProperty.Stage``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-apistage.html#cfn-apigateway-usageplan-apistage-stage
            """
            result = self._values.get("stage")
            return result

        @builtins.property
        def throttle(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, typing.Union["CfnUsagePlan.ThrottleSettingsProperty", _IResolvable_a771d0ef]]]]:
            """``CfnUsagePlan.ApiStageProperty.Throttle``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-apistage.html#cfn-apigateway-usageplan-apistage-throttle
            """
            result = self._values.get("throttle")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ApiStageProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_apigateway.CfnUsagePlan.QuotaSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={"limit": "limit", "offset": "offset", "period": "period"},
    )
    class QuotaSettingsProperty:
        def __init__(
            self,
            *,
            limit: typing.Optional[jsii.Number] = None,
            offset: typing.Optional[jsii.Number] = None,
            period: typing.Optional[builtins.str] = None,
        ) -> None:
            """
            :param limit: ``CfnUsagePlan.QuotaSettingsProperty.Limit``.
            :param offset: ``CfnUsagePlan.QuotaSettingsProperty.Offset``.
            :param period: ``CfnUsagePlan.QuotaSettingsProperty.Period``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-quotasettings.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if limit is not None:
                self._values["limit"] = limit
            if offset is not None:
                self._values["offset"] = offset
            if period is not None:
                self._values["period"] = period

        @builtins.property
        def limit(self) -> typing.Optional[jsii.Number]:
            """``CfnUsagePlan.QuotaSettingsProperty.Limit``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-quotasettings.html#cfn-apigateway-usageplan-quotasettings-limit
            """
            result = self._values.get("limit")
            return result

        @builtins.property
        def offset(self) -> typing.Optional[jsii.Number]:
            """``CfnUsagePlan.QuotaSettingsProperty.Offset``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-quotasettings.html#cfn-apigateway-usageplan-quotasettings-offset
            """
            result = self._values.get("offset")
            return result

        @builtins.property
        def period(self) -> typing.Optional[builtins.str]:
            """``CfnUsagePlan.QuotaSettingsProperty.Period``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-quotasettings.html#cfn-apigateway-usageplan-quotasettings-period
            """
            result = self._values.get("period")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "QuotaSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_apigateway.CfnUsagePlan.ThrottleSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={"burst_limit": "burstLimit", "rate_limit": "rateLimit"},
    )
    class ThrottleSettingsProperty:
        def __init__(
            self,
            *,
            burst_limit: typing.Optional[jsii.Number] = None,
            rate_limit: typing.Optional[jsii.Number] = None,
        ) -> None:
            """
            :param burst_limit: ``CfnUsagePlan.ThrottleSettingsProperty.BurstLimit``.
            :param rate_limit: ``CfnUsagePlan.ThrottleSettingsProperty.RateLimit``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-throttlesettings.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if burst_limit is not None:
                self._values["burst_limit"] = burst_limit
            if rate_limit is not None:
                self._values["rate_limit"] = rate_limit

        @builtins.property
        def burst_limit(self) -> typing.Optional[jsii.Number]:
            """``CfnUsagePlan.ThrottleSettingsProperty.BurstLimit``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-throttlesettings.html#cfn-apigateway-usageplan-throttlesettings-burstlimit
            """
            result = self._values.get("burst_limit")
            return result

        @builtins.property
        def rate_limit(self) -> typing.Optional[jsii.Number]:
            """``CfnUsagePlan.ThrottleSettingsProperty.RateLimit``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-throttlesettings.html#cfn-apigateway-usageplan-throttlesettings-ratelimit
            """
            result = self._values.get("rate_limit")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ThrottleSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.implements(_IInspectable_82c04a63)
class CfnUsagePlanKey(
    _CfnResource_e0a482dc,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_apigateway.CfnUsagePlanKey",
):
    """A CloudFormation ``AWS::ApiGateway::UsagePlanKey``.

    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplankey.html
    :cloudformationResource: AWS::ApiGateway::UsagePlanKey
    """

    def __init__(
        self,
        scope: _Construct_e78e779f,
        id: builtins.str,
        *,
        key_id: builtins.str,
        key_type: builtins.str,
        usage_plan_id: builtins.str,
    ) -> None:
        """Create a new ``AWS::ApiGateway::UsagePlanKey``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param key_id: ``AWS::ApiGateway::UsagePlanKey.KeyId``.
        :param key_type: ``AWS::ApiGateway::UsagePlanKey.KeyType``.
        :param usage_plan_id: ``AWS::ApiGateway::UsagePlanKey.UsagePlanId``.
        """
        props = CfnUsagePlanKeyProps(
            key_id=key_id, key_type=key_type, usage_plan_id=usage_plan_id
        )

        jsii.create(CfnUsagePlanKey, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_1cd1894e) -> None:
        """(experimental) Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="keyId")
    def key_id(self) -> builtins.str:
        """``AWS::ApiGateway::UsagePlanKey.KeyId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplankey.html#cfn-apigateway-usageplankey-keyid
        """
        return jsii.get(self, "keyId")

    @key_id.setter # type: ignore
    def key_id(self, value: builtins.str) -> None:
        jsii.set(self, "keyId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="keyType")
    def key_type(self) -> builtins.str:
        """``AWS::ApiGateway::UsagePlanKey.KeyType``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplankey.html#cfn-apigateway-usageplankey-keytype
        """
        return jsii.get(self, "keyType")

    @key_type.setter # type: ignore
    def key_type(self, value: builtins.str) -> None:
        jsii.set(self, "keyType", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="usagePlanId")
    def usage_plan_id(self) -> builtins.str:
        """``AWS::ApiGateway::UsagePlanKey.UsagePlanId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplankey.html#cfn-apigateway-usageplankey-usageplanid
        """
        return jsii.get(self, "usagePlanId")

    @usage_plan_id.setter # type: ignore
    def usage_plan_id(self, value: builtins.str) -> None:
        jsii.set(self, "usagePlanId", value)


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.CfnUsagePlanKeyProps",
    jsii_struct_bases=[],
    name_mapping={
        "key_id": "keyId",
        "key_type": "keyType",
        "usage_plan_id": "usagePlanId",
    },
)
class CfnUsagePlanKeyProps:
    def __init__(
        self,
        *,
        key_id: builtins.str,
        key_type: builtins.str,
        usage_plan_id: builtins.str,
    ) -> None:
        """Properties for defining a ``AWS::ApiGateway::UsagePlanKey``.

        :param key_id: ``AWS::ApiGateway::UsagePlanKey.KeyId``.
        :param key_type: ``AWS::ApiGateway::UsagePlanKey.KeyType``.
        :param usage_plan_id: ``AWS::ApiGateway::UsagePlanKey.UsagePlanId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplankey.html
        """
        self._values: typing.Dict[str, typing.Any] = {
            "key_id": key_id,
            "key_type": key_type,
            "usage_plan_id": usage_plan_id,
        }

    @builtins.property
    def key_id(self) -> builtins.str:
        """``AWS::ApiGateway::UsagePlanKey.KeyId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplankey.html#cfn-apigateway-usageplankey-keyid
        """
        result = self._values.get("key_id")
        assert result is not None, "Required property 'key_id' is missing"
        return result

    @builtins.property
    def key_type(self) -> builtins.str:
        """``AWS::ApiGateway::UsagePlanKey.KeyType``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplankey.html#cfn-apigateway-usageplankey-keytype
        """
        result = self._values.get("key_type")
        assert result is not None, "Required property 'key_type' is missing"
        return result

    @builtins.property
    def usage_plan_id(self) -> builtins.str:
        """``AWS::ApiGateway::UsagePlanKey.UsagePlanId``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplankey.html#cfn-apigateway-usageplankey-usageplanid
        """
        result = self._values.get("usage_plan_id")
        assert result is not None, "Required property 'usage_plan_id' is missing"
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnUsagePlanKeyProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.CfnUsagePlanProps",
    jsii_struct_bases=[],
    name_mapping={
        "api_stages": "apiStages",
        "description": "description",
        "quota": "quota",
        "tags": "tags",
        "throttle": "throttle",
        "usage_plan_name": "usagePlanName",
    },
)
class CfnUsagePlanProps:
    def __init__(
        self,
        *,
        api_stages: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union[CfnUsagePlan.ApiStageProperty, _IResolvable_a771d0ef]]]] = None,
        description: typing.Optional[builtins.str] = None,
        quota: typing.Optional[typing.Union[CfnUsagePlan.QuotaSettingsProperty, _IResolvable_a771d0ef]] = None,
        tags: typing.Optional[typing.List[_CfnTag_95fbdc29]] = None,
        throttle: typing.Optional[typing.Union[CfnUsagePlan.ThrottleSettingsProperty, _IResolvable_a771d0ef]] = None,
        usage_plan_name: typing.Optional[builtins.str] = None,
    ) -> None:
        """Properties for defining a ``AWS::ApiGateway::UsagePlan``.

        :param api_stages: ``AWS::ApiGateway::UsagePlan.ApiStages``.
        :param description: ``AWS::ApiGateway::UsagePlan.Description``.
        :param quota: ``AWS::ApiGateway::UsagePlan.Quota``.
        :param tags: ``AWS::ApiGateway::UsagePlan.Tags``.
        :param throttle: ``AWS::ApiGateway::UsagePlan.Throttle``.
        :param usage_plan_name: ``AWS::ApiGateway::UsagePlan.UsagePlanName``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if api_stages is not None:
            self._values["api_stages"] = api_stages
        if description is not None:
            self._values["description"] = description
        if quota is not None:
            self._values["quota"] = quota
        if tags is not None:
            self._values["tags"] = tags
        if throttle is not None:
            self._values["throttle"] = throttle
        if usage_plan_name is not None:
            self._values["usage_plan_name"] = usage_plan_name

    @builtins.property
    def api_stages(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union[CfnUsagePlan.ApiStageProperty, _IResolvable_a771d0ef]]]]:
        """``AWS::ApiGateway::UsagePlan.ApiStages``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html#cfn-apigateway-usageplan-apistages
        """
        result = self._values.get("api_stages")
        return result

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::UsagePlan.Description``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html#cfn-apigateway-usageplan-description
        """
        result = self._values.get("description")
        return result

    @builtins.property
    def quota(
        self,
    ) -> typing.Optional[typing.Union[CfnUsagePlan.QuotaSettingsProperty, _IResolvable_a771d0ef]]:
        """``AWS::ApiGateway::UsagePlan.Quota``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html#cfn-apigateway-usageplan-quota
        """
        result = self._values.get("quota")
        return result

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_95fbdc29]]:
        """``AWS::ApiGateway::UsagePlan.Tags``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html#cfn-apigateway-usageplan-tags
        """
        result = self._values.get("tags")
        return result

    @builtins.property
    def throttle(
        self,
    ) -> typing.Optional[typing.Union[CfnUsagePlan.ThrottleSettingsProperty, _IResolvable_a771d0ef]]:
        """``AWS::ApiGateway::UsagePlan.Throttle``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html#cfn-apigateway-usageplan-throttle
        """
        result = self._values.get("throttle")
        return result

    @builtins.property
    def usage_plan_name(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::UsagePlan.UsagePlanName``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html#cfn-apigateway-usageplan-usageplanname
        """
        result = self._values.get("usage_plan_name")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnUsagePlanProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_82c04a63)
class CfnVpcLink(
    _CfnResource_e0a482dc,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_apigateway.CfnVpcLink",
):
    """A CloudFormation ``AWS::ApiGateway::VpcLink``.

    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-vpclink.html
    :cloudformationResource: AWS::ApiGateway::VpcLink
    """

    def __init__(
        self,
        scope: _Construct_e78e779f,
        id: builtins.str,
        *,
        name: builtins.str,
        target_arns: typing.List[builtins.str],
        description: typing.Optional[builtins.str] = None,
    ) -> None:
        """Create a new ``AWS::ApiGateway::VpcLink``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param name: ``AWS::ApiGateway::VpcLink.Name``.
        :param target_arns: ``AWS::ApiGateway::VpcLink.TargetArns``.
        :param description: ``AWS::ApiGateway::VpcLink.Description``.
        """
        props = CfnVpcLinkProps(
            name=name, target_arns=target_arns, description=description
        )

        jsii.create(CfnVpcLink, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_1cd1894e) -> None:
        """(experimental) Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        """``AWS::ApiGateway::VpcLink.Name``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-vpclink.html#cfn-apigateway-vpclink-name
        """
        return jsii.get(self, "name")

    @name.setter # type: ignore
    def name(self, value: builtins.str) -> None:
        jsii.set(self, "name", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="targetArns")
    def target_arns(self) -> typing.List[builtins.str]:
        """``AWS::ApiGateway::VpcLink.TargetArns``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-vpclink.html#cfn-apigateway-vpclink-targetarns
        """
        return jsii.get(self, "targetArns")

    @target_arns.setter # type: ignore
    def target_arns(self, value: typing.List[builtins.str]) -> None:
        jsii.set(self, "targetArns", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::VpcLink.Description``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-vpclink.html#cfn-apigateway-vpclink-description
        """
        return jsii.get(self, "description")

    @description.setter # type: ignore
    def description(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "description", value)


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.CfnVpcLinkProps",
    jsii_struct_bases=[],
    name_mapping={
        "name": "name",
        "target_arns": "targetArns",
        "description": "description",
    },
)
class CfnVpcLinkProps:
    def __init__(
        self,
        *,
        name: builtins.str,
        target_arns: typing.List[builtins.str],
        description: typing.Optional[builtins.str] = None,
    ) -> None:
        """Properties for defining a ``AWS::ApiGateway::VpcLink``.

        :param name: ``AWS::ApiGateway::VpcLink.Name``.
        :param target_arns: ``AWS::ApiGateway::VpcLink.TargetArns``.
        :param description: ``AWS::ApiGateway::VpcLink.Description``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-vpclink.html
        """
        self._values: typing.Dict[str, typing.Any] = {
            "name": name,
            "target_arns": target_arns,
        }
        if description is not None:
            self._values["description"] = description

    @builtins.property
    def name(self) -> builtins.str:
        """``AWS::ApiGateway::VpcLink.Name``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-vpclink.html#cfn-apigateway-vpclink-name
        """
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return result

    @builtins.property
    def target_arns(self) -> typing.List[builtins.str]:
        """``AWS::ApiGateway::VpcLink.TargetArns``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-vpclink.html#cfn-apigateway-vpclink-targetarns
        """
        result = self._values.get("target_arns")
        assert result is not None, "Required property 'target_arns' is missing"
        return result

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        """``AWS::ApiGateway::VpcLink.Description``.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-vpclink.html#cfn-apigateway-vpclink-description
        """
        result = self._values.get("description")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnVpcLinkProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="monocdk.aws_apigateway.ConnectionType")
class ConnectionType(enum.Enum):
    """
    :stability: experimental
    """

    INTERNET = "INTERNET"
    """(experimental) For connections through the public routable internet.

    :stability: experimental
    """
    VPC_LINK = "VPC_LINK"
    """(experimental) For private connections between API Gateway and a network load balancer in a VPC.

    :stability: experimental
    """


@jsii.enum(jsii_type="monocdk.aws_apigateway.ContentHandling")
class ContentHandling(enum.Enum):
    """
    :stability: experimental
    """

    CONVERT_TO_BINARY = "CONVERT_TO_BINARY"
    """(experimental) Converts a request payload from a base64-encoded string to a binary blob.

    :stability: experimental
    """
    CONVERT_TO_TEXT = "CONVERT_TO_TEXT"
    """(experimental) Converts a request payload from a binary blob to a base64-encoded string.

    :stability: experimental
    """


class Cors(metaclass=jsii.JSIIMeta, jsii_type="monocdk.aws_apigateway.Cors"):
    """
    :stability: experimental
    """

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="ALL_METHODS")
    def ALL_METHODS(cls) -> typing.List[builtins.str]:
        """(experimental) All HTTP methods.

        :stability: experimental
        """
        return jsii.sget(cls, "ALL_METHODS")

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="ALL_ORIGINS")
    def ALL_ORIGINS(cls) -> typing.List[builtins.str]:
        """(experimental) All origins.

        :stability: experimental
        """
        return jsii.sget(cls, "ALL_ORIGINS")

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="DEFAULT_HEADERS")
    def DEFAULT_HEADERS(cls) -> typing.List[builtins.str]:
        """(experimental) The set of default headers allowed for CORS and useful for API Gateway.

        :stability: experimental
        """
        return jsii.sget(cls, "DEFAULT_HEADERS")


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.CorsOptions",
    jsii_struct_bases=[],
    name_mapping={
        "allow_origins": "allowOrigins",
        "allow_credentials": "allowCredentials",
        "allow_headers": "allowHeaders",
        "allow_methods": "allowMethods",
        "disable_cache": "disableCache",
        "expose_headers": "exposeHeaders",
        "max_age": "maxAge",
        "status_code": "statusCode",
    },
)
class CorsOptions:
    def __init__(
        self,
        *,
        allow_origins: typing.List[builtins.str],
        allow_credentials: typing.Optional[builtins.bool] = None,
        allow_headers: typing.Optional[typing.List[builtins.str]] = None,
        allow_methods: typing.Optional[typing.List[builtins.str]] = None,
        disable_cache: typing.Optional[builtins.bool] = None,
        expose_headers: typing.Optional[typing.List[builtins.str]] = None,
        max_age: typing.Optional[_Duration_070aa057] = None,
        status_code: typing.Optional[jsii.Number] = None,
    ) -> None:
        """
        :param allow_origins: (experimental) Specifies the list of origins that are allowed to make requests to this resource. If you wish to allow all origins, specify ``Cors.ALL_ORIGINS`` or ``[ * ]``. Responses will include the ``Access-Control-Allow-Origin`` response header. If ``Cors.ALL_ORIGINS`` is specified, the ``Vary: Origin`` response header will also be included.
        :param allow_credentials: (experimental) The Access-Control-Allow-Credentials response header tells browsers whether to expose the response to frontend JavaScript code when the request's credentials mode (Request.credentials) is "include". When a request's credentials mode (Request.credentials) is "include", browsers will only expose the response to frontend JavaScript code if the Access-Control-Allow-Credentials value is true. Credentials are cookies, authorization headers or TLS client certificates. Default: false
        :param allow_headers: (experimental) The Access-Control-Allow-Headers response header is used in response to a preflight request which includes the Access-Control-Request-Headers to indicate which HTTP headers can be used during the actual request. Default: Cors.DEFAULT_HEADERS
        :param allow_methods: (experimental) The Access-Control-Allow-Methods response header specifies the method or methods allowed when accessing the resource in response to a preflight request. If ``ANY`` is specified, it will be expanded to ``Cors.ALL_METHODS``. Default: Cors.ALL_METHODS
        :param disable_cache: (experimental) Sets Access-Control-Max-Age to -1, which means that caching is disabled. This option cannot be used with ``maxAge``. Default: - cache is enabled
        :param expose_headers: (experimental) The Access-Control-Expose-Headers response header indicates which headers can be exposed as part of the response by listing their names. If you want clients to be able to access other headers, you have to list them using the Access-Control-Expose-Headers header. Default: - only the 6 CORS-safelisted response headers are exposed: Cache-Control, Content-Language, Content-Type, Expires, Last-Modified, Pragma
        :param max_age: (experimental) The Access-Control-Max-Age response header indicates how long the results of a preflight request (that is the information contained in the Access-Control-Allow-Methods and Access-Control-Allow-Headers headers) can be cached. To disable caching altogther use ``disableCache: true``. Default: - browser-specific (see reference)
        :param status_code: (experimental) Specifies the response status code returned from the OPTIONS method. Default: 204

        :stability: experimental
        """
        self._values: typing.Dict[str, typing.Any] = {
            "allow_origins": allow_origins,
        }
        if allow_credentials is not None:
            self._values["allow_credentials"] = allow_credentials
        if allow_headers is not None:
            self._values["allow_headers"] = allow_headers
        if allow_methods is not None:
            self._values["allow_methods"] = allow_methods
        if disable_cache is not None:
            self._values["disable_cache"] = disable_cache
        if expose_headers is not None:
            self._values["expose_headers"] = expose_headers
        if max_age is not None:
            self._values["max_age"] = max_age
        if status_code is not None:
            self._values["status_code"] = status_code

    @builtins.property
    def allow_origins(self) -> typing.List[builtins.str]:
        """(experimental) Specifies the list of origins that are allowed to make requests to this resource.

        If you wish to allow all origins, specify ``Cors.ALL_ORIGINS`` or
        ``[ * ]``.

        Responses will include the ``Access-Control-Allow-Origin`` response header.
        If ``Cors.ALL_ORIGINS`` is specified, the ``Vary: Origin`` response header will
        also be included.

        :see: https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Origin
        :stability: experimental
        """
        result = self._values.get("allow_origins")
        assert result is not None, "Required property 'allow_origins' is missing"
        return result

    @builtins.property
    def allow_credentials(self) -> typing.Optional[builtins.bool]:
        """(experimental) The Access-Control-Allow-Credentials response header tells browsers whether to expose the response to frontend JavaScript code when the request's credentials mode (Request.credentials) is "include".

        When a request's credentials mode (Request.credentials) is "include",
        browsers will only expose the response to frontend JavaScript code if the
        Access-Control-Allow-Credentials value is true.

        Credentials are cookies, authorization headers or TLS client certificates.

        :default: false

        :see: https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Credentials
        :stability: experimental
        """
        result = self._values.get("allow_credentials")
        return result

    @builtins.property
    def allow_headers(self) -> typing.Optional[typing.List[builtins.str]]:
        """(experimental) The Access-Control-Allow-Headers response header is used in response to a preflight request which includes the Access-Control-Request-Headers to indicate which HTTP headers can be used during the actual request.

        :default: Cors.DEFAULT_HEADERS

        :see: https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Headers
        :stability: experimental
        """
        result = self._values.get("allow_headers")
        return result

    @builtins.property
    def allow_methods(self) -> typing.Optional[typing.List[builtins.str]]:
        """(experimental) The Access-Control-Allow-Methods response header specifies the method or methods allowed when accessing the resource in response to a preflight request.

        If ``ANY`` is specified, it will be expanded to ``Cors.ALL_METHODS``.

        :default: Cors.ALL_METHODS

        :see: https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Methods
        :stability: experimental
        """
        result = self._values.get("allow_methods")
        return result

    @builtins.property
    def disable_cache(self) -> typing.Optional[builtins.bool]:
        """(experimental) Sets Access-Control-Max-Age to -1, which means that caching is disabled.

        This option cannot be used with ``maxAge``.

        :default: - cache is enabled

        :stability: experimental
        """
        result = self._values.get("disable_cache")
        return result

    @builtins.property
    def expose_headers(self) -> typing.Optional[typing.List[builtins.str]]:
        """(experimental) The Access-Control-Expose-Headers response header indicates which headers can be exposed as part of the response by listing their names.

        If you want clients to be able to access other headers, you have to list
        them using the Access-Control-Expose-Headers header.

        :default:

        - only the 6 CORS-safelisted response headers are exposed:
        Cache-Control, Content-Language, Content-Type, Expires, Last-Modified,
        Pragma

        :see: https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Expose-Headers
        :stability: experimental
        """
        result = self._values.get("expose_headers")
        return result

    @builtins.property
    def max_age(self) -> typing.Optional[_Duration_070aa057]:
        """(experimental) The Access-Control-Max-Age response header indicates how long the results of a preflight request (that is the information contained in the Access-Control-Allow-Methods and Access-Control-Allow-Headers headers) can be cached.

        To disable caching altogther use ``disableCache: true``.

        :default: - browser-specific (see reference)

        :see: https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Max-Age
        :stability: experimental
        """
        result = self._values.get("max_age")
        return result

    @builtins.property
    def status_code(self) -> typing.Optional[jsii.Number]:
        """(experimental) Specifies the response status code returned from the OPTIONS method.

        :default: 204

        :stability: experimental
        """
        result = self._values.get("status_code")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CorsOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class Deployment(
    _Resource_abff4495,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_apigateway.Deployment",
):
    """(experimental) A Deployment of a REST API.

    An immutable representation of a RestApi resource that can be called by users
    using Stages. A deployment must be associated with a Stage for it to be
    callable over the Internet.

    Normally, you don't need to define deployments manually. The RestApi
    construct manages a Deployment resource that represents the latest model. It
    can be accessed through ``restApi.latestDeployment`` (unless ``deploy: false`` is
    set when defining the ``RestApi``).

    If you manually define this resource, you will need to know that since
    deployments are immutable, as long as the resource's logical ID doesn't
    change, the deployment will represent the snapshot in time in which the
    resource was created. This means that if you modify the RestApi model (i.e.
    add methods or resources), these changes will not be reflected unless a new
    deployment resource is created.

    To achieve this behavior, the method ``addToLogicalId(data)`` can be used to
    augment the logical ID generated for the deployment resource such that it
    will include arbitrary data. This is done automatically for the
    ``restApi.latestDeployment`` deployment.

    Furthermore, since a deployment does not reference any of the REST API
    resources and methods, CloudFormation will likely provision it before these
    resources are created, which means that it will represent a "half-baked"
    model. Use the ``node.addDependency(dep)`` method to circumvent that. This is done
    automatically for the ``restApi.latestDeployment`` deployment.

    :stability: experimental
    """

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        api: "IRestApi",
        description: typing.Optional[builtins.str] = None,
        retain_deployments: typing.Optional[builtins.bool] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param api: (experimental) The Rest API to deploy.
        :param description: (experimental) A description of the purpose of the API Gateway deployment. Default: - No description.
        :param retain_deployments: (experimental) When an API Gateway model is updated, a new deployment will automatically be created. If this is true, the old API Gateway Deployment resource will not be deleted. This will allow manually reverting back to a previous deployment in case for example Default: false

        :stability: experimental
        """
        props = DeploymentProps(
            api=api, description=description, retain_deployments=retain_deployments
        )

        jsii.create(Deployment, self, [scope, id, props])

    @jsii.member(jsii_name="addToLogicalId")
    def add_to_logical_id(self, data: typing.Any) -> None:
        """(experimental) Adds a component to the hash that determines this Deployment resource's logical ID.

        This should be called by constructs of the API Gateway model that want to
        invalidate the deployment when their settings change. The component will
        be resolve()ed during synthesis so tokens are welcome.

        :param data: -

        :stability: experimental
        """
        return jsii.invoke(self, "addToLogicalId", [data])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="api")
    def api(self) -> "IRestApi":
        """
        :stability: experimental
        """
        return jsii.get(self, "api")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="deploymentId")
    def deployment_id(self) -> builtins.str:
        """
        :stability: experimental
        :attribute: true
        """
        return jsii.get(self, "deploymentId")


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.DeploymentProps",
    jsii_struct_bases=[],
    name_mapping={
        "api": "api",
        "description": "description",
        "retain_deployments": "retainDeployments",
    },
)
class DeploymentProps:
    def __init__(
        self,
        *,
        api: "IRestApi",
        description: typing.Optional[builtins.str] = None,
        retain_deployments: typing.Optional[builtins.bool] = None,
    ) -> None:
        """
        :param api: (experimental) The Rest API to deploy.
        :param description: (experimental) A description of the purpose of the API Gateway deployment. Default: - No description.
        :param retain_deployments: (experimental) When an API Gateway model is updated, a new deployment will automatically be created. If this is true, the old API Gateway Deployment resource will not be deleted. This will allow manually reverting back to a previous deployment in case for example Default: false

        :stability: experimental
        """
        self._values: typing.Dict[str, typing.Any] = {
            "api": api,
        }
        if description is not None:
            self._values["description"] = description
        if retain_deployments is not None:
            self._values["retain_deployments"] = retain_deployments

    @builtins.property
    def api(self) -> "IRestApi":
        """(experimental) The Rest API to deploy.

        :stability: experimental
        """
        result = self._values.get("api")
        assert result is not None, "Required property 'api' is missing"
        return result

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        """(experimental) A description of the purpose of the API Gateway deployment.

        :default: - No description.

        :stability: experimental
        """
        result = self._values.get("description")
        return result

    @builtins.property
    def retain_deployments(self) -> typing.Optional[builtins.bool]:
        """(experimental) When an API Gateway model is updated, a new deployment will automatically be created.

        If this is true, the old API Gateway Deployment resource will not be deleted.
        This will allow manually reverting back to a previous deployment in case for example

        :default: false

        :stability: experimental
        """
        result = self._values.get("retain_deployments")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DeploymentProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.DomainNameAttributes",
    jsii_struct_bases=[],
    name_mapping={
        "domain_name": "domainName",
        "domain_name_alias_hosted_zone_id": "domainNameAliasHostedZoneId",
        "domain_name_alias_target": "domainNameAliasTarget",
    },
)
class DomainNameAttributes:
    def __init__(
        self,
        *,
        domain_name: builtins.str,
        domain_name_alias_hosted_zone_id: builtins.str,
        domain_name_alias_target: builtins.str,
    ) -> None:
        """
        :param domain_name: (experimental) The domain name (e.g. ``example.com``).
        :param domain_name_alias_hosted_zone_id: (experimental) Thje Route53 hosted zone ID to use in order to connect a record set to this domain through an alias.
        :param domain_name_alias_target: (experimental) The Route53 alias target to use in order to connect a record set to this domain through an alias.

        :stability: experimental
        """
        self._values: typing.Dict[str, typing.Any] = {
            "domain_name": domain_name,
            "domain_name_alias_hosted_zone_id": domain_name_alias_hosted_zone_id,
            "domain_name_alias_target": domain_name_alias_target,
        }

    @builtins.property
    def domain_name(self) -> builtins.str:
        """(experimental) The domain name (e.g. ``example.com``).

        :stability: experimental
        """
        result = self._values.get("domain_name")
        assert result is not None, "Required property 'domain_name' is missing"
        return result

    @builtins.property
    def domain_name_alias_hosted_zone_id(self) -> builtins.str:
        """(experimental) Thje Route53 hosted zone ID to use in order to connect a record set to this domain through an alias.

        :stability: experimental
        """
        result = self._values.get("domain_name_alias_hosted_zone_id")
        assert result is not None, "Required property 'domain_name_alias_hosted_zone_id' is missing"
        return result

    @builtins.property
    def domain_name_alias_target(self) -> builtins.str:
        """(experimental) The Route53 alias target to use in order to connect a record set to this domain through an alias.

        :stability: experimental
        """
        result = self._values.get("domain_name_alias_target")
        assert result is not None, "Required property 'domain_name_alias_target' is missing"
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DomainNameAttributes(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.DomainNameOptions",
    jsii_struct_bases=[],
    name_mapping={
        "certificate": "certificate",
        "domain_name": "domainName",
        "endpoint_type": "endpointType",
        "mtls": "mtls",
        "security_policy": "securityPolicy",
    },
)
class DomainNameOptions:
    def __init__(
        self,
        *,
        certificate: _ICertificate_c7bbdc16,
        domain_name: builtins.str,
        endpoint_type: typing.Optional["EndpointType"] = None,
        mtls: typing.Optional["MTLSConfig"] = None,
        security_policy: typing.Optional["SecurityPolicy"] = None,
    ) -> None:
        """
        :param certificate: (experimental) The reference to an AWS-managed certificate for use by the edge-optimized endpoint for the domain name. For "EDGE" domain names, the certificate needs to be in the US East (N. Virginia) region.
        :param domain_name: (experimental) The custom domain name for your API. Uppercase letters are not supported.
        :param endpoint_type: (experimental) The type of endpoint for this DomainName. Default: REGIONAL
        :param mtls: (experimental) The mutual TLS authentication configuration for a custom domain name. Default: - mTLS is not configured.
        :param security_policy: (experimental) The Transport Layer Security (TLS) version + cipher suite for this domain name. Default: SecurityPolicy.TLS_1_0

        :stability: experimental
        """
        if isinstance(mtls, dict):
            mtls = MTLSConfig(**mtls)
        self._values: typing.Dict[str, typing.Any] = {
            "certificate": certificate,
            "domain_name": domain_name,
        }
        if endpoint_type is not None:
            self._values["endpoint_type"] = endpoint_type
        if mtls is not None:
            self._values["mtls"] = mtls
        if security_policy is not None:
            self._values["security_policy"] = security_policy

    @builtins.property
    def certificate(self) -> _ICertificate_c7bbdc16:
        """(experimental) The reference to an AWS-managed certificate for use by the edge-optimized endpoint for the domain name.

        For "EDGE" domain names, the certificate
        needs to be in the US East (N. Virginia) region.

        :stability: experimental
        """
        result = self._values.get("certificate")
        assert result is not None, "Required property 'certificate' is missing"
        return result

    @builtins.property
    def domain_name(self) -> builtins.str:
        """(experimental) The custom domain name for your API.

        Uppercase letters are not supported.

        :stability: experimental
        """
        result = self._values.get("domain_name")
        assert result is not None, "Required property 'domain_name' is missing"
        return result

    @builtins.property
    def endpoint_type(self) -> typing.Optional["EndpointType"]:
        """(experimental) The type of endpoint for this DomainName.

        :default: REGIONAL

        :stability: experimental
        """
        result = self._values.get("endpoint_type")
        return result

    @builtins.property
    def mtls(self) -> typing.Optional["MTLSConfig"]:
        """(experimental) The mutual TLS authentication configuration for a custom domain name.

        :default: - mTLS is not configured.

        :stability: experimental
        """
        result = self._values.get("mtls")
        return result

    @builtins.property
    def security_policy(self) -> typing.Optional["SecurityPolicy"]:
        """(experimental) The Transport Layer Security (TLS) version + cipher suite for this domain name.

        :default: SecurityPolicy.TLS_1_0

        :see: https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainname.html
        :stability: experimental
        """
        result = self._values.get("security_policy")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DomainNameOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.DomainNameProps",
    jsii_struct_bases=[DomainNameOptions],
    name_mapping={
        "certificate": "certificate",
        "domain_name": "domainName",
        "endpoint_type": "endpointType",
        "mtls": "mtls",
        "security_policy": "securityPolicy",
        "mapping": "mapping",
    },
)
class DomainNameProps(DomainNameOptions):
    def __init__(
        self,
        *,
        certificate: _ICertificate_c7bbdc16,
        domain_name: builtins.str,
        endpoint_type: typing.Optional["EndpointType"] = None,
        mtls: typing.Optional["MTLSConfig"] = None,
        security_policy: typing.Optional["SecurityPolicy"] = None,
        mapping: typing.Optional["IRestApi"] = None,
    ) -> None:
        """
        :param certificate: (experimental) The reference to an AWS-managed certificate for use by the edge-optimized endpoint for the domain name. For "EDGE" domain names, the certificate needs to be in the US East (N. Virginia) region.
        :param domain_name: (experimental) The custom domain name for your API. Uppercase letters are not supported.
        :param endpoint_type: (experimental) The type of endpoint for this DomainName. Default: REGIONAL
        :param mtls: (experimental) The mutual TLS authentication configuration for a custom domain name. Default: - mTLS is not configured.
        :param security_policy: (experimental) The Transport Layer Security (TLS) version + cipher suite for this domain name. Default: SecurityPolicy.TLS_1_0
        :param mapping: (experimental) If specified, all requests to this domain will be mapped to the production deployment of this API. If you wish to map this domain to multiple APIs with different base paths, don't specify this option and use ``addBasePathMapping``. Default: - you will have to call ``addBasePathMapping`` to map this domain to API endpoints.

        :stability: experimental
        """
        if isinstance(mtls, dict):
            mtls = MTLSConfig(**mtls)
        self._values: typing.Dict[str, typing.Any] = {
            "certificate": certificate,
            "domain_name": domain_name,
        }
        if endpoint_type is not None:
            self._values["endpoint_type"] = endpoint_type
        if mtls is not None:
            self._values["mtls"] = mtls
        if security_policy is not None:
            self._values["security_policy"] = security_policy
        if mapping is not None:
            self._values["mapping"] = mapping

    @builtins.property
    def certificate(self) -> _ICertificate_c7bbdc16:
        """(experimental) The reference to an AWS-managed certificate for use by the edge-optimized endpoint for the domain name.

        For "EDGE" domain names, the certificate
        needs to be in the US East (N. Virginia) region.

        :stability: experimental
        """
        result = self._values.get("certificate")
        assert result is not None, "Required property 'certificate' is missing"
        return result

    @builtins.property
    def domain_name(self) -> builtins.str:
        """(experimental) The custom domain name for your API.

        Uppercase letters are not supported.

        :stability: experimental
        """
        result = self._values.get("domain_name")
        assert result is not None, "Required property 'domain_name' is missing"
        return result

    @builtins.property
    def endpoint_type(self) -> typing.Optional["EndpointType"]:
        """(experimental) The type of endpoint for this DomainName.

        :default: REGIONAL

        :stability: experimental
        """
        result = self._values.get("endpoint_type")
        return result

    @builtins.property
    def mtls(self) -> typing.Optional["MTLSConfig"]:
        """(experimental) The mutual TLS authentication configuration for a custom domain name.

        :default: - mTLS is not configured.

        :stability: experimental
        """
        result = self._values.get("mtls")
        return result

    @builtins.property
    def security_policy(self) -> typing.Optional["SecurityPolicy"]:
        """(experimental) The Transport Layer Security (TLS) version + cipher suite for this domain name.

        :default: SecurityPolicy.TLS_1_0

        :see: https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainname.html
        :stability: experimental
        """
        result = self._values.get("security_policy")
        return result

    @builtins.property
    def mapping(self) -> typing.Optional["IRestApi"]:
        """(experimental) If specified, all requests to this domain will be mapped to the production deployment of this API.

        If you wish to map this domain to multiple APIs
        with different base paths, don't specify this option and use
        ``addBasePathMapping``.

        :default:

        - you will have to call ``addBasePathMapping`` to map this domain to
        API endpoints.

        :stability: experimental
        """
        result = self._values.get("mapping")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DomainNameProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.EndpointConfiguration",
    jsii_struct_bases=[],
    name_mapping={"types": "types", "vpc_endpoints": "vpcEndpoints"},
)
class EndpointConfiguration:
    def __init__(
        self,
        *,
        types: typing.List["EndpointType"],
        vpc_endpoints: typing.Optional[typing.List[_IVpcEndpoint_8b8ad2f1]] = None,
    ) -> None:
        """(experimental) The endpoint configuration of a REST API, including VPCs and endpoint types.

        EndpointConfiguration is a property of the AWS::ApiGateway::RestApi resource.

        :param types: (experimental) A list of endpoint types of an API or its custom domain name. Default: EndpointType.EDGE
        :param vpc_endpoints: (experimental) A list of VPC Endpoints against which to create Route53 ALIASes. Default: - no ALIASes are created for the endpoint.

        :stability: experimental
        """
        self._values: typing.Dict[str, typing.Any] = {
            "types": types,
        }
        if vpc_endpoints is not None:
            self._values["vpc_endpoints"] = vpc_endpoints

    @builtins.property
    def types(self) -> typing.List["EndpointType"]:
        """(experimental) A list of endpoint types of an API or its custom domain name.

        :default: EndpointType.EDGE

        :stability: experimental
        """
        result = self._values.get("types")
        assert result is not None, "Required property 'types' is missing"
        return result

    @builtins.property
    def vpc_endpoints(self) -> typing.Optional[typing.List[_IVpcEndpoint_8b8ad2f1]]:
        """(experimental) A list of VPC Endpoints against which to create Route53 ALIASes.

        :default: - no ALIASes are created for the endpoint.

        :stability: experimental
        """
        result = self._values.get("vpc_endpoints")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EndpointConfiguration(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="monocdk.aws_apigateway.EndpointType")
class EndpointType(enum.Enum):
    """
    :stability: experimental
    """

    EDGE = "EDGE"
    """(experimental) For an edge-optimized API and its custom domain name.

    :stability: experimental
    """
    REGIONAL = "REGIONAL"
    """(experimental) For a regional API and its custom domain name.

    :stability: experimental
    """
    PRIVATE = "PRIVATE"
    """(experimental) For a private API and its custom domain name.

    :stability: experimental
    """


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.GatewayResponseOptions",
    jsii_struct_bases=[],
    name_mapping={
        "type": "type",
        "response_headers": "responseHeaders",
        "status_code": "statusCode",
        "templates": "templates",
    },
)
class GatewayResponseOptions:
    def __init__(
        self,
        *,
        type: "ResponseType",
        response_headers: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        status_code: typing.Optional[builtins.str] = None,
        templates: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
    ) -> None:
        """(experimental) Options to add gateway response.

        :param type: (experimental) Response type to associate with gateway response.
        :param response_headers: (experimental) Custom headers parameters for response. Default: - no headers
        :param status_code: (experimental) Http status code for response. Default: - standard http status code for the response type.
        :param templates: (experimental) Custom templates to get mapped as response. Default: - Response from api will be returned without applying any transformation.

        :stability: experimental
        """
        self._values: typing.Dict[str, typing.Any] = {
            "type": type,
        }
        if response_headers is not None:
            self._values["response_headers"] = response_headers
        if status_code is not None:
            self._values["status_code"] = status_code
        if templates is not None:
            self._values["templates"] = templates

    @builtins.property
    def type(self) -> "ResponseType":
        """(experimental) Response type to associate with gateway response.

        :see: https://docs.aws.amazon.com/apigateway/latest/developerguide/supported-gateway-response-types.html
        :stability: experimental
        """
        result = self._values.get("type")
        assert result is not None, "Required property 'type' is missing"
        return result

    @builtins.property
    def response_headers(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        """(experimental) Custom headers parameters for response.

        :default: - no headers

        :stability: experimental
        """
        result = self._values.get("response_headers")
        return result

    @builtins.property
    def status_code(self) -> typing.Optional[builtins.str]:
        """(experimental) Http status code for response.

        :default: - standard http status code for the response type.

        :stability: experimental
        """
        result = self._values.get("status_code")
        return result

    @builtins.property
    def templates(self) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        """(experimental) Custom templates to get mapped as response.

        :default: - Response from api will be returned without applying any transformation.

        :stability: experimental
        """
        result = self._values.get("templates")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "GatewayResponseOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.GatewayResponseProps",
    jsii_struct_bases=[GatewayResponseOptions],
    name_mapping={
        "type": "type",
        "response_headers": "responseHeaders",
        "status_code": "statusCode",
        "templates": "templates",
        "rest_api": "restApi",
    },
)
class GatewayResponseProps(GatewayResponseOptions):
    def __init__(
        self,
        *,
        type: "ResponseType",
        response_headers: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        status_code: typing.Optional[builtins.str] = None,
        templates: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        rest_api: "IRestApi",
    ) -> None:
        """(experimental) Properties for a new gateway response.

        :param type: (experimental) Response type to associate with gateway response.
        :param response_headers: (experimental) Custom headers parameters for response. Default: - no headers
        :param status_code: (experimental) Http status code for response. Default: - standard http status code for the response type.
        :param templates: (experimental) Custom templates to get mapped as response. Default: - Response from api will be returned without applying any transformation.
        :param rest_api: (experimental) Rest api resource to target.

        :stability: experimental
        """
        self._values: typing.Dict[str, typing.Any] = {
            "type": type,
            "rest_api": rest_api,
        }
        if response_headers is not None:
            self._values["response_headers"] = response_headers
        if status_code is not None:
            self._values["status_code"] = status_code
        if templates is not None:
            self._values["templates"] = templates

    @builtins.property
    def type(self) -> "ResponseType":
        """(experimental) Response type to associate with gateway response.

        :see: https://docs.aws.amazon.com/apigateway/latest/developerguide/supported-gateway-response-types.html
        :stability: experimental
        """
        result = self._values.get("type")
        assert result is not None, "Required property 'type' is missing"
        return result

    @builtins.property
    def response_headers(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        """(experimental) Custom headers parameters for response.

        :default: - no headers

        :stability: experimental
        """
        result = self._values.get("response_headers")
        return result

    @builtins.property
    def status_code(self) -> typing.Optional[builtins.str]:
        """(experimental) Http status code for response.

        :default: - standard http status code for the response type.

        :stability: experimental
        """
        result = self._values.get("status_code")
        return result

    @builtins.property
    def templates(self) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        """(experimental) Custom templates to get mapped as response.

        :default: - Response from api will be returned without applying any transformation.

        :stability: experimental
        """
        result = self._values.get("templates")
        return result

    @builtins.property
    def rest_api(self) -> "IRestApi":
        """(experimental) Rest api resource to target.

        :stability: experimental
        """
        result = self._values.get("rest_api")
        assert result is not None, "Required property 'rest_api' is missing"
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "GatewayResponseProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.HttpIntegrationProps",
    jsii_struct_bases=[],
    name_mapping={"http_method": "httpMethod", "options": "options", "proxy": "proxy"},
)
class HttpIntegrationProps:
    def __init__(
        self,
        *,
        http_method: typing.Optional[builtins.str] = None,
        options: typing.Optional["IntegrationOptions"] = None,
        proxy: typing.Optional[builtins.bool] = None,
    ) -> None:
        """
        :param http_method: (experimental) HTTP method to use when invoking the backend URL. Default: GET
        :param options: (experimental) Integration options, such as request/resopnse mapping, content handling, etc. Default: defaults based on ``IntegrationOptions`` defaults
        :param proxy: (experimental) Determines whether to use proxy integration or custom integration. Default: true

        :stability: experimental
        """
        if isinstance(options, dict):
            options = IntegrationOptions(**options)
        self._values: typing.Dict[str, typing.Any] = {}
        if http_method is not None:
            self._values["http_method"] = http_method
        if options is not None:
            self._values["options"] = options
        if proxy is not None:
            self._values["proxy"] = proxy

    @builtins.property
    def http_method(self) -> typing.Optional[builtins.str]:
        """(experimental) HTTP method to use when invoking the backend URL.

        :default: GET

        :stability: experimental
        """
        result = self._values.get("http_method")
        return result

    @builtins.property
    def options(self) -> typing.Optional["IntegrationOptions"]:
        """(experimental) Integration options, such as request/resopnse mapping, content handling, etc.

        :default: defaults based on ``IntegrationOptions`` defaults

        :stability: experimental
        """
        result = self._values.get("options")
        return result

    @builtins.property
    def proxy(self) -> typing.Optional[builtins.bool]:
        """(experimental) Determines whether to use proxy integration or custom integration.

        :default: true

        :stability: experimental
        """
        result = self._values.get("proxy")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "HttpIntegrationProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.interface(jsii_type="monocdk.aws_apigateway.IAccessLogDestination")
class IAccessLogDestination(typing_extensions.Protocol):
    """(experimental) Access log destination for a RestApi Stage.

    :stability: experimental
    """

    @builtins.staticmethod
    def __jsii_proxy_class__():
        return _IAccessLogDestinationProxy

    @jsii.member(jsii_name="bind")
    def bind(self, stage: "IStage") -> AccessLogDestinationConfig:
        """(experimental) Binds this destination to the RestApi Stage.

        :param stage: -

        :stability: experimental
        """
        ...


class _IAccessLogDestinationProxy:
    """(experimental) Access log destination for a RestApi Stage.

    :stability: experimental
    """

    __jsii_type__: typing.ClassVar[str] = "monocdk.aws_apigateway.IAccessLogDestination"

    @jsii.member(jsii_name="bind")
    def bind(self, stage: "IStage") -> AccessLogDestinationConfig:
        """(experimental) Binds this destination to the RestApi Stage.

        :param stage: -

        :stability: experimental
        """
        return jsii.invoke(self, "bind", [stage])


@jsii.interface(jsii_type="monocdk.aws_apigateway.IApiKey")
class IApiKey(_IResource_8c1dbbbd, typing_extensions.Protocol):
    """(experimental) API keys are alphanumeric string values that you distribute to app developer customers to grant access to your API.

    :stability: experimental
    """

    @builtins.staticmethod
    def __jsii_proxy_class__():
        return _IApiKeyProxy

    @builtins.property # type: ignore
    @jsii.member(jsii_name="keyArn")
    def key_arn(self) -> builtins.str:
        """(experimental) The API key ARN.

        :stability: experimental
        """
        ...

    @builtins.property # type: ignore
    @jsii.member(jsii_name="keyId")
    def key_id(self) -> builtins.str:
        """(experimental) The API key ID.

        :stability: experimental
        :attribute: true
        """
        ...


class _IApiKeyProxy(
    jsii.proxy_for(_IResource_8c1dbbbd) # type: ignore
):
    """(experimental) API keys are alphanumeric string values that you distribute to app developer customers to grant access to your API.

    :stability: experimental
    """

    __jsii_type__: typing.ClassVar[str] = "monocdk.aws_apigateway.IApiKey"

    @builtins.property # type: ignore
    @jsii.member(jsii_name="keyArn")
    def key_arn(self) -> builtins.str:
        """(experimental) The API key ARN.

        :stability: experimental
        """
        return jsii.get(self, "keyArn")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="keyId")
    def key_id(self) -> builtins.str:
        """(experimental) The API key ID.

        :stability: experimental
        :attribute: true
        """
        return jsii.get(self, "keyId")


@jsii.interface(jsii_type="monocdk.aws_apigateway.IAuthorizer")
class IAuthorizer(typing_extensions.Protocol):
    """(experimental) Represents an API Gateway authorizer.

    :stability: experimental
    """

    @builtins.staticmethod
    def __jsii_proxy_class__():
        return _IAuthorizerProxy

    @builtins.property # type: ignore
    @jsii.member(jsii_name="authorizerId")
    def authorizer_id(self) -> builtins.str:
        """(experimental) The authorizer ID.

        :stability: experimental
        :attribute: true
        """
        ...

    @builtins.property # type: ignore
    @jsii.member(jsii_name="authorizationType")
    def authorization_type(self) -> typing.Optional[AuthorizationType]:
        """(experimental) The authorization type of this authorizer.

        :stability: experimental
        """
        ...


class _IAuthorizerProxy:
    """(experimental) Represents an API Gateway authorizer.

    :stability: experimental
    """

    __jsii_type__: typing.ClassVar[str] = "monocdk.aws_apigateway.IAuthorizer"

    @builtins.property # type: ignore
    @jsii.member(jsii_name="authorizerId")
    def authorizer_id(self) -> builtins.str:
        """(experimental) The authorizer ID.

        :stability: experimental
        :attribute: true
        """
        return jsii.get(self, "authorizerId")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="authorizationType")
    def authorization_type(self) -> typing.Optional[AuthorizationType]:
        """(experimental) The authorization type of this authorizer.

        :stability: experimental
        """
        return jsii.get(self, "authorizationType")


@jsii.interface(jsii_type="monocdk.aws_apigateway.IDomainName")
class IDomainName(_IResource_8c1dbbbd, typing_extensions.Protocol):
    """
    :stability: experimental
    """

    @builtins.staticmethod
    def __jsii_proxy_class__():
        return _IDomainNameProxy

    @builtins.property # type: ignore
    @jsii.member(jsii_name="domainName")
    def domain_name(self) -> builtins.str:
        """(experimental) The domain name (e.g. ``example.com``).

        :stability: experimental
        :attribute: DomainName
        """
        ...

    @builtins.property # type: ignore
    @jsii.member(jsii_name="domainNameAliasDomainName")
    def domain_name_alias_domain_name(self) -> builtins.str:
        """(experimental) The Route53 alias target to use in order to connect a record set to this domain through an alias.

        :stability: experimental
        :attribute: DistributionDomainName,RegionalDomainName
        """
        ...

    @builtins.property # type: ignore
    @jsii.member(jsii_name="domainNameAliasHostedZoneId")
    def domain_name_alias_hosted_zone_id(self) -> builtins.str:
        """(experimental) The Route53 hosted zone ID to use in order to connect a record set to this domain through an alias.

        :stability: experimental
        :attribute: DistributionHostedZoneId,RegionalHostedZoneId
        """
        ...


class _IDomainNameProxy(
    jsii.proxy_for(_IResource_8c1dbbbd) # type: ignore
):
    """
    :stability: experimental
    """

    __jsii_type__: typing.ClassVar[str] = "monocdk.aws_apigateway.IDomainName"

    @builtins.property # type: ignore
    @jsii.member(jsii_name="domainName")
    def domain_name(self) -> builtins.str:
        """(experimental) The domain name (e.g. ``example.com``).

        :stability: experimental
        :attribute: DomainName
        """
        return jsii.get(self, "domainName")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="domainNameAliasDomainName")
    def domain_name_alias_domain_name(self) -> builtins.str:
        """(experimental) The Route53 alias target to use in order to connect a record set to this domain through an alias.

        :stability: experimental
        :attribute: DistributionDomainName,RegionalDomainName
        """
        return jsii.get(self, "domainNameAliasDomainName")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="domainNameAliasHostedZoneId")
    def domain_name_alias_hosted_zone_id(self) -> builtins.str:
        """(experimental) The Route53 hosted zone ID to use in order to connect a record set to this domain through an alias.

        :stability: experimental
        :attribute: DistributionHostedZoneId,RegionalHostedZoneId
        """
        return jsii.get(self, "domainNameAliasHostedZoneId")


@jsii.interface(jsii_type="monocdk.aws_apigateway.IGatewayResponse")
class IGatewayResponse(_IResource_8c1dbbbd, typing_extensions.Protocol):
    """(experimental) Represents gateway response resource.

    :stability: experimental
    """

    @builtins.staticmethod
    def __jsii_proxy_class__():
        return _IGatewayResponseProxy


class _IGatewayResponseProxy(
    jsii.proxy_for(_IResource_8c1dbbbd) # type: ignore
):
    """(experimental) Represents gateway response resource.

    :stability: experimental
    """

    __jsii_type__: typing.ClassVar[str] = "monocdk.aws_apigateway.IGatewayResponse"
    pass


@jsii.interface(jsii_type="monocdk.aws_apigateway.IModel")
class IModel(typing_extensions.Protocol):
    """
    :stability: experimental
    """

    @builtins.staticmethod
    def __jsii_proxy_class__():
        return _IModelProxy

    @builtins.property # type: ignore
    @jsii.member(jsii_name="modelId")
    def model_id(self) -> builtins.str:
        """(experimental) Returns the model name, such as 'myModel'.

        :stability: experimental
        :attribute: true
        """
        ...


class _IModelProxy:
    """
    :stability: experimental
    """

    __jsii_type__: typing.ClassVar[str] = "monocdk.aws_apigateway.IModel"

    @builtins.property # type: ignore
    @jsii.member(jsii_name="modelId")
    def model_id(self) -> builtins.str:
        """(experimental) Returns the model name, such as 'myModel'.

        :stability: experimental
        :attribute: true
        """
        return jsii.get(self, "modelId")


@jsii.interface(jsii_type="monocdk.aws_apigateway.IRequestValidator")
class IRequestValidator(_IResource_8c1dbbbd, typing_extensions.Protocol):
    """
    :stability: experimental
    """

    @builtins.staticmethod
    def __jsii_proxy_class__():
        return _IRequestValidatorProxy

    @builtins.property # type: ignore
    @jsii.member(jsii_name="requestValidatorId")
    def request_validator_id(self) -> builtins.str:
        """(experimental) ID of the request validator, such as abc123.

        :stability: experimental
        :attribute: true
        """
        ...


class _IRequestValidatorProxy(
    jsii.proxy_for(_IResource_8c1dbbbd) # type: ignore
):
    """
    :stability: experimental
    """

    __jsii_type__: typing.ClassVar[str] = "monocdk.aws_apigateway.IRequestValidator"

    @builtins.property # type: ignore
    @jsii.member(jsii_name="requestValidatorId")
    def request_validator_id(self) -> builtins.str:
        """(experimental) ID of the request validator, such as abc123.

        :stability: experimental
        :attribute: true
        """
        return jsii.get(self, "requestValidatorId")


@jsii.interface(jsii_type="monocdk.aws_apigateway.IResource")
class IResource(_IResource_8c1dbbbd, typing_extensions.Protocol):
    """
    :stability: experimental
    """

    @builtins.staticmethod
    def __jsii_proxy_class__():
        return _IResourceProxy

    @builtins.property # type: ignore
    @jsii.member(jsii_name="api")
    def api(self) -> "IRestApi":
        """(experimental) The rest API that this resource is part of.

        The reason we need the RestApi object itself and not just the ID is because the model
        is being tracked by the top-level RestApi object for the purpose of calculating it's
        hash to determine the ID of the deployment. This allows us to automatically update
        the deployment when the model of the REST API changes.

        :stability: experimental
        """
        ...

    @builtins.property # type: ignore
    @jsii.member(jsii_name="path")
    def path(self) -> builtins.str:
        """(experimental) The full path of this resuorce.

        :stability: experimental
        """
        ...

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceId")
    def resource_id(self) -> builtins.str:
        """(experimental) The ID of the resource.

        :stability: experimental
        :attribute: true
        """
        ...

    @builtins.property # type: ignore
    @jsii.member(jsii_name="restApi")
    def rest_api(self) -> "RestApi":
        """(deprecated) The rest API that this resource is part of.

        :deprecated: - Throws an error if this Resource is not associated with an instance of ``RestApi``. Use ``api`` instead.

        :stability: deprecated
        """
        ...

    @builtins.property # type: ignore
    @jsii.member(jsii_name="defaultCorsPreflightOptions")
    def default_cors_preflight_options(self) -> typing.Optional[CorsOptions]:
        """(experimental) Default options for CORS preflight OPTIONS method.

        :stability: experimental
        """
        ...

    @builtins.property # type: ignore
    @jsii.member(jsii_name="defaultIntegration")
    def default_integration(self) -> typing.Optional["Integration"]:
        """(experimental) An integration to use as a default for all methods created within this API unless an integration is specified.

        :stability: experimental
        """
        ...

    @builtins.property # type: ignore
    @jsii.member(jsii_name="defaultMethodOptions")
    def default_method_options(self) -> typing.Optional["MethodOptions"]:
        """(experimental) Method options to use as a default for all methods created within this API unless custom options are specified.

        :stability: experimental
        """
        ...

    @builtins.property # type: ignore
    @jsii.member(jsii_name="parentResource")
    def parent_resource(self) -> typing.Optional["IResource"]:
        """(experimental) The parent of this resource or undefined for the root resource.

        :stability: experimental
        """
        ...

    @jsii.member(jsii_name="addCorsPreflight")
    def add_cors_preflight(
        self,
        *,
        allow_origins: typing.List[builtins.str],
        allow_credentials: typing.Optional[builtins.bool] = None,
        allow_headers: typing.Optional[typing.List[builtins.str]] = None,
        allow_methods: typing.Optional[typing.List[builtins.str]] = None,
        disable_cache: typing.Optional[builtins.bool] = None,
        expose_headers: typing.Optional[typing.List[builtins.str]] = None,
        max_age: typing.Optional[_Duration_070aa057] = None,
        status_code: typing.Optional[jsii.Number] = None,
    ) -> "Method":
        """(experimental) Adds an OPTIONS method to this resource which responds to Cross-Origin Resource Sharing (CORS) preflight requests.

        Cross-Origin Resource Sharing (CORS) is a mechanism that uses additional
        HTTP headers to tell browsers to give a web application running at one
        origin, access to selected resources from a different origin. A web
        application executes a cross-origin HTTP request when it requests a
        resource that has a different origin (domain, protocol, or port) from its
        own.

        :param allow_origins: (experimental) Specifies the list of origins that are allowed to make requests to this resource. If you wish to allow all origins, specify ``Cors.ALL_ORIGINS`` or ``[ * ]``. Responses will include the ``Access-Control-Allow-Origin`` response header. If ``Cors.ALL_ORIGINS`` is specified, the ``Vary: Origin`` response header will also be included.
        :param allow_credentials: (experimental) The Access-Control-Allow-Credentials response header tells browsers whether to expose the response to frontend JavaScript code when the request's credentials mode (Request.credentials) is "include". When a request's credentials mode (Request.credentials) is "include", browsers will only expose the response to frontend JavaScript code if the Access-Control-Allow-Credentials value is true. Credentials are cookies, authorization headers or TLS client certificates. Default: false
        :param allow_headers: (experimental) The Access-Control-Allow-Headers response header is used in response to a preflight request which includes the Access-Control-Request-Headers to indicate which HTTP headers can be used during the actual request. Default: Cors.DEFAULT_HEADERS
        :param allow_methods: (experimental) The Access-Control-Allow-Methods response header specifies the method or methods allowed when accessing the resource in response to a preflight request. If ``ANY`` is specified, it will be expanded to ``Cors.ALL_METHODS``. Default: Cors.ALL_METHODS
        :param disable_cache: (experimental) Sets Access-Control-Max-Age to -1, which means that caching is disabled. This option cannot be used with ``maxAge``. Default: - cache is enabled
        :param expose_headers: (experimental) The Access-Control-Expose-Headers response header indicates which headers can be exposed as part of the response by listing their names. If you want clients to be able to access other headers, you have to list them using the Access-Control-Expose-Headers header. Default: - only the 6 CORS-safelisted response headers are exposed: Cache-Control, Content-Language, Content-Type, Expires, Last-Modified, Pragma
        :param max_age: (experimental) The Access-Control-Max-Age response header indicates how long the results of a preflight request (that is the information contained in the Access-Control-Allow-Methods and Access-Control-Allow-Headers headers) can be cached. To disable caching altogther use ``disableCache: true``. Default: - browser-specific (see reference)
        :param status_code: (experimental) Specifies the response status code returned from the OPTIONS method. Default: 204

        :return: a ``Method`` object

        :see: https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS
        :stability: experimental
        """
        ...

    @jsii.member(jsii_name="addMethod")
    def add_method(
        self,
        http_method: builtins.str,
        target: typing.Optional["Integration"] = None,
        *,
        api_key_required: typing.Optional[builtins.bool] = None,
        authorization_scopes: typing.Optional[typing.List[builtins.str]] = None,
        authorization_type: typing.Optional[AuthorizationType] = None,
        authorizer: typing.Optional[IAuthorizer] = None,
        method_responses: typing.Optional[typing.List["MethodResponse"]] = None,
        operation_name: typing.Optional[builtins.str] = None,
        request_models: typing.Optional[typing.Mapping[builtins.str, IModel]] = None,
        request_parameters: typing.Optional[typing.Mapping[builtins.str, builtins.bool]] = None,
        request_validator: typing.Optional[IRequestValidator] = None,
        request_validator_options: typing.Optional["RequestValidatorOptions"] = None,
    ) -> "Method":
        """(experimental) Defines a new method for this resource.

        :param http_method: The HTTP method.
        :param target: The target backend integration for this method.
        :param api_key_required: (experimental) Indicates whether the method requires clients to submit a valid API key. Default: false
        :param authorization_scopes: (experimental) A list of authorization scopes configured on the method. The scopes are used with a COGNITO_USER_POOLS authorizer to authorize the method invocation. Default: - no authorization scopes
        :param authorization_type: (experimental) Method authorization. If the value is set of ``Custom``, an ``authorizer`` must also be specified. If you're using one of the authorizers that are available via the {@link Authorizer} class, such as {@link Authorizer#token()}, it is recommended that this option not be specified. The authorizer will take care of setting the correct authorization type. However, specifying an authorization type using this property that conflicts with what is expected by the {@link Authorizer} will result in an error. Default: - open access unless ``authorizer`` is specified
        :param authorizer: (experimental) If ``authorizationType`` is ``Custom``, this specifies the ID of the method authorizer resource. If specified, the value of ``authorizationType`` must be set to ``Custom``
        :param method_responses: (experimental) The responses that can be sent to the client who calls the method. Default: None This property is not required, but if these are not supplied for a Lambda proxy integration, the Lambda function must return a value of the correct format, for the integration response to be correctly mapped to a response to the client.
        :param operation_name: (experimental) A friendly operation name for the method. For example, you can assign the OperationName of ListPets for the GET /pets method.
        :param request_models: (experimental) The models which describe data structure of request payload. When combined with ``requestValidator`` or ``requestValidatorOptions``, the service will validate the API request payload before it reaches the API's Integration (including proxies). Specify ``requestModels`` as key-value pairs, with a content type (e.g. ``'application/json'``) as the key and an API Gateway Model as the value.
        :param request_parameters: (experimental) The request parameters that API Gateway accepts. Specify request parameters as key-value pairs (string-to-Boolean mapping), with a source as the key and a Boolean as the value. The Boolean specifies whether a parameter is required. A source must match the format method.request.location.name, where the location is querystring, path, or header, and name is a valid, unique parameter name. Default: None
        :param request_validator: (experimental) The ID of the associated request validator. Only one of ``requestValidator`` or ``requestValidatorOptions`` must be specified. Works together with ``requestModels`` or ``requestParameters`` to validate the request before it reaches integration like Lambda Proxy Integration. Default: - No default validator
        :param request_validator_options: (experimental) Request validator options to create new validator Only one of ``requestValidator`` or ``requestValidatorOptions`` must be specified. Works together with ``requestModels`` or ``requestParameters`` to validate the request before it reaches integration like Lambda Proxy Integration. Default: - No default validator

        :return: The newly created ``Method`` object.

        :stability: experimental
        """
        ...

    @jsii.member(jsii_name="addProxy")
    def add_proxy(
        self,
        *,
        any_method: typing.Optional[builtins.bool] = None,
        default_cors_preflight_options: typing.Optional[CorsOptions] = None,
        default_integration: typing.Optional["Integration"] = None,
        default_method_options: typing.Optional["MethodOptions"] = None,
    ) -> "ProxyResource":
        """(experimental) Adds a greedy proxy resource ("{proxy+}") and an ANY method to this route.

        :param any_method: (experimental) Adds an "ANY" method to this resource. If set to ``false``, you will have to explicitly add methods to this resource after it's created. Default: true
        :param default_cors_preflight_options: (experimental) Adds a CORS preflight OPTIONS method to this resource and all child resources. You can add CORS at the resource-level using ``addCorsPreflight``. Default: - CORS is disabled
        :param default_integration: (experimental) An integration to use as a default for all methods created within this API unless an integration is specified. Default: - Inherited from parent.
        :param default_method_options: (experimental) Method options to use as a default for all methods created within this API unless custom options are specified. Default: - Inherited from parent.

        :stability: experimental
        """
        ...

    @jsii.member(jsii_name="addResource")
    def add_resource(
        self,
        path_part: builtins.str,
        *,
        default_cors_preflight_options: typing.Optional[CorsOptions] = None,
        default_integration: typing.Optional["Integration"] = None,
        default_method_options: typing.Optional["MethodOptions"] = None,
    ) -> "Resource":
        """(experimental) Defines a new child resource where this resource is the parent.

        :param path_part: The path part for the child resource.
        :param default_cors_preflight_options: (experimental) Adds a CORS preflight OPTIONS method to this resource and all child resources. You can add CORS at the resource-level using ``addCorsPreflight``. Default: - CORS is disabled
        :param default_integration: (experimental) An integration to use as a default for all methods created within this API unless an integration is specified. Default: - Inherited from parent.
        :param default_method_options: (experimental) Method options to use as a default for all methods created within this API unless custom options are specified. Default: - Inherited from parent.

        :return: A Resource object

        :stability: experimental
        """
        ...

    @jsii.member(jsii_name="getResource")
    def get_resource(self, path_part: builtins.str) -> typing.Optional["IResource"]:
        """(experimental) Retrieves a child resource by path part.

        :param path_part: The path part of the child resource.

        :return: the child resource or undefined if not found

        :stability: experimental
        """
        ...

    @jsii.member(jsii_name="resourceForPath")
    def resource_for_path(self, path: builtins.str) -> "Resource":
        """(experimental) Gets or create all resources leading up to the specified path.

        - Path may only start with "/" if this method is called on the root resource.
        - All resources are created using default options.

        :param path: The relative path.

        :return: a new or existing resource.

        :stability: experimental
        """
        ...


class _IResourceProxy(
    jsii.proxy_for(_IResource_8c1dbbbd) # type: ignore
):
    """
    :stability: experimental
    """

    __jsii_type__: typing.ClassVar[str] = "monocdk.aws_apigateway.IResource"

    @builtins.property # type: ignore
    @jsii.member(jsii_name="api")
    def api(self) -> "IRestApi":
        """(experimental) The rest API that this resource is part of.

        The reason we need the RestApi object itself and not just the ID is because the model
        is being tracked by the top-level RestApi object for the purpose of calculating it's
        hash to determine the ID of the deployment. This allows us to automatically update
        the deployment when the model of the REST API changes.

        :stability: experimental
        """
        return jsii.get(self, "api")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="path")
    def path(self) -> builtins.str:
        """(experimental) The full path of this resuorce.

        :stability: experimental
        """
        return jsii.get(self, "path")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceId")
    def resource_id(self) -> builtins.str:
        """(experimental) The ID of the resource.

        :stability: experimental
        :attribute: true
        """
        return jsii.get(self, "resourceId")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="restApi")
    def rest_api(self) -> "RestApi":
        """(deprecated) The rest API that this resource is part of.

        :deprecated: - Throws an error if this Resource is not associated with an instance of ``RestApi``. Use ``api`` instead.

        :stability: deprecated
        """
        return jsii.get(self, "restApi")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="defaultCorsPreflightOptions")
    def default_cors_preflight_options(self) -> typing.Optional[CorsOptions]:
        """(experimental) Default options for CORS preflight OPTIONS method.

        :stability: experimental
        """
        return jsii.get(self, "defaultCorsPreflightOptions")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="defaultIntegration")
    def default_integration(self) -> typing.Optional["Integration"]:
        """(experimental) An integration to use as a default for all methods created within this API unless an integration is specified.

        :stability: experimental
        """
        return jsii.get(self, "defaultIntegration")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="defaultMethodOptions")
    def default_method_options(self) -> typing.Optional["MethodOptions"]:
        """(experimental) Method options to use as a default for all methods created within this API unless custom options are specified.

        :stability: experimental
        """
        return jsii.get(self, "defaultMethodOptions")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="parentResource")
    def parent_resource(self) -> typing.Optional[IResource]:
        """(experimental) The parent of this resource or undefined for the root resource.

        :stability: experimental
        """
        return jsii.get(self, "parentResource")

    @jsii.member(jsii_name="addCorsPreflight")
    def add_cors_preflight(
        self,
        *,
        allow_origins: typing.List[builtins.str],
        allow_credentials: typing.Optional[builtins.bool] = None,
        allow_headers: typing.Optional[typing.List[builtins.str]] = None,
        allow_methods: typing.Optional[typing.List[builtins.str]] = None,
        disable_cache: typing.Optional[builtins.bool] = None,
        expose_headers: typing.Optional[typing.List[builtins.str]] = None,
        max_age: typing.Optional[_Duration_070aa057] = None,
        status_code: typing.Optional[jsii.Number] = None,
    ) -> "Method":
        """(experimental) Adds an OPTIONS method to this resource which responds to Cross-Origin Resource Sharing (CORS) preflight requests.

        Cross-Origin Resource Sharing (CORS) is a mechanism that uses additional
        HTTP headers to tell browsers to give a web application running at one
        origin, access to selected resources from a different origin. A web
        application executes a cross-origin HTTP request when it requests a
        resource that has a different origin (domain, protocol, or port) from its
        own.

        :param allow_origins: (experimental) Specifies the list of origins that are allowed to make requests to this resource. If you wish to allow all origins, specify ``Cors.ALL_ORIGINS`` or ``[ * ]``. Responses will include the ``Access-Control-Allow-Origin`` response header. If ``Cors.ALL_ORIGINS`` is specified, the ``Vary: Origin`` response header will also be included.
        :param allow_credentials: (experimental) The Access-Control-Allow-Credentials response header tells browsers whether to expose the response to frontend JavaScript code when the request's credentials mode (Request.credentials) is "include". When a request's credentials mode (Request.credentials) is "include", browsers will only expose the response to frontend JavaScript code if the Access-Control-Allow-Credentials value is true. Credentials are cookies, authorization headers or TLS client certificates. Default: false
        :param allow_headers: (experimental) The Access-Control-Allow-Headers response header is used in response to a preflight request which includes the Access-Control-Request-Headers to indicate which HTTP headers can be used during the actual request. Default: Cors.DEFAULT_HEADERS
        :param allow_methods: (experimental) The Access-Control-Allow-Methods response header specifies the method or methods allowed when accessing the resource in response to a preflight request. If ``ANY`` is specified, it will be expanded to ``Cors.ALL_METHODS``. Default: Cors.ALL_METHODS
        :param disable_cache: (experimental) Sets Access-Control-Max-Age to -1, which means that caching is disabled. This option cannot be used with ``maxAge``. Default: - cache is enabled
        :param expose_headers: (experimental) The Access-Control-Expose-Headers response header indicates which headers can be exposed as part of the response by listing their names. If you want clients to be able to access other headers, you have to list them using the Access-Control-Expose-Headers header. Default: - only the 6 CORS-safelisted response headers are exposed: Cache-Control, Content-Language, Content-Type, Expires, Last-Modified, Pragma
        :param max_age: (experimental) The Access-Control-Max-Age response header indicates how long the results of a preflight request (that is the information contained in the Access-Control-Allow-Methods and Access-Control-Allow-Headers headers) can be cached. To disable caching altogther use ``disableCache: true``. Default: - browser-specific (see reference)
        :param status_code: (experimental) Specifies the response status code returned from the OPTIONS method. Default: 204

        :return: a ``Method`` object

        :see: https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS
        :stability: experimental
        """
        options = CorsOptions(
            allow_origins=allow_origins,
            allow_credentials=allow_credentials,
            allow_headers=allow_headers,
            allow_methods=allow_methods,
            disable_cache=disable_cache,
            expose_headers=expose_headers,
            max_age=max_age,
            status_code=status_code,
        )

        return jsii.invoke(self, "addCorsPreflight", [options])

    @jsii.member(jsii_name="addMethod")
    def add_method(
        self,
        http_method: builtins.str,
        target: typing.Optional["Integration"] = None,
        *,
        api_key_required: typing.Optional[builtins.bool] = None,
        authorization_scopes: typing.Optional[typing.List[builtins.str]] = None,
        authorization_type: typing.Optional[AuthorizationType] = None,
        authorizer: typing.Optional[IAuthorizer] = None,
        method_responses: typing.Optional[typing.List["MethodResponse"]] = None,
        operation_name: typing.Optional[builtins.str] = None,
        request_models: typing.Optional[typing.Mapping[builtins.str, IModel]] = None,
        request_parameters: typing.Optional[typing.Mapping[builtins.str, builtins.bool]] = None,
        request_validator: typing.Optional[IRequestValidator] = None,
        request_validator_options: typing.Optional["RequestValidatorOptions"] = None,
    ) -> "Method":
        """(experimental) Defines a new method for this resource.

        :param http_method: The HTTP method.
        :param target: The target backend integration for this method.
        :param api_key_required: (experimental) Indicates whether the method requires clients to submit a valid API key. Default: false
        :param authorization_scopes: (experimental) A list of authorization scopes configured on the method. The scopes are used with a COGNITO_USER_POOLS authorizer to authorize the method invocation. Default: - no authorization scopes
        :param authorization_type: (experimental) Method authorization. If the value is set of ``Custom``, an ``authorizer`` must also be specified. If you're using one of the authorizers that are available via the {@link Authorizer} class, such as {@link Authorizer#token()}, it is recommended that this option not be specified. The authorizer will take care of setting the correct authorization type. However, specifying an authorization type using this property that conflicts with what is expected by the {@link Authorizer} will result in an error. Default: - open access unless ``authorizer`` is specified
        :param authorizer: (experimental) If ``authorizationType`` is ``Custom``, this specifies the ID of the method authorizer resource. If specified, the value of ``authorizationType`` must be set to ``Custom``
        :param method_responses: (experimental) The responses that can be sent to the client who calls the method. Default: None This property is not required, but if these are not supplied for a Lambda proxy integration, the Lambda function must return a value of the correct format, for the integration response to be correctly mapped to a response to the client.
        :param operation_name: (experimental) A friendly operation name for the method. For example, you can assign the OperationName of ListPets for the GET /pets method.
        :param request_models: (experimental) The models which describe data structure of request payload. When combined with ``requestValidator`` or ``requestValidatorOptions``, the service will validate the API request payload before it reaches the API's Integration (including proxies). Specify ``requestModels`` as key-value pairs, with a content type (e.g. ``'application/json'``) as the key and an API Gateway Model as the value.
        :param request_parameters: (experimental) The request parameters that API Gateway accepts. Specify request parameters as key-value pairs (string-to-Boolean mapping), with a source as the key and a Boolean as the value. The Boolean specifies whether a parameter is required. A source must match the format method.request.location.name, where the location is querystring, path, or header, and name is a valid, unique parameter name. Default: None
        :param request_validator: (experimental) The ID of the associated request validator. Only one of ``requestValidator`` or ``requestValidatorOptions`` must be specified. Works together with ``requestModels`` or ``requestParameters`` to validate the request before it reaches integration like Lambda Proxy Integration. Default: - No default validator
        :param request_validator_options: (experimental) Request validator options to create new validator Only one of ``requestValidator`` or ``requestValidatorOptions`` must be specified. Works together with ``requestModels`` or ``requestParameters`` to validate the request before it reaches integration like Lambda Proxy Integration. Default: - No default validator

        :return: The newly created ``Method`` object.

        :stability: experimental
        """
        options = MethodOptions(
            api_key_required=api_key_required,
            authorization_scopes=authorization_scopes,
            authorization_type=authorization_type,
            authorizer=authorizer,
            method_responses=method_responses,
            operation_name=operation_name,
            request_models=request_models,
            request_parameters=request_parameters,
            request_validator=request_validator,
            request_validator_options=request_validator_options,
        )

        return jsii.invoke(self, "addMethod", [http_method, target, options])

    @jsii.member(jsii_name="addProxy")
    def add_proxy(
        self,
        *,
        any_method: typing.Optional[builtins.bool] = None,
        default_cors_preflight_options: typing.Optional[CorsOptions] = None,
        default_integration: typing.Optional["Integration"] = None,
        default_method_options: typing.Optional["MethodOptions"] = None,
    ) -> "ProxyResource":
        """(experimental) Adds a greedy proxy resource ("{proxy+}") and an ANY method to this route.

        :param any_method: (experimental) Adds an "ANY" method to this resource. If set to ``false``, you will have to explicitly add methods to this resource after it's created. Default: true
        :param default_cors_preflight_options: (experimental) Adds a CORS preflight OPTIONS method to this resource and all child resources. You can add CORS at the resource-level using ``addCorsPreflight``. Default: - CORS is disabled
        :param default_integration: (experimental) An integration to use as a default for all methods created within this API unless an integration is specified. Default: - Inherited from parent.
        :param default_method_options: (experimental) Method options to use as a default for all methods created within this API unless custom options are specified. Default: - Inherited from parent.

        :stability: experimental
        """
        options = ProxyResourceOptions(
            any_method=any_method,
            default_cors_preflight_options=default_cors_preflight_options,
            default_integration=default_integration,
            default_method_options=default_method_options,
        )

        return jsii.invoke(self, "addProxy", [options])

    @jsii.member(jsii_name="addResource")
    def add_resource(
        self,
        path_part: builtins.str,
        *,
        default_cors_preflight_options: typing.Optional[CorsOptions] = None,
        default_integration: typing.Optional["Integration"] = None,
        default_method_options: typing.Optional["MethodOptions"] = None,
    ) -> "Resource":
        """(experimental) Defines a new child resource where this resource is the parent.

        :param path_part: The path part for the child resource.
        :param default_cors_preflight_options: (experimental) Adds a CORS preflight OPTIONS method to this resource and all child resources. You can add CORS at the resource-level using ``addCorsPreflight``. Default: - CORS is disabled
        :param default_integration: (experimental) An integration to use as a default for all methods created within this API unless an integration is specified. Default: - Inherited from parent.
        :param default_method_options: (experimental) Method options to use as a default for all methods created within this API unless custom options are specified. Default: - Inherited from parent.

        :return: A Resource object

        :stability: experimental
        """
        options = ResourceOptions(
            default_cors_preflight_options=default_cors_preflight_options,
            default_integration=default_integration,
            default_method_options=default_method_options,
        )

        return jsii.invoke(self, "addResource", [path_part, options])

    @jsii.member(jsii_name="getResource")
    def get_resource(self, path_part: builtins.str) -> typing.Optional[IResource]:
        """(experimental) Retrieves a child resource by path part.

        :param path_part: The path part of the child resource.

        :return: the child resource or undefined if not found

        :stability: experimental
        """
        return jsii.invoke(self, "getResource", [path_part])

    @jsii.member(jsii_name="resourceForPath")
    def resource_for_path(self, path: builtins.str) -> "Resource":
        """(experimental) Gets or create all resources leading up to the specified path.

        - Path may only start with "/" if this method is called on the root resource.
        - All resources are created using default options.

        :param path: The relative path.

        :return: a new or existing resource.

        :stability: experimental
        """
        return jsii.invoke(self, "resourceForPath", [path])


@jsii.interface(jsii_type="monocdk.aws_apigateway.IRestApi")
class IRestApi(_IResource_8c1dbbbd, typing_extensions.Protocol):
    """
    :stability: experimental
    """

    @builtins.staticmethod
    def __jsii_proxy_class__():
        return _IRestApiProxy

    @builtins.property # type: ignore
    @jsii.member(jsii_name="restApiId")
    def rest_api_id(self) -> builtins.str:
        """(experimental) The ID of this API Gateway RestApi.

        :stability: experimental
        :attribute: true
        """
        ...

    @builtins.property # type: ignore
    @jsii.member(jsii_name="restApiRootResourceId")
    def rest_api_root_resource_id(self) -> builtins.str:
        """(experimental) The resource ID of the root resource.

        :stability: experimental
        :attribute: true
        """
        ...

    @builtins.property # type: ignore
    @jsii.member(jsii_name="root")
    def root(self) -> IResource:
        """(experimental) Represents the root resource ("/") of this API. Use it to define the API model:.

        api.root.addMethod('ANY', redirectToHomePage); // "ANY /"
        api.root.addResource('friends').addMethod('GET', getFriendsHandler); // "GET /friends"

        :stability: experimental
        """
        ...

    @builtins.property # type: ignore
    @jsii.member(jsii_name="latestDeployment")
    def latest_deployment(self) -> typing.Optional[Deployment]:
        """(experimental) API Gateway deployment that represents the latest changes of the API.

        This resource will be automatically updated every time the REST API model changes.
        ``undefined`` when no deployment is configured.

        :stability: experimental
        """
        ...

    @builtins.property # type: ignore
    @jsii.member(jsii_name="deploymentStage")
    def deployment_stage(self) -> "Stage":
        """(experimental) API Gateway stage that points to the latest deployment (if defined).

        :stability: experimental
        """
        ...

    @deployment_stage.setter # type: ignore
    def deployment_stage(self, value: "Stage") -> None:
        ...

    @jsii.member(jsii_name="arnForExecuteApi")
    def arn_for_execute_api(
        self,
        method: typing.Optional[builtins.str] = None,
        path: typing.Optional[builtins.str] = None,
        stage: typing.Optional[builtins.str] = None,
    ) -> builtins.str:
        """(experimental) Gets the "execute-api" ARN.

        :param method: The method (default ``*``).
        :param path: The resource path. Must start with '/' (default ``*``)
        :param stage: The stage (default ``*``).

        :default:

        "*" returns the execute API ARN for all methods/resources in
        this API.

        :return: The "execute-api" ARN.

        :stability: experimental
        """
        ...


class _IRestApiProxy(
    jsii.proxy_for(_IResource_8c1dbbbd) # type: ignore
):
    """
    :stability: experimental
    """

    __jsii_type__: typing.ClassVar[str] = "monocdk.aws_apigateway.IRestApi"

    @builtins.property # type: ignore
    @jsii.member(jsii_name="restApiId")
    def rest_api_id(self) -> builtins.str:
        """(experimental) The ID of this API Gateway RestApi.

        :stability: experimental
        :attribute: true
        """
        return jsii.get(self, "restApiId")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="restApiRootResourceId")
    def rest_api_root_resource_id(self) -> builtins.str:
        """(experimental) The resource ID of the root resource.

        :stability: experimental
        :attribute: true
        """
        return jsii.get(self, "restApiRootResourceId")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="root")
    def root(self) -> IResource:
        """(experimental) Represents the root resource ("/") of this API. Use it to define the API model:.

        api.root.addMethod('ANY', redirectToHomePage); // "ANY /"
        api.root.addResource('friends').addMethod('GET', getFriendsHandler); // "GET /friends"

        :stability: experimental
        """
        return jsii.get(self, "root")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="latestDeployment")
    def latest_deployment(self) -> typing.Optional[Deployment]:
        """(experimental) API Gateway deployment that represents the latest changes of the API.

        This resource will be automatically updated every time the REST API model changes.
        ``undefined`` when no deployment is configured.

        :stability: experimental
        """
        return jsii.get(self, "latestDeployment")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="deploymentStage")
    def deployment_stage(self) -> "Stage":
        """(experimental) API Gateway stage that points to the latest deployment (if defined).

        :stability: experimental
        """
        return jsii.get(self, "deploymentStage")

    @deployment_stage.setter # type: ignore
    def deployment_stage(self, value: "Stage") -> None:
        jsii.set(self, "deploymentStage", value)

    @jsii.member(jsii_name="arnForExecuteApi")
    def arn_for_execute_api(
        self,
        method: typing.Optional[builtins.str] = None,
        path: typing.Optional[builtins.str] = None,
        stage: typing.Optional[builtins.str] = None,
    ) -> builtins.str:
        """(experimental) Gets the "execute-api" ARN.

        :param method: The method (default ``*``).
        :param path: The resource path. Must start with '/' (default ``*``)
        :param stage: The stage (default ``*``).

        :default:

        "*" returns the execute API ARN for all methods/resources in
        this API.

        :return: The "execute-api" ARN.

        :stability: experimental
        """
        return jsii.invoke(self, "arnForExecuteApi", [method, path, stage])


@jsii.interface(jsii_type="monocdk.aws_apigateway.IStage")
class IStage(_IResource_8c1dbbbd, typing_extensions.Protocol):
    """(experimental) Represents an APIGateway Stage.

    :stability: experimental
    """

    @builtins.staticmethod
    def __jsii_proxy_class__():
        return _IStageProxy

    @builtins.property # type: ignore
    @jsii.member(jsii_name="restApi")
    def rest_api(self) -> IRestApi:
        """(experimental) RestApi to which this stage is associated.

        :stability: experimental
        """
        ...

    @builtins.property # type: ignore
    @jsii.member(jsii_name="stageName")
    def stage_name(self) -> builtins.str:
        """(experimental) Name of this stage.

        :stability: experimental
        :attribute: true
        """
        ...


class _IStageProxy(
    jsii.proxy_for(_IResource_8c1dbbbd) # type: ignore
):
    """(experimental) Represents an APIGateway Stage.

    :stability: experimental
    """

    __jsii_type__: typing.ClassVar[str] = "monocdk.aws_apigateway.IStage"

    @builtins.property # type: ignore
    @jsii.member(jsii_name="restApi")
    def rest_api(self) -> IRestApi:
        """(experimental) RestApi to which this stage is associated.

        :stability: experimental
        """
        return jsii.get(self, "restApi")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="stageName")
    def stage_name(self) -> builtins.str:
        """(experimental) Name of this stage.

        :stability: experimental
        :attribute: true
        """
        return jsii.get(self, "stageName")


@jsii.interface(jsii_type="monocdk.aws_apigateway.IVpcLink")
class IVpcLink(_IResource_8c1dbbbd, typing_extensions.Protocol):
    """(experimental) Represents an API Gateway VpcLink.

    :stability: experimental
    """

    @builtins.staticmethod
    def __jsii_proxy_class__():
        return _IVpcLinkProxy

    @builtins.property # type: ignore
    @jsii.member(jsii_name="vpcLinkId")
    def vpc_link_id(self) -> builtins.str:
        """(experimental) Physical ID of the VpcLink resource.

        :stability: experimental
        :attribute: true
        """
        ...


class _IVpcLinkProxy(
    jsii.proxy_for(_IResource_8c1dbbbd) # type: ignore
):
    """(experimental) Represents an API Gateway VpcLink.

    :stability: experimental
    """

    __jsii_type__: typing.ClassVar[str] = "monocdk.aws_apigateway.IVpcLink"

    @builtins.property # type: ignore
    @jsii.member(jsii_name="vpcLinkId")
    def vpc_link_id(self) -> builtins.str:
        """(experimental) Physical ID of the VpcLink resource.

        :stability: experimental
        :attribute: true
        """
        return jsii.get(self, "vpcLinkId")


class IdentitySource(
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_apigateway.IdentitySource",
):
    """(experimental) Represents an identity source.

    The source can be specified either as a literal value (e.g: ``Auth``) which
    cannot be blank, or as an unresolved string token.

    :stability: experimental
    """

    def __init__(self) -> None:
        """
        :stability: experimental
        """
        jsii.create(IdentitySource, self, [])

    @jsii.member(jsii_name="context")
    @builtins.classmethod
    def context(cls, context: builtins.str) -> builtins.str:
        """(experimental) Provides a properly formatted request context identity source.

        :param context: the name of the context variable the ``IdentitySource`` will represent.

        :return: a request context identity source.

        :stability: experimental
        """
        return jsii.sinvoke(cls, "context", [context])

    @jsii.member(jsii_name="header")
    @builtins.classmethod
    def header(cls, header_name: builtins.str) -> builtins.str:
        """(experimental) Provides a properly formatted header identity source.

        :param header_name: the name of the header the ``IdentitySource`` will represent.

        :return: a header identity source.

        :stability: experimental
        """
        return jsii.sinvoke(cls, "header", [header_name])

    @jsii.member(jsii_name="queryString")
    @builtins.classmethod
    def query_string(cls, query_string: builtins.str) -> builtins.str:
        """(experimental) Provides a properly formatted query string identity source.

        :param query_string: the name of the query string the ``IdentitySource`` will represent.

        :return: a query string identity source.

        :stability: experimental
        """
        return jsii.sinvoke(cls, "queryString", [query_string])

    @jsii.member(jsii_name="stageVariable")
    @builtins.classmethod
    def stage_variable(cls, stage_variable: builtins.str) -> builtins.str:
        """(experimental) Provides a properly formatted API Gateway stage variable identity source.

        :param stage_variable: the name of the stage variable the ``IdentitySource`` will represent.

        :return: an API Gateway stage variable identity source.

        :stability: experimental
        """
        return jsii.sinvoke(cls, "stageVariable", [stage_variable])


class InlineApiDefinition(
    ApiDefinition,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_apigateway.InlineApiDefinition",
):
    """(experimental) OpenAPI specification from an inline JSON object.

    :stability: experimental
    """

    def __init__(self, definition: typing.Any) -> None:
        """
        :param definition: -

        :stability: experimental
        """
        jsii.create(InlineApiDefinition, self, [definition])

    @jsii.member(jsii_name="bind")
    def bind(self, _scope: _Construct_e78e779f) -> ApiDefinitionConfig:
        """(experimental) Called when the specification is initialized to allow this object to bind to the stack, add resources and have fun.

        :param _scope: -

        :stability: experimental
        """
        return jsii.invoke(self, "bind", [_scope])


class Integration(
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_apigateway.Integration",
):
    """(experimental) Base class for backend integrations for an API Gateway method.

    Use one of the concrete classes such as ``MockIntegration``, ``AwsIntegration``, ``LambdaIntegration``
    or implement on your own by specifying the set of props.

    :stability: experimental
    """

    def __init__(
        self,
        *,
        type: "IntegrationType",
        integration_http_method: typing.Optional[builtins.str] = None,
        options: typing.Optional["IntegrationOptions"] = None,
        uri: typing.Any = None,
    ) -> None:
        """
        :param type: (experimental) Specifies an API method integration type.
        :param integration_http_method: (experimental) The integration's HTTP method type. Required unless you use a MOCK integration.
        :param options: (experimental) Integration options.
        :param uri: (experimental) The Uniform Resource Identifier (URI) for the integration. - If you specify HTTP for the ``type`` property, specify the API endpoint URL. - If you specify MOCK for the ``type`` property, don't specify this property. - If you specify AWS for the ``type`` property, specify an AWS service that follows this form: ``arn:partition:apigateway:region:subdomain.service|service:path|action/service_api.`` For example, a Lambda function URI follows this form: arn:partition:apigateway:region:lambda:path/path. The path is usually in the form /2015-03-31/functions/LambdaFunctionARN/invocations.

        :stability: experimental
        """
        props = IntegrationProps(
            type=type,
            integration_http_method=integration_http_method,
            options=options,
            uri=uri,
        )

        jsii.create(Integration, self, [props])

    @jsii.member(jsii_name="bind")
    def bind(self, _method: "Method") -> "IntegrationConfig":
        """(experimental) Can be overridden by subclasses to allow the integration to interact with the method being integrated, access the REST API object, method ARNs, etc.

        :param _method: -

        :stability: experimental
        """
        return jsii.invoke(self, "bind", [_method])


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.IntegrationConfig",
    jsii_struct_bases=[],
    name_mapping={
        "type": "type",
        "deployment_token": "deploymentToken",
        "integration_http_method": "integrationHttpMethod",
        "options": "options",
        "uri": "uri",
    },
)
class IntegrationConfig:
    def __init__(
        self,
        *,
        type: "IntegrationType",
        deployment_token: typing.Optional[builtins.str] = None,
        integration_http_method: typing.Optional[builtins.str] = None,
        options: typing.Optional["IntegrationOptions"] = None,
        uri: typing.Optional[builtins.str] = None,
    ) -> None:
        """(experimental) Result of binding an Integration to a Method.

        :param type: (experimental) Specifies an API method integration type.
        :param deployment_token: (experimental) This value is included in computing the Deployment's fingerprint. When the fingerprint changes, a new deployment is triggered. This property should contain values associated with the Integration that upon changing should trigger a fresh the Deployment needs to be refreshed. Default: undefined deployments are not triggered for any change to this integration.
        :param integration_http_method: (experimental) The integration's HTTP method type. Default: - no integration method specified.
        :param options: (experimental) Integration options. Default: - no integration options
        :param uri: (experimental) The Uniform Resource Identifier (URI) for the integration. Default: - no URI. Usually applies to MOCK integration

        :stability: experimental
        """
        if isinstance(options, dict):
            options = IntegrationOptions(**options)
        self._values: typing.Dict[str, typing.Any] = {
            "type": type,
        }
        if deployment_token is not None:
            self._values["deployment_token"] = deployment_token
        if integration_http_method is not None:
            self._values["integration_http_method"] = integration_http_method
        if options is not None:
            self._values["options"] = options
        if uri is not None:
            self._values["uri"] = uri

    @builtins.property
    def type(self) -> "IntegrationType":
        """(experimental) Specifies an API method integration type.

        :stability: experimental
        """
        result = self._values.get("type")
        assert result is not None, "Required property 'type' is missing"
        return result

    @builtins.property
    def deployment_token(self) -> typing.Optional[builtins.str]:
        """(experimental) This value is included in computing the Deployment's fingerprint.

        When the fingerprint
        changes, a new deployment is triggered.
        This property should contain values associated with the Integration that upon changing
        should trigger a fresh the Deployment needs to be refreshed.

        :default: undefined deployments are not triggered for any change to this integration.

        :stability: experimental
        """
        result = self._values.get("deployment_token")
        return result

    @builtins.property
    def integration_http_method(self) -> typing.Optional[builtins.str]:
        """(experimental) The integration's HTTP method type.

        :default: - no integration method specified.

        :stability: experimental
        """
        result = self._values.get("integration_http_method")
        return result

    @builtins.property
    def options(self) -> typing.Optional["IntegrationOptions"]:
        """(experimental) Integration options.

        :default: - no integration options

        :stability: experimental
        """
        result = self._values.get("options")
        return result

    @builtins.property
    def uri(self) -> typing.Optional[builtins.str]:
        """(experimental) The Uniform Resource Identifier (URI) for the integration.

        :default: - no URI. Usually applies to MOCK integration

        :see: https://docs.aws.amazon.com/apigateway/api-reference/resource/integration/#uri
        :stability: experimental
        """
        result = self._values.get("uri")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "IntegrationConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.IntegrationOptions",
    jsii_struct_bases=[],
    name_mapping={
        "cache_key_parameters": "cacheKeyParameters",
        "cache_namespace": "cacheNamespace",
        "connection_type": "connectionType",
        "content_handling": "contentHandling",
        "credentials_passthrough": "credentialsPassthrough",
        "credentials_role": "credentialsRole",
        "integration_responses": "integrationResponses",
        "passthrough_behavior": "passthroughBehavior",
        "request_parameters": "requestParameters",
        "request_templates": "requestTemplates",
        "vpc_link": "vpcLink",
    },
)
class IntegrationOptions:
    def __init__(
        self,
        *,
        cache_key_parameters: typing.Optional[typing.List[builtins.str]] = None,
        cache_namespace: typing.Optional[builtins.str] = None,
        connection_type: typing.Optional[ConnectionType] = None,
        content_handling: typing.Optional[ContentHandling] = None,
        credentials_passthrough: typing.Optional[builtins.bool] = None,
        credentials_role: typing.Optional[_IRole_59af6f50] = None,
        integration_responses: typing.Optional[typing.List["IntegrationResponse"]] = None,
        passthrough_behavior: typing.Optional["PassthroughBehavior"] = None,
        request_parameters: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        request_templates: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        vpc_link: typing.Optional[IVpcLink] = None,
    ) -> None:
        """
        :param cache_key_parameters: (experimental) A list of request parameters whose values are to be cached. It determines request parameters that will make it into the cache key.
        :param cache_namespace: (experimental) An API-specific tag group of related cached parameters.
        :param connection_type: (experimental) The type of network connection to the integration endpoint. Default: - ConnectionType.VPC_LINK if ``vpcLink`` property is configured; ConnectionType.Internet otherwise.
        :param content_handling: (experimental) Specifies how to handle request payload content type conversions. Default: none if this property isn't defined, the request payload is passed through from the method request to the integration request without modification, provided that the ``passthroughBehaviors`` property is configured to support payload pass-through.
        :param credentials_passthrough: (experimental) Requires that the caller's identity be passed through from the request. Default: Caller identity is not passed through
        :param credentials_role: (experimental) An IAM role that API Gateway assumes. Mutually exclusive with ``credentialsPassThrough``. Default: A role is not assumed
        :param integration_responses: (experimental) The response that API Gateway provides after a method's backend completes processing a request. API Gateway intercepts the response from the backend so that you can control how API Gateway surfaces backend responses. For example, you can map the backend status codes to codes that you define.
        :param passthrough_behavior: (experimental) Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource. There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER.
        :param request_parameters: (experimental) The request parameters that API Gateway sends with the backend request. Specify request parameters as key-value pairs (string-to-string mappings), with a destination as the key and a source as the value. Specify the destination by using the following pattern integration.request.location.name, where location is querystring, path, or header, and name is a valid, unique parameter name. The source must be an existing method request parameter or a static value. You must enclose static values in single quotation marks and pre-encode these values based on their destination in the request.
        :param request_templates: (experimental) A map of Apache Velocity templates that are applied on the request payload. The template that API Gateway uses is based on the value of the Content-Type header that's sent by the client. The content type value is the key, and the template is the value (specified as a string), such as the following snippet:: { "application/json": "{ \\"statusCode\\": 200 }" }
        :param vpc_link: (experimental) The VpcLink used for the integration. Required if connectionType is VPC_LINK

        :stability: experimental
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if cache_key_parameters is not None:
            self._values["cache_key_parameters"] = cache_key_parameters
        if cache_namespace is not None:
            self._values["cache_namespace"] = cache_namespace
        if connection_type is not None:
            self._values["connection_type"] = connection_type
        if content_handling is not None:
            self._values["content_handling"] = content_handling
        if credentials_passthrough is not None:
            self._values["credentials_passthrough"] = credentials_passthrough
        if credentials_role is not None:
            self._values["credentials_role"] = credentials_role
        if integration_responses is not None:
            self._values["integration_responses"] = integration_responses
        if passthrough_behavior is not None:
            self._values["passthrough_behavior"] = passthrough_behavior
        if request_parameters is not None:
            self._values["request_parameters"] = request_parameters
        if request_templates is not None:
            self._values["request_templates"] = request_templates
        if vpc_link is not None:
            self._values["vpc_link"] = vpc_link

    @builtins.property
    def cache_key_parameters(self) -> typing.Optional[typing.List[builtins.str]]:
        """(experimental) A list of request parameters whose values are to be cached.

        It determines
        request parameters that will make it into the cache key.

        :stability: experimental
        """
        result = self._values.get("cache_key_parameters")
        return result

    @builtins.property
    def cache_namespace(self) -> typing.Optional[builtins.str]:
        """(experimental) An API-specific tag group of related cached parameters.

        :stability: experimental
        """
        result = self._values.get("cache_namespace")
        return result

    @builtins.property
    def connection_type(self) -> typing.Optional[ConnectionType]:
        """(experimental) The type of network connection to the integration endpoint.

        :default: - ConnectionType.VPC_LINK if ``vpcLink`` property is configured; ConnectionType.Internet otherwise.

        :stability: experimental
        """
        result = self._values.get("connection_type")
        return result

    @builtins.property
    def content_handling(self) -> typing.Optional[ContentHandling]:
        """(experimental) Specifies how to handle request payload content type conversions.

        :default:

        none if this property isn't defined, the request payload is passed
        through from the method request to the integration request without
        modification, provided that the ``passthroughBehaviors`` property is
        configured to support payload pass-through.

        :stability: experimental
        """
        result = self._values.get("content_handling")
        return result

    @builtins.property
    def credentials_passthrough(self) -> typing.Optional[builtins.bool]:
        """(experimental) Requires that the caller's identity be passed through from the request.

        :default: Caller identity is not passed through

        :stability: experimental
        """
        result = self._values.get("credentials_passthrough")
        return result

    @builtins.property
    def credentials_role(self) -> typing.Optional[_IRole_59af6f50]:
        """(experimental) An IAM role that API Gateway assumes.

        Mutually exclusive with ``credentialsPassThrough``.

        :default: A role is not assumed

        :stability: experimental
        """
        result = self._values.get("credentials_role")
        return result

    @builtins.property
    def integration_responses(
        self,
    ) -> typing.Optional[typing.List["IntegrationResponse"]]:
        """(experimental) The response that API Gateway provides after a method's backend completes processing a request.

        API Gateway intercepts the response from the
        backend so that you can control how API Gateway surfaces backend
        responses. For example, you can map the backend status codes to codes
        that you define.

        :stability: experimental
        """
        result = self._values.get("integration_responses")
        return result

    @builtins.property
    def passthrough_behavior(self) -> typing.Optional["PassthroughBehavior"]:
        """(experimental) Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource.

        There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and
        NEVER.

        :stability: experimental
        """
        result = self._values.get("passthrough_behavior")
        return result

    @builtins.property
    def request_parameters(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        """(experimental) The request parameters that API Gateway sends with the backend request.

        Specify request parameters as key-value pairs (string-to-string
        mappings), with a destination as the key and a source as the value.

        Specify the destination by using the following pattern
        integration.request.location.name, where location is querystring, path,
        or header, and name is a valid, unique parameter name.

        The source must be an existing method request parameter or a static
        value. You must enclose static values in single quotation marks and
        pre-encode these values based on their destination in the request.

        :stability: experimental
        """
        result = self._values.get("request_parameters")
        return result

    @builtins.property
    def request_templates(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        """(experimental) A map of Apache Velocity templates that are applied on the request payload.

        The template that API Gateway uses is based on the value of the
        Content-Type header that's sent by the client. The content type value is
        the key, and the template is the value (specified as a string), such as
        the following snippet::

              { "application/json": "{ \\"statusCode\\": 200 }" }

        :see: http://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html
        :stability: experimental
        """
        result = self._values.get("request_templates")
        return result

    @builtins.property
    def vpc_link(self) -> typing.Optional[IVpcLink]:
        """(experimental) The VpcLink used for the integration.

        Required if connectionType is VPC_LINK

        :stability: experimental
        """
        result = self._values.get("vpc_link")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "IntegrationOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.IntegrationProps",
    jsii_struct_bases=[],
    name_mapping={
        "type": "type",
        "integration_http_method": "integrationHttpMethod",
        "options": "options",
        "uri": "uri",
    },
)
class IntegrationProps:
    def __init__(
        self,
        *,
        type: "IntegrationType",
        integration_http_method: typing.Optional[builtins.str] = None,
        options: typing.Optional[IntegrationOptions] = None,
        uri: typing.Any = None,
    ) -> None:
        """
        :param type: (experimental) Specifies an API method integration type.
        :param integration_http_method: (experimental) The integration's HTTP method type. Required unless you use a MOCK integration.
        :param options: (experimental) Integration options.
        :param uri: (experimental) The Uniform Resource Identifier (URI) for the integration. - If you specify HTTP for the ``type`` property, specify the API endpoint URL. - If you specify MOCK for the ``type`` property, don't specify this property. - If you specify AWS for the ``type`` property, specify an AWS service that follows this form: ``arn:partition:apigateway:region:subdomain.service|service:path|action/service_api.`` For example, a Lambda function URI follows this form: arn:partition:apigateway:region:lambda:path/path. The path is usually in the form /2015-03-31/functions/LambdaFunctionARN/invocations.

        :stability: experimental
        """
        if isinstance(options, dict):
            options = IntegrationOptions(**options)
        self._values: typing.Dict[str, typing.Any] = {
            "type": type,
        }
        if integration_http_method is not None:
            self._values["integration_http_method"] = integration_http_method
        if options is not None:
            self._values["options"] = options
        if uri is not None:
            self._values["uri"] = uri

    @builtins.property
    def type(self) -> "IntegrationType":
        """(experimental) Specifies an API method integration type.

        :stability: experimental
        """
        result = self._values.get("type")
        assert result is not None, "Required property 'type' is missing"
        return result

    @builtins.property
    def integration_http_method(self) -> typing.Optional[builtins.str]:
        """(experimental) The integration's HTTP method type.

        Required unless you use a MOCK integration.

        :stability: experimental
        """
        result = self._values.get("integration_http_method")
        return result

    @builtins.property
    def options(self) -> typing.Optional[IntegrationOptions]:
        """(experimental) Integration options.

        :stability: experimental
        """
        result = self._values.get("options")
        return result

    @builtins.property
    def uri(self) -> typing.Any:
        """(experimental) The Uniform Resource Identifier (URI) for the integration.

        - If you specify HTTP for the ``type`` property, specify the API endpoint URL.
        - If you specify MOCK for the ``type`` property, don't specify this property.
        - If you specify AWS for the ``type`` property, specify an AWS service that
          follows this form: ``arn:partition:apigateway:region:subdomain.service|service:path|action/service_api.``
          For example, a Lambda function URI follows this form:
          arn:partition:apigateway:region:lambda:path/path. The path is usually in the
          form /2015-03-31/functions/LambdaFunctionARN/invocations.

        :see: https://docs.aws.amazon.com/apigateway/api-reference/resource/integration/#uri
        :stability: experimental
        """
        result = self._values.get("uri")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "IntegrationProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.IntegrationResponse",
    jsii_struct_bases=[],
    name_mapping={
        "status_code": "statusCode",
        "content_handling": "contentHandling",
        "response_parameters": "responseParameters",
        "response_templates": "responseTemplates",
        "selection_pattern": "selectionPattern",
    },
)
class IntegrationResponse:
    def __init__(
        self,
        *,
        status_code: builtins.str,
        content_handling: typing.Optional[ContentHandling] = None,
        response_parameters: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        response_templates: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        selection_pattern: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param status_code: (experimental) The status code that API Gateway uses to map the integration response to a MethodResponse status code.
        :param content_handling: (experimental) Specifies how to handle request payload content type conversions. Default: none the request payload is passed through from the method request to the integration request without modification.
        :param response_parameters: (experimental) The response parameters from the backend response that API Gateway sends to the method response. Use the destination as the key and the source as the value: - The destination must be an existing response parameter in the MethodResponse property. - The source must be an existing method request parameter or a static value. You must enclose static values in single quotation marks and pre-encode these values based on the destination specified in the request.
        :param response_templates: (experimental) The templates that are used to transform the integration response body. Specify templates as key-value pairs, with a content type as the key and a template as the value.
        :param selection_pattern: (experimental) Specifies the regular expression (regex) pattern used to choose an integration response based on the response from the back end. For example, if the success response returns nothing and the error response returns some string, you could use the ``.+`` regex to match error response. However, make sure that the error response does not contain any newline (``\\n``) character in such cases. If the back end is an AWS Lambda function, the AWS Lambda function error header is matched. For all other HTTP and AWS back ends, the HTTP status code is matched.

        :stability: experimental
        """
        self._values: typing.Dict[str, typing.Any] = {
            "status_code": status_code,
        }
        if content_handling is not None:
            self._values["content_handling"] = content_handling
        if response_parameters is not None:
            self._values["response_parameters"] = response_parameters
        if response_templates is not None:
            self._values["response_templates"] = response_templates
        if selection_pattern is not None:
            self._values["selection_pattern"] = selection_pattern

    @builtins.property
    def status_code(self) -> builtins.str:
        """(experimental) The status code that API Gateway uses to map the integration response to a MethodResponse status code.

        :stability: experimental
        """
        result = self._values.get("status_code")
        assert result is not None, "Required property 'status_code' is missing"
        return result

    @builtins.property
    def content_handling(self) -> typing.Optional[ContentHandling]:
        """(experimental) Specifies how to handle request payload content type conversions.

        :default:

        none the request payload is passed through from the method
        request to the integration request without modification.

        :stability: experimental
        """
        result = self._values.get("content_handling")
        return result

    @builtins.property
    def response_parameters(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        """(experimental) The response parameters from the backend response that API Gateway sends to the method response.

        Use the destination as the key and the source as the value:

        - The destination must be an existing response parameter in the
          MethodResponse property.
        - The source must be an existing method request parameter or a static
          value. You must enclose static values in single quotation marks and
          pre-encode these values based on the destination specified in the
          request.

        :see: http://docs.aws.amazon.com/apigateway/latest/developerguide/request-response-data-mappings.html
        :stability: experimental
        """
        result = self._values.get("response_parameters")
        return result

    @builtins.property
    def response_templates(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        """(experimental) The templates that are used to transform the integration response body.

        Specify templates as key-value pairs, with a content type as the key and
        a template as the value.

        :see: http://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html
        :stability: experimental
        """
        result = self._values.get("response_templates")
        return result

    @builtins.property
    def selection_pattern(self) -> typing.Optional[builtins.str]:
        """(experimental) Specifies the regular expression (regex) pattern used to choose an integration response based on the response from the back end.

        For example, if the success response returns nothing and the error response returns some string, you
        could use the ``.+`` regex to match error response. However, make sure that the error response does not contain any
        newline (``\\n``) character in such cases. If the back end is an AWS Lambda function, the AWS Lambda function error
        header is matched. For all other HTTP and AWS back ends, the HTTP status code is matched.

        :see: https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-integration-settings-integration-response.html
        :stability: experimental
        """
        result = self._values.get("selection_pattern")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "IntegrationResponse(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="monocdk.aws_apigateway.IntegrationType")
class IntegrationType(enum.Enum):
    """
    :stability: experimental
    """

    AWS = "AWS"
    """(experimental) For integrating the API method request with an AWS service action, including the Lambda function-invoking action.

    With the Lambda
    function-invoking action, this is referred to as the Lambda custom
    integration. With any other AWS service action, this is known as AWS
    integration.

    :stability: experimental
    """
    AWS_PROXY = "AWS_PROXY"
    """(experimental) For integrating the API method request with the Lambda function-invoking action with the client request passed through as-is.

    This integration is
    also referred to as the Lambda proxy integration

    :stability: experimental
    """
    HTTP = "HTTP"
    """(experimental) For integrating the API method request with an HTTP endpoint, including a private HTTP endpoint within a VPC.

    This integration is also referred to
    as the HTTP custom integration.

    :stability: experimental
    """
    HTTP_PROXY = "HTTP_PROXY"
    """(experimental) For integrating the API method request with an HTTP endpoint, including a private HTTP endpoint within a VPC, with the client request passed through as-is.

    This is also referred to as the HTTP proxy integration

    :stability: experimental
    """
    MOCK = "MOCK"
    """(experimental) For integrating the API method request with API Gateway as a "loop-back" endpoint without invoking any backend.

    :stability: experimental
    """


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.JsonSchema",
    jsii_struct_bases=[],
    name_mapping={
        "additional_items": "additionalItems",
        "additional_properties": "additionalProperties",
        "all_of": "allOf",
        "any_of": "anyOf",
        "contains": "contains",
        "definitions": "definitions",
        "dependencies": "dependencies",
        "description": "description",
        "enum": "enum",
        "exclusive_maximum": "exclusiveMaximum",
        "exclusive_minimum": "exclusiveMinimum",
        "format": "format",
        "id": "id",
        "items": "items",
        "maximum": "maximum",
        "max_items": "maxItems",
        "max_length": "maxLength",
        "max_properties": "maxProperties",
        "minimum": "minimum",
        "min_items": "minItems",
        "min_length": "minLength",
        "min_properties": "minProperties",
        "multiple_of": "multipleOf",
        "not_": "not",
        "one_of": "oneOf",
        "pattern": "pattern",
        "pattern_properties": "patternProperties",
        "properties": "properties",
        "property_names": "propertyNames",
        "ref": "ref",
        "required": "required",
        "schema": "schema",
        "title": "title",
        "type": "type",
        "unique_items": "uniqueItems",
    },
)
class JsonSchema:
    def __init__(
        self,
        *,
        additional_items: typing.Optional[typing.List["JsonSchema"]] = None,
        additional_properties: typing.Optional[typing.Union[builtins.bool, "JsonSchema"]] = None,
        all_of: typing.Optional[typing.List["JsonSchema"]] = None,
        any_of: typing.Optional[typing.List["JsonSchema"]] = None,
        contains: typing.Optional[typing.Union["JsonSchema", typing.List["JsonSchema"]]] = None,
        definitions: typing.Optional[typing.Mapping[builtins.str, "JsonSchema"]] = None,
        dependencies: typing.Optional[typing.Mapping[builtins.str, typing.Union["JsonSchema", typing.List[builtins.str]]]] = None,
        description: typing.Optional[builtins.str] = None,
        enum: typing.Optional[typing.List[typing.Any]] = None,
        exclusive_maximum: typing.Optional[builtins.bool] = None,
        exclusive_minimum: typing.Optional[builtins.bool] = None,
        format: typing.Optional[builtins.str] = None,
        id: typing.Optional[builtins.str] = None,
        items: typing.Optional[typing.Union["JsonSchema", typing.List["JsonSchema"]]] = None,
        maximum: typing.Optional[jsii.Number] = None,
        max_items: typing.Optional[jsii.Number] = None,
        max_length: typing.Optional[jsii.Number] = None,
        max_properties: typing.Optional[jsii.Number] = None,
        minimum: typing.Optional[jsii.Number] = None,
        min_items: typing.Optional[jsii.Number] = None,
        min_length: typing.Optional[jsii.Number] = None,
        min_properties: typing.Optional[jsii.Number] = None,
        multiple_of: typing.Optional[jsii.Number] = None,
        not_: typing.Optional["JsonSchema"] = None,
        one_of: typing.Optional[typing.List["JsonSchema"]] = None,
        pattern: typing.Optional[builtins.str] = None,
        pattern_properties: typing.Optional[typing.Mapping[builtins.str, "JsonSchema"]] = None,
        properties: typing.Optional[typing.Mapping[builtins.str, "JsonSchema"]] = None,
        property_names: typing.Optional["JsonSchema"] = None,
        ref: typing.Optional[builtins.str] = None,
        required: typing.Optional[typing.List[builtins.str]] = None,
        schema: typing.Optional["JsonSchemaVersion"] = None,
        title: typing.Optional[builtins.str] = None,
        type: typing.Optional[typing.Union["JsonSchemaType", typing.List["JsonSchemaType"]]] = None,
        unique_items: typing.Optional[builtins.bool] = None,
    ) -> None:
        """(experimental) Represents a JSON schema definition of the structure of a REST API model.

        Copied from npm module jsonschema.

        :param additional_items: 
        :param additional_properties: 
        :param all_of: 
        :param any_of: 
        :param contains: 
        :param definitions: 
        :param dependencies: 
        :param description: 
        :param enum: 
        :param exclusive_maximum: 
        :param exclusive_minimum: 
        :param format: 
        :param id: 
        :param items: 
        :param maximum: 
        :param max_items: 
        :param max_length: 
        :param max_properties: 
        :param minimum: 
        :param min_items: 
        :param min_length: 
        :param min_properties: 
        :param multiple_of: 
        :param not_: 
        :param one_of: 
        :param pattern: 
        :param pattern_properties: 
        :param properties: 
        :param property_names: 
        :param ref: 
        :param required: 
        :param schema: 
        :param title: 
        :param type: 
        :param unique_items: 

        :see: https://github.com/tdegrunt/jsonschema
        :stability: experimental
        """
        if isinstance(not_, dict):
            not_ = JsonSchema(**not_)
        if isinstance(property_names, dict):
            property_names = JsonSchema(**property_names)
        self._values: typing.Dict[str, typing.Any] = {}
        if additional_items is not None:
            self._values["additional_items"] = additional_items
        if additional_properties is not None:
            self._values["additional_properties"] = additional_properties
        if all_of is not None:
            self._values["all_of"] = all_of
        if any_of is not None:
            self._values["any_of"] = any_of
        if contains is not None:
            self._values["contains"] = contains
        if definitions is not None:
            self._values["definitions"] = definitions
        if dependencies is not None:
            self._values["dependencies"] = dependencies
        if description is not None:
            self._values["description"] = description
        if enum is not None:
            self._values["enum"] = enum
        if exclusive_maximum is not None:
            self._values["exclusive_maximum"] = exclusive_maximum
        if exclusive_minimum is not None:
            self._values["exclusive_minimum"] = exclusive_minimum
        if format is not None:
            self._values["format"] = format
        if id is not None:
            self._values["id"] = id
        if items is not None:
            self._values["items"] = items
        if maximum is not None:
            self._values["maximum"] = maximum
        if max_items is not None:
            self._values["max_items"] = max_items
        if max_length is not None:
            self._values["max_length"] = max_length
        if max_properties is not None:
            self._values["max_properties"] = max_properties
        if minimum is not None:
            self._values["minimum"] = minimum
        if min_items is not None:
            self._values["min_items"] = min_items
        if min_length is not None:
            self._values["min_length"] = min_length
        if min_properties is not None:
            self._values["min_properties"] = min_properties
        if multiple_of is not None:
            self._values["multiple_of"] = multiple_of
        if not_ is not None:
            self._values["not_"] = not_
        if one_of is not None:
            self._values["one_of"] = one_of
        if pattern is not None:
            self._values["pattern"] = pattern
        if pattern_properties is not None:
            self._values["pattern_properties"] = pattern_properties
        if properties is not None:
            self._values["properties"] = properties
        if property_names is not None:
            self._values["property_names"] = property_names
        if ref is not None:
            self._values["ref"] = ref
        if required is not None:
            self._values["required"] = required
        if schema is not None:
            self._values["schema"] = schema
        if title is not None:
            self._values["title"] = title
        if type is not None:
            self._values["type"] = type
        if unique_items is not None:
            self._values["unique_items"] = unique_items

    @builtins.property
    def additional_items(self) -> typing.Optional[typing.List["JsonSchema"]]:
        """
        :stability: experimental
        """
        result = self._values.get("additional_items")
        return result

    @builtins.property
    def additional_properties(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, "JsonSchema"]]:
        """
        :stability: experimental
        """
        result = self._values.get("additional_properties")
        return result

    @builtins.property
    def all_of(self) -> typing.Optional[typing.List["JsonSchema"]]:
        """
        :stability: experimental
        """
        result = self._values.get("all_of")
        return result

    @builtins.property
    def any_of(self) -> typing.Optional[typing.List["JsonSchema"]]:
        """
        :stability: experimental
        """
        result = self._values.get("any_of")
        return result

    @builtins.property
    def contains(
        self,
    ) -> typing.Optional[typing.Union["JsonSchema", typing.List["JsonSchema"]]]:
        """
        :stability: experimental
        """
        result = self._values.get("contains")
        return result

    @builtins.property
    def definitions(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, "JsonSchema"]]:
        """
        :stability: experimental
        """
        result = self._values.get("definitions")
        return result

    @builtins.property
    def dependencies(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, typing.Union["JsonSchema", typing.List[builtins.str]]]]:
        """
        :stability: experimental
        """
        result = self._values.get("dependencies")
        return result

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        """
        :stability: experimental
        """
        result = self._values.get("description")
        return result

    @builtins.property
    def enum(self) -> typing.Optional[typing.List[typing.Any]]:
        """
        :stability: experimental
        """
        result = self._values.get("enum")
        return result

    @builtins.property
    def exclusive_maximum(self) -> typing.Optional[builtins.bool]:
        """
        :stability: experimental
        """
        result = self._values.get("exclusive_maximum")
        return result

    @builtins.property
    def exclusive_minimum(self) -> typing.Optional[builtins.bool]:
        """
        :stability: experimental
        """
        result = self._values.get("exclusive_minimum")
        return result

    @builtins.property
    def format(self) -> typing.Optional[builtins.str]:
        """
        :stability: experimental
        """
        result = self._values.get("format")
        return result

    @builtins.property
    def id(self) -> typing.Optional[builtins.str]:
        """
        :stability: experimental
        """
        result = self._values.get("id")
        return result

    @builtins.property
    def items(
        self,
    ) -> typing.Optional[typing.Union["JsonSchema", typing.List["JsonSchema"]]]:
        """
        :stability: experimental
        """
        result = self._values.get("items")
        return result

    @builtins.property
    def maximum(self) -> typing.Optional[jsii.Number]:
        """
        :stability: experimental
        """
        result = self._values.get("maximum")
        return result

    @builtins.property
    def max_items(self) -> typing.Optional[jsii.Number]:
        """
        :stability: experimental
        """
        result = self._values.get("max_items")
        return result

    @builtins.property
    def max_length(self) -> typing.Optional[jsii.Number]:
        """
        :stability: experimental
        """
        result = self._values.get("max_length")
        return result

    @builtins.property
    def max_properties(self) -> typing.Optional[jsii.Number]:
        """
        :stability: experimental
        """
        result = self._values.get("max_properties")
        return result

    @builtins.property
    def minimum(self) -> typing.Optional[jsii.Number]:
        """
        :stability: experimental
        """
        result = self._values.get("minimum")
        return result

    @builtins.property
    def min_items(self) -> typing.Optional[jsii.Number]:
        """
        :stability: experimental
        """
        result = self._values.get("min_items")
        return result

    @builtins.property
    def min_length(self) -> typing.Optional[jsii.Number]:
        """
        :stability: experimental
        """
        result = self._values.get("min_length")
        return result

    @builtins.property
    def min_properties(self) -> typing.Optional[jsii.Number]:
        """
        :stability: experimental
        """
        result = self._values.get("min_properties")
        return result

    @builtins.property
    def multiple_of(self) -> typing.Optional[jsii.Number]:
        """
        :stability: experimental
        """
        result = self._values.get("multiple_of")
        return result

    @builtins.property
    def not_(self) -> typing.Optional["JsonSchema"]:
        """
        :stability: experimental
        """
        result = self._values.get("not_")
        return result

    @builtins.property
    def one_of(self) -> typing.Optional[typing.List["JsonSchema"]]:
        """
        :stability: experimental
        """
        result = self._values.get("one_of")
        return result

    @builtins.property
    def pattern(self) -> typing.Optional[builtins.str]:
        """
        :stability: experimental
        """
        result = self._values.get("pattern")
        return result

    @builtins.property
    def pattern_properties(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, "JsonSchema"]]:
        """
        :stability: experimental
        """
        result = self._values.get("pattern_properties")
        return result

    @builtins.property
    def properties(self) -> typing.Optional[typing.Mapping[builtins.str, "JsonSchema"]]:
        """
        :stability: experimental
        """
        result = self._values.get("properties")
        return result

    @builtins.property
    def property_names(self) -> typing.Optional["JsonSchema"]:
        """
        :stability: experimental
        """
        result = self._values.get("property_names")
        return result

    @builtins.property
    def ref(self) -> typing.Optional[builtins.str]:
        """
        :stability: experimental
        """
        result = self._values.get("ref")
        return result

    @builtins.property
    def required(self) -> typing.Optional[typing.List[builtins.str]]:
        """
        :stability: experimental
        """
        result = self._values.get("required")
        return result

    @builtins.property
    def schema(self) -> typing.Optional["JsonSchemaVersion"]:
        """
        :stability: experimental
        """
        result = self._values.get("schema")
        return result

    @builtins.property
    def title(self) -> typing.Optional[builtins.str]:
        """
        :stability: experimental
        """
        result = self._values.get("title")
        return result

    @builtins.property
    def type(
        self,
    ) -> typing.Optional[typing.Union["JsonSchemaType", typing.List["JsonSchemaType"]]]:
        """
        :stability: experimental
        """
        result = self._values.get("type")
        return result

    @builtins.property
    def unique_items(self) -> typing.Optional[builtins.bool]:
        """
        :stability: experimental
        """
        result = self._values.get("unique_items")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "JsonSchema(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="monocdk.aws_apigateway.JsonSchemaType")
class JsonSchemaType(enum.Enum):
    """
    :stability: experimental
    """

    NULL = "NULL"
    """
    :stability: experimental
    """
    BOOLEAN = "BOOLEAN"
    """
    :stability: experimental
    """
    OBJECT = "OBJECT"
    """
    :stability: experimental
    """
    ARRAY = "ARRAY"
    """
    :stability: experimental
    """
    NUMBER = "NUMBER"
    """
    :stability: experimental
    """
    INTEGER = "INTEGER"
    """
    :stability: experimental
    """
    STRING = "STRING"
    """
    :stability: experimental
    """


@jsii.enum(jsii_type="monocdk.aws_apigateway.JsonSchemaVersion")
class JsonSchemaVersion(enum.Enum):
    """
    :stability: experimental
    """

    DRAFT4 = "DRAFT4"
    """(experimental) In API Gateway models are defined using the JSON schema draft 4.

    :see: https://tools.ietf.org/html/draft-zyp-json-schema-04
    :stability: experimental
    """
    DRAFT7 = "DRAFT7"
    """
    :stability: experimental
    """


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.JsonWithStandardFieldProps",
    jsii_struct_bases=[],
    name_mapping={
        "caller": "caller",
        "http_method": "httpMethod",
        "ip": "ip",
        "protocol": "protocol",
        "request_time": "requestTime",
        "resource_path": "resourcePath",
        "response_length": "responseLength",
        "status": "status",
        "user": "user",
    },
)
class JsonWithStandardFieldProps:
    def __init__(
        self,
        *,
        caller: builtins.bool,
        http_method: builtins.bool,
        ip: builtins.bool,
        protocol: builtins.bool,
        request_time: builtins.bool,
        resource_path: builtins.bool,
        response_length: builtins.bool,
        status: builtins.bool,
        user: builtins.bool,
    ) -> None:
        """(experimental) Properties for controlling items output in JSON standard format.

        :param caller: (experimental) If this flag is enabled, the principal identifier of the caller will be output to the log.
        :param http_method: (experimental) If this flag is enabled, the http method will be output to the log.
        :param ip: (experimental) If this flag is enabled, the source IP of request will be output to the log.
        :param protocol: (experimental) If this flag is enabled, the request protocol will be output to the log.
        :param request_time: (experimental) If this flag is enabled, the CLF-formatted request time((dd/MMM/yyyy:HH:mm:ss +-hhmm) will be output to the log.
        :param resource_path: (experimental) If this flag is enabled, the path to your resource will be output to the log.
        :param response_length: (experimental) If this flag is enabled, the response payload length will be output to the log.
        :param status: (experimental) If this flag is enabled, the method response status will be output to the log.
        :param user: (experimental) If this flag is enabled, the principal identifier of the user will be output to the log.

        :stability: experimental
        """
        self._values: typing.Dict[str, typing.Any] = {
            "caller": caller,
            "http_method": http_method,
            "ip": ip,
            "protocol": protocol,
            "request_time": request_time,
            "resource_path": resource_path,
            "response_length": response_length,
            "status": status,
            "user": user,
        }

    @builtins.property
    def caller(self) -> builtins.bool:
        """(experimental) If this flag is enabled, the principal identifier of the caller will be output to the log.

        :stability: experimental
        """
        result = self._values.get("caller")
        assert result is not None, "Required property 'caller' is missing"
        return result

    @builtins.property
    def http_method(self) -> builtins.bool:
        """(experimental) If this flag is enabled, the http method will be output to the log.

        :stability: experimental
        """
        result = self._values.get("http_method")
        assert result is not None, "Required property 'http_method' is missing"
        return result

    @builtins.property
    def ip(self) -> builtins.bool:
        """(experimental) If this flag is enabled, the source IP of request will be output to the log.

        :stability: experimental
        """
        result = self._values.get("ip")
        assert result is not None, "Required property 'ip' is missing"
        return result

    @builtins.property
    def protocol(self) -> builtins.bool:
        """(experimental) If this flag is enabled, the request protocol will be output to the log.

        :stability: experimental
        """
        result = self._values.get("protocol")
        assert result is not None, "Required property 'protocol' is missing"
        return result

    @builtins.property
    def request_time(self) -> builtins.bool:
        """(experimental) If this flag is enabled, the CLF-formatted request time((dd/MMM/yyyy:HH:mm:ss +-hhmm) will be output to the log.

        :stability: experimental
        """
        result = self._values.get("request_time")
        assert result is not None, "Required property 'request_time' is missing"
        return result

    @builtins.property
    def resource_path(self) -> builtins.bool:
        """(experimental) If this flag is enabled, the path to your resource will be output to the log.

        :stability: experimental
        """
        result = self._values.get("resource_path")
        assert result is not None, "Required property 'resource_path' is missing"
        return result

    @builtins.property
    def response_length(self) -> builtins.bool:
        """(experimental) If this flag is enabled, the response payload length will be output to the log.

        :stability: experimental
        """
        result = self._values.get("response_length")
        assert result is not None, "Required property 'response_length' is missing"
        return result

    @builtins.property
    def status(self) -> builtins.bool:
        """(experimental) If this flag is enabled, the method response status will be output to the log.

        :stability: experimental
        """
        result = self._values.get("status")
        assert result is not None, "Required property 'status' is missing"
        return result

    @builtins.property
    def user(self) -> builtins.bool:
        """(experimental) If this flag is enabled, the principal identifier of the user will be output to the log.

        :stability: experimental
        """
        result = self._values.get("user")
        assert result is not None, "Required property 'user' is missing"
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "JsonWithStandardFieldProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.LambdaAuthorizerProps",
    jsii_struct_bases=[],
    name_mapping={
        "handler": "handler",
        "assume_role": "assumeRole",
        "authorizer_name": "authorizerName",
        "results_cache_ttl": "resultsCacheTtl",
    },
)
class LambdaAuthorizerProps:
    def __init__(
        self,
        *,
        handler: _IFunction_6e14f09e,
        assume_role: typing.Optional[_IRole_59af6f50] = None,
        authorizer_name: typing.Optional[builtins.str] = None,
        results_cache_ttl: typing.Optional[_Duration_070aa057] = None,
    ) -> None:
        """(experimental) Base properties for all lambda authorizers.

        :param handler: (experimental) The handler for the authorizer lambda function. The handler must follow a very specific protocol on the input it receives and the output it needs to produce. API Gateway has documented the handler's input specification {@link https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-lambda-authorizer-input.html | here} and output specification {@link https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-lambda-authorizer-output.html | here}.
        :param assume_role: (experimental) An optional IAM role for APIGateway to assume before calling the Lambda-based authorizer. The IAM role must be assumable by 'apigateway.amazonaws.com'. Default: - A resource policy is added to the Lambda function allowing apigateway.amazonaws.com to invoke the function.
        :param authorizer_name: (experimental) An optional human friendly name for the authorizer. Note that, this is not the primary identifier of the authorizer. Default: - the unique construcrt ID
        :param results_cache_ttl: (experimental) How long APIGateway should cache the results. Max 1 hour. Disable caching by setting this to 0. Default: Duration.minutes(5)

        :stability: experimental
        """
        self._values: typing.Dict[str, typing.Any] = {
            "handler": handler,
        }
        if assume_role is not None:
            self._values["assume_role"] = assume_role
        if authorizer_name is not None:
            self._values["authorizer_name"] = authorizer_name
        if results_cache_ttl is not None:
            self._values["results_cache_ttl"] = results_cache_ttl

    @builtins.property
    def handler(self) -> _IFunction_6e14f09e:
        """(experimental) The handler for the authorizer lambda function.

        The handler must follow a very specific protocol on the input it receives and the output it needs to produce.
        API Gateway has documented the handler's input specification
        {@link https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-lambda-authorizer-input.html | here} and output specification
        {@link https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-lambda-authorizer-output.html | here}.

        :stability: experimental
        """
        result = self._values.get("handler")
        assert result is not None, "Required property 'handler' is missing"
        return result

    @builtins.property
    def assume_role(self) -> typing.Optional[_IRole_59af6f50]:
        """(experimental) An optional IAM role for APIGateway to assume before calling the Lambda-based authorizer.

        The IAM role must be
        assumable by 'apigateway.amazonaws.com'.

        :default: - A resource policy is added to the Lambda function allowing apigateway.amazonaws.com to invoke the function.

        :stability: experimental
        """
        result = self._values.get("assume_role")
        return result

    @builtins.property
    def authorizer_name(self) -> typing.Optional[builtins.str]:
        """(experimental) An optional human friendly name for the authorizer.

        Note that, this is not the primary identifier of the authorizer.

        :default: - the unique construcrt ID

        :stability: experimental
        """
        result = self._values.get("authorizer_name")
        return result

    @builtins.property
    def results_cache_ttl(self) -> typing.Optional[_Duration_070aa057]:
        """(experimental) How long APIGateway should cache the results.

        Max 1 hour.
        Disable caching by setting this to 0.

        :default: Duration.minutes(5)

        :stability: experimental
        """
        result = self._values.get("results_cache_ttl")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "LambdaAuthorizerProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.LambdaIntegrationOptions",
    jsii_struct_bases=[IntegrationOptions],
    name_mapping={
        "cache_key_parameters": "cacheKeyParameters",
        "cache_namespace": "cacheNamespace",
        "connection_type": "connectionType",
        "content_handling": "contentHandling",
        "credentials_passthrough": "credentialsPassthrough",
        "credentials_role": "credentialsRole",
        "integration_responses": "integrationResponses",
        "passthrough_behavior": "passthroughBehavior",
        "request_parameters": "requestParameters",
        "request_templates": "requestTemplates",
        "vpc_link": "vpcLink",
        "allow_test_invoke": "allowTestInvoke",
        "proxy": "proxy",
    },
)
class LambdaIntegrationOptions(IntegrationOptions):
    def __init__(
        self,
        *,
        cache_key_parameters: typing.Optional[typing.List[builtins.str]] = None,
        cache_namespace: typing.Optional[builtins.str] = None,
        connection_type: typing.Optional[ConnectionType] = None,
        content_handling: typing.Optional[ContentHandling] = None,
        credentials_passthrough: typing.Optional[builtins.bool] = None,
        credentials_role: typing.Optional[_IRole_59af6f50] = None,
        integration_responses: typing.Optional[typing.List[IntegrationResponse]] = None,
        passthrough_behavior: typing.Optional["PassthroughBehavior"] = None,
        request_parameters: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        request_templates: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        vpc_link: typing.Optional[IVpcLink] = None,
        allow_test_invoke: typing.Optional[builtins.bool] = None,
        proxy: typing.Optional[builtins.bool] = None,
    ) -> None:
        """
        :param cache_key_parameters: (experimental) A list of request parameters whose values are to be cached. It determines request parameters that will make it into the cache key.
        :param cache_namespace: (experimental) An API-specific tag group of related cached parameters.
        :param connection_type: (experimental) The type of network connection to the integration endpoint. Default: - ConnectionType.VPC_LINK if ``vpcLink`` property is configured; ConnectionType.Internet otherwise.
        :param content_handling: (experimental) Specifies how to handle request payload content type conversions. Default: none if this property isn't defined, the request payload is passed through from the method request to the integration request without modification, provided that the ``passthroughBehaviors`` property is configured to support payload pass-through.
        :param credentials_passthrough: (experimental) Requires that the caller's identity be passed through from the request. Default: Caller identity is not passed through
        :param credentials_role: (experimental) An IAM role that API Gateway assumes. Mutually exclusive with ``credentialsPassThrough``. Default: A role is not assumed
        :param integration_responses: (experimental) The response that API Gateway provides after a method's backend completes processing a request. API Gateway intercepts the response from the backend so that you can control how API Gateway surfaces backend responses. For example, you can map the backend status codes to codes that you define.
        :param passthrough_behavior: (experimental) Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource. There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER.
        :param request_parameters: (experimental) The request parameters that API Gateway sends with the backend request. Specify request parameters as key-value pairs (string-to-string mappings), with a destination as the key and a source as the value. Specify the destination by using the following pattern integration.request.location.name, where location is querystring, path, or header, and name is a valid, unique parameter name. The source must be an existing method request parameter or a static value. You must enclose static values in single quotation marks and pre-encode these values based on their destination in the request.
        :param request_templates: (experimental) A map of Apache Velocity templates that are applied on the request payload. The template that API Gateway uses is based on the value of the Content-Type header that's sent by the client. The content type value is the key, and the template is the value (specified as a string), such as the following snippet:: { "application/json": "{ \\"statusCode\\": 200 }" }
        :param vpc_link: (experimental) The VpcLink used for the integration. Required if connectionType is VPC_LINK
        :param allow_test_invoke: (experimental) Allow invoking method from AWS Console UI (for testing purposes). This will add another permission to the AWS Lambda resource policy which will allow the ``test-invoke-stage`` stage to invoke this handler. If this is set to ``false``, the function will only be usable from the deployment endpoint. Default: true
        :param proxy: (experimental) Use proxy integration or normal (request/response mapping) integration. Default: true

        :stability: experimental
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if cache_key_parameters is not None:
            self._values["cache_key_parameters"] = cache_key_parameters
        if cache_namespace is not None:
            self._values["cache_namespace"] = cache_namespace
        if connection_type is not None:
            self._values["connection_type"] = connection_type
        if content_handling is not None:
            self._values["content_handling"] = content_handling
        if credentials_passthrough is not None:
            self._values["credentials_passthrough"] = credentials_passthrough
        if credentials_role is not None:
            self._values["credentials_role"] = credentials_role
        if integration_responses is not None:
            self._values["integration_responses"] = integration_responses
        if passthrough_behavior is not None:
            self._values["passthrough_behavior"] = passthrough_behavior
        if request_parameters is not None:
            self._values["request_parameters"] = request_parameters
        if request_templates is not None:
            self._values["request_templates"] = request_templates
        if vpc_link is not None:
            self._values["vpc_link"] = vpc_link
        if allow_test_invoke is not None:
            self._values["allow_test_invoke"] = allow_test_invoke
        if proxy is not None:
            self._values["proxy"] = proxy

    @builtins.property
    def cache_key_parameters(self) -> typing.Optional[typing.List[builtins.str]]:
        """(experimental) A list of request parameters whose values are to be cached.

        It determines
        request parameters that will make it into the cache key.

        :stability: experimental
        """
        result = self._values.get("cache_key_parameters")
        return result

    @builtins.property
    def cache_namespace(self) -> typing.Optional[builtins.str]:
        """(experimental) An API-specific tag group of related cached parameters.

        :stability: experimental
        """
        result = self._values.get("cache_namespace")
        return result

    @builtins.property
    def connection_type(self) -> typing.Optional[ConnectionType]:
        """(experimental) The type of network connection to the integration endpoint.

        :default: - ConnectionType.VPC_LINK if ``vpcLink`` property is configured; ConnectionType.Internet otherwise.

        :stability: experimental
        """
        result = self._values.get("connection_type")
        return result

    @builtins.property
    def content_handling(self) -> typing.Optional[ContentHandling]:
        """(experimental) Specifies how to handle request payload content type conversions.

        :default:

        none if this property isn't defined, the request payload is passed
        through from the method request to the integration request without
        modification, provided that the ``passthroughBehaviors`` property is
        configured to support payload pass-through.

        :stability: experimental
        """
        result = self._values.get("content_handling")
        return result

    @builtins.property
    def credentials_passthrough(self) -> typing.Optional[builtins.bool]:
        """(experimental) Requires that the caller's identity be passed through from the request.

        :default: Caller identity is not passed through

        :stability: experimental
        """
        result = self._values.get("credentials_passthrough")
        return result

    @builtins.property
    def credentials_role(self) -> typing.Optional[_IRole_59af6f50]:
        """(experimental) An IAM role that API Gateway assumes.

        Mutually exclusive with ``credentialsPassThrough``.

        :default: A role is not assumed

        :stability: experimental
        """
        result = self._values.get("credentials_role")
        return result

    @builtins.property
    def integration_responses(
        self,
    ) -> typing.Optional[typing.List[IntegrationResponse]]:
        """(experimental) The response that API Gateway provides after a method's backend completes processing a request.

        API Gateway intercepts the response from the
        backend so that you can control how API Gateway surfaces backend
        responses. For example, you can map the backend status codes to codes
        that you define.

        :stability: experimental
        """
        result = self._values.get("integration_responses")
        return result

    @builtins.property
    def passthrough_behavior(self) -> typing.Optional["PassthroughBehavior"]:
        """(experimental) Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource.

        There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and
        NEVER.

        :stability: experimental
        """
        result = self._values.get("passthrough_behavior")
        return result

    @builtins.property
    def request_parameters(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        """(experimental) The request parameters that API Gateway sends with the backend request.

        Specify request parameters as key-value pairs (string-to-string
        mappings), with a destination as the key and a source as the value.

        Specify the destination by using the following pattern
        integration.request.location.name, where location is querystring, path,
        or header, and name is a valid, unique parameter name.

        The source must be an existing method request parameter or a static
        value. You must enclose static values in single quotation marks and
        pre-encode these values based on their destination in the request.

        :stability: experimental
        """
        result = self._values.get("request_parameters")
        return result

    @builtins.property
    def request_templates(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        """(experimental) A map of Apache Velocity templates that are applied on the request payload.

        The template that API Gateway uses is based on the value of the
        Content-Type header that's sent by the client. The content type value is
        the key, and the template is the value (specified as a string), such as
        the following snippet::

              { "application/json": "{ \\"statusCode\\": 200 }" }

        :see: http://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html
        :stability: experimental
        """
        result = self._values.get("request_templates")
        return result

    @builtins.property
    def vpc_link(self) -> typing.Optional[IVpcLink]:
        """(experimental) The VpcLink used for the integration.

        Required if connectionType is VPC_LINK

        :stability: experimental
        """
        result = self._values.get("vpc_link")
        return result

    @builtins.property
    def allow_test_invoke(self) -> typing.Optional[builtins.bool]:
        """(experimental) Allow invoking method from AWS Console UI (for testing purposes).

        This will add another permission to the AWS Lambda resource policy which
        will allow the ``test-invoke-stage`` stage to invoke this handler. If this
        is set to ``false``, the function will only be usable from the deployment
        endpoint.

        :default: true

        :stability: experimental
        """
        result = self._values.get("allow_test_invoke")
        return result

    @builtins.property
    def proxy(self) -> typing.Optional[builtins.bool]:
        """(experimental) Use proxy integration or normal (request/response mapping) integration.

        :default: true

        :stability: experimental
        """
        result = self._values.get("proxy")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "LambdaIntegrationOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(IAccessLogDestination)
class LogGroupLogDestination(
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_apigateway.LogGroupLogDestination",
):
    """(experimental) Use CloudWatch Logs as a custom access log destination for API Gateway.

    :stability: experimental
    """

    def __init__(self, log_group: _ILogGroup_846e17a0) -> None:
        """
        :param log_group: -

        :stability: experimental
        """
        jsii.create(LogGroupLogDestination, self, [log_group])

    @jsii.member(jsii_name="bind")
    def bind(self, _stage: IStage) -> AccessLogDestinationConfig:
        """(experimental) Binds this destination to the CloudWatch Logs.

        :param _stage: -

        :stability: experimental
        """
        return jsii.invoke(self, "bind", [_stage])


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.MTLSConfig",
    jsii_struct_bases=[],
    name_mapping={"bucket": "bucket", "key": "key", "version": "version"},
)
class MTLSConfig:
    def __init__(
        self,
        *,
        bucket: _IBucket_73486e29,
        key: builtins.str,
        version: typing.Optional[builtins.str] = None,
    ) -> None:
        """(experimental) The mTLS authentication configuration for a custom domain name.

        :param bucket: (experimental) The bucket that the trust store is hosted in.
        :param key: (experimental) The key in S3 to look at for the trust store.
        :param version: (experimental) The version of the S3 object that contains your truststore. To specify a version, you must have versioning enabled for the S3 bucket. Default: - latest version

        :stability: experimental
        """
        self._values: typing.Dict[str, typing.Any] = {
            "bucket": bucket,
            "key": key,
        }
        if version is not None:
            self._values["version"] = version

    @builtins.property
    def bucket(self) -> _IBucket_73486e29:
        """(experimental) The bucket that the trust store is hosted in.

        :stability: experimental
        """
        result = self._values.get("bucket")
        assert result is not None, "Required property 'bucket' is missing"
        return result

    @builtins.property
    def key(self) -> builtins.str:
        """(experimental) The key in S3 to look at for the trust store.

        :stability: experimental
        """
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return result

    @builtins.property
    def version(self) -> typing.Optional[builtins.str]:
        """(experimental) The version of the S3 object that contains your truststore.

        To specify a version, you must have versioning enabled for the S3 bucket.

        :default: - latest version

        :stability: experimental
        """
        result = self._values.get("version")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "MTLSConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class Method(
    _Resource_abff4495,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_apigateway.Method",
):
    """
    :stability: experimental
    """

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        http_method: builtins.str,
        resource: IResource,
        integration: typing.Optional[Integration] = None,
        options: typing.Optional["MethodOptions"] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param http_method: (experimental) The HTTP method ("GET", "POST", "PUT", ...) that clients use to call this method.
        :param resource: (experimental) The resource this method is associated with. For root resource methods, specify the ``RestApi`` object.
        :param integration: (experimental) The backend system that the method calls when it receives a request. Default: - a new ``MockIntegration``.
        :param options: (experimental) Method options. Default: - No options.

        :stability: experimental
        """
        props = MethodProps(
            http_method=http_method,
            resource=resource,
            integration=integration,
            options=options,
        )

        jsii.create(Method, self, [scope, id, props])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="api")
    def api(self) -> IRestApi:
        """(experimental) The API Gateway RestApi associated with this method.

        :stability: experimental
        """
        return jsii.get(self, "api")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="httpMethod")
    def http_method(self) -> builtins.str:
        """
        :stability: experimental
        """
        return jsii.get(self, "httpMethod")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="methodArn")
    def method_arn(self) -> builtins.str:
        """(experimental) Returns an execute-api ARN for this method:.

        arn:aws:execute-api:{region}:{account}:{restApiId}/{stage}/{method}/{path}

        NOTE: {stage} will refer to the ``restApi.deploymentStage``, which will
        automatically set if auto-deploy is enabled, or can be explicitly assigned.
        When not configured, {stage} will be set to '*', as a shorthand for 'all stages'.

        :stability: experimental
        :attribute: true
        """
        return jsii.get(self, "methodArn")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="methodId")
    def method_id(self) -> builtins.str:
        """
        :stability: experimental
        :attribute: true
        """
        return jsii.get(self, "methodId")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resource")
    def resource(self) -> IResource:
        """
        :stability: experimental
        """
        return jsii.get(self, "resource")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="restApi")
    def rest_api(self) -> "RestApi":
        """(deprecated) The RestApi associated with this Method.

        :deprecated: - Throws an error if this Resource is not associated with an instance of ``RestApi``. Use ``api`` instead.

        :stability: deprecated
        """
        return jsii.get(self, "restApi")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="testMethodArn")
    def test_method_arn(self) -> builtins.str:
        """(experimental) Returns an execute-api ARN for this method's "test-invoke-stage" stage.

        This stage is used by the AWS Console UI when testing the method.

        :stability: experimental
        """
        return jsii.get(self, "testMethodArn")


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.MethodDeploymentOptions",
    jsii_struct_bases=[],
    name_mapping={
        "cache_data_encrypted": "cacheDataEncrypted",
        "cache_ttl": "cacheTtl",
        "caching_enabled": "cachingEnabled",
        "data_trace_enabled": "dataTraceEnabled",
        "logging_level": "loggingLevel",
        "metrics_enabled": "metricsEnabled",
        "throttling_burst_limit": "throttlingBurstLimit",
        "throttling_rate_limit": "throttlingRateLimit",
    },
)
class MethodDeploymentOptions:
    def __init__(
        self,
        *,
        cache_data_encrypted: typing.Optional[builtins.bool] = None,
        cache_ttl: typing.Optional[_Duration_070aa057] = None,
        caching_enabled: typing.Optional[builtins.bool] = None,
        data_trace_enabled: typing.Optional[builtins.bool] = None,
        logging_level: typing.Optional["MethodLoggingLevel"] = None,
        metrics_enabled: typing.Optional[builtins.bool] = None,
        throttling_burst_limit: typing.Optional[jsii.Number] = None,
        throttling_rate_limit: typing.Optional[jsii.Number] = None,
    ) -> None:
        """
        :param cache_data_encrypted: (experimental) Indicates whether the cached responses are encrypted. Default: false
        :param cache_ttl: (experimental) Specifies the time to live (TTL), in seconds, for cached responses. The higher the TTL, the longer the response will be cached. Default: Duration.minutes(5)
        :param caching_enabled: (experimental) Specifies whether responses should be cached and returned for requests. A cache cluster must be enabled on the stage for responses to be cached. Default: - Caching is Disabled.
        :param data_trace_enabled: (experimental) Specifies whether data trace logging is enabled for this method, which effects the log entries pushed to Amazon CloudWatch Logs. Default: false
        :param logging_level: (experimental) Specifies the logging level for this method, which effects the log entries pushed to Amazon CloudWatch Logs. Default: - Off
        :param metrics_enabled: (experimental) Specifies whether Amazon CloudWatch metrics are enabled for this method. Default: false
        :param throttling_burst_limit: (experimental) Specifies the throttling burst limit. The total rate of all requests in your AWS account is limited to 5,000 requests. Default: - No additional restriction.
        :param throttling_rate_limit: (experimental) Specifies the throttling rate limit. The total rate of all requests in your AWS account is limited to 10,000 requests per second (rps). Default: - No additional restriction.

        :stability: experimental
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if cache_data_encrypted is not None:
            self._values["cache_data_encrypted"] = cache_data_encrypted
        if cache_ttl is not None:
            self._values["cache_ttl"] = cache_ttl
        if caching_enabled is not None:
            self._values["caching_enabled"] = caching_enabled
        if data_trace_enabled is not None:
            self._values["data_trace_enabled"] = data_trace_enabled
        if logging_level is not None:
            self._values["logging_level"] = logging_level
        if metrics_enabled is not None:
            self._values["metrics_enabled"] = metrics_enabled
        if throttling_burst_limit is not None:
            self._values["throttling_burst_limit"] = throttling_burst_limit
        if throttling_rate_limit is not None:
            self._values["throttling_rate_limit"] = throttling_rate_limit

    @builtins.property
    def cache_data_encrypted(self) -> typing.Optional[builtins.bool]:
        """(experimental) Indicates whether the cached responses are encrypted.

        :default: false

        :stability: experimental
        """
        result = self._values.get("cache_data_encrypted")
        return result

    @builtins.property
    def cache_ttl(self) -> typing.Optional[_Duration_070aa057]:
        """(experimental) Specifies the time to live (TTL), in seconds, for cached responses.

        The
        higher the TTL, the longer the response will be cached.

        :default: Duration.minutes(5)

        :see: https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-caching.html
        :stability: experimental
        """
        result = self._values.get("cache_ttl")
        return result

    @builtins.property
    def caching_enabled(self) -> typing.Optional[builtins.bool]:
        """(experimental) Specifies whether responses should be cached and returned for requests.

        A
        cache cluster must be enabled on the stage for responses to be cached.

        :default: - Caching is Disabled.

        :stability: experimental
        """
        result = self._values.get("caching_enabled")
        return result

    @builtins.property
    def data_trace_enabled(self) -> typing.Optional[builtins.bool]:
        """(experimental) Specifies whether data trace logging is enabled for this method, which effects the log entries pushed to Amazon CloudWatch Logs.

        :default: false

        :stability: experimental
        """
        result = self._values.get("data_trace_enabled")
        return result

    @builtins.property
    def logging_level(self) -> typing.Optional["MethodLoggingLevel"]:
        """(experimental) Specifies the logging level for this method, which effects the log entries pushed to Amazon CloudWatch Logs.

        :default: - Off

        :stability: experimental
        """
        result = self._values.get("logging_level")
        return result

    @builtins.property
    def metrics_enabled(self) -> typing.Optional[builtins.bool]:
        """(experimental) Specifies whether Amazon CloudWatch metrics are enabled for this method.

        :default: false

        :stability: experimental
        """
        result = self._values.get("metrics_enabled")
        return result

    @builtins.property
    def throttling_burst_limit(self) -> typing.Optional[jsii.Number]:
        """(experimental) Specifies the throttling burst limit.

        The total rate of all requests in your AWS account is limited to 5,000 requests.

        :default: - No additional restriction.

        :see: https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-request-throttling.html
        :stability: experimental
        """
        result = self._values.get("throttling_burst_limit")
        return result

    @builtins.property
    def throttling_rate_limit(self) -> typing.Optional[jsii.Number]:
        """(experimental) Specifies the throttling rate limit.

        The total rate of all requests in your AWS account is limited to 10,000 requests per second (rps).

        :default: - No additional restriction.

        :see: https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-request-throttling.html
        :stability: experimental
        """
        result = self._values.get("throttling_rate_limit")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "MethodDeploymentOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="monocdk.aws_apigateway.MethodLoggingLevel")
class MethodLoggingLevel(enum.Enum):
    """
    :stability: experimental
    """

    OFF = "OFF"
    """
    :stability: experimental
    """
    ERROR = "ERROR"
    """
    :stability: experimental
    """
    INFO = "INFO"
    """
    :stability: experimental
    """


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.MethodOptions",
    jsii_struct_bases=[],
    name_mapping={
        "api_key_required": "apiKeyRequired",
        "authorization_scopes": "authorizationScopes",
        "authorization_type": "authorizationType",
        "authorizer": "authorizer",
        "method_responses": "methodResponses",
        "operation_name": "operationName",
        "request_models": "requestModels",
        "request_parameters": "requestParameters",
        "request_validator": "requestValidator",
        "request_validator_options": "requestValidatorOptions",
    },
)
class MethodOptions:
    def __init__(
        self,
        *,
        api_key_required: typing.Optional[builtins.bool] = None,
        authorization_scopes: typing.Optional[typing.List[builtins.str]] = None,
        authorization_type: typing.Optional[AuthorizationType] = None,
        authorizer: typing.Optional[IAuthorizer] = None,
        method_responses: typing.Optional[typing.List["MethodResponse"]] = None,
        operation_name: typing.Optional[builtins.str] = None,
        request_models: typing.Optional[typing.Mapping[builtins.str, IModel]] = None,
        request_parameters: typing.Optional[typing.Mapping[builtins.str, builtins.bool]] = None,
        request_validator: typing.Optional[IRequestValidator] = None,
        request_validator_options: typing.Optional["RequestValidatorOptions"] = None,
    ) -> None:
        """
        :param api_key_required: (experimental) Indicates whether the method requires clients to submit a valid API key. Default: false
        :param authorization_scopes: (experimental) A list of authorization scopes configured on the method. The scopes are used with a COGNITO_USER_POOLS authorizer to authorize the method invocation. Default: - no authorization scopes
        :param authorization_type: (experimental) Method authorization. If the value is set of ``Custom``, an ``authorizer`` must also be specified. If you're using one of the authorizers that are available via the {@link Authorizer} class, such as {@link Authorizer#token()}, it is recommended that this option not be specified. The authorizer will take care of setting the correct authorization type. However, specifying an authorization type using this property that conflicts with what is expected by the {@link Authorizer} will result in an error. Default: - open access unless ``authorizer`` is specified
        :param authorizer: (experimental) If ``authorizationType`` is ``Custom``, this specifies the ID of the method authorizer resource. If specified, the value of ``authorizationType`` must be set to ``Custom``
        :param method_responses: (experimental) The responses that can be sent to the client who calls the method. Default: None This property is not required, but if these are not supplied for a Lambda proxy integration, the Lambda function must return a value of the correct format, for the integration response to be correctly mapped to a response to the client.
        :param operation_name: (experimental) A friendly operation name for the method. For example, you can assign the OperationName of ListPets for the GET /pets method.
        :param request_models: (experimental) The models which describe data structure of request payload. When combined with ``requestValidator`` or ``requestValidatorOptions``, the service will validate the API request payload before it reaches the API's Integration (including proxies). Specify ``requestModels`` as key-value pairs, with a content type (e.g. ``'application/json'``) as the key and an API Gateway Model as the value.
        :param request_parameters: (experimental) The request parameters that API Gateway accepts. Specify request parameters as key-value pairs (string-to-Boolean mapping), with a source as the key and a Boolean as the value. The Boolean specifies whether a parameter is required. A source must match the format method.request.location.name, where the location is querystring, path, or header, and name is a valid, unique parameter name. Default: None
        :param request_validator: (experimental) The ID of the associated request validator. Only one of ``requestValidator`` or ``requestValidatorOptions`` must be specified. Works together with ``requestModels`` or ``requestParameters`` to validate the request before it reaches integration like Lambda Proxy Integration. Default: - No default validator
        :param request_validator_options: (experimental) Request validator options to create new validator Only one of ``requestValidator`` or ``requestValidatorOptions`` must be specified. Works together with ``requestModels`` or ``requestParameters`` to validate the request before it reaches integration like Lambda Proxy Integration. Default: - No default validator

        :stability: experimental
        """
        if isinstance(request_validator_options, dict):
            request_validator_options = RequestValidatorOptions(**request_validator_options)
        self._values: typing.Dict[str, typing.Any] = {}
        if api_key_required is not None:
            self._values["api_key_required"] = api_key_required
        if authorization_scopes is not None:
            self._values["authorization_scopes"] = authorization_scopes
        if authorization_type is not None:
            self._values["authorization_type"] = authorization_type
        if authorizer is not None:
            self._values["authorizer"] = authorizer
        if method_responses is not None:
            self._values["method_responses"] = method_responses
        if operation_name is not None:
            self._values["operation_name"] = operation_name
        if request_models is not None:
            self._values["request_models"] = request_models
        if request_parameters is not None:
            self._values["request_parameters"] = request_parameters
        if request_validator is not None:
            self._values["request_validator"] = request_validator
        if request_validator_options is not None:
            self._values["request_validator_options"] = request_validator_options

    @builtins.property
    def api_key_required(self) -> typing.Optional[builtins.bool]:
        """(experimental) Indicates whether the method requires clients to submit a valid API key.

        :default: false

        :stability: experimental
        """
        result = self._values.get("api_key_required")
        return result

    @builtins.property
    def authorization_scopes(self) -> typing.Optional[typing.List[builtins.str]]:
        """(experimental) A list of authorization scopes configured on the method.

        The scopes are used with
        a COGNITO_USER_POOLS authorizer to authorize the method invocation.

        :default: - no authorization scopes

        :see: https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationscopes
        :stability: experimental
        """
        result = self._values.get("authorization_scopes")
        return result

    @builtins.property
    def authorization_type(self) -> typing.Optional[AuthorizationType]:
        """(experimental) Method authorization. If the value is set of ``Custom``, an ``authorizer`` must also be specified.

        If you're using one of the authorizers that are available via the {@link Authorizer} class, such as {@link Authorizer#token()},
        it is recommended that this option not be specified. The authorizer will take care of setting the correct authorization type.
        However, specifying an authorization type using this property that conflicts with what is expected by the {@link Authorizer}
        will result in an error.

        :default: - open access unless ``authorizer`` is specified

        :stability: experimental
        """
        result = self._values.get("authorization_type")
        return result

    @builtins.property
    def authorizer(self) -> typing.Optional[IAuthorizer]:
        """(experimental) If ``authorizationType`` is ``Custom``, this specifies the ID of the method authorizer resource.

        If specified, the value of ``authorizationType`` must be set to ``Custom``

        :stability: experimental
        """
        result = self._values.get("authorizer")
        return result

    @builtins.property
    def method_responses(self) -> typing.Optional[typing.List["MethodResponse"]]:
        """(experimental) The responses that can be sent to the client who calls the method.

        :default:

        None

        This property is not required, but if these are not supplied for a Lambda
        proxy integration, the Lambda function must return a value of the correct format,
        for the integration response to be correctly mapped to a response to the client.

        :see: https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-method-settings-method-response.html
        :stability: experimental
        """
        result = self._values.get("method_responses")
        return result

    @builtins.property
    def operation_name(self) -> typing.Optional[builtins.str]:
        """(experimental) A friendly operation name for the method.

        For example, you can assign the
        OperationName of ListPets for the GET /pets method.

        :stability: experimental
        """
        result = self._values.get("operation_name")
        return result

    @builtins.property
    def request_models(self) -> typing.Optional[typing.Mapping[builtins.str, IModel]]:
        """(experimental) The models which describe data structure of request payload.

        When
        combined with ``requestValidator`` or ``requestValidatorOptions``, the service
        will validate the API request payload before it reaches the API's Integration (including proxies).
        Specify ``requestModels`` as key-value pairs, with a content type
        (e.g. ``'application/json'``) as the key and an API Gateway Model as the value.

        :see: https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-method-settings-method-request.html#setup-method-request-model
        :stability: experimental

        Example::

            # Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
            user_model = api.add_model("UserModel",
                schema={
                    "type": apigateway.JsonSchemaType.OBJECT,
                    "properties": {
                        "user_id": {
                            "type": apigateway.JsonSchema.STRING
                        },
                        "name": {
                            "type": apigateway.JsonSchema.STRING
                        }
                    },
                    "required": ["userId"]
                }
            )
            api.root.add_resource("user").add_method("POST",
                apigateway.LambdaIntegration(user_lambda),
                    request_models={
                        "application/json": user_model
                    }
                )
        """
        result = self._values.get("request_models")
        return result

    @builtins.property
    def request_parameters(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.bool]]:
        """(experimental) The request parameters that API Gateway accepts.

        Specify request parameters
        as key-value pairs (string-to-Boolean mapping), with a source as the key and
        a Boolean as the value. The Boolean specifies whether a parameter is required.
        A source must match the format method.request.location.name, where the location
        is querystring, path, or header, and name is a valid, unique parameter name.

        :default: None

        :stability: experimental
        """
        result = self._values.get("request_parameters")
        return result

    @builtins.property
    def request_validator(self) -> typing.Optional[IRequestValidator]:
        """(experimental) The ID of the associated request validator.

        Only one of ``requestValidator`` or ``requestValidatorOptions`` must be specified.
        Works together with ``requestModels`` or ``requestParameters`` to validate
        the request before it reaches integration like Lambda Proxy Integration.

        :default: - No default validator

        :stability: experimental
        """
        result = self._values.get("request_validator")
        return result

    @builtins.property
    def request_validator_options(self) -> typing.Optional["RequestValidatorOptions"]:
        """(experimental) Request validator options to create new validator Only one of ``requestValidator`` or ``requestValidatorOptions`` must be specified.

        Works together with ``requestModels`` or ``requestParameters`` to validate
        the request before it reaches integration like Lambda Proxy Integration.

        :default: - No default validator

        :stability: experimental
        """
        result = self._values.get("request_validator_options")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "MethodOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.MethodProps",
    jsii_struct_bases=[],
    name_mapping={
        "http_method": "httpMethod",
        "resource": "resource",
        "integration": "integration",
        "options": "options",
    },
)
class MethodProps:
    def __init__(
        self,
        *,
        http_method: builtins.str,
        resource: IResource,
        integration: typing.Optional[Integration] = None,
        options: typing.Optional[MethodOptions] = None,
    ) -> None:
        """
        :param http_method: (experimental) The HTTP method ("GET", "POST", "PUT", ...) that clients use to call this method.
        :param resource: (experimental) The resource this method is associated with. For root resource methods, specify the ``RestApi`` object.
        :param integration: (experimental) The backend system that the method calls when it receives a request. Default: - a new ``MockIntegration``.
        :param options: (experimental) Method options. Default: - No options.

        :stability: experimental
        """
        if isinstance(options, dict):
            options = MethodOptions(**options)
        self._values: typing.Dict[str, typing.Any] = {
            "http_method": http_method,
            "resource": resource,
        }
        if integration is not None:
            self._values["integration"] = integration
        if options is not None:
            self._values["options"] = options

    @builtins.property
    def http_method(self) -> builtins.str:
        """(experimental) The HTTP method ("GET", "POST", "PUT", ...) that clients use to call this method.

        :stability: experimental
        """
        result = self._values.get("http_method")
        assert result is not None, "Required property 'http_method' is missing"
        return result

    @builtins.property
    def resource(self) -> IResource:
        """(experimental) The resource this method is associated with.

        For root resource methods,
        specify the ``RestApi`` object.

        :stability: experimental
        """
        result = self._values.get("resource")
        assert result is not None, "Required property 'resource' is missing"
        return result

    @builtins.property
    def integration(self) -> typing.Optional[Integration]:
        """(experimental) The backend system that the method calls when it receives a request.

        :default: - a new ``MockIntegration``.

        :stability: experimental
        """
        result = self._values.get("integration")
        return result

    @builtins.property
    def options(self) -> typing.Optional[MethodOptions]:
        """(experimental) Method options.

        :default: - No options.

        :stability: experimental
        """
        result = self._values.get("options")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "MethodProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.MethodResponse",
    jsii_struct_bases=[],
    name_mapping={
        "status_code": "statusCode",
        "response_models": "responseModels",
        "response_parameters": "responseParameters",
    },
)
class MethodResponse:
    def __init__(
        self,
        *,
        status_code: builtins.str,
        response_models: typing.Optional[typing.Mapping[builtins.str, IModel]] = None,
        response_parameters: typing.Optional[typing.Mapping[builtins.str, builtins.bool]] = None,
    ) -> None:
        """
        :param status_code: (experimental) The method response's status code, which you map to an IntegrationResponse. Required.
        :param response_models: (experimental) The resources used for the response's content type. Specify response models as key-value pairs (string-to-string maps), with a content type as the key and a Model resource name as the value. Default: None
        :param response_parameters: (experimental) Response parameters that API Gateway sends to the client that called a method. Specify response parameters as key-value pairs (string-to-Boolean maps), with a destination as the key and a Boolean as the value. Specify the destination using the following pattern: method.response.header.name, where the name is a valid, unique header name. The Boolean specifies whether a parameter is required. Default: None

        :stability: experimental
        """
        self._values: typing.Dict[str, typing.Any] = {
            "status_code": status_code,
        }
        if response_models is not None:
            self._values["response_models"] = response_models
        if response_parameters is not None:
            self._values["response_parameters"] = response_parameters

    @builtins.property
    def status_code(self) -> builtins.str:
        """(experimental) The method response's status code, which you map to an IntegrationResponse.

        Required.

        :stability: experimental
        """
        result = self._values.get("status_code")
        assert result is not None, "Required property 'status_code' is missing"
        return result

    @builtins.property
    def response_models(self) -> typing.Optional[typing.Mapping[builtins.str, IModel]]:
        """(experimental) The resources used for the response's content type.

        Specify response models as
        key-value pairs (string-to-string maps), with a content type as the key and a Model
        resource name as the value.

        :default: None

        :stability: experimental
        """
        result = self._values.get("response_models")
        return result

    @builtins.property
    def response_parameters(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.bool]]:
        """(experimental) Response parameters that API Gateway sends to the client that called a method.

        Specify response parameters as key-value pairs (string-to-Boolean maps), with
        a destination as the key and a Boolean as the value. Specify the destination
        using the following pattern: method.response.header.name, where the name is a
        valid, unique header name. The Boolean specifies whether a parameter is required.

        :default: None

        :stability: experimental
        """
        result = self._values.get("response_parameters")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "MethodResponse(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class MockIntegration(
    Integration,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_apigateway.MockIntegration",
):
    """(experimental) This type of integration lets API Gateway return a response without sending the request further to the backend.

    This is useful for API testing because it
    can be used to test the integration set up without incurring charges for
    using the backend and to enable collaborative development of an API. In
    collaborative development, a team can isolate their development effort by
    setting up simulations of API components owned by other teams by using the
    MOCK integrations. It is also used to return CORS-related headers to ensure
    that the API method permits CORS access. In fact, the API Gateway console
    integrates the OPTIONS method to support CORS with a mock integration.
    Gateway responses are other examples of mock integrations.

    :stability: experimental
    """

    def __init__(
        self,
        *,
        cache_key_parameters: typing.Optional[typing.List[builtins.str]] = None,
        cache_namespace: typing.Optional[builtins.str] = None,
        connection_type: typing.Optional[ConnectionType] = None,
        content_handling: typing.Optional[ContentHandling] = None,
        credentials_passthrough: typing.Optional[builtins.bool] = None,
        credentials_role: typing.Optional[_IRole_59af6f50] = None,
        integration_responses: typing.Optional[typing.List[IntegrationResponse]] = None,
        passthrough_behavior: typing.Optional["PassthroughBehavior"] = None,
        request_parameters: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        request_templates: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        vpc_link: typing.Optional[IVpcLink] = None,
    ) -> None:
        """
        :param cache_key_parameters: (experimental) A list of request parameters whose values are to be cached. It determines request parameters that will make it into the cache key.
        :param cache_namespace: (experimental) An API-specific tag group of related cached parameters.
        :param connection_type: (experimental) The type of network connection to the integration endpoint. Default: - ConnectionType.VPC_LINK if ``vpcLink`` property is configured; ConnectionType.Internet otherwise.
        :param content_handling: (experimental) Specifies how to handle request payload content type conversions. Default: none if this property isn't defined, the request payload is passed through from the method request to the integration request without modification, provided that the ``passthroughBehaviors`` property is configured to support payload pass-through.
        :param credentials_passthrough: (experimental) Requires that the caller's identity be passed through from the request. Default: Caller identity is not passed through
        :param credentials_role: (experimental) An IAM role that API Gateway assumes. Mutually exclusive with ``credentialsPassThrough``. Default: A role is not assumed
        :param integration_responses: (experimental) The response that API Gateway provides after a method's backend completes processing a request. API Gateway intercepts the response from the backend so that you can control how API Gateway surfaces backend responses. For example, you can map the backend status codes to codes that you define.
        :param passthrough_behavior: (experimental) Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource. There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER.
        :param request_parameters: (experimental) The request parameters that API Gateway sends with the backend request. Specify request parameters as key-value pairs (string-to-string mappings), with a destination as the key and a source as the value. Specify the destination by using the following pattern integration.request.location.name, where location is querystring, path, or header, and name is a valid, unique parameter name. The source must be an existing method request parameter or a static value. You must enclose static values in single quotation marks and pre-encode these values based on their destination in the request.
        :param request_templates: (experimental) A map of Apache Velocity templates that are applied on the request payload. The template that API Gateway uses is based on the value of the Content-Type header that's sent by the client. The content type value is the key, and the template is the value (specified as a string), such as the following snippet:: { "application/json": "{ \\"statusCode\\": 200 }" }
        :param vpc_link: (experimental) The VpcLink used for the integration. Required if connectionType is VPC_LINK

        :stability: experimental
        """
        options = IntegrationOptions(
            cache_key_parameters=cache_key_parameters,
            cache_namespace=cache_namespace,
            connection_type=connection_type,
            content_handling=content_handling,
            credentials_passthrough=credentials_passthrough,
            credentials_role=credentials_role,
            integration_responses=integration_responses,
            passthrough_behavior=passthrough_behavior,
            request_parameters=request_parameters,
            request_templates=request_templates,
            vpc_link=vpc_link,
        )

        jsii.create(MockIntegration, self, [options])


@jsii.implements(IModel)
class Model(
    _Resource_abff4495,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_apigateway.Model",
):
    """
    :stability: experimental
    """

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        rest_api: IRestApi,
        schema: JsonSchema,
        content_type: typing.Optional[builtins.str] = None,
        description: typing.Optional[builtins.str] = None,
        model_name: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param rest_api: (experimental) The rest API that this model is part of. The reason we need the RestApi object itself and not just the ID is because the model is being tracked by the top-level RestApi object for the purpose of calculating it's hash to determine the ID of the deployment. This allows us to automatically update the deployment when the model of the REST API changes.
        :param schema: (experimental) The schema to use to transform data to one or more output formats. Specify null ({}) if you don't want to specify a schema.
        :param content_type: (experimental) The content type for the model. You can also force a content type in the request or response model mapping. Default: 'application/json'
        :param description: (experimental) A description that identifies this model. Default: None
        :param model_name: (experimental) A name for the model. Important If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name. Default: If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the model name. For more information, see Name Type.

        :stability: experimental
        """
        props = ModelProps(
            rest_api=rest_api,
            schema=schema,
            content_type=content_type,
            description=description,
            model_name=model_name,
        )

        jsii.create(Model, self, [scope, id, props])

    @jsii.member(jsii_name="fromModelName")
    @builtins.classmethod
    def from_model_name(
        cls,
        scope: constructs.Construct,
        id: builtins.str,
        model_name: builtins.str,
    ) -> IModel:
        """
        :param scope: -
        :param id: -
        :param model_name: -

        :stability: experimental
        """
        return jsii.sinvoke(cls, "fromModelName", [scope, id, model_name])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="EMPTY_MODEL")
    def EMPTY_MODEL(cls) -> IModel:
        """(experimental) Represents a reference to a REST API's Empty model, which is available as part of the model collection by default.

        This can be used for mapping
        JSON responses from an integration to what is returned to a client,
        where strong typing is not required. In the absence of any defined
        model, the Empty model will be used to return the response payload
        unmapped.

        Definition
        {
        "$schema" : "http://json-schema.org/draft-04/schema#",
        "title" : "Empty Schema",
        "type" : "object"
        }

        :see: https://docs.amazonaws.cn/en_us/apigateway/latest/developerguide/models-mappings.html#models-mappings-models
        :stability: experimental
        """
        return jsii.sget(cls, "EMPTY_MODEL")

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="ERROR_MODEL")
    def ERROR_MODEL(cls) -> IModel:
        """(experimental) Represents a reference to a REST API's Error model, which is available as part of the model collection by default.

        This can be used for mapping
        error JSON responses from an integration to a client, where a simple
        generic message field is sufficient to map and return an error payload.

        Definition
        {
        "$schema" : "http://json-schema.org/draft-04/schema#",
        "title" : "Error Schema",
        "type" : "object",
        "properties" : {
        "message" : { "type" : "string" }
        }
        }

        :stability: experimental
        """
        return jsii.sget(cls, "ERROR_MODEL")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="modelId")
    def model_id(self) -> builtins.str:
        """(experimental) Returns the model name, such as 'myModel'.

        :stability: experimental
        :attribute: true
        """
        return jsii.get(self, "modelId")


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.ModelOptions",
    jsii_struct_bases=[],
    name_mapping={
        "schema": "schema",
        "content_type": "contentType",
        "description": "description",
        "model_name": "modelName",
    },
)
class ModelOptions:
    def __init__(
        self,
        *,
        schema: JsonSchema,
        content_type: typing.Optional[builtins.str] = None,
        description: typing.Optional[builtins.str] = None,
        model_name: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param schema: (experimental) The schema to use to transform data to one or more output formats. Specify null ({}) if you don't want to specify a schema.
        :param content_type: (experimental) The content type for the model. You can also force a content type in the request or response model mapping. Default: 'application/json'
        :param description: (experimental) A description that identifies this model. Default: None
        :param model_name: (experimental) A name for the model. Important If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name. Default: If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the model name. For more information, see Name Type.

        :stability: experimental
        """
        if isinstance(schema, dict):
            schema = JsonSchema(**schema)
        self._values: typing.Dict[str, typing.Any] = {
            "schema": schema,
        }
        if content_type is not None:
            self._values["content_type"] = content_type
        if description is not None:
            self._values["description"] = description
        if model_name is not None:
            self._values["model_name"] = model_name

    @builtins.property
    def schema(self) -> JsonSchema:
        """(experimental) The schema to use to transform data to one or more output formats.

        Specify null ({}) if you don't want to specify a schema.

        :stability: experimental
        """
        result = self._values.get("schema")
        assert result is not None, "Required property 'schema' is missing"
        return result

    @builtins.property
    def content_type(self) -> typing.Optional[builtins.str]:
        """(experimental) The content type for the model.

        You can also force a
        content type in the request or response model mapping.

        :default: 'application/json'

        :stability: experimental
        """
        result = self._values.get("content_type")
        return result

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        """(experimental) A description that identifies this model.

        :default: None

        :stability: experimental
        """
        result = self._values.get("description")
        return result

    @builtins.property
    def model_name(self) -> typing.Optional[builtins.str]:
        """(experimental) A name for the model.

        Important
        If you specify a name, you cannot perform updates that
        require replacement of this resource. You can perform
        updates that require no or some interruption. If you
        must replace the resource, specify a new name.

        :default:

        If you don't specify a name,
        AWS CloudFormation generates a unique physical ID and
        uses that ID for the model name. For more information,
        see Name Type.

        :stability: experimental
        """
        result = self._values.get("model_name")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ModelOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.ModelProps",
    jsii_struct_bases=[ModelOptions],
    name_mapping={
        "schema": "schema",
        "content_type": "contentType",
        "description": "description",
        "model_name": "modelName",
        "rest_api": "restApi",
    },
)
class ModelProps(ModelOptions):
    def __init__(
        self,
        *,
        schema: JsonSchema,
        content_type: typing.Optional[builtins.str] = None,
        description: typing.Optional[builtins.str] = None,
        model_name: typing.Optional[builtins.str] = None,
        rest_api: IRestApi,
    ) -> None:
        """
        :param schema: (experimental) The schema to use to transform data to one or more output formats. Specify null ({}) if you don't want to specify a schema.
        :param content_type: (experimental) The content type for the model. You can also force a content type in the request or response model mapping. Default: 'application/json'
        :param description: (experimental) A description that identifies this model. Default: None
        :param model_name: (experimental) A name for the model. Important If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name. Default: If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the model name. For more information, see Name Type.
        :param rest_api: (experimental) The rest API that this model is part of. The reason we need the RestApi object itself and not just the ID is because the model is being tracked by the top-level RestApi object for the purpose of calculating it's hash to determine the ID of the deployment. This allows us to automatically update the deployment when the model of the REST API changes.

        :stability: experimental
        """
        if isinstance(schema, dict):
            schema = JsonSchema(**schema)
        self._values: typing.Dict[str, typing.Any] = {
            "schema": schema,
            "rest_api": rest_api,
        }
        if content_type is not None:
            self._values["content_type"] = content_type
        if description is not None:
            self._values["description"] = description
        if model_name is not None:
            self._values["model_name"] = model_name

    @builtins.property
    def schema(self) -> JsonSchema:
        """(experimental) The schema to use to transform data to one or more output formats.

        Specify null ({}) if you don't want to specify a schema.

        :stability: experimental
        """
        result = self._values.get("schema")
        assert result is not None, "Required property 'schema' is missing"
        return result

    @builtins.property
    def content_type(self) -> typing.Optional[builtins.str]:
        """(experimental) The content type for the model.

        You can also force a
        content type in the request or response model mapping.

        :default: 'application/json'

        :stability: experimental
        """
        result = self._values.get("content_type")
        return result

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        """(experimental) A description that identifies this model.

        :default: None

        :stability: experimental
        """
        result = self._values.get("description")
        return result

    @builtins.property
    def model_name(self) -> typing.Optional[builtins.str]:
        """(experimental) A name for the model.

        Important
        If you specify a name, you cannot perform updates that
        require replacement of this resource. You can perform
        updates that require no or some interruption. If you
        must replace the resource, specify a new name.

        :default:

        If you don't specify a name,
        AWS CloudFormation generates a unique physical ID and
        uses that ID for the model name. For more information,
        see Name Type.

        :stability: experimental
        """
        result = self._values.get("model_name")
        return result

    @builtins.property
    def rest_api(self) -> IRestApi:
        """(experimental) The rest API that this model is part of.

        The reason we need the RestApi object itself and not just the ID is because the model
        is being tracked by the top-level RestApi object for the purpose of calculating it's
        hash to determine the ID of the deployment. This allows us to automatically update
        the deployment when the model of the REST API changes.

        :stability: experimental
        """
        result = self._values.get("rest_api")
        assert result is not None, "Required property 'rest_api' is missing"
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ModelProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="monocdk.aws_apigateway.PassthroughBehavior")
class PassthroughBehavior(enum.Enum):
    """
    :stability: experimental
    """

    WHEN_NO_MATCH = "WHEN_NO_MATCH"
    """(experimental) Passes the request body for unmapped content types through to the integration back end without transformation.

    :stability: experimental
    """
    NEVER = "NEVER"
    """(experimental) Rejects unmapped content types with an HTTP 415 'Unsupported Media Type' response.

    :stability: experimental
    """
    WHEN_NO_TEMPLATES = "WHEN_NO_TEMPLATES"
    """(experimental) Allows pass-through when the integration has NO content types mapped to templates.

    However if there is at least one content type defined,
    unmapped content types will be rejected with the same 415 response.

    :stability: experimental
    """


@jsii.enum(jsii_type="monocdk.aws_apigateway.Period")
class Period(enum.Enum):
    """(experimental) Time period for which quota settings apply.

    :stability: experimental
    """

    DAY = "DAY"
    """
    :stability: experimental
    """
    WEEK = "WEEK"
    """
    :stability: experimental
    """
    MONTH = "MONTH"
    """
    :stability: experimental
    """


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.QuotaSettings",
    jsii_struct_bases=[],
    name_mapping={"limit": "limit", "offset": "offset", "period": "period"},
)
class QuotaSettings:
    def __init__(
        self,
        *,
        limit: typing.Optional[jsii.Number] = None,
        offset: typing.Optional[jsii.Number] = None,
        period: typing.Optional[Period] = None,
    ) -> None:
        """(experimental) Specifies the maximum number of requests that clients can make to API Gateway APIs.

        :param limit: (experimental) The maximum number of requests that users can make within the specified time period. Default: none
        :param offset: (experimental) For the initial time period, the number of requests to subtract from the specified limit. Default: none
        :param period: (experimental) The time period for which the maximum limit of requests applies. Default: none

        :stability: experimental
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if limit is not None:
            self._values["limit"] = limit
        if offset is not None:
            self._values["offset"] = offset
        if period is not None:
            self._values["period"] = period

    @builtins.property
    def limit(self) -> typing.Optional[jsii.Number]:
        """(experimental) The maximum number of requests that users can make within the specified time period.

        :default: none

        :stability: experimental
        """
        result = self._values.get("limit")
        return result

    @builtins.property
    def offset(self) -> typing.Optional[jsii.Number]:
        """(experimental) For the initial time period, the number of requests to subtract from the specified limit.

        :default: none

        :stability: experimental
        """
        result = self._values.get("offset")
        return result

    @builtins.property
    def period(self) -> typing.Optional[Period]:
        """(experimental) The time period for which the maximum limit of requests applies.

        :default: none

        :stability: experimental
        """
        result = self._values.get("period")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "QuotaSettings(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(IApiKey)
class RateLimitedApiKey(
    _Resource_abff4495,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_apigateway.RateLimitedApiKey",
):
    """(experimental) An API Gateway ApiKey, for which a rate limiting configuration can be specified.

    :stability: experimental
    :resource: AWS::ApiGateway::ApiKey
    """

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        api_stages: typing.Optional[typing.List["UsagePlanPerApiStage"]] = None,
        quota: typing.Optional[QuotaSettings] = None,
        throttle: typing.Optional["ThrottleSettings"] = None,
        customer_id: typing.Optional[builtins.str] = None,
        description: typing.Optional[builtins.str] = None,
        enabled: typing.Optional[builtins.bool] = None,
        generate_distinct_id: typing.Optional[builtins.bool] = None,
        resources: typing.Optional[typing.List["RestApi"]] = None,
        api_key_name: typing.Optional[builtins.str] = None,
        value: typing.Optional[builtins.str] = None,
        default_cors_preflight_options: typing.Optional[CorsOptions] = None,
        default_integration: typing.Optional[Integration] = None,
        default_method_options: typing.Optional[MethodOptions] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param api_stages: (experimental) API Stages to be associated with the RateLimitedApiKey. Default: none
        :param quota: (experimental) Number of requests clients can make in a given time period. Default: none
        :param throttle: (experimental) Overall throttle settings for the API. Default: none
        :param customer_id: (experimental) An AWS Marketplace customer identifier to use when integrating with the AWS SaaS Marketplace. Default: none
        :param description: (experimental) A description of the purpose of the API key. Default: none
        :param enabled: (experimental) Indicates whether the API key can be used by clients. Default: true
        :param generate_distinct_id: (experimental) Specifies whether the key identifier is distinct from the created API key value. Default: false
        :param resources: (experimental) [disable-awslint:ref-via-interface] A list of resources this api key is associated with. Default: none
        :param api_key_name: (experimental) A name for the API key. If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the API key name. Default: automically generated name
        :param value: (experimental) The value of the API key. Must be at least 20 characters long. Default: none
        :param default_cors_preflight_options: (experimental) Adds a CORS preflight OPTIONS method to this resource and all child resources. You can add CORS at the resource-level using ``addCorsPreflight``. Default: - CORS is disabled
        :param default_integration: (experimental) An integration to use as a default for all methods created within this API unless an integration is specified. Default: - Inherited from parent.
        :param default_method_options: (experimental) Method options to use as a default for all methods created within this API unless custom options are specified. Default: - Inherited from parent.

        :stability: experimental
        """
        props = RateLimitedApiKeyProps(
            api_stages=api_stages,
            quota=quota,
            throttle=throttle,
            customer_id=customer_id,
            description=description,
            enabled=enabled,
            generate_distinct_id=generate_distinct_id,
            resources=resources,
            api_key_name=api_key_name,
            value=value,
            default_cors_preflight_options=default_cors_preflight_options,
            default_integration=default_integration,
            default_method_options=default_method_options,
        )

        jsii.create(RateLimitedApiKey, self, [scope, id, props])

    @jsii.member(jsii_name="grantRead")
    def grant_read(self, grantee: _IGrantable_4c5a91d1) -> _Grant_bcb5eae7:
        """(experimental) Permits the IAM principal all read operations through this key.

        :param grantee: The principal to grant access to.

        :stability: experimental
        """
        return jsii.invoke(self, "grantRead", [grantee])

    @jsii.member(jsii_name="grantReadWrite")
    def grant_read_write(self, grantee: _IGrantable_4c5a91d1) -> _Grant_bcb5eae7:
        """(experimental) Permits the IAM principal all read and write operations through this key.

        :param grantee: The principal to grant access to.

        :stability: experimental
        """
        return jsii.invoke(self, "grantReadWrite", [grantee])

    @jsii.member(jsii_name="grantWrite")
    def grant_write(self, grantee: _IGrantable_4c5a91d1) -> _Grant_bcb5eae7:
        """(experimental) Permits the IAM principal all write operations through this key.

        :param grantee: The principal to grant access to.

        :stability: experimental
        """
        return jsii.invoke(self, "grantWrite", [grantee])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="keyArn")
    def key_arn(self) -> builtins.str:
        """(experimental) The API key ARN.

        :stability: experimental
        """
        return jsii.get(self, "keyArn")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="keyId")
    def key_id(self) -> builtins.str:
        """(experimental) The API key ID.

        :stability: experimental
        """
        return jsii.get(self, "keyId")


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.RequestAuthorizerProps",
    jsii_struct_bases=[LambdaAuthorizerProps],
    name_mapping={
        "handler": "handler",
        "assume_role": "assumeRole",
        "authorizer_name": "authorizerName",
        "results_cache_ttl": "resultsCacheTtl",
        "identity_sources": "identitySources",
    },
)
class RequestAuthorizerProps(LambdaAuthorizerProps):
    def __init__(
        self,
        *,
        handler: _IFunction_6e14f09e,
        assume_role: typing.Optional[_IRole_59af6f50] = None,
        authorizer_name: typing.Optional[builtins.str] = None,
        results_cache_ttl: typing.Optional[_Duration_070aa057] = None,
        identity_sources: typing.List[builtins.str],
    ) -> None:
        """(experimental) Properties for RequestAuthorizer.

        :param handler: (experimental) The handler for the authorizer lambda function. The handler must follow a very specific protocol on the input it receives and the output it needs to produce. API Gateway has documented the handler's input specification {@link https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-lambda-authorizer-input.html | here} and output specification {@link https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-lambda-authorizer-output.html | here}.
        :param assume_role: (experimental) An optional IAM role for APIGateway to assume before calling the Lambda-based authorizer. The IAM role must be assumable by 'apigateway.amazonaws.com'. Default: - A resource policy is added to the Lambda function allowing apigateway.amazonaws.com to invoke the function.
        :param authorizer_name: (experimental) An optional human friendly name for the authorizer. Note that, this is not the primary identifier of the authorizer. Default: - the unique construcrt ID
        :param results_cache_ttl: (experimental) How long APIGateway should cache the results. Max 1 hour. Disable caching by setting this to 0. Default: Duration.minutes(5)
        :param identity_sources: (experimental) An array of request header mapping expressions for identities. Supported parameter types are Header, Query String, Stage Variable, and Context. For instance, extracting an authorization token from a header would use the identity source ``IdentitySource.header('Authorizer')``. Note: API Gateway uses the specified identity sources as the request authorizer caching key. When caching is enabled, API Gateway calls the authorizer's Lambda function only after successfully verifying that all the specified identity sources are present at runtime. If a specified identify source is missing, null, or empty, API Gateway returns a 401 Unauthorized response without calling the authorizer Lambda function.

        :stability: experimental
        """
        self._values: typing.Dict[str, typing.Any] = {
            "handler": handler,
            "identity_sources": identity_sources,
        }
        if assume_role is not None:
            self._values["assume_role"] = assume_role
        if authorizer_name is not None:
            self._values["authorizer_name"] = authorizer_name
        if results_cache_ttl is not None:
            self._values["results_cache_ttl"] = results_cache_ttl

    @builtins.property
    def handler(self) -> _IFunction_6e14f09e:
        """(experimental) The handler for the authorizer lambda function.

        The handler must follow a very specific protocol on the input it receives and the output it needs to produce.
        API Gateway has documented the handler's input specification
        {@link https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-lambda-authorizer-input.html | here} and output specification
        {@link https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-lambda-authorizer-output.html | here}.

        :stability: experimental
        """
        result = self._values.get("handler")
        assert result is not None, "Required property 'handler' is missing"
        return result

    @builtins.property
    def assume_role(self) -> typing.Optional[_IRole_59af6f50]:
        """(experimental) An optional IAM role for APIGateway to assume before calling the Lambda-based authorizer.

        The IAM role must be
        assumable by 'apigateway.amazonaws.com'.

        :default: - A resource policy is added to the Lambda function allowing apigateway.amazonaws.com to invoke the function.

        :stability: experimental
        """
        result = self._values.get("assume_role")
        return result

    @builtins.property
    def authorizer_name(self) -> typing.Optional[builtins.str]:
        """(experimental) An optional human friendly name for the authorizer.

        Note that, this is not the primary identifier of the authorizer.

        :default: - the unique construcrt ID

        :stability: experimental
        """
        result = self._values.get("authorizer_name")
        return result

    @builtins.property
    def results_cache_ttl(self) -> typing.Optional[_Duration_070aa057]:
        """(experimental) How long APIGateway should cache the results.

        Max 1 hour.
        Disable caching by setting this to 0.

        :default: Duration.minutes(5)

        :stability: experimental
        """
        result = self._values.get("results_cache_ttl")
        return result

    @builtins.property
    def identity_sources(self) -> typing.List[builtins.str]:
        """(experimental) An array of request header mapping expressions for identities.

        Supported parameter types are
        Header, Query String, Stage Variable, and Context. For instance, extracting an authorization
        token from a header would use the identity source ``IdentitySource.header('Authorizer')``.

        Note: API Gateway uses the specified identity sources as the request authorizer caching key. When caching is
        enabled, API Gateway calls the authorizer's Lambda function only after successfully verifying that all the
        specified identity sources are present at runtime. If a specified identify source is missing, null, or empty,
        API Gateway returns a 401 Unauthorized response without calling the authorizer Lambda function.

        :see: https://docs.aws.amazon.com/apigateway/api-reference/link-relation/authorizer-create/#identitySource
        :stability: experimental
        """
        result = self._values.get("identity_sources")
        assert result is not None, "Required property 'identity_sources' is missing"
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "RequestAuthorizerProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(IRequestValidator)
class RequestValidator(
    _Resource_abff4495,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_apigateway.RequestValidator",
):
    """
    :stability: experimental
    """

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        rest_api: IRestApi,
        request_validator_name: typing.Optional[builtins.str] = None,
        validate_request_body: typing.Optional[builtins.bool] = None,
        validate_request_parameters: typing.Optional[builtins.bool] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param rest_api: (experimental) The rest API that this model is part of. The reason we need the RestApi object itself and not just the ID is because the model is being tracked by the top-level RestApi object for the purpose of calculating it's hash to determine the ID of the deployment. This allows us to automatically update the deployment when the model of the REST API changes.
        :param request_validator_name: (experimental) The name of this request validator. Default: None
        :param validate_request_body: (experimental) Indicates whether to validate the request body according to the configured schema for the targeted API and method. Default: false
        :param validate_request_parameters: (experimental) Indicates whether to validate request parameters. Default: false

        :stability: experimental
        """
        props = RequestValidatorProps(
            rest_api=rest_api,
            request_validator_name=request_validator_name,
            validate_request_body=validate_request_body,
            validate_request_parameters=validate_request_parameters,
        )

        jsii.create(RequestValidator, self, [scope, id, props])

    @jsii.member(jsii_name="fromRequestValidatorId")
    @builtins.classmethod
    def from_request_validator_id(
        cls,
        scope: constructs.Construct,
        id: builtins.str,
        request_validator_id: builtins.str,
    ) -> IRequestValidator:
        """
        :param scope: -
        :param id: -
        :param request_validator_id: -

        :stability: experimental
        """
        return jsii.sinvoke(cls, "fromRequestValidatorId", [scope, id, request_validator_id])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="requestValidatorId")
    def request_validator_id(self) -> builtins.str:
        """(experimental) ID of the request validator, such as abc123.

        :stability: experimental
        :attribute: true
        """
        return jsii.get(self, "requestValidatorId")


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.RequestValidatorOptions",
    jsii_struct_bases=[],
    name_mapping={
        "request_validator_name": "requestValidatorName",
        "validate_request_body": "validateRequestBody",
        "validate_request_parameters": "validateRequestParameters",
    },
)
class RequestValidatorOptions:
    def __init__(
        self,
        *,
        request_validator_name: typing.Optional[builtins.str] = None,
        validate_request_body: typing.Optional[builtins.bool] = None,
        validate_request_parameters: typing.Optional[builtins.bool] = None,
    ) -> None:
        """
        :param request_validator_name: (experimental) The name of this request validator. Default: None
        :param validate_request_body: (experimental) Indicates whether to validate the request body according to the configured schema for the targeted API and method. Default: false
        :param validate_request_parameters: (experimental) Indicates whether to validate request parameters. Default: false

        :stability: experimental
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if request_validator_name is not None:
            self._values["request_validator_name"] = request_validator_name
        if validate_request_body is not None:
            self._values["validate_request_body"] = validate_request_body
        if validate_request_parameters is not None:
            self._values["validate_request_parameters"] = validate_request_parameters

    @builtins.property
    def request_validator_name(self) -> typing.Optional[builtins.str]:
        """(experimental) The name of this request validator.

        :default: None

        :stability: experimental
        """
        result = self._values.get("request_validator_name")
        return result

    @builtins.property
    def validate_request_body(self) -> typing.Optional[builtins.bool]:
        """(experimental) Indicates whether to validate the request body according to the configured schema for the targeted API and method.

        :default: false

        :stability: experimental
        """
        result = self._values.get("validate_request_body")
        return result

    @builtins.property
    def validate_request_parameters(self) -> typing.Optional[builtins.bool]:
        """(experimental) Indicates whether to validate request parameters.

        :default: false

        :stability: experimental
        """
        result = self._values.get("validate_request_parameters")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "RequestValidatorOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.RequestValidatorProps",
    jsii_struct_bases=[RequestValidatorOptions],
    name_mapping={
        "request_validator_name": "requestValidatorName",
        "validate_request_body": "validateRequestBody",
        "validate_request_parameters": "validateRequestParameters",
        "rest_api": "restApi",
    },
)
class RequestValidatorProps(RequestValidatorOptions):
    def __init__(
        self,
        *,
        request_validator_name: typing.Optional[builtins.str] = None,
        validate_request_body: typing.Optional[builtins.bool] = None,
        validate_request_parameters: typing.Optional[builtins.bool] = None,
        rest_api: IRestApi,
    ) -> None:
        """
        :param request_validator_name: (experimental) The name of this request validator. Default: None
        :param validate_request_body: (experimental) Indicates whether to validate the request body according to the configured schema for the targeted API and method. Default: false
        :param validate_request_parameters: (experimental) Indicates whether to validate request parameters. Default: false
        :param rest_api: (experimental) The rest API that this model is part of. The reason we need the RestApi object itself and not just the ID is because the model is being tracked by the top-level RestApi object for the purpose of calculating it's hash to determine the ID of the deployment. This allows us to automatically update the deployment when the model of the REST API changes.

        :stability: experimental
        """
        self._values: typing.Dict[str, typing.Any] = {
            "rest_api": rest_api,
        }
        if request_validator_name is not None:
            self._values["request_validator_name"] = request_validator_name
        if validate_request_body is not None:
            self._values["validate_request_body"] = validate_request_body
        if validate_request_parameters is not None:
            self._values["validate_request_parameters"] = validate_request_parameters

    @builtins.property
    def request_validator_name(self) -> typing.Optional[builtins.str]:
        """(experimental) The name of this request validator.

        :default: None

        :stability: experimental
        """
        result = self._values.get("request_validator_name")
        return result

    @builtins.property
    def validate_request_body(self) -> typing.Optional[builtins.bool]:
        """(experimental) Indicates whether to validate the request body according to the configured schema for the targeted API and method.

        :default: false

        :stability: experimental
        """
        result = self._values.get("validate_request_body")
        return result

    @builtins.property
    def validate_request_parameters(self) -> typing.Optional[builtins.bool]:
        """(experimental) Indicates whether to validate request parameters.

        :default: false

        :stability: experimental
        """
        result = self._values.get("validate_request_parameters")
        return result

    @builtins.property
    def rest_api(self) -> IRestApi:
        """(experimental) The rest API that this model is part of.

        The reason we need the RestApi object itself and not just the ID is because the model
        is being tracked by the top-level RestApi object for the purpose of calculating it's
        hash to determine the ID of the deployment. This allows us to automatically update
        the deployment when the model of the REST API changes.

        :stability: experimental
        """
        result = self._values.get("rest_api")
        assert result is not None, "Required property 'rest_api' is missing"
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "RequestValidatorProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(IResource)
class ResourceBase(
    _Resource_abff4495,
    metaclass=jsii.JSIIAbstractClass,
    jsii_type="monocdk.aws_apigateway.ResourceBase",
):
    """
    :stability: experimental
    """

    @builtins.staticmethod
    def __jsii_proxy_class__():
        return _ResourceBaseProxy

    def __init__(self, scope: constructs.Construct, id: builtins.str) -> None:
        """
        :param scope: -
        :param id: -

        :stability: experimental
        """
        jsii.create(ResourceBase, self, [scope, id])

    @jsii.member(jsii_name="addCorsPreflight")
    def add_cors_preflight(
        self,
        *,
        allow_origins: typing.List[builtins.str],
        allow_credentials: typing.Optional[builtins.bool] = None,
        allow_headers: typing.Optional[typing.List[builtins.str]] = None,
        allow_methods: typing.Optional[typing.List[builtins.str]] = None,
        disable_cache: typing.Optional[builtins.bool] = None,
        expose_headers: typing.Optional[typing.List[builtins.str]] = None,
        max_age: typing.Optional[_Duration_070aa057] = None,
        status_code: typing.Optional[jsii.Number] = None,
    ) -> Method:
        """(experimental) Adds an OPTIONS method to this resource which responds to Cross-Origin Resource Sharing (CORS) preflight requests.

        Cross-Origin Resource Sharing (CORS) is a mechanism that uses additional
        HTTP headers to tell browsers to give a web application running at one
        origin, access to selected resources from a different origin. A web
        application executes a cross-origin HTTP request when it requests a
        resource that has a different origin (domain, protocol, or port) from its
        own.

        :param allow_origins: (experimental) Specifies the list of origins that are allowed to make requests to this resource. If you wish to allow all origins, specify ``Cors.ALL_ORIGINS`` or ``[ * ]``. Responses will include the ``Access-Control-Allow-Origin`` response header. If ``Cors.ALL_ORIGINS`` is specified, the ``Vary: Origin`` response header will also be included.
        :param allow_credentials: (experimental) The Access-Control-Allow-Credentials response header tells browsers whether to expose the response to frontend JavaScript code when the request's credentials mode (Request.credentials) is "include". When a request's credentials mode (Request.credentials) is "include", browsers will only expose the response to frontend JavaScript code if the Access-Control-Allow-Credentials value is true. Credentials are cookies, authorization headers or TLS client certificates. Default: false
        :param allow_headers: (experimental) The Access-Control-Allow-Headers response header is used in response to a preflight request which includes the Access-Control-Request-Headers to indicate which HTTP headers can be used during the actual request. Default: Cors.DEFAULT_HEADERS
        :param allow_methods: (experimental) The Access-Control-Allow-Methods response header specifies the method or methods allowed when accessing the resource in response to a preflight request. If ``ANY`` is specified, it will be expanded to ``Cors.ALL_METHODS``. Default: Cors.ALL_METHODS
        :param disable_cache: (experimental) Sets Access-Control-Max-Age to -1, which means that caching is disabled. This option cannot be used with ``maxAge``. Default: - cache is enabled
        :param expose_headers: (experimental) The Access-Control-Expose-Headers response header indicates which headers can be exposed as part of the response by listing their names. If you want clients to be able to access other headers, you have to list them using the Access-Control-Expose-Headers header. Default: - only the 6 CORS-safelisted response headers are exposed: Cache-Control, Content-Language, Content-Type, Expires, Last-Modified, Pragma
        :param max_age: (experimental) The Access-Control-Max-Age response header indicates how long the results of a preflight request (that is the information contained in the Access-Control-Allow-Methods and Access-Control-Allow-Headers headers) can be cached. To disable caching altogther use ``disableCache: true``. Default: - browser-specific (see reference)
        :param status_code: (experimental) Specifies the response status code returned from the OPTIONS method. Default: 204

        :stability: experimental
        """
        options = CorsOptions(
            allow_origins=allow_origins,
            allow_credentials=allow_credentials,
            allow_headers=allow_headers,
            allow_methods=allow_methods,
            disable_cache=disable_cache,
            expose_headers=expose_headers,
            max_age=max_age,
            status_code=status_code,
        )

        return jsii.invoke(self, "addCorsPreflight", [options])

    @jsii.member(jsii_name="addMethod")
    def add_method(
        self,
        http_method: builtins.str,
        integration: typing.Optional[Integration] = None,
        *,
        api_key_required: typing.Optional[builtins.bool] = None,
        authorization_scopes: typing.Optional[typing.List[builtins.str]] = None,
        authorization_type: typing.Optional[AuthorizationType] = None,
        authorizer: typing.Optional[IAuthorizer] = None,
        method_responses: typing.Optional[typing.List[MethodResponse]] = None,
        operation_name: typing.Optional[builtins.str] = None,
        request_models: typing.Optional[typing.Mapping[builtins.str, IModel]] = None,
        request_parameters: typing.Optional[typing.Mapping[builtins.str, builtins.bool]] = None,
        request_validator: typing.Optional[IRequestValidator] = None,
        request_validator_options: typing.Optional[RequestValidatorOptions] = None,
    ) -> Method:
        """(experimental) Defines a new method for this resource.

        :param http_method: -
        :param integration: -
        :param api_key_required: (experimental) Indicates whether the method requires clients to submit a valid API key. Default: false
        :param authorization_scopes: (experimental) A list of authorization scopes configured on the method. The scopes are used with a COGNITO_USER_POOLS authorizer to authorize the method invocation. Default: - no authorization scopes
        :param authorization_type: (experimental) Method authorization. If the value is set of ``Custom``, an ``authorizer`` must also be specified. If you're using one of the authorizers that are available via the {@link Authorizer} class, such as {@link Authorizer#token()}, it is recommended that this option not be specified. The authorizer will take care of setting the correct authorization type. However, specifying an authorization type using this property that conflicts with what is expected by the {@link Authorizer} will result in an error. Default: - open access unless ``authorizer`` is specified
        :param authorizer: (experimental) If ``authorizationType`` is ``Custom``, this specifies the ID of the method authorizer resource. If specified, the value of ``authorizationType`` must be set to ``Custom``
        :param method_responses: (experimental) The responses that can be sent to the client who calls the method. Default: None This property is not required, but if these are not supplied for a Lambda proxy integration, the Lambda function must return a value of the correct format, for the integration response to be correctly mapped to a response to the client.
        :param operation_name: (experimental) A friendly operation name for the method. For example, you can assign the OperationName of ListPets for the GET /pets method.
        :param request_models: (experimental) The models which describe data structure of request payload. When combined with ``requestValidator`` or ``requestValidatorOptions``, the service will validate the API request payload before it reaches the API's Integration (including proxies). Specify ``requestModels`` as key-value pairs, with a content type (e.g. ``'application/json'``) as the key and an API Gateway Model as the value.
        :param request_parameters: (experimental) The request parameters that API Gateway accepts. Specify request parameters as key-value pairs (string-to-Boolean mapping), with a source as the key and a Boolean as the value. The Boolean specifies whether a parameter is required. A source must match the format method.request.location.name, where the location is querystring, path, or header, and name is a valid, unique parameter name. Default: None
        :param request_validator: (experimental) The ID of the associated request validator. Only one of ``requestValidator`` or ``requestValidatorOptions`` must be specified. Works together with ``requestModels`` or ``requestParameters`` to validate the request before it reaches integration like Lambda Proxy Integration. Default: - No default validator
        :param request_validator_options: (experimental) Request validator options to create new validator Only one of ``requestValidator`` or ``requestValidatorOptions`` must be specified. Works together with ``requestModels`` or ``requestParameters`` to validate the request before it reaches integration like Lambda Proxy Integration. Default: - No default validator

        :stability: experimental
        """
        options = MethodOptions(
            api_key_required=api_key_required,
            authorization_scopes=authorization_scopes,
            authorization_type=authorization_type,
            authorizer=authorizer,
            method_responses=method_responses,
            operation_name=operation_name,
            request_models=request_models,
            request_parameters=request_parameters,
            request_validator=request_validator,
            request_validator_options=request_validator_options,
        )

        return jsii.invoke(self, "addMethod", [http_method, integration, options])

    @jsii.member(jsii_name="addProxy")
    def add_proxy(
        self,
        *,
        any_method: typing.Optional[builtins.bool] = None,
        default_cors_preflight_options: typing.Optional[CorsOptions] = None,
        default_integration: typing.Optional[Integration] = None,
        default_method_options: typing.Optional[MethodOptions] = None,
    ) -> "ProxyResource":
        """(experimental) Adds a greedy proxy resource ("{proxy+}") and an ANY method to this route.

        :param any_method: (experimental) Adds an "ANY" method to this resource. If set to ``false``, you will have to explicitly add methods to this resource after it's created. Default: true
        :param default_cors_preflight_options: (experimental) Adds a CORS preflight OPTIONS method to this resource and all child resources. You can add CORS at the resource-level using ``addCorsPreflight``. Default: - CORS is disabled
        :param default_integration: (experimental) An integration to use as a default for all methods created within this API unless an integration is specified. Default: - Inherited from parent.
        :param default_method_options: (experimental) Method options to use as a default for all methods created within this API unless custom options are specified. Default: - Inherited from parent.

        :stability: experimental
        """
        options = ProxyResourceOptions(
            any_method=any_method,
            default_cors_preflight_options=default_cors_preflight_options,
            default_integration=default_integration,
            default_method_options=default_method_options,
        )

        return jsii.invoke(self, "addProxy", [options])

    @jsii.member(jsii_name="addResource")
    def add_resource(
        self,
        path_part: builtins.str,
        *,
        default_cors_preflight_options: typing.Optional[CorsOptions] = None,
        default_integration: typing.Optional[Integration] = None,
        default_method_options: typing.Optional[MethodOptions] = None,
    ) -> "Resource":
        """(experimental) Defines a new child resource where this resource is the parent.

        :param path_part: -
        :param default_cors_preflight_options: (experimental) Adds a CORS preflight OPTIONS method to this resource and all child resources. You can add CORS at the resource-level using ``addCorsPreflight``. Default: - CORS is disabled
        :param default_integration: (experimental) An integration to use as a default for all methods created within this API unless an integration is specified. Default: - Inherited from parent.
        :param default_method_options: (experimental) Method options to use as a default for all methods created within this API unless custom options are specified. Default: - Inherited from parent.

        :stability: experimental
        """
        options = ResourceOptions(
            default_cors_preflight_options=default_cors_preflight_options,
            default_integration=default_integration,
            default_method_options=default_method_options,
        )

        return jsii.invoke(self, "addResource", [path_part, options])

    @jsii.member(jsii_name="getResource")
    def get_resource(self, path_part: builtins.str) -> typing.Optional[IResource]:
        """(experimental) Retrieves a child resource by path part.

        :param path_part: -

        :stability: experimental
        """
        return jsii.invoke(self, "getResource", [path_part])

    @jsii.member(jsii_name="resourceForPath")
    def resource_for_path(self, path: builtins.str) -> "Resource":
        """(experimental) Gets or create all resources leading up to the specified path.

        - Path may only start with "/" if this method is called on the root resource.
        - All resources are created using default options.

        :param path: -

        :stability: experimental
        """
        return jsii.invoke(self, "resourceForPath", [path])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="api")
    @abc.abstractmethod
    def api(self) -> IRestApi:
        """(experimental) The rest API that this resource is part of.

        The reason we need the RestApi object itself and not just the ID is because the model
        is being tracked by the top-level RestApi object for the purpose of calculating it's
        hash to determine the ID of the deployment. This allows us to automatically update
        the deployment when the model of the REST API changes.

        :stability: experimental
        """
        ...

    @builtins.property # type: ignore
    @jsii.member(jsii_name="path")
    @abc.abstractmethod
    def path(self) -> builtins.str:
        """(experimental) The full path of this resuorce.

        :stability: experimental
        """
        ...

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceId")
    @abc.abstractmethod
    def resource_id(self) -> builtins.str:
        """(experimental) The ID of the resource.

        :stability: experimental
        """
        ...

    @builtins.property # type: ignore
    @jsii.member(jsii_name="restApi")
    @abc.abstractmethod
    def rest_api(self) -> "RestApi":
        """(deprecated) The rest API that this resource is part of.

        :deprecated: - Throws an error if this Resource is not associated with an instance of ``RestApi``. Use ``api`` instead.

        :stability: deprecated
        """
        ...

    @builtins.property # type: ignore
    @jsii.member(jsii_name="url")
    def url(self) -> builtins.str:
        """
        :deprecated: - Throws error in some use cases that have been enabled since this deprecation notice. Use ``RestApi.urlForPath()`` instead.

        :stability: deprecated
        """
        return jsii.get(self, "url")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="defaultCorsPreflightOptions")
    @abc.abstractmethod
    def default_cors_preflight_options(self) -> typing.Optional[CorsOptions]:
        """(experimental) Default options for CORS preflight OPTIONS method.

        :stability: experimental
        """
        ...

    @builtins.property # type: ignore
    @jsii.member(jsii_name="defaultIntegration")
    @abc.abstractmethod
    def default_integration(self) -> typing.Optional[Integration]:
        """(experimental) An integration to use as a default for all methods created within this API unless an integration is specified.

        :stability: experimental
        """
        ...

    @builtins.property # type: ignore
    @jsii.member(jsii_name="defaultMethodOptions")
    @abc.abstractmethod
    def default_method_options(self) -> typing.Optional[MethodOptions]:
        """(experimental) Method options to use as a default for all methods created within this API unless custom options are specified.

        :stability: experimental
        """
        ...

    @builtins.property # type: ignore
    @jsii.member(jsii_name="parentResource")
    @abc.abstractmethod
    def parent_resource(self) -> typing.Optional[IResource]:
        """(experimental) The parent of this resource or undefined for the root resource.

        :stability: experimental
        """
        ...


class _ResourceBaseProxy(
    ResourceBase, jsii.proxy_for(_Resource_abff4495) # type: ignore
):
    @builtins.property # type: ignore
    @jsii.member(jsii_name="api")
    def api(self) -> IRestApi:
        """(experimental) The rest API that this resource is part of.

        The reason we need the RestApi object itself and not just the ID is because the model
        is being tracked by the top-level RestApi object for the purpose of calculating it's
        hash to determine the ID of the deployment. This allows us to automatically update
        the deployment when the model of the REST API changes.

        :stability: experimental
        """
        return jsii.get(self, "api")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="path")
    def path(self) -> builtins.str:
        """(experimental) The full path of this resuorce.

        :stability: experimental
        """
        return jsii.get(self, "path")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceId")
    def resource_id(self) -> builtins.str:
        """(experimental) The ID of the resource.

        :stability: experimental
        """
        return jsii.get(self, "resourceId")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="restApi")
    def rest_api(self) -> "RestApi":
        """(deprecated) The rest API that this resource is part of.

        :deprecated: - Throws an error if this Resource is not associated with an instance of ``RestApi``. Use ``api`` instead.

        :stability: deprecated
        """
        return jsii.get(self, "restApi")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="defaultCorsPreflightOptions")
    def default_cors_preflight_options(self) -> typing.Optional[CorsOptions]:
        """(experimental) Default options for CORS preflight OPTIONS method.

        :stability: experimental
        """
        return jsii.get(self, "defaultCorsPreflightOptions")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="defaultIntegration")
    def default_integration(self) -> typing.Optional[Integration]:
        """(experimental) An integration to use as a default for all methods created within this API unless an integration is specified.

        :stability: experimental
        """
        return jsii.get(self, "defaultIntegration")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="defaultMethodOptions")
    def default_method_options(self) -> typing.Optional[MethodOptions]:
        """(experimental) Method options to use as a default for all methods created within this API unless custom options are specified.

        :stability: experimental
        """
        return jsii.get(self, "defaultMethodOptions")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="parentResource")
    def parent_resource(self) -> typing.Optional[IResource]:
        """(experimental) The parent of this resource or undefined for the root resource.

        :stability: experimental
        """
        return jsii.get(self, "parentResource")


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.ResourceOptions",
    jsii_struct_bases=[],
    name_mapping={
        "default_cors_preflight_options": "defaultCorsPreflightOptions",
        "default_integration": "defaultIntegration",
        "default_method_options": "defaultMethodOptions",
    },
)
class ResourceOptions:
    def __init__(
        self,
        *,
        default_cors_preflight_options: typing.Optional[CorsOptions] = None,
        default_integration: typing.Optional[Integration] = None,
        default_method_options: typing.Optional[MethodOptions] = None,
    ) -> None:
        """
        :param default_cors_preflight_options: (experimental) Adds a CORS preflight OPTIONS method to this resource and all child resources. You can add CORS at the resource-level using ``addCorsPreflight``. Default: - CORS is disabled
        :param default_integration: (experimental) An integration to use as a default for all methods created within this API unless an integration is specified. Default: - Inherited from parent.
        :param default_method_options: (experimental) Method options to use as a default for all methods created within this API unless custom options are specified. Default: - Inherited from parent.

        :stability: experimental
        """
        if isinstance(default_cors_preflight_options, dict):
            default_cors_preflight_options = CorsOptions(**default_cors_preflight_options)
        if isinstance(default_method_options, dict):
            default_method_options = MethodOptions(**default_method_options)
        self._values: typing.Dict[str, typing.Any] = {}
        if default_cors_preflight_options is not None:
            self._values["default_cors_preflight_options"] = default_cors_preflight_options
        if default_integration is not None:
            self._values["default_integration"] = default_integration
        if default_method_options is not None:
            self._values["default_method_options"] = default_method_options

    @builtins.property
    def default_cors_preflight_options(self) -> typing.Optional[CorsOptions]:
        """(experimental) Adds a CORS preflight OPTIONS method to this resource and all child resources.

        You can add CORS at the resource-level using ``addCorsPreflight``.

        :default: - CORS is disabled

        :stability: experimental
        """
        result = self._values.get("default_cors_preflight_options")
        return result

    @builtins.property
    def default_integration(self) -> typing.Optional[Integration]:
        """(experimental) An integration to use as a default for all methods created within this API unless an integration is specified.

        :default: - Inherited from parent.

        :stability: experimental
        """
        result = self._values.get("default_integration")
        return result

    @builtins.property
    def default_method_options(self) -> typing.Optional[MethodOptions]:
        """(experimental) Method options to use as a default for all methods created within this API unless custom options are specified.

        :default: - Inherited from parent.

        :stability: experimental
        """
        result = self._values.get("default_method_options")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ResourceOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.ResourceProps",
    jsii_struct_bases=[ResourceOptions],
    name_mapping={
        "default_cors_preflight_options": "defaultCorsPreflightOptions",
        "default_integration": "defaultIntegration",
        "default_method_options": "defaultMethodOptions",
        "parent": "parent",
        "path_part": "pathPart",
    },
)
class ResourceProps(ResourceOptions):
    def __init__(
        self,
        *,
        default_cors_preflight_options: typing.Optional[CorsOptions] = None,
        default_integration: typing.Optional[Integration] = None,
        default_method_options: typing.Optional[MethodOptions] = None,
        parent: IResource,
        path_part: builtins.str,
    ) -> None:
        """
        :param default_cors_preflight_options: (experimental) Adds a CORS preflight OPTIONS method to this resource and all child resources. You can add CORS at the resource-level using ``addCorsPreflight``. Default: - CORS is disabled
        :param default_integration: (experimental) An integration to use as a default for all methods created within this API unless an integration is specified. Default: - Inherited from parent.
        :param default_method_options: (experimental) Method options to use as a default for all methods created within this API unless custom options are specified. Default: - Inherited from parent.
        :param parent: (experimental) The parent resource of this resource. You can either pass another ``Resource`` object or a ``RestApi`` object here.
        :param path_part: (experimental) A path name for the resource.

        :stability: experimental
        """
        if isinstance(default_cors_preflight_options, dict):
            default_cors_preflight_options = CorsOptions(**default_cors_preflight_options)
        if isinstance(default_method_options, dict):
            default_method_options = MethodOptions(**default_method_options)
        self._values: typing.Dict[str, typing.Any] = {
            "parent": parent,
            "path_part": path_part,
        }
        if default_cors_preflight_options is not None:
            self._values["default_cors_preflight_options"] = default_cors_preflight_options
        if default_integration is not None:
            self._values["default_integration"] = default_integration
        if default_method_options is not None:
            self._values["default_method_options"] = default_method_options

    @builtins.property
    def default_cors_preflight_options(self) -> typing.Optional[CorsOptions]:
        """(experimental) Adds a CORS preflight OPTIONS method to this resource and all child resources.

        You can add CORS at the resource-level using ``addCorsPreflight``.

        :default: - CORS is disabled

        :stability: experimental
        """
        result = self._values.get("default_cors_preflight_options")
        return result

    @builtins.property
    def default_integration(self) -> typing.Optional[Integration]:
        """(experimental) An integration to use as a default for all methods created within this API unless an integration is specified.

        :default: - Inherited from parent.

        :stability: experimental
        """
        result = self._values.get("default_integration")
        return result

    @builtins.property
    def default_method_options(self) -> typing.Optional[MethodOptions]:
        """(experimental) Method options to use as a default for all methods created within this API unless custom options are specified.

        :default: - Inherited from parent.

        :stability: experimental
        """
        result = self._values.get("default_method_options")
        return result

    @builtins.property
    def parent(self) -> IResource:
        """(experimental) The parent resource of this resource.

        You can either pass another
        ``Resource`` object or a ``RestApi`` object here.

        :stability: experimental
        """
        result = self._values.get("parent")
        assert result is not None, "Required property 'parent' is missing"
        return result

    @builtins.property
    def path_part(self) -> builtins.str:
        """(experimental) A path name for the resource.

        :stability: experimental
        """
        result = self._values.get("path_part")
        assert result is not None, "Required property 'path_part' is missing"
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ResourceProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ResponseType(
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_apigateway.ResponseType",
):
    """(experimental) Supported types of gateway responses.

    :see: https://docs.aws.amazon.com/apigateway/latest/developerguide/supported-gateway-response-types.html
    :stability: experimental
    """

    @jsii.member(jsii_name="of")
    @builtins.classmethod
    def of(cls, type: builtins.str) -> "ResponseType":
        """(experimental) A custom response type to suppport future cases.

        :param type: -

        :stability: experimental
        """
        return jsii.sinvoke(cls, "of", [type])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="ACCESS_DENIED")
    def ACCESS_DENIED(cls) -> "ResponseType":
        """(experimental) The gateway response for authorization failure.

        :stability: experimental
        """
        return jsii.sget(cls, "ACCESS_DENIED")

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="API_CONFIGURATION_ERROR")
    def API_CONFIGURATION_ERROR(cls) -> "ResponseType":
        """(experimental) The gateway response for an invalid API configuration.

        :stability: experimental
        """
        return jsii.sget(cls, "API_CONFIGURATION_ERROR")

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="AUTHORIZER_CONFIGURATION_ERROR")
    def AUTHORIZER_CONFIGURATION_ERROR(cls) -> "ResponseType":
        """(experimental) The gateway response for failing to connect to a custom or Amazon Cognito authorizer.

        :stability: experimental
        """
        return jsii.sget(cls, "AUTHORIZER_CONFIGURATION_ERROR")

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="AUTHORIZER_FAILURE")
    def AUTHORIZER_FAILURE(cls) -> "ResponseType":
        """(experimental) The gateway response when a custom or Amazon Cognito authorizer failed to authenticate the caller.

        :stability: experimental
        """
        return jsii.sget(cls, "AUTHORIZER_FAILURE")

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="BAD_REQUEST_BODY")
    def BAD_REQUEST_BODY(cls) -> "ResponseType":
        """(experimental) The gateway response when the request body cannot be validated according to an enabled request validator.

        :stability: experimental
        """
        return jsii.sget(cls, "BAD_REQUEST_BODY")

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="BAD_REQUEST_PARAMETERS")
    def BAD_REQUEST_PARAMETERS(cls) -> "ResponseType":
        """(experimental) The gateway response when the request parameter cannot be validated according to an enabled request validator.

        :stability: experimental
        """
        return jsii.sget(cls, "BAD_REQUEST_PARAMETERS")

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="DEFAULT_4XX")
    def DEFAULT_4_XX(cls) -> "ResponseType":
        """(experimental) The default gateway response for an unspecified response type with the status code of 4XX.

        :stability: experimental
        """
        return jsii.sget(cls, "DEFAULT_4XX")

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="DEFAULT_5XX")
    def DEFAULT_5_XX(cls) -> "ResponseType":
        """(experimental) The default gateway response for an unspecified response type with a status code of 5XX.

        :stability: experimental
        """
        return jsii.sget(cls, "DEFAULT_5XX")

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="EXPIRED_TOKEN")
    def EXPIRED_TOKEN(cls) -> "ResponseType":
        """(experimental) The gateway response for an AWS authentication token expired error.

        :stability: experimental
        """
        return jsii.sget(cls, "EXPIRED_TOKEN")

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="INTEGRATION_FAILURE")
    def INTEGRATION_FAILURE(cls) -> "ResponseType":
        """(experimental) The gateway response for an integration failed error.

        :stability: experimental
        """
        return jsii.sget(cls, "INTEGRATION_FAILURE")

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="INTEGRATION_TIMEOUT")
    def INTEGRATION_TIMEOUT(cls) -> "ResponseType":
        """(experimental) The gateway response for an integration timed out error.

        :stability: experimental
        """
        return jsii.sget(cls, "INTEGRATION_TIMEOUT")

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="INVALID_API_KEY")
    def INVALID_API_KEY(cls) -> "ResponseType":
        """(experimental) The gateway response for an invalid API key submitted for a method requiring an API key.

        :stability: experimental
        """
        return jsii.sget(cls, "INVALID_API_KEY")

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="INVALID_SIGNATURE")
    def INVALID_SIGNATURE(cls) -> "ResponseType":
        """(experimental) The gateway response for an invalid AWS signature error.

        :stability: experimental
        """
        return jsii.sget(cls, "INVALID_SIGNATURE")

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="MISSING_AUTHENTICATION_TOKEN")
    def MISSING_AUTHENTICATION_TOKEN(cls) -> "ResponseType":
        """(experimental) The gateway response for a missing authentication token error, including the cases when the client attempts to invoke an unsupported API method or resource.

        :stability: experimental
        """
        return jsii.sget(cls, "MISSING_AUTHENTICATION_TOKEN")

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="QUOTA_EXCEEDED")
    def QUOTA_EXCEEDED(cls) -> "ResponseType":
        """(experimental) The gateway response for the usage plan quota exceeded error.

        :stability: experimental
        """
        return jsii.sget(cls, "QUOTA_EXCEEDED")

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="REQUEST_TOO_LARGE")
    def REQUEST_TOO_LARGE(cls) -> "ResponseType":
        """(experimental) The gateway response for the request too large error.

        :stability: experimental
        """
        return jsii.sget(cls, "REQUEST_TOO_LARGE")

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="RESOURCE_NOT_FOUND")
    def RESOURCE_NOT_FOUND(cls) -> "ResponseType":
        """(experimental) The gateway response when API Gateway cannot find the specified resource after an API request passes authentication and authorization.

        :stability: experimental
        """
        return jsii.sget(cls, "RESOURCE_NOT_FOUND")

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="THROTTLED")
    def THROTTLED(cls) -> "ResponseType":
        """(experimental) The gateway response when usage plan, method, stage, or account level throttling limits exceeded.

        :stability: experimental
        """
        return jsii.sget(cls, "THROTTLED")

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="UNAUTHORIZED")
    def UNAUTHORIZED(cls) -> "ResponseType":
        """(experimental) The gateway response when the custom or Amazon Cognito authorizer failed to authenticate the caller.

        :stability: experimental
        """
        return jsii.sget(cls, "UNAUTHORIZED")

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="UNSUPPORTED_MEDIA_TYPE")
    def UNSUPPORTED_MEDIA_TYPE(cls) -> "ResponseType":
        """(experimental) The gateway response when a payload is of an unsupported media type, if strict passthrough behavior is enabled.

        :stability: experimental
        """
        return jsii.sget(cls, "UNSUPPORTED_MEDIA_TYPE")

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="WAF_FILTERED")
    def WAF_FILTERED(cls) -> "ResponseType":
        """(experimental) The gateway response when a request is blocked by AWS WAF.

        :stability: experimental
        """
        return jsii.sget(cls, "WAF_FILTERED")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="responseType")
    def response_type(self) -> builtins.str:
        """(experimental) Valid value of response type.

        :stability: experimental
        """
        return jsii.get(self, "responseType")


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.RestApiAttributes",
    jsii_struct_bases=[],
    name_mapping={"rest_api_id": "restApiId", "root_resource_id": "rootResourceId"},
)
class RestApiAttributes:
    def __init__(
        self,
        *,
        rest_api_id: builtins.str,
        root_resource_id: builtins.str,
    ) -> None:
        """(experimental) Attributes that can be specified when importing a RestApi.

        :param rest_api_id: (experimental) The ID of the API Gateway RestApi.
        :param root_resource_id: (experimental) The resource ID of the root resource.

        :stability: experimental
        """
        self._values: typing.Dict[str, typing.Any] = {
            "rest_api_id": rest_api_id,
            "root_resource_id": root_resource_id,
        }

    @builtins.property
    def rest_api_id(self) -> builtins.str:
        """(experimental) The ID of the API Gateway RestApi.

        :stability: experimental
        """
        result = self._values.get("rest_api_id")
        assert result is not None, "Required property 'rest_api_id' is missing"
        return result

    @builtins.property
    def root_resource_id(self) -> builtins.str:
        """(experimental) The resource ID of the root resource.

        :stability: experimental
        """
        result = self._values.get("root_resource_id")
        assert result is not None, "Required property 'root_resource_id' is missing"
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "RestApiAttributes(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(IRestApi)
class RestApiBase(
    _Resource_abff4495,
    metaclass=jsii.JSIIAbstractClass,
    jsii_type="monocdk.aws_apigateway.RestApiBase",
):
    """(experimental) Base implementation that are common to various implementations of IRestApi.

    :stability: experimental
    """

    @builtins.staticmethod
    def __jsii_proxy_class__():
        return _RestApiBaseProxy

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        cloud_watch_role: typing.Optional[builtins.bool] = None,
        deploy: typing.Optional[builtins.bool] = None,
        deploy_options: typing.Optional["StageOptions"] = None,
        domain_name: typing.Optional[DomainNameOptions] = None,
        endpoint_export_name: typing.Optional[builtins.str] = None,
        endpoint_types: typing.Optional[typing.List[EndpointType]] = None,
        fail_on_warnings: typing.Optional[builtins.bool] = None,
        parameters: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        policy: typing.Optional[_PolicyDocument_b5de5177] = None,
        rest_api_name: typing.Optional[builtins.str] = None,
        retain_deployments: typing.Optional[builtins.bool] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param cloud_watch_role: (experimental) Automatically configure an AWS CloudWatch role for API Gateway. Default: true
        :param deploy: (experimental) Indicates if a Deployment should be automatically created for this API, and recreated when the API model (resources, methods) changes. Since API Gateway deployments are immutable, When this option is enabled (by default), an AWS::ApiGateway::Deployment resource will automatically created with a logical ID that hashes the API model (methods, resources and options). This means that when the model changes, the logical ID of this CloudFormation resource will change, and a new deployment will be created. If this is set, ``latestDeployment`` will refer to the ``Deployment`` object and ``deploymentStage`` will refer to a ``Stage`` that points to this deployment. To customize the stage options, use the ``deployOptions`` property. A CloudFormation Output will also be defined with the root URL endpoint of this REST API. Default: true
        :param deploy_options: (experimental) Options for the API Gateway stage that will always point to the latest deployment when ``deploy`` is enabled. If ``deploy`` is disabled, this value cannot be set. Default: - Based on defaults of ``StageOptions``.
        :param domain_name: (experimental) Configure a custom domain name and map it to this API. Default: - no domain name is defined, use ``addDomainName`` or directly define a ``DomainName``.
        :param endpoint_export_name: (experimental) Export name for the CfnOutput containing the API endpoint. Default: - when no export name is given, output will be created without export
        :param endpoint_types: (experimental) A list of the endpoint types of the API. Use this property when creating an API. Default: EndpointType.EDGE
        :param fail_on_warnings: (experimental) Indicates whether to roll back the resource if a warning occurs while API Gateway is creating the RestApi resource. Default: false
        :param parameters: (experimental) Custom header parameters for the request. Default: - No parameters.
        :param policy: (experimental) A policy document that contains the permissions for this RestApi. Default: - No policy.
        :param rest_api_name: (experimental) A name for the API Gateway RestApi resource. Default: - ID of the RestApi construct.
        :param retain_deployments: (experimental) Retains old deployment resources when the API changes. This allows manually reverting stages to point to old deployments via the AWS Console. Default: false

        :stability: experimental
        """
        props = RestApiBaseProps(
            cloud_watch_role=cloud_watch_role,
            deploy=deploy,
            deploy_options=deploy_options,
            domain_name=domain_name,
            endpoint_export_name=endpoint_export_name,
            endpoint_types=endpoint_types,
            fail_on_warnings=fail_on_warnings,
            parameters=parameters,
            policy=policy,
            rest_api_name=rest_api_name,
            retain_deployments=retain_deployments,
        )

        jsii.create(RestApiBase, self, [scope, id, props])

    @jsii.member(jsii_name="addDomainName")
    def add_domain_name(
        self,
        id: builtins.str,
        *,
        certificate: _ICertificate_c7bbdc16,
        domain_name: builtins.str,
        endpoint_type: typing.Optional[EndpointType] = None,
        mtls: typing.Optional[MTLSConfig] = None,
        security_policy: typing.Optional["SecurityPolicy"] = None,
    ) -> "DomainName":
        """(experimental) Defines an API Gateway domain name and maps it to this API.

        :param id: The construct id.
        :param certificate: (experimental) The reference to an AWS-managed certificate for use by the edge-optimized endpoint for the domain name. For "EDGE" domain names, the certificate needs to be in the US East (N. Virginia) region.
        :param domain_name: (experimental) The custom domain name for your API. Uppercase letters are not supported.
        :param endpoint_type: (experimental) The type of endpoint for this DomainName. Default: REGIONAL
        :param mtls: (experimental) The mutual TLS authentication configuration for a custom domain name. Default: - mTLS is not configured.
        :param security_policy: (experimental) The Transport Layer Security (TLS) version + cipher suite for this domain name. Default: SecurityPolicy.TLS_1_0

        :stability: experimental
        """
        options = DomainNameOptions(
            certificate=certificate,
            domain_name=domain_name,
            endpoint_type=endpoint_type,
            mtls=mtls,
            security_policy=security_policy,
        )

        return jsii.invoke(self, "addDomainName", [id, options])

    @jsii.member(jsii_name="addGatewayResponse")
    def add_gateway_response(
        self,
        id: builtins.str,
        *,
        type: ResponseType,
        response_headers: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        status_code: typing.Optional[builtins.str] = None,
        templates: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
    ) -> "GatewayResponse":
        """(experimental) Adds a new gateway response.

        :param id: -
        :param type: (experimental) Response type to associate with gateway response.
        :param response_headers: (experimental) Custom headers parameters for response. Default: - no headers
        :param status_code: (experimental) Http status code for response. Default: - standard http status code for the response type.
        :param templates: (experimental) Custom templates to get mapped as response. Default: - Response from api will be returned without applying any transformation.

        :stability: experimental
        """
        options = GatewayResponseOptions(
            type=type,
            response_headers=response_headers,
            status_code=status_code,
            templates=templates,
        )

        return jsii.invoke(self, "addGatewayResponse", [id, options])

    @jsii.member(jsii_name="addUsagePlan")
    def add_usage_plan(
        self,
        id: builtins.str,
        *,
        api_key: typing.Optional[IApiKey] = None,
        api_stages: typing.Optional[typing.List["UsagePlanPerApiStage"]] = None,
        description: typing.Optional[builtins.str] = None,
        name: typing.Optional[builtins.str] = None,
        quota: typing.Optional[QuotaSettings] = None,
        throttle: typing.Optional["ThrottleSettings"] = None,
    ) -> "UsagePlan":
        """(experimental) Adds a usage plan.

        :param id: -
        :param api_key: (experimental) ApiKey to be associated with the usage plan. Default: none
        :param api_stages: (experimental) API Stages to be associated with the usage plan. Default: none
        :param description: (experimental) Represents usage plan purpose. Default: none
        :param name: (experimental) Name for this usage plan. Default: none
        :param quota: (experimental) Number of requests clients can make in a given time period. Default: none
        :param throttle: (experimental) Overall throttle settings for the API. Default: none

        :stability: experimental
        """
        props = UsagePlanProps(
            api_key=api_key,
            api_stages=api_stages,
            description=description,
            name=name,
            quota=quota,
            throttle=throttle,
        )

        return jsii.invoke(self, "addUsagePlan", [id, props])

    @jsii.member(jsii_name="arnForExecuteApi")
    def arn_for_execute_api(
        self,
        method: typing.Optional[builtins.str] = None,
        path: typing.Optional[builtins.str] = None,
        stage: typing.Optional[builtins.str] = None,
    ) -> builtins.str:
        """(experimental) Gets the "execute-api" ARN.

        :param method: -
        :param path: -
        :param stage: -

        :stability: experimental
        """
        return jsii.invoke(self, "arnForExecuteApi", [method, path, stage])

    @jsii.member(jsii_name="configureCloudWatchRole")
    def _configure_cloud_watch_role(self, api_resource: CfnRestApi) -> None:
        """
        :param api_resource: -

        :stability: experimental
        """
        return jsii.invoke(self, "configureCloudWatchRole", [api_resource])

    @jsii.member(jsii_name="configureDeployment")
    def _configure_deployment(
        self,
        *,
        cloud_watch_role: typing.Optional[builtins.bool] = None,
        deploy: typing.Optional[builtins.bool] = None,
        deploy_options: typing.Optional["StageOptions"] = None,
        domain_name: typing.Optional[DomainNameOptions] = None,
        endpoint_export_name: typing.Optional[builtins.str] = None,
        endpoint_types: typing.Optional[typing.List[EndpointType]] = None,
        fail_on_warnings: typing.Optional[builtins.bool] = None,
        parameters: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        policy: typing.Optional[_PolicyDocument_b5de5177] = None,
        rest_api_name: typing.Optional[builtins.str] = None,
        retain_deployments: typing.Optional[builtins.bool] = None,
        default_cors_preflight_options: typing.Optional[CorsOptions] = None,
        default_integration: typing.Optional[Integration] = None,
        default_method_options: typing.Optional[MethodOptions] = None,
    ) -> None:
        """
        :param cloud_watch_role: (experimental) Automatically configure an AWS CloudWatch role for API Gateway. Default: true
        :param deploy: (experimental) Indicates if a Deployment should be automatically created for this API, and recreated when the API model (resources, methods) changes. Since API Gateway deployments are immutable, When this option is enabled (by default), an AWS::ApiGateway::Deployment resource will automatically created with a logical ID that hashes the API model (methods, resources and options). This means that when the model changes, the logical ID of this CloudFormation resource will change, and a new deployment will be created. If this is set, ``latestDeployment`` will refer to the ``Deployment`` object and ``deploymentStage`` will refer to a ``Stage`` that points to this deployment. To customize the stage options, use the ``deployOptions`` property. A CloudFormation Output will also be defined with the root URL endpoint of this REST API. Default: true
        :param deploy_options: (experimental) Options for the API Gateway stage that will always point to the latest deployment when ``deploy`` is enabled. If ``deploy`` is disabled, this value cannot be set. Default: - Based on defaults of ``StageOptions``.
        :param domain_name: (experimental) Configure a custom domain name and map it to this API. Default: - no domain name is defined, use ``addDomainName`` or directly define a ``DomainName``.
        :param endpoint_export_name: (experimental) Export name for the CfnOutput containing the API endpoint. Default: - when no export name is given, output will be created without export
        :param endpoint_types: (experimental) A list of the endpoint types of the API. Use this property when creating an API. Default: EndpointType.EDGE
        :param fail_on_warnings: (experimental) Indicates whether to roll back the resource if a warning occurs while API Gateway is creating the RestApi resource. Default: false
        :param parameters: (experimental) Custom header parameters for the request. Default: - No parameters.
        :param policy: (experimental) A policy document that contains the permissions for this RestApi. Default: - No policy.
        :param rest_api_name: (experimental) A name for the API Gateway RestApi resource. Default: - ID of the RestApi construct.
        :param retain_deployments: (experimental) Retains old deployment resources when the API changes. This allows manually reverting stages to point to old deployments via the AWS Console. Default: false
        :param default_cors_preflight_options: (experimental) Adds a CORS preflight OPTIONS method to this resource and all child resources. You can add CORS at the resource-level using ``addCorsPreflight``. Default: - CORS is disabled
        :param default_integration: (experimental) An integration to use as a default for all methods created within this API unless an integration is specified. Default: - Inherited from parent.
        :param default_method_options: (experimental) Method options to use as a default for all methods created within this API unless custom options are specified. Default: - Inherited from parent.

        :stability: experimental
        """
        props = RestApiOptions(
            cloud_watch_role=cloud_watch_role,
            deploy=deploy,
            deploy_options=deploy_options,
            domain_name=domain_name,
            endpoint_export_name=endpoint_export_name,
            endpoint_types=endpoint_types,
            fail_on_warnings=fail_on_warnings,
            parameters=parameters,
            policy=policy,
            rest_api_name=rest_api_name,
            retain_deployments=retain_deployments,
            default_cors_preflight_options=default_cors_preflight_options,
            default_integration=default_integration,
            default_method_options=default_method_options,
        )

        return jsii.invoke(self, "configureDeployment", [props])

    @jsii.member(jsii_name="metric")
    def metric(
        self,
        metric_name: builtins.str,
        *,
        account: typing.Optional[builtins.str] = None,
        color: typing.Optional[builtins.str] = None,
        dimensions: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        label: typing.Optional[builtins.str] = None,
        period: typing.Optional[_Duration_070aa057] = None,
        region: typing.Optional[builtins.str] = None,
        statistic: typing.Optional[builtins.str] = None,
        unit: typing.Optional[_Unit_113c79f9] = None,
    ) -> _Metric_5b2b8e58:
        """(experimental) Returns the given named metric for this API.

        :param metric_name: -
        :param account: (experimental) Account which this metric comes from. Default: - Deployment account.
        :param color: (experimental) The hex color code, prefixed with '#' (e.g. '#00ff00'), to use when this metric is rendered on a graph. The ``Color`` class has a set of standard colors that can be used here. Default: - Automatic color
        :param dimensions: (experimental) Dimensions of the metric. Default: - No dimensions.
        :param label: (experimental) Label for this metric when added to a Graph in a Dashboard. Default: - No label
        :param period: (experimental) The period over which the specified statistic is applied. Default: Duration.minutes(5)
        :param region: (experimental) Region which this metric comes from. Default: - Deployment region.
        :param statistic: (experimental) What function to use for aggregating. Can be one of the following: - "Minimum" | "min" - "Maximum" | "max" - "Average" | "avg" - "Sum" | "sum" - "SampleCount | "n" - "pNN.NN" Default: Average
        :param unit: (experimental) Unit used to filter the metric stream. Only refer to datums emitted to the metric stream with the given unit and ignore all others. Only useful when datums are being emitted to the same metric stream under different units. The default is to use all matric datums in the stream, regardless of unit, which is recommended in nearly all cases. CloudWatch does not honor this property for graphs. Default: - All metric datums in the given metric stream

        :stability: experimental
        """
        props = _MetricOptions_1c185ae8(
            account=account,
            color=color,
            dimensions=dimensions,
            label=label,
            period=period,
            region=region,
            statistic=statistic,
            unit=unit,
        )

        return jsii.invoke(self, "metric", [metric_name, props])

    @jsii.member(jsii_name="metricCacheHitCount")
    def metric_cache_hit_count(
        self,
        *,
        account: typing.Optional[builtins.str] = None,
        color: typing.Optional[builtins.str] = None,
        dimensions: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        label: typing.Optional[builtins.str] = None,
        period: typing.Optional[_Duration_070aa057] = None,
        region: typing.Optional[builtins.str] = None,
        statistic: typing.Optional[builtins.str] = None,
        unit: typing.Optional[_Unit_113c79f9] = None,
    ) -> _Metric_5b2b8e58:
        """(experimental) Metric for the number of requests served from the API cache in a given period.

        :param account: (experimental) Account which this metric comes from. Default: - Deployment account.
        :param color: (experimental) The hex color code, prefixed with '#' (e.g. '#00ff00'), to use when this metric is rendered on a graph. The ``Color`` class has a set of standard colors that can be used here. Default: - Automatic color
        :param dimensions: (experimental) Dimensions of the metric. Default: - No dimensions.
        :param label: (experimental) Label for this metric when added to a Graph in a Dashboard. Default: - No label
        :param period: (experimental) The period over which the specified statistic is applied. Default: Duration.minutes(5)
        :param region: (experimental) Region which this metric comes from. Default: - Deployment region.
        :param statistic: (experimental) What function to use for aggregating. Can be one of the following: - "Minimum" | "min" - "Maximum" | "max" - "Average" | "avg" - "Sum" | "sum" - "SampleCount | "n" - "pNN.NN" Default: Average
        :param unit: (experimental) Unit used to filter the metric stream. Only refer to datums emitted to the metric stream with the given unit and ignore all others. Only useful when datums are being emitted to the same metric stream under different units. The default is to use all matric datums in the stream, regardless of unit, which is recommended in nearly all cases. CloudWatch does not honor this property for graphs. Default: - All metric datums in the given metric stream

        :default: - sum over 5 minutes

        :stability: experimental
        """
        props = _MetricOptions_1c185ae8(
            account=account,
            color=color,
            dimensions=dimensions,
            label=label,
            period=period,
            region=region,
            statistic=statistic,
            unit=unit,
        )

        return jsii.invoke(self, "metricCacheHitCount", [props])

    @jsii.member(jsii_name="metricCacheMissCount")
    def metric_cache_miss_count(
        self,
        *,
        account: typing.Optional[builtins.str] = None,
        color: typing.Optional[builtins.str] = None,
        dimensions: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        label: typing.Optional[builtins.str] = None,
        period: typing.Optional[_Duration_070aa057] = None,
        region: typing.Optional[builtins.str] = None,
        statistic: typing.Optional[builtins.str] = None,
        unit: typing.Optional[_Unit_113c79f9] = None,
    ) -> _Metric_5b2b8e58:
        """(experimental) Metric for the number of requests served from the backend in a given period, when API caching is enabled.

        :param account: (experimental) Account which this metric comes from. Default: - Deployment account.
        :param color: (experimental) The hex color code, prefixed with '#' (e.g. '#00ff00'), to use when this metric is rendered on a graph. The ``Color`` class has a set of standard colors that can be used here. Default: - Automatic color
        :param dimensions: (experimental) Dimensions of the metric. Default: - No dimensions.
        :param label: (experimental) Label for this metric when added to a Graph in a Dashboard. Default: - No label
        :param period: (experimental) The period over which the specified statistic is applied. Default: Duration.minutes(5)
        :param region: (experimental) Region which this metric comes from. Default: - Deployment region.
        :param statistic: (experimental) What function to use for aggregating. Can be one of the following: - "Minimum" | "min" - "Maximum" | "max" - "Average" | "avg" - "Sum" | "sum" - "SampleCount | "n" - "pNN.NN" Default: Average
        :param unit: (experimental) Unit used to filter the metric stream. Only refer to datums emitted to the metric stream with the given unit and ignore all others. Only useful when datums are being emitted to the same metric stream under different units. The default is to use all matric datums in the stream, regardless of unit, which is recommended in nearly all cases. CloudWatch does not honor this property for graphs. Default: - All metric datums in the given metric stream

        :default: - sum over 5 minutes

        :stability: experimental
        """
        props = _MetricOptions_1c185ae8(
            account=account,
            color=color,
            dimensions=dimensions,
            label=label,
            period=period,
            region=region,
            statistic=statistic,
            unit=unit,
        )

        return jsii.invoke(self, "metricCacheMissCount", [props])

    @jsii.member(jsii_name="metricClientError")
    def metric_client_error(
        self,
        *,
        account: typing.Optional[builtins.str] = None,
        color: typing.Optional[builtins.str] = None,
        dimensions: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        label: typing.Optional[builtins.str] = None,
        period: typing.Optional[_Duration_070aa057] = None,
        region: typing.Optional[builtins.str] = None,
        statistic: typing.Optional[builtins.str] = None,
        unit: typing.Optional[_Unit_113c79f9] = None,
    ) -> _Metric_5b2b8e58:
        """(experimental) Metric for the number of client-side errors captured in a given period.

        :param account: (experimental) Account which this metric comes from. Default: - Deployment account.
        :param color: (experimental) The hex color code, prefixed with '#' (e.g. '#00ff00'), to use when this metric is rendered on a graph. The ``Color`` class has a set of standard colors that can be used here. Default: - Automatic color
        :param dimensions: (experimental) Dimensions of the metric. Default: - No dimensions.
        :param label: (experimental) Label for this metric when added to a Graph in a Dashboard. Default: - No label
        :param period: (experimental) The period over which the specified statistic is applied. Default: Duration.minutes(5)
        :param region: (experimental) Region which this metric comes from. Default: - Deployment region.
        :param statistic: (experimental) What function to use for aggregating. Can be one of the following: - "Minimum" | "min" - "Maximum" | "max" - "Average" | "avg" - "Sum" | "sum" - "SampleCount | "n" - "pNN.NN" Default: Average
        :param unit: (experimental) Unit used to filter the metric stream. Only refer to datums emitted to the metric stream with the given unit and ignore all others. Only useful when datums are being emitted to the same metric stream under different units. The default is to use all matric datums in the stream, regardless of unit, which is recommended in nearly all cases. CloudWatch does not honor this property for graphs. Default: - All metric datums in the given metric stream

        :default: - sum over 5 minutes

        :stability: experimental
        """
        props = _MetricOptions_1c185ae8(
            account=account,
            color=color,
            dimensions=dimensions,
            label=label,
            period=period,
            region=region,
            statistic=statistic,
            unit=unit,
        )

        return jsii.invoke(self, "metricClientError", [props])

    @jsii.member(jsii_name="metricCount")
    def metric_count(
        self,
        *,
        account: typing.Optional[builtins.str] = None,
        color: typing.Optional[builtins.str] = None,
        dimensions: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        label: typing.Optional[builtins.str] = None,
        period: typing.Optional[_Duration_070aa057] = None,
        region: typing.Optional[builtins.str] = None,
        statistic: typing.Optional[builtins.str] = None,
        unit: typing.Optional[_Unit_113c79f9] = None,
    ) -> _Metric_5b2b8e58:
        """(experimental) Metric for the total number API requests in a given period.

        :param account: (experimental) Account which this metric comes from. Default: - Deployment account.
        :param color: (experimental) The hex color code, prefixed with '#' (e.g. '#00ff00'), to use when this metric is rendered on a graph. The ``Color`` class has a set of standard colors that can be used here. Default: - Automatic color
        :param dimensions: (experimental) Dimensions of the metric. Default: - No dimensions.
        :param label: (experimental) Label for this metric when added to a Graph in a Dashboard. Default: - No label
        :param period: (experimental) The period over which the specified statistic is applied. Default: Duration.minutes(5)
        :param region: (experimental) Region which this metric comes from. Default: - Deployment region.
        :param statistic: (experimental) What function to use for aggregating. Can be one of the following: - "Minimum" | "min" - "Maximum" | "max" - "Average" | "avg" - "Sum" | "sum" - "SampleCount | "n" - "pNN.NN" Default: Average
        :param unit: (experimental) Unit used to filter the metric stream. Only refer to datums emitted to the metric stream with the given unit and ignore all others. Only useful when datums are being emitted to the same metric stream under different units. The default is to use all matric datums in the stream, regardless of unit, which is recommended in nearly all cases. CloudWatch does not honor this property for graphs. Default: - All metric datums in the given metric stream

        :default: - SampleCount over 5 minutes

        :stability: experimental
        """
        props = _MetricOptions_1c185ae8(
            account=account,
            color=color,
            dimensions=dimensions,
            label=label,
            period=period,
            region=region,
            statistic=statistic,
            unit=unit,
        )

        return jsii.invoke(self, "metricCount", [props])

    @jsii.member(jsii_name="metricIntegrationLatency")
    def metric_integration_latency(
        self,
        *,
        account: typing.Optional[builtins.str] = None,
        color: typing.Optional[builtins.str] = None,
        dimensions: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        label: typing.Optional[builtins.str] = None,
        period: typing.Optional[_Duration_070aa057] = None,
        region: typing.Optional[builtins.str] = None,
        statistic: typing.Optional[builtins.str] = None,
        unit: typing.Optional[_Unit_113c79f9] = None,
    ) -> _Metric_5b2b8e58:
        """(experimental) Metric for the time between when API Gateway relays a request to the backend and when it receives a response from the backend.

        :param account: (experimental) Account which this metric comes from. Default: - Deployment account.
        :param color: (experimental) The hex color code, prefixed with '#' (e.g. '#00ff00'), to use when this metric is rendered on a graph. The ``Color`` class has a set of standard colors that can be used here. Default: - Automatic color
        :param dimensions: (experimental) Dimensions of the metric. Default: - No dimensions.
        :param label: (experimental) Label for this metric when added to a Graph in a Dashboard. Default: - No label
        :param period: (experimental) The period over which the specified statistic is applied. Default: Duration.minutes(5)
        :param region: (experimental) Region which this metric comes from. Default: - Deployment region.
        :param statistic: (experimental) What function to use for aggregating. Can be one of the following: - "Minimum" | "min" - "Maximum" | "max" - "Average" | "avg" - "Sum" | "sum" - "SampleCount | "n" - "pNN.NN" Default: Average
        :param unit: (experimental) Unit used to filter the metric stream. Only refer to datums emitted to the metric stream with the given unit and ignore all others. Only useful when datums are being emitted to the same metric stream under different units. The default is to use all matric datums in the stream, regardless of unit, which is recommended in nearly all cases. CloudWatch does not honor this property for graphs. Default: - All metric datums in the given metric stream

        :default: - no statistic

        :stability: experimental
        """
        props = _MetricOptions_1c185ae8(
            account=account,
            color=color,
            dimensions=dimensions,
            label=label,
            period=period,
            region=region,
            statistic=statistic,
            unit=unit,
        )

        return jsii.invoke(self, "metricIntegrationLatency", [props])

    @jsii.member(jsii_name="metricLatency")
    def metric_latency(
        self,
        *,
        account: typing.Optional[builtins.str] = None,
        color: typing.Optional[builtins.str] = None,
        dimensions: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        label: typing.Optional[builtins.str] = None,
        period: typing.Optional[_Duration_070aa057] = None,
        region: typing.Optional[builtins.str] = None,
        statistic: typing.Optional[builtins.str] = None,
        unit: typing.Optional[_Unit_113c79f9] = None,
    ) -> _Metric_5b2b8e58:
        """(experimental) The time between when API Gateway receives a request from a client and when it returns a response to the client.

        The latency includes the integration latency and other API Gateway overhead.

        :param account: (experimental) Account which this metric comes from. Default: - Deployment account.
        :param color: (experimental) The hex color code, prefixed with '#' (e.g. '#00ff00'), to use when this metric is rendered on a graph. The ``Color`` class has a set of standard colors that can be used here. Default: - Automatic color
        :param dimensions: (experimental) Dimensions of the metric. Default: - No dimensions.
        :param label: (experimental) Label for this metric when added to a Graph in a Dashboard. Default: - No label
        :param period: (experimental) The period over which the specified statistic is applied. Default: Duration.minutes(5)
        :param region: (experimental) Region which this metric comes from. Default: - Deployment region.
        :param statistic: (experimental) What function to use for aggregating. Can be one of the following: - "Minimum" | "min" - "Maximum" | "max" - "Average" | "avg" - "Sum" | "sum" - "SampleCount | "n" - "pNN.NN" Default: Average
        :param unit: (experimental) Unit used to filter the metric stream. Only refer to datums emitted to the metric stream with the given unit and ignore all others. Only useful when datums are being emitted to the same metric stream under different units. The default is to use all matric datums in the stream, regardless of unit, which is recommended in nearly all cases. CloudWatch does not honor this property for graphs. Default: - All metric datums in the given metric stream

        :default: - no statistic

        :stability: experimental
        """
        props = _MetricOptions_1c185ae8(
            account=account,
            color=color,
            dimensions=dimensions,
            label=label,
            period=period,
            region=region,
            statistic=statistic,
            unit=unit,
        )

        return jsii.invoke(self, "metricLatency", [props])

    @jsii.member(jsii_name="metricServerError")
    def metric_server_error(
        self,
        *,
        account: typing.Optional[builtins.str] = None,
        color: typing.Optional[builtins.str] = None,
        dimensions: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        label: typing.Optional[builtins.str] = None,
        period: typing.Optional[_Duration_070aa057] = None,
        region: typing.Optional[builtins.str] = None,
        statistic: typing.Optional[builtins.str] = None,
        unit: typing.Optional[_Unit_113c79f9] = None,
    ) -> _Metric_5b2b8e58:
        """(experimental) Metric for the number of server-side errors captured in a given period.

        :param account: (experimental) Account which this metric comes from. Default: - Deployment account.
        :param color: (experimental) The hex color code, prefixed with '#' (e.g. '#00ff00'), to use when this metric is rendered on a graph. The ``Color`` class has a set of standard colors that can be used here. Default: - Automatic color
        :param dimensions: (experimental) Dimensions of the metric. Default: - No dimensions.
        :param label: (experimental) Label for this metric when added to a Graph in a Dashboard. Default: - No label
        :param period: (experimental) The period over which the specified statistic is applied. Default: Duration.minutes(5)
        :param region: (experimental) Region which this metric comes from. Default: - Deployment region.
        :param statistic: (experimental) What function to use for aggregating. Can be one of the following: - "Minimum" | "min" - "Maximum" | "max" - "Average" | "avg" - "Sum" | "sum" - "SampleCount | "n" - "pNN.NN" Default: Average
        :param unit: (experimental) Unit used to filter the metric stream. Only refer to datums emitted to the metric stream with the given unit and ignore all others. Only useful when datums are being emitted to the same metric stream under different units. The default is to use all matric datums in the stream, regardless of unit, which is recommended in nearly all cases. CloudWatch does not honor this property for graphs. Default: - All metric datums in the given metric stream

        :default: - sum over 5 minutes

        :stability: experimental
        """
        props = _MetricOptions_1c185ae8(
            account=account,
            color=color,
            dimensions=dimensions,
            label=label,
            period=period,
            region=region,
            statistic=statistic,
            unit=unit,
        )

        return jsii.invoke(self, "metricServerError", [props])

    @jsii.member(jsii_name="urlForPath")
    def url_for_path(self, path: typing.Optional[builtins.str] = None) -> builtins.str:
        """(experimental) Returns the URL for an HTTP path.

        Fails if ``deploymentStage`` is not set either by ``deploy`` or explicitly.

        :param path: -

        :stability: experimental
        """
        return jsii.invoke(self, "urlForPath", [path])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="restApiId")
    @abc.abstractmethod
    def rest_api_id(self) -> builtins.str:
        """(experimental) The ID of this API Gateway RestApi.

        :stability: experimental
        """
        ...

    @builtins.property # type: ignore
    @jsii.member(jsii_name="restApiName")
    def rest_api_name(self) -> builtins.str:
        """(experimental) A human friendly name for this Rest API.

        Note that this is different from ``restApiId``.

        :stability: experimental
        """
        return jsii.get(self, "restApiName")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="restApiRootResourceId")
    @abc.abstractmethod
    def rest_api_root_resource_id(self) -> builtins.str:
        """(experimental) The resource ID of the root resource.

        :stability: experimental
        :attribute: true
        """
        ...

    @builtins.property # type: ignore
    @jsii.member(jsii_name="root")
    @abc.abstractmethod
    def root(self) -> IResource:
        """(experimental) Represents the root resource of this API endpoint ('/').

        Resources and Methods are added to this resource.

        :stability: experimental
        """
        ...

    @builtins.property # type: ignore
    @jsii.member(jsii_name="domainName")
    def domain_name(self) -> typing.Optional["DomainName"]:
        """(experimental) The first domain name mapped to this API, if defined through the ``domainName`` configuration prop, or added via ``addDomainName``.

        :stability: experimental
        """
        return jsii.get(self, "domainName")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="latestDeployment")
    def latest_deployment(self) -> typing.Optional[Deployment]:
        """(experimental) API Gateway deployment that represents the latest changes of the API.

        This resource will be automatically updated every time the REST API model changes.
        This will be undefined if ``deploy`` is false.

        :stability: experimental
        """
        return jsii.get(self, "latestDeployment")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="deploymentStage")
    def deployment_stage(self) -> "Stage":
        """(experimental) API Gateway stage that points to the latest deployment (if defined).

        If ``deploy`` is disabled, you will need to explicitly assign this value in order to
        set up integrations.

        :stability: experimental
        """
        return jsii.get(self, "deploymentStage")

    @deployment_stage.setter # type: ignore
    def deployment_stage(self, value: "Stage") -> None:
        jsii.set(self, "deploymentStage", value)


class _RestApiBaseProxy(
    RestApiBase, jsii.proxy_for(_Resource_abff4495) # type: ignore
):
    @builtins.property # type: ignore
    @jsii.member(jsii_name="restApiId")
    def rest_api_id(self) -> builtins.str:
        """(experimental) The ID of this API Gateway RestApi.

        :stability: experimental
        """
        return jsii.get(self, "restApiId")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="restApiRootResourceId")
    def rest_api_root_resource_id(self) -> builtins.str:
        """(experimental) The resource ID of the root resource.

        :stability: experimental
        :attribute: true
        """
        return jsii.get(self, "restApiRootResourceId")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="root")
    def root(self) -> IResource:
        """(experimental) Represents the root resource of this API endpoint ('/').

        Resources and Methods are added to this resource.

        :stability: experimental
        """
        return jsii.get(self, "root")


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.RestApiBaseProps",
    jsii_struct_bases=[],
    name_mapping={
        "cloud_watch_role": "cloudWatchRole",
        "deploy": "deploy",
        "deploy_options": "deployOptions",
        "domain_name": "domainName",
        "endpoint_export_name": "endpointExportName",
        "endpoint_types": "endpointTypes",
        "fail_on_warnings": "failOnWarnings",
        "parameters": "parameters",
        "policy": "policy",
        "rest_api_name": "restApiName",
        "retain_deployments": "retainDeployments",
    },
)
class RestApiBaseProps:
    def __init__(
        self,
        *,
        cloud_watch_role: typing.Optional[builtins.bool] = None,
        deploy: typing.Optional[builtins.bool] = None,
        deploy_options: typing.Optional["StageOptions"] = None,
        domain_name: typing.Optional[DomainNameOptions] = None,
        endpoint_export_name: typing.Optional[builtins.str] = None,
        endpoint_types: typing.Optional[typing.List[EndpointType]] = None,
        fail_on_warnings: typing.Optional[builtins.bool] = None,
        parameters: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        policy: typing.Optional[_PolicyDocument_b5de5177] = None,
        rest_api_name: typing.Optional[builtins.str] = None,
        retain_deployments: typing.Optional[builtins.bool] = None,
    ) -> None:
        """(experimental) Represents the props that all Rest APIs share.

        :param cloud_watch_role: (experimental) Automatically configure an AWS CloudWatch role for API Gateway. Default: true
        :param deploy: (experimental) Indicates if a Deployment should be automatically created for this API, and recreated when the API model (resources, methods) changes. Since API Gateway deployments are immutable, When this option is enabled (by default), an AWS::ApiGateway::Deployment resource will automatically created with a logical ID that hashes the API model (methods, resources and options). This means that when the model changes, the logical ID of this CloudFormation resource will change, and a new deployment will be created. If this is set, ``latestDeployment`` will refer to the ``Deployment`` object and ``deploymentStage`` will refer to a ``Stage`` that points to this deployment. To customize the stage options, use the ``deployOptions`` property. A CloudFormation Output will also be defined with the root URL endpoint of this REST API. Default: true
        :param deploy_options: (experimental) Options for the API Gateway stage that will always point to the latest deployment when ``deploy`` is enabled. If ``deploy`` is disabled, this value cannot be set. Default: - Based on defaults of ``StageOptions``.
        :param domain_name: (experimental) Configure a custom domain name and map it to this API. Default: - no domain name is defined, use ``addDomainName`` or directly define a ``DomainName``.
        :param endpoint_export_name: (experimental) Export name for the CfnOutput containing the API endpoint. Default: - when no export name is given, output will be created without export
        :param endpoint_types: (experimental) A list of the endpoint types of the API. Use this property when creating an API. Default: EndpointType.EDGE
        :param fail_on_warnings: (experimental) Indicates whether to roll back the resource if a warning occurs while API Gateway is creating the RestApi resource. Default: false
        :param parameters: (experimental) Custom header parameters for the request. Default: - No parameters.
        :param policy: (experimental) A policy document that contains the permissions for this RestApi. Default: - No policy.
        :param rest_api_name: (experimental) A name for the API Gateway RestApi resource. Default: - ID of the RestApi construct.
        :param retain_deployments: (experimental) Retains old deployment resources when the API changes. This allows manually reverting stages to point to old deployments via the AWS Console. Default: false

        :stability: experimental
        """
        if isinstance(deploy_options, dict):
            deploy_options = StageOptions(**deploy_options)
        if isinstance(domain_name, dict):
            domain_name = DomainNameOptions(**domain_name)
        self._values: typing.Dict[str, typing.Any] = {}
        if cloud_watch_role is not None:
            self._values["cloud_watch_role"] = cloud_watch_role
        if deploy is not None:
            self._values["deploy"] = deploy
        if deploy_options is not None:
            self._values["deploy_options"] = deploy_options
        if domain_name is not None:
            self._values["domain_name"] = domain_name
        if endpoint_export_name is not None:
            self._values["endpoint_export_name"] = endpoint_export_name
        if endpoint_types is not None:
            self._values["endpoint_types"] = endpoint_types
        if fail_on_warnings is not None:
            self._values["fail_on_warnings"] = fail_on_warnings
        if parameters is not None:
            self._values["parameters"] = parameters
        if policy is not None:
            self._values["policy"] = policy
        if rest_api_name is not None:
            self._values["rest_api_name"] = rest_api_name
        if retain_deployments is not None:
            self._values["retain_deployments"] = retain_deployments

    @builtins.property
    def cloud_watch_role(self) -> typing.Optional[builtins.bool]:
        """(experimental) Automatically configure an AWS CloudWatch role for API Gateway.

        :default: true

        :stability: experimental
        """
        result = self._values.get("cloud_watch_role")
        return result

    @builtins.property
    def deploy(self) -> typing.Optional[builtins.bool]:
        """(experimental) Indicates if a Deployment should be automatically created for this API, and recreated when the API model (resources, methods) changes.

        Since API Gateway deployments are immutable, When this option is enabled
        (by default), an AWS::ApiGateway::Deployment resource will automatically
        created with a logical ID that hashes the API model (methods, resources
        and options). This means that when the model changes, the logical ID of
        this CloudFormation resource will change, and a new deployment will be
        created.

        If this is set, ``latestDeployment`` will refer to the ``Deployment`` object
        and ``deploymentStage`` will refer to a ``Stage`` that points to this
        deployment. To customize the stage options, use the ``deployOptions``
        property.

        A CloudFormation Output will also be defined with the root URL endpoint
        of this REST API.

        :default: true

        :stability: experimental
        """
        result = self._values.get("deploy")
        return result

    @builtins.property
    def deploy_options(self) -> typing.Optional["StageOptions"]:
        """(experimental) Options for the API Gateway stage that will always point to the latest deployment when ``deploy`` is enabled.

        If ``deploy`` is disabled,
        this value cannot be set.

        :default: - Based on defaults of ``StageOptions``.

        :stability: experimental
        """
        result = self._values.get("deploy_options")
        return result

    @builtins.property
    def domain_name(self) -> typing.Optional[DomainNameOptions]:
        """(experimental) Configure a custom domain name and map it to this API.

        :default: - no domain name is defined, use ``addDomainName`` or directly define a ``DomainName``.

        :stability: experimental
        """
        result = self._values.get("domain_name")
        return result

    @builtins.property
    def endpoint_export_name(self) -> typing.Optional[builtins.str]:
        """(experimental) Export name for the CfnOutput containing the API endpoint.

        :default: - when no export name is given, output will be created without export

        :stability: experimental
        """
        result = self._values.get("endpoint_export_name")
        return result

    @builtins.property
    def endpoint_types(self) -> typing.Optional[typing.List[EndpointType]]:
        """(experimental) A list of the endpoint types of the API.

        Use this property when creating
        an API.

        :default: EndpointType.EDGE

        :stability: experimental
        """
        result = self._values.get("endpoint_types")
        return result

    @builtins.property
    def fail_on_warnings(self) -> typing.Optional[builtins.bool]:
        """(experimental) Indicates whether to roll back the resource if a warning occurs while API Gateway is creating the RestApi resource.

        :default: false

        :stability: experimental
        """
        result = self._values.get("fail_on_warnings")
        return result

    @builtins.property
    def parameters(self) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        """(experimental) Custom header parameters for the request.

        :default: - No parameters.

        :see: https://docs.aws.amazon.com/cli/latest/reference/apigateway/import-rest-api.html
        :stability: experimental
        """
        result = self._values.get("parameters")
        return result

    @builtins.property
    def policy(self) -> typing.Optional[_PolicyDocument_b5de5177]:
        """(experimental) A policy document that contains the permissions for this RestApi.

        :default: - No policy.

        :stability: experimental
        """
        result = self._values.get("policy")
        return result

    @builtins.property
    def rest_api_name(self) -> typing.Optional[builtins.str]:
        """(experimental) A name for the API Gateway RestApi resource.

        :default: - ID of the RestApi construct.

        :stability: experimental
        """
        result = self._values.get("rest_api_name")
        return result

    @builtins.property
    def retain_deployments(self) -> typing.Optional[builtins.bool]:
        """(experimental) Retains old deployment resources when the API changes.

        This allows
        manually reverting stages to point to old deployments via the AWS
        Console.

        :default: false

        :stability: experimental
        """
        result = self._values.get("retain_deployments")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "RestApiBaseProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.RestApiOptions",
    jsii_struct_bases=[RestApiBaseProps, ResourceOptions],
    name_mapping={
        "cloud_watch_role": "cloudWatchRole",
        "deploy": "deploy",
        "deploy_options": "deployOptions",
        "domain_name": "domainName",
        "endpoint_export_name": "endpointExportName",
        "endpoint_types": "endpointTypes",
        "fail_on_warnings": "failOnWarnings",
        "parameters": "parameters",
        "policy": "policy",
        "rest_api_name": "restApiName",
        "retain_deployments": "retainDeployments",
        "default_cors_preflight_options": "defaultCorsPreflightOptions",
        "default_integration": "defaultIntegration",
        "default_method_options": "defaultMethodOptions",
    },
)
class RestApiOptions(RestApiBaseProps, ResourceOptions):
    def __init__(
        self,
        *,
        cloud_watch_role: typing.Optional[builtins.bool] = None,
        deploy: typing.Optional[builtins.bool] = None,
        deploy_options: typing.Optional["StageOptions"] = None,
        domain_name: typing.Optional[DomainNameOptions] = None,
        endpoint_export_name: typing.Optional[builtins.str] = None,
        endpoint_types: typing.Optional[typing.List[EndpointType]] = None,
        fail_on_warnings: typing.Optional[builtins.bool] = None,
        parameters: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        policy: typing.Optional[_PolicyDocument_b5de5177] = None,
        rest_api_name: typing.Optional[builtins.str] = None,
        retain_deployments: typing.Optional[builtins.bool] = None,
        default_cors_preflight_options: typing.Optional[CorsOptions] = None,
        default_integration: typing.Optional[Integration] = None,
        default_method_options: typing.Optional[MethodOptions] = None,
    ) -> None:
        """(deprecated) Represents the props that all Rest APIs share.

        :param cloud_watch_role: (experimental) Automatically configure an AWS CloudWatch role for API Gateway. Default: true
        :param deploy: (experimental) Indicates if a Deployment should be automatically created for this API, and recreated when the API model (resources, methods) changes. Since API Gateway deployments are immutable, When this option is enabled (by default), an AWS::ApiGateway::Deployment resource will automatically created with a logical ID that hashes the API model (methods, resources and options). This means that when the model changes, the logical ID of this CloudFormation resource will change, and a new deployment will be created. If this is set, ``latestDeployment`` will refer to the ``Deployment`` object and ``deploymentStage`` will refer to a ``Stage`` that points to this deployment. To customize the stage options, use the ``deployOptions`` property. A CloudFormation Output will also be defined with the root URL endpoint of this REST API. Default: true
        :param deploy_options: (experimental) Options for the API Gateway stage that will always point to the latest deployment when ``deploy`` is enabled. If ``deploy`` is disabled, this value cannot be set. Default: - Based on defaults of ``StageOptions``.
        :param domain_name: (experimental) Configure a custom domain name and map it to this API. Default: - no domain name is defined, use ``addDomainName`` or directly define a ``DomainName``.
        :param endpoint_export_name: (experimental) Export name for the CfnOutput containing the API endpoint. Default: - when no export name is given, output will be created without export
        :param endpoint_types: (experimental) A list of the endpoint types of the API. Use this property when creating an API. Default: EndpointType.EDGE
        :param fail_on_warnings: (experimental) Indicates whether to roll back the resource if a warning occurs while API Gateway is creating the RestApi resource. Default: false
        :param parameters: (experimental) Custom header parameters for the request. Default: - No parameters.
        :param policy: (experimental) A policy document that contains the permissions for this RestApi. Default: - No policy.
        :param rest_api_name: (experimental) A name for the API Gateway RestApi resource. Default: - ID of the RestApi construct.
        :param retain_deployments: (experimental) Retains old deployment resources when the API changes. This allows manually reverting stages to point to old deployments via the AWS Console. Default: false
        :param default_cors_preflight_options: (experimental) Adds a CORS preflight OPTIONS method to this resource and all child resources. You can add CORS at the resource-level using ``addCorsPreflight``. Default: - CORS is disabled
        :param default_integration: (experimental) An integration to use as a default for all methods created within this API unless an integration is specified. Default: - Inherited from parent.
        :param default_method_options: (experimental) Method options to use as a default for all methods created within this API unless custom options are specified. Default: - Inherited from parent.

        :deprecated: - superceded by ``RestApiBaseProps``

        :stability: deprecated
        """
        if isinstance(deploy_options, dict):
            deploy_options = StageOptions(**deploy_options)
        if isinstance(domain_name, dict):
            domain_name = DomainNameOptions(**domain_name)
        if isinstance(default_cors_preflight_options, dict):
            default_cors_preflight_options = CorsOptions(**default_cors_preflight_options)
        if isinstance(default_method_options, dict):
            default_method_options = MethodOptions(**default_method_options)
        self._values: typing.Dict[str, typing.Any] = {}
        if cloud_watch_role is not None:
            self._values["cloud_watch_role"] = cloud_watch_role
        if deploy is not None:
            self._values["deploy"] = deploy
        if deploy_options is not None:
            self._values["deploy_options"] = deploy_options
        if domain_name is not None:
            self._values["domain_name"] = domain_name
        if endpoint_export_name is not None:
            self._values["endpoint_export_name"] = endpoint_export_name
        if endpoint_types is not None:
            self._values["endpoint_types"] = endpoint_types
        if fail_on_warnings is not None:
            self._values["fail_on_warnings"] = fail_on_warnings
        if parameters is not None:
            self._values["parameters"] = parameters
        if policy is not None:
            self._values["policy"] = policy
        if rest_api_name is not None:
            self._values["rest_api_name"] = rest_api_name
        if retain_deployments is not None:
            self._values["retain_deployments"] = retain_deployments
        if default_cors_preflight_options is not None:
            self._values["default_cors_preflight_options"] = default_cors_preflight_options
        if default_integration is not None:
            self._values["default_integration"] = default_integration
        if default_method_options is not None:
            self._values["default_method_options"] = default_method_options

    @builtins.property
    def cloud_watch_role(self) -> typing.Optional[builtins.bool]:
        """(experimental) Automatically configure an AWS CloudWatch role for API Gateway.

        :default: true

        :stability: experimental
        """
        result = self._values.get("cloud_watch_role")
        return result

    @builtins.property
    def deploy(self) -> typing.Optional[builtins.bool]:
        """(experimental) Indicates if a Deployment should be automatically created for this API, and recreated when the API model (resources, methods) changes.

        Since API Gateway deployments are immutable, When this option is enabled
        (by default), an AWS::ApiGateway::Deployment resource will automatically
        created with a logical ID that hashes the API model (methods, resources
        and options). This means that when the model changes, the logical ID of
        this CloudFormation resource will change, and a new deployment will be
        created.

        If this is set, ``latestDeployment`` will refer to the ``Deployment`` object
        and ``deploymentStage`` will refer to a ``Stage`` that points to this
        deployment. To customize the stage options, use the ``deployOptions``
        property.

        A CloudFormation Output will also be defined with the root URL endpoint
        of this REST API.

        :default: true

        :stability: experimental
        """
        result = self._values.get("deploy")
        return result

    @builtins.property
    def deploy_options(self) -> typing.Optional["StageOptions"]:
        """(experimental) Options for the API Gateway stage that will always point to the latest deployment when ``deploy`` is enabled.

        If ``deploy`` is disabled,
        this value cannot be set.

        :default: - Based on defaults of ``StageOptions``.

        :stability: experimental
        """
        result = self._values.get("deploy_options")
        return result

    @builtins.property
    def domain_name(self) -> typing.Optional[DomainNameOptions]:
        """(experimental) Configure a custom domain name and map it to this API.

        :default: - no domain name is defined, use ``addDomainName`` or directly define a ``DomainName``.

        :stability: experimental
        """
        result = self._values.get("domain_name")
        return result

    @builtins.property
    def endpoint_export_name(self) -> typing.Optional[builtins.str]:
        """(experimental) Export name for the CfnOutput containing the API endpoint.

        :default: - when no export name is given, output will be created without export

        :stability: experimental
        """
        result = self._values.get("endpoint_export_name")
        return result

    @builtins.property
    def endpoint_types(self) -> typing.Optional[typing.List[EndpointType]]:
        """(experimental) A list of the endpoint types of the API.

        Use this property when creating
        an API.

        :default: EndpointType.EDGE

        :stability: experimental
        """
        result = self._values.get("endpoint_types")
        return result

    @builtins.property
    def fail_on_warnings(self) -> typing.Optional[builtins.bool]:
        """(experimental) Indicates whether to roll back the resource if a warning occurs while API Gateway is creating the RestApi resource.

        :default: false

        :stability: experimental
        """
        result = self._values.get("fail_on_warnings")
        return result

    @builtins.property
    def parameters(self) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        """(experimental) Custom header parameters for the request.

        :default: - No parameters.

        :see: https://docs.aws.amazon.com/cli/latest/reference/apigateway/import-rest-api.html
        :stability: experimental
        """
        result = self._values.get("parameters")
        return result

    @builtins.property
    def policy(self) -> typing.Optional[_PolicyDocument_b5de5177]:
        """(experimental) A policy document that contains the permissions for this RestApi.

        :default: - No policy.

        :stability: experimental
        """
        result = self._values.get("policy")
        return result

    @builtins.property
    def rest_api_name(self) -> typing.Optional[builtins.str]:
        """(experimental) A name for the API Gateway RestApi resource.

        :default: - ID of the RestApi construct.

        :stability: experimental
        """
        result = self._values.get("rest_api_name")
        return result

    @builtins.property
    def retain_deployments(self) -> typing.Optional[builtins.bool]:
        """(experimental) Retains old deployment resources when the API changes.

        This allows
        manually reverting stages to point to old deployments via the AWS
        Console.

        :default: false

        :stability: experimental
        """
        result = self._values.get("retain_deployments")
        return result

    @builtins.property
    def default_cors_preflight_options(self) -> typing.Optional[CorsOptions]:
        """(experimental) Adds a CORS preflight OPTIONS method to this resource and all child resources.

        You can add CORS at the resource-level using ``addCorsPreflight``.

        :default: - CORS is disabled

        :stability: experimental
        """
        result = self._values.get("default_cors_preflight_options")
        return result

    @builtins.property
    def default_integration(self) -> typing.Optional[Integration]:
        """(experimental) An integration to use as a default for all methods created within this API unless an integration is specified.

        :default: - Inherited from parent.

        :stability: experimental
        """
        result = self._values.get("default_integration")
        return result

    @builtins.property
    def default_method_options(self) -> typing.Optional[MethodOptions]:
        """(experimental) Method options to use as a default for all methods created within this API unless custom options are specified.

        :default: - Inherited from parent.

        :stability: experimental
        """
        result = self._values.get("default_method_options")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "RestApiOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.RestApiProps",
    jsii_struct_bases=[RestApiOptions],
    name_mapping={
        "cloud_watch_role": "cloudWatchRole",
        "deploy": "deploy",
        "deploy_options": "deployOptions",
        "domain_name": "domainName",
        "endpoint_export_name": "endpointExportName",
        "endpoint_types": "endpointTypes",
        "fail_on_warnings": "failOnWarnings",
        "parameters": "parameters",
        "policy": "policy",
        "rest_api_name": "restApiName",
        "retain_deployments": "retainDeployments",
        "default_cors_preflight_options": "defaultCorsPreflightOptions",
        "default_integration": "defaultIntegration",
        "default_method_options": "defaultMethodOptions",
        "api_key_source_type": "apiKeySourceType",
        "binary_media_types": "binaryMediaTypes",
        "clone_from": "cloneFrom",
        "description": "description",
        "endpoint_configuration": "endpointConfiguration",
        "minimum_compression_size": "minimumCompressionSize",
    },
)
class RestApiProps(RestApiOptions):
    def __init__(
        self,
        *,
        cloud_watch_role: typing.Optional[builtins.bool] = None,
        deploy: typing.Optional[builtins.bool] = None,
        deploy_options: typing.Optional["StageOptions"] = None,
        domain_name: typing.Optional[DomainNameOptions] = None,
        endpoint_export_name: typing.Optional[builtins.str] = None,
        endpoint_types: typing.Optional[typing.List[EndpointType]] = None,
        fail_on_warnings: typing.Optional[builtins.bool] = None,
        parameters: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        policy: typing.Optional[_PolicyDocument_b5de5177] = None,
        rest_api_name: typing.Optional[builtins.str] = None,
        retain_deployments: typing.Optional[builtins.bool] = None,
        default_cors_preflight_options: typing.Optional[CorsOptions] = None,
        default_integration: typing.Optional[Integration] = None,
        default_method_options: typing.Optional[MethodOptions] = None,
        api_key_source_type: typing.Optional[ApiKeySourceType] = None,
        binary_media_types: typing.Optional[typing.List[builtins.str]] = None,
        clone_from: typing.Optional[IRestApi] = None,
        description: typing.Optional[builtins.str] = None,
        endpoint_configuration: typing.Optional[EndpointConfiguration] = None,
        minimum_compression_size: typing.Optional[jsii.Number] = None,
    ) -> None:
        """(experimental) Props to create a new instance of RestApi.

        :param cloud_watch_role: (experimental) Automatically configure an AWS CloudWatch role for API Gateway. Default: true
        :param deploy: (experimental) Indicates if a Deployment should be automatically created for this API, and recreated when the API model (resources, methods) changes. Since API Gateway deployments are immutable, When this option is enabled (by default), an AWS::ApiGateway::Deployment resource will automatically created with a logical ID that hashes the API model (methods, resources and options). This means that when the model changes, the logical ID of this CloudFormation resource will change, and a new deployment will be created. If this is set, ``latestDeployment`` will refer to the ``Deployment`` object and ``deploymentStage`` will refer to a ``Stage`` that points to this deployment. To customize the stage options, use the ``deployOptions`` property. A CloudFormation Output will also be defined with the root URL endpoint of this REST API. Default: true
        :param deploy_options: (experimental) Options for the API Gateway stage that will always point to the latest deployment when ``deploy`` is enabled. If ``deploy`` is disabled, this value cannot be set. Default: - Based on defaults of ``StageOptions``.
        :param domain_name: (experimental) Configure a custom domain name and map it to this API. Default: - no domain name is defined, use ``addDomainName`` or directly define a ``DomainName``.
        :param endpoint_export_name: (experimental) Export name for the CfnOutput containing the API endpoint. Default: - when no export name is given, output will be created without export
        :param endpoint_types: (experimental) A list of the endpoint types of the API. Use this property when creating an API. Default: EndpointType.EDGE
        :param fail_on_warnings: (experimental) Indicates whether to roll back the resource if a warning occurs while API Gateway is creating the RestApi resource. Default: false
        :param parameters: (experimental) Custom header parameters for the request. Default: - No parameters.
        :param policy: (experimental) A policy document that contains the permissions for this RestApi. Default: - No policy.
        :param rest_api_name: (experimental) A name for the API Gateway RestApi resource. Default: - ID of the RestApi construct.
        :param retain_deployments: (experimental) Retains old deployment resources when the API changes. This allows manually reverting stages to point to old deployments via the AWS Console. Default: false
        :param default_cors_preflight_options: (experimental) Adds a CORS preflight OPTIONS method to this resource and all child resources. You can add CORS at the resource-level using ``addCorsPreflight``. Default: - CORS is disabled
        :param default_integration: (experimental) An integration to use as a default for all methods created within this API unless an integration is specified. Default: - Inherited from parent.
        :param default_method_options: (experimental) Method options to use as a default for all methods created within this API unless custom options are specified. Default: - Inherited from parent.
        :param api_key_source_type: (experimental) The source of the API key for metering requests according to a usage plan. Default: - Metering is disabled.
        :param binary_media_types: (experimental) The list of binary media mime-types that are supported by the RestApi resource, such as "image/png" or "application/octet-stream". Default: - RestApi supports only UTF-8-encoded text payloads.
        :param clone_from: (experimental) The ID of the API Gateway RestApi resource that you want to clone. Default: - None.
        :param description: (experimental) A description of the purpose of this API Gateway RestApi resource. Default: - No description.
        :param endpoint_configuration: (experimental) The EndpointConfiguration property type specifies the endpoint types of a REST API. Default: EndpointType.EDGE
        :param minimum_compression_size: (experimental) A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (when undefined) on an API. When compression is enabled, compression or decompression is not applied on the payload if the payload size is smaller than this value. Setting it to zero allows compression for any payload size. Default: - Compression is disabled.

        :stability: experimental
        """
        if isinstance(deploy_options, dict):
            deploy_options = StageOptions(**deploy_options)
        if isinstance(domain_name, dict):
            domain_name = DomainNameOptions(**domain_name)
        if isinstance(default_cors_preflight_options, dict):
            default_cors_preflight_options = CorsOptions(**default_cors_preflight_options)
        if isinstance(default_method_options, dict):
            default_method_options = MethodOptions(**default_method_options)
        if isinstance(endpoint_configuration, dict):
            endpoint_configuration = EndpointConfiguration(**endpoint_configuration)
        self._values: typing.Dict[str, typing.Any] = {}
        if cloud_watch_role is not None:
            self._values["cloud_watch_role"] = cloud_watch_role
        if deploy is not None:
            self._values["deploy"] = deploy
        if deploy_options is not None:
            self._values["deploy_options"] = deploy_options
        if domain_name is not None:
            self._values["domain_name"] = domain_name
        if endpoint_export_name is not None:
            self._values["endpoint_export_name"] = endpoint_export_name
        if endpoint_types is not None:
            self._values["endpoint_types"] = endpoint_types
        if fail_on_warnings is not None:
            self._values["fail_on_warnings"] = fail_on_warnings
        if parameters is not None:
            self._values["parameters"] = parameters
        if policy is not None:
            self._values["policy"] = policy
        if rest_api_name is not None:
            self._values["rest_api_name"] = rest_api_name
        if retain_deployments is not None:
            self._values["retain_deployments"] = retain_deployments
        if default_cors_preflight_options is not None:
            self._values["default_cors_preflight_options"] = default_cors_preflight_options
        if default_integration is not None:
            self._values["default_integration"] = default_integration
        if default_method_options is not None:
            self._values["default_method_options"] = default_method_options
        if api_key_source_type is not None:
            self._values["api_key_source_type"] = api_key_source_type
        if binary_media_types is not None:
            self._values["binary_media_types"] = binary_media_types
        if clone_from is not None:
            self._values["clone_from"] = clone_from
        if description is not None:
            self._values["description"] = description
        if endpoint_configuration is not None:
            self._values["endpoint_configuration"] = endpoint_configuration
        if minimum_compression_size is not None:
            self._values["minimum_compression_size"] = minimum_compression_size

    @builtins.property
    def cloud_watch_role(self) -> typing.Optional[builtins.bool]:
        """(experimental) Automatically configure an AWS CloudWatch role for API Gateway.

        :default: true

        :stability: experimental
        """
        result = self._values.get("cloud_watch_role")
        return result

    @builtins.property
    def deploy(self) -> typing.Optional[builtins.bool]:
        """(experimental) Indicates if a Deployment should be automatically created for this API, and recreated when the API model (resources, methods) changes.

        Since API Gateway deployments are immutable, When this option is enabled
        (by default), an AWS::ApiGateway::Deployment resource will automatically
        created with a logical ID that hashes the API model (methods, resources
        and options). This means that when the model changes, the logical ID of
        this CloudFormation resource will change, and a new deployment will be
        created.

        If this is set, ``latestDeployment`` will refer to the ``Deployment`` object
        and ``deploymentStage`` will refer to a ``Stage`` that points to this
        deployment. To customize the stage options, use the ``deployOptions``
        property.

        A CloudFormation Output will also be defined with the root URL endpoint
        of this REST API.

        :default: true

        :stability: experimental
        """
        result = self._values.get("deploy")
        return result

    @builtins.property
    def deploy_options(self) -> typing.Optional["StageOptions"]:
        """(experimental) Options for the API Gateway stage that will always point to the latest deployment when ``deploy`` is enabled.

        If ``deploy`` is disabled,
        this value cannot be set.

        :default: - Based on defaults of ``StageOptions``.

        :stability: experimental
        """
        result = self._values.get("deploy_options")
        return result

    @builtins.property
    def domain_name(self) -> typing.Optional[DomainNameOptions]:
        """(experimental) Configure a custom domain name and map it to this API.

        :default: - no domain name is defined, use ``addDomainName`` or directly define a ``DomainName``.

        :stability: experimental
        """
        result = self._values.get("domain_name")
        return result

    @builtins.property
    def endpoint_export_name(self) -> typing.Optional[builtins.str]:
        """(experimental) Export name for the CfnOutput containing the API endpoint.

        :default: - when no export name is given, output will be created without export

        :stability: experimental
        """
        result = self._values.get("endpoint_export_name")
        return result

    @builtins.property
    def endpoint_types(self) -> typing.Optional[typing.List[EndpointType]]:
        """(experimental) A list of the endpoint types of the API.

        Use this property when creating
        an API.

        :default: EndpointType.EDGE

        :stability: experimental
        """
        result = self._values.get("endpoint_types")
        return result

    @builtins.property
    def fail_on_warnings(self) -> typing.Optional[builtins.bool]:
        """(experimental) Indicates whether to roll back the resource if a warning occurs while API Gateway is creating the RestApi resource.

        :default: false

        :stability: experimental
        """
        result = self._values.get("fail_on_warnings")
        return result

    @builtins.property
    def parameters(self) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        """(experimental) Custom header parameters for the request.

        :default: - No parameters.

        :see: https://docs.aws.amazon.com/cli/latest/reference/apigateway/import-rest-api.html
        :stability: experimental
        """
        result = self._values.get("parameters")
        return result

    @builtins.property
    def policy(self) -> typing.Optional[_PolicyDocument_b5de5177]:
        """(experimental) A policy document that contains the permissions for this RestApi.

        :default: - No policy.

        :stability: experimental
        """
        result = self._values.get("policy")
        return result

    @builtins.property
    def rest_api_name(self) -> typing.Optional[builtins.str]:
        """(experimental) A name for the API Gateway RestApi resource.

        :default: - ID of the RestApi construct.

        :stability: experimental
        """
        result = self._values.get("rest_api_name")
        return result

    @builtins.property
    def retain_deployments(self) -> typing.Optional[builtins.bool]:
        """(experimental) Retains old deployment resources when the API changes.

        This allows
        manually reverting stages to point to old deployments via the AWS
        Console.

        :default: false

        :stability: experimental
        """
        result = self._values.get("retain_deployments")
        return result

    @builtins.property
    def default_cors_preflight_options(self) -> typing.Optional[CorsOptions]:
        """(experimental) Adds a CORS preflight OPTIONS method to this resource and all child resources.

        You can add CORS at the resource-level using ``addCorsPreflight``.

        :default: - CORS is disabled

        :stability: experimental
        """
        result = self._values.get("default_cors_preflight_options")
        return result

    @builtins.property
    def default_integration(self) -> typing.Optional[Integration]:
        """(experimental) An integration to use as a default for all methods created within this API unless an integration is specified.

        :default: - Inherited from parent.

        :stability: experimental
        """
        result = self._values.get("default_integration")
        return result

    @builtins.property
    def default_method_options(self) -> typing.Optional[MethodOptions]:
        """(experimental) Method options to use as a default for all methods created within this API unless custom options are specified.

        :default: - Inherited from parent.

        :stability: experimental
        """
        result = self._values.get("default_method_options")
        return result

    @builtins.property
    def api_key_source_type(self) -> typing.Optional[ApiKeySourceType]:
        """(experimental) The source of the API key for metering requests according to a usage plan.

        :default: - Metering is disabled.

        :stability: experimental
        """
        result = self._values.get("api_key_source_type")
        return result

    @builtins.property
    def binary_media_types(self) -> typing.Optional[typing.List[builtins.str]]:
        """(experimental) The list of binary media mime-types that are supported by the RestApi resource, such as "image/png" or "application/octet-stream".

        :default: - RestApi supports only UTF-8-encoded text payloads.

        :stability: experimental
        """
        result = self._values.get("binary_media_types")
        return result

    @builtins.property
    def clone_from(self) -> typing.Optional[IRestApi]:
        """(experimental) The ID of the API Gateway RestApi resource that you want to clone.

        :default: - None.

        :stability: experimental
        """
        result = self._values.get("clone_from")
        return result

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        """(experimental) A description of the purpose of this API Gateway RestApi resource.

        :default: - No description.

        :stability: experimental
        """
        result = self._values.get("description")
        return result

    @builtins.property
    def endpoint_configuration(self) -> typing.Optional[EndpointConfiguration]:
        """(experimental) The EndpointConfiguration property type specifies the endpoint types of a REST API.

        :default: EndpointType.EDGE

        :see: https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-endpointconfiguration.html
        :stability: experimental
        """
        result = self._values.get("endpoint_configuration")
        return result

    @builtins.property
    def minimum_compression_size(self) -> typing.Optional[jsii.Number]:
        """(experimental) A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (when undefined) on an API.

        When compression is enabled, compression or
        decompression is not applied on the payload if the payload size is
        smaller than this value. Setting it to zero allows compression for any
        payload size.

        :default: - Compression is disabled.

        :stability: experimental
        """
        result = self._values.get("minimum_compression_size")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "RestApiProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class S3ApiDefinition(
    ApiDefinition,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_apigateway.S3ApiDefinition",
):
    """(experimental) OpenAPI specification from an S3 archive.

    :stability: experimental
    """

    def __init__(
        self,
        bucket: _IBucket_73486e29,
        key: builtins.str,
        object_version: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param bucket: -
        :param key: -
        :param object_version: -

        :stability: experimental
        """
        jsii.create(S3ApiDefinition, self, [bucket, key, object_version])

    @jsii.member(jsii_name="bind")
    def bind(self, _scope: _Construct_e78e779f) -> ApiDefinitionConfig:
        """(experimental) Called when the specification is initialized to allow this object to bind to the stack, add resources and have fun.

        :param _scope: -

        :stability: experimental
        """
        return jsii.invoke(self, "bind", [_scope])


@jsii.enum(jsii_type="monocdk.aws_apigateway.SecurityPolicy")
class SecurityPolicy(enum.Enum):
    """(experimental) The minimum version of the SSL protocol that you want API Gateway to use for HTTPS connections.

    :stability: experimental
    """

    TLS_1_0 = "TLS_1_0"
    """(experimental) Cipher suite TLS 1.0.

    :stability: experimental
    """
    TLS_1_2 = "TLS_1_2"
    """(experimental) Cipher suite TLS 1.2.

    :stability: experimental
    """


class SpecRestApi(
    RestApiBase,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_apigateway.SpecRestApi",
):
    """(experimental) Represents a REST API in Amazon API Gateway, created with an OpenAPI specification.

    Some properties normally accessible on @see {@link RestApi} - such as the description -
    must be declared in the specification. All Resources and Methods need to be defined as
    part of the OpenAPI specification file, and cannot be added via the CDK.

    By default, the API will automatically be deployed and accessible from a
    public endpoint.

    :stability: experimental
    :resource: AWS::ApiGateway::RestApi
    """

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        api_definition: ApiDefinition,
        cloud_watch_role: typing.Optional[builtins.bool] = None,
        deploy: typing.Optional[builtins.bool] = None,
        deploy_options: typing.Optional["StageOptions"] = None,
        domain_name: typing.Optional[DomainNameOptions] = None,
        endpoint_export_name: typing.Optional[builtins.str] = None,
        endpoint_types: typing.Optional[typing.List[EndpointType]] = None,
        fail_on_warnings: typing.Optional[builtins.bool] = None,
        parameters: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        policy: typing.Optional[_PolicyDocument_b5de5177] = None,
        rest_api_name: typing.Optional[builtins.str] = None,
        retain_deployments: typing.Optional[builtins.bool] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param api_definition: (experimental) An OpenAPI definition compatible with API Gateway.
        :param cloud_watch_role: (experimental) Automatically configure an AWS CloudWatch role for API Gateway. Default: true
        :param deploy: (experimental) Indicates if a Deployment should be automatically created for this API, and recreated when the API model (resources, methods) changes. Since API Gateway deployments are immutable, When this option is enabled (by default), an AWS::ApiGateway::Deployment resource will automatically created with a logical ID that hashes the API model (methods, resources and options). This means that when the model changes, the logical ID of this CloudFormation resource will change, and a new deployment will be created. If this is set, ``latestDeployment`` will refer to the ``Deployment`` object and ``deploymentStage`` will refer to a ``Stage`` that points to this deployment. To customize the stage options, use the ``deployOptions`` property. A CloudFormation Output will also be defined with the root URL endpoint of this REST API. Default: true
        :param deploy_options: (experimental) Options for the API Gateway stage that will always point to the latest deployment when ``deploy`` is enabled. If ``deploy`` is disabled, this value cannot be set. Default: - Based on defaults of ``StageOptions``.
        :param domain_name: (experimental) Configure a custom domain name and map it to this API. Default: - no domain name is defined, use ``addDomainName`` or directly define a ``DomainName``.
        :param endpoint_export_name: (experimental) Export name for the CfnOutput containing the API endpoint. Default: - when no export name is given, output will be created without export
        :param endpoint_types: (experimental) A list of the endpoint types of the API. Use this property when creating an API. Default: EndpointType.EDGE
        :param fail_on_warnings: (experimental) Indicates whether to roll back the resource if a warning occurs while API Gateway is creating the RestApi resource. Default: false
        :param parameters: (experimental) Custom header parameters for the request. Default: - No parameters.
        :param policy: (experimental) A policy document that contains the permissions for this RestApi. Default: - No policy.
        :param rest_api_name: (experimental) A name for the API Gateway RestApi resource. Default: - ID of the RestApi construct.
        :param retain_deployments: (experimental) Retains old deployment resources when the API changes. This allows manually reverting stages to point to old deployments via the AWS Console. Default: false

        :stability: experimental
        """
        props = SpecRestApiProps(
            api_definition=api_definition,
            cloud_watch_role=cloud_watch_role,
            deploy=deploy,
            deploy_options=deploy_options,
            domain_name=domain_name,
            endpoint_export_name=endpoint_export_name,
            endpoint_types=endpoint_types,
            fail_on_warnings=fail_on_warnings,
            parameters=parameters,
            policy=policy,
            rest_api_name=rest_api_name,
            retain_deployments=retain_deployments,
        )

        jsii.create(SpecRestApi, self, [scope, id, props])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="restApiId")
    def rest_api_id(self) -> builtins.str:
        """(experimental) The ID of this API Gateway RestApi.

        :stability: experimental
        """
        return jsii.get(self, "restApiId")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="restApiRootResourceId")
    def rest_api_root_resource_id(self) -> builtins.str:
        """(experimental) The resource ID of the root resource.

        :stability: experimental
        :attribute: true
        """
        return jsii.get(self, "restApiRootResourceId")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="root")
    def root(self) -> IResource:
        """(experimental) Represents the root resource of this API endpoint ('/').

        Resources and Methods are added to this resource.

        :stability: experimental
        """
        return jsii.get(self, "root")


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.SpecRestApiProps",
    jsii_struct_bases=[RestApiBaseProps],
    name_mapping={
        "cloud_watch_role": "cloudWatchRole",
        "deploy": "deploy",
        "deploy_options": "deployOptions",
        "domain_name": "domainName",
        "endpoint_export_name": "endpointExportName",
        "endpoint_types": "endpointTypes",
        "fail_on_warnings": "failOnWarnings",
        "parameters": "parameters",
        "policy": "policy",
        "rest_api_name": "restApiName",
        "retain_deployments": "retainDeployments",
        "api_definition": "apiDefinition",
    },
)
class SpecRestApiProps(RestApiBaseProps):
    def __init__(
        self,
        *,
        cloud_watch_role: typing.Optional[builtins.bool] = None,
        deploy: typing.Optional[builtins.bool] = None,
        deploy_options: typing.Optional["StageOptions"] = None,
        domain_name: typing.Optional[DomainNameOptions] = None,
        endpoint_export_name: typing.Optional[builtins.str] = None,
        endpoint_types: typing.Optional[typing.List[EndpointType]] = None,
        fail_on_warnings: typing.Optional[builtins.bool] = None,
        parameters: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        policy: typing.Optional[_PolicyDocument_b5de5177] = None,
        rest_api_name: typing.Optional[builtins.str] = None,
        retain_deployments: typing.Optional[builtins.bool] = None,
        api_definition: ApiDefinition,
    ) -> None:
        """(experimental) Props to instantiate a new SpecRestApi.

        :param cloud_watch_role: (experimental) Automatically configure an AWS CloudWatch role for API Gateway. Default: true
        :param deploy: (experimental) Indicates if a Deployment should be automatically created for this API, and recreated when the API model (resources, methods) changes. Since API Gateway deployments are immutable, When this option is enabled (by default), an AWS::ApiGateway::Deployment resource will automatically created with a logical ID that hashes the API model (methods, resources and options). This means that when the model changes, the logical ID of this CloudFormation resource will change, and a new deployment will be created. If this is set, ``latestDeployment`` will refer to the ``Deployment`` object and ``deploymentStage`` will refer to a ``Stage`` that points to this deployment. To customize the stage options, use the ``deployOptions`` property. A CloudFormation Output will also be defined with the root URL endpoint of this REST API. Default: true
        :param deploy_options: (experimental) Options for the API Gateway stage that will always point to the latest deployment when ``deploy`` is enabled. If ``deploy`` is disabled, this value cannot be set. Default: - Based on defaults of ``StageOptions``.
        :param domain_name: (experimental) Configure a custom domain name and map it to this API. Default: - no domain name is defined, use ``addDomainName`` or directly define a ``DomainName``.
        :param endpoint_export_name: (experimental) Export name for the CfnOutput containing the API endpoint. Default: - when no export name is given, output will be created without export
        :param endpoint_types: (experimental) A list of the endpoint types of the API. Use this property when creating an API. Default: EndpointType.EDGE
        :param fail_on_warnings: (experimental) Indicates whether to roll back the resource if a warning occurs while API Gateway is creating the RestApi resource. Default: false
        :param parameters: (experimental) Custom header parameters for the request. Default: - No parameters.
        :param policy: (experimental) A policy document that contains the permissions for this RestApi. Default: - No policy.
        :param rest_api_name: (experimental) A name for the API Gateway RestApi resource. Default: - ID of the RestApi construct.
        :param retain_deployments: (experimental) Retains old deployment resources when the API changes. This allows manually reverting stages to point to old deployments via the AWS Console. Default: false
        :param api_definition: (experimental) An OpenAPI definition compatible with API Gateway.

        :stability: experimental
        """
        if isinstance(deploy_options, dict):
            deploy_options = StageOptions(**deploy_options)
        if isinstance(domain_name, dict):
            domain_name = DomainNameOptions(**domain_name)
        self._values: typing.Dict[str, typing.Any] = {
            "api_definition": api_definition,
        }
        if cloud_watch_role is not None:
            self._values["cloud_watch_role"] = cloud_watch_role
        if deploy is not None:
            self._values["deploy"] = deploy
        if deploy_options is not None:
            self._values["deploy_options"] = deploy_options
        if domain_name is not None:
            self._values["domain_name"] = domain_name
        if endpoint_export_name is not None:
            self._values["endpoint_export_name"] = endpoint_export_name
        if endpoint_types is not None:
            self._values["endpoint_types"] = endpoint_types
        if fail_on_warnings is not None:
            self._values["fail_on_warnings"] = fail_on_warnings
        if parameters is not None:
            self._values["parameters"] = parameters
        if policy is not None:
            self._values["policy"] = policy
        if rest_api_name is not None:
            self._values["rest_api_name"] = rest_api_name
        if retain_deployments is not None:
            self._values["retain_deployments"] = retain_deployments

    @builtins.property
    def cloud_watch_role(self) -> typing.Optional[builtins.bool]:
        """(experimental) Automatically configure an AWS CloudWatch role for API Gateway.

        :default: true

        :stability: experimental
        """
        result = self._values.get("cloud_watch_role")
        return result

    @builtins.property
    def deploy(self) -> typing.Optional[builtins.bool]:
        """(experimental) Indicates if a Deployment should be automatically created for this API, and recreated when the API model (resources, methods) changes.

        Since API Gateway deployments are immutable, When this option is enabled
        (by default), an AWS::ApiGateway::Deployment resource will automatically
        created with a logical ID that hashes the API model (methods, resources
        and options). This means that when the model changes, the logical ID of
        this CloudFormation resource will change, and a new deployment will be
        created.

        If this is set, ``latestDeployment`` will refer to the ``Deployment`` object
        and ``deploymentStage`` will refer to a ``Stage`` that points to this
        deployment. To customize the stage options, use the ``deployOptions``
        property.

        A CloudFormation Output will also be defined with the root URL endpoint
        of this REST API.

        :default: true

        :stability: experimental
        """
        result = self._values.get("deploy")
        return result

    @builtins.property
    def deploy_options(self) -> typing.Optional["StageOptions"]:
        """(experimental) Options for the API Gateway stage that will always point to the latest deployment when ``deploy`` is enabled.

        If ``deploy`` is disabled,
        this value cannot be set.

        :default: - Based on defaults of ``StageOptions``.

        :stability: experimental
        """
        result = self._values.get("deploy_options")
        return result

    @builtins.property
    def domain_name(self) -> typing.Optional[DomainNameOptions]:
        """(experimental) Configure a custom domain name and map it to this API.

        :default: - no domain name is defined, use ``addDomainName`` or directly define a ``DomainName``.

        :stability: experimental
        """
        result = self._values.get("domain_name")
        return result

    @builtins.property
    def endpoint_export_name(self) -> typing.Optional[builtins.str]:
        """(experimental) Export name for the CfnOutput containing the API endpoint.

        :default: - when no export name is given, output will be created without export

        :stability: experimental
        """
        result = self._values.get("endpoint_export_name")
        return result

    @builtins.property
    def endpoint_types(self) -> typing.Optional[typing.List[EndpointType]]:
        """(experimental) A list of the endpoint types of the API.

        Use this property when creating
        an API.

        :default: EndpointType.EDGE

        :stability: experimental
        """
        result = self._values.get("endpoint_types")
        return result

    @builtins.property
    def fail_on_warnings(self) -> typing.Optional[builtins.bool]:
        """(experimental) Indicates whether to roll back the resource if a warning occurs while API Gateway is creating the RestApi resource.

        :default: false

        :stability: experimental
        """
        result = self._values.get("fail_on_warnings")
        return result

    @builtins.property
    def parameters(self) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        """(experimental) Custom header parameters for the request.

        :default: - No parameters.

        :see: https://docs.aws.amazon.com/cli/latest/reference/apigateway/import-rest-api.html
        :stability: experimental
        """
        result = self._values.get("parameters")
        return result

    @builtins.property
    def policy(self) -> typing.Optional[_PolicyDocument_b5de5177]:
        """(experimental) A policy document that contains the permissions for this RestApi.

        :default: - No policy.

        :stability: experimental
        """
        result = self._values.get("policy")
        return result

    @builtins.property
    def rest_api_name(self) -> typing.Optional[builtins.str]:
        """(experimental) A name for the API Gateway RestApi resource.

        :default: - ID of the RestApi construct.

        :stability: experimental
        """
        result = self._values.get("rest_api_name")
        return result

    @builtins.property
    def retain_deployments(self) -> typing.Optional[builtins.bool]:
        """(experimental) Retains old deployment resources when the API changes.

        This allows
        manually reverting stages to point to old deployments via the AWS
        Console.

        :default: false

        :stability: experimental
        """
        result = self._values.get("retain_deployments")
        return result

    @builtins.property
    def api_definition(self) -> ApiDefinition:
        """(experimental) An OpenAPI definition compatible with API Gateway.

        :see: https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-import-api.html
        :stability: experimental
        """
        result = self._values.get("api_definition")
        assert result is not None, "Required property 'api_definition' is missing"
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "SpecRestApiProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(IStage)
class Stage(
    _Resource_abff4495,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_apigateway.Stage",
):
    """
    :stability: experimental
    """

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        deployment: Deployment,
        access_log_destination: typing.Optional[IAccessLogDestination] = None,
        access_log_format: typing.Optional[AccessLogFormat] = None,
        cache_cluster_enabled: typing.Optional[builtins.bool] = None,
        cache_cluster_size: typing.Optional[builtins.str] = None,
        client_certificate_id: typing.Optional[builtins.str] = None,
        description: typing.Optional[builtins.str] = None,
        documentation_version: typing.Optional[builtins.str] = None,
        method_options: typing.Optional[typing.Mapping[builtins.str, MethodDeploymentOptions]] = None,
        stage_name: typing.Optional[builtins.str] = None,
        tracing_enabled: typing.Optional[builtins.bool] = None,
        variables: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        cache_data_encrypted: typing.Optional[builtins.bool] = None,
        cache_ttl: typing.Optional[_Duration_070aa057] = None,
        caching_enabled: typing.Optional[builtins.bool] = None,
        data_trace_enabled: typing.Optional[builtins.bool] = None,
        logging_level: typing.Optional[MethodLoggingLevel] = None,
        metrics_enabled: typing.Optional[builtins.bool] = None,
        throttling_burst_limit: typing.Optional[jsii.Number] = None,
        throttling_rate_limit: typing.Optional[jsii.Number] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param deployment: (experimental) The deployment that this stage points to [disable-awslint:ref-via-interface].
        :param access_log_destination: (experimental) The CloudWatch Logs log group. Default: - No destination
        :param access_log_format: (experimental) A single line format of access logs of data, as specified by selected $content variables. The format must include at least ``AccessLogFormat.contextRequestId()``. Default: - Common Log Format
        :param cache_cluster_enabled: (experimental) Indicates whether cache clustering is enabled for the stage. Default: - Disabled for the stage.
        :param cache_cluster_size: (experimental) The stage's cache cluster size. Default: 0.5
        :param client_certificate_id: (experimental) The identifier of the client certificate that API Gateway uses to call your integration endpoints in the stage. Default: - None.
        :param description: (experimental) A description of the purpose of the stage. Default: - No description.
        :param documentation_version: (experimental) The version identifier of the API documentation snapshot. Default: - No documentation version.
        :param method_options: (experimental) Method deployment options for specific resources/methods. These will override common options defined in ``StageOptions#methodOptions``. Default: - Common options will be used.
        :param stage_name: (experimental) The name of the stage, which API Gateway uses as the first path segment in the invoked Uniform Resource Identifier (URI). Default: - "prod"
        :param tracing_enabled: (experimental) Specifies whether Amazon X-Ray tracing is enabled for this method. Default: false
        :param variables: (experimental) A map that defines the stage variables. Variable names must consist of alphanumeric characters, and the values must match the following regular expression: [A-Za-z0-9-._~:/?#&=,]+. Default: - No stage variables.
        :param cache_data_encrypted: (experimental) Indicates whether the cached responses are encrypted. Default: false
        :param cache_ttl: (experimental) Specifies the time to live (TTL), in seconds, for cached responses. The higher the TTL, the longer the response will be cached. Default: Duration.minutes(5)
        :param caching_enabled: (experimental) Specifies whether responses should be cached and returned for requests. A cache cluster must be enabled on the stage for responses to be cached. Default: - Caching is Disabled.
        :param data_trace_enabled: (experimental) Specifies whether data trace logging is enabled for this method, which effects the log entries pushed to Amazon CloudWatch Logs. Default: false
        :param logging_level: (experimental) Specifies the logging level for this method, which effects the log entries pushed to Amazon CloudWatch Logs. Default: - Off
        :param metrics_enabled: (experimental) Specifies whether Amazon CloudWatch metrics are enabled for this method. Default: false
        :param throttling_burst_limit: (experimental) Specifies the throttling burst limit. The total rate of all requests in your AWS account is limited to 5,000 requests. Default: - No additional restriction.
        :param throttling_rate_limit: (experimental) Specifies the throttling rate limit. The total rate of all requests in your AWS account is limited to 10,000 requests per second (rps). Default: - No additional restriction.

        :stability: experimental
        """
        props = StageProps(
            deployment=deployment,
            access_log_destination=access_log_destination,
            access_log_format=access_log_format,
            cache_cluster_enabled=cache_cluster_enabled,
            cache_cluster_size=cache_cluster_size,
            client_certificate_id=client_certificate_id,
            description=description,
            documentation_version=documentation_version,
            method_options=method_options,
            stage_name=stage_name,
            tracing_enabled=tracing_enabled,
            variables=variables,
            cache_data_encrypted=cache_data_encrypted,
            cache_ttl=cache_ttl,
            caching_enabled=caching_enabled,
            data_trace_enabled=data_trace_enabled,
            logging_level=logging_level,
            metrics_enabled=metrics_enabled,
            throttling_burst_limit=throttling_burst_limit,
            throttling_rate_limit=throttling_rate_limit,
        )

        jsii.create(Stage, self, [scope, id, props])

    @jsii.member(jsii_name="urlForPath")
    def url_for_path(self, path: typing.Optional[builtins.str] = None) -> builtins.str:
        """(experimental) Returns the invoke URL for a certain path.

        :param path: The resource path.

        :stability: experimental
        """
        return jsii.invoke(self, "urlForPath", [path])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="restApi")
    def rest_api(self) -> IRestApi:
        """(experimental) RestApi to which this stage is associated.

        :stability: experimental
        """
        return jsii.get(self, "restApi")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="stageName")
    def stage_name(self) -> builtins.str:
        """(experimental) Name of this stage.

        :stability: experimental
        """
        return jsii.get(self, "stageName")


@jsii.data_type(
    jsii_type="monocdk.aws_apigateway.StageOptions",
    jsii_struct_bases=[MethodDeploymentOptions],
    name_mapping={
        "cache_data_encrypted": "cacheDataEncrypted",
        "cache_ttl": "cacheTtl",
        "caching_enabled": "cachingEnabled",
        "data_trace_enabled": "dataTraceEnabled",
        "logging_level": "loggingLevel",
        "metrics_enabled": "metricsEnabled",
        "throttling_burst_limit": "throttlingBurstLimit",
        "throttling_rate_limit": "throttlingRateLimit",
        "access_log_destination": "accessLogDestination",
        "access_log_format": "accessLogFormat",
        "cache_cluster_enabled": "cacheClusterEnabled",
        "cache_cluster_size": "cacheClusterSize",
        "client_certificate_id": "clientCertificateId",
        "description": "description",
        "documentation_version": "documentationVersion",
        "method_options": "methodOptions",
        "stage_name": "stageName",
        "tracing_enabled": "tracingEnabled",
        "variables": "variables",
    },
)
class StageOptions(MethodDeploymentOptions):
    def __init__(
        self,
        *,
        cache_data_encrypted: typing.Optional[builtins.bool] = None,
        cache_ttl: typing.Optional[_Duration_070aa057] = None,
        caching_enabled: typing.Optional[builtins.bool] = None,
        data_trace_enabled: typing.Optional[builtins.bool] = None,
        logging_level: typing.Optional[MethodLoggingLevel] = None,
        metrics_enabled: typing.Optional[builtins.bool] = None,
        throttling_burst_limit: typing.Optional[jsii.Number] = None,
        throttling_rate_limit: typing.Optional[jsii.Number] = None,
        access_log_destination: typing.Optional[IAccessLogDestination] = None,
        access_log_format: typing.Optional[AccessLogFormat] = None,
        cache_cluster_enabled: typing.Optional[builtins.bool] = None,
        cache_cluster_size: typing.Optional[builtins.str] = None,
        client_certificate_id: typing.Optional[builtins.str] = None,
        description: typing.Optional[builtins.str] = None,
        documentation_version: typing.Optional[builtins.str] = None,
        method_options: typing.Optional[typing.Mapping[builtins.str, MethodDeploymentOptions]] = None,
        stage_name: typing.Optional[builtins.str] = None,
        tracing_enabled: typing.Optional[builtins.bool] = None,
        variables: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
    ) -> None:
        """
        :param cache_data_encrypted: (experimental) Indicates whether the cached responses are encrypted. Default: false
        :param cache_ttl: (experimental) Specifies the time to live (TTL), in seconds, for cached responses. The higher the TTL, the longer the response will be cached. Default: Duration.minutes(5)
        :param caching_enabled: (experimental) Specifies whether responses should be cached and returned for requests. A cache cluster must be enabled on the stage for responses to be cached. Default: - Caching is Disabled.
        :param data_trace_enabled: (experimental) Specifies whether data trace logging is enabled for this method, which effects the log entries pushed to Amazon CloudWatch Logs. Default: false
        :param logging_level: (experimental) Specifies the logging level for this method, which effects the log entries pushed to Amazon CloudWatch Logs. Default: - Off
        :param metrics_enabled: (experimental) Specifies whether Amazon CloudWatch metrics are enabled for this method. Default: false
        :param throttling_burst_limit: (experimental) Specifies the throttling burst limit. The total rate of all requests in your AWS account is limited to 5,000 requests. Default: - No additional restriction.
        :param throttling_rate_limit: (experimental) Specifies the throttling rate limit. The total rate of all requests in your AWS account is limited to 10,000 requests per second (rps). Default: - No additional restriction.
        :param access_log_destination: (experimental) The CloudWatch Logs log group. Default: - No destination
        :param access_log_format: (experimental) A single line format of access logs of data, as specified by selected $content variables. The format must include at least ``AccessLogFormat.contextRequestId()``. Default: - Common Log Format
        :param cache_cluster_enabled: (experimental) Indicates whether cache clustering is enabled for the stage. Default: - Disabled for the stage.
        :param cache_cluster_size: (experimental) The stage's cache cluster size. Default: 0.5
        :param client_certificate_id: (experimental) The identifier of the client certificate that API Gateway uses to call your integration endpoints in the stage. Default: - None.
        :param description: (experimental) A description of the purpose of the stage. Default: - No description.
        :param documentation_version: (experimental) The version identifier of the API documentation snapshot. Default: - No documentation version.
        :param method_options: (experimental) Method deployment options for specific resources/methods. These will override common options defined in ``StageOptions#methodOptions``. Default: - Common options will be used.
        :param stage_name: (experimental) The name of the stage, which API Gateway uses as the first path segment in the invoked Uniform Resource Identifier (URI). Default: - "prod"
        :param tracing_enabled: (experimental) Specifies whether Amazon X-Ray tracing is enabled for this method. Default: false
        :param variables: (experimental) A map that defines the stage variables. Variable names must consist of alphanumeric characters, and the values must match the following regular expression: [A-Za-z0-9-._~:/?#&=,]+. Default: - No stage variables.

        :stability: experimental
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if cache_data_encrypted is not None:
            self._values["cache_data_encrypted"] = cache_data_encrypted
        if cache_ttl is not None:
            self._values["cache_ttl"] = cache_ttl
        if caching_enabled is not None:
            self._values["caching_enabled"] = caching_enabled
        if data_trace_enabled is not None:
            self._values["data_trace_enabled"] = data_trace_enabled
        if logging_level is not None:
            self._values["logging_level"] = logging_level
        if metrics_enabled is not None:
            self._values["metrics_enabled"] = metrics_enabled
        if throttling_burst_limit is not None:
            self._values["throttling_burst_limit"] = throttling_burst_limit
        if throttling_rate_limit is not None:
            self._values["throttling_rate_limit"] = throttling_rate_limit
        if access_log_destination is not None:
            self._values["access_log_destination"] = access_log_destination
        if access_log_format is not None:
            self._values["access_log_format"] = access_log_format
        if cache_cluster_enabled is not None:
            self._values["cache_cluster_enabled"] = cache_cluster_enabled
        if cache_cluster_size is not None:
            self._values["cache_cluster_size"] = cache_cluster_size
        if client_certificate_id is not None:
            self._values["client_certificate_id"] = client_certificate_id
        if description is not None:
            self._values["description"] = description
        if documentation_version is not None:
            self._values["documentation_version"] = documentation_version
        if method_options is not None:
            self._values["method_options"] = method_options
        if stage_name is not None:
            self._values["stage_name"] = stage_name
        if tracing_enabled is not None:
            self._values["tracing_enabled"] = tracing_enabled
        if variables is not None:
            self._values["variables"] = variables

    @builtins.property
    def cache_data_encrypted(self) -> typing.Optional[builtins.bool]:
        """(experimental) Indicates whether the cached responses are encrypted.

        :default: false

        :stability: experimental
        """
        result = self._values.get("cache_data_encrypted")
        return result

    @builtins.property
    def cache_ttl(self) -> typing.Optional[_Duration_070aa057]:
        """(experimental) Specifies the time to live (TTL), in seconds, for cached responses.

        The
        higher the TTL, the longer the response will be cached.

        :default: Duration.minutes(5)

        :see: https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-caching.html
        :stability: experimental
        """
        result = self._values.get("cache_ttl")
        return result

    @builtins.property
    def caching_enabled(self) -> typing.Optional[builtins.bool]:
        """(experimental) Specifies whether responses should be cached and returned for requests.

        A
        cache cluster must be enabled on the stage for responses to be cached.

        :default: - Caching is Disabled.

        :stability: experimental
        """
        result = self._values.get("caching_enabled")
        return result

    @builtins.property
    def data_trace_enabled(self) -> typing.Optional[builtins.bool]:
        """(experimental) Specifies whether data trace logging is enabled for this method, which effects the log entries pushed to Amazon CloudWatch Logs.

        :default: false

        :stability: experimental
        """
        result = self._values.get("data_trace_enabled")
        return result

    @builtins.property
    def logging_level(self) -> typing.Optional[MethodLoggingLevel]:
        """(experimental) Specifies the logging level for this method, which effects the log entries pushed to Amazon CloudWatch Logs.

        :default: - Off

        :stability: experimental
        """
        result = self._values.get("logging_level")
        return result

    @builtins.property
    def metrics_enabled(self) -> typing.Optional[builtins.bool]:
        """(experimental) Specifies whether Amazon CloudWatch metrics are enabled for this method.

        :default: false

        :stability: experimental
        """
        result = self._values.get("metrics_enabled")
        return result

    @builtins.property
    def throttling_burst_limit(self) -> typing.Optional[jsii.Number]:
        """(experimental) Specifies the throttling burst limit.

        The total rate of all requests in your AWS account is limited to 5,000 requests.

        :default: - No additional restriction.

        :see: https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-request-throttling.html
        :stability: experimental
        """
        result = self._values.get("throttling_burst_limit")
        return result

    @builtins.property
    def throttling_rate_limit(self) -> typing.Optional[jsii.Number]:
        """(experimental) Specifies the throttling rate limit.

        The total rate of all requests in your AWS account is limited to 10,000 requests per second (rps).

        :default: - No additional restriction.

        :see: https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-request-throttling.html
        :stability: experimental
        """
        result = self._values.get("throttling_rate_limit")
        return result

    @builtins.property
    def access_log_destination(self) -> typing.Optional[IAccessLogDestination]:
        """(experimental) The CloudWatch Logs log group.

        :default: -