# coding: utf-8

"""
    Robot API

    Robot REST API  # noqa: E501

    OpenAPI spec version: 2.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from pdhttp.api_client import ApiClient


class SignalsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def bind_stop_port_high(self, port, **kwargs):  # noqa: E501
        """Bind stop command to high input signal on a specific port  # noqa: E501

        The function binds stop command execution to \"high\" input signal on a specific port.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.bind_stop_port_high(port, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int port: The parameter indicates the number of a digital input is a physical port on the back panel of the control box. Since the control box has four digital inputs (DI), the parameter can have any integral value between 1 (corresponds to DI1) and 4 (corresponds to DI4). (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.bind_stop_port_high_with_http_info(port, **kwargs)  # noqa: E501
        else:
            (data) = self.bind_stop_port_high_with_http_info(port, **kwargs)  # noqa: E501
            return data

    def bind_stop_port_high_with_http_info(self, port, **kwargs):  # noqa: E501
        """Bind stop command to high input signal on a specific port  # noqa: E501

        The function binds stop command execution to \"high\" input signal on a specific port.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.bind_stop_port_high_with_http_info(port, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int port: The parameter indicates the number of a digital input is a physical port on the back panel of the control box. Since the control box has four digital inputs (DI), the parameter can have any integral value between 1 (corresponds to DI1) and 4 (corresponds to DI4). (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['port']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method bind_stop_port_high" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'port' is set
        if ('port' not in params or
                params['port'] is None):
            raise ValueError("Missing the required parameter `port` when calling `bind_stop_port_high`")  # noqa: E501

        if 'port' in params and params['port'] > 4:  # noqa: E501
            raise ValueError("Invalid value for parameter `port` when calling `bind_stop_port_high`, must be a value less than or equal to `4`")  # noqa: E501
        if 'port' in params and params['port'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `port` when calling `bind_stop_port_high`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'port' in params:
            path_params['port'] = params['port']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/stop/bind/{port}/high', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def bind_stop_port_low(self, port, **kwargs):  # noqa: E501
        """Bind stop command to low input signal on a specific port  # noqa: E501

        The function binds stop command execution to \"low\" input signal on a specific port.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.bind_stop_port_low(port, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int port: The parameter indicates the number of a digital input is a physical port on the back panel of the control box. Since the control box has four digital inputs (DI), the parameter can have any integral value between 1 (corresponds to DI1) and 4 (corresponds to DI4). (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.bind_stop_port_low_with_http_info(port, **kwargs)  # noqa: E501
        else:
            (data) = self.bind_stop_port_low_with_http_info(port, **kwargs)  # noqa: E501
            return data

    def bind_stop_port_low_with_http_info(self, port, **kwargs):  # noqa: E501
        """Bind stop command to low input signal on a specific port  # noqa: E501

        The function binds stop command execution to \"low\" input signal on a specific port.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.bind_stop_port_low_with_http_info(port, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int port: The parameter indicates the number of a digital input is a physical port on the back panel of the control box. Since the control box has four digital inputs (DI), the parameter can have any integral value between 1 (corresponds to DI1) and 4 (corresponds to DI4). (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['port']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method bind_stop_port_low" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'port' is set
        if ('port' not in params or
                params['port'] is None):
            raise ValueError("Missing the required parameter `port` when calling `bind_stop_port_low`")  # noqa: E501

        if 'port' in params and params['port'] > 4:  # noqa: E501
            raise ValueError("Invalid value for parameter `port` when calling `bind_stop_port_low`, must be a value less than or equal to `4`")  # noqa: E501
        if 'port' in params and params['port'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `port` when calling `bind_stop_port_low`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'port' in params:
            path_params['port'] = params['port']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/stop/bind/{port}/low', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_digital_input(self, port, **kwargs):  # noqa: E501
        """Get level of digital input signal  # noqa: E501

        The function returns the actual signal level on the digital input specified in the {port} parameter of the request path.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_digital_input(port, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int port: The parameter indicates the number of a digital input is a physical port on the back panel of the control box. Since the control box has four digital inputs (DI), the parameter can have any integral value between 1 (corresponds to DI1) and 4 (corresponds to DI4). (required)
        :return: Signal
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_digital_input_with_http_info(port, **kwargs)  # noqa: E501
        else:
            (data) = self.get_digital_input_with_http_info(port, **kwargs)  # noqa: E501
            return data

    def get_digital_input_with_http_info(self, port, **kwargs):  # noqa: E501
        """Get level of digital input signal  # noqa: E501

        The function returns the actual signal level on the digital input specified in the {port} parameter of the request path.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_digital_input_with_http_info(port, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int port: The parameter indicates the number of a digital input is a physical port on the back panel of the control box. Since the control box has four digital inputs (DI), the parameter can have any integral value between 1 (corresponds to DI1) and 4 (corresponds to DI4). (required)
        :return: Signal
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['port']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_digital_input" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'port' is set
        if ('port' not in params or
                params['port'] is None):
            raise ValueError("Missing the required parameter `port` when calling `get_digital_input`")  # noqa: E501

        if 'port' in params and params['port'] > 4:  # noqa: E501
            raise ValueError("Invalid value for parameter `port` when calling `get_digital_input`, must be a value less than or equal to `4`")  # noqa: E501
        if 'port' in params and params['port'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `port` when calling `get_digital_input`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'port' in params:
            path_params['port'] = params['port']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/signal/input/{port}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Signal',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_digital_output(self, port, **kwargs):  # noqa: E501
        """Get level of digital output signal  # noqa: E501

        The function returns the actual signal level on the digital output specified in the {port} parameter of the request path.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_digital_output(port, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int port: The parameter indicates the number of a digital output is a physical port on the back panel of the control box. Since the control box has two digital outputs, the parameter value can be either 1 (corresponds to Relay output 1) or 2 (corresponds to Relay output 2). (required)
        :return: Signal
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_digital_output_with_http_info(port, **kwargs)  # noqa: E501
        else:
            (data) = self.get_digital_output_with_http_info(port, **kwargs)  # noqa: E501
            return data

    def get_digital_output_with_http_info(self, port, **kwargs):  # noqa: E501
        """Get level of digital output signal  # noqa: E501

        The function returns the actual signal level on the digital output specified in the {port} parameter of the request path.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_digital_output_with_http_info(port, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int port: The parameter indicates the number of a digital output is a physical port on the back panel of the control box. Since the control box has two digital outputs, the parameter value can be either 1 (corresponds to Relay output 1) or 2 (corresponds to Relay output 2). (required)
        :return: Signal
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['port']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_digital_output" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'port' is set
        if ('port' not in params or
                params['port'] is None):
            raise ValueError("Missing the required parameter `port` when calling `get_digital_output`")  # noqa: E501

        if 'port' in params and params['port'] > 2:  # noqa: E501
            raise ValueError("Invalid value for parameter `port` when calling `get_digital_output`, must be a value less than or equal to `2`")  # noqa: E501
        if 'port' in params and params['port'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `port` when calling `get_digital_output`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'port' in params:
            path_params['port'] = params['port']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/signal/output/{port}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Signal',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_digital_output_high(self, port, **kwargs):  # noqa: E501
        """Set high level of digital output signal  # noqa: E501

        The function sets the digital output specified in the {port} parameter of the request path to the HIGH signal level.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_digital_output_high(port, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int port: The parameter indicates the number of the digital output on the back of the control box that you want to set to the LOW signal level. Since the control box has two digital outputs, the parameter value can be either 1 (corresponds to Relay output 1 on the control box) or 2 (corresponds to Relay output 2 on the control box). (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.set_digital_output_high_with_http_info(port, **kwargs)  # noqa: E501
        else:
            (data) = self.set_digital_output_high_with_http_info(port, **kwargs)  # noqa: E501
            return data

    def set_digital_output_high_with_http_info(self, port, **kwargs):  # noqa: E501
        """Set high level of digital output signal  # noqa: E501

        The function sets the digital output specified in the {port} parameter of the request path to the HIGH signal level.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_digital_output_high_with_http_info(port, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int port: The parameter indicates the number of the digital output on the back of the control box that you want to set to the LOW signal level. Since the control box has two digital outputs, the parameter value can be either 1 (corresponds to Relay output 1 on the control box) or 2 (corresponds to Relay output 2 on the control box). (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['port']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_digital_output_high" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'port' is set
        if ('port' not in params or
                params['port'] is None):
            raise ValueError("Missing the required parameter `port` when calling `set_digital_output_high`")  # noqa: E501

        if 'port' in params and params['port'] > 2:  # noqa: E501
            raise ValueError("Invalid value for parameter `port` when calling `set_digital_output_high`, must be a value less than or equal to `2`")  # noqa: E501
        if 'port' in params and params['port'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `port` when calling `set_digital_output_high`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'port' in params:
            path_params['port'] = params['port']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/signal/output/{port}/high', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_digital_output_low(self, port, **kwargs):  # noqa: E501
        """Set low level of digital output signal  # noqa: E501

        The function sets the digital output specified in the Port parameter to the LOW signal level. A digital output is a physical port on the back panel of the control box that controls the robotic arm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_digital_output_low(port, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int port: The parameter indicates the number of the digital output on the back of the control box that you want to set to the LOW signal level. Since the control box has two digital outputs, the parameter value can be either 1 (corresponds to Relay output 1 on the control box) or 2 (corresponds to Relay output 2 on the control box). (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.set_digital_output_low_with_http_info(port, **kwargs)  # noqa: E501
        else:
            (data) = self.set_digital_output_low_with_http_info(port, **kwargs)  # noqa: E501
            return data

    def set_digital_output_low_with_http_info(self, port, **kwargs):  # noqa: E501
        """Set low level of digital output signal  # noqa: E501

        The function sets the digital output specified in the Port parameter to the LOW signal level. A digital output is a physical port on the back panel of the control box that controls the robotic arm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_digital_output_low_with_http_info(port, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int port: The parameter indicates the number of the digital output on the back of the control box that you want to set to the LOW signal level. Since the control box has two digital outputs, the parameter value can be either 1 (corresponds to Relay output 1 on the control box) or 2 (corresponds to Relay output 2 on the control box). (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['port']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_digital_output_low" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'port' is set
        if ('port' not in params or
                params['port'] is None):
            raise ValueError("Missing the required parameter `port` when calling `set_digital_output_low`")  # noqa: E501

        if 'port' in params and params['port'] > 2:  # noqa: E501
            raise ValueError("Invalid value for parameter `port` when calling `set_digital_output_low`, must be a value less than or equal to `2`")  # noqa: E501
        if 'port' in params and params['port'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `port` when calling `set_digital_output_low`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'port' in params:
            path_params['port'] = params['port']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/signal/output/{port}/low', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
