# coding: utf-8

"""
    Robot API

    Robot REST API  # noqa: E501

    OpenAPI spec version: 2.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from pdhttp.api_client import ApiClient


class PoseApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_pose(self, **kwargs):  # noqa: E501
        """Getting the actual arm pose  # noqa: E501

        The function returns the actual pose of the robotic arm and the timestamp. The pose is described as a set of output flange angles (in degrees) of all the six servos in the arm joints.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_pose(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: PoseTimestamp
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_pose_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_pose_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_pose_with_http_info(self, **kwargs):  # noqa: E501
        """Getting the actual arm pose  # noqa: E501

        The function returns the actual pose of the robotic arm and the timestamp. The pose is described as a set of output flange angles (in degrees) of all the six servos in the arm joints.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_pose_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: PoseTimestamp
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_pose" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/pose', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PoseTimestamp',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def run_poses(self, body, **kwargs):  # noqa: E501
        """Asking the arm to move to a pose  # noqa: E501

        The function allows for setting a trajectory of one or more waypoints to move the robotic arm smoothly from one pose to another. In the trajectory, each waypoint is a set of output flange angles (in degrees) of the six servos in the arm joints.  Two motion types supported: linear and joint. Default: joint  ### Note:  Similarly, you can move the arm from one pose to another through one or more waypoints using the PUT/pose function. When the arm is executing a trajectory of PUT/pose waypoints, it stops for a short moment at each preset waypoint. With the PUT/poses/run function, however, the arm moves smoothly though all waypoints without stopping, which reduces the overall time of going from one pose to another.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.run_poses(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[Pose] body: Request Body (required)
        :param int speed: Speed of Robot. Controls acceleration and velocity at the same time.
        :param int velocity: Velocity of Robot. MUST be used together with acceleration.
        :param int acceleration: Acceleration of Robot. MUST be used together with velocity. **Note:** Use values greater than 100 with caution: the robotic arm could reject or fail operation execution. Values greater than 100 are acceptable when the robotic arm moves with a relatively light load or without one.
        :param str motion_type: Motion type of robot. MUST be either JOINT (default) or LINEAR
        :param float tcp_max_velocity: The parameter defines the limit velocity in meters per second that an end effector can reach at its TCP while moving. It is not mandatory. When the user specifies no value for it, it is set to default. The default setting is 2 m/s.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.run_poses_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.run_poses_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def run_poses_with_http_info(self, body, **kwargs):  # noqa: E501
        """Asking the arm to move to a pose  # noqa: E501

        The function allows for setting a trajectory of one or more waypoints to move the robotic arm smoothly from one pose to another. In the trajectory, each waypoint is a set of output flange angles (in degrees) of the six servos in the arm joints.  Two motion types supported: linear and joint. Default: joint  ### Note:  Similarly, you can move the arm from one pose to another through one or more waypoints using the PUT/pose function. When the arm is executing a trajectory of PUT/pose waypoints, it stops for a short moment at each preset waypoint. With the PUT/poses/run function, however, the arm moves smoothly though all waypoints without stopping, which reduces the overall time of going from one pose to another.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.run_poses_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[Pose] body: Request Body (required)
        :param int speed: Speed of Robot. Controls acceleration and velocity at the same time.
        :param int velocity: Velocity of Robot. MUST be used together with acceleration.
        :param int acceleration: Acceleration of Robot. MUST be used together with velocity. **Note:** Use values greater than 100 with caution: the robotic arm could reject or fail operation execution. Values greater than 100 are acceptable when the robotic arm moves with a relatively light load or without one.
        :param str motion_type: Motion type of robot. MUST be either JOINT (default) or LINEAR
        :param float tcp_max_velocity: The parameter defines the limit velocity in meters per second that an end effector can reach at its TCP while moving. It is not mandatory. When the user specifies no value for it, it is set to default. The default setting is 2 m/s.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'speed', 'velocity', 'acceleration', 'motion_type', 'tcp_max_velocity']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method run_poses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `run_poses`")  # noqa: E501

        if 'speed' in params and params['speed'] > 100:  # noqa: E501
            raise ValueError("Invalid value for parameter `speed` when calling `run_poses`, must be a value less than or equal to `100`")  # noqa: E501
        if 'speed' in params and params['speed'] <= 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `speed` when calling `run_poses`, must be a value greater than `0`")  # noqa: E501
        if 'velocity' in params and params['velocity'] > 100:  # noqa: E501
            raise ValueError("Invalid value for parameter `velocity` when calling `run_poses`, must be a value less than or equal to `100`")  # noqa: E501
        if 'velocity' in params and params['velocity'] <= 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `velocity` when calling `run_poses`, must be a value greater than `0`")  # noqa: E501
        if 'acceleration' in params and params['acceleration'] > 200:  # noqa: E501
            raise ValueError("Invalid value for parameter `acceleration` when calling `run_poses`, must be a value less than or equal to `200`")  # noqa: E501
        if 'acceleration' in params and params['acceleration'] <= 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `acceleration` when calling `run_poses`, must be a value greater than `0`")  # noqa: E501
        if 'tcp_max_velocity' in params and params['tcp_max_velocity'] > 2:  # noqa: E501
            raise ValueError("Invalid value for parameter `tcp_max_velocity` when calling `run_poses`, must be a value less than or equal to `2`")  # noqa: E501
        if 'tcp_max_velocity' in params and params['tcp_max_velocity'] <= 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `tcp_max_velocity` when calling `run_poses`, must be a value greater than `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'speed' in params:
            query_params.append(('speed', params['speed']))  # noqa: E501
        if 'velocity' in params:
            query_params.append(('velocity', params['velocity']))  # noqa: E501
        if 'acceleration' in params:
            query_params.append(('acceleration', params['acceleration']))  # noqa: E501
        if 'motion_type' in params:
            query_params.append(('motionType', params['motion_type']))  # noqa: E501
        if 'tcp_max_velocity' in params:
            query_params.append(('tcp_max_velocity', params['tcp_max_velocity']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/poses/run', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_pose(self, body, **kwargs):  # noqa: E501
        """Setting a new arm pose  # noqa: E501

        The function commands the arm to move to a new pose. A pose is described as a set of output flange angles (in degrees) of the six servos integrated into the robot joints.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_pose(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Pose body: Request Body (required)
        :param int speed: Speed of Robot. Controls acceleration and velocity at the same time.
        :param int velocity: Velocity of Robot. MUST be used together with acceleration.
        :param int acceleration: Acceleration of Robot. MUST be used together with velocity. **Note:** Use values greater than 100 with caution: the robotic arm could reject or fail operation execution. Values greater than 100 are acceptable when the robotic arm moves with a relatively light load or without one.
        :param str motion_type: Motion type of robot. MUST be either JOINT (default) or LINEAR
        :param float tcp_max_velocity: The parameter defines the limit velocity in meters per second that an end effector can reach at its TCP while moving. It is not mandatory. When the user specifies no value for it, it is set to default. The default setting is 2 m/s.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.set_pose_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.set_pose_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def set_pose_with_http_info(self, body, **kwargs):  # noqa: E501
        """Setting a new arm pose  # noqa: E501

        The function commands the arm to move to a new pose. A pose is described as a set of output flange angles (in degrees) of the six servos integrated into the robot joints.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_pose_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Pose body: Request Body (required)
        :param int speed: Speed of Robot. Controls acceleration and velocity at the same time.
        :param int velocity: Velocity of Robot. MUST be used together with acceleration.
        :param int acceleration: Acceleration of Robot. MUST be used together with velocity. **Note:** Use values greater than 100 with caution: the robotic arm could reject or fail operation execution. Values greater than 100 are acceptable when the robotic arm moves with a relatively light load or without one.
        :param str motion_type: Motion type of robot. MUST be either JOINT (default) or LINEAR
        :param float tcp_max_velocity: The parameter defines the limit velocity in meters per second that an end effector can reach at its TCP while moving. It is not mandatory. When the user specifies no value for it, it is set to default. The default setting is 2 m/s.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'speed', 'velocity', 'acceleration', 'motion_type', 'tcp_max_velocity']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_pose" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `set_pose`")  # noqa: E501

        if 'speed' in params and params['speed'] > 100:  # noqa: E501
            raise ValueError("Invalid value for parameter `speed` when calling `set_pose`, must be a value less than or equal to `100`")  # noqa: E501
        if 'speed' in params and params['speed'] <= 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `speed` when calling `set_pose`, must be a value greater than `0`")  # noqa: E501
        if 'velocity' in params and params['velocity'] > 100:  # noqa: E501
            raise ValueError("Invalid value for parameter `velocity` when calling `set_pose`, must be a value less than or equal to `100`")  # noqa: E501
        if 'velocity' in params and params['velocity'] <= 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `velocity` when calling `set_pose`, must be a value greater than `0`")  # noqa: E501
        if 'acceleration' in params and params['acceleration'] > 200:  # noqa: E501
            raise ValueError("Invalid value for parameter `acceleration` when calling `set_pose`, must be a value less than or equal to `200`")  # noqa: E501
        if 'acceleration' in params and params['acceleration'] <= 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `acceleration` when calling `set_pose`, must be a value greater than `0`")  # noqa: E501
        if 'tcp_max_velocity' in params and params['tcp_max_velocity'] > 2:  # noqa: E501
            raise ValueError("Invalid value for parameter `tcp_max_velocity` when calling `set_pose`, must be a value less than or equal to `2`")  # noqa: E501
        if 'tcp_max_velocity' in params and params['tcp_max_velocity'] <= 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `tcp_max_velocity` when calling `set_pose`, must be a value greater than `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'speed' in params:
            query_params.append(('speed', params['speed']))  # noqa: E501
        if 'velocity' in params:
            query_params.append(('velocity', params['velocity']))  # noqa: E501
        if 'acceleration' in params:
            query_params.append(('acceleration', params['acceleration']))  # noqa: E501
        if 'motion_type' in params:
            query_params.append(('motionType', params['motion_type']))  # noqa: E501
        if 'tcp_max_velocity' in params:
            query_params.append(('tcp_max_velocity', params['tcp_max_velocity']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/pose', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
