# -*- coding: utf-8 -*-

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

from .geometry import (
    Vertex,
    NormalizedVertex,
    BoundingPoly,
    NormalizedBoundingPoly,
    Position,
)
from .product_search_service import (
    Product,
    ProductSet,
    ReferenceImage,
    CreateProductRequest,
    ListProductsRequest,
    ListProductsResponse,
    GetProductRequest,
    UpdateProductRequest,
    DeleteProductRequest,
    CreateProductSetRequest,
    ListProductSetsRequest,
    ListProductSetsResponse,
    GetProductSetRequest,
    UpdateProductSetRequest,
    DeleteProductSetRequest,
    CreateReferenceImageRequest,
    ListReferenceImagesRequest,
    ListReferenceImagesResponse,
    GetReferenceImageRequest,
    DeleteReferenceImageRequest,
    AddProductToProductSetRequest,
    RemoveProductFromProductSetRequest,
    ListProductsInProductSetRequest,
    ListProductsInProductSetResponse,
    ImportProductSetsGcsSource,
    ImportProductSetsInputConfig,
    ImportProductSetsRequest,
    ImportProductSetsResponse,
    BatchOperationMetadata,
)
from .product_search import (
    ProductSearchParams,
    ProductSearchResults,
    ProductSearchCategory,
    ProductSearchResultsView,
)
from .text_annotation import (
    TextAnnotation,
    Page,
    Block,
    Paragraph,
    Word,
    Symbol,
)
from .web_detection import WebDetection
from .image_annotator import (
    Feature,
    ImageSource,
    Image,
    FaceAnnotation,
    LocationInfo,
    Property,
    EntityAnnotation,
    LocalizedObjectAnnotation,
    SafeSearchAnnotation,
    LatLongRect,
    ColorInfo,
    DominantColorsAnnotation,
    ImageProperties,
    CropHint,
    CropHintsAnnotation,
    CropHintsParams,
    WebDetectionParams,
    TextDetectionParams,
    ImageContext,
    AnnotateImageRequest,
    ImageAnnotationContext,
    AnnotateImageResponse,
    AnnotateFileResponse,
    BatchAnnotateImagesRequest,
    BatchAnnotateImagesResponse,
    AsyncAnnotateFileRequest,
    AsyncAnnotateFileResponse,
    AsyncBatchAnnotateFilesRequest,
    AsyncBatchAnnotateFilesResponse,
    InputConfig,
    OutputConfig,
    GcsSource,
    GcsDestination,
    OperationMetadata,
    Likelihood,
)

__all__ = (
    "Vertex",
    "NormalizedVertex",
    "BoundingPoly",
    "NormalizedBoundingPoly",
    "Position",
    "Product",
    "ProductSet",
    "ReferenceImage",
    "CreateProductRequest",
    "ListProductsRequest",
    "ListProductsResponse",
    "GetProductRequest",
    "UpdateProductRequest",
    "DeleteProductRequest",
    "CreateProductSetRequest",
    "ListProductSetsRequest",
    "ListProductSetsResponse",
    "GetProductSetRequest",
    "UpdateProductSetRequest",
    "DeleteProductSetRequest",
    "CreateReferenceImageRequest",
    "ListReferenceImagesRequest",
    "ListReferenceImagesResponse",
    "GetReferenceImageRequest",
    "DeleteReferenceImageRequest",
    "AddProductToProductSetRequest",
    "RemoveProductFromProductSetRequest",
    "ListProductsInProductSetRequest",
    "ListProductsInProductSetResponse",
    "ImportProductSetsGcsSource",
    "ImportProductSetsInputConfig",
    "ImportProductSetsRequest",
    "ImportProductSetsResponse",
    "BatchOperationMetadata",
    "ProductSearchParams",
    "ProductSearchResults",
    "ProductSearchCategory",
    "ProductSearchResultsView",
    "TextAnnotation",
    "Page",
    "Block",
    "Paragraph",
    "Word",
    "Symbol",
    "WebDetection",
    "Feature",
    "ImageSource",
    "Image",
    "FaceAnnotation",
    "LocationInfo",
    "Property",
    "EntityAnnotation",
    "LocalizedObjectAnnotation",
    "SafeSearchAnnotation",
    "LatLongRect",
    "ColorInfo",
    "DominantColorsAnnotation",
    "ImageProperties",
    "CropHint",
    "CropHintsAnnotation",
    "CropHintsParams",
    "WebDetectionParams",
    "TextDetectionParams",
    "ImageContext",
    "AnnotateImageRequest",
    "ImageAnnotationContext",
    "AnnotateImageResponse",
    "AnnotateFileResponse",
    "BatchAnnotateImagesRequest",
    "BatchAnnotateImagesResponse",
    "AsyncAnnotateFileRequest",
    "AsyncAnnotateFileResponse",
    "AsyncBatchAnnotateFilesRequest",
    "AsyncBatchAnnotateFilesResponse",
    "InputConfig",
    "OutputConfig",
    "GcsSource",
    "GcsDestination",
    "OperationMetadata",
    "Likelihood",
)
