import numpy as np

periods = np.array(
    [[-50285, -47466],
     [-47465, -44646],
     [-44645, -41826],
     [-41825, -39006],
     [-39005, -36186],
     [-36185, -33366],
     [-33365, -30546],
     [-30545, -27726],
     [-27725, -24906],
     [-24905, -22086],
     [-22085, -19266],
     [-19265, -16446],
     [-16445, -13626],
     [-13625, -10806],
     [-10805,  -7986],
     [ -7985,  -5166],
     [ -5165,  -2346],
     [ -2345,    474],
     [   475,   3294],
     [  3295,   6114],
     [  6115,   8934],
     [  8935,  11754],
     [ 11755,  14574],
     [ 14575,  17394],
     [ 17395,  20214],
     [ 20215,  23034],
     [ 23035,  25854],
     [ 25855,  28674],
     [ 28675,  31494],
     [ 31495,  34314],
     [ 34315,  37134],
     [ 37135,  39954],
     [ 39955,  42774],
     [ 42775,  45594],
     [ 45595,  48414],
     [ 48415,  51234]]
    )


# ref: https://calendar.ut.ac.ir/Fa/News/Data/Doc/KabiseShamsi1206-1498-new.pdf
official_leaps = np.array([
    1210,1214,1218,1222,1226,1230,1234,1238,1243,
    1247,1251,1255,1259,1263,1267,1271,1276, #1275
    1280,1284,1288,1292,1296,1300,1304,1309, #1308
    1313,1317,1321,1325,1329,1333,1337,1342, #1341
    1346,1350,1354,1358,1362,1366,1370,1375,
    1379,1383,1387,1391,1395,1399,1403,1408,
    1412,1416,1420,1424,1428,1432,1436,1441,
    1445,1449,1453,1457,1461,1465,1469,1474,
    1478,1482,1486,1490,1494,1498])

# 1th Farvardin of persian year (birashk) to julian date
per_jul = {
    -50000: -16314154.5, -49000: -15948912.5, -48000: -15583670.5,
    -47000: -15218428.5, -46000: -14853185.5, -45000: -14487943.5,
    -44000: -14122701.5, -43000: -13757459.5, -42000: -13392217.5,
    -41000: -13026974.5, -40000: -12661732.5, -39000: -12296490.5,
    -38000: -11931248.5, -37000: -11566006.5, -36000: -11200763.5,
    -35000: -10835521.5, -34000: -10470279.5, -33000: -10105037.5,
    -32000: -9739795.5, -31000: -9374552.5, -30000: -9009310.5,
    -29000: -8644068.5, -28000: -8278826.5, -27000: -7913584.5,
    -26000: -7548341.5, -25000: -7183099.5, -24000: -6817857.5,
    -23000: -6452615.5, -22000: -6087373.5, -21000: -5722130.5,
    -20000: -5356888.5, -19000: -4991646.5, -18000: -4626404.5,
    -17000: -4261162.5, -16000: -3895919.5, -15000: -3530677.5,
    -14000: -3165435.5, -13000: -2800193.5, -12000: -2434951.5,
    -11000: -2069709.5, -10000: -1704466.5, -9000: -1339224.5,
    -8000: -973982.5, -7000: -608740.5, -6000: -243498.5,
    -5000: 121744.5, -4000: 486986.5, -3000: 852228.5,
    -2000: 1217470.5, -1000: 1582712.5, 0: 1947955.5,
    1000: 2313197.5, 2000: 2678439.5, 3000: 3043681.5, 4000: 3408923.5,
    5000: 3774166.5, 6000: 4139408.5, 7000: 4504650.5, 8000: 4869892.5,
    9000: 5235134.5, 10000: 5600377.5, 11000: 5965619.5, 12000: 6330861.5,
    13000: 6696103.5, 14000: 7061345.5, 15000: 7426588.5, 16000: 7791830.5,
    17000: 8157072.5, 18000: 8522314.5, 19000: 8887556.5, 20000: 9252799.5,
    21000: 9618041.5, 22000: 9983283.5, 23000: 10348525.5, 24000: 10713767.5,
    25000: 11079010.5, 26000: 11444252.5, 27000: 11809494.5, 28000: 12174736.5,
    29000: 12539978.5, 30000: 12905221.5, 31000: 13270463.5, 32000: 13635705.5,
    33000: 14000947.5, 34000: 14366189.5, 35000: 14731432.5, 36000: 15096674.5,
    37000: 15461916.5, 38000: 15827158.5, 39000: 16192400.5, 40000: 16557643.5,
    41000: 16922885.5, 42000: 17288127.5, 43000: 17653369.5, 44000: 18018611.5,
    45000: 18383854.5, 46000: 18749096.5, 47000: 19114338.5, 48000: 19479580.5,
    49000: 19844822.5, 50000: 20210065.5
    }

jul_per = {v: k for k, v in per_jul.items()}

# 1th January of gregorian/julian year to julian day
gre_jul = {
    -51000: -16906692.5, -50000: -16541442.5, -49000: -16176192.5,
    -48000: -15810942.5, -47000: -15445692.5, -46000: -15080442.5,
    -45000: -14715192.5, -44000: -14349942.5, -43000: -13984692.5,
    -42000: -13619442.5, -41000: -13254192.5, -40000: -12888942.5,
    -39000: -12523692.5, -38000: -12158442.5, -37000: -11793192.5,
    -36000: -11427942.5, -35000: -11062692.5, -34000: -10697442.5,
    -33000: -10332192.5, -32000: -9966942.5, -31000: -9601692.5,
    -30000: -9236442.5, -29000: -8871192.5, -28000: -8505942.5,
    -27000: -8140692.5, -26000: -7775442.5, -25000: -7410192.5,
    -24000: -7044942.5, -23000: -6679692.5, -22000: -6314442.5,
    -21000: -5949192.5, -20000: -5583942.5, -19000: -5218692.5,
    -18000: -4853442.5, -17000: -4488192.5, -16000: -4122942.5,
    -15000: -3757692.5, -14000: -3392442.5, -13000: -3027192.5,
    -12000: -2661942.5, -11000: -2296692.5, -10000: -1931442.5,
    -9000: -1566192.5, -8000: -1200942.5, -7000: -835692.5,
    -6000: -470442.5, -5000: -105192.5, -4000: 260057.5,
    -3000: 625307.5, -2000: 990557.5, -1000: 1355807.5, 0 : 1721057.5,
    1000 : 2086307.5, 2000 : 2451544.5, 3000 : 2816787.5,
    4000 : 3182029.5, 5000 : 3547272.5, 6000 : 3912514.5,
    7000 : 4277757.5, 8000 : 4642999.5, 9000 : 5008242.5,
    10000: 5373484.5, 11000: 5738727.5, 12000: 6103969.5,
    13000: 6469212.5, 14000: 6834454.5, 15000: 7199697.5,
    16000: 7564939.5, 17000: 7930182.5, 18000: 8295424.5,
    19000: 8660667.5, 20000: 9025909.5, 21000: 9391152.5,
    22000: 9756394.5, 23000: 10121637.5, 24000: 10486879.5,
    25000: 10852122.5, 26000: 11217364.5, 27000: 11582607.5,
    28000: 11947849.5, 29000: 12313092.5, 30000: 12678334.5,
    31000: 13043577.5, 32000: 13408819.5, 33000: 13774062.5,
    34000: 14139304.5, 35000: 14504547.5, 36000: 14869789.5,
    37000: 15235032.5, 38000: 15600274.5, 39000: 15965517.5,
    40000: 16330759.5, 41000: 16696002.5, 42000: 17061244.5,
    43000: 17426487.5, 44000: 17791729.5, 45000: 18156972.5,
    46000: 18522214.5, 47000: 18887457.5, 48000: 19252699.5,
    49000: 19617942.5, 50000: 19983184.5, 51000: 20348427.5
    }

jul_gre = {v: k for k, v in gre_jul.items()}
