# qovery
- Qovery is the fastest way to deploy your full-stack apps on any Cloud provider.
- ℹ️ The API is stable and still in development.


This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.3
- Package version: 1.0.3
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://www.qovery.com](https://www.qovery.com)

## Requirements.

Python >=3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/qovery/qovery-client-python.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/qovery/qovery-client-python.git`)

Then import the package:
```python
import qovery
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import qovery
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import qovery
from pprint import pprint
from qovery.api import account_info_api
from qovery.model.account_info_response import AccountInfoResponse
# Defining the host is optional and defaults to https://api.qovery.com
# See configuration.py for a list of all supported configuration parameters.
configuration = qovery.Configuration(
    host = "https://api.qovery.com"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure Bearer authorization (JWT): bearerAuth
configuration = qovery.Configuration(
    access_token = 'YOUR_BEARER_TOKEN'
)


# Enter a context with an instance of the API client
with qovery.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = account_info_api.AccountInfoApi(api_client)
    
    try:
        # Get Account information
        api_response = api_instance.get_account_information()
        pprint(api_response)
    except qovery.ApiException as e:
        print("Exception when calling AccountInfoApi->get_account_information: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://api.qovery.com*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AccountInfoApi* | [**get_account_information**](docs/AccountInfoApi.md#get_account_information) | **GET** /account | Get Account information
*ApplicationActionsApi* | [**deploy_application**](docs/ApplicationActionsApi.md#deploy_application) | **POST** /application/{applicationId}/deploy | Deploy application
*ApplicationActionsApi* | [**restart_application**](docs/ApplicationActionsApi.md#restart_application) | **POST** /application/{applicationId}/restart | Restart application
*ApplicationActionsApi* | [**stop_application**](docs/ApplicationActionsApi.md#stop_application) | **POST** /application/{applicationId}/stop | Stop application
*ApplicationConfigurationApi* | [**edit_application_network**](docs/ApplicationConfigurationApi.md#edit_application_network) | **PUT** /application/{applicationId}/network | Edit Application Network
*ApplicationConfigurationApi* | [**get_application_network**](docs/ApplicationConfigurationApi.md#get_application_network) | **GET** /application/{applicationId}/network | Get Application Network information
*ApplicationDatabaseApi* | [**attach_databaseto_application**](docs/ApplicationDatabaseApi.md#attach_databaseto_application) | **POST** /application/{applicationId}/database/{targetDatabaseId} | Link a database to the application
*ApplicationDatabaseApi* | [**attach_logical_databaseto_application**](docs/ApplicationDatabaseApi.md#attach_logical_databaseto_application) | **POST** /application/{applicationId}/logicalDatabase/{targetLogicalDatabaseId} | Link a logical database to the application
*ApplicationDatabaseApi* | [**list_application_database**](docs/ApplicationDatabaseApi.md#list_application_database) | **GET** /application/{applicationId}/database | List linked databases
*ApplicationDatabaseApi* | [**list_application_logical_database**](docs/ApplicationDatabaseApi.md#list_application_logical_database) | **GET** /application/{applicationId}/logicalDatabase | List linked logical databases
*ApplicationDatabaseApi* | [**remove_database_from_application**](docs/ApplicationDatabaseApi.md#remove_database_from_application) | **DELETE** /application/{applicationId}/database/{targetDatabaseId} | Remove database link to this application.
*ApplicationDatabaseApi* | [**remove_logical_database_from_application**](docs/ApplicationDatabaseApi.md#remove_logical_database_from_application) | **DELETE** /application/{applicationId}/logicalDatabase/{targetLogicalDatabaseId} | Remove logical database link to this application.
*ApplicationDeploymentHistoryApi* | [**list_application_deployment_history**](docs/ApplicationDeploymentHistoryApi.md#list_application_deployment_history) | **GET** /application/{applicationId}/deploymentHistory | List application deploys
*ApplicationEnvironmentVariableApi* | [**create_application_environment_variable**](docs/ApplicationEnvironmentVariableApi.md#create_application_environment_variable) | **POST** /application/{applicationId}/environmentVariable | Add an environment variable to the application
*ApplicationEnvironmentVariableApi* | [**create_application_environment_variable_alias**](docs/ApplicationEnvironmentVariableApi.md#create_application_environment_variable_alias) | **POST** /application/{applicationId}/environmentVariable/{environmentVariableId}/alias | Create an environment variable alias at the application level
*ApplicationEnvironmentVariableApi* | [**create_application_environment_variable_override**](docs/ApplicationEnvironmentVariableApi.md#create_application_environment_variable_override) | **POST** /application/{applicationId}/environmentVariable/{environmentVariableId}/override | Create an environment variable override at the application level
*ApplicationEnvironmentVariableApi* | [**delete_application_environment_variable**](docs/ApplicationEnvironmentVariableApi.md#delete_application_environment_variable) | **DELETE** /application/{applicationId}/environmentVariable/{environmentVariableId} | Delete an environment variable from an application
*ApplicationEnvironmentVariableApi* | [**edit_application_environment_variable**](docs/ApplicationEnvironmentVariableApi.md#edit_application_environment_variable) | **PUT** /application/{applicationId}/environmentVariable/{environmentVariableId} | Edit an environment variable belonging to the application
*ApplicationEnvironmentVariableApi* | [**import_environment_variable**](docs/ApplicationEnvironmentVariableApi.md#import_environment_variable) | **POST** /application/{applicationId}/environmentVariable/import | Import variables
*ApplicationEnvironmentVariableApi* | [**list_application_environment_variable**](docs/ApplicationEnvironmentVariableApi.md#list_application_environment_variable) | **GET** /application/{applicationId}/environmentVariable | List environment variables
*ApplicationEventApi* | [**list_application_event**](docs/ApplicationEventApi.md#list_application_event) | **GET** /application/{applicationId}/event | List application events
*ApplicationLogsApi* | [**list_application_log**](docs/ApplicationLogsApi.md#list_application_log) | **GET** /application/{applicationId}/log | List logs
*ApplicationMainCallsApi* | [**create_application_tag**](docs/ApplicationMainCallsApi.md#create_application_tag) | **POST** /application/{applicationId}/tag | Add application tag
*ApplicationMainCallsApi* | [**delete_application**](docs/ApplicationMainCallsApi.md#delete_application) | **DELETE** /application/{applicationId} | Delete application
*ApplicationMainCallsApi* | [**delete_application_tag**](docs/ApplicationMainCallsApi.md#delete_application_tag) | **DELETE** /application/{applicationId}/tag/{tagId} | Delete application tag
*ApplicationMainCallsApi* | [**edit_application**](docs/ApplicationMainCallsApi.md#edit_application) | **PUT** /application/{applicationId} | Edit application
*ApplicationMainCallsApi* | [**get_application**](docs/ApplicationMainCallsApi.md#get_application) | **GET** /application/{applicationId} | Get application by ID
*ApplicationMainCallsApi* | [**get_application_status**](docs/ApplicationMainCallsApi.md#get_application_status) | **GET** /application/{applicationId}/status | Get application status
*ApplicationMainCallsApi* | [**list_application_commit**](docs/ApplicationMainCallsApi.md#list_application_commit) | **GET** /application/{applicationId}/commit | List last commits
*ApplicationMainCallsApi* | [**list_application_contributor**](docs/ApplicationMainCallsApi.md#list_application_contributor) | **GET** /application/{applicationId}/contributor | List contributors
*ApplicationMainCallsApi* | [**list_application_links**](docs/ApplicationMainCallsApi.md#list_application_links) | **GET** /application/{applicationId}/link | List all URLs of the application
*ApplicationMainCallsApi* | [**list_application_tag**](docs/ApplicationMainCallsApi.md#list_application_tag) | **GET** /application/{applicationId}/tag | List tags
*ApplicationMetricsApi* | [**get_application_current_instance**](docs/ApplicationMetricsApi.md#get_application_current_instance) | **GET** /application/{applicationId}/instance | List currently running instances of the application with their CPU and RAM metrics
*ApplicationMetricsApi* | [**get_application_current_scale**](docs/ApplicationMetricsApi.md#get_application_current_scale) | **GET** /application/{applicationId}/currentScale | Get current scaling of the application
*ApplicationMetricsApi* | [**get_application_current_storage_disk**](docs/ApplicationMetricsApi.md#get_application_current_storage_disk) | **GET** /application/{applicationId}/currentStorage | List current storage disk usage
*ApplicationMetricsApi* | [**get_application_metric_cpu**](docs/ApplicationMetricsApi.md#get_application_metric_cpu) | **GET** /application/{applicationId}/metric/cpu | Get CPU consumption metric over time for the application
*ApplicationMetricsApi* | [**get_application_metric_health_check**](docs/ApplicationMetricsApi.md#get_application_metric_health_check) | **GET** /application/{applicationId}/metric/healthCheck | Get Health Check latency  metric over time for the application
*ApplicationMetricsApi* | [**get_application_metric_memory**](docs/ApplicationMetricsApi.md#get_application_metric_memory) | **GET** /application/{applicationId}/metric/memory | Get Memory consumption metric over time for the application
*ApplicationMetricsApi* | [**get_application_metric_restart**](docs/ApplicationMetricsApi.md#get_application_metric_restart) | **GET** /application/{applicationId}/metric/restart | List application restarts
*ApplicationMetricsApi* | [**get_application_metric_storage**](docs/ApplicationMetricsApi.md#get_application_metric_storage) | **GET** /application/{applicationId}/metric/storage | Get Storage consumption metric over time for the application
*ApplicationSecretApi* | [**create_application_secret**](docs/ApplicationSecretApi.md#create_application_secret) | **POST** /application/{applicationId}/secret | Add a secret to the application
*ApplicationSecretApi* | [**create_application_secret_alias**](docs/ApplicationSecretApi.md#create_application_secret_alias) | **POST** /application/{applicationId}/secret/{secretId}/alias | Create a secret alias at the application level
*ApplicationSecretApi* | [**create_application_secret_override**](docs/ApplicationSecretApi.md#create_application_secret_override) | **POST** /application/{applicationId}/secret/{secretId}/override | Create a secret override at the application level
*ApplicationSecretApi* | [**delete_application_secret**](docs/ApplicationSecretApi.md#delete_application_secret) | **DELETE** /application/{applicationId}/secret/{secretId} | Delete a secret from an application
*ApplicationSecretApi* | [**edit_application_secret**](docs/ApplicationSecretApi.md#edit_application_secret) | **PUT** /application/{applicationId}/secret/{secretId} | Edit a secret belonging to the application
*ApplicationSecretApi* | [**list_application_secrets**](docs/ApplicationSecretApi.md#list_application_secrets) | **GET** /application/{applicationId}/secret | List application secrets
*ApplicationsApi* | [**create_application**](docs/ApplicationsApi.md#create_application) | **POST** /environment/{environmentId}/application | Create an application
*ApplicationsApi* | [**get_environment_application_current_instance**](docs/ApplicationsApi.md#get_environment_application_current_instance) | **GET** /environment/{environmentId}/application/instance | List running instances with CPU and RAM usage for each application
*ApplicationsApi* | [**get_environment_application_current_scale**](docs/ApplicationsApi.md#get_environment_application_current_scale) | **GET** /environment/{environmentId}/application/currentScale | List current scaling information for each application
*ApplicationsApi* | [**get_environment_application_current_storage**](docs/ApplicationsApi.md#get_environment_application_current_storage) | **GET** /environment/{environmentId}/application/currentStorage | List current storage disk usage for each application
*ApplicationsApi* | [**get_environment_application_status**](docs/ApplicationsApi.md#get_environment_application_status) | **GET** /environment/{environmentId}/application/status | List all environment applications statuses
*ApplicationsApi* | [**get_environment_application_supported_languages**](docs/ApplicationsApi.md#get_environment_application_supported_languages) | **GET** /environment/{environmentId}/application/supportedLanguage | List supported languages
*ApplicationsApi* | [**list_application**](docs/ApplicationsApi.md#list_application) | **GET** /environment/{environmentId}/application | List applications
*BackupsApi* | [**add_backup_database**](docs/BackupsApi.md#add_backup_database) | **POST** /database/{databaseId}/backup | Add a backup to the Database 
*BackupsApi* | [**list_database_backup**](docs/BackupsApi.md#list_database_backup) | **GET** /database/{databaseId}/backup | List database  backups
*BackupsApi* | [**remove_database_backup**](docs/BackupsApi.md#remove_database_backup) | **DELETE** /database/{databaseId}/backup/{backupId} | Remove database  backup
*BillingApi* | [**add_credit_card**](docs/BillingApi.md#add_credit_card) | **POST** /organization/{organizationId}/creditCard | Add credit card
*BillingApi* | [**add_credit_code**](docs/BillingApi.md#add_credit_code) | **POST** /organization/{organizationId}/creditCode | Add credit code
*BillingApi* | [**delete_credit_card**](docs/BillingApi.md#delete_credit_card) | **DELETE** /organization/{organizationId}/creditCard/{creditCardId} | Delete credit card
*BillingApi* | [**edit_organization_billing_info**](docs/BillingApi.md#edit_organization_billing_info) | **PUT** /organization/{organizationId}/billingInfo | Edit Organization Billing Info
*BillingApi* | [**get_cluster_current_cost**](docs/BillingApi.md#get_cluster_current_cost) | **GET** /organization/{organizationId}/cluster/{clusterId}/currentCost | Get cluster current cost
*BillingApi* | [**get_organization_billing_info**](docs/BillingApi.md#get_organization_billing_info) | **GET** /organization/{organizationId}/billingInfo | Get organization billing info
*BillingApi* | [**get_organization_billing_status**](docs/BillingApi.md#get_organization_billing_status) | **GET** /organization/{organizationId}/billingStatus | Get organization billing status
*BillingApi* | [**get_organization_current_cost**](docs/BillingApi.md#get_organization_current_cost) | **GET** /organization/{organizationId}/currentCost | Get organization current cost
*BillingApi* | [**get_organization_invoice**](docs/BillingApi.md#get_organization_invoice) | **GET** /organization/{organizationId}/invoice/{invoiceId} | Get organization invoice
*BillingApi* | [**get_organization_invoice_pdf**](docs/BillingApi.md#get_organization_invoice_pdf) | **GET** /organization/{organizationId}/invoice/{invoiceId}/download | Get invoice link
*BillingApi* | [**list_organization_credit_cards**](docs/BillingApi.md#list_organization_credit_cards) | **GET** /organization/{organizationId}/creditCard | List organization credit cards
*BillingApi* | [**list_organization_invoice**](docs/BillingApi.md#list_organization_invoice) | **GET** /organization/{organizationId}/invoice | List organization invoices
*BillingApi* | [**organization_download_all_invoices**](docs/BillingApi.md#organization_download_all_invoices) | **POST** /organization/{organizationId}/downloadInvoices | Download all invoices
*CloudProviderApi* | [**list_aws_features**](docs/CloudProviderApi.md#list_aws_features) | **GET** /aws/clusterFeature | List AWS features available
*CloudProviderApi* | [**list_aws_regions**](docs/CloudProviderApi.md#list_aws_regions) | **GET** /aws/region | List AWS regions
*CloudProviderApi* | [**list_cloud_provider**](docs/CloudProviderApi.md#list_cloud_provider) | **GET** /cloudProvider | List Cloud providers available
*CloudProviderApi* | [**list_do_features**](docs/CloudProviderApi.md#list_do_features) | **GET** /digitalOcean/clusterFeature | List DO features available
*CloudProviderApi* | [**list_do_regions**](docs/CloudProviderApi.md#list_do_regions) | **GET** /digitalOcean/region | List DO regions
*CloudProviderApi* | [**list_scaleway_features**](docs/CloudProviderApi.md#list_scaleway_features) | **GET** /scaleway/clusterFeature | List Scaleway features available
*CloudProviderApi* | [**list_scaleway_regions**](docs/CloudProviderApi.md#list_scaleway_regions) | **GET** /scaleway/region | List Scaleway regions
*CloudProviderCredentialsApi* | [**create_aws_credentials**](docs/CloudProviderCredentialsApi.md#create_aws_credentials) | **POST** /organization/{organizationId}/aws/credentials | Create AWS credentials set
*CloudProviderCredentialsApi* | [**create_do_credentials**](docs/CloudProviderCredentialsApi.md#create_do_credentials) | **POST** /organization/{organizationId}/digitalOcean/credentials | Create Digital Ocean credentials set
*CloudProviderCredentialsApi* | [**create_scaleway_credentials**](docs/CloudProviderCredentialsApi.md#create_scaleway_credentials) | **POST** /organization/{organizationId}/scaleway/credentials | Create Scaleway credentials set
*CloudProviderCredentialsApi* | [**delete_aws_credentials**](docs/CloudProviderCredentialsApi.md#delete_aws_credentials) | **DELETE** /organization/{organizationId}/aws/credentials/{credentialsId} | Delete a set of AWS credentials
*CloudProviderCredentialsApi* | [**delete_do_credentials**](docs/CloudProviderCredentialsApi.md#delete_do_credentials) | **DELETE** /organization/{organizationId}/digitalOcean/credentials/{credentialsId} | Delete a set of Digital Ocean credentials
*CloudProviderCredentialsApi* | [**delete_scaleway_credentials**](docs/CloudProviderCredentialsApi.md#delete_scaleway_credentials) | **DELETE** /organization/{organizationId}/scaleway/credentials/{credentialsId} | Delete a set of Scaleway credentials
*CloudProviderCredentialsApi* | [**edit_aws_credentials**](docs/CloudProviderCredentialsApi.md#edit_aws_credentials) | **PUT** /organization/{organizationId}/aws/credentials/{credentialsId} | Edit a set of AWS credentials
*CloudProviderCredentialsApi* | [**edit_do_credentials**](docs/CloudProviderCredentialsApi.md#edit_do_credentials) | **PUT** /organization/{organizationId}/digitalOcean/credentials/{credentialsId} | Edit a set of Digital Ocean credentials
*CloudProviderCredentialsApi* | [**edit_scaleway_credentials**](docs/CloudProviderCredentialsApi.md#edit_scaleway_credentials) | **PUT** /organization/{organizationId}/scaleway/credentials/{credentialsId} | Edit a set of Scaleway credentials
*CloudProviderCredentialsApi* | [**list_aws_credentials**](docs/CloudProviderCredentialsApi.md#list_aws_credentials) | **GET** /organization/{organizationId}/aws/credentials | List AWS credentials
*CloudProviderCredentialsApi* | [**list_do_credentials**](docs/CloudProviderCredentialsApi.md#list_do_credentials) | **GET** /organization/{organizationId}/digitalOcean/credentials | List DO credentials
*CloudProviderCredentialsApi* | [**list_scaleway_credentials**](docs/CloudProviderCredentialsApi.md#list_scaleway_credentials) | **GET** /organization/{organizationId}/scaleway/credentials | List Scaleway credentials
*ClustersApi* | [**create_cluster**](docs/ClustersApi.md#create_cluster) | **POST** /organization/{organizationId}/cluster | Create a cluster
*ClustersApi* | [**delete_cluster**](docs/ClustersApi.md#delete_cluster) | **DELETE** /organization/{organizationId}/cluster/{clusterId} | Delete a cluster
*ClustersApi* | [**deploy_cluster**](docs/ClustersApi.md#deploy_cluster) | **POST** /organization/{organizationId}/cluster/{clusterId}/deploy | Deploy a cluster
*ClustersApi* | [**edit_cluster**](docs/ClustersApi.md#edit_cluster) | **PUT** /organization/{organizationId}/cluster/{clusterId} | Edit a cluster
*ClustersApi* | [**edit_routing_table**](docs/ClustersApi.md#edit_routing_table) | **PUT** /organization/{organizationId}/cluster/{clusterId}/routingTable | Edit routing table
*ClustersApi* | [**get_cluster_readiness_status**](docs/ClustersApi.md#get_cluster_readiness_status) | **GET** /organization/{organizationId}/cluster/{clusterId}/isReady | Know if a cluster is ready to be deployed or not
*ClustersApi* | [**get_cluster_status**](docs/ClustersApi.md#get_cluster_status) | **GET** /organization/{organizationId}/cluster/{clusterId}/status | Get cluster status
*ClustersApi* | [**get_organization_cloud_provider_info**](docs/ClustersApi.md#get_organization_cloud_provider_info) | **GET** /organization/{organizationId}/cluster/{clusterId}/cloudProviderInfo | Get cluster cloud provider info and credentials
*ClustersApi* | [**get_organization_cluster_status**](docs/ClustersApi.md#get_organization_cluster_status) | **GET** /organization/{organizationId}/cluster/status | List all clusters statuses
*ClustersApi* | [**get_routing_table**](docs/ClustersApi.md#get_routing_table) | **GET** /organization/{organizationId}/cluster/{clusterId}/routingTable | Get routing table
*ClustersApi* | [**list_organization_cluster**](docs/ClustersApi.md#list_organization_cluster) | **GET** /organization/{organizationId}/cluster | List organization clusters
*ClustersApi* | [**specify_cluster_cloud_provider_info**](docs/ClustersApi.md#specify_cluster_cloud_provider_info) | **POST** /organization/{organizationId}/cluster/{clusterId}/cloudProviderInfo | Specify cluster cloud provider info and credentials
*ClustersApi* | [**stop_cluster**](docs/ClustersApi.md#stop_cluster) | **POST** /organization/{organizationId}/cluster/{clusterId}/stop | Stop cluster
*ClustersApi* | [**update_cluster**](docs/ClustersApi.md#update_cluster) | **POST** /organization/{organizationId}/cluster/{clusterId}/update | Update a cluster Version
*CustomDomainApi* | [**create_application_custom_domain**](docs/CustomDomainApi.md#create_application_custom_domain) | **POST** /application/{applicationId}/customDomain | Add custom domain to the application.
*CustomDomainApi* | [**delete_custom_domain**](docs/CustomDomainApi.md#delete_custom_domain) | **DELETE** /application/{applicationId}/customDomain/{customDomainId} | Delete a Custom Domain
*CustomDomainApi* | [**edit_custom_domain**](docs/CustomDomainApi.md#edit_custom_domain) | **PUT** /application/{applicationId}/customDomain/{customDomainId} | Edit a Custom Domain
*CustomDomainApi* | [**get_custom_domain_status**](docs/CustomDomainApi.md#get_custom_domain_status) | **GET** /application/{applicationId}/customDomain/{customDomainId}/status | Get Custom Domain status
*CustomDomainApi* | [**list_application_custom_domain**](docs/CustomDomainApi.md#list_application_custom_domain) | **GET** /application/{applicationId}/customDomain | List application custom domains
*DatabaseActionsApi* | [**deploy_database**](docs/DatabaseActionsApi.md#deploy_database) | **POST** /database/{databaseId}/deploy | Deploy database 
*DatabaseActionsApi* | [**restart_database**](docs/DatabaseActionsApi.md#restart_database) | **POST** /database/{databaseId}/restart | Retart database
*DatabaseActionsApi* | [**stop_database**](docs/DatabaseActionsApi.md#stop_database) | **POST** /database/{databaseId}/stop | Stop database
*DatabaseApplicationApi* | [**list_database_application**](docs/DatabaseApplicationApi.md#list_database_application) | **GET** /database/{databaseId}/application | List applications using the database
*DatabaseApplicationApi* | [**remove_application_from_database**](docs/DatabaseApplicationApi.md#remove_application_from_database) | **DELETE** /database/{databaseId}/application/{targetApplicationId} | Remove an application from this database 
*DatabaseEventApi* | [**list_database_event**](docs/DatabaseEventApi.md#list_database_event) | **GET** /database/{databaseId}/event | List database  events
*DatabaseMainCallsApi* | [**delete_database**](docs/DatabaseMainCallsApi.md#delete_database) | **DELETE** /database/{databaseId} | Delete a database 
*DatabaseMainCallsApi* | [**edit_database**](docs/DatabaseMainCallsApi.md#edit_database) | **PUT** /database/{databaseId} | Edit a database 
*DatabaseMainCallsApi* | [**edit_database_credentials**](docs/DatabaseMainCallsApi.md#edit_database_credentials) | **PUT** /database/{databaseId}/masterCredentials | Edit database  master credentials
*DatabaseMainCallsApi* | [**get_database**](docs/DatabaseMainCallsApi.md#get_database) | **GET** /database/{databaseId} | Get database by ID
*DatabaseMainCallsApi* | [**get_database_master_credentials**](docs/DatabaseMainCallsApi.md#get_database_master_credentials) | **GET** /database/{databaseId}/masterCredentials | Get master credentials of the database
*DatabaseMainCallsApi* | [**get_database_status**](docs/DatabaseMainCallsApi.md#get_database_status) | **GET** /database/{databaseId}/status | Get database status
*DatabaseMainCallsApi* | [**list_database_version**](docs/DatabaseMainCallsApi.md#list_database_version) | **GET** /database/{databaseId}/version | List eligible versions for the database
*DatabaseMetricsApi* | [**get_database_current_metric**](docs/DatabaseMetricsApi.md#get_database_current_metric) | **GET** /database/{databaseId}/currentMetric | Get current metric consumption of the database 
*DatabaseMetricsApi* | [**get_database_metric_cpu**](docs/DatabaseMetricsApi.md#get_database_metric_cpu) | **GET** /database/{databaseId}/metric/cpu | Get CPU consumption metric over time for the database
*DatabaseMetricsApi* | [**get_database_metric_health_check**](docs/DatabaseMetricsApi.md#get_database_metric_health_check) | **GET** /database/{databaseId}/metric/healthCheck | Get Health Check latency  metric over time for the database
*DatabaseMetricsApi* | [**get_database_metric_memory**](docs/DatabaseMetricsApi.md#get_database_metric_memory) | **GET** /database/{databaseId}/metric/memory | Get Memory consumption metric over time for the database
*DatabaseMetricsApi* | [**get_database_metric_restart**](docs/DatabaseMetricsApi.md#get_database_metric_restart) | **GET** /database/{databaseId}/metric/restart | List database restarts
*DatabaseMetricsApi* | [**get_database_metric_storage**](docs/DatabaseMetricsApi.md#get_database_metric_storage) | **GET** /database/{databaseId}/metric/storage | Get Storage consumption metric over time for the database
*DatabasesApi* | [**create_database**](docs/DatabasesApi.md#create_database) | **POST** /environment/{environmentId}/database | Create a database
*DatabasesApi* | [**get_environment_database_status**](docs/DatabasesApi.md#get_environment_database_status) | **GET** /environment/{environmentId}/database/status | List all environment databases statuses
*DatabasesApi* | [**list_database**](docs/DatabasesApi.md#list_database) | **GET** /environment/{environmentId}/database | List environment databases
*DatabasesApi* | [**list_environment_database_config**](docs/DatabasesApi.md#list_environment_database_config) | **GET** /environment/{environmentId}/databaseConfiguration | List eligible database types, versions and modes for the environment
*DatabasesApi* | [**list_environment_database_current_metric**](docs/DatabasesApi.md#list_environment_database_current_metric) | **GET** /environment/{environmentId}/database/currentMetric | List current metric consumption for each database
*DependencyApi* | [**create_application_dependency**](docs/DependencyApi.md#create_application_dependency) | **POST** /application/{applicationId}/dependency/{targetApplicationId} | Add application dependency to this application.
*DependencyApi* | [**list_application_dependency**](docs/DependencyApi.md#list_application_dependency) | **GET** /application/{applicationId}/dependency | List application dependencies
*DependencyApi* | [**remove_application_dependency**](docs/DependencyApi.md#remove_application_dependency) | **DELETE** /application/{applicationId}/dependency/{targetApplicationId} | Remove application dependency to this application.
*EnvironmentActionsApi* | [**cancel_environment_deployment**](docs/EnvironmentActionsApi.md#cancel_environment_deployment) | **POST** /environment/{environmentId}/cancelDeployment | Cancel environment deployment
*EnvironmentActionsApi* | [**clone_environment**](docs/EnvironmentActionsApi.md#clone_environment) | **POST** /environment/{environmentId}/clone | Clone environment
*EnvironmentActionsApi* | [**deploy_environment**](docs/EnvironmentActionsApi.md#deploy_environment) | **POST** /environment/{environmentId}/deploy | Deploy environment
*EnvironmentActionsApi* | [**restart_environment**](docs/EnvironmentActionsApi.md#restart_environment) | **POST** /environment/{environmentId}/restart | Restart environment
*EnvironmentActionsApi* | [**stop_environment**](docs/EnvironmentActionsApi.md#stop_environment) | **POST** /environment/{environmentId}/stop | Stop environment
*EnvironmentDeploymentHistoryApi* | [**list_environment_deployment_history**](docs/EnvironmentDeploymentHistoryApi.md#list_environment_deployment_history) | **GET** /environment/{environmentId}/deploymentHistory | List environment deployments
*EnvironmentDeploymentRuleApi* | [**edit_environment_deployment_rule**](docs/EnvironmentDeploymentRuleApi.md#edit_environment_deployment_rule) | **PUT** /environment/{environmentId}/deploymentRule/{deploymentRuleId} | Edit an environment deployment rule
*EnvironmentDeploymentRuleApi* | [**get_environment_deployment_rule**](docs/EnvironmentDeploymentRuleApi.md#get_environment_deployment_rule) | **GET** /environment/{environmentId}/deploymentRule | Get environment deployment rule
*EnvironmentLogsApi* | [**list_environment_log**](docs/EnvironmentLogsApi.md#list_environment_log) | **GET** /environment/{environmentId}/log | List environment deployment logs
*EnvironmentMainCallsApi* | [**delete_environment**](docs/EnvironmentMainCallsApi.md#delete_environment) | **DELETE** /environment/{environmentId} | Delete an environment
*EnvironmentMainCallsApi* | [**edit_environment**](docs/EnvironmentMainCallsApi.md#edit_environment) | **PUT** /environment/{environmentId} | Edit an environment
*EnvironmentMainCallsApi* | [**get_environment**](docs/EnvironmentMainCallsApi.md#get_environment) | **GET** /environment/{environmentId} | Get environment by ID
*EnvironmentMainCallsApi* | [**get_environment_status**](docs/EnvironmentMainCallsApi.md#get_environment_status) | **GET** /environment/{environmentId}/status | Get environment status
*EnvironmentMainCallsApi* | [**list_environment_links**](docs/EnvironmentMainCallsApi.md#list_environment_links) | **GET** /environment/{environmentId}/link | List all URLs of the environment
*EnvironmentSecretApi* | [**create_environment_secret**](docs/EnvironmentSecretApi.md#create_environment_secret) | **POST** /environment/{environmentId}/secret | Add a secret to the environment
*EnvironmentSecretApi* | [**create_environment_secret_alias**](docs/EnvironmentSecretApi.md#create_environment_secret_alias) | **POST** /environment/{environmentId}/secret/{secretId}/alias | Create a secret alias at the environment level
*EnvironmentSecretApi* | [**create_environment_secret_override**](docs/EnvironmentSecretApi.md#create_environment_secret_override) | **POST** /environment/{environmentId}/secret/{secretId}/override | Create a secret override at the environment level
*EnvironmentSecretApi* | [**delete_environment_secret**](docs/EnvironmentSecretApi.md#delete_environment_secret) | **DELETE** /environment/{environmentId}/secret/{secretId} | Delete a secret from the environment
*EnvironmentSecretApi* | [**edit_environment_secret**](docs/EnvironmentSecretApi.md#edit_environment_secret) | **PUT** /environment/{environmentId}/secret/{secretId} | Edit a secret belonging to the environment
*EnvironmentSecretApi* | [**list_environment_secrets**](docs/EnvironmentSecretApi.md#list_environment_secrets) | **GET** /environment/{environmentId}/secret | List environment secrets
*EnvironmentVariableApi* | [**create_environment_environment_variable**](docs/EnvironmentVariableApi.md#create_environment_environment_variable) | **POST** /environment/{environmentId}/environmentVariable | Add an environment variable to the environment
*EnvironmentVariableApi* | [**create_environment_environment_variable_alias**](docs/EnvironmentVariableApi.md#create_environment_environment_variable_alias) | **POST** /environment/{environmentId}/environmentVariable/{environmentVariableId}/alias | Create an environment variable alias at the environment level
*EnvironmentVariableApi* | [**create_environment_environment_variable_override**](docs/EnvironmentVariableApi.md#create_environment_environment_variable_override) | **POST** /environment/{environmentId}/environmentVariable/{environmentVariableId}/override | Create an environment variable override at the environment level
*EnvironmentVariableApi* | [**delete_environment_environment_variable**](docs/EnvironmentVariableApi.md#delete_environment_environment_variable) | **DELETE** /environment/{environmentId}/environmentVariable/{environmentVariableId} | Delete an environment variable from an environment
*EnvironmentVariableApi* | [**edit_environment_environment_variable**](docs/EnvironmentVariableApi.md#edit_environment_environment_variable) | **PUT** /environment/{environmentId}/environmentVariable/{environmentVariableId} | Edit an environment variable belonging to the environment
*EnvironmentVariableApi* | [**list_environment_environment_variable**](docs/EnvironmentVariableApi.md#list_environment_environment_variable) | **GET** /environment/{environmentId}/environmentVariable | List environment variables
*EnvironmentsApi* | [**create_environment**](docs/EnvironmentsApi.md#create_environment) | **POST** /project/{projectId}/environment | Create an environment
*EnvironmentsApi* | [**get_project_environment_service_number**](docs/EnvironmentsApi.md#get_project_environment_service_number) | **GET** /project/{projectId}/environment/stats | List total number of services for each environment of the project
*EnvironmentsApi* | [**get_project_environment_status**](docs/EnvironmentsApi.md#get_project_environment_status) | **GET** /project/{projectId}/environment/status | List environments statuses
*EnvironmentsApi* | [**list_environment**](docs/EnvironmentsApi.md#list_environment) | **GET** /project/{projectId}/environment | List environments
*GitRepositoriesApi* | [**get_bitbucket_repositories**](docs/GitRepositoriesApi.md#get_bitbucket_repositories) | **GET** /account/bitbucket/repository | Get bitbucket repositories of the connected user
*GitRepositoriesApi* | [**get_bitbucket_repository_branches**](docs/GitRepositoriesApi.md#get_bitbucket_repository_branches) | **GET** /account/bitbucket/repository/branch | Get bitbucket branches of the specified repository
*GitRepositoriesApi* | [**get_git_provider_account**](docs/GitRepositoriesApi.md#get_git_provider_account) | **GET** /account/gitAuthProvider | Get git provider accounts
*GitRepositoriesApi* | [**get_github_repositories**](docs/GitRepositoriesApi.md#get_github_repositories) | **GET** /account/github/repository | Get github repositories of the connected user
*GitRepositoriesApi* | [**get_github_repository_branches**](docs/GitRepositoriesApi.md#get_github_repository_branches) | **GET** /account/github/repository/branch | Get github branches of the specified repository
*GitRepositoriesApi* | [**get_gitlab_repositories**](docs/GitRepositoriesApi.md#get_gitlab_repositories) | **GET** /account/gitlab/repository | Get gitlab repositories of the connected user
*GitRepositoriesApi* | [**get_gitlab_repository_branches**](docs/GitRepositoriesApi.md#get_gitlab_repository_branches) | **GET** /account/gitlab/repository/branch | Get gitlab branches of the specified repository
*LogicalDatabaseApi* | [**create_logical_database_on_database**](docs/LogicalDatabaseApi.md#create_logical_database_on_database) | **POST** /database/{databaseId}/logicalDatabase | Create a logical database on the database
*LogicalDatabaseApi* | [**delete_logical_database**](docs/LogicalDatabaseApi.md#delete_logical_database) | **DELETE** /logicalDatabase/{logicalDatabaseId} | Delete a Logical database
*LogicalDatabaseApi* | [**edit_logical_database**](docs/LogicalDatabaseApi.md#edit_logical_database) | **PUT** /logicalDatabase/{logicalDatabaseId} | Edit a logical database
*LogicalDatabaseApi* | [**edit_logical_database_credentials**](docs/LogicalDatabaseApi.md#edit_logical_database_credentials) | **PUT** /logicalDatabase/{logicalDatabaseId}/credentials | Edit logical database credentials
*LogicalDatabaseApi* | [**get_logical_database**](docs/LogicalDatabaseApi.md#get_logical_database) | **GET** /logicalDatabase/{logicalDatabaseId} | Get logical database by ID
*LogicalDatabaseApi* | [**get_logical_database_credentials**](docs/LogicalDatabaseApi.md#get_logical_database_credentials) | **GET** /logicalDatabase/{logicalDatabaseId}/credentials | Get  credentials of the logical database
*LogicalDatabaseApi* | [**list_logical_database_application**](docs/LogicalDatabaseApi.md#list_logical_database_application) | **GET** /logicalDatabase/{logicalDatabaseId}/application | List linked applications
*LogicalDatabaseApi* | [**list_logical_database_database**](docs/LogicalDatabaseApi.md#list_logical_database_database) | **GET** /database/{databaseId}/logicalDatabase | List logical databases of a database
*MembersApi* | [**delete_invite_member**](docs/MembersApi.md#delete_invite_member) | **DELETE** /organization/{organizationId}/inviteMember/{inviteId} | Remove an invited member
*MembersApi* | [**delete_member**](docs/MembersApi.md#delete_member) | **DELETE** /organization/{organizationId}/member/{userId} | Remove a member
*MembersApi* | [**get_organization_invited_members**](docs/MembersApi.md#get_organization_invited_members) | **GET** /organization/{organizationId}/inviteMember | Get invited members
*MembersApi* | [**get_organization_members**](docs/MembersApi.md#get_organization_members) | **GET** /organization/{organizationId}/member | Get organization members
*MembersApi* | [**post_accept_invite_member**](docs/MembersApi.md#post_accept_invite_member) | **POST** /organization/{organizationId}/inviteMember/{inviteId} | Accept Invite in the organization
*MembersApi* | [**post_invite_member**](docs/MembersApi.md#post_invite_member) | **POST** /organization/{organizationId}/inviteMember | Invite someone in the organization
*MembersApi* | [**post_organization_transfer_ownership**](docs/MembersApi.md#post_organization_transfer_ownership) | **POST** /organization/{organizationId}/transferOwnership | Transfer organization ownership to another user
*OrganizationMainCallsApi* | [**create_organization**](docs/OrganizationMainCallsApi.md#create_organization) | **POST** /organization | Create an organization
*OrganizationMainCallsApi* | [**delete_organization**](docs/OrganizationMainCallsApi.md#delete_organization) | **DELETE** /organization/{organizationId} | Delete an organization
*OrganizationMainCallsApi* | [**edit_organization**](docs/OrganizationMainCallsApi.md#edit_organization) | **PUT** /organization/{organizationId} | Edit an organization
*OrganizationMainCallsApi* | [**get_organization**](docs/OrganizationMainCallsApi.md#get_organization) | **GET** /organization/{organizationId} | Get organization by ID
*OrganizationMainCallsApi* | [**list_organization**](docs/OrganizationMainCallsApi.md#list_organization) | **GET** /organization | List user organizations
*ProjectDeploymentRuleApi* | [**create_deployment_rule**](docs/ProjectDeploymentRuleApi.md#create_deployment_rule) | **POST** /project/{projectId}/deploymentRule | Create a deployment rule
*ProjectDeploymentRuleApi* | [**delete_project_deployment_rule**](docs/ProjectDeploymentRuleApi.md#delete_project_deployment_rule) | **DELETE** /project/{projectId}/deploymentRule/{deploymentRuleId} | Delete a project deployment rule
*ProjectDeploymentRuleApi* | [**edit_project_deployemtn_rule**](docs/ProjectDeploymentRuleApi.md#edit_project_deployemtn_rule) | **PUT** /project/{projectId}/deploymentRule/{deploymentRuleId} | Edit a project deployment rule
*ProjectDeploymentRuleApi* | [**get_project_deployment_rule**](docs/ProjectDeploymentRuleApi.md#get_project_deployment_rule) | **GET** /project/{projectId}/deploymentRule/{deploymentRuleId} | Get a project deployment rule
*ProjectDeploymentRuleApi* | [**list_project_deployment_rules**](docs/ProjectDeploymentRuleApi.md#list_project_deployment_rules) | **GET** /project/{projectId}/deploymentRule | List project deployment rules
*ProjectDeploymentRuleApi* | [**update_deployment_rules_priority_order**](docs/ProjectDeploymentRuleApi.md#update_deployment_rules_priority_order) | **PUT** /project/{projectId}/deploymentRule/order | Update deployment rules priority order
*ProjectEnvironmentVariableApi* | [**create_project_environment_variable**](docs/ProjectEnvironmentVariableApi.md#create_project_environment_variable) | **POST** /project/{projectId}/environmentVariable | Add an environment variable to the project
*ProjectEnvironmentVariableApi* | [**create_project_environment_variable_alias**](docs/ProjectEnvironmentVariableApi.md#create_project_environment_variable_alias) | **POST** /project/{projectId}/environmentVariable/{environmentVariableId}/alias | Create an environment variable alias at the project level
*ProjectEnvironmentVariableApi* | [**create_project_environment_variable_override**](docs/ProjectEnvironmentVariableApi.md#create_project_environment_variable_override) | **POST** /project/{projectId}/environmentVariable/{environmentVariableId}/override | Create an environment variable override at the project level
*ProjectEnvironmentVariableApi* | [**delete_project_environment_variable**](docs/ProjectEnvironmentVariableApi.md#delete_project_environment_variable) | **DELETE** /project/{projectId}/environmentVariable/{environmentVariableId} | Delete an environment variable from a project
*ProjectEnvironmentVariableApi* | [**edit_project_environment_variable**](docs/ProjectEnvironmentVariableApi.md#edit_project_environment_variable) | **PUT** /project/{projectId}/environmentVariable/{environmentVariableId} | Edit an environment variable belonging to the project
*ProjectEnvironmentVariableApi* | [**list_project_environment_variable**](docs/ProjectEnvironmentVariableApi.md#list_project_environment_variable) | **GET** /project/{projectId}/environmentVariable | List project environment variables
*ProjectMainCallsApi* | [**delete_project**](docs/ProjectMainCallsApi.md#delete_project) | **DELETE** /project/{projectId} | Delete a project
*ProjectMainCallsApi* | [**edit_project**](docs/ProjectMainCallsApi.md#edit_project) | **PUT** /project/{projectId} | Edit a project
*ProjectMainCallsApi* | [**get_project**](docs/ProjectMainCallsApi.md#get_project) | **GET** /project/{projectId} | Get project by ID
*ProjectSecretApi* | [**create_project_secret**](docs/ProjectSecretApi.md#create_project_secret) | **POST** /project/{projectId}/secret | Add a secret to the project
*ProjectSecretApi* | [**create_project_secret_alias**](docs/ProjectSecretApi.md#create_project_secret_alias) | **POST** /project/{projectId}/secret/{secretId}/alias | Create a secret alias at the project level
*ProjectSecretApi* | [**create_project_secret_override**](docs/ProjectSecretApi.md#create_project_secret_override) | **POST** /project/{projectId}/secret/{secretId}/override | Create a secret override at the project level
*ProjectSecretApi* | [**delete_project_secret**](docs/ProjectSecretApi.md#delete_project_secret) | **DELETE** /project/{projectId}/secret/{secretId} | Delete a secret from a project
*ProjectSecretApi* | [**edit_project_secret**](docs/ProjectSecretApi.md#edit_project_secret) | **PUT** /project/{projectId}/secret/{secretId} | Edit a secret belonging to the project
*ProjectSecretApi* | [**list_project_secrets**](docs/ProjectSecretApi.md#list_project_secrets) | **GET** /project/{projectId}/secret | List project secrets
*ProjectsApi* | [**create_project**](docs/ProjectsApi.md#create_project) | **POST** /organization/{organizationId}/project | Create a project
*ProjectsApi* | [**get_organization_project_stats**](docs/ProjectsApi.md#get_organization_project_stats) | **GET** /organization/{organizationId}/project/stats | List total number of services and environments for each project of the organization
*ProjectsApi* | [**list_project**](docs/ProjectsApi.md#list_project) | **GET** /organization/{organizationId}/project | List projects
*ReferralRewardsApi* | [**get_account_referral**](docs/ReferralRewardsApi.md#get_account_referral) | **GET** /account/referral | Get your referral information
*ReferralRewardsApi* | [**post_account_reward_claim**](docs/ReferralRewardsApi.md#post_account_reward_claim) | **POST** /account/rewardClaim | Claim a reward


## Documentation For Models

 - [AccountInfoEditRequest](docs/AccountInfoEditRequest.md)
 - [AccountInfoResponse](docs/AccountInfoResponse.md)
 - [AliasedSecret](docs/AliasedSecret.md)
 - [ApplicationCurrentScaleResponse](docs/ApplicationCurrentScaleResponse.md)
 - [ApplicationDependencyRequest](docs/ApplicationDependencyRequest.md)
 - [ApplicationEditRequest](docs/ApplicationEditRequest.md)
 - [ApplicationGitRepositoryRequest](docs/ApplicationGitRepositoryRequest.md)
 - [ApplicationGitRepositoryResponse](docs/ApplicationGitRepositoryResponse.md)
 - [ApplicationNetworkRequest](docs/ApplicationNetworkRequest.md)
 - [ApplicationNetworkResponse](docs/ApplicationNetworkResponse.md)
 - [ApplicationPortRequest](docs/ApplicationPortRequest.md)
 - [ApplicationPortRequestPorts](docs/ApplicationPortRequestPorts.md)
 - [ApplicationPortResponse](docs/ApplicationPortResponse.md)
 - [ApplicationPortResponsePorts](docs/ApplicationPortResponsePorts.md)
 - [ApplicationRequest](docs/ApplicationRequest.md)
 - [ApplicationResponse](docs/ApplicationResponse.md)
 - [ApplicationResponseList](docs/ApplicationResponseList.md)
 - [ApplicationStorageRequest](docs/ApplicationStorageRequest.md)
 - [ApplicationStorageRequestStorage](docs/ApplicationStorageRequestStorage.md)
 - [ApplicationStorageResponse](docs/ApplicationStorageResponse.md)
 - [ApplicationStorageResponseStorage](docs/ApplicationStorageResponseStorage.md)
 - [AwsCredentialsRequest](docs/AwsCredentialsRequest.md)
 - [BackupPaginatedResponseList](docs/BackupPaginatedResponseList.md)
 - [BackupRequest](docs/BackupRequest.md)
 - [BackupResponse](docs/BackupResponse.md)
 - [BackupResponseList](docs/BackupResponseList.md)
 - [BaseResponse](docs/BaseResponse.md)
 - [BillingEnd](docs/BillingEnd.md)
 - [BillingInfoRequest](docs/BillingInfoRequest.md)
 - [BillingInfoResponse](docs/BillingInfoResponse.md)
 - [BillingPeriod](docs/BillingPeriod.md)
 - [BillingStart](docs/BillingStart.md)
 - [BillingStatus](docs/BillingStatus.md)
 - [BudgetResponse](docs/BudgetResponse.md)
 - [BudgetThreshold](docs/BudgetThreshold.md)
 - [CloneRequest](docs/CloneRequest.md)
 - [CloudProviderResponse](docs/CloudProviderResponse.md)
 - [CloudProviderResponseList](docs/CloudProviderResponseList.md)
 - [CluserCredentialsResponse](docs/CluserCredentialsResponse.md)
 - [Cluster](docs/Cluster.md)
 - [ClusterCloudProviderInfoRequest](docs/ClusterCloudProviderInfoRequest.md)
 - [ClusterCloudProviderInfoRequestCredentials](docs/ClusterCloudProviderInfoRequestCredentials.md)
 - [ClusterCloudProviderInfoResponse](docs/ClusterCloudProviderInfoResponse.md)
 - [ClusterCredentialsRequest](docs/ClusterCredentialsRequest.md)
 - [ClusterCredentialsResponse](docs/ClusterCredentialsResponse.md)
 - [ClusterCredentialsResponseList](docs/ClusterCredentialsResponseList.md)
 - [ClusterFeatureRequest](docs/ClusterFeatureRequest.md)
 - [ClusterFeatureRequestFeatures](docs/ClusterFeatureRequestFeatures.md)
 - [ClusterFeatureResponse](docs/ClusterFeatureResponse.md)
 - [ClusterFeatureResponseList](docs/ClusterFeatureResponseList.md)
 - [ClusterReadinessStatus](docs/ClusterReadinessStatus.md)
 - [ClusterRegionResponse](docs/ClusterRegionResponse.md)
 - [ClusterRegionResponseList](docs/ClusterRegionResponseList.md)
 - [ClusterRequest](docs/ClusterRequest.md)
 - [ClusterResponse](docs/ClusterResponse.md)
 - [ClusterResponseList](docs/ClusterResponseList.md)
 - [ClusterRoutingTableRequest](docs/ClusterRoutingTableRequest.md)
 - [ClusterRoutingTableRequestRoutes](docs/ClusterRoutingTableRequestRoutes.md)
 - [ClusterRoutingTableResponse](docs/ClusterRoutingTableResponse.md)
 - [ClusterRoutingTableResponseResults](docs/ClusterRoutingTableResponseResults.md)
 - [ClusterStatusResponse](docs/ClusterStatusResponse.md)
 - [ClusterStatusResponseList](docs/ClusterStatusResponseList.md)
 - [CommitPaginatedResponseList](docs/CommitPaginatedResponseList.md)
 - [CommitResponse](docs/CommitResponse.md)
 - [CommitResponseList](docs/CommitResponseList.md)
 - [CommunityUsage](docs/CommunityUsage.md)
 - [CommunityUsageResponse](docs/CommunityUsageResponse.md)
 - [Cost](docs/Cost.md)
 - [CostRangeResponse](docs/CostRangeResponse.md)
 - [CostResponse](docs/CostResponse.md)
 - [CredentialsRequest](docs/CredentialsRequest.md)
 - [CredentialsResponse](docs/CredentialsResponse.md)
 - [CreditCardRequest](docs/CreditCardRequest.md)
 - [CreditCardResponse](docs/CreditCardResponse.md)
 - [CreditCardResponseList](docs/CreditCardResponseList.md)
 - [CurrentCost](docs/CurrentCost.md)
 - [CustomDomainRequest](docs/CustomDomainRequest.md)
 - [CustomDomainResponse](docs/CustomDomainResponse.md)
 - [CustomDomainResponseList](docs/CustomDomainResponseList.md)
 - [DatabaseConfigurationResponse](docs/DatabaseConfigurationResponse.md)
 - [DatabaseConfigurationResponseList](docs/DatabaseConfigurationResponseList.md)
 - [DatabaseCurrentMetricResponse](docs/DatabaseCurrentMetricResponse.md)
 - [DatabaseEditRequest](docs/DatabaseEditRequest.md)
 - [DatabaseRequest](docs/DatabaseRequest.md)
 - [DatabaseResponse](docs/DatabaseResponse.md)
 - [DatabaseResponseList](docs/DatabaseResponseList.md)
 - [DatabaseVersionMode](docs/DatabaseVersionMode.md)
 - [DeployRequest](docs/DeployRequest.md)
 - [DeploymentHistoryApplicationResponse](docs/DeploymentHistoryApplicationResponse.md)
 - [DeploymentHistoryDatabaseResponse](docs/DeploymentHistoryDatabaseResponse.md)
 - [DeploymentHistoryEnvironmentPaginatedResponseList](docs/DeploymentHistoryEnvironmentPaginatedResponseList.md)
 - [DeploymentHistoryEnvironmentResponse](docs/DeploymentHistoryEnvironmentResponse.md)
 - [DeploymentHistoryPaginatedResponseList](docs/DeploymentHistoryPaginatedResponseList.md)
 - [DeploymentHistoryResponse](docs/DeploymentHistoryResponse.md)
 - [DeploymentHistoryResponseList](docs/DeploymentHistoryResponseList.md)
 - [DeploymentRuleRequest](docs/DeploymentRuleRequest.md)
 - [DoCredentialsRequest](docs/DoCredentialsRequest.md)
 - [EnvironmentApplicationsCurrentScaleResponse](docs/EnvironmentApplicationsCurrentScaleResponse.md)
 - [EnvironmentApplicationsCurrentScaleResponseList](docs/EnvironmentApplicationsCurrentScaleResponseList.md)
 - [EnvironmentApplicationsInstanceResponseList](docs/EnvironmentApplicationsInstanceResponseList.md)
 - [EnvironmentApplicationsInstanceResponseListResults](docs/EnvironmentApplicationsInstanceResponseListResults.md)
 - [EnvironmentApplicationsStorageResponse](docs/EnvironmentApplicationsStorageResponse.md)
 - [EnvironmentApplicationsStorageResponseList](docs/EnvironmentApplicationsStorageResponseList.md)
 - [EnvironmentApplicationsSupportedLanguage](docs/EnvironmentApplicationsSupportedLanguage.md)
 - [EnvironmentApplicationsSupportedLanguageList](docs/EnvironmentApplicationsSupportedLanguageList.md)
 - [EnvironmentApplicationsSupportedLanguageResponse](docs/EnvironmentApplicationsSupportedLanguageResponse.md)
 - [EnvironmentApplicationsSupportedLanguageResponseList](docs/EnvironmentApplicationsSupportedLanguageResponseList.md)
 - [EnvironmentDatabasesCurrentMetricResponse](docs/EnvironmentDatabasesCurrentMetricResponse.md)
 - [EnvironmentDatabasesCurrentMetricResponseCpu](docs/EnvironmentDatabasesCurrentMetricResponseCpu.md)
 - [EnvironmentDatabasesCurrentMetricResponseList](docs/EnvironmentDatabasesCurrentMetricResponseList.md)
 - [EnvironmentDatabasesCurrentMetricResponseMemory](docs/EnvironmentDatabasesCurrentMetricResponseMemory.md)
 - [EnvironmentDatabasesCurrentMetricResponseStorage](docs/EnvironmentDatabasesCurrentMetricResponseStorage.md)
 - [EnvironmentDeploymentRuleEditRequest](docs/EnvironmentDeploymentRuleEditRequest.md)
 - [EnvironmentDeploymentRuleResponse](docs/EnvironmentDeploymentRuleResponse.md)
 - [EnvironmentEditRequest](docs/EnvironmentEditRequest.md)
 - [EnvironmentLogPaginatedResponseList](docs/EnvironmentLogPaginatedResponseList.md)
 - [EnvironmentLogResponse](docs/EnvironmentLogResponse.md)
 - [EnvironmentLogResponseList](docs/EnvironmentLogResponseList.md)
 - [EnvironmentLogResponseScope](docs/EnvironmentLogResponseScope.md)
 - [EnvironmentRequest](docs/EnvironmentRequest.md)
 - [EnvironmentResponse](docs/EnvironmentResponse.md)
 - [EnvironmentResponseList](docs/EnvironmentResponseList.md)
 - [EnvironmentRestartRequest](docs/EnvironmentRestartRequest.md)
 - [EnvironmentStatsResponse](docs/EnvironmentStatsResponse.md)
 - [EnvironmentStatsResponseList](docs/EnvironmentStatsResponseList.md)
 - [EnvironmentTotalNumber](docs/EnvironmentTotalNumber.md)
 - [EnvironmentVariableEditRequest](docs/EnvironmentVariableEditRequest.md)
 - [EnvironmentVariableRequest](docs/EnvironmentVariableRequest.md)
 - [EnvironmentVariableResponse](docs/EnvironmentVariableResponse.md)
 - [EnvironmentVariableResponseList](docs/EnvironmentVariableResponseList.md)
 - [EventPaginatedResponseList](docs/EventPaginatedResponseList.md)
 - [EventResponse](docs/EventResponse.md)
 - [EventResponseList](docs/EventResponseList.md)
 - [GenericObjectCurrentCostResponse](docs/GenericObjectCurrentCostResponse.md)
 - [GitAuthProviderResponse](docs/GitAuthProviderResponse.md)
 - [GitAuthProviderResponseList](docs/GitAuthProviderResponseList.md)
 - [GitRepositoryBranchResponse](docs/GitRepositoryBranchResponse.md)
 - [GitRepositoryBranchResponseList](docs/GitRepositoryBranchResponseList.md)
 - [GitRepositoryResponse](docs/GitRepositoryResponse.md)
 - [GitRepositoryResponseList](docs/GitRepositoryResponseList.md)
 - [Healthcheck](docs/Healthcheck.md)
 - [InlineObject](docs/InlineObject.md)
 - [InstanceResponse](docs/InstanceResponse.md)
 - [InstanceResponseList](docs/InstanceResponseList.md)
 - [InviteMemberRequest](docs/InviteMemberRequest.md)
 - [InviteMemberResponse](docs/InviteMemberResponse.md)
 - [InviteMemberResponseList](docs/InviteMemberResponseList.md)
 - [InvoiceResponse](docs/InvoiceResponse.md)
 - [InvoiceResponseList](docs/InvoiceResponseList.md)
 - [Key](docs/Key.md)
 - [LinkResponse](docs/LinkResponse.md)
 - [LinkResponseList](docs/LinkResponseList.md)
 - [LogPaginatedResponseList](docs/LogPaginatedResponseList.md)
 - [LogResponse](docs/LogResponse.md)
 - [LogResponseList](docs/LogResponseList.md)
 - [LogicalDatabaseRequest](docs/LogicalDatabaseRequest.md)
 - [LogicalDatabaseResponse](docs/LogicalDatabaseResponse.md)
 - [LogicalDatabaseResponseList](docs/LogicalDatabaseResponseList.md)
 - [MemberResponse](docs/MemberResponse.md)
 - [MemberResponseList](docs/MemberResponseList.md)
 - [MetricCPUDatapointResponse](docs/MetricCPUDatapointResponse.md)
 - [MetricCPUDatapointResponseList](docs/MetricCPUDatapointResponseList.md)
 - [MetricCPUResponse](docs/MetricCPUResponse.md)
 - [MetricCPUResponseList](docs/MetricCPUResponseList.md)
 - [MetricGenericDatapointResponse](docs/MetricGenericDatapointResponse.md)
 - [MetricGenericResponse](docs/MetricGenericResponse.md)
 - [MetricGenericResponseList](docs/MetricGenericResponseList.md)
 - [MetricMemoryDatapointResponse](docs/MetricMemoryDatapointResponse.md)
 - [MetricMemoryDatapointResponseList](docs/MetricMemoryDatapointResponseList.md)
 - [MetricMemoryResponse](docs/MetricMemoryResponse.md)
 - [MetricMemoryResponseList](docs/MetricMemoryResponseList.md)
 - [MetricRestartResponse](docs/MetricRestartResponse.md)
 - [MetricRestartResponseResults](docs/MetricRestartResponseResults.md)
 - [MetricStorageDatapointResponse](docs/MetricStorageDatapointResponse.md)
 - [MetricStorageDatapointResponseList](docs/MetricStorageDatapointResponseList.md)
 - [MetricStorageResponse](docs/MetricStorageResponse.md)
 - [MetricStorageResponseList](docs/MetricStorageResponseList.md)
 - [Name](docs/Name.md)
 - [OrganizationCreditCodeRequest](docs/OrganizationCreditCodeRequest.md)
 - [OrganizationCurrentCostResponse](docs/OrganizationCurrentCostResponse.md)
 - [OrganizationEditRequest](docs/OrganizationEditRequest.md)
 - [OrganizationRequest](docs/OrganizationRequest.md)
 - [OrganizationResponse](docs/OrganizationResponse.md)
 - [OrganizationResponseList](docs/OrganizationResponseList.md)
 - [OverriddenSecret](docs/OverriddenSecret.md)
 - [PaginationDataResponse](docs/PaginationDataResponse.md)
 - [PaidUsage](docs/PaidUsage.md)
 - [PaidUsageResponse](docs/PaidUsageResponse.md)
 - [ProjectCurrentCostResponse](docs/ProjectCurrentCostResponse.md)
 - [ProjectCurrentCostResponseList](docs/ProjectCurrentCostResponseList.md)
 - [ProjectDeploymentRuleRequest](docs/ProjectDeploymentRuleRequest.md)
 - [ProjectDeploymentRuleResponse](docs/ProjectDeploymentRuleResponse.md)
 - [ProjectDeploymentRuleResponseList](docs/ProjectDeploymentRuleResponseList.md)
 - [ProjectProjectIdDeploymentRuleOrderProjectDeploymentRuleIdsInOrder](docs/ProjectProjectIdDeploymentRuleOrderProjectDeploymentRuleIdsInOrder.md)
 - [ProjectRequest](docs/ProjectRequest.md)
 - [ProjectResponse](docs/ProjectResponse.md)
 - [ProjectResponseList](docs/ProjectResponseList.md)
 - [ProjectStatsResponse](docs/ProjectStatsResponse.md)
 - [ProjectStatsResponseList](docs/ProjectStatsResponseList.md)
 - [ReferenceObject](docs/ReferenceObject.md)
 - [ReferenceObjectStatusResponse](docs/ReferenceObjectStatusResponse.md)
 - [ReferenceObjectStatusResponseList](docs/ReferenceObjectStatusResponseList.md)
 - [ReferralResponse](docs/ReferralResponse.md)
 - [RemainingCredits](docs/RemainingCredits.md)
 - [RewardClaimResponse](docs/RewardClaimResponse.md)
 - [ScalewayCredentialsRequest](docs/ScalewayCredentialsRequest.md)
 - [SecretEditRequest](docs/SecretEditRequest.md)
 - [SecretRequest](docs/SecretRequest.md)
 - [SecretResponse](docs/SecretResponse.md)
 - [SecretResponseList](docs/SecretResponseList.md)
 - [ServiceResponse](docs/ServiceResponse.md)
 - [ServiceResponseList](docs/ServiceResponseList.md)
 - [ServiceTotalNumber](docs/ServiceTotalNumber.md)
 - [Status](docs/Status.md)
 - [StorageDiskResponse](docs/StorageDiskResponse.md)
 - [StorageDiskResponseList](docs/StorageDiskResponseList.md)
 - [TagRequest](docs/TagRequest.md)
 - [TagResponse](docs/TagResponse.md)
 - [TagResponseList](docs/TagResponseList.md)
 - [TransferOwnershipRequest](docs/TransferOwnershipRequest.md)
 - [UnexpectedError](docs/UnexpectedError.md)
 - [UserResponse](docs/UserResponse.md)
 - [UserResponseList](docs/UserResponseList.md)
 - [Value](docs/Value.md)
 - [VariableImportRequest](docs/VariableImportRequest.md)
 - [VariableImportRequestVars](docs/VariableImportRequestVars.md)
 - [VariableImportResponse](docs/VariableImportResponse.md)
 - [VariableImportResponseSuccessfulImportedVariables](docs/VariableImportResponseSuccessfulImportedVariables.md)
 - [VersionResponse](docs/VersionResponse.md)
 - [VersionResponseList](docs/VersionResponseList.md)


## Documentation For Authorization


## bearerAuth

- **Type**: Bearer authentication (JWT)


## Author

support+api+documentation@qovery.com


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in qovery.apis and qovery.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from qovery.api.default_api import DefaultApi`
- `from qovery.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import qovery
from qovery.apis import *
from qovery.models import *
```

