from .imports import internally_imported
from .stack_trace_string import resolve as resolve_stack_trace_string

with internally_imported():
    import os
    from builtins import type as builtins_type
    import logging


logger = logging.getLogger(__name__)


def report(error, type: str = "INTERNAL"):
    if os.environ.get("SLS_CRASH_ON_SDK_ERROR", None):
        if isinstance(error, BaseException):
            raise error
        else:
            raise Exception(error)

    error_data = {
        "source": "serverlessSdk",
        "type": f"ERROR_TYPE_CAUGHT_SDK_{type}",
        "name": builtins_type(error).__name__,
        "message": str(error),
        "stack": resolve_stack_trace_string(error),
    }

    if type == "INTERNAL":
        error_data["description"] = (
            "Internal Serverless SDK Error. "
            + "Please report at https://github.com/serverless/console/issue"
        )

    if hasattr(error, "code"):
        error_data["code"] = error.code

    logger.error(error_data)

    try:
        # Require on spot to avoid otherwise difficult to mitigate circular dependency
        from .error_captured_event import create as create_error_captured_event

        create_error_captured_event(
            error_data["message"],
            name=error_data["name"],
            stack=error_data["stack"],
            type="handledSdkUser" if type == "USER" else "handledSdkInternal",
            origin="pythonLogging",
        )
    except:  # noqa: E722
        # ignore
        pass
